/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSConstants;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSService;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class QingAnalysisDSListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"QingAnalysisDsListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        this.cacheModelId(modelId);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"model"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void cacheModelId(Long modelId) {
        this.getPageCache().put("model", String.valueOf(modelId));
        this.getModel().setValue("model", (Object)modelId);
    }

    private void refreshListData() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.setFilter(this.getListQFilter());
        billList.refresh();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("model".equals(propName)) {
            PluginUtils.setModelFilter(beforeF7SelectEvent, this.getView());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)beforeF7SelectEvent);
        }
    }

    private QFilter getListQFilter() {
        return new QFilter("model", "=", (Object)this.getModelId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
            if (IDUtils.isNull((Long)modelId)) {
                this.getModel().setValue("model", (Object)this.getPageCache().get("model"));
            } else {
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get("model")))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.cacheModelId(modelId);
                this.refreshListData();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_new": {
                this.openEditPage(null);
                break;
            }
            case "btn_copy": {
                this.copyData();
                break;
            }
            case "btn_publish": {
                this.publish();
                break;
            }
            case "btn_pub_cancel": {
                this.cancelPublish();
                break;
            }
            case "btn_del": {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"QingAnalysisDsListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                DynamicObjectCollection dynamicObjects = QingAnalysisDSService.getInstance().queryStatus(ids);
                if (dynamicObjects.stream().anyMatch(dynamicObject -> QingAnalysisDSConstants.Status.RELEASE.getValue().equals(dynamicObject.getString("status")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u72b6\u6001\u7684\u6570\u636e\u6e90\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QingAnalysisDsListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6570\u636e\uff1f", (String)"QingAnalysisDsListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmDel", (IFormPlugin)this));
                break;
            }
            case "btn_refresh": {
                this.refreshListData();
                break;
            }
            case "btn_qing": {
                this.openQingAnalysis();
                break;
            }
            case "btn_var": {
                this.openVariableConfigPage();
                break;
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        Object pkId = ((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        this.openEditPage(pkId.toString());
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDel".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.delData();
        }
    }

    private void openEditPage(String id) {
        String model = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)model)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"QingAnalysisDsListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_qinganalysisds");
        showParameter.setCustomParam("model", (Object)model);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        if (StringUtils.isNotEmpty((String)id)) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u6570\u636e\u6e90\u4fee\u6539", (String)"QingAnalysisDsListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u6570\u636e\u6e90\u65b0\u589e", (String)"QingAnalysisDsListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openQingAnalysis() {
        String model = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)model)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"QingAnalysisDsListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"QingAnalysisDsListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        DynamicObjectCollection dyObjects = QingAnalysisDSService.getInstance().queryStatus(Collections.singletonList(id));
        if (CollectionUtils.isEmpty((Collection)dyObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"QingAnalysisDsListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dyObject = (DynamicObject)dyObjects.get(0);
        String status = dyObject.getString("status");
        if (!QingAnalysisDSConstants.Status.RELEASE.getValue().equals(status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u53d1\u5e03\u6570\u636e\u6e90\u3002", (String)"QingAnalysisDsListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QingAnalysisDSService.getInstance().publishCheck(id.longValue(), this.getView());
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("eb_qinganalysisds_ap");
        showParameter.setCustomParam("model", (Object)model);
        showParameter.setCustomParam("id", (Object)id);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8f7b\u5206\u6790", (String)"QingAnalysisDsListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openVariableConfigPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_qingds_varconf");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        this.getView().showForm(showParameter);
    }

    private void delData() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QingAnalysisDSService.getInstance().delete(ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"QingAnalysisDsListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "QingAnalysisDsListPlugin_20", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "QingAnalysisDsListPlugin_6", "epm-eb-formplugin"));
        this.refreshListData();
    }

    private void copyData() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"QingAnalysisDsListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        long newId = QingAnalysisDSService.getInstance().copy(id);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"QingAnalysisDsListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("cppy", new MultiLangEnumBridge("\u590d\u5236", "QingAnalysisDsListPlugin_21", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u6210\u529f\u3002", "QingAnalysisDsListPlugin_7", "epm-eb-formplugin"));
        this.refreshListData();
        this.openEditPage(String.valueOf(newId));
    }

    private void publish() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"QingAnalysisDsListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List ids = selectedRows.stream().map(row -> {
            Long id = IDUtils.toLong((Object)row.getPrimaryKeyValue().toString());
            DsDataModel dataModel = QingAnalysisDSService.getInstance().publishCheck(id.longValue(), this.getView());
            return dataModel == null ? null : id;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QingAnalysisDSService.getInstance().updateStatus(QingAnalysisDSConstants.Status.RELEASE, ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"QingAnalysisDsListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("publish", new MultiLangEnumBridge("\u53d1\u5e03", "QingAnalysisDsListPlugin_17", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d1\u5e03\u6210\u529f\u3002", "QingAnalysisDsListPlugin_10", "epm-eb-formplugin"));
        this.refreshListData();
    }

    private void cancelPublish() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"QingAnalysisDsListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        QingAnalysisDSService.getInstance().updateStatus(QingAnalysisDSConstants.Status.SAVE, ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f\u3002", (String)"QingAnalysisDsListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("cancelPublish", new MultiLangEnumBridge("\u53d6\u6d88\u53d1\u5e03", "QingAnalysisDsListPlugin_18", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d1\u5e03\u5df2\u53d6\u6d88\u3002", "QingAnalysisDsListPlugin_19", "epm-eb-formplugin"));
        this.refreshListData();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("addCloseCallback".equals(actionId)) {
            this.refreshListData();
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getListQFilter());
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)modelId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("model");
            if (value == null) {
                return 0L;
            }
            modelId = value.getString("id");
            this.getPageCache().put("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    @Override
    protected void addColumnKeysToHide4NewEb(Set<String> colsToHide) {
        super.addColumnKeysToHide4NewEb(colsToHide);
        colsToHide.add("bizmodel.name");
        colsToHide.add("dataset.name");
    }
}

