/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarModelService;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarService;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVar;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVarModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QingAnalysisDSVarConfigPlugin
extends AbstractBasePlugin
implements ClickListener {
    private static final String BTN_VAR_CONF = "variable";
    private static final String SELECT_VARIABLE_CLOSE_CALLBACK = "selectVariableCloseCallBack";
    private static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("model", params.get("model").toString());
        this.initEntry(IDUtils.toLong(params.get("id")));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_VAR_CONF, "btn_ok"});
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        return IDUtils.toLong((Object)modelId);
    }

    private void initEntry(Long qingDsId) {
        List dsVarList;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        List varIdList = null;
        if (IDUtils.isNotEmptyLong((Long)qingDsId).booleanValue() && CollectionUtils.isNotEmpty((Collection)(dsVarList = QingAnalysisDSVarService.getInstance().query(qingDsId.longValue())))) {
            varIdList = dsVarList.stream().map(QingAnalysisDSVar::getVariableId).collect(Collectors.toList());
        }
        long modelId = this.getModelId();
        List varConfList = CollectionUtils.isNotEmpty(varIdList) ? QingAnalysisDSVarModelService.getInstance().queryByVariable(modelId, varIdList) : QingAnalysisDSVarModelService.getInstance().queryByModel(modelId);
        if (CollectionUtils.isEmpty((Collection)varConfList)) {
            return;
        }
        QFilter qFilter = null;
        for (QingAnalysisDSVarModel var : varConfList) {
            if (qFilter == null) {
                qFilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)var.getVarNumber()).and("dimension", "=", (Object)var.getDimensionId());
                continue;
            }
            qFilter.or(new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)var.getVarNumber()).and("dimension", "=", (Object)var.getDimensionId()));
        }
        if (qFilter == null) {
            return;
        }
        DynamicObjectCollection varInfoList = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id, name, number, grouptype, dimension", (QFilter[])new QFilter[]{qFilter});
        if (varInfoList.isEmpty()) {
            return;
        }
        Map<Long, QingAnalysisDSVarModel> varConfMap = varConfList.stream().collect(Collectors.toMap(QingAnalysisDSVarModel::getVariableId, v -> v, (o1, o2) -> o2));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, varInfoList.size());
        for (int i = 0; i < varInfoList.size(); ++i) {
            DynamicObject dyObj = (DynamicObject)varInfoList.get(i);
            long dimensionId = dyObj.getLong("dimension");
            Dimension dimension = modelCache.getDimension(Long.valueOf(dimensionId));
            long varId = dyObj.getLong("id");
            QingAnalysisDSVarModel varConf = varConfMap.get(varId);
            if (varConf == null) continue;
            this.getModel().setValue("dataid", (Object)varConf.getId(), i);
            this.getModel().setValue("dimname", (Object)dimension.getName(), i);
            this.getModel().setValue("dimnumber", (Object)dimension.getNumber(), i);
            this.getModel().setValue("varname", (Object)dyObj.getString("name"), i);
            this.getModel().setValue("varnumber", (Object)dyObj.getString("number"), i);
            this.getModel().setValue("vartype", (Object)dyObj.getString("grouptype"), i);
            String varJson = varConf.getVariableJson();
            if (!StringUtils.isNotBlank((CharSequence)varJson)) continue;
            this.getModel().setValue("variablejson", (Object)varJson, i);
            List memberInfos = (List)SerializationUtils.fromJsonString((String)varJson, List.class);
            String name = memberInfos.stream().map(x -> x.get("name").toString()).collect(Collectors.joining(","));
            this.getModel().setValue(BTN_VAR_CONF, (Object)name, i);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        switch (key) {
            case "btn_ok": {
                this.saveConfig();
                break;
            }
            case "variable": {
                this.showMemberSelect();
            }
        }
    }

    private void showMemberSelect() {
        String dataset;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        String dimNumber = row.getString("dimnumber");
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        String type = row.getString("vartype");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if ("2".equals(type)) {
            f7Param.setCanSelectRoot(false);
            filters.add(new QFilter("level", "<=", (Object)2));
        }
        String variableJson = row.getString("variablejson");
        HashSet ids = new HashSet(16);
        HashSet viewIds = new HashSet(16);
        if (StringUtils.isNotEmpty((CharSequence)variableJson)) {
            ((List)JsonUtils.readValue((String)variableJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).forEach(map -> ids.add(Long.parseLong(map.get("id").toString())));
            ((List)JsonUtils.readValue((String)variableJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).forEach(map -> viewIds.add(IDUtils.toLong(map.get("view"))));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            f7Param.setSelectIds(ids);
        }
        if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            filters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        f7Param.addCustomCommFilter(filters);
        f7Param.setEnableView(true);
        String bizmodel = (String)this.getView().getFormShowParameter().getCustomParam("bizmodel");
        if (StringUtils.isNotEmpty((CharSequence)bizmodel)) {
            f7Param.setBusModelId(Long.valueOf(Long.parseLong(bizmodel)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(dataset = (String)this.getView().getFormShowParameter().getCustomParam("dataset")))) {
            f7Param.setDatasetId(Long.valueOf(Long.parseLong(dataset)));
        }
        f7Param.setLoadDefaultBusModel(StringUtils.isNotEmpty((CharSequence)dataset) || StringUtils.isNotEmpty((CharSequence)bizmodel));
        if (CollectionUtils.isNotEmpty(viewIds)) {
            f7Param.setViewId((Long)viewIds.iterator().next());
        } else if (StringUtils.isEmpty((CharSequence)dataset) && StringUtils.isEmpty((CharSequence)bizmodel)) {
            IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
            Long defaultViewIdOnDim = iModelCacheHelper.getDefaultViewIdOnDim(dimNumber);
            f7Param.setViewId(defaultViewIdOnDim);
        }
        f7Param.setCanSelectBudgetPeriodRoot(false);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, SELECT_VARIABLE_CLOSE_CALLBACK));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newVal;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (BTN_VAR_CONF.equals(key) && StringUtils.isBlank((CharSequence)(newVal = (String)e.getChangeSet()[0].getNewValue()))) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue("variablejson", (Object)"", rowIndex);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (SELECT_VARIABLE_CLOSE_CALLBACK.equals(actionId)) {
            this.setSelectVariable(evt);
        }
    }

    private void setSelectVariable(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
        if (selectedRows == null) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        ArrayList memberInfos = new ArrayList(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            HashMap<String, Object> memberInfoMap = new HashMap<String, Object>(16);
            memberInfoMap.put("id", selectedRow.getPrimaryKeyValue());
            memberInfoMap.put("name", selectedRow.getName());
            memberInfoMap.put("number", selectedRow.getNumber());
            memberInfoMap.put("view", selectedRow.getDataMap().get("viewid"));
            memberInfos.add(memberInfoMap);
        }
        if (!memberInfos.isEmpty()) {
            String name = memberInfos.stream().map(x -> x.get("name").toString()).collect(Collectors.joining(","));
            this.getModel().setValue(BTN_VAR_CONF, (Object)name, rowIndex);
            String memberJson = SerializationUtils.toJsonString(memberInfos);
            this.getModel().setValue("variablejson", (Object)memberJson, rowIndex);
        }
    }

    private void saveConfig() {
        DynamicObjectCollection varConfList = this.getModel().getEntryEntity(ENTRY_ENTITY);
        varConfList.forEach(e -> {
            if (StringUtils.isEmpty((CharSequence)e.getString(BTN_VAR_CONF))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u91cf\u503c\u3002", (String)"QingAnalysisDSVarConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)varConfList)) {
            QingAnalysisDSVarModelService.getInstance().update(this.getModelId().longValue(), varConfList);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ControlProcessAddPlugin_16", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ControlProcessAddPlugin_15", "epm-eb-formplugin");
            this.writeLog(null, "save", opName, opDesc, null);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QingAnalysisDsEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
        this.getView().close();
    }
}

