/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis.constant;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;

public interface QingAnalysisDSPluginConstants {
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_NEW = "btn_new";
    public static final String BTN_DEL = "btn_del";
    public static final String BTN_COPY = "btn_copy";
    public static final String BTN_QING = "btn_qing";
    public static final String BTN_VAR = "btn_var";
    public static final String BTN_PREVIEW = "btn_preview";
    public static final String BTN_REFRESH = "btn_refresh";
    public static final String BTN_PUBLISH = "btn_publish";
    public static final String BTN_PUB_CANCEL = "btn_pub_cancel";
    public static final String BTN_ADD_LINE = "btn_addline";
    public static final String BTN_DEL_LINE = "btn_delline";
    public static final String BTN_IMPORT = "btn_import";
    public static final String BTN_EXPORT = "btn_export";
    public static final String BTN_DOWN_TEMP = "btn_downtemp";
    public static final String BTN_SURE = "btn_ok";
    public static final String BTN_CANCEL = "btn_cancel";
    public static final String VALUE_FIELD_CONFIG = "btn_valueconfig";
    public static final String FIELD_TYPE_CONFIG = "btn_bpftype";
    public static final String KEY_ATTACHMENT_PANEL = "attachment";
    public static final String IMPORT_TYPE = "importtype";
    public static final String IMPORT_ADD = "1";
    public static final String IMPORT_COVER = "2";
    public static final String CONFIG_KEY = "config_key";
    public static final String CONFIG_NAME = "config_name";
    public static final String CONFIG_DATA = "config_data";
    public static final String PK_ID = "id";
    public static final String MODEL = "model";
    public static final String BIZ_MODEL = "bizmodel";
    public static final String DATASET = "dataset";
    public static final String DS_NAME = "name";
    public static final String DS_STATUS = "status";
    public static final String DS_FEMPTY = "filterempty";
    public static final String BP_FTYPE = "bpfieldtype";
    public static final String ALL_DIM = "all_dim";
    public static final String DATA_MODEL = "data_model";
    public static final String POSTFIX_SELECT = "_select";
    public static final String POSTFIX_VALUE = "_t";
    public static final String PREFIX_CUSTOM_ITEM = "cus_item_";
    public static final String DIMENSION_VIEW = "dimension_view";
    public static final String POOL_HIDE = "hidepool";
    public static final String POOL_TEXT = "textpool";
    public static final String POOL_VALUE = "valuepool";
    public static final String POOL_VALUE_CONF = "valueconfigpool";
    public static final String POOL_VALUE_FIELD = "valuePoolField";
    public static final String IMPORT_FILE = "importFile";
    public static final String PREVIEW_SPREAD = "previewspread";
    public static final String PREVIEW_SPREAD_PANEL = "spreadpanel";
    public static final int PREVIEW_MAX_ROW = 1000;
    public static final String BILL_LIST = "billlistap";
    public static final String ENTRY_CONFIG = "configentry";
    public static final String TOOLBAR = "toolbarap";
    public static final String CLOSE_CALLBACK_ADD = "addCloseCallback";
    public static final String CLOSE_CALLBACK_CONFIG = "configCloseCallback";
    public static final String CLOSE_CALLBACK_FTYPE = "fieldTypeCloseCallback";
    public static final String CLOSE_CALLBACK_IMPORT = "importCloseCallback";
    public static final String EXPORT_TEMP_PATH = "qinganalysis/valueFieldConfig.xlsx";
    public static final int MAX_TEXT_FIELDS = 5;
    public static final List<String> ENABLE_TEXT_FIELDS = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.InternalCompany.getNumber()});
    public static final List<String> DEFAULT_TEXT_FIELDS = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber()});
    public static final List<String> DEFAULT_VALUE_FIELDS = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.Metric.getNumber()});
    public static final Map<String, String> DEFAULT_MEMBER = ImmutableMap.of((Object)SysDimensionEnum.InternalCompany.getNumber(), (Object)"ICNone", (Object)SysDimensionEnum.Currency.getNumber(), (Object)"CNY", (Object)SysDimensionEnum.AuditTrail.getNumber(), (Object)"ATTotal");

    public static boolean isCustomItem(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return controlKey.startsWith(PREFIX_CUSTOM_ITEM) && !controlKey.endsWith("_id");
    }

    public static boolean isCustomItemHideField(String panel) {
        return POOL_HIDE.equals(panel);
    }

    public static boolean isCustomItemValueField(String panel) {
        return POOL_VALUE.equals(panel);
    }

    public static boolean isCustomItemTextField(String panel) {
        return POOL_TEXT.equals(panel);
    }

    public static boolean isCustomItemConfigField(String key) {
        return QingAnalysisDSPluginConstants.isCustomItem(key) && key.endsWith(POSTFIX_VALUE);
    }

    public static boolean canMove2TextPanel(String dimNumber) {
        if (ENABLE_TEXT_FIELDS.contains(dimNumber)) {
            return true;
        }
        return QingAnalysisDSPluginConstants.isUserDefineDimension(dimNumber);
    }

    public static boolean isUserDefineDimension(String dimNumber) {
        return "epm_userdefinedmembertree".equals(SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
    }

    public static String createDtoKey() {
        return PREFIX_CUSTOM_ITEM + GlobalIdUtil.genGlobalLongId() + POSTFIX_VALUE;
    }
}

