/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis.dataplugin;

import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingMeta;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSQuery;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSService;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDS;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.business.qinganalysis.processor.DataProviderProcessor;
import kd.epm.eb.business.qinganalysis.processor.IQingAnalysisDSProcessor;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QingAnalysisDSDataProvider
extends AbstractFormPlugin
implements IQingDataProvider {
    private static final Log log = LogFactory.getLog(QingAnalysisDSDataProvider.class);
    private static final String LOG_TAG = "QingDSProvider";

    public QingMeta getMeta(String pageId) {
        this.setPageSize();
        QingAnalysisDS qingAnalysisDS = this.getQingAnalysisDS();
        String dsName = qingAnalysisDS.getName().toString();
        return new DataProviderProcessor(qingAnalysisDS).buildQingMeta(dsName);
    }

    private IModelCacheHelper getModelCache() {
        Long modelId = this.getModelId();
        return ModelCacheContext.getOrCreate((Long)modelId);
    }

    private Long getModelId() {
        String modelIdStr = this.getPageCache().get("model");
        if (StringUtils.isBlank((CharSequence)modelIdStr)) {
            modelIdStr = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.getPageCache().put("model", modelIdStr);
        }
        return IDUtils.toLong((Object)modelIdStr);
    }

    private QingAnalysisDS getQingAnalysisDS() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long id = IDUtils.toLong((Object)formShowParameter.getCustomParam("id").toString());
        return QingAnalysisDSService.getInstance().load(id);
    }

    public QingData getData(String pageId, int startRow, int limit) {
        int dataCount;
        Stopwatch stopwatch = Stopwatch.createStarted();
        QingAnalysisDS qingAnalysisDS = this.getQingAnalysisDS();
        DsDataModel dataModel = qingAnalysisDS.getDataModel();
        IModelCacheHelper modelCache = this.getModelCache();
        long dataSetId = qingAnalysisDS.getDataset();
        DataProviderProcessor processor = new DataProviderProcessor(qingAnalysisDS);
        QingAnalysisDSQuery qingAnalysisDSQuery = new QingAnalysisDSQuery(dataModel, modelCache, dataSetId, (IQingAnalysisDSProcessor)processor, startRow, limit);
        long totalCount = qingAnalysisDSQuery.getTotalCount();
        log.info("{} getData pageId:{} startRow:{} limit:{} totalCount:{}", new Object[]{LOG_TAG, pageId, startRow, limit, totalCount});
        if ((long)startRow > totalCount) {
            this.resetPageSize();
            return null;
        }
        qingAnalysisDSQuery.query();
        QingData qingData = processor.getQingData();
        if (CollectionUtils.isEmpty((Collection)qingData.getRows())) {
            this.resetPageSize();
            dataCount = 0;
        } else {
            dataCount = qingData.getRows().size();
        }
        log.info("{} getData complete dataCount:{} totalCount:{} filterEmpty:{} cost:{}s", new Object[]{LOG_TAG, dataCount, totalCount, qingAnalysisDS.getFilterEmpty(), stopwatch.elapsed(TimeUnit.SECONDS)});
        return qingData;
    }

    private void setPageSize() {
        String qingOriginPageSize = System.getProperty("qing.form.pagesize");
        this.getPageCache().put("qingOriginPageSize", qingOriginPageSize);
        System.setProperty("qing.form.pagesize", "10000");
    }

    private void resetPageSize() {
        String qingOriginPageSize = this.getPageCache().get("qingOriginPageSize");
        if (StringUtils.isBlank((CharSequence)qingOriginPageSize)) {
            System.setProperty("qing.form.pagesize", "");
        } else {
            System.setProperty("qing.form.pagesize", qingOriginPageSize);
        }
    }
}

