/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.pageinteraction.model.Area;
import kd.epm.eb.common.pageinteraction.model.BaseEditElement;
import kd.epm.eb.common.pageinteraction.model.Element;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.pageinteraction.model.TextEditElement;
import kd.epm.eb.common.utils.DataEntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializerUtil;
import kd.epm.eb.spread.utils.ReportDimFilterUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportPageDimFloatFormPlugin
extends AbstractFormPlugin
implements SubPage,
BeforeF7SelectListener,
DynamicPage {
    private EntityMetadata entityMeta = null;

    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap fieldMap = new HashMap();
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        itemMap.put("fontClass", "kdfont kdfont-guolv_mian");
        itemMap.put("showEditButton", true);
        fieldMap.put("item", itemMap);
        for (Map.Entry<String, String> entry : this.getFilterDimMap().entrySet()) {
            this.getView().updateControlMetadata(entry.getKey(), fieldMap);
        }
    }

    private void bindCtrlMapping() {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        if (this.entityMeta == null) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            this.entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        props.clear();
        Map<String, String> dimF7KeyMapping = this.getDimF7KeyMapping();
        dimF7KeyMapping.forEach((f7Key, dimNumber) -> {
            if (!props.containsKey(f7Key)) {
                DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("pagedimpanel")), (MainEntityType)mainEntityType, (String)f7Key, (String)SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber), (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        });
        Map<String, String> filterDimMap = this.getFilterDimMap();
        filterDimMap.forEach((filterKey, dimnumber) -> {
            if (!props.containsKey(filterKey)) {
                TextProp fieldprop = new TextProp();
                fieldprop.setName(filterKey);
                Container pagedimpanel = (Container)this.getControl("pagedimpanel");
                mainEntityType.addProperty((DynamicProperty)fieldprop);
                FieldAp field = new FieldAp();
                field.setName(new LocaleString(filterKey));
                field.setKey(filterKey);
                TextField textFiled = new TextField();
                textFiled.setKey(filterKey);
                textFiled.setEntityMetadata(this.entityMeta);
                this.entityMeta.getItems().add(textFiled);
                field.setField((Field)textFiled);
                FieldEdit control = field.buildRuntimeControl();
                control.setModel(this.getModel());
                control.setView(this.getView());
                pagedimpanel.getItems().add(control);
                DataEntityUtils.addTextFieldToMainEntity((Container)pagedimpanel, (MainEntityType)mainEntityType, (EntityMetadata)this.entityMeta, (String)filterKey, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Object customFormParam = this.getCustomFormParam("filterMemberCache");
        if (customFormParam != null) {
            this.getPageCache().put(this.getCustomFormParam("processId") + "filterMemberCache", customFormParam.toString());
        }
        this.loadPageData();
        this.getPageCache().put("processId", this.getCustomFormParam("processId").toString());
    }

    private void loadPageData() {
        Map<String, String> dimF7KeyMapping = this.getDimF7KeyMapping();
        Set<String> needLockDimF7Keys = this.getNeedLockDimF7Keys();
        Map<String, String> filterDimMap = this.getFilterDimMap();
        this.loadPageDimF7Control(dimF7KeyMapping, needLockDimF7Keys, filterDimMap);
        this.loadPageDimF7Data(dimF7KeyMapping, needLockDimF7Keys);
        this.loadFilterMemberData();
    }

    private void loadFilterMemberData() {
        Map<String, List<MemberCondition>> filterMemberMap = this.getFilterMemberMap();
        if (filterMemberMap != null && filterMemberMap.size() > 0) {
            for (Map.Entry<String, List<MemberCondition>> entry : filterMemberMap.entrySet()) {
                String filterKey;
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue()) || !StringUtils.isNotEmpty((String)(filterKey = this.getFilterKey(entry.getKey())))) continue;
                this.getModel().setValue(filterKey, (Object)this.buildFilterMemShowname(entry.getValue()));
            }
        }
        this.getView().updateView();
    }

    private String getFilterKey(String dimNumber) {
        Map<String, String> filterDimMap = this.getFilterDimMap();
        String filterKey = null;
        for (Map.Entry<String, String> entry : filterDimMap.entrySet()) {
            if (!dimNumber.equals(entry.getValue())) continue;
            filterKey = entry.getKey();
            break;
        }
        return filterKey;
    }

    private void loadPageDimF7Data(Map<String, String> dimF7KeyMapping, Set<String> needLockDimF7Keys) {
        Map<String, Long> pageDimValues = this.getPageDimValues();
        for (Map.Entry<String, String> entry : dimF7KeyMapping.entrySet()) {
            String f7Key = entry.getKey();
            String dimNumber = entry.getValue();
            this.getModel().setValue(f7Key, (Object)pageDimValues.get(dimNumber));
            if (!needLockDimF7Keys.contains(f7Key) && !"DataType".equals(dimNumber) && !"Version".equals(dimNumber)) continue;
            this.getView().setEnable(Boolean.valueOf(false), new String[]{f7Key});
        }
        this.getView().updateView();
    }

    private void loadPageDimF7Control(Map<String, String> dimF7KeyMapping, Set<String> needLockDimF7Keys, Map<String, String> filterDimMap) {
        LinkedList<String> orderDimF7Keys = new LinkedList<String>();
        int canSelectIndex = 0;
        for (Map.Entry<String, String> entry : dimF7KeyMapping.entrySet()) {
            if (needLockDimF7Keys.contains(entry.getKey())) {
                orderDimF7Keys.add(entry.getKey());
                continue;
            }
            ++canSelectIndex;
            orderDimF7Keys.add(0, entry.getKey());
        }
        for (Map.Entry<String, String> entry : filterDimMap.entrySet()) {
            orderDimF7Keys.add(canSelectIndex++, entry.getKey());
        }
        Page page = new Page();
        Area area = new Area("pagedimpanel");
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        for (String controlKey : orderDimF7Keys) {
            String dimName;
            Dimension dimension;
            String dimNumber;
            if (controlKey.startsWith("ebf7_")) {
                dimNumber = dimF7KeyMapping.get(controlKey);
                dimension = iModelCacheHelper.getDimension(dimNumber);
                dimName = dimension != null ? dimension.getName() : "name";
                BaseEditElement f7 = new BaseEditElement(dimName, controlKey, SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
                f7.setDisplayProp("name");
                f7.setHeight(new LocaleString("45px"));
                f7.setStyle(this.getStyle());
                f7.setWidth(new LocaleString("220px"));
                f7.setFontSize(12);
                f7.setFieldTextAlign("left");
                f7.setLabelDirection("v");
                area.addElement((Element)f7);
                continue;
            }
            if (!controlKey.startsWith("filter_")) continue;
            dimNumber = filterDimMap.get(controlKey);
            dimension = iModelCacheHelper.getDimension(dimNumber);
            dimName = dimension != null ? dimension.getName() : "name";
            TextEditElement textEditElement = new TextEditElement(dimName, controlKey, SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
            textEditElement.setHeight(new LocaleString("45px"));
            textEditElement.setStyle(this.getStyle());
            textEditElement.setEditStyle(1);
            textEditElement.setFieldStyle(3);
            textEditElement.setWidth(new LocaleString("220px"));
            textEditElement.setFontSize(12);
            textEditElement.setFieldTextAlign("left");
            textEditElement.setLabelDirection("v");
            area.addElement((Element)textEditElement);
        }
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        MemberF7Parameter f7Param;
        String dimNumber;
        String key;
        block16: {
            IModelCacheHelper modelCacheHelper;
            ITemplateModel templateModel;
            block15: {
                Long viewId;
                String curOrgNum;
                block17: {
                    key = e.getProperty().getName();
                    dimNumber = this.getDimF7KeyMapping().get(key);
                    if (dimNumber == null) {
                        e.setCancel(true);
                        return;
                    }
                    templateModel = this.getTemplateModel();
                    BgTemplate templateBaseInfo = templateModel.getTemplateBaseInfo();
                    modelCacheHelper = this.getIModelCacheHelper();
                    Long modelId = this.getModelId();
                    f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
                    f7Param.setViewId((Long)templateModel.getDimemsionViews().get(dimNumber));
                    f7Param.setBusModelId(templateBaseInfo.getBizModel());
                    f7Param.setDatasetId(templateBaseInfo.getDatasetID());
                    if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) break block15;
                    curOrgNum = this.getCurrentEntityNumber();
                    if (!StringUtils.isNotEmpty((String)curOrgNum)) break block16;
                    IFormView parentView = null;
                    if (this.getView().getParentView() != null) {
                        parentView = this.getView().getParentView().getParentView();
                    }
                    viewId = (Long)templateModel.getDimemsionViews().get(dimNumber);
                    if (parentView == null || !BudgetFormHelper.isBudgetForm((IFormView)parentView)) break block17;
                    String orgViewIdCache = parentView.getPageCache().get("orgViewIdCache");
                    if (StringUtils.isNotEmpty((String)orgViewIdCache)) {
                        viewId = IDUtils.toLong((Object)orgViewIdCache);
                        f7Param.setViewId(viewId);
                    }
                    HashSet<Object> orgNumbers = new HashSet<Object>(16);
                    String orgIdCache = parentView.getPageCache().get("orgIdsCache");
                    if (StringUtils.isNotEmpty((String)orgIdCache)) {
                        List orgIds = (List)SerializationUtils.deSerializeFromBase64((String)orgIdCache);
                        for (Long orgId : orgIds) {
                            Member orgMember;
                            if (BudgetFormHelper.isEntityPageDim((ITemplateModel)templateModel)) {
                                orgMember = modelCacheHelper.getMember(dimNumber, viewId, orgId);
                                List memberList = modelCacheHelper.getMember(dimNumber, viewId, orgMember.getNumber(), kd.epm.eb.common.enums.RangeEnum.ALL.getIndex());
                                Set memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                                orgNumbers.addAll(memberNumbers);
                                continue;
                            }
                            orgMember = modelCacheHelper.getMember(dimNumber, viewId, orgId);
                            String orgNumber = orgMember.getNumber();
                            orgNumbers.add(orgNumber);
                        }
                    }
                    QFilter qFilter = new QFilter("number", "in", orgNumbers);
                    f7Param.addCustomFilter(qFilter);
                    break block16;
                }
                Member _dimMember = modelCacheHelper.getMember(dimNumber, viewId, curOrgNum);
                if (_dimMember == null) break block16;
                if (_dimMember.getId() != null) {
                    f7Param.addSelectRange(_dimMember.getId(), kd.epm.eb.common.enums.RangeEnum.ALL.getIndex());
                } else {
                    f7Param.addSelectRange(_dimMember.getNumber(), kd.epm.eb.common.enums.RangeEnum.ALL.getIndex(), modelCacheHelper);
                }
                break block16;
            }
            List pageDims = templateModel.getPagemembentry();
            if (pageDims != null) {
                IPageDimensionEntry pageDim = null;
                for (IPageDimensionEntry entry : pageDims) {
                    if (!dimNumber.equals(entry.getDimension().getNumber())) continue;
                    pageDim = entry;
                    break;
                }
                if (pageDim != null) {
                    for (IDimensionMember _member : pageDim.getMembers()) {
                        if (_member.getId() != null) {
                            f7Param.addSelectRange(_member.getId(), _member.getScope());
                            continue;
                        }
                        f7Param.addSelectRange(_member.getNumber(), _member.getScope(), modelCacheHelper);
                    }
                }
            }
        }
        List<String> relationMembers = this.getRelationMembers(dimNumber);
        if (relationMembers != null) {
            f7Param.addCustomFilter(new QFilter("number", "in", relationMembers));
        }
        if ("ebf7_audittrail".equals(key)) {
            f7Param.setHideDecompose(false);
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String f7Key = e.getProperty().getName();
        Object ob = e.getChangeSet()[0].getNewValue();
        if (f7Key.startsWith("filter_") && (ob == null || "".equals(ob))) {
            Map<String, String> filterDimMap = this.getFilterDimMap();
            String key = filterDimMap.get(f7Key);
            this.getModel().setValue(f7Key, null);
            this.buildFilterMemShowname(key, new DynamicObjectCollection());
            CommandParam commandParam = new CommandParam(this.getView().getEntityId(), this.getView().getParentView().getEntityId(), "filterValueChange", new Object[]{key, new DynamicObjectCollection()});
            this.sendMsg(this.getView(), commandParam);
        }
        if (ob instanceof DynamicObject) {
            CommandParam commandParam = new CommandParam(this.getView().getEntityId(), this.getView().getParentView().getEntityId(), "f7ChangeValue", new Object[]{f7Key, ob});
            this.sendMsg(this.getView(), commandParam);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException var3) {
            throw new RuntimeException(var3);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith("ebf7_")) {
            BasedataEdit edit = new BasedataEdit();
            edit.setKey(e.getKey());
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            e.setControl((Control)edit);
        } else if (key.startsWith("filter_")) {
            Map<String, String> filterDimMap = this.getFilterDimMap();
            String dimNumber = filterDimMap.get(key);
            if (dimNumber == null) {
                return;
            }
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setView(this.getView());
            textEdit.setModel(this.getModel());
            textEdit.setEntryKey(SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
            textEdit.addClickListener((ClickListener)this);
            e.setControl((Control)textEdit);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (key.startsWith("filter_")) {
            Map<String, String> filterDimMap = this.getFilterDimMap();
            String dimNumber = filterDimMap.get(key);
            if (StringUtils.isEmpty((String)dimNumber)) {
                return;
            }
            ITemplateModel templateModel = this.getTemplateModel();
            BgTemplate templateBaseInfo = templateModel.getTemplateBaseInfo();
            Long modelId = this.getModelId();
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)DynamicObject.class.getName());
            f8Param.setBusModelId(templateBaseInfo.getBizModel());
            f8Param.setDatasetId(templateBaseInfo.getDatasetID());
            f8Param.setReturnAllData(true);
            f8Param.setRangeType(F7RangeTypeEnum.MINI);
            f8Param.setEnableView(true);
            f8Param.setShowCustomProperty(true);
            f8Param.setShowDisableVisible(true);
            f8Param.setMustSelected(false);
            f8Param.setHideDecompose(false);
            Long viewId = this.getSpreadManager() == null ? Long.valueOf(0L) : (Long)this.getSpreadManager().getDimemsionViews().get(dimNumber);
            String memberCacheStr = (String)this.getView().getFormShowParameter().getCustomParam("filterMemberCache");
            if (StringUtils.isNotEmpty((String)memberCacheStr)) {
                String viewId1;
                Map memberCacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)memberCacheStr);
                List conditionList = (List)memberCacheMap.get(dimNumber);
                if (conditionList != null) {
                    IModelCacheHelper modelCache = this.getTemplateModel().getModelCache(modelId);
                    CustomF7utils.loadSelectedData((List)conditionList, (MemberF7Parameter)f8Param, (Dimension)modelCache.getDimension(dimNumber));
                }
                if (dimNumber.equals(SysDimensionEnum.Entity.getNumber())) {
                    viewId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("currentEntityViewId"));
                } else if (conditionList != null && conditionList.size() > 0 && StringUtils.isNotEmpty((String)(viewId1 = ((MemberCondition)conditionList.get(0)).getViewId()))) {
                    viewId = IDUtils.toLong((Object)viewId1);
                }
            }
            f8Param.setSelectRangeIds(ReportDimFilterUtils.getFilterId((Long)viewId, (String)dimNumber, this.getDefaultDimMember(), (ITemplateModel)this.getTemplateModel(), (IEbSpreadManager)this.getSpreadManager(), (Long)IDUtils.toLong((Object)this.getCustomFormParam("taskId")), (String)((String)this.getCustomFormParam("processType"))));
            f8Param.setViewId(viewId);
            f8Param.setCutTree(true);
            NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("filter_")) {
            this.handleFilterF7Return(actionId, closedCallBackEvent.getReturnData());
            Map<String, String> filterDimMap = this.getFilterDimMap();
            String key = filterDimMap.get(actionId);
            CommandParam commandParam = new CommandParam(this.getView().getEntityId(), this.getView().getParentView().getEntityId(), "filterValueChange", new Object[]{key, closedCallBackEvent.getReturnData()});
            this.sendMsg(this.getView(), commandParam);
        }
    }

    private void handleFilterF7Return(String key, Object returnData) {
        if (returnData instanceof DynamicObjectCollection) {
            Map<String, String> filterDimMap = this.getFilterDimMap();
            String dimNumber = filterDimMap.get(key);
            if (StringUtils.isEmpty((String)dimNumber)) {
                return;
            }
            String showText = this.buildFilterMemShowname(dimNumber, (DynamicObjectCollection)returnData);
            this.getView().getModel().setValue(key, (Object)showText);
            this.getView().updateView(key);
        }
    }

    private String buildFilterMemShowname(String key, DynamicObjectCollection returnData) {
        ArrayList<String> list = new ArrayList<String>(returnData.size());
        ArrayList<MemberCondition> conditionList = new ArrayList<MemberCondition>(16);
        for (DynamicObject dyna : returnData) {
            String name = dyna.getString("name");
            int scope = dyna.getInt("scope");
            String showtext = RangeEnum.getRangeByVal((int)scope) == RangeEnum.VALUE_10 ? name : name + RangeEnum.getRangeByVal((int)scope).getName();
            MemberCondition memberCondition = new MemberCondition(dyna.getString("number"), dyna.getString("name"), "", dyna.getString("scope"));
            memberCondition.setId(dyna.getString("id"));
            memberCondition.setProp("2".equals(dyna.getString("type")));
            memberCondition.setViewId(dyna.getString("viewId"));
            memberCondition.setRange(scope + "");
            conditionList.add(memberCondition);
            list.add(showtext);
        }
        String memberCacheStr = this.getPageCache().get(this.getPageCache().get("processId") + "filterMemberCache");
        Map memberCacheMap = new HashMap<String, ArrayList<MemberCondition>>(16);
        if (StringUtils.isNotEmpty((String)memberCacheStr)) {
            memberCacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)memberCacheStr);
        }
        memberCacheMap.put(key, conditionList);
        if (CollectionUtils.isEmpty(conditionList)) {
            memberCacheMap.remove(key);
        }
        if (memberCacheMap.size() > 0) {
            this.getPageCache().put(this.getPageCache().get("processId") + "filterMemberCache", ObjectSerialUtil.toByteSerialized(memberCacheMap));
        } else {
            this.getPageCache().remove(this.getPageCache().get("processId") + "filterMemberCache");
        }
        return String.join((CharSequence)";", list);
    }

    private String buildFilterMemShowname(List<MemberCondition> returnData) {
        ArrayList<String> list = new ArrayList<String>(returnData.size());
        for (MemberCondition memberCondition : returnData) {
            String name = memberCondition.getName();
            int scope = Integer.parseInt(memberCondition.getRange());
            String showtext = RangeEnum.getRangeByVal((int)scope) == RangeEnum.VALUE_10 ? name : name + RangeEnum.getRangeByVal((int)scope).getName();
            list.add(showtext);
        }
        return String.join((CharSequence)";", list);
    }

    private Set<String> getNeedLockDimF7Keys() {
        Object param = this.getCustomFormParam("needLockDimF7Keys");
        if (param != null) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)param.toString());
        }
        return new HashSet<String>(0);
    }

    private List<String> getRelationMembers(String dimNumber) {
        Object param = this.getCustomFormParam("relationMembers");
        if (param != null) {
            Map relationMembers = (Map)SerializationUtils.deSerializeFromBase64((String)param.toString());
            return (List)relationMembers.get(dimNumber);
        }
        return null;
    }

    private String getCurrentEntityNumber() {
        return (String)this.getCustomFormParam("currentEntityNumber");
    }

    private Map<String, Long> getDefaultDimMember() {
        Object defaultDimMember = this.getCustomFormParam("defaultDimMember");
        if (defaultDimMember == null) {
            return new HashMap<String, Long>(2);
        }
        return (Map)defaultDimMember;
    }

    private Map<String, String> getDimF7KeyMapping() {
        Object param = this.getCustomFormParam("dimF7KeyMapping");
        if (param != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)param.toString());
        }
        return new HashMap<String, String>();
    }

    private Map<String, Long> getPageDimValues() {
        Object param = this.getCustomFormParam("pageDimValues");
        if (param != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)param.toString());
        }
        return new HashMap<String, Long>();
    }

    public ITemplateModel getTemplateModel() {
        return (ITemplateModel)SerializationUtils.deSerializeFromBase64((String)((String)this.getCustomFormParam("templateModel")));
    }

    @Override
    public Long getModelId() {
        return (Long)this.getCustomFormParam("model");
    }

    private Style getStyle() {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("0");
        mg.setBottom("10px");
        mg.setRight("0");
        mg.setLeft("10px");
        sl.setMargin(mg);
        return sl;
    }

    private Map<String, String> getFilterDimMap() {
        Object param = this.getCustomFormParam("filterToDimCache");
        if (param != null) {
            Map map = (Map)ObjectSerialUtil.deSerializedBytes((String)param.toString());
            return this.sortMapByKey(map);
        }
        return new HashMap<String, String>();
    }

    private Map<String, List<MemberCondition>> getFilterMemberMap() {
        String param = this.getPageCache().get(this.getCustomFormParam("processId") + "filterMemberCache");
        if (param != null) {
            Map map = (Map)ObjectSerialUtil.deSerializedBytes((String)param.toString());
            return map;
        }
        return new HashMap<String, List<MemberCondition>>();
    }

    public Map sortMapByKey(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap sortMap = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    private IEbSpreadManager getSpreadManager() {
        Object param = this.getCustomFormParam("spreadManager");
        if (1 == this.getTemplateType()) {
            return EbSpreadManagerSerializerUtil.read((String)param.toString());
        }
        return FixSpreadManagerSerializerUtil.read((String)param.toString());
    }

    private int getTemplateType() {
        return this.getTemplateModel().getTemplateBaseInfo().getTemplatetype();
    }
}

