/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.currencyConvert.CurrencyConvertException;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.business.examinev2.service.ExamineCheckDataServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.business.forecast.PredictParamService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.ApproveBillExistInfo;
import kd.epm.eb.common.enums.AttachementTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessQuoteService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.PeriodDistribution.PeriodDistributionUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.adjustrecord.AdjustRecordHelper;
import kd.epm.eb.formplugin.centralaudit.CentralOptimization;
import kd.epm.eb.formplugin.customstatustab.CustomEventEnum;
import kd.epm.eb.formplugin.customstatustab.CustomStatusTab;
import kd.epm.eb.formplugin.customstatustab.CustomStatusTabAp;
import kd.epm.eb.formplugin.customstatustab.ICustomStatusTabAp;
import kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import kd.epm.eb.formplugin.task.command.BgCurrencyConvertCommand;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.formplugin.task.multi.TabInfo;
import kd.epm.eb.formplugin.task.multi.TabManager;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.report.excel.entity.RptProcessQInfo;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializerUtil;
import kd.epm.eb.spread.utils.ReportDimFilterUtils;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class RptPluginCommonLogic
implements BgTaskExecuteConstant,
EbMembPerm,
ICustomStatusTabAp {
    private static final Log log = LogFactory.getLog(RptPluginCommonLogic.class);
    private IBgTaskExecutePlugin formPlugin = null;
    private long modelId = 0L;
    private TabManager tabManager = null;

    private RptPluginCommonLogic(IBgTaskExecutePlugin plugin) {
        this.formPlugin = plugin;
    }

    public static RptPluginCommonLogic getInstance(IBgTaskExecutePlugin bgTaskExecutePlugin) {
        return new RptPluginCommonLogic(bgTaskExecutePlugin);
    }

    public void addContextMenuItems() {
        boolean isLockReport;
        SpreadContainer spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
        spreadContainer.deleteContextMenuItems(new String[]{"drillthrough", "viewComputeProcess", "periodDistribution", "viewAttchement", "showAttchement", "modifyNote", "dataDetailsItem", "clearSelectArea", "reportHyperLink", "relQueryExecuteRecord"});
        spreadContainer.addContextMenuItems("drillthrough", ResManager.loadKDString((String)"\u67e5\u8be2\u5206\u6790", (String)"BgTaskExecutePlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("viewComputeProcess", ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b", (String)"BgTaskExecutePlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("dimensionDataDetail", ResManager.loadKDString((String)"\u7ef4\u5ea6\u6570\u636e\u8be6\u60c5", (String)"BgTaskExecutePlugin_93", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        int reportProcessStatus = this.getReportProcessStatus();
        String reportProcessId = this.getPageCache().get("current_report_id");
        boolean fromHyperLink = this.isFromHyperLink(IDUtils.toLong((Object)reportProcessId));
        boolean bl = isLockReport = this.getPageCache().get("lockReportCache") != null;
        if (!(reportProcessStatus == 3 || reportProcessStatus == 5 || reportProcessStatus == 9 || this.isReportQuery() || this.isGraphRelation() || fromHyperLink || isLockReport)) {
            spreadContainer.addContextMenuItems("periodDistribution", ResManager.loadKDString((String)"\u671f\u95f4\u5206\u5e03", (String)"BgTaskExecutePlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[0]), PeriodDistributionUtils.getSubMenus(), new ContextMenuWorkArea().setViewport(true));
        }
        spreadContainer.addContextMenuItems("viewAttchement", ResManager.loadKDString((String)"\u67e5\u770b\u5907\u6ce8", (String)"BgTaskExecutePlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("showAttchement", ResManager.loadKDString((String)"\u63d2\u5165/\u67e5\u770b\u5907\u6ce8", (String)"BgTaskExecutePlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("deleteAttchement", ResManager.loadKDString((String)"\u5220\u9664\u5907\u6ce8", (String)"BgTaskExecutePlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("clearSelectArea", ResManager.loadKDString((String)"\u6e05\u7a7a\u6570\u636e\u533a\u57df", (String)"BgTaskExecutePlugin_84", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("relQueryExecuteRecord", ResManager.loadKDString((String)"\u8054\u67e5\u6267\u884c\u8ddf\u8e2a", (String)"BgTaskExecutePlugin_97", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        if (PredictParamService.getInstance().isShow(this.getModelId())) {
            spreadContainer.addContextMenuItems("predictData", ResManager.loadKDString((String)"\u667a\u80fd\u9884\u6d4b", (String)"BgTaskExecutePlugin_99", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        }
        this.setAttchementMenuItems(spreadContainer);
    }

    private boolean isAllowAdjust() {
        if (this.getView() != null && "true".equals(this.getView().getPageCache().get("lockedbymutex"))) {
            return false;
        }
        long reportProcessId = 0L;
        Long approveBillId = this.getApproveBillId();
        String reportProcess = this.getPageCache().get("current_report_id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)reportProcess)) {
            reportProcessId = Long.parseLong(reportProcess);
        }
        return ApproveAdjustUtils.getInstance().approveAdjust(this.getModelId(), Long.valueOf(reportProcessId), this.getView(), approveBillId);
    }

    private boolean existAdjustRecord() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        return QueryServiceHelper.exists((String)"eb_decomposeadjust", (QFilter[])qFilter.toArray());
    }

    private boolean isFromHyperLink(Long reportProcessId) {
        String s = this.getPageCache().get("openByHyperLink_" + reportProcessId);
        return kd.bos.util.StringUtils.isNotEmpty((String)s);
    }

    public void setAttchementMenuItems(SpreadContainer spreadContainer) {
        String reportProcessId = this.getPageCache().get("current_report_id");
        if (kd.bos.util.StringUtils.isEmpty((String)reportProcessId)) {
            return;
        }
        if (this.isFromHyperLink(IDUtils.toLong((Object)reportProcessId))) {
            spreadContainer.hideContextMenuItemsByKey((List)Lists.newArrayList((Object[])new String[]{"showAttchement", "deleteAttchement"}), (List)Lists.newArrayList((Object[])new String[]{"viewAttchement"}));
            return;
        }
        int canStatus = this.getReportProcessPlugin().canEditAttachement(IDUtils.toLong((Object)reportProcessId).longValue());
        if (canStatus != 1 || this.isReportQuery() || this.isGraphRelation()) {
            if (canStatus == -3 && !this.isReportQuery() && !this.isGraphRelation()) {
                spreadContainer.hideContextMenuItemsByKey((List)Lists.newArrayList((Object[])new String[]{"viewAttchement"}), (List)Lists.newArrayList((Object[])new String[]{"showAttchement", "deleteAttchement"}));
            } else {
                spreadContainer.hideContextMenuItemsByKey((List)Lists.newArrayList((Object[])new String[]{"showAttchement", "deleteAttchement"}), (List)Lists.newArrayList((Object[])new String[]{"viewAttchement"}));
            }
        } else {
            spreadContainer.hideContextMenuItemsByKey((List)Lists.newArrayList((Object[])new String[]{"viewAttchement"}), (List)Lists.newArrayList((Object[])new String[]{"showAttchement", "deleteAttchement"}));
        }
    }

    public void importData() {
        long modelId = this.getModelId();
        if (Long.valueOf(0L).equals(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFileDialog();
    }

    private void openFileDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epm_import");
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCustomParam("modelNumber", (Object)this.getMoreModelNumber());
        formShowParameter.setCustomParam("processtype", (Object)this.getReportProcessPlugin().getProcessType());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formShowParameter.setFormConfig(formConfig);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "importData"));
        formShowParameter.addCustPlugin("kd.epm.eb.formplugin.task.BgTaskExecuteImportPlugin");
        this.getView().showForm(formShowParameter);
    }

    public String getMoreModelNumber() {
        kd.epm.eb.common.ebcommon.common.util.QFBuilder qfBuilder = new kd.epm.eb.common.ebcommon.common.util.QFBuilder();
        String qfilter = "name,number";
        qfBuilder.add(new QFilter("id", "=", (Object)this.getModelId()));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)qfilter, (QFilter[])qfBuilder.toArray());
        return dynamicObject.getString("number");
    }

    public void exportTemplate() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bg_moreexport");
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        showParameter.setCustomParam("processid", (Object)this.getReportProcessPlugin().getProcessId());
        showParameter.setCustomParam("processtype", (Object)this.getReportProcessPlugin().getProcessType());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"bg_moreexport");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.task.BgTaskExecuteExportPlugin");
        this.getView().showForm(showParameter);
    }

    public Long getModelId() {
        if (this.modelId != 0L) {
            return this.modelId;
        }
        this.modelId = this.formPlugin.getModelId();
        if (this.modelId != 0L) {
            return this.modelId;
        }
        String modelIdStr = this.getPageCache().get("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isNotEmpty((String)modelIdStr) && !"0".equals(modelIdStr)) {
            this.modelId = Long.parseLong(modelIdStr);
        }
        return this.modelId;
    }

    private String getSpreadKey() {
        return "report";
    }

    public boolean currentUserIsAuditor() {
        List<String> auditorIds = this.getAuditorIds();
        String userId = RequestContext.get().getUserId();
        return auditorIds != null && auditorIds.contains(userId);
    }

    private List<String> getAuditorIds() {
        String audStr = (String)this.getView().getFormShowParameter().getCustomParam("auditors");
        if (kd.bos.util.StringUtils.isEmpty((String)audStr)) {
            return Collections.EMPTY_LIST;
        }
        List auditors = (List)SerializationUtils.fromJsonString((String)audStr, List.class);
        ArrayList<String> ids = new ArrayList<String>(auditors.size());
        for (Object auditor : auditors) {
            ids.add(String.valueOf(auditor));
        }
        return ids;
    }

    public void switchHideShowPageDims() {
        if ("false".equals(this.getPageCache().get("isExamineVisible"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"eb_dimcontentpanel"});
            String json = this.formPlugin.getView().getPageCache().get(this.formPlugin.getReportProcessPlugin().getProcessType() + this.formPlugin.getReportProcessPlugin().getProcessId());
            if (StringUtils.isNotEmpty((String)json)) {
                List examineReportProcessIds = (List)SerializationUtils.fromJsonString((String)json, List.class);
                this.formPlugin.showInContainerDesigner(ShowType.InContainer, examineReportProcessIds);
            }
            this.getPageCache().put("isExamineVisible", "true");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.getPageCache().put("isExamineVisible", "false");
        }
    }

    public void showAttchement(Boolean readOnly) {
        String reportProcessId = this.getPageCache().get("current_report_id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)IDUtils.toLong((Object)reportProcessId), (String)"eb_reportprocess");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u8868\u5b9e\u4f8b\u3002", (String)"AbstractMultiReportPlugin_155", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        String status = dynamicObject.getString("status");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)status, (CharSequence)BgTaskStateEnum.UNSTARTED.getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u62a5\u8868\uff0c\u518d\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"AbstractMultiReportPlugin_116", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        String pageMembersKey = this.getReportProcessPlugin().getPageMembersKey();
        this.getReportProcessPlugin().showAttchement(pageMembersKey, "callback_upload_attchement", AttachementTypeEnum.TEMPLATE.getValue(), readOnly);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newVal;
        Object ob = e.getChangeSet()[0].getNewValue();
        if (ob instanceof DynamicObject) {
            BgTaskExecuteHelper.cacheUserSelectF7(this.getView(), e.getProperty().getName(), ((DynamicObject)ob).getString("id"));
        }
        if ((newVal = e.getChangeSet()[0].getNewValue()) instanceof DynamicObject) {
            IFormView parentView = this.formPlugin.getView().getParentView();
            String key = e.getProperty().getName();
            if (BudgetFormHelper.isBudgetForm((IFormView)parentView) && "ebf7_entity".equals(key)) {
                DynamicObject org = (DynamicObject)newVal;
                this.getReportProcessPlugin().setCurrentEntityNumber(org.getString("number"));
                List filterDims = this.getReportProcessPlugin().getTemplateModel().getFilterDims();
                if (CollectionUtils.isEmpty((Collection)filterDims) || !filterDims.contains(SysDimensionEnum.Entity.getNumber())) {
                    return;
                }
                String defaultMemberStr = this.getPageCache().get("defaultMember" + this.getReportProcessPlugin().getProcessId());
                if (kd.bos.util.StringUtils.isNotEmpty((String)defaultMemberStr)) {
                    Map defaultDimMember = (Map)ObjectSerialUtil.deSerializedBytes((String)defaultMemberStr);
                    defaultDimMember.put(SysDimensionEnum.Entity.getNumber(), org.getLong("id"));
                    this.getPageCache().put("defaultMember" + this.getReportProcessPlugin().getProcessId(), ObjectSerialUtil.toByteSerialized((Object)defaultDimMember));
                    this.getPageCache().remove(this.getReportProcessPlugin().getProcessId() + "filterMemberCache");
                }
            }
        }
        this.addContextMenuItems();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String membersKey;
        String callBackId = e.getCallBackId();
        if ("callback_delete_attachement".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                int count = this.delTaskProAttachement();
                if (count == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u5220\u9664\u5185\u5bb9\u3002", (String)"BgTaskExecutePlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"BgTaskExecutePlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("callback_delete_cell_attachement".equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult()) && !kd.bos.util.StringUtils.isEmpty((String)(membersKey = this.getPageCache().get("ContextMenuItems_Del_CellAttachement")))) {
            List rangeList;
            ArrayList membersKeyList = (ArrayList)SerializationUtils.fromJsonString((String)membersKey, ArrayList.class);
            long l = System.currentTimeMillis();
            int count = this.batchDelCellAttachement(membersKeyList);
            if (count == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u5220\u9664\u5185\u5bb9\u3002", (String)"BgTaskExecutePlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"BgTaskExecutePlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().remove("ContextMenuItems_Del_CellAttachement");
            String rangeStr = this.getPageCache().get("ContextMenuItems_Del_CellAttachement_Range");
            if (kd.bos.util.StringUtils.isNotEmpty((String)rangeStr) && CollectionUtils.isNotEmpty((Collection)(rangeList = (List)SerializationUtils.fromJsonString((String)rangeStr, ArrayList.class)))) {
                this.getReportProcessPlugin().resetCellTags(rangeList);
            }
        }
    }

    public void openCurrencyCounvertParamPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_currconvertparampage");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "currency_convert"));
        this.getView().showForm(formShowParameter);
    }

    public void openWeaveDesPage() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"weavedescription"});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bgm_report_desc");
        String templateId = this.getPageCache().get("current_rpt");
        if (kd.bos.util.StringUtils.isNotEmpty((String)templateId)) {
            formShowParameter.setCustomParam("templateId", (Object)templateId);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "weaveDes"));
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("weavedescription");
        this.getView().showForm(formShowParameter);
    }

    private int delCellAttachement(String memberskey) {
        if (kd.bos.util.StringUtils.isEmpty((String)memberskey)) {
            return 0;
        }
        int count = this.getReportProcessPlugin().doDeleteAttchement(memberskey, AttachementTypeEnum.CELL.getValue());
        this.getReportProcessPlugin().refreCellTags(memberskey, "", Boolean.valueOf(false));
        return count;
    }

    private int batchDelCellAttachement(List<String> membersKeyList) {
        if (CollectionUtils.isEmpty(membersKeyList)) {
            return 0;
        }
        long l = System.currentTimeMillis();
        int count = this.getReportProcessPlugin().batchDeleteAttchement(membersKeyList, AttachementTypeEnum.CELL.getValue());
        return count;
    }

    private int delTaskProAttachement() {
        String attachmentKey = this.getPageCache().get("current_report_id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)attachmentKey)) {
            String pageMembersKey = this.getReportProcessPlugin().getPageMembersKey();
            int count = this.getReportProcessPlugin().doDeleteAttchement(pageMembersKey, AttachementTypeEnum.TEMPLATE.getValue());
            if (count != 0) {
                this.getReportProcessPlugin().setTaskAttachementTag(Long.parseLong(attachmentKey), pageMembersKey);
            }
            return count;
        }
        return 0;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key = evt.getActionId();
        if ("callback_upload_attchement".equals(key)) {
            String attachmentKey = this.getPageCache().get("current_report_id");
            if (kd.bos.util.StringUtils.isNotEmpty((String)attachmentKey)) {
                String pageMembersKey = this.getReportProcessPlugin().getPageMembersKey();
                this.getReportProcessPlugin().setTaskAttachementTag(Long.parseLong(attachmentKey), pageMembersKey);
            }
        } else if ("callback_upload_cell_attchement".equals(key)) {
            Object backData = evt.getReturnData();
            this.setCellTag(backData);
        } else if ("currency_convert".equals(key)) {
            Object res = evt.getReturnData();
            if (res != null && kd.bos.util.StringUtils.isNotEmpty((String)res.toString())) {
                try {
                    new BgCurrencyConvertCommand(res.toString()).execute(this.formPlugin);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u5b8c\u6bd5\uff0c\u8bf7\u5728\u6298\u7b97\u8868\u4e2d\u68c0\u67e5\u6570\u636e\u51c6\u786e\u6027\u3002", (String)"BgTaskExecutePlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.formPlugin.clickRefresh();
                }
                catch (CurrencyConvertException e) {
                    log.error((Throwable)e);
                    this.getView().showTipNotification(e.getMessage());
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6267\u884c\u8d27\u5e01\u6298\u7b97\u51fa\u9519\u201c%1\u201d,\u8be6\u60c5\u8bf7\u67e5\u770b\u8d27\u5e01\u6298\u7b97\u65e5\u5fd7\u3002", (String)"BgTaskExecutePlugin_73", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
            }
        } else if ("exportReport".equals(key)) {
            Object backData = evt.getReturnData();
            if (backData != null) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"exportdata"});
            }
        } else if ("callback_float_pagedim".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pagedimspanel"});
        } else if (key.startsWith("filter_")) {
            Object returnData = evt.getReturnData();
            this.handleFilterF7Return(key, returnData);
        }
    }

    public void refreshReportByFilterValueReset(String key) {
        String initFilterChange = this.getPageCache().get("initFilterChange");
        if (kd.bos.util.StringUtils.isNotEmpty((String)initFilterChange)) {
            return;
        }
        String filterToDimMapStr = this.getPageCache().get("filterToDimCache");
        Map filterToDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)filterToDimMapStr);
        String dimNumber = (String)filterToDimMap.get(key);
        this.buildFilterMemShowname(dimNumber, new DynamicObjectCollection());
    }

    private void setCellTag(Object backData) {
        if (backData != null) {
            Map data = (Map)SerializationUtils.deSerializeFromBase64((String)((String)backData));
            String memberskey = (String)data.get("memberskey");
            String remark = (String)data.get("remark");
            if (!kd.bos.util.StringUtils.isEmpty((String)memberskey)) {
                this.getReportProcessPlugin().refreCellTags(memberskey, remark, Boolean.valueOf(true));
            }
        } else {
            String reportProcessId;
            String memberskey = this.getPageCache().get("memberskey");
            if (kd.bos.util.StringUtils.isNotEmpty((String)memberskey) && kd.bos.util.StringUtils.isNotEmpty((String)(reportProcessId = this.getPageCache().get("current_report_id")))) {
                Long modelId = this.getModelId();
                QFilter filter = new QFilter("modelid", "=", (Object)modelId);
                filter.and(new QFilter("reportprocess", "=", (Object)IDUtils.toLong((Object)reportProcessId)));
                filter.and(new QFilter("type", "=", (Object)AttachementTypeEnum.CELL.getValue()));
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"", (String)"eb_reportattachment", (String)"memberskey,remark,attachmentcount", (QFilter[])filter.toArray(), (String)"modifytime desc", (int)1);
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                    List list = dynamicObjects.stream().filter(e -> e.getString("memberskey") != null && e.getString("memberskey").equals(memberskey)).collect(Collectors.toList());
                    Iterator iterator = list.stream().iterator();
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        String remark = next.getString("remark");
                        int attachmentcount = next.getInt("attachmentcount");
                        String memberskey1 = next.getString("memberskey");
                        if (!kd.bos.util.StringUtils.isEmpty((String)remark) || attachmentcount != 0) continue;
                        this.getReportProcessPlugin().refreCellTags(memberskey1, "", Boolean.valueOf(false));
                    }
                }
            }
        }
    }

    public void deleteAttachment() {
        String reportProcessId = this.getPageCache().get("current_report_id");
        Boolean canDel = this.getReportProcessPlugin().canDelAttachement(IDUtils.toLong((Object)reportProcessId).longValue());
        if (canDel.booleanValue()) {
            this.showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u9644\u4ef6\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BgTaskExecutePlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[0]), "callback_delete_attachement");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        block21: {
            MemberF7Parameter f7Param;
            Long viewId;
            String dimNumber;
            block23: {
                IModelCacheHelper modelCacheHelper;
                BgTemplate templateBaseInfo;
                Long modelId;
                block22: {
                    String curOrgNum;
                    block24: {
                        key = e.getProperty().getName();
                        modelId = this.getModelId();
                        if (this.getReportProcessPlugin() == null || this.getReportProcessPlugin().getSpreadManager() == null || !(this.formPlugin instanceof EbMembPerm)) break block21;
                        dimNumber = ((EbMembPerm)this.formPlugin).getCurrentDimNumber(key);
                        viewId = (Long)this.getReportProcessPlugin().getSpreadManager().getDimemsionViews().get(dimNumber);
                        templateBaseInfo = this.getReportProcessPlugin().getTemplateModel().getTemplateBaseInfo();
                        Long bizModel = templateBaseInfo.getBizModel();
                        Map dimensionViews = this.getReportProcessPlugin().getSpreadManager().getDimemsionViews();
                        if (bizModel == null) break block21;
                        f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
                        f7Param.setBusModelId(bizModel);
                        f7Param.setViewId((Long)dimensionViews.get(dimNumber));
                        f7Param.setDatasetId(templateBaseInfo.getDatasetID());
                        modelCacheHelper = this.getReportProcessPlugin().getModelCacheHelper();
                        if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) break block22;
                        curOrgNum = this.getReportProcessPlugin().getCurrentEntityNumber();
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)curOrgNum)) break block23;
                        IFormView parentView = this.formPlugin.getView().getParentView();
                        if (!BudgetFormHelper.isBudgetForm((IFormView)parentView)) break block24;
                        String orgViewIdCache = parentView.getPageCache().get("orgViewIdCache");
                        if (kd.bos.util.StringUtils.isNotEmpty((String)orgViewIdCache)) {
                            viewId = IDUtils.toLong((Object)orgViewIdCache);
                            f7Param.setViewId(viewId);
                        }
                        HashSet<Object> orgNumbers = new HashSet<Object>(16);
                        String orgIdCache = parentView.getPageCache().get("orgIdsCache");
                        if (kd.bos.util.StringUtils.isNotEmpty((String)orgIdCache)) {
                            List orgIds = (List)SerializationUtils.deSerializeFromBase64((String)orgIdCache);
                            for (Long orgId : orgIds) {
                                Member orgMember;
                                if (BudgetFormHelper.isEntityPageDim((ITemplateModel)this.getReportProcessPlugin().getTemplateModel())) {
                                    orgMember = modelCacheHelper.getMember(dimNumber, viewId, orgId);
                                    List memberList = modelCacheHelper.getMember(dimNumber, viewId, orgMember.getNumber(), RangeEnum.ALL.getIndex());
                                    Set memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                                    orgNumbers.addAll(memberNumbers);
                                    continue;
                                }
                                orgMember = modelCacheHelper.getMember(dimNumber, viewId, orgId);
                                String orgNumber = orgMember.getNumber();
                                orgNumbers.add(orgNumber);
                            }
                        }
                        QFilter qFilter = new QFilter("number", "in", orgNumbers);
                        f7Param.addCustomFilter(qFilter);
                        break block23;
                    }
                    Member _dimMember = modelCacheHelper.getMember(dimNumber, viewId, curOrgNum);
                    if (_dimMember == null) break block23;
                    if (_dimMember.getId() != null) {
                        f7Param.addSelectRange(_dimMember.getId(), RangeEnum.ALL.getIndex());
                    } else {
                        f7Param.addSelectRange(_dimMember.getNumber(), RangeEnum.ALL.getIndex(), modelCacheHelper);
                    }
                    break block23;
                }
                List pageDims = this.getReportProcessPlugin().getTemplateModel().getPagemembentry();
                if (pageDims != null) {
                    IPageDimensionEntry pageDim = null;
                    for (IPageDimensionEntry entry : pageDims) {
                        if (!dimNumber.equals(entry.getDimension().getNumber())) continue;
                        pageDim = entry;
                        break;
                    }
                    if (pageDim != null) {
                        for (IDimensionMember _member : pageDim.getMembers()) {
                            if (TemplateVarUtil.checkIsVar((IDimensionMember)_member, (String)dimNumber).booleanValue()) {
                                Map varValus = ReportVarUtil.getVarValues((String)this.getReportProcessPlugin().getSpreadManager().getProcessType(), (Long)modelId, (Long)this.getReportProcessPlugin().getSpreadManager().getProcessId(), (String)templateBaseInfo.getVarBase());
                                String memNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)_member.getNumber(), (String)dimNumber, (Map)varValus);
                                f7Param.addSelectRange(memNumber, _member.getScope(), modelCacheHelper);
                                continue;
                            }
                            if (_member.getId() != null) {
                                f7Param.addSelectRange(_member.getId(), _member.getScope());
                                continue;
                            }
                            f7Param.addSelectRange(_member.getNumber(), _member.getScope(), modelCacheHelper);
                        }
                    }
                }
            }
            Map dimMap = this.getReportProcessPlugin().getDimMapping();
            if (dimMap.containsKey(key) && this.getReportProcessPlugin().checkDimNeedRelationFilter((String)dimMap.get(key)).booleanValue()) {
                Set relationMembers = this.getReportProcessPlugin().getPageDimRelationMemNum((String)dimMap.get(key));
                if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                    IModelCacheHelper modelCache = this.getReportProcessPlugin().getModelCacheHelper();
                    DimensionRelationUtils.mergeNotLeafMember((IModelCacheHelper)modelCache, (Long)viewId, (String)dimNumber, (Set)relationMembers);
                }
                f7Param.addCustomFilter(new QFilter("number", "in", (Object)relationMembers));
            }
            if ("ebf7_audittrail".equals(key)) {
                f7Param.setHideDecompose(false);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
        }
        if (key.equals("model") && this.isFromTask()) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getView().getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("id", "in", this.getModelIdsByTasks()));
            if (showParameter.getCustomParams() != null) {
                showParameter.getCustomParams().put("noNeedDefaultQFilter", "true");
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if ("spreadf7".equals(key)) {
            e.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "cellF7"));
        }
        if (this.getReportProcessPlugin() != null) {
            this.getReportProcessPlugin().beforeF7Select(e);
        }
    }

    private String getModelSign() {
        return "model";
    }

    public Set<Long> getModelIdsByTasks() {
        QFBuilder qb = new QFBuilder();
        this.filterCurrentUser(qb);
        HashSet<Long> modelIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_taskprocess", (String)"task.tasklist.model as model", (QFilter[])qb.toArray(), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long modelId = row.getLong("model");
                    if (!IDUtils.isNotNull((Long)modelId)) continue;
                    modelIds.add(modelId);
                }
            }
        }
        return modelIds;
    }

    public void filterCurrentUser(QFBuilder qb) {
        if (qb == null) {
            return;
        }
        if (this.isSupervisorView()) {
            qb.add("entryentity.supervisor", "=", (Object)this.getUserId());
        } else if (!this.isApproveBill()) {
            qb.add("executors.fbasedataid_id", "=", (Object)this.getUserId());
        }
    }

    private long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public boolean isApproveBill() {
        boolean flag = false;
        String idstr = (String)this.getView().getFormShowParameter().getCustomParam("approveBill");
        if (StringUtils.isNotEmpty((String)idstr)) {
            flag = true;
            this.getPageCache().put("isApproveBill", "1");
        }
        return flag;
    }

    public String getBillStatus() {
        Long approveBillId = this.getApproveBillId();
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)});
        if (approveBill == null) {
            return (String)this.getView().getFormShowParameter().getCustomParam("billstatus");
        }
        return approveBill.getString("billstatus");
    }

    public void removeAuditId(String processId) {
        List<String> clickAuditIds;
        if (kd.bos.util.StringUtils.isEmpty((String)processId)) {
            return;
        }
        if (this.getPageCache().get("clickAuditIds") != null && (clickAuditIds = this.getCacheAuditList()) != null && clickAuditIds.contains(processId)) {
            clickAuditIds.remove(processId);
            this.getPageCache().put("clickAuditIds", SerializationUtils.toJsonString(clickAuditIds));
        }
    }

    public void cacheAuditList(String processId) {
        if (kd.bos.util.StringUtils.isEmpty((String)processId)) {
            return;
        }
        List<String> clickAuditIds = null;
        if (this.getPageCache().get("clickAuditIds") != null) {
            clickAuditIds = this.getCacheAuditList();
            if (clickAuditIds != null && !clickAuditIds.contains(processId)) {
                clickAuditIds.add(processId);
            }
        } else {
            clickAuditIds = new ArrayList<String>(16);
            clickAuditIds.add(processId);
        }
        this.getPageCache().put("clickAuditIds", SerializationUtils.toJsonString(clickAuditIds));
    }

    public List<String> getCacheAuditList() {
        if (this.getPageCache().get("clickAuditIds") == null) {
            return null;
        }
        List clickAuditIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("clickAuditIds"), List.class);
        return clickAuditIds;
    }

    private boolean isSupervisorView() {
        return "supervisor".equals(this.getView().getFormShowParameter().getCustomParam("role"));
    }

    private void showConfirm(String msg, String callBackId) {
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(callBackId, (IFormPlugin)this.formPlugin));
    }

    private boolean isFromTask() {
        return ProcessTypeEnum.TASK.getNumber().equals(this.getReportProcessPlugin().getProcessType());
    }

    public void setAppId() {
        if (this.isApproveBill()) {
            this.formPlugin.getView().getFormShowParameter().setAppId(ApplicationTypeEnum.BGM.getAppnum());
        }
    }

    public void loadReport(ReportProcess reportProcess) {
        Object pointMap;
        String orgId;
        ReportOrTaskPojo reportOrTaskPojo;
        Map quotes;
        if (reportProcess == null) {
            return;
        }
        String selectFields = "id,name,number,templatetype,dataunit,model,templateCatalog,dataset,dataset.businessmodel,isreadonly,isrelation,dimrelationinfo2,data,dimmemdefaultdisplaytype,floatcalculate,varbaseforeb";
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)reportProcess.getTemplateId())).toArray());
        if (dyna == null) {
            return;
        }
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setTemplatetype(dyna.getInt("templatetype"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("model_id")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("templateCatalog_id")));
        templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset_id")));
        templateBaseInfo.setIsReadOnly(dyna.getBoolean("isreadonly") ? "1" : "0");
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        templateBaseInfo.setFloatcalculate(dyna.getBoolean("floatcalculate") ? "1" : "0");
        DynamicObjectCollection dimrelationinfos = dyna.getDynamicObjectCollection("dimrelationinfo2");
        List dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        templateBaseInfo.setDimRelations(dimRelations);
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        Long busModelId = dyna.getLong("dataset.businessmodel_id");
        templateBaseInfo.setBizModel(busModelId);
        templateBaseInfo.setDimMemDefaultDisplayType(dyna.getInt("dimmemdefaultdisplaytype"));
        ITemplateModel templateModel = null;
        String data = dyna.getString("data");
        templateModel = !kd.bos.util.StringUtils.isEmpty((String)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel((String)String.valueOf(templateBaseInfo.getTemplatetype()));
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        String processType = null;
        Long processId = null;
        Long orgViewId = null;
        ReportProcessQuote processQuote = reportProcess.getProcessQuote();
        if (processQuote == null && (quotes = ReportProcessQuoteService.getInstance().getReportProcessQuote(reportProcess.getId(), templateBaseInfo.getModelID())) != null && quotes.size() > 0) {
            for (Map.Entry entry : quotes.entrySet()) {
                Set setOfQuote = (Set)entry.getValue();
                if (setOfQuote == null || setOfQuote.size() <= 0) continue;
                processQuote = (ReportProcessQuote)setOfQuote.iterator().next();
                reportProcess.setProcessQuote(processQuote);
                break;
            }
        }
        if (processQuote == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u6765\u6e90\u672a\u627e\u5230\uff0c\u65e0\u6cd5\u6253\u5f00\u62a5\u8868\u3002", (String)"BgTaskExecutePlugin_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        processType = processQuote.getProcessTypeEnum().getNumber();
        processId = processQuote.getSourceId2();
        orgViewId = processQuote.getSourceId3();
        Long modelId = this.getModelId();
        HashMap<String, String> cacheMap = new HashMap<String, String>(16);
        cacheMap.put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)templateBaseInfo));
        cacheMap.put("isreadonly", templateBaseInfo.getIsReadOnly());
        cacheMap.put("TemplateModel", data);
        cacheMap.put("varbaseforeb", dyna.getString("varbaseforeb"));
        cacheMap.put("current_org", String.valueOf(reportProcess.getEntityId()));
        cacheMap.put("CURRENT_ORG_VIEW", String.valueOf(orgViewId));
        cacheMap.put("CURRENT_ORG_NUMBER", reportProcess.getEntityNumber());
        cacheMap.put("current_rpt", String.valueOf(reportProcess.getTemplateId()));
        cacheMap.put("CURRENT_VERSION", String.valueOf(reportProcess.getVersionId()));
        cacheMap.put("CURRENT_DATATYPE", String.valueOf(reportProcess.getDataTypeId()));
        cacheMap.put("CURRENT_PERIOD", String.valueOf(reportProcess.getPeriodId()));
        cacheMap.put("current_rpt_type", String.valueOf(templateBaseInfo.getTemplatetype()));
        cacheMap.put("current_report_id", String.valueOf(reportProcess.getId()));
        cacheMap.put("current_processid", String.valueOf(processId));
        cacheMap.put("KEY_MODEL_ID", String.valueOf(modelId));
        cacheMap.put("currentApproveBillId", String.valueOf(reportProcess.getApproveBillId()));
        this.getPageCache().put(cacheMap);
        if (templateBaseInfo.getTemplatetype() == 1 && (templateModel.getPartitionSetting() == null || templateModel.getPartitionSetting().getColPartition().size() == 0 || templateModel.getPartitionSetting().getRowPartition().size() == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u65e0\u6cd5\u6253\u5f00\uff0c\u6a21\u677f\u672a\u8bbe\u7f6e\u884c\u6216\u5217\u5206\u533a\u3002", (String)"BgTaskExecutePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (ProcessTypeEnum.REPORT == processQuote.getProcessTypeEnum()) {
            reportOrTaskPojo = new ReportOrTaskPojo();
            reportOrTaskPojo.setModelIdLong(this.getModelId());
            reportOrTaskPojo.setBusinessModelIdLong(busModelId);
            reportOrTaskPojo.setReportProcessIdLong(reportProcess.getId());
            reportOrTaskPojo.setTitleString(templateBaseInfo.getName());
            reportOrTaskPojo.setBudgetPeriodIdLong(templateBaseInfo.getBizModel());
            reportOrTaskPojo.setTypeString(ProcessTypeEnum.REPORT.name());
            reportOrTaskPojo.setRptSchemaIdLong(processQuote.getSourceId());
            reportOrTaskPojo.setBudgetPeriodIdLong(reportProcess.getPeriodId());
            reportOrTaskPojo.setVersionIdLong(reportProcess.getVersionId());
            reportOrTaskPojo.setDataTypeIdLong(reportProcess.getDataTypeId());
            reportOrTaskPojo.setEnableMatchReportBoolean(Boolean.valueOf(true));
            CacheUtils.put((IPageCache)this.getPageCache(), (Object)reportOrTaskPojo);
        } else if (ProcessTypeEnum.TASK == processQuote.getProcessTypeEnum()) {
            reportOrTaskPojo = new ReportOrTaskPojo();
            reportOrTaskPojo.setModelIdLong(this.getModelId());
            reportOrTaskPojo.setBusinessModelIdLong(busModelId);
            reportOrTaskPojo.setReportProcessIdLong(reportProcess.getId());
            reportOrTaskPojo.setTitleString(templateBaseInfo.getName());
            reportOrTaskPojo.setBudgetPeriodIdLong(templateBaseInfo.getBizModel());
            reportOrTaskPojo.setTypeString(ProcessTypeEnum.TASK.name());
            reportOrTaskPojo.setEnableMatchReportBoolean(Boolean.valueOf(false));
            CacheUtils.put((IPageCache)this.getPageCache(), (Object)reportOrTaskPojo);
        }
        Map<String, Long> defaultDimMember = null;
        String defDimMemberStr = (String)this.getView().getFormShowParameter().getCustomParam("defalutValue");
        if (kd.bos.util.StringUtils.isNotEmpty((String)defDimMemberStr)) {
            defaultDimMember = (Map<String, Long>)SerializationUtils.fromJsonString((String)defDimMemberStr, Map.class);
        }
        if (defaultDimMember == null) {
            boolean isFirstOpen;
            boolean bl = isFirstOpen = !BgTaskExecuteHelper.getLoadedReportIdsFromCache(this.getView()).contains(reportProcess.getId() + "");
            if (isFirstOpen) {
                BgTaskExecuteHelper.addLoadedReportIdToCache(this.getView(), reportProcess.getId() + "");
            }
            defaultDimMember = BgTaskExecuteHelper.getUserSelectF7FromCache(this.getView(), true, isFirstOpen && CommonUtils.lastSelectPageMem((Long)this.getModelId()));
            log.info("get defaultDimMember by userselect:{}", (Object)JSONUtils.toString(defaultDimMember));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(orgId = BgTaskExecuteHelper.getUserSelectF7FromCache(this.getView(), SysDimensionEnum.Entity.getNumber())))) {
            defaultDimMember.put(SysDimensionEnum.Entity.getNumber(), Long.valueOf(orgId));
        }
        if (!defaultDimMember.containsKey(SysDimensionEnum.DataType.getNumber())) {
            defaultDimMember.put(SysDimensionEnum.DataType.getNumber(), reportProcess.getDataTypeId());
        }
        if (!defaultDimMember.containsKey(SysDimensionEnum.Version.getNumber())) {
            defaultDimMember.put(SysDimensionEnum.Version.getNumber(), reportProcess.getVersionId());
        }
        if (!defaultDimMember.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
            defaultDimMember.put(SysDimensionEnum.BudgetPeriod.getNumber(), reportProcess.getPeriodId());
        }
        Map dimensionViews = templateModel.getDimemsionViews();
        String idstr = (String)this.getView().getFormShowParameter().getCustomParam("relationGraph");
        if (kd.bos.util.StringUtils.isNotEmpty((String)idstr) && (pointMap = this.getView().getFormShowParameter().getCustomParam("relationGraphMemberMap")) != null) {
            List pagemembentry = templateModel.getPagemembentry();
            Set pageDimember = pagemembentry.stream().map(x -> x.getDimension().getNumber()).collect(Collectors.toSet());
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Map memberMap = (Map)SerializationUtils.fromJsonString((String)((String)pointMap), Map.class);
            for (Map.Entry entry : memberMap.entrySet()) {
                Member member;
                if (!pageDimember.contains(entry.getKey()) || (member = orCreate.getMember((String)entry.getKey(), (Long)dimensionViews.get(entry.getKey()), (String)entry.getValue())) == null) continue;
                defaultDimMember.put((String)entry.getKey(), member.getId());
            }
        }
        Set pageDims = templateModel.getPagemembentry().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toSet());
        HashMap<String, QFilter> extraFilters = new HashMap<String, QFilter>(16);
        if (pageDims.contains(SysDimensionEnum.Entity.getNumber())) {
            extraFilters.put(SysDimensionEnum.Entity.getNumber(), this.formPlugin.setEntityFilter());
        }
        if (pageDims.contains(SysDimensionEnum.Account.getNumber())) {
            extraFilters.put(SysDimensionEnum.Account.getNumber(), new QFilter("dataset", "=", (Object)templateBaseInfo.getDatasetID()));
        }
        this.formPlugin.initReportPlugin(String.valueOf(templateBaseInfo.getTemplatetype()));
        this.getReportProcessPlugin().setProcessType(processType);
        this.getReportProcessPlugin().setProcessId(reportProcess.getId());
        this.getReportProcessPlugin().setTaskProcessId(processId);
        this.getReportProcessPlugin().setExtraQfilter(extraFilters);
        this.getReportProcessPlugin().setDefaultDimMember(defaultDimMember);
        this.getReportProcessPlugin().setCurrentEntityViewId(String.valueOf(orgViewId));
        this.getReportProcessPlugin().setCurrentEntityNumber(reportProcess.getEntityNumber());
        this.getReportProcessPlugin().setTemplateModel(null);
        String filterMemberStr = this.getPageCache().get(reportProcess.getId() + "filterMemberCache");
        Map filterMember = ReportDimFilterUtils.getDefaultFilter((String)filterMemberStr, (IModelCacheHelper)this.formPlugin.getReportProcessPlugin().getModelCacheHelper(), (String)reportProcess.getEntityNumber(), (ITemplateModel)templateModel, (IPageCache)this.getPageCache(), (Long)reportProcess.getId(), (Long)orgViewId);
        this.getPageCache().put("defaultMember" + reportProcess.getId(), ObjectSerialUtil.toByteSerialized(defaultDimMember));
        String cellMemberInfoStr = this.getPageCache().get(reportProcess.getId() + "cellMemberInfo");
        HashMap<String, String> filterContextMap = new HashMap<String, String>(16);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cellMemberInfoStr)) {
            Map cellMember = (Map)SerializationUtils.fromJsonString((String)cellMemberInfoStr, Map.class);
            String oldCellMemberInfo = this.getPageCache().get(reportProcess.getId() + "cellMemberInfoOld");
            boolean isNewCell = !cellMemberInfoStr.equals(oldCellMemberInfo);
            this.getReportProcessPlugin().setCellMember(cellMember);
            boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            if (CollectionUtils.isNotEmpty((Collection)templateModel.getFilterDims()) && isNewCell) {
                for (String filterDim : templateModel.getFilterDims()) {
                    Object id;
                    Long viewId = 0L;
                    int templatetype = templateModel.getTemplateBaseInfo().getTemplatetype();
                    EbSpreadManager spreadManager = null;
                    if (templatetype == 1) {
                        spreadManager = new EbSpreadManager();
                        spreadManager.setProcessId(processId);
                        spreadManager.setVarFlagStr("1");
                        spreadManager.setProcessType(processType);
                        spreadManager.initModelObj(templateModel);
                        EBook ieBook = new EBook(new String[]{"Sheet1"});
                        spreadManager.setEbook((IEBook)ieBook);
                        spreadManager.buildReportManager(templateModel);
                    } else {
                        spreadManager = new FixSpreadManager();
                        spreadManager.setProcessId(processId);
                        spreadManager.setVarFlagStr("1");
                        spreadManager.setProcessType(processType);
                        spreadManager.initModelObj(templateModel);
                        spreadManager.buildReportManager(templateModel);
                    }
                    if (spreadManager.getDimemsionViews() != null) {
                        viewId = (Long)spreadManager.getDimemsionViews().get(filterDim);
                    }
                    if (SysDimensionEnum.Entity.getNumber().equals(filterDim)) {
                        viewId = IDUtils.toLong((Object)this.getReportProcessPlugin().getCurrentEntityViewId());
                    }
                    Set filterId = ReportDimFilterUtils.getFilterId((Long)viewId, (String)filterDim, defaultDimMember, (ITemplateModel)templateModel, (IEbSpreadManager)spreadManager, (Long)this.getReportProcessPlugin().getTaskProcessId(), (String)this.getReportProcessPlugin().getProcessType());
                    HashSet viewIds = new HashSet(16);
                    for (Map.Entry stringLongEntry : dimensionViews.entrySet()) {
                        if (!((String)stringLongEntry.getKey()).equals(filterDim) && !((String)stringLongEntry.getKey()).startsWith(filterDim + "_")) continue;
                        viewIds.add(stringLongEntry.getValue());
                    }
                    Member member = null;
                    if (CollectionUtils.isNotEmpty(viewIds)) {
                        Map.Entry stringLongEntry;
                        stringLongEntry = viewIds.iterator();
                        while (stringLongEntry.hasNext() && (member = orCreate.getMember(filterDim, (Long)(id = (Long)stringLongEntry.next()), (String)cellMember.get(filterDim))) == null) {
                        }
                    } else {
                        member = orCreate.getMember(filterDim, null, (String)cellMember.get(filterDim));
                    }
                    if (member == null || CollectionUtils.isEmpty((Collection)filterId) || !filterId.contains(member.getId())) {
                        filterMember.remove(filterDim);
                        continue;
                    }
                    if (!modelManager && DimMembPermUtil.needCheckDataPerm((String)filterDim, (Long)this.getModelId())) {
                        HashSet permMembs = new HashSet(16);
                        if (CollectionUtils.isNotEmpty(viewIds)) {
                            id = viewIds.iterator();
                            while (id.hasNext()) {
                                Long id2 = (Long)id.next();
                                Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)filterDim, (Long)this.getModelId(), (Long)busModelId, (Long)id2, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                                if (!CollectionUtils.isNotEmpty((Collection)permMembNumbers)) continue;
                                permMembs.addAll(permMembNumbers);
                            }
                        } else {
                            Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)filterDim, (Long)this.getModelId(), (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                            if (CollectionUtils.isNotEmpty((Collection)permMembNumbers)) {
                                permMembs.addAll(permMembNumbers);
                            }
                        }
                        if (CollectionUtils.isEmpty(permMembs) || !permMembs.contains(cellMember.get(filterDim))) {
                            filterMember.remove(filterDim);
                            continue;
                        }
                    }
                    if (SysDimensionEnum.Entity.getNumber().equals(filterDim)) {
                        filterMember.remove(filterDim + "$default");
                        AbstractReportPlugin reportProcessPlugin = this.getReportProcessPlugin();
                        viewId = IDUtils.toLong((Object)reportProcessPlugin.getCurrentEntityViewId());
                    }
                    MemberCondition memberCondition = new MemberCondition(member.getNumber(), member.getName(), "", RangeEnum.ALL.getIndex() + "");
                    memberCondition.setId(member.getId() + "");
                    memberCondition.setProp(Boolean.FALSE.booleanValue());
                    memberCondition.setViewId(viewId + "");
                    ArrayList<MemberCondition> tempList = new ArrayList<MemberCondition>(16);
                    tempList.add(memberCondition);
                    filterMember.put(filterDim, tempList);
                    filterContextMap.put(filterDim, member.getName() + RangeEnum.ALL.getName());
                }
            }
        }
        this.getReportProcessPlugin().setFilterMemberMap(Collections.singletonList(filterMember));
        this.getReportProcessPlugin().afterCreateNewData(null);
        this.getReportProcessPlugin().handleFilterHidden(this.getFilterWithFilterAndCentralized());
        if (filterContextMap.size() > 0) {
            String filterToDimMapStr = this.getPageCache().get("filterToDimCache");
            Map filterToDimMap = kd.bos.util.StringUtils.isNotEmpty((String)filterToDimMapStr) ? (Map)ObjectSerialUtil.deSerializedBytes((String)filterToDimMapStr) : new HashMap(16);
            for (Map.Entry entry : filterContextMap.entrySet()) {
                Optional<Map.Entry> first = filterToDimMap.entrySet().stream().filter(x -> ((String)x.getValue()).equals(entry.getKey())).findFirst();
                if (!first.isPresent()) continue;
                this.getView().getModel().setValue((String)first.get().getKey(), entry.getValue());
            }
        }
    }

    private void cleanVirtualReportProcess(List<Long> processIds) {
        if (CollectionUtils.isNotEmpty(processIds)) {
            for (Long processId : processIds) {
                this.getPageCache().remove(processId.toString() + "lastselect_" + SysDimensionEnum.Entity.getNumber());
            }
        }
    }

    public void batchOpenReports(List<Long> processIds, Object orgViewId) {
        this.cleanVirtualReportProcess(processIds);
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessDynamicList(new QFilter("id", "in", processIds));
        if (reportProcessList != null && reportProcessList.size() > 0) {
            String json;
            AtomicInteger seq = new AtomicInteger(0);
            Map<Long, Integer> keyToSeq = processIds.stream().collect(Collectors.toMap(k -> k, v -> seq.incrementAndGet(), (o1, o2) -> o2));
            reportProcessList.sort((o1, o2) -> {
                Integer seq1 = keyToSeq.getOrDefault(o1.getId(), Integer.MAX_VALUE);
                Integer seq2 = keyToSeq.getOrDefault(o2.getId(), Integer.MAX_VALUE);
                return Integer.compare(seq1, seq2);
            });
            boolean isApproveBill = this.isApproveBill();
            Set<Object> noPermMap = isApproveBill ? new HashSet(16) : this.checkNoOrgPerm(reportProcessList, IDUtils.toLong((Object)orgViewId));
            Map<String, List<Long>> processBillMap = CentralOptimization.getInstance().getProcessBillMap(this.getView());
            HashMap<Long, String> centralBillEntityMap = new HashMap<Long, String>(16);
            if (processBillMap.size() != 0) {
                HashSet<Long> centralBills = new HashSet<Long>(16);
                processBillMap.values().forEach(centralBills::addAll);
                centralBillEntityMap.putAll(CentralOptimization.getInstance().getCentralBillEntityMap(centralBills, this.getModelId()));
            }
            ArrayList<TabInfo> tabInfos = new ArrayList<TabInfo>(reportProcessList.size());
            String readOnlyReport = ResManager.loadKDString((String)"\u62a5\u8868\u5206\u6790:", (String)"RptPluginCommonLogic_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            for (ReportProcess reportProcess : reportProcessList) {
                Long processId = reportProcess.getId();
                if (noPermMap.contains(processId)) continue;
                List<Long> centralBills = processBillMap.get(String.valueOf(processId));
                if (centralBills == null) {
                    String tabName = reportProcess.isReadOnly() ? readOnlyReport + reportProcess.getEntityName() + ' ' + reportProcess.getTemplateName() : reportProcess.getEntityName() + ' ' + reportProcess.getTemplateName();
                    TabInfo tabInfo = new TabInfo(String.valueOf(processId), tabName);
                    tabInfo.putUserObject("reportProcess", reportProcess);
                    tabInfo.putUserObject("orgViewId", orgViewId);
                    tabInfos.add(tabInfo);
                    continue;
                }
                for (Long centralBill : centralBills) {
                    String tabName;
                    String entityName = centralBillEntityMap.getOrDefault(centralBill, "");
                    String string = tabName = reportProcess.isReadOnly() ? readOnlyReport + reportProcess.getEntityName() + ' ' + reportProcess.getTemplateName() : reportProcess.getEntityName() + ' ' + reportProcess.getTemplateName();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)entityName)) {
                        tabName = String.format("%s \u3010%s\u3011", tabName, entityName);
                    }
                    String tabKey = String.valueOf(processId);
                    tabKey = tabKey + "!" + centralBill;
                    TabInfo tabInfo = new TabInfo(tabKey, tabName);
                    tabInfo.putUserObject("reportProcess", reportProcess);
                    tabInfo.putUserObject("orgViewId", orgViewId);
                    tabInfo.putUserObject(CentralOptimization.CENTRAL_BILL, centralBill);
                    tabInfo.putUserObject("centralEntity", entityName);
                    tabInfos.add(tabInfo);
                }
            }
            this.formPlugin.switchShowLeftPanel(tabInfos.size() == 0);
            this.handleTabs(tabInfos);
            this.statusTabReLoad(this.getTabManager());
            if (!isApproveBill && !noPermMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u62a5\u8868\u65e0\u7ec4\u7ec7\u6743\u9650\uff0c\u4e0d\u80fd\u6253\u5f00\u62a5\u8868\u3002", (String)"ReportPreparationListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)(json = this.getPageCache().get("currentFloatId")))) {
                this.formPlugin.showInContainerDesigner(ShowType.InContainer, Collections.singletonList(this.getReportProcessPlugin().getProcessId()));
            }
        }
    }

    private Set<Long> checkNoOrgPerm(List<ReportProcess> reportProcessList, Long orgViewId) {
        HashSet<Long> result = new HashSet<Long>(16);
        HashSet tempIds = new HashSet(16);
        reportProcessList.forEach(e -> tempIds.add(e.getTemplateId()));
        String selectFields = "id,dataset.businessmodel_id";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "in", tempIds).toArray());
        HashMap<Long, Long> tempBusMap = new HashMap<Long, Long>(16);
        dynamicObjectCollection.forEach(e -> tempBusMap.put(e.getLong("id"), e.getLong("dataset.businessmodel_id")));
        Map<Long, Set<Long>> map = this.checkNoOrgPerm(tempBusMap, orgViewId);
        for (ReportProcess reportProcess : reportProcessList) {
            Set<Long> set = map.get(reportProcess.getTemplateId());
            if (!set.contains(reportProcess.getEntityId())) continue;
            result.add(reportProcess.getId());
        }
        return result;
    }

    private Map<Long, Set<Long>> checkNoOrgPerm(Map<Long, Long> tempBusMap, Long orgViewId) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        tempBusMap.forEach((k, v) -> {
            HashSet set = EpmThreadLocalUtils.getPermMembIds((String)"Entity", (Long)this.getModelId(), (Long)v, (Long)orgViewId, (DimMembPermType)DimMembPermType.READ, (boolean)false);
            if (set == null) {
                set = new HashSet(16);
            }
            result.put((Long)k, set);
        });
        return result;
    }

    private void handleTabs(List<TabInfo> tabInfos) {
        if (tabInfos == null || tabInfos.isEmpty()) {
            return;
        }
        TabAp tabap = new TabAp();
        tabap.setKey("reporttab");
        tabap.setName(new LocaleString("reporttab"));
        tabap.setGrow(0);
        TabManager tabManager = this.getTabManager();
        TabInfo oldSelectedTab = tabManager.getSelectedTabInfo();
        String tabKey = null;
        for (TabInfo t : tabInfos) {
            tabKey = t.getTabKey();
            TabInfo tabInfo = tabManager.searchTab(tabKey);
            if (tabInfo != null) continue;
            tabManager.addTabInfo(t);
        }
        ArrayList<String> keys = new ArrayList<String>(16);
        Iterator<TabInfo> it = tabManager.iterator();
        while (it.hasNext()) {
            TabInfo tab = it.next();
            TabPageAp page = new TabPageAp();
            page.setKey(tab.getTabKey());
            page.setName(new LocaleString(tab.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"BgTaskExecutePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("reporttab", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(1);
        closeMap.put("closable", true);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
        tabManager.setSelectTabInfo(tabKey);
        this.getPageCache().put("TASKTAB_MANAGER_CACHEKEY", ObjectSerialUtil.toByteSerialized((Object)tabManager));
        Tab reporttab = (Tab)this.getView().getControl("reporttab");
        log.info("handleTabs start\uff1a{}", (Object)reporttab);
        if (reporttab != null) {
            log.info("handleTabs tabKey:{} activeTab:{}", (Object)tabKey, (Object)this.getCachedLastActiveTab());
            if (StringUtil.equals((String)tabKey, (String)this.getCachedLastActiveTab())) {
                reporttab.selectTab(tabKey);
            }
            reporttab.activeTab(tabKey);
        }
    }

    public void cacheLastActiveTab(String tabKey) {
        this.getPageCache().put("LastActiveTab", tabKey);
    }

    public String getCachedLastActiveTab() {
        return this.getPageCache().get("LastActiveTab");
    }

    public TabManager getTabManager() {
        if (this.tabManager != null) {
            return this.tabManager;
        }
        String str = this.getPageCache().get("TASKTAB_MANAGER_CACHEKEY");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)str)) {
            this.tabManager = (TabManager)ObjectSerialUtil.deSerializedBytes((String)str);
        }
        if (this.tabManager == null) {
            this.tabManager = new TabManager();
        }
        return this.tabManager;
    }

    public void cacheTabManager() {
        this.getPageCache().put("TASKTAB_MANAGER_CACHEKEY", ObjectSerialUtil.toByteSerialized((Object)this.tabManager));
    }

    public void clearTabManager() {
        this.tabManager = null;
        this.cacheTabManager();
    }

    public void closeTabs(Set<String> keys) {
        if (keys != null && !keys.isEmpty()) {
            TabInfo firstTabInfo;
            new VersionConstrastHelper().closeTab(this.formPlugin, keys);
            AdjustRecordHelper.closeTab(this.formPlugin, keys);
            TabAp tabap = new TabAp();
            tabap.setKey("reporttab");
            tabap.setName(new LocaleString("reporttab"));
            tabap.setGrow(0);
            this.tabManager = this.getTabManager();
            LinkedList removedTabs = new LinkedList();
            LinkedList<String> removedReportIds = new LinkedList<String>();
            keys.forEach(k -> {
                removedTabs.add(this.tabManager.releaseTabByKey((String)k));
                this.getPageCache().remove(k + "filterMemberCache");
            });
            for (TabInfo tabInfo2 : removedTabs) {
                if (tabInfo2 == null || tabInfo2.getUserObjects() == null) continue;
                removedReportIds.add(tabInfo2.getTabKey());
            }
            BgTaskExecuteHelper.removeUserSelectF7FromCache(this.getView(), removedReportIds);
            BgTaskExecuteHelper.removeLoadedReportIdFromCache(this.getView(), removedReportIds);
            Iterator<TabInfo> it = this.tabManager.iterator();
            while (it.hasNext()) {
                TabInfo tab = it.next();
                TabPageAp page = new TabPageAp();
                page.setKey(tab.getTabKey());
                page.setName(new LocaleString(tab.getTabName()));
                tabap.getItems().add(page);
            }
            Map features = tabap.createControl();
            HashMap<String, String> busyTips = new HashMap<String, String>(1);
            busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"BgTaskExecutePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            features.put("busyTip", busyTips);
            this.getView().updateControlMetadata("reporttab", features);
            String currentTabKey = this.getPageCache().get("current_report_id");
            this.getPageCache().remove("openByHyperLink_" + currentTabKey);
            this.getPageCache().remove(currentTabKey + "cellMemberInfo");
            this.getPageCache().remove(currentTabKey + "cellMemberInfoOld");
            String activeTabKey = null;
            if (keys.contains(currentTabKey) && (firstTabInfo = this.tabManager.getFirstTabInfo()) != null) {
                this.tabManager.setSelectTabInfo(firstTabInfo.getTabKey());
                activeTabKey = firstTabInfo.getTabKey();
            }
            this.cacheTabManager();
            if (this.tabManager.getTabCount() > 0) {
                this.tabManager.iterator().forEachRemaining(tabInfo -> {
                    HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(1);
                    closeMap.put("closable", true);
                    this.getView().updateControlMetadata(tabInfo.getTabKey(), closeMap);
                });
                Tab reporttab = (Tab)this.getView().getControl("reporttab");
                if (reporttab != null && activeTabKey != null) {
                    reporttab.activeTab(activeTabKey);
                }
            } else {
                if (CentralOptimization.getInstance().isFromCentralList(this.getView())) {
                    if (CentralOptimization.getInstance().isCentralOpenAll(this.getView())) {
                        this.getView().close();
                        return;
                    }
                    this.invokeParentOperation(CentralOptimization.SHOW_CENTRAL_LIST, false);
                }
                BeforeClickEvent evt = new BeforeClickEvent((Object)this.getView().getControl("treepanelswitchrpt"));
                this.clearSelects(keys);
                this.formPlugin.click((EventObject)evt);
            }
            this.clearSelects(keys);
            this.getView().executeClientCommand("closeTab", new Object[]{keys});
            this.closeFloatPageDimForm();
            if (this.isOpenStatusTab() && CollectionUtils.isNotEmpty(keys)) {
                for (String key : keys) {
                    CacheUtils.remove((IPageCache)this.getPageCache(), (Object)("RUNEXAMINEWHENOPEN_SIGN" + key));
                    this.getPageCache().remove(key + "filterMemberCache");
                }
                this.closeStatusTabs(this.getStatusTabControlKey(), keys, activeTabKey);
            }
        }
    }

    public void closeTab(String key) {
        CacheUtils.remove((IPageCache)this.getPageCache(), (Object)("RUNEXAMINEWHENOPEN_SIGN" + this.getPageCache().get("current_report_id")));
        this.closeTabs(Collections.singleton(key));
    }

    public void workFlowStatusChangedRpt_new(ApproveBillExistInfo existApproveBill) {
        boolean btn_recalcVisable = CommonUtils.btnReCalcVisible((Long)this.getModelId());
        switch (existApproveBill) {
            case EMPTY: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"save", "delattachement", "btn_import_data", "btn_export_template", "currency_convert", "btn_attachement"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"commit", "btn_export_template", "currency_convert"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelcommit", "approved"});
                if (!btn_recalcVisable) break;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_recalc"});
                break;
            }
            case SUBMIT: {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "delattachement", "btn_import_data"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancelcommit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"commit", "approved", "btn_export_template", "currency_convert", ""});
                if (!btn_recalcVisable) break;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_recalc"});
                break;
            }
            case COMPLETED: {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"approved"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"commit", "cancelcommit", "btn_export_template", "currency_convert"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "delattachement", "btn_import_data", "approved"});
                if (!btn_recalcVisable) break;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_recalc"});
                break;
            }
            case REJECT: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"save", "delattachement", "btn_import_data", "btn_export_template", "currency_convert", "btn_attachement"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelcommit", "approved"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_export_template", "currency_convert", "commit"});
                if (!btn_recalcVisable) break;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_recalc"});
                break;
            }
            default: {
                throw new KDBizException("Invalid approve bill status.");
            }
        }
    }

    public void workFlowStatusChangedRpt(int existApproveBill) {
        switch (existApproveBill) {
            case 0: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"save", "delattachement", "btn_import_data", "btn_export_template", "currency_convert", "btn_attachement"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"commit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelcommit", "approved"});
                break;
            }
            case 1: {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "delattachement", "btn_import_data", "btn_export_template", "currency_convert"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancelcommit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"commit", "approved"});
                break;
            }
            case 2: {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"approved"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"commit", "cancelcommit"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "delattachement", "btn_import_data", "btn_export_template", "approved", "currency_convert"});
                break;
            }
            case 3: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"save", "delattachement", "btn_import_data", "btn_export_template", "currency_convert", "btn_attachement"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelcommit", "approved"});
                if (this.isApproveBill()) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"commit"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"commit"});
                break;
            }
            default: {
                throw new KDBizException("Invalid approve bill status.");
            }
        }
    }

    private AbstractReportPlugin getReportProcessPlugin() {
        return this.formPlugin.getReportProcessPlugin();
    }

    private IPageCache getPageCache() {
        return this.formPlugin.getView().getPageCache();
    }

    @Override
    public IFormView getView() {
        return this.formPlugin.getView();
    }

    public void clearSelects(Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        String totalSelectStr = this.getPageCache().get("totalSelect");
        Set processIds = new HashSet(16);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)totalSelectStr)) {
            processIds = (Set)SerializationUtils.deSerializeFromBase64((String)totalSelectStr);
        }
        if (processIds != null) {
            processIds.removeAll(IDUtils.toLongs(keys));
            String cache = SerializationUtils.serializeToBase64(processIds);
            this.getPageCache().put("totalSelect", cache);
        }
    }

    public void clearSelect(String key) {
        this.clearSelects(Collections.singleton(key));
    }

    public void cacheLastSelectCell(String processId) {
        AbstractReportPlugin processPlugin = this.getReportProcessPlugin();
        SpreadSelector selector = null;
        String startPos = null;
        if (processPlugin != null && kd.bos.util.StringUtils.isNotEmpty((String)processId) && (selector = processPlugin.getSpreadSelector()) != null && !"A1".equals(startPos = selector.getStartPosition())) {
            this.getPageCache().put("LAST_SELECT_CELL" + processId, startPos);
        }
    }

    private boolean isReportQuery() {
        String entityId = this.getView().getEntityId();
        return "eb_reportquery_new".equals(entityId);
    }

    private boolean isGraphRelation() {
        String entityId = this.getView().getEntityId();
        IFormView parentView = this.getView().getParentView();
        String parentEntityId = parentView != null ? parentView.getEntityId() : "";
        return "eb_relation_graph".equals(entityId) || "eb_relation_graph".equals(parentEntityId);
    }

    private int getReportProcessStatus() {
        Long reportProcessId = IDUtils.toLong((Object)this.getPageCache().get("current_report_id"));
        Long reportLastSelectEntity = IDUtils.toLong((Object)this.getPageCache().get(reportProcessId + "lastselect_" + SysDimensionEnum.Entity.getNumber()));
        if (this.isFromHyperLink(IDUtils.toLong((Object)this.getPageCache().get("current_report_id")))) {
            return 9;
        }
        Long approveBillId = this.getApproveBillId();
        if (IDUtils.isNull((Long)reportLastSelectEntity) && !ReportProcessUtil.checkReportProcessStatus((Long)reportProcessId, (Long)approveBillId).booleanValue()) {
            return ApproveBillQuery.getInstance().getProcessStatus(reportProcessId, approveBillId);
        }
        Long templateId = IDUtils.toLong((Object)this.getPageCache().get("current_rpt"));
        Long viewId = IDUtils.toLong((Object)this.getPageCache().get("CURRENT_ORG_VIEW"));
        Long periodId = IDUtils.toLong((Object)this.getPageCache().get("CURRENT_PERIOD"));
        Long versionId = IDUtils.toLong((Object)this.getPageCache().get("CURRENT_VERSION"));
        Long dataTypeId = IDUtils.toLong((Object)this.getPageCache().get("CURRENT_DATATYPE"));
        if (IDUtils.isNull((Long)periodId) || IDUtils.isNull((Long)versionId) || IDUtils.isNull((Long)dataTypeId)) {
            QFBuilder builder = new QFBuilder();
            builder.add("id", "=", (Object)reportProcessId);
            DynamicObject reportProcess = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_reportprocess", (String)"version.id,datatype.id,period.id", (QFilter[])builder.toArrays());
            if (reportProcess != null) {
                periodId = reportProcess.getLong("period.id");
                versionId = reportProcess.getLong("version.id");
                dataTypeId = reportProcess.getLong("datatype.id");
            }
        }
        if (IDUtils.isNotNull((Long)reportLastSelectEntity)) {
            ReportProcess reportProcess = ReportProcessServiceImpl.getInstance().getReportProcess(this.getModelId(), templateId, reportLastSelectEntity, periodId, dataTypeId, versionId);
            if (reportProcess != null && kd.bos.util.StringUtils.isNotEmpty((String)reportProcess.getStatus())) {
                return Integer.parseInt(reportProcess.getStatus());
            }
            reportProcessId = ReportProcessUtil.checkVimReportProcessStatus((Long)this.getModelId(), (Long)templateId, (Long)reportLastSelectEntity, null, (Long)periodId, (Long)versionId, (Long)dataTypeId, (Long)viewId);
            if (IDUtils.isNotNull((Long)reportProcessId)) {
                return ApproveBillQuery.getInstance().getProcessStatus(reportProcessId);
            }
            return -1;
        }
        if (this.getReportProcessPlugin() != null) {
            IEbSpreadManager spreadManager = this.getReportProcessPlugin().getSpreadManager();
            RptProcessQInfo processQInfo = new RptProcessQInfo(templateId, periodId, versionId, dataTypeId, viewId);
            reportProcessId = ReportHelper.getVrRptProcessId((Long)reportProcessId, (IEbSpreadManager)spreadManager, (RptProcessQInfo)processQInfo);
        }
        if (reportProcessId != 0L) {
            int status = ApproveBillQuery.getInstance().getProcessStatus(reportProcessId, approveBillId);
            return status;
        }
        return -1;
    }

    public void restoreCellSelect(String processId) {
        AbstractReportPlugin processPlugin = this.getReportProcessPlugin();
        String lastSelectCell = null;
        if (processPlugin != null && processPlugin.getSpreadContainer() != null && kd.bos.util.StringUtils.isNotEmpty((String)processId) && (lastSelectCell = this.getPageCache().get("LAST_SELECT_CELL" + processId)) != null) {
            Point point = ExcelUtils.pos2Point((String)lastSelectCell);
            processPlugin.getSpreadContainer().setSelections(new CellArea(point.y, point.x, 1, 1), true);
        }
    }

    public void showOrHideDetailLabelClick() {
        Set<String> needLockDims = this.getNeedLockDimF7Keys();
        if (CollectionUtils.isEmpty(needLockDims)) {
            return;
        }
        String reportProcessId = this.getPageCache().get("current_report_id");
        String lastVisible = this.getPageCache().get("cache_lock_dim_visible" + reportProcessId);
        boolean newVisible = !"true".equals(lastVisible);
        this.getPageCache().put("cache_lock_dim_visible" + reportProcessId, newVisible ? "true" : "false");
        Label label = (Label)this.getView().getControl("showhidedetail");
        if (label != null) {
            label.setText(newVisible ? ResManager.loadKDString((String)"\u9690\u85cf\u8be6\u60c5", (String)"BgTaskExecutePlugin_95", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u663e\u793a\u8be6\u60c5", (String)"BgTaskExecutePlugin_94", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.valueOf(newVisible), needLockDims.toArray(new String[0]));
    }

    private Set<String> getNeedLockDimF7Keys() {
        String reportProcessId = this.getPageCache().get("current_report_id");
        String cacheNeedLockPageDimStr = this.getPageCache().get("cache_need_lock_dimF7Keys" + reportProcessId);
        if (cacheNeedLockPageDimStr != null) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)cacheNeedLockPageDimStr);
        }
        return new HashSet<String>(0);
    }

    public void openFloatPageDimForm(String pageId) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"pagedimspanel"});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rptpagedim_float");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        AbstractReportPlugin reportProcessPlugin = this.getReportProcessPlugin();
        String defaultMemberStr = this.getPageCache().get("defaultMember" + this.getReportProcessPlugin().getProcessId());
        Map defaultMember = new HashMap(16);
        if (kd.bos.util.StringUtils.isNotEmpty((String)defaultMemberStr)) {
            defaultMember = (Map)ObjectSerialUtil.deSerializedBytes((String)defaultMemberStr);
        }
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("templateModel", (Object)SerializationUtils.serializeToBase64((Object)reportProcessPlugin.getTemplateModel()));
        showParameter.setCustomParam("currentEntityNumber", (Object)reportProcessPlugin.getCurrentEntityNumber());
        showParameter.setCustomParam("dimF7KeyMapping", (Object)SerializationUtils.serializeToBase64((Object)reportProcessPlugin.getDimMapping()));
        showParameter.setCustomParam("pageDimValues", (Object)SerializationUtils.serializeToBase64(this.getPageDimValues()));
        showParameter.setCustomParam("needLockDimF7Keys", (Object)SerializationUtils.serializeToBase64(this.getNeedLockDimF7Keys()));
        showParameter.setCustomParam("processId", (Object)reportProcessPlugin.getProcessId());
        showParameter.setCustomParam("processType", (Object)reportProcessPlugin.getProcessType());
        showParameter.setCustomParam("taskId", (Object)reportProcessPlugin.getTaskProcessId());
        showParameter.setCustomParam("defaultDimMember", defaultMember);
        showParameter.setCustomParam("cellMemberInfo", (Object)reportProcessPlugin.getCellMember());
        showParameter.setCustomParam("currentEntityViewId", (Object)reportProcessPlugin.getCurrentEntityViewId());
        showParameter.setCustomParam("filterToDimCache", (Object)reportProcessPlugin.getPageCache().get("filterToDimCache"));
        showParameter.setCustomParam("filterMemberCache", (Object)reportProcessPlugin.getPageCache().get(this.getReportProcessPlugin().getProcessId() + "filterMemberCache"));
        if (1 == this.getReportProcessPlugin().getTemplateModel().getTemplateBaseInfo().getTemplatetype()) {
            showParameter.setCustomParam("spreadManager", (Object)EbSpreadManagerSerializerUtil.toJson((IEbSpreadManager)reportProcessPlugin.getSpreadManager()));
        } else {
            showParameter.setCustomParam("spreadManager", (Object)FixSpreadManagerSerializerUtil.toJson((IEbSpreadManager)reportProcessPlugin.getSpreadManager()));
        }
        this.getPageCache().put("floatPageDimPageId", pageId);
        showParameter.setPageId(pageId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "callback_float_pagedim"));
        this.getView().showForm(showParameter);
    }

    public Map<String, Long> getPageDimValues() {
        Map dimMapping = this.getReportProcessPlugin().getDimMapping();
        HashMap<String, Long> pageDimValues = new HashMap<String, Long>(dimMapping.size());
        for (Map.Entry entry : dimMapping.entrySet()) {
            String f7key = (String)entry.getKey();
            String dimNumber = (String)entry.getValue();
            DynamicObject value = (DynamicObject)this.getView().getModel().getValue(f7key);
            if (value == null) continue;
            pageDimValues.put(dimNumber, value.getLong("id"));
        }
        return pageDimValues;
    }

    public void dealMsg(CommandParam com) {
        SplitContainer splRptRule;
        String operation = com.getOperation();
        List param = com.getParam();
        if ("f7ChangeValue".equals(operation)) {
            this.getView().getModel().setValue((String)param.get(0), param.get(1));
        } else if ("filterValueChange".equals(operation)) {
            DynamicObjectCollection returnData = (DynamicObjectCollection)param.get(1);
            if (CollectionUtils.isEmpty((Collection)returnData)) {
                String filterKey = this.getFilterKey((String)param.get(0));
                if (kd.bos.util.StringUtils.isNotEmpty((String)filterKey)) {
                    this.getView().getModel().setValue(filterKey, null);
                    this.buildFilterMemShowname(filterKey, null);
                }
            } else {
                String showText = this.buildFilterMemShowname((String)param.get(0), returnData);
                String filterKey = this.getFilterKey((String)param.get(0));
                if (kd.bos.util.StringUtils.isNotEmpty((String)filterKey)) {
                    this.getView().getModel().setValue(filterKey, (Object)showText);
                }
            }
        } else if ("remarkColor".equals(operation)) {
            this.formPlugin.examineRemark(param.get(0).toString());
        } else if ("versionConstrastRemarkColor".equals(operation)) {
            this.formPlugin.versionConstrastRemark(param.get(0));
        } else if ("float".equals(operation)) {
            String json = this.formPlugin.getView().getPageCache().get(this.formPlugin.getReportProcessPlugin().getProcessType() + this.formPlugin.getReportProcessPlugin().getProcessId());
            if (StringUtils.isNotEmpty((String)json)) {
                List examineReportProcessIds = (List)SerializationUtils.fromJsonString((String)json, List.class);
                this.formPlugin.showInContainerDesigner(ShowType.Floating, examineReportProcessIds);
            }
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.getPageCache().put("isExamineVisible", "false");
        } else if ("openList".equals(operation)) {
            this.showExamineResult();
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.getPageCache().put("isExamineVisible", "false");
        } else if ("tabSelect".equals(operation)) {
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.getPageCache().put("isExamineVisible", "false");
        } else if ("closeTab".equals(operation) || "closeTabs".equals(operation)) {
            this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.getPageCache().put("isExamineVisible", "false");
        } else if ("collapseSplRule".equals(operation) && (splRptRule = (SplitContainer)this.formPlugin.getView().getControl("split_rpt_rule")) != null) {
            splRptRule.setCollapse("split_rule", true);
        }
    }

    private void showExamineResult() {
        String reportOrTaskPojoJsonString;
        String reportsIds = this.formPlugin.getView().getPageCache().get(this.getReportProcessPlugin().getProcessType() + this.getReportProcessPlugin().getProcessId());
        List examineCheckReportV1List = ExamineCheckReportServiceImpl.getInstance().queryCheckReportByReportProcessV1(this.formPlugin.getReportProcessPlugin().getProcessId());
        if (CollectionUtils.isEmpty((Collection)examineCheckReportV1List)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        if (kd.bos.util.StringUtils.isNotEmpty((String)reportsIds)) {
            formShowParameter.setCustomParam("reportIds", (Object)reportsIds);
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(reportOrTaskPojoJsonString = CacheUtils.get((IPageCache)this.formPlugin.getView().getPageCache(), (String)ReportOrTaskPojo.class.getName())))) {
            formShowParameter.setCustomParam(ReportOrTaskPojo.class.getName(), (Object)reportOrTaskPojoJsonString);
        }
        if ("commit".equals(this.formPlugin.getView().getPageCache().get("commitType"))) {
            formShowParameter.setCustomParam("key", (Object)this.formPlugin.getView().getPageCache().get("commitType"));
        } else {
            formShowParameter.setCustomParam("key", (Object)"examine_remark");
        }
        formShowParameter.setCustomParam("model", (Object)((BgTaskExecutePlugin)this.formPlugin).getModelId());
        formShowParameter.setFormId("eb_examine_result");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u7ed3\u679c", (String)"EbExamineEditPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setParentPageId(this.formPlugin.getView().getPageId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "examineCheckResult"));
        formShowParameter.setPageId(this.formPlugin.getView().getPageId() + "eb_examine_result");
        formShowParameter.setCustomParam("processType", (Object)(this.formPlugin instanceof ReportPreparationListPlugin ? ProcessTypeEnum.REPORT : ProcessTypeEnum.TASK));
        this.formPlugin.getView().showForm(formShowParameter);
    }

    private String getFilterKey(String dimNumber) {
        String filterToDimMapStr = this.getPageCache().get("filterToDimCache");
        if (kd.bos.util.StringUtils.isEmpty((String)filterToDimMapStr)) {
            return null;
        }
        Map filterToDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)filterToDimMapStr);
        String filterKey = null;
        for (Map.Entry entry : filterToDimMap.entrySet()) {
            if (!dimNumber.equals(entry.getValue())) continue;
            filterKey = (String)entry.getKey();
            break;
        }
        return filterKey;
    }

    public void closeFloatPageDimForm() {
        IFormView pageDimFormView;
        String cachePageDimPageId = this.getView().getPageCache().get("floatPageDimPageId");
        if (cachePageDimPageId != null && (pageDimFormView = this.getView().getView(cachePageDimPageId)) != null) {
            pageDimFormView.close();
            this.getView().sendFormAction(pageDimFormView);
        }
    }

    public boolean isOpenStatusTab() {
        if (this.getView().getControl("isOpenStatusTab") == null) {
            return false;
        }
        return (Boolean)this.getView().getModel().getValue("isOpenStatusTab");
    }

    @Override
    public Map<String, CustomStatusTabAp> fillInitTabsInfo() {
        HashMap<String, CustomStatusTabAp> map = new HashMap<String, CustomStatusTabAp>(1);
        CustomStatusTabAp customStatusTabAp = new CustomStatusTabAp();
        TabManager tabManager = this.getTabManager();
        List<CustomStatusTab> customStatusTabs = this.getStatusTabsInfoByTabManager(tabManager);
        customStatusTabAp.setCustomStatusTabs(customStatusTabs);
        if (tabManager.getSelectedTabInfo() != null) {
            customStatusTabAp.setFocusTabId(tabManager.getSelectedTabInfo().getTabKey());
        }
        map.put(this.getStatusTabControlKey(), customStatusTabAp);
        return map;
    }

    @Override
    public void statusTabCloseClick(String cusControlKey, Set<String> tabIds) {
        if (CollectionUtils.isEmpty(tabIds)) {
            return;
        }
        ArrayList closeInfo = new ArrayList(tabIds.size());
        for (String tabId : tabIds) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("id", tabId);
            map.put("closable", true);
            closeInfo.add(map);
        }
        this.formPlugin.customEvent(new CustomEventArgs((Object)this.getView().getControl(this.getStatusTabControlKey()), cusControlKey, "closeTabs", SerializationUtils.toJsonString(closeInfo)));
    }

    @Override
    public void afterDelStatusTabs(String controlKey) {
        String curSelStatusTabId = this.getCurSelStatusTabId(controlKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)curSelStatusTabId)) {
            this.formPlugin.customEvent(new CustomEventArgs((Object)this.getView().getControl("reporttab"), controlKey, CustomEventEnum.STATUS_TAB_SELECTED.getEventName(), this.getCurSelStatusTabId(controlKey)));
        }
    }

    @Override
    public void statusTabSelected(String cusControlKey, String statusTabId) {
        Tab reportTab = (Tab)this.getView().getControl("reporttab");
        if (reportTab != null) {
            if (StringUtil.equals((String)statusTabId, (String)this.getCachedLastActiveTab())) {
                reportTab.selectTab(statusTabId);
            }
            reportTab.activeTab(statusTabId);
            boolean fromHyperLink = this.isFromHyperLink(IDUtils.toLong((Object)statusTabId));
            if (fromHyperLink) {
                return;
            }
            this.updateCurReportReadStatus(cusControlKey, statusTabId);
        }
    }

    public void updateCurReportReadStatus(String cusControlKey, String statusTabId) {
        if (!(this.isOpenStatusTab() && this.curCustomInitialized(cusControlKey) && this.isInProcessApproveBill())) {
            return;
        }
        CustomStatusTab tabItemInfo = this.getCustomStatusTabItemInfo(cusControlKey, statusTabId);
        if (tabItemInfo != null && kd.bos.util.StringUtils.isNotEmpty((String)tabItemInfo.getTabName())) {
            tabItemInfo.setTabStatusName("");
            this.updateStatusTabs(cusControlKey, tabItemInfo, tabItemInfo.getTabId());
        }
    }

    public boolean isInProcessApproveBill() {
        Long approveBillId;
        DynamicObject approveBill;
        String param = (String)this.getView().getFormShowParameter().getCustomParam("approveBill");
        if (kd.bos.util.StringUtils.isNotEmpty((String)param) && (approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"billstatus", (QFilter[])new QFilter("id", "=", (Object)(approveBillId = this.getApproveBillId())).toArray())) != null) {
            return !"A".equals(approveBill.getString("billstatus"));
        }
        return false;
    }

    public Map<Long, Boolean> isInProcessApproveBills(Collection<Long> approveBillIds) {
        DynamicObjectCollection approveBills;
        HashMap<Long, Boolean> approveBillStatus = new HashMap<Long, Boolean>(16);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("approveBill");
        if (kd.bos.util.StringUtils.isNotEmpty((String)param) && (approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billstatus", (QFilter[])new QFilter("id", "in", approveBillIds).toArray())).size() != 0) {
            approveBills.forEach(e -> approveBillStatus.put(e.getLong("id"), !"A".equals(e.getString("billstatus"))));
        }
        return approveBillStatus;
    }

    public Long getApproveBillId() {
        return ApproveBillHelper.getAppBillIdFromPage((IFormView)this.getView());
    }

    private String getCentralOrgName() {
        return null;
    }

    public void statusTabReLoad(TabManager tabManager) {
        if (!this.isOpenStatusTab() || !this.curCustomInitialized(this.getStatusTabControlKey())) {
            return;
        }
        List<CustomStatusTab> customStatusTabs = this.getStatusTabsInfoByTabManager(tabManager);
        if (CollectionUtils.isNotEmpty(customStatusTabs)) {
            this.statusTabReLoad(this.getStatusTabControlKey(), customStatusTabs, tabManager.getSelectedTabInfo().getTabKey());
        }
    }

    private List<CustomStatusTab> getStatusTabsInfoByTabManager(TabManager tabManager) {
        String reportTitleShowType = ParamQueryServiceHelper.getChildString((long)this.getModelId(), (ParamEnum)ParamEnum.BG012, (String)"reporttitle");
        boolean isShowReportStatus = ParamQueryServiceHelper.getBoolean((long)this.getModelId(), (ParamEnum)ParamEnum.BG013);
        Long approveBillId = ApproveBillHelper.getAppBillIdFromPage((IFormView)this.getView());
        Map readReportProcessIds = ApproveUtils.getInstance().queryUserApproveBillReadRecords((Collection)Sets.newHashSet((Object[])new Long[]{approveBillId}), UserUtils.getUserId());
        Map<Long, Boolean> inProcessApproveBill = this.isInProcessApproveBills(Sets.newHashSet((Object[])new Long[]{approveBillId}));
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List<TabInfo> tabs = tabManager.getTabs();
        HashMap<Long, List<Long>> billRefProcessIds = new HashMap<Long, List<Long>>(16);
        HashSet<Long> centralBills = new HashSet<Long>(16);
        HashSet<Long> processIds = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(tabs)) {
            HashMap<String, CustomStatusTab> reportProcessStatusTabs = new HashMap<String, CustomStatusTab>(tabs.size());
            boolean fromCentralList = CentralOptimization.getInstance().isFromCentralList(this.getView());
            List reportProcessIds = tabs.stream().map(tab -> {
                ReportProcess reportProcess = (ReportProcess)tab.getUserObject("reportProcess");
                return reportProcess == null ? null : reportProcess.getId();
            }).filter(Objects::nonNull).collect(Collectors.toList());
            DynamicObjectCollection reports = ExamineCheckDataServiceImpl.getInstance().getReportStatus(reportProcessIds);
            ArrayList<CustomStatusTab> customStatusTabs = new ArrayList<CustomStatusTab>(tabs.size());
            for (TabInfo tab2 : tabs) {
                ReportProcess reportProcess;
                if (fromCentralList) {
                    Long centralBill = ConvertUtils.toLong((Object)tab2.getUserObject(CentralOptimization.CENTRAL_BILL));
                    centralBills.add(centralBill);
                    approveBillId = centralBill;
                }
                if ((reportProcess = (ReportProcess)tab2.getUserObject("reportProcess")) == null) continue;
                Object orgViewId = tab2.getUserObject("orgViewId");
                Member member = modelCacheHelper.getMember("Entity", IDUtils.toLong((Object)orgViewId), reportProcess.getEntityId());
                String entityName = "";
                if (member != null) {
                    entityName = "1".equals(reportTitleShowType) && kd.bos.util.StringUtils.isNotEmpty((String)member.getSimpleName()) ? member.getSimpleName() : member.getName();
                }
                String tabName = entityName + " " + reportProcess.getTemplateName();
                String centralEntity = (String)tab2.getUserObject("centralEntity");
                if (kd.bos.util.StringUtils.isNotEmpty((String)centralEntity)) {
                    tabName = String.format("%s \u3010%s\u3011", tabName, centralEntity);
                }
                CustomStatusTab customStatusTab = new CustomStatusTab();
                customStatusTab.setTabId(tab2.getTabKey());
                customStatusTab.setTabName(tabName);
                customStatusTab.setShowClose(true);
                List reportStatus = reports.stream().filter(e -> reportProcess.getId().longValue() == e.getLong("reportprocess")).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(reportStatus)) {
                    if (reportStatus.stream().anyMatch(e -> 50 == e.getInt("status"))) {
                        customStatusTab.setIconClass("kdfont kdfont-jinzhi AqJLx0Mm _2QnPOn2h");
                        customStatusTab.setIconColor("#f56c6c");
                    } else if (reportStatus.stream().anyMatch(e -> 45 == e.getInt("status"))) {
                        customStatusTab.setIconClass("kdfont kdfont-bianji AqJLx0Mm _2QnPOn2h");
                        customStatusTab.setIconColor("#409EFF");
                    } else if (reportStatus.stream().anyMatch(e -> 40 == e.getInt("status"))) {
                        customStatusTab.setIconClass("kdfont kdfont-Toast-jinggao AqJLx0Mm _2QnPOn2h");
                        customStatusTab.setIconColor("#E6A23C");
                    } else {
                        customStatusTab.setIconClass("kdfont kdfont-danliexuanze AqJLx0Mm _2QnPOn2h");
                        customStatusTab.setIconColor("#5CB87A");
                    }
                }
                customStatusTabs.add(customStatusTab);
                Long processId = reportProcess.getId();
                reportProcessStatusTabs.put(processId + "!" + approveBillId, customStatusTab);
                processIds.add(processId);
                List _processIds = billRefProcessIds.computeIfAbsent(approveBillId, k -> new ArrayList(16));
                if (_processIds.contains(processId)) continue;
                _processIds.add(processId);
            }
            if (fromCentralList) {
                readReportProcessIds = ApproveUtils.getInstance().queryUserApproveBillReadRecords(centralBills, UserUtils.getUserId());
                inProcessApproveBill = this.isInProcessApproveBills(centralBills);
            }
            if (isShowReportStatus) {
                this.updateStatusTabStatus(tabManager, readReportProcessIds, inProcessApproveBill, billRefProcessIds, reportProcessStatusTabs, processIds);
            }
            return customStatusTabs;
        }
        return new ArrayList<CustomStatusTab>(0);
    }

    public void updateStatusTabStatus(TabManager tabManager, Map<Long, List<Long>> readReportProcessIds, Map<Long, Boolean> inProcessApproveBill, Map<Long, List<Long>> billRefProcessIds, Map<String, CustomStatusTab> reportProcessStatusTabs, Set<Long> processIds) {
        if (CentralOptimization.getInstance().isFromCentralList(this.getView())) {
            return;
        }
        if (billRefProcessIds == null || reportProcessStatusTabs == null || inProcessApproveBill == null || readReportProcessIds == null) {
            return;
        }
        Map<Long, String> reportProcessStatus = this.getReportProcessStatus(processIds);
        for (Map.Entry<Long, List<Long>> entry : billRefProcessIds.entrySet()) {
            Long approveBill = entry.getKey();
            List<Long> _processIds = entry.getValue();
            Boolean isInProcess = inProcessApproveBill.getOrDefault(approveBill, false);
            List hasReadProcessIds = readReportProcessIds.getOrDefault(approveBill, new ArrayList(16));
            for (Long processId : _processIds) {
                String status = reportProcessStatus.get(processId);
                if (status == null) continue;
                CustomStatusTab customStatusTab = reportProcessStatusTabs.get(processId + "!" + approveBill);
                if (isInProcess.booleanValue()) {
                    boolean isOpening = customStatusTab != null && tabManager.getSelectedTabInfo() != null && tabManager.getSelectedTabInfo().getTabKey().equals(customStatusTab.getTabId());
                    String string = status = hasReadProcessIds.contains(processId) || isOpening ? null : BgTaskStateEnum.UNREAD.getNumber();
                }
                if (this.isFromHyperLink(processId)) {
                    status = BgTaskStateEnum.REPORT_LINK_READONLY.getNumber();
                }
                if (customStatusTab == null) continue;
                customStatusTab.setTabStatusName(BgTaskStateEnum.getNameByNumber((String)status));
                customStatusTab.setTabStatusBackColor(BgTaskStateEnum.getColorByNumber((String)status));
            }
        }
    }

    public void initStatusTabs() {
        if (this.isOpenStatusTab() && IDUtils.isNotEmptyLong((Long)this.getModelId()).booleanValue() && !this.curCustomInitialized(this.getStatusTabControlKey())) {
            this.initStatusTabAp();
        }
    }

    public void tabCustomEvent(CustomEventArgs e) {
        this.statusTabCustomEvent(e);
    }

    public String getStatusTabControlKey() {
        return "customcontrolap";
    }

    public void updateReportTabStatus() {
        if (!this.isOpenStatusTab() || !this.curCustomInitialized(this.getStatusTabControlKey())) {
            return;
        }
        TabManager tabManager = this.getTabManager();
        List<CustomStatusTab> customStatusTabs = this.getStatusTabsInfoByTabManager(tabManager);
        if (CollectionUtils.isNotEmpty(customStatusTabs)) {
            this.updateStatusTabs(this.getStatusTabControlKey(), new HashSet<CustomStatusTab>(customStatusTabs), tabManager.getSelectedTabInfo().getTabKey());
        }
    }

    public Map<Long, String> getReportProcessStatus(Set<Long> reportProcessIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status", (QFilter[])new QFilter("id", "in", reportProcessIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ApproveBillInfo approveBillInfo = ApproveBillHelper.queryBill((Long)this.getApproveBillId());
            if (approveBillInfo != null && approveBillInfo.isCentralBill()) {
                String status = approveBillInfo.getStatus4Rpt();
                return query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> status));
            }
            return query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("status")));
        }
        return new HashMap<Long, String>(0);
    }

    public void filterClick(String key) {
        String filterToDimMapStr = this.getPageCache().get("filterToDimCache");
        if (kd.bos.util.StringUtils.isEmpty((String)filterToDimMapStr) || StringUtil.isEmptyString((String)key)) {
            return;
        }
        Map filterToDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)filterToDimMapStr);
        if (filterToDimMap != null && this.getReportProcessPlugin() != null && this.formPlugin instanceof EbMembPerm) {
            String memberCacheStr;
            String dimNumber = (String)filterToDimMap.get(key);
            if (kd.bos.util.StringUtils.isEmpty((String)dimNumber)) {
                return;
            }
            BgTemplate templateBaseInfo = this.getReportProcessPlugin().getTemplateModel().getTemplateBaseInfo();
            Long modelId = this.getModelId();
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)DynamicObject.class.getName());
            f8Param.setBusModelId(templateBaseInfo.getBizModel());
            f8Param.setDatasetId(templateBaseInfo.getDatasetID());
            f8Param.setReturnAllData(true);
            f8Param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
            f8Param.setCusRange(Arrays.asList(RangeEnum.ONLY.getIndStr(), RangeEnum.DIRECTSUB_EXCLUDE.getIndStr(), RangeEnum.DIRECTSUB.getIndStr(), RangeEnum.ALL_EXCLUDE.getIndStr(), RangeEnum.ALL.getIndStr(), RangeEnum.ALL_DETAIL.getIndStr(), RangeEnum.ALL_NOTDETAIL.getIndStr()));
            f8Param.setEnableView(true);
            f8Param.setShowCustomProperty(true);
            f8Param.setShowDisableVisible(true);
            f8Param.setMustSelected(false);
            f8Param.setHideDecompose(false);
            Long viewId = (Long)this.getReportProcessPlugin().getSpreadManager().getDimemsionViews().get(dimNumber);
            String defaultMemberStr = this.getPageCache().get("defaultMember" + this.getReportProcessPlugin().getProcessId());
            Map defaultMember = new HashMap(16);
            if (kd.bos.util.StringUtils.isNotEmpty((String)defaultMemberStr)) {
                defaultMember = (Map)ObjectSerialUtil.deSerializedBytes((String)defaultMemberStr);
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)(memberCacheStr = this.getPageCache().get(this.getReportProcessPlugin().getProcessId() + "filterMemberCache")))) {
                String viewId1;
                Map memberCacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)memberCacheStr);
                List conditionList = (List)memberCacheMap.get(dimNumber);
                if (conditionList != null) {
                    IModelCacheHelper modelCache = this.getReportProcessPlugin().getModelCacheHelper();
                    CustomF7utils.loadSelectedData((List)conditionList, (MemberF7Parameter)f8Param, (Dimension)modelCache.getDimension(dimNumber));
                }
                if (conditionList != null && conditionList.size() > 0 && kd.bos.util.StringUtils.isNotEmpty((String)(viewId1 = ((MemberCondition)conditionList.get(0)).getViewId()))) {
                    viewId = IDUtils.toLong((Object)viewId1);
                }
                if (dimNumber.equals(SysDimensionEnum.Entity.getNumber()) && IDUtils.isNull((Long)viewId)) {
                    AbstractReportPlugin reportProcessPlugin = this.getReportProcessPlugin();
                    viewId = IDUtils.toLong((Object)reportProcessPlugin.getCurrentEntityViewId());
                }
            } else if (dimNumber.equals(SysDimensionEnum.Entity.getNumber())) {
                AbstractReportPlugin reportProcessPlugin = this.getReportProcessPlugin();
                viewId = IDUtils.toLong((Object)reportProcessPlugin.getCurrentEntityViewId());
            }
            f8Param.setSelectRangeIds(ReportDimFilterUtils.getFilterId((Long)viewId, (String)dimNumber, defaultMember, (ITemplateModel)this.getReportProcessPlugin().getTemplateModel(), (IEbSpreadManager)this.getReportProcessPlugin().getSpreadManager(), (Long)this.getReportProcessPlugin().getTaskProcessId(), (String)this.getReportProcessPlugin().getProcessType()));
            f8Param.setViewId(viewId);
            f8Param.setCutTree(true);
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                f8Param.setDefRangeValue(RangeEnum.ALL_DETAIL);
            }
            NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this.formPlugin, key));
        }
    }

    private void handleFilterF7Return(String key, Object returnData) {
        if (returnData instanceof DynamicObjectCollection) {
            String filterToDimMapStr = this.getPageCache().get("filterToDimCache");
            Map filterToDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)filterToDimMapStr);
            String dimNumber = (String)filterToDimMap.get(key);
            if (kd.bos.util.StringUtils.isEmpty((String)dimNumber)) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)returnData))) {
                this.getView().getModel().setValue(key, null);
                this.buildFilterMemShowname(dimNumber, null);
            } else {
                String showText = this.buildFilterMemShowname(dimNumber, (DynamicObjectCollection)returnData);
                this.getView().getModel().setValue(key, (Object)showText);
            }
        }
    }

    private String buildFilterMemShowname(String key, DynamicObjectCollection returnData) {
        ArrayList<String> list = new ArrayList<String>(returnData == null ? 16 : returnData.size());
        ArrayList<MemberCondition> conditionList = new ArrayList<MemberCondition>(16);
        if (CollectionUtils.isNotEmpty((Collection)returnData)) {
            for (DynamicObject dyna : returnData) {
                String name = dyna.getString("name");
                int scope = dyna.getInt("scope");
                String showtext = kd.epm.eb.common.ebcommon.common.enums.RangeEnum.getRangeByVal((int)scope) == kd.epm.eb.common.ebcommon.common.enums.RangeEnum.VALUE_10 ? name : name + kd.epm.eb.common.ebcommon.common.enums.RangeEnum.getRangeByVal((int)scope).getName();
                MemberCondition memberCondition = new MemberCondition(dyna.getString("number"), dyna.getString("name"), "", dyna.getString("scope"));
                memberCondition.setId(dyna.getString("id"));
                memberCondition.setProp("2".equals(dyna.getString("type")));
                memberCondition.setViewId(dyna.getString("viewId"));
                conditionList.add(memberCondition);
                list.add(showtext);
            }
        }
        String memberCacheStr = this.getPageCache().get(this.getReportProcessPlugin().getProcessId() + "filterMemberCache");
        Map<String, List> memberCacheMap = new HashMap<String, ArrayList<MemberCondition>>(16);
        if (kd.bos.util.StringUtils.isNotEmpty((String)memberCacheStr)) {
            memberCacheMap = (Map)ObjectSerialUtil.deSerializedBytes((String)memberCacheStr);
        }
        memberCacheMap.put(key, conditionList);
        if (CollectionUtils.isEmpty(conditionList)) {
            if (key.equals(SysDimensionEnum.Entity.getNumber())) {
                String orgViewId = this.getReportProcessPlugin().getCurrentEntityViewId();
                List defaultFilterEntity = ReportDimFilterUtils.getDefaultFilterEntity((IModelCacheHelper)this.formPlugin.getReportProcessPlugin().getModelCacheHelper(), (String)this.formPlugin.getReportProcessPlugin().getCurrentEntityNumber(), (ITemplateModel)this.formPlugin.getReportProcessPlugin().getTemplateModel(), (Long)IDUtils.toLong((Object)orgViewId));
                if (CollectionUtils.isNotEmpty((Collection)defaultFilterEntity)) {
                    memberCacheMap.put(SysDimensionEnum.Entity.getNumber() + "$default", defaultFilterEntity);
                }
                memberCacheMap.remove(SysDimensionEnum.Entity.getNumber());
            } else {
                memberCacheMap.remove(key);
            }
        } else if (key.equals(SysDimensionEnum.Entity.getNumber())) {
            memberCacheMap.remove(SysDimensionEnum.Entity.getNumber() + "$default");
        }
        if (memberCacheMap.size() > 0) {
            this.getPageCache().put(this.getReportProcessPlugin().getProcessId() + "filterMemberCache", ObjectSerialUtil.toByteSerialized(memberCacheMap));
        } else {
            this.getPageCache().remove(this.getReportProcessPlugin().getProcessId() + "filterMemberCache");
        }
        this.getReportProcessPlugin().setDefaultDimMember(this.getPageDimValues());
        this.getReportProcessPlugin().setFilterMemberMap(Collections.singletonList(memberCacheMap));
        this.getReportProcessPlugin().afterCreateNewData(null);
        this.getReportProcessPlugin().handleFilterHidden(this.getFilterWithFilterAndCentralized());
        return String.join((CharSequence)";", list);
    }

    public List<Map<String, List<MemberCondition>>> getFilterWithFilterAndCentralized() {
        return this.getReportProcessPlugin().getFilterWithFilterAndCentralized();
    }

    public void invokeParentOperation(String operateKey) {
        this.invokeParentOperation(operateKey, true);
    }

    public void invokeParentOperation(String operateKey, boolean needCheckAudit) {
        CentralOptimization.getInstance().invokeParentOperation(operateKey, this.getView(), needCheckAudit);
    }

    public void checkPerm() {
        this.checkPerm("btn_submit");
    }

    public void checkUnApprovePerm() {
        this.checkPerm("btn_unaudit");
    }

    public void checkPerm(String button) {
        String formId = "eb_approvebill";
        this.checkPerm(button, formId);
    }

    public void checkPerm(String button, String formId) {
        String appid = null;
        IFormView view = this.getView();
        if (view != null) {
            appid = view.getFormShowParameter().getAppId();
        }
        if (appid == null || !appid.equals(ApplicationTypeEnum.BGRP.getAppnum())) {
            appid = this.getAppId();
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{this.getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)appid).getId(), formId, button});
    }

    public String getAppId() {
        if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            return ApplicationTypeEnum.EB.getAppnum();
        }
        return ApplicationTypeEnum.BGM.getAppnum();
    }
}

