/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.designer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.target.service.TargetSchemeService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.constant.ReportQueryDesignerConstant;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.pageinteraction.model.Area;
import kd.epm.eb.common.pageinteraction.model.BaseEditElement;
import kd.epm.eb.common.pageinteraction.model.Element;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.pageinteraction.model.TextEditElement;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.DataEntityUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.CommonMethod;
import kd.epm.eb.formplugin.report.designer.IReportQueryDesigner;
import kd.epm.eb.formplugin.report.designer.ReportQueryDesignerHelper;
import kd.epm.eb.formplugin.report.designer.ShareSettingDto;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.formplugin.utils.TemplateModelHelper;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.DefaultTemplateModel;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IAreaRangeEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.headerarea.DefaultHeaderAreaSetting;
import kd.epm.eb.spread.template.headerarea.HeaderAreaInfo;
import kd.epm.eb.spread.template.headerarea.IHeaderAreaSetting;
import kd.epm.eb.spread.template.metric.DefaultMetricDimMmeber;
import kd.epm.eb.spread.template.metric.IMetricDimMmeber;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.DefaultPartitionSetting;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.partition.PartitionInfo;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.partition.TimeOffset;
import kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import org.apache.commons.collections4.CollectionUtils;

public class ReportQueryDesigner
extends AbstractFormPlugin
implements CommonMethod,
DynamicPage,
SubPage,
IReportQueryDesigner,
BeforeF7SelectListener,
ReportQueryDesignerConstant,
TabCloseListener {
    private static final Log log = LogFactory.getLog(ReportQueryDesigner.class);
    private List<IDimension> allDims = new ArrayList<IDimension>(16);
    private EntityMetadata entityMeta = null;
    private IModelCacheHelper modelCacheHelper;

    public void initialize() {
        super.initialize();
        this.setAllDims(false);
        this.bindCtrlMapping();
    }

    public void sendMsg(IFormView currView, CommandParam cmd) {
        IFormView parentView = currView.getParentView();
        FormViewPluginProxy proxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
        proxy.getPlugIns().forEach(e -> {
            if (MainPage.class.isAssignableFrom(e.getClass()) && !"kd.epm.eb.formplugin.report.query.QueryListPlugin".equals(e.getClass().getName())) {
                ((MainPage)e).dispatchMsg(parentView, cmd);
            }
        });
        currView.sendFormAction(parentView);
    }

    private void bindCtrlMapping() {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        if (this.entityMeta == null) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            this.entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        props.removeIf(e -> !"dataset".equals(e.getName()) && !"dataset_id".equals(e.getName()));
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        pointEntry.values().forEach(dimInfo -> {
            String f7Key = (String)dimInfo.get("sign");
            if (f7Key.endsWith("row") || f7Key.endsWith("col")) {
                String panel = f7Key.endsWith("row") ? "rowdimpanel" : "coldimpanel";
                this.addTextFieldToMainEntity((Container)this.getControl(panel), mainEntityType, this.entityMeta, f7Key, this.getModel(), this.getView());
            } else if (f7Key.endsWith("page")) {
                DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("pagedimpanel")), (MainEntityType)mainEntityType, (String)f7Key, (String)((String)dimInfo.get("entity")), (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        });
    }

    private void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        textFiled.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(textFiled);
        field.setField((Field)textFiled);
        FieldEdit control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCache("cache_tab", (String)this.getFormCustomParam("cache_tab"));
        this.setCache(this.getCurNodeCacheName(), (String)this.getFormCustomParam(this.getCurNodeCacheName()));
        this.getView().setEnable(Boolean.valueOf(!this.isDataEable()), new String[]{"dataset"});
        this.refreshPage();
    }

    private void loadPageInfo() {
        boolean isNeedInitData = this.isNeedInitData();
        if (isNeedInitData) {
            this.loadDatasetDimData();
        } else {
            ITemplateModel templateModel = this.getTemplateModelFromShowParam();
            this.loadPageInfoByTemplateModel(templateModel);
        }
    }

    protected void loadPageInfoByTemplateModel(ITemplateModel templateModel) {
        if (templateModel == null || templateModel.getPartitionSetting() == null || templateModel.getPartitionSetting().getColPartition().size() == 0 || templateModel.getPartitionSetting().getRowPartition().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u8bbe\u7f6e\u884c\u5206\u533a\u6216\u8005\u5217\u5206\u533a\uff0c\u4e0d\u53ef\u6253\u5f00\u62a5\u8868\u3002", (String)"ReportQueryDesigner_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.buildPartitionInfo(templateModel, true);
        this.buildPartitionInfo(templateModel, false);
        ReportQueryDesignerHelper.getInstance().checkDimensionisAll(templateModel);
        List pageDimList = templateModel.getPagemembentry();
        this.buildPageDimPanelInfo(templateModel, pageDimList);
        this.toAddNewTab();
    }

    protected void toAddNewTab() {
        this.toAddNewTab(this.getRowColPartTabKeys(true), true);
        this.toAddNewTab(this.getRowColPartTabKeys(false), false);
    }

    private void initPageData() {
        this.initDataset();
        this.loadDimPanelData();
        this.loadPartitionData();
        this.executeLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initDataset() {
        Long dataSetId = this.getDataSetId();
        if (IDUtils.isNull((Long)dataSetId)) {
            DynamicObject dynamicObject = DataSetServiceHelper.loadDefault((Long)this.getModelId());
            if (dynamicObject == null) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"ReportQueryDesigner_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("dataset", (Object)dynamicObject);
            this.setCache("dataset", String.valueOf(dynamicObject.getString("id")));
            return;
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("dataset", (Object)dataSetId);
            this.getModel().endInit();
        }
    }

    private void executeLock() {
        Set<String> needLockDims = this.getNeedLockDims();
        if (!this.isFromTargetCusReport() || needLockDims == null) {
            return;
        }
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        for (Map.Entry<String, Map<String, String>> entry : pointEntry.entrySet()) {
            Map<String, String> dimInfo = entry.getValue();
            String dimNumber = dimInfo.get("number");
            this.getView().setEnable(Boolean.valueOf(!needLockDims.contains(dimNumber)), new String[]{dimInfo.get("sign")});
        }
    }

    private void buildPageDimPanelInfo(ITemplateModel templateModel, List<IPageDimensionEntry> pageDimList) {
        if (CollectionUtils.isEmpty(pageDimList)) {
            return;
        }
        Long modelId = this.getModelId();
        Long dataSetId = this.getDataSetId();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dataSetId);
        Map<String, String> allF7Map = this.getAllDimF7KeyMap();
        Map dimemsionViews = templateModel.getDimemsionViews();
        for (IPageDimensionEntry pageDimensionEntry : pageDimList) {
            IDimension dimension = pageDimensionEntry.getDimension();
            String dimNumber = dimension.getNumber();
            List members = pageDimensionEntry.getMembers();
            String f7Key = allF7Map.get(dimNumber);
            Long dimViewId = (Long)templateModel.getDimemsionViews().get(dimNumber);
            if (!CollectionUtils.isNotEmpty((Collection)members) || members.size() <= 0) continue;
            IDimensionMember member = (IDimensionMember)members.get(0);
            Set permMemIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)dimViewId, (boolean)true);
            if (permMemIds != null && !permMemIds.contains(member.getId()) || modelCacheHelper.getMember(dimNumber, dimViewId, ((IDimensionMember)members.get(0)).getId()) == null) continue;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
            map.put("id", member.getId().toString());
            map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
            map.put("number", member.getNumber());
            map.put("name", member.getName());
            map.put("pid", "");
            this.setCache(f7Key, SerializationUtils.toJsonString(map));
            Long viewId = (Long)dimemsionViews.get(dimNumber);
            this.cacheCurPartDimViewId(f7Key, viewId);
        }
    }

    private void buildPartitionInfo(ITemplateModel templateModel, boolean isRowPart) {
        String rowCol;
        Long modelId = templateModel.getModelId();
        Long bizModel = templateModel.getTemplateBaseInfo().getBizModel();
        List rowColPartitions = templateModel.getPartitionSetting().getColPartition();
        String string = rowCol = isRowPart ? "row" : "col";
        if (isRowPart) {
            rowColPartitions = templateModel.getPartitionSetting().getRowPartition();
        }
        if (rowColPartitions.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u5217\u5206\u533a\u4fe1\u606f\u5931\u8d25\u3002", (String)"ReportQueryDesigner_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> rowColTabKeys = new ArrayList<String>(10);
        String pre_part = isRowPart ? "rowpart" : "colpart";
        Map<String, String> allF7Map = this.getAllDimF7KeyMap();
        Boolean metricInRow = templateModel.getAreaRangeEntry().isMetricInRow();
        int i = 0;
        for (RowColPartition rowColPartition : rowColPartitions) {
            String curPartCacheF7Key;
            String rowColPartTabKey = pre_part + ++i;
            rowColTabKeys.add(rowColPartTabKey);
            List rowColDimensionEntries = rowColPartition.getRowColDimensionEntries();
            List metricDimMmebers = rowColPartition.getMetricDimMmebers();
            if (CollectionUtils.isEmpty((Collection)rowColDimensionEntries)) continue;
            ArrayList<String> curPartCacheF7Keys = new ArrayList<String>(10);
            for (IRowColDimensionEntry iRowColDimensionEntry : rowColDimensionEntries) {
                IDimension dimension = iRowColDimensionEntry.getDimension();
                String dimNumber = dimension.getNumber();
                if ("Metric".equals(dimNumber)) continue;
                List members = new ArrayList(10);
                if (CollectionUtils.isNotEmpty((Collection)iRowColDimensionEntry.getMembers())) {
                    members = iRowColDimensionEntry.getMembers();
                }
                Iterator iterator = members.iterator();
                IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Long viewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (String)dimNumber, (String)(isRowPart ? "r" + (i - 1) : "c" + (i - 1)));
                Set permMemIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModel, (Long)viewId, (boolean)true);
                while (iterator.hasNext()) {
                    IDimensionMember next = (IDimensionMember)iterator.next();
                    String type = RangeF7PropertyCataEnum.Member.getIndex();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)((DefaultDimMember)next).getType())) {
                        type = ((DefaultDimMember)next).getType();
                    }
                    if (!RangeF7PropertyCataEnum.Member.getIndex().equals(type) || (permMemIds == null || permMemIds.contains(next.getId())) && orCreate.getMember(dimNumber, viewId, next.getNumber()) != null) continue;
                    iterator.remove();
                }
                String f7Key = allF7Map.get(dimNumber);
                curPartCacheF7Key = this.getCurPartF7Key(f7Key, rowColPartTabKey);
                ArrayList list = new ArrayList(members.size());
                for (IDimensionMember member : members) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", IDUtils.toString((Object)member.getId()));
                    map.put("scope", String.valueOf(member.getScope()));
                    map.put("number", member.getNumber());
                    map.put("name", member.getName());
                    map.put("type", member.getType());
                    list.add(map);
                }
                this.setCache(curPartCacheF7Key, SerializationUtils.toJsonString(list));
                curPartCacheF7Keys.add(curPartCacheF7Key);
                this.cacheCurPartDimViewId(curPartCacheF7Key, viewId);
            }
            if (metricInRow != null && metricInRow.equals(isRowPart)) {
                curPartCacheF7Key = "ebf7_metric_" + rowCol + "_" + rowColPartTabKey;
                curPartCacheF7Keys.add(curPartCacheF7Key);
                if (metricDimMmebers.size() > 0) {
                    Set permMemIds = DimMembPermHelper.getReadPermMembIds((String)"Metric", (Long)modelId, (Long)bizModel, null, (boolean)true);
                    if (permMemIds != null) {
                        metricDimMmebers.removeIf(e -> !permMemIds.contains(e.getId()));
                    }
                    for (IMetricDimMmeber metricDimMmeber : metricDimMmebers) {
                        Member member = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber());
                        if (member == null) continue;
                        metricDimMmeber.setShowNumber(member.getShowNumber());
                    }
                    rowColPartition.setMetricDimMmebers(metricDimMmebers);
                    metricDimMmebers.removeIf(e -> this.getModelCacheHelper().getMember("Metric", null, e.getId()) == null);
                    this.setCache(curPartCacheF7Key, SerializationUtils.toJsonString((Object)metricDimMmebers));
                }
            }
            this.cacheCurPartF7Keys(rowColPartTabKey, curPartCacheF7Keys);
        }
        this.cachePartTabKeys(isRowPart, rowColTabKeys);
    }

    private Map<String, String> getAllDimF7KeyMap() {
        LinkedHashMap<String, String> f7KeyMap = new LinkedHashMap<String, String>(16);
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        pointEntry.forEach((f7key, dimInfo) -> {
            f7KeyMap.put((String)f7key, (String)dimInfo.get("number"));
            f7KeyMap.put((String)dimInfo.get("number"), (String)f7key);
        });
        return f7KeyMap;
    }

    private ITemplateModel getTemplateModelFromShowParam() {
        String customParam = this.getCache("TemplateModel");
        if (customParam == null) {
            customParam = (String)this.getView().getFormShowParameter().getCustomParam("TemplateModel");
            this.setCache("TemplateModel", customParam);
        }
        if (customParam == null) {
            return null;
        }
        return TemplateModelJSONUtil.parseITemplateModel((String)customParam);
    }

    private boolean isNeedInitData() {
        return this.getFormCustomParam("TemplateModel") == null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(this.isFloatShow()), new String[]{"eb_dopanel"});
        this.setPanelDimVisible();
    }

    private void setPanelDimVisible() {
        if (kd.bos.util.StringUtils.isEmpty((String)((String)this.getFormCustomParam("querysetting")))) {
            return;
        }
        ShareSettingDto shareSetting = this.getShareSetting();
        Map<String, String> dimVisible = shareSetting.getDimVisible();
        boolean isNoVisibleRowDim = this.setPanelDimVisible("row", dimVisible);
        boolean isNoVisibleColDim = this.setPanelDimVisible("col", dimVisible);
        boolean isNoVisiblePageDim = this.setPanelDimVisible("page", dimVisible);
        if (this.isFloatShow()) {
            return;
        }
        if (isNoVisibleRowDim && isNoVisibleColDim && isNoVisiblePageDim) {
            CommandParam commandParam = new CommandParam("eb_rptquerydesigner", "eb_reportqueryprocess", "close_designer", new Object[0]);
            this.sendMsg(this.getView(), commandParam);
        } else {
            CommandParam commandParam = new CommandParam("eb_rptquerydesigner", "eb_reportqueryprocess", "show_designer", new Object[0]);
            this.sendMsg(this.getView(), commandParam);
        }
    }

    private boolean isMyShareNode() {
        return (Boolean)this.getFormCustomParam("isMyShareNode");
    }

    private boolean setPanelDimVisible(String panel, Map<String, String> dimVisible) {
        boolean isNoVisibleDim = false;
        List<Map<String, String>> panelDimInfo = this.getPointEntry(panel);
        int visibleDimCount = 0;
        for (Map<String, String> dimInfo : panelDimInfo) {
            String sign = dimInfo.get("sign");
            String number = dimInfo.get("number");
            if ("0".equals(dimVisible.get(number))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{sign});
                continue;
            }
            ++visibleDimCount;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{sign});
        }
        if (visibleDimCount == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.getDimParentPanelKey(panel)});
            isNoVisibleDim = true;
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.getDimParentPanelKey(panel)});
        }
        return isNoVisibleDim;
    }

    private String getDimParentPanelKey(String panel) {
        if (panel.equals("row")) {
            return "rowdimpanel1";
        }
        if (panel.equals("col")) {
            return "coldimpanel1";
        }
        return "pagedimpanel1";
    }

    private ShareSettingDto getShareSetting() {
        ShareSettingDto shareSettingDto = new ShareSettingDto();
        String querysetting = this.getCache("querysetting");
        if (querysetting == null) {
            querysetting = (String)this.getFormCustomParam("querysetting");
        }
        if (querysetting != null) {
            shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)querysetting, ShareSettingDto.class);
            this.setCache("querysetting", querysetting);
        }
        return shareSettingDto;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        List<String> clickCtrKeys = Arrays.asList("btn_addrowpart", "btn_addcolpart", "designer_float", "designer_switchlist", "btn_ok", "btn_cancel");
        this.addClickListeners(clickCtrKeys.toArray(new String[0]));
        Set<String> allF7Keys = this.getAllF7Keys();
        allF7Keys.removeIf(key -> !key.endsWith("page"));
        this.addF7SelectListener(this, allF7Keys.toArray(new String[0]));
        this.addF7SelectListener(this, new String[]{"dataset"});
        this.addTabListeners();
    }

    private void addTabListeners() {
        Tab designer_row_tab = (Tab)this.getControl("rowtabap");
        Tab designer_col_tab = (Tab)this.getControl("coltabap");
        designer_row_tab.addTabSelectListener(this::designerTabSelected);
        designer_col_tab.addTabSelectListener(this::designerTabSelected);
        designer_col_tab.addTabCloseListener(this::tabClose);
        designer_row_tab.addTabCloseListener(this::tabClose);
    }

    private void designerTabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.switchRowColPart(tabKey);
    }

    private Set<String> getAllF7Keys() {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        return pointEntry.keySet();
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String name = e.getEventName();
        if ("drop".equals(name)) {
            this.doDropEvent(e);
        } else if ("closeTab".equals(name)) {
            this.delRowColPart("rowtabap".equals(e.getKey()), e.getEventArgs());
            this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
        } else if ("closeTabs".equals(name)) {
            ArrayList<String> keys = new ArrayList<String>(16);
            Object keys_obj = JSONUtils.parse((String)e.getEventArgs(), Object.class);
            if (keys_obj instanceof List) {
                List key_list = (List)keys_obj;
                for (Object item : key_list) {
                    Object id_obj;
                    if (!(item instanceof Map) || (id_obj = ((Map)item).get("id")) == null) continue;
                    keys.add(String.valueOf(id_obj));
                }
            }
            if (CollectionUtils.isNotEmpty(keys)) {
                this.setCache("needCloseId", JSONObject.toJSONString(keys));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                String notShowTip = this.getCache("notShowTip");
                this.returnTemplateModelData(!kd.bos.util.StringUtils.isNotEmpty((String)notShowTip), "refreshReport", true, false);
                break;
            }
            case "btn_addrowpart": {
                this.addRowColPart(true);
                break;
            }
            case "btn_addcolpart": {
                this.addRowColPart(false);
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            default: {
                boolean doStr = ReportQueryHelper.checkControlKey(key);
                if (!doStr) break;
                String dimNumByCtrlKey = this.getDimNumByCtrlKey(key);
                if (SysDimensionEnum.Entity.getNumber().equals(dimNumByCtrlKey) || !SysDimensionEnum.include((String)dimNumByCtrlKey, (Boolean)false)) {
                    this.showMemberPropSelect(evt, dimNumByCtrlKey);
                    break;
                }
                this.doDimMulSelectClick(evt);
            }
        }
    }

    private void refreshPage() {
        this.loadPageInfo();
        this.initPageData();
        this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
    }

    private void showMemberPropSelect(EventObject evt, String dimNumByCtrlKey) {
        String key = ((Control)evt.getSource()).getKey();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)this.getModelId()));
        this.addTargetDataFilter(dimNumByCtrlKey, qFilters);
        String cacheCurTabF7Key = this.getCurPartF7Key(key, this.getCurRowColTabKey(key.endsWith("_row")));
        String content = this.getPageCache().get(cacheCurTabF7Key);
        if (kd.bos.util.StringUtils.isNotEmpty((String)content)) {
            List membColl = (List)SerializationUtils.fromJsonString((String)content, List.class);
            for (Map stringMap : membColl) {
                String type = (String)stringMap.get("type");
                if (!kd.bos.util.StringUtils.isEmpty((String)type)) continue;
                stringMap.put("type", RangeF7PropertyCataEnum.Member.getIndex());
            }
            this.setCache(cacheCurTabF7Key, SerializationUtils.toJsonString((Object)membColl));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(closeCallBack);
        param.setOpenProperty(true);
        param.setqFilters(qFilters);
        param.setSign(cacheCurTabF7Key);
        param.setEnableView(!this.isFromTargetCusReport());
        param.setQueryDecompose(true);
        param.setNeedPermCheck(true);
        FormShowParameter formShowParameter = new FormShowParameter();
        param.setShowParameter(formShowParameter);
        Long dataSetId = this.getDataSetId();
        param.setBizModelId(this.getModelCacheHelper().getBusModelByDataSet(dataSetId));
        Long viewId = this.getDimViewId(cacheCurTabF7Key, dimNumByCtrlKey, dataSetId);
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNumByCtrlKey, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    private boolean isFromTargetCusReport() {
        return kd.bos.util.StringUtils.isNotEmpty((String)this.getPkIdFromTargetData()) && "tab_dimset".equals(this.getCache("cache_tab"));
    }

    private boolean isDataEable() {
        return this.isFromTargetCusReport() || this.getIsShareNode();
    }

    public void dealMsg(CommandParam com) {
        switch (com.getOperation()) {
            case "openFloatDesigner": {
                boolean result = this.returnTemplateModelData(false, "openFloatDesigner", true, false);
                if (!result) break;
                this.getView().close();
                break;
            }
            case "openFloatDesignerShare": {
                this.returnTemplateModelData(false, "openFloatDesignerShare", false, false);
                this.getView().close();
                break;
            }
            case "checkExistRptTarScheme": {
                this.returnTemplateModelData(false, "checkExistRptTarScheme", false, false);
                break;
            }
            case "checkBeforeInterst": {
                this.returnTemplateModelData(true, "checkBeforeInterst", true, false);
                break;
            }
            case "checkBeforeSaveInterest": {
                this.returnTemplateModelData(true, "checkBeforeSaveInterest", true, false);
                break;
            }
            case "checkBeforeShare": {
                this.returnTemplateModelData(true, "checkBeforeShare", true, false);
                break;
            }
            case "openDesignerListPage": {
                this.returnTemplateModelData(true, "openDesignerListPage", true, false);
                break;
            }
            case "loadReport": {
                this.returnTemplateModelData(false, "loadReport", true, false);
                break;
            }
            case "loadFixReport": {
                this.returnTemplateModelData(false, "loadFixReport", true, false);
                break;
            }
            case "updateDimPanelVisible": {
                this.updateDimPanelVisible(com);
                break;
            }
            case "designer_cancel": {
                this.refreshPage();
                break;
            }
            case "designer_ok": {
                this.returnTemplateModelData(true, "refreshReport", true, false);
                break;
            }
            case "checkBeforeSetting": {
                this.returnTemplateModelData(true, "checkBeforeSetting", true, false);
                break;
            }
        }
    }

    private void updateDimPanelVisible(CommandParam com) {
        List param = com.getParam();
        if (param.size() < 1) {
            return;
        }
        String shareSettingDtoCache = (String)param.get(0);
        this.setCache("querysetting", shareSettingDtoCache);
        this.setPanelDimVisible();
    }

    public String getCacheTemplateModel() {
        String templateModelCache = this.getCache("TemplateModel");
        if (!kd.bos.util.StringUtils.isEmpty((String)templateModelCache)) {
            return templateModelCache;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6784\u5efa\u62a5\u8868\u6a21\u677f\u3002", (String)"ReportQueryDesigner_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (ReportQueryHelper.checkControlKey(actionId) || actionId != null && (actionId.startsWith("rowdim") || actionId.startsWith("coldim"))) {
            String dimNumByCtrlKey = this.getDimNumByCtrlKey(actionId);
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumByCtrlKey) || !SysDimensionEnum.include((String)dimNumByCtrlKey, (Boolean)false)) {
                this.fillMemberPropSelectClick(evt);
            } else {
                this.callBackDimMulSelectClick(evt);
            }
        }
    }

    private void fillMemberPropSelectClick(ClosedCallBackEvent evt) {
        DynamicObjectCollection rows;
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        ArrayList list = new ArrayList(16);
        Long viewId = 0L;
        if (evt.getReturnData() instanceof DynamicObjectCollection) {
            rows = (DynamicObjectCollection)returnData;
            for (DynamicObject dynamicObject : rows) {
                int scope = dynamicObject.getInt("scope");
                String pid = dynamicObject.getString("pid");
                String type = dynamicObject.getString("type");
                String number = dynamicObject.getString("number");
                String name = dynamicObject.getString("name");
                HashMap<String, String> map = new HashMap<String, String>(6);
                map.put("id", dynamicObject.getString("mid"));
                map.put("scope", String.valueOf(scope));
                map.put("number", number);
                map.put("name", name);
                map.put("pid", pid);
                map.put("type", type);
                viewId = dynamicObject.getLong("viewid");
                list.add(map);
            }
        } else if (evt.getReturnData() instanceof ListSelectedRowCollection && (rows = (ListSelectedRowCollection)evt.getReturnData()) != null) {
            for (int i = 0; i < rows.size(); ++i) {
                String string = rows.get(i).getDataMap().get("name").toString();
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", rows.get(i).getDataMap().get("memberid").toString());
                map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
                map.put("number", rows.get(i).getDataMap().get("number").toString());
                map.put("name", string);
                map.put("type", rows.get(i).getDataMap().get("type").toString());
                map.put("pid", rows.get(i).getDataMap().get("pid").toString());
                viewId = IDUtils.toLong(rows.get(i).getDataMap().get("viewid"));
                list.add(map);
            }
        }
        this.cacheCurPartDimViewId(actionId, viewId);
        this.cacheViewId();
        if (actionId.endsWith("_page")) {
            if (CollectionUtils.isNotEmpty(list)) {
                String id = (String)((Map)list.get(0)).get("id");
                this.getModel().setValue(actionId, (Object)IDUtils.toLong((Object)id));
            }
            return;
        }
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (Map map : list) {
            RangeEnum scope = RangeEnum.getRangeByVal((String)((String)map.get("scope")));
            if (scope != null && scope != RangeEnum.ONLY) {
                names.add((String)map.get("name") + scope.getName());
                continue;
            }
            names.add((String)map.get("name"));
        }
        String nameText = String.join((CharSequence)",", names);
        String string = this.getCurRowColTabKey(actionId.endsWith("_row"));
        String cacheF7ValueKey = this.getCurPartF7Key(actionId, string);
        String oldCache = this.getCache(cacheF7ValueKey);
        this.setCache(cacheF7ValueKey + "_old", oldCache);
        this.setCache(cacheF7ValueKey, SerializationUtils.toJsonString(list));
        Object value = this.getModel().getValue(actionId);
        if (value instanceof String && nameText.equals(value)) {
            nameText = nameText + " ";
        }
        this.getModel().setValue(actionId, (Object)nameText);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.startsWith("ebf7_")) {
            String cache = this.getCache("changeByDataSet");
            this.setSingleF7Cache(e);
            if (kd.bos.util.StringUtils.isEmpty((String)cache)) {
                try {
                    this.setCache("notShowTip", "1");
                    String drop = this.getPageCache().get("drop");
                    if (kd.bos.util.StringUtils.isEmpty((String)drop)) {
                        this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
                    }
                    this.clearCache("notShowTip");
                }
                catch (KDBizException exception) {
                    String name = e.getProperty().getName();
                    if (name.endsWith("row") || name.endsWith("col")) {
                        String row = this.getCurRowColTabKey(name.endsWith("row"));
                        String curPartF7Key = this.getCurPartF7Key(name, row);
                        String oldCahe = this.getCache(curPartF7Key + "_old");
                        this.setCache(curPartF7Key, oldCahe);
                        this.clearCache(curPartF7Key + "_old");
                    }
                    throw exception;
                }
            }
        } else if ("dataset".equals(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"ReportQueryDesigner_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (newValue == oldValue) {
                log.info("value no change ");
                return;
            }
            this.clearCache(null, "viewId");
            this.setCache("changeByDataSet", "1");
            this.setCache("dataset", ((DynamicObject)newValue).getString("id"));
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.getPageCache().put("dataset", ((DynamicObject)newValue).getString("id"));
            }
            this.loadDatasetDimData();
            this.initPageData();
            this.setCache("isDatasetChange", "true");
            UserSelectUtils.saveUserSelectDataSetId((IFormView)this.getView().getParentView(), (long)this.getModelId(), (long)((DynamicObject)newValue).getLong("id"));
            this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            Object oldValue;
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == (oldValue = e.getChangeSet()[0].getOldValue())) {
                log.info("value no change ");
                return;
            }
            this.clearRowColPart(false);
            this.clearRowColPart(true);
        }
    }

    private void setSingleF7Cache(PropertyChangedArgs e) {
        String ctrlKey = e.getProperty().getName();
        if (ctrlKey.endsWith("page")) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.clearCache(ctrlKey);
                return;
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
            map.put("id", newValue.getString("id"));
            map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
            map.put("number", newValue.getString("number"));
            map.put("name", newValue.getString("name"));
            map.put("pid", "");
            this.setCache(ctrlKey, SerializationUtils.toJsonString(map));
        } else if (ctrlKey.endsWith("row") || ctrlKey.endsWith("col")) {
            String value = this.getModel().getDataEntity().getString(ctrlKey);
            String curRowColTabKey = this.getCurRowColTabKey(ctrlKey.endsWith("row"));
            if (kd.bos.util.StringUtils.isEmpty((String)value)) {
                this.clearCache(this.getCurPartF7Key(ctrlKey, curRowColTabKey));
            }
        }
    }

    private void callBackDimMulSelectClick(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (evt.getReturnData() == null) {
            return;
        }
        Long viewId = 0L;
        if (ReportQueryHelper.checkControlKey(actionId) || actionId != null && actionId.startsWith("ebf7_")) {
            DynamicObjectCollection rows;
            StringBuilder sb = new StringBuilder();
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
            if (evt.getReturnData() instanceof DynamicObjectCollection) {
                rows = (DynamicObjectCollection)evt.getReturnData();
                if (rows != null) {
                    for (int i = 0; i < rows.size(); ++i) {
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        map.put("id", ((DynamicObject)rows.get(i)).getString("memberid"));
                        map.put("scope", ((DynamicObject)rows.get(i)).getString("scope"));
                        map.put("number", ((DynamicObject)rows.get(i)).getString("number"));
                        map.put("name", ((DynamicObject)rows.get(i)).getString("name"));
                        map.put("pid", ((DynamicObject)rows.get(i)).getString("pid"));
                        this.buildMultiSelectF7ReturnValue(sb, ((DynamicObject)rows.get(i)).getString("name"), rows.size(), i);
                        viewId = ((DynamicObject)rows.get(i)).getLong("viewid");
                        list.add(map);
                    }
                }
            } else if (evt.getReturnData() instanceof ListSelectedRowCollection && (rows = (ListSelectedRowCollection)evt.getReturnData()) != null) {
                for (int i = 0; i < rows.size(); ++i) {
                    String name = rows.get(i).getDataMap().get("name").toString();
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", rows.get(i).getDataMap().get("memberid").toString());
                    map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
                    map.put("number", rows.get(i).getDataMap().get("number").toString());
                    map.put("name", name);
                    map.put("pid", rows.get(i).getDataMap().get("pid").toString());
                    this.buildMultiSelectF7ReturnValue(sb, name, rows.size(), i);
                    viewId = IDUtils.toLong(rows.get(i).getDataMap().get("viewid"));
                    list.add(map);
                }
            }
            if (actionId.endsWith("_page")) {
                this.cacheCurPartDimViewId(actionId, viewId);
                if (CollectionUtils.isNotEmpty(list)) {
                    String id = (String)((Map)list.get(0)).get("id");
                    this.getModel().setValue(actionId, (Object)IDUtils.toLong((Object)id));
                }
                return;
            }
            String cacheCurTabF7Key = this.getCurPartF7Key(actionId, this.getCurRowColTabKey(actionId.endsWith("_row")));
            this.cacheCurPartDimViewId(cacheCurTabF7Key, viewId);
            this.cacheViewId();
            this.analyseRange(actionId, list, viewId);
        }
    }

    private void cacheViewId() {
        HashMap cachedViewIds = new HashMap(16);
        this.getPageCache().getAll().forEach((k, v) -> {
            if (k.endsWith("viewId")) {
                cachedViewIds.put(k, v);
            }
        });
        IFormView parentView = null;
        if (cachedViewIds.size() > 0 && (parentView = this.getView().getParentView()) != null) {
            parentView.getPageCache().put(cachedViewIds);
        }
    }

    protected void clearCache(String prefix, String suffix) {
        Set allCacheKeys = this.getPageCache().getAll().keySet();
        List keys = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)prefix) && kd.bos.util.StringUtils.isNotEmpty((String)suffix)) {
            keys = allCacheKeys.stream().filter(e -> e.startsWith(prefix) && e.endsWith(suffix)).collect(Collectors.toList());
        } else if (kd.bos.util.StringUtils.isNotEmpty((String)prefix)) {
            keys = allCacheKeys.stream().filter(e -> e.startsWith(prefix)).collect(Collectors.toList());
        } else if (kd.bos.util.StringUtils.isNotEmpty((String)suffix)) {
            keys = allCacheKeys.stream().filter(e -> e.endsWith(suffix)).collect(Collectors.toList());
        }
        if (keys != null && keys.size() > 0) {
            this.getPageCache().batchRemove(keys);
        }
    }

    private void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int size, int index) {
        if (index == size - 1) {
            sb.append(name);
        } else {
            sb.append(name).append(",");
        }
    }

    private List<Map<String, String>> getMultiSelectF7ReturnValue(List<Map<String, String>> list, String actionId, Long viewId) {
        ArrayList<Map<String, String>> listNew = new ArrayList<Map<String, String>>(16);
        String number = this.getDimNumByCtrlKey(actionId);
        if (kd.bos.util.StringUtils.isEmpty((String)number)) {
            return listNew;
        }
        for (Map<String, String> map : list) {
            Member member = ModelCacheServiceHelper.getMember((Model)this.getModelCacheHelper().getModelobj(), (String)number, (Long)viewId, (String)map.get("number"));
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            memberMap.put("id", member.getId().toString());
            memberMap.put("scope", map.get("scope"));
            memberMap.put("number", member.getNumber());
            memberMap.put("name", member.getName());
            memberMap.put("pid", member.getParentId().toString());
            listNew.add(memberMap);
        }
        return listNew;
    }

    private long getMulSelViewId(String actionId) {
        long viewId = 0L;
        String viewIdStr = this.getCache(actionId + "viewId");
        if (!kd.bos.util.StringUtils.isEmpty((String)viewIdStr)) {
            viewId = Long.parseLong(viewIdStr);
        }
        return viewId;
    }

    protected String getBeforeF7Key(BeforeF7SelectEvent e) {
        return e.getProperty().getName();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = this.getBeforeF7Key(e);
        String dimNumber = this.getDimNumByCtrlKey(key);
        if (kd.bos.util.StringUtils.isNotEmpty((String)dimNumber)) {
            String cache;
            Long modelId = this.getModelId();
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            Long dataSetId = this.getDataSetId();
            f7Param.setDatasetId(dataSetId);
            f7Param.setBusModelId(Long.valueOf(ReportQueryHelper.getDataModelByDataSetId(dataSetId)));
            Long viewId = this.getDimViewId(key, dimNumber, dataSetId);
            f7Param.setViewId(viewId);
            f7Param.setEnableView(!this.isFromTargetCusReport());
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            if ("Entity".equals(dimNumber)) {
                qFilterList.add(new QFilter("isoffsetentry", "=", (Object)false));
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)(cache = this.getCache(key)))) {
                Map map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
                f7Param.setSelectIds(Collections.singleton(IDUtils.toLong(map.get("id"))));
            }
            this.addTargetDataFilter(dimNumber, qFilterList);
            f7Param.addCustomFilter(qFilterList);
            f7Param.setHideDecompose(false);
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        }
        this.setListShowFilter(e);
        if ("dataset".equals(key)) {
            e.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        return this.getDimNumByCtrlKey(controlKey);
    }

    private void setListShowFilter(BeforeF7SelectEvent e) {
        if (kd.bos.util.StringUtils.isEmpty((String)this.getCache("customdimfielter"))) {
            return;
        }
        String f7Kkey = e.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        Map allMap = (Map)SerializationUtils.fromJsonString((String)this.getCache("allPoint"), Map.class);
        Map customMap = (Map)SerializationUtils.fromJsonString((String)this.getCache("customdimfielter"), Map.class);
        if (allMap.containsKey(f7Kkey)) {
            String f7Entity = (String)((Map)allMap.get(f7Kkey)).get("number");
            for (Map.Entry entity : customMap.entrySet()) {
                if (!((String)entity.getKey()).equalsIgnoreCase(f7Entity)) continue;
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", entity.getValue()));
                break;
            }
        }
    }

    private void doDimMulSelectClick(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String number = this.getDimNumByCtrlKey(key);
        if (kd.bos.util.StringUtils.isEmpty((String)number)) {
            return;
        }
        Long modelId = this.getModelId();
        Long dataSetId = this.getDataSetId();
        Long bizModel = this.getModelCacheHelper().getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        this.addTargetDataFilter(number, qFilters);
        String curRowColTabKey = this.getCurRowColTabKey(key.contains("row"));
        String cacheCurTabF7Key = key + "_" + curRowColTabKey;
        long viewId = this.getDimViewId(cacheCurTabF7Key, number, dataSetId);
        String value = this.getModel().getDataEntity().getString(key);
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            this.getView().getPageCache().remove(cacheCurTabF7Key);
        }
        RangeF7Param param = new RangeF7Param();
        param.setBizModelId(bizModel);
        param.setDatasetId(dataSetId);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        param.setqFilters(qFilters);
        param.setSign(cacheCurTabF7Key);
        param.setEnableView(!this.isFromTargetCusReport());
        param.setNeedPermCheck(true);
        param.setQueryDecompose(true);
        CustomF7utils.openCustomF7Range((Long)modelId, (String)number, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    private void addTargetDataFilter(String number, List<QFilter> qFilters) {
        List longNumbers;
        String tarCacheKey;
        String tarCache;
        if (this.isFromTargetCusReport() && kd.bos.util.StringUtils.isNotEmpty((String)(tarCache = this.getCache(tarCacheKey = "cache_tar_" + number))) && CollectionUtils.isNotEmpty((Collection)(longNumbers = (List)SerializationUtils.fromJsonString((String)tarCache, List.class)))) {
            QFilter qFilter = new QFilter("longnumber", "like", (Object)((String)longNumbers.get(0) + "%"));
            if (longNumbers.size() > 1) {
                for (int i = 1; i < longNumbers.size(); ++i) {
                    qFilter.or(new QFilter("longnumber", "like", (Object)((String)longNumbers.get(i) + "%")));
                }
            }
            qFilters.add(qFilter);
        }
    }

    protected long getDimViewId(String sign, String dimNumber, long dataSetId) {
        Map viewGroupViewsByDataSet;
        String targetDimView;
        if (this.isFromTargetCusReport() && (targetDimView = this.getPageCache().get("targetDimView")) != null) {
            Map targetView = (Map)SerializationUtils.fromJsonString((String)targetDimView, Map.class);
            Dimension dimension = this.getModelCacheHelper().getDimension(dimNumber);
            if (dimension != null && targetView.containsKey(dimension.getId() + "")) {
                return (Long)targetView.get(dimension.getId() + "");
            }
        }
        long viewId = 0L;
        if (sign != null && this.getPageCache().get(sign + "viewId") != null) {
            viewId = Long.parseLong(this.getPageCache().get(sign + "viewId"));
        }
        if (viewId == 0L && (viewGroupViewsByDataSet = this.getModelCacheHelper().getViewsByDataSet(Long.valueOf(dataSetId))).containsKey(dimNumber)) {
            viewId = (Long)viewGroupViewsByDataSet.get(dimNumber);
        }
        return viewId;
    }

    private void doDropEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        String[] msg = this.translateMessage(eventArgs);
        String target = msg[0];
        String source = msg[1];
        if (ReportQueryHelper.checkControlKey(source)) {
            this.interChange(target, source);
            this.getModel().getDataEntity();
            this.bindCtrlMapping();
            this.getPageCache().put("drop", "1");
            this.initPageData();
            this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
            this.getPageCache().remove("drop");
        }
    }

    private void interChange(String target, String source) {
        String sourcePanel = "";
        Map<String, Map<String, String>> dimMap = this.getPointEntry();
        if (dimMap.containsKey(source)) {
            sourcePanel = dimMap.get(source).get("panel");
        }
        long dataSetId = this.getDataSetId();
        boolean targetIsF7Control = target.startsWith("ebf7");
        String targetControl = targetIsF7Control ? target : null;
        String string = target = targetIsF7Control ? dimMap.get(target).get("panel") : target;
        if (!kd.bos.util.StringUtils.isEmpty((String)sourcePanel) && !kd.bos.util.StringUtils.isEmpty((String)target)) {
            String sourceOwner = this.getParentPanel(source);
            if (sourcePanel.equals(target)) {
                Map<String, String> sourceF7Key = dimMap.get(source);
                LinkedHashMap newDimMap = new LinkedHashMap(16);
                if (targetControl == null) {
                    dimMap.put(source, sourceF7Key);
                } else {
                    dimMap.forEach((dim, dimInfo) -> {
                        if (targetControl.equals(dim)) {
                            newDimMap.put(source, sourceF7Key);
                        }
                        if (!dim.equals(source)) {
                            newDimMap.put(dim, dimInfo);
                        }
                    });
                    dimMap.clear();
                    dimMap.putAll(newDimMap);
                }
            } else if ("pagedimpanel1".equals(target)) {
                String baseF7Key = ReportQueryHelper.getCtrlKeyPrefix(source);
                String f7Key = baseF7Key + "_page";
                this.updataDimMap(f7Key, source, target, dimMap, targetControl);
                String sourceCacheF7Key = source + "_" + this.getCurRowColTabKey("rowdimpanel1".equals(sourcePanel));
                String dimIdStr = this.getCache(sourceCacheF7Key);
                if (!kd.bos.util.StringUtils.isEmpty((String)dimIdStr)) {
                    long sourceDimViewId = this.getDimViewId(sourceCacheF7Key, this.getDimNumByCtrlKey(f7Key), dataSetId);
                    List curDimMap = (List)SerializationUtils.fromJsonString((String)dimIdStr, List.class);
                    if (curDimMap.size() > 0) {
                        this.setCache(f7Key, SerializationUtils.toJsonString(curDimMap.get(0)));
                        this.cacheCurPartDimViewId(f7Key, sourceDimViewId);
                    }
                }
                this.updateRowColPartAfterMoveOut(source);
            } else if ("pagedimpanel".equals(sourceOwner) && ("rowdimpanel1".equals(target) || "coldimpanel1".equals(target))) {
                Map curDimMap;
                String suffix = "rowdimpanel1".equals(target) ? "row" : "col";
                String baseF7Key = ReportQueryHelper.getCtrlKeyPrefix(source);
                String f7Key = baseF7Key + "_" + suffix;
                this.updataDimMap(f7Key, source, target, dimMap, targetControl);
                if (this.getCache(source) != null && (curDimMap = (Map)SerializationUtils.fromJsonString((String)this.getCache(source), Map.class)) != null) {
                    long dimViewId = this.getDimViewId(source, this.getDimNumByCtrlKey(f7Key), dataSetId);
                    ArrayList<Map> list = new ArrayList<Map>(10);
                    list.add(curDimMap);
                    List<String> tabKeys = this.getRowColPartTabKeys("rowdimpanel1".equals(target));
                    for (String tabKey : tabKeys) {
                        String cutPartF7Key = this.getCurPartF7Key(f7Key, tabKey);
                        this.setCache(cutPartF7Key, SerializationUtils.toJsonString(list));
                        this.cacheCurPartDimViewId(cutPartF7Key, dimViewId);
                    }
                }
                this.clearCache(source);
                this.clearCurPartDimViewId(source);
                this.updateRowColPartAfterMoveIn(f7Key);
            } else if ("rowdimpanel".equals(sourceOwner) && "coldimpanel1".equals(target) || "coldimpanel".equals(sourceOwner) && "rowdimpanel1".equals(target)) {
                String suffix = "rowdimpanel1".equals(target) ? "row" : "col";
                String baseF7Key = ReportQueryHelper.getCtrlKeyPrefix(source);
                String f7Key = baseF7Key + "_" + suffix;
                this.updataDimMap(f7Key, source, target, dimMap, targetControl);
                String sourceCacheF7Key = this.getCurPartF7Key(source, this.getCurRowColTabKey("rowdimpanel".equals(sourceOwner)));
                String dimsStr = this.getCache(sourceCacheF7Key);
                if (!kd.bos.util.StringUtils.isEmpty((String)dimsStr)) {
                    List<String> tabKeys = this.getRowColPartTabKeys("rowdimpanel1".equals(target));
                    long sourceDimViewId = this.getDimViewId(sourceCacheF7Key, this.getDimNumByCtrlKey(f7Key), dataSetId);
                    for (String tabKey : tabKeys) {
                        String cutPartF7Key = this.getCurPartF7Key(f7Key, tabKey);
                        this.setCache(cutPartF7Key, dimsStr);
                        this.cacheCurPartDimViewId(cutPartF7Key, sourceDimViewId);
                    }
                }
                this.updateRowColPartAfterSwitch(f7Key, source);
            }
        }
        this.setAllDimCtrlCache(dimMap);
        this.setAllDimCache(dimMap);
    }

    private void setAllDimCtrlCache(Map<String, Map<String, String>> ctlsMap) {
        this.getPageCache().put("allPoint", SerializationUtils.toJsonString(ctlsMap));
        this.setBaseF7Mapping(ctlsMap);
    }

    private void setBaseF7Mapping(Map<String, Map<String, String>> allDimMap) {
        LinkedHashMap<String, String> allDimCtrlMap = new LinkedHashMap<String, String>(16);
        Set<String> f7CtrlSet = allDimMap.keySet();
        for (String f7Ctrl : f7CtrlSet) {
            String baseF7Key = ReportQueryHelper.getCtrlKeyPrefix(f7Ctrl);
            allDimCtrlMap.put(baseF7Key, f7Ctrl);
        }
        this.setCache("f7_basemapping_cache", SerializationUtils.toJsonString(allDimCtrlMap));
    }

    private void updataDimMap(String f7Key, String sourceF7, String target, Map<String, Map<String, String>> dimMap, String targetControl) {
        this.addDimMap(f7Key, sourceF7, target, dimMap, targetControl);
        dimMap.remove(sourceF7);
    }

    private void addDimMap(String f7Key, String sourceF7, String target, Map<String, Map<String, String>> dimMap, String targetControl) {
        Map<String, String> map = dimMap.get(sourceF7);
        map.put("panel", target);
        map.put("sign", f7Key);
        if (targetControl == null) {
            dimMap.put(f7Key, map);
        } else {
            LinkedHashMap newDimMap = new LinkedHashMap(16);
            dimMap.forEach((dim, dimInfo) -> {
                if (targetControl.equals(dim)) {
                    newDimMap.put(f7Key, map);
                }
                newDimMap.put(dim, dimInfo);
            });
            dimMap.clear();
            dimMap.putAll(newDimMap);
        }
    }

    private String getParentPanel(String source) {
        String result = "";
        if (kd.bos.util.StringUtils.isEmpty((String)source)) {
            return result;
        }
        String suffix = ReportQueryHelper.getCtrlKeySuffix(source);
        if (suffix.equalsIgnoreCase("page")) {
            result = "pagedimpanel";
        } else if (suffix.equalsIgnoreCase("row")) {
            result = "rowdimpanel";
        } else if (suffix.equalsIgnoreCase("col")) {
            result = "coldimpanel";
        }
        return result;
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    protected void loadDatasetDimData() {
        Long modelId = this.getModelId();
        Long datasetId = this.getDataSetId();
        Map<String, List<DynamicObject>> dataSetDimDysMap = this.getDataSetDimDysMap(modelId, datasetId);
        this.initDefaultPanelDims(dataSetDimDysMap, modelId, datasetId);
    }

    private void loadDimPanelData() {
        Page page = new Page();
        this.buildUpdateAreaPanel(this.getPointEntry("row"), page, "rowdimpanel");
        this.buildUpdateAreaPanel(this.getPointEntry("col"), page, "coldimpanel");
        this.buildUpdateAreaPanel(this.getPointEntry("page"), page, "pagedimpanel");
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.allDrag(this.getView(), page);
    }

    public void buildUpdateAreaPanel(List<Map<String, String>> pageDimList, Page page, String areaPanel) {
        Area area = new Area(areaPanel);
        Style sl = this.getStyle();
        for (Map<String, String> dimInfo : pageDimList) {
            BaseEditElement f7;
            if (dimInfo == null) continue;
            String number = dimInfo.get("number");
            Dimension dimension = this.getModelCacheHelper().getDimension(number);
            String name = dimension != null ? dimension.getName() : dimInfo.get("name");
            String sign = dimInfo.get("sign");
            if ("pagedimpanel".equals(areaPanel) || "listpagedimpanel".equals(areaPanel)) {
                f7 = new BaseEditElement(name, sign, SysDimensionEnum.getMemberTreemodelByNumber((String)number));
                f7.setDisplayProp("name");
            } else {
                f7 = new TextEditElement(name, sign, SysDimensionEnum.getMemberTreemodelByNumber((String)number));
                ((TextEditElement)f7).setNumber(number);
            }
            f7.addUserObject("memList", null);
            f7.addUserObject("id", (Object)dimInfo.get("id"));
            f7.setHeight(new LocaleString("45px"));
            f7.setStyle(sl);
            f7.setWidth(new LocaleString("220px"));
            f7.setFontSize(12);
            f7.setFieldTextAlign("left");
            f7.setLabelDirection("v");
            area.addElement((Element)f7);
        }
        page.addArea(area);
    }

    private Style getStyle() {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("12px");
        mg.setBottom("0");
        mg.setRight("0");
        mg.setLeft("10px");
        sl.setMargin(mg);
        return sl;
    }

    private void loadPartitionData() {
        List<Map<String, String>> pageDimList = this.getPointEntry("page");
        this.initRowColDimData(true);
        this.initRowColDimData(false);
        for (Map<String, String> dimInfo : pageDimList) {
            String sign = dimInfo.get("sign");
            String cache = this.getCache(sign);
            if (kd.bos.util.StringUtils.isEmpty((String)cache)) {
                this.getModel().setValue(sign, (Object)"");
                continue;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            this.getModel().setValue(sign, (Object)IDUtils.toLong(map.get("id")));
        }
        this.getView().updateView("pagedimpanel");
    }

    private void initRowColDimData(boolean isRow) {
        Tab tab = (Tab)this.getControl(isRow ? "rowtabap" : "coltabap");
        String currentTab = tab.getCurrentTab();
        if (currentTab != null) {
            List<String> curPartF7Keys = this.getCurPartF7Keys(currentTab);
            for (String curPartF7Key : curPartF7Keys) {
                String cache = this.getCache(curPartF7Key);
                String f7Key = curPartF7Key.replace("_" + currentTab, "");
                if (cache != null && kd.bos.util.StringUtils.isNotEmpty((String)cache)) {
                    List list = (List)SerializationUtils.fromJsonString((String)cache, List.class);
                    ArrayList<String> names = new ArrayList<String>(list.size());
                    for (Map map : list) {
                        RangeEnum scope = RangeEnum.getRangeByVal((String)String.valueOf(map.get("scope")));
                        if (scope != null && scope != RangeEnum.ONLY) {
                            names.add((String)map.get("name") + scope.getName());
                            continue;
                        }
                        names.add((String)map.get("name"));
                    }
                    this.getModel().setValue(f7Key, (Object)String.join((CharSequence)",", names));
                    continue;
                }
                this.getModel().setValue(f7Key, (Object)"");
            }
        }
        this.getView().updateView(isRow ? "rowdimpanel" : "coldimpanel");
    }

    private boolean returnTemplateModelData(boolean isNeedShowTips, String operationKey, boolean isCheck, boolean noCheckMemberValue) {
        ArrayList<String> params;
        this.clearCache("changeByDataSet");
        ITemplateModel templateModel = null;
        String tab = this.getCache("cache_tab");
        if (tab == null) {
            tab = (String)this.getFormCustomParam("cache_tab");
        }
        if (tab.equalsIgnoreCase("tab_dimset") || tab.equalsIgnoreCase("tab_myinterest")) {
            Long dataSetId = this.getDataSetId();
            templateModel = this.createTemplateModel(dataSetId, isNeedShowTips, isCheck, noCheckMemberValue);
        }
        if (templateModel == null) {
            if (operationKey.equals("openFloatDesigner")) {
                params = new ArrayList();
                params.add(this.getCurNodeId());
                params.add(operationKey);
                ITemplateModel templateModelFromShowParam = this.getTemplateModelFromShowParam();
                if (templateModelFromShowParam == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efa\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bbe\u8ba1\u533a\u8bbe\u7f6e\u3002", (String)"ReportQueryDesigner_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                params.add(TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModelFromShowParam));
                params.add(SerializationUtils.toJsonString(this.getPointEntry()));
                CommandParam commandParam = new CommandParam("eb_rptquerydesigner", "eb_reportqueryprocess", "dimdesigner", new Object[0]);
                commandParam.setParam(params);
                this.sendMsg(this.getView(), commandParam);
            }
            return false;
        }
        params = new ArrayList<String>();
        params.add(this.getCurNodeId());
        String isDatasetChange = this.getCache("isDatasetChange");
        if ("true".equals(isDatasetChange)) {
            params.add("datasetChange");
            this.removeCache("isDatasetChange");
        } else {
            params.add(operationKey);
        }
        params.add(TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        params.add(SerializationUtils.toJsonString(this.getPointEntry()));
        if (this.isFromTargetCusReport()) {
            params.add(this.getCache("needLockDim"));
        }
        CommandParam commandParam = new CommandParam("eb_rptquerydesigner", "eb_reportqueryprocess", "dimdesigner", new Object[0]);
        commandParam.setParam(params);
        this.sendMsg(this.getView(), commandParam);
        return true;
    }

    private boolean isFromShare() {
        QFilter qFilter1 = new QFilter("receiver", "=", (Object)ReportQueryHelper.getUserId());
        QFilter qFilter2 = new QFilter("sharestatus", "=", (Object)"A");
        QFilter qFilter3 = new QFilter("modelid", "=", (Object)this.getModelId());
        String curTreeNodId = this.getCurNodeId();
        TreeNode root = this.getCacheTreeNode();
        if (root == null) {
            return false;
        }
        TreeNode curNode = root.getTreeNode(curTreeNodId, 10);
        if (curNode == null) {
            return false;
        }
        Map dataMap = (Map)curNode.getData();
        if (dataMap == null) {
            return false;
        }
        QFilter qFilter4 = new QFilter("number", "=", dataMap.get("number"));
        QFilter qfilter = qFilter1.and(qFilter2).and(qFilter3).and(qFilter4);
        return QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])qfilter.toArray());
    }

    private TreeNode getCacheTreeNode() {
        Object formCustomParam = this.getFormCustomParam("cache_tree_node");
        if (formCustomParam != null) {
            return (TreeNode)SerializationUtils.fromJsonString((String)formCustomParam.toString(), TreeNode.class);
        }
        return null;
    }

    private String getReportQueryId() {
        return (String)this.getFormCustomParam("reportqueryid");
    }

    private String getCurNodeId() {
        return (String)this.getFormCustomParam("cur_node_id");
    }

    private ITemplateModel createTemplateModel(Long dataSetId, Boolean isNeedShowTips, Boolean isCheck, Boolean noCheckMemberValue) {
        DefaultDimension dimEntity;
        Long modelId = this.getModelId();
        Long bizModelId = this.getModelCacheHelper().getBusModelByDataSet(dataSetId);
        ITemplateModel templateModel = this.newTemplateModel(dataSetId, null);
        ArrayList<Map> page = new ArrayList<Map>(16);
        ArrayList<Map<String, String>> row = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> rank = new ArrayList<Map<String, String>>(16);
        templateModel.getViewpointmembentry().clear();
        templateModel.getPagemembentry().clear();
        templateModel.getAreaRangeEntry().getRowdimensions().clear();
        templateModel.getAreaRangeEntry().getColdimensions().clear();
        boolean hasCurrency = false;
        Map<String, Map<String, String>> allDimMap = this.getPointEntry();
        ArrayList<Map<String, String>> valueList = new ArrayList<Map<String, String>>(allDimMap.values());
        Map metricDimMap = null;
        List<String> curRowTabKeys = this.getRowColPartTabKeys(true);
        List<String> curColTabKeys = this.getRowColPartTabKeys(false);
        for (Map map : valueList) {
            String partIndex;
            String partF7Key;
            if (map.get("sign") != null && ((String)map.get("sign")).startsWith("ebf7_metric")) {
                metricDimMap = map;
            }
            if ("pagedimpanel1".equals(map.get("panel"))) {
                String value = this.getCache((String)map.get("sign"));
                if (!((map.containsKey("hide") && !((String)map.get("hide")).equalsIgnoreCase("1") || value != null && !kd.bos.util.StringUtils.isEmpty((String)value)) && !"{}".equals(value) || noCheckMemberValue.booleanValue())) {
                    Dimension dimension = this.modelCacheHelper.getDimension((String)map.get("number"));
                    String string = dimension != null ? dimension.getName() : "";
                    this.showViewMsg(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4[%1]\u6210\u5458\u3002", (String)"ReportQueryDesigner_4", (String)"epm-eb-formplugin", (Object[])new Object[]{string}), isNeedShowTips);
                    if (isCheck.booleanValue()) {
                        return null;
                    }
                }
                page.add(map);
            } else if ("coldimpanel1".equals(map.get("panel"))) {
                int i = 0;
                for (String partKey : curColTabKeys) {
                    ++i;
                    partF7Key = (String)map.get("sign") + "_" + partKey;
                    if (this.getCache(partF7Key) != null && !kd.bos.util.StringUtils.isEmpty((String)this.getCache(partF7Key)) && ((List)SerializationUtils.fromJsonString((String)this.getCache(partF7Key), List.class)).size() != 0 || noCheckMemberValue.booleanValue()) continue;
                    partIndex = curColTabKeys.size() == 1 ? "" : String.valueOf(i);
                    this.showViewMsg(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9[\u5217\u533a%1]\u7684[%2]\u6210\u5458\u3002", (String)"ReportQueryDesigner_5", (String)"epm-eb-formplugin", (Object[])new Object[]{partIndex, map.get("name")}), isNeedShowTips);
                    if (!isCheck.booleanValue()) continue;
                    return null;
                }
                rank.add(map);
            } else if ("rowdimpanel1".equals(map.get("panel"))) {
                int i = 0;
                for (String partKey : curRowTabKeys) {
                    ++i;
                    partF7Key = (String)map.get("sign") + "_" + partKey;
                    if (this.getCache(partF7Key) != null && !kd.bos.util.StringUtils.isEmpty((String)this.getCache(partF7Key)) && ((List)SerializationUtils.fromJsonString((String)this.getCache(partF7Key), List.class)).size() != 0 || noCheckMemberValue.booleanValue()) continue;
                    partIndex = curRowTabKeys.size() == 1 ? "" : String.valueOf(i);
                    this.showViewMsg(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9[\u884c\u533a%1]\u7684[%2]\u6210\u5458\u3002", (String)"ReportQueryDesigner_6", (String)"epm-eb-formplugin", (Object[])new Object[]{partIndex, map.get("name")}), isNeedShowTips);
                    if (!isCheck.booleanValue()) continue;
                    return null;
                }
                row.add(map);
            }
            if (!((String)map.get("number")).equals(SysDimensionEnum.Currency.getNumber())) continue;
            hasCurrency = true;
        }
        if (row.size() < 1 || row.size() == 1 && "ebf7_metric_row".equals(((Map)row.get(0)).get("sign"))) {
            this.showViewMsg(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u81f3\u5c11\u4e00\u4e2a\u975e\u5ea6\u91cf\u7ef4\u5ea6\u4f5c\u4e3a\u884c\u7ef4\u5ea6\u3002", (String)"ReportQueryDesigner_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), isNeedShowTips);
            if (isCheck.booleanValue()) {
                return null;
            }
        }
        if (rank.size() < 1 || rank.size() == 1 && "ebf7_metric_col".equals(((Map)rank.get(0)).get("sign"))) {
            this.showViewMsg(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u81f3\u5c11\u4e00\u4e2a\u975e\u5ea6\u91cf\u7ef4\u5ea6\u4f5c\u4e3a\u5217\u7ef4\u5ea6\u3002", (String)"ReportQueryDesigner_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), isNeedShowTips);
            if (isCheck.booleanValue()) {
                return null;
            }
        }
        for (Map map : page) {
            DefaultPageDimensionEntry dimensionEntry = new DefaultPageDimensionEntry();
            dimensionEntry.setDimension((IDimension)new DefaultDimension(Long.valueOf((String)map.get("id") + ""), (String)map.get("name"), (String)map.get("number"), Integer.valueOf((String)map.get("seq"))));
            String cacheValue = this.getCache((String)map.get("sign"));
            if (cacheValue == null) continue;
            Map map2 = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
            String memName = (String)map2.get("name");
            Long memId = IDUtils.toLong(map2.get("id"));
            Long viewGroupByBusModelAndDimNumber = this.getModelCacheHelper().getViewGroupByBusModelAndDimNumber(bizModelId, dimensionEntry.getDimension().getNumber());
            long dimViewId = this.getDimViewId((String)map.get("sign"), (String)map.get("number"), dataSetId);
            Set hasPermMemberIds = DimMembPermHelper.getReadPermMembIds((String)((String)map.get("number")), (Long)modelId, (Long)bizModelId, (Long)dimViewId, (boolean)true);
            if (hasPermMemberIds != null && !hasPermMemberIds.contains(memId) && isCheck.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u201c%1\u201d\u7ef4\u5ea6\u201c%2\u201d\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"ReportQueryDesigner_9", (String)"epm-eb-formplugin", (Object[])new Object[]{map.get("name"), memName}));
                return null;
            }
            dimensionEntry.addOneMember((IDimensionMember)new DefaultDimMember(IDUtils.toLong(map2.get("id")), map2.get("name") + "", map2.get("number") + "", RangeEnum.ONLY.getIndex()));
            templateModel.addPagemembentry((IPageDimensionEntry)dimensionEntry);
            this.setDimensionViews(templateModel, (String)map.get("entity"), (String)map.get("number"), dimViewId);
        }
        IAreaRangeEntry dimensionEntry = templateModel.getAreaRangeEntry();
        Boolean bl = this.getMetricPosition();
        dimensionEntry.setMetricInRow(bl);
        Map<Long, List<PropertyObj>> dimPropertys = TemplateModelHelper.getDimensionPropertys(templateModel.getModelId(), row, rank);
        for (Map map : row) {
            dimEntity = new DefaultDimension(Long.valueOf((String)map.get("id") + ""), (String)map.get("name"), (String)map.get("number"), Integer.valueOf((String)map.get("seq")));
            dimensionEntry.addRowdimension((IDimension)dimEntity);
            for (int i = 0; i < curRowTabKeys.size(); ++i) {
                this.setDimensionViews(templateModel, (String)map.get("entity"), (String)map.get("number") + "_" + "r" + i, this.getDimViewId(this.getCurPartF7Key((String)map.get("sign"), curRowTabKeys.get(i)), (String)map.get("number"), dataSetId));
            }
        }
        for (Map map : rank) {
            dimEntity = new DefaultDimension(Long.valueOf((String)map.get("id") + ""), (String)map.get("name"), (String)map.get("number"), Integer.valueOf((String)map.get("seq")));
            dimensionEntry.addColdimension((IDimension)dimEntity);
            for (int i = 0; i < curColTabKeys.size(); ++i) {
                this.setDimensionViews(templateModel, (String)map.get("entity"), (String)map.get("number") + "_" + "c" + i, this.getDimViewId(this.getCurPartF7Key((String)map.get("sign"), curColTabKeys.get(i)), (String)map.get("number"), dataSetId));
            }
        }
        DefaultPartitionSetting partitionSetting = new DefaultPartitionSetting();
        templateModel.setPartitionSetting((IPartitionSetting)partitionSetting);
        String string = "A1";
        String tf = "0";
        String tfc = "10";
        PartitionInfo partitionInfo = new PartitionInfo(string, null);
        partitionInfo.setTimeOffset(new TimeOffset(Integer.parseInt(tf), Integer.parseInt(tfc)));
        String actdata = this.getCache("actdata");
        if (actdata != null) {
            int intStr;
            if (actdata.startsWith("partition.row")) {
                partitionInfo.setActualDataInRow(Boolean.valueOf(true));
                intStr = Integer.parseInt(actdata.substring("partition.row.".length()));
                partitionInfo.setActualDataPartitionNumber(Integer.valueOf(intStr));
            } else if (actdata.startsWith("partition.rank")) {
                partitionInfo.setActualDataInRow(Boolean.valueOf(false));
                intStr = Integer.parseInt(actdata.substring("partition.rank.".length()));
                partitionInfo.setActualDataPartitionNumber(Integer.valueOf(intStr));
            }
        }
        partitionSetting.setPartitionInfo(partitionInfo);
        DefaultHeaderAreaSetting headerAreaSetting = new DefaultHeaderAreaSetting();
        HeaderAreaInfo headerAreaInfo = new HeaderAreaInfo();
        HashMap headerTable = new HashMap(16);
        headerAreaSetting.setHeaderTable(headerTable);
        headerAreaSetting.setHeaderAreaInfo(headerAreaInfo);
        templateModel.setHeadAreaSetting((IHeaderAreaSetting)headerAreaSetting);
        boolean existError1 = this.fillDimInfo((IPartitionSetting)partitionSetting, "coldimpanel1", rank, metricDimMap, dimPropertys, modelId, bizModelId, isCheck);
        boolean existError2 = this.fillDimInfo((IPartitionSetting)partitionSetting, "rowdimpanel1", row, metricDimMap, dimPropertys, modelId, bizModelId, isCheck);
        if (existError1 || existError2) {
            return null;
        }
        templateModel.getHidedimentry().clear();
        for (IDimension d : this.allDims) {
            if (!d.getNumber().equals(SysDimensionEnum.Scenario.getNumber()) && !d.getNumber().equals(SysDimensionEnum.Process.getNumber()) && (hasCurrency || !d.getNumber().equals(SysDimensionEnum.Currency.getNumber()))) continue;
            DefaultViewPointDimensionEntry dimEntry = new DefaultViewPointDimensionEntry();
            dimEntry.setDimension((IDimension)new DefaultDimension(d.getId(), d.getName(), d.getNumber(), d.getDSeq()));
            dimEntry.setMember((IDimensionMember)new DefaultDimMember(null, null, this.getDefaultDimMember(d.getNumber()), 0));
            templateModel.addHidedimentry((IViewPointDimensionEntry)dimEntry);
        }
        return templateModel;
    }

    private void setAllDims(Boolean forceRefresh) {
        if (this.getModelId() == 0L) {
            return;
        }
        if (!forceRefresh.booleanValue() && this.getCache("cache_alldims") != null) {
            this.allDims = (List)ObjectSerialUtil.deSerializedBytes((String)this.getCache("cache_alldims"));
        } else {
            List dims = this.getModelCacheHelper().getDimensionList();
            this.allDims = new ArrayList<IDimension>(16);
            dims.forEach(d -> {
                DefaultDimension dim = new DefaultDimension();
                dim.setId(d.getId());
                dim.setNumber(d.getNumber());
                dim.setName(d.getName());
                dim.setDSeq(Integer.valueOf(d.getSeq()));
                dim.setMemberModel(d.getMemberModel());
                dim.setFieldMapped(d.getFieldMapped());
                this.allDims.add((IDimension)dim);
            });
        }
        this.setCache("cache_alldims", ObjectSerialUtil.toByteSerialized(this.allDims));
    }

    private String getDefaultDimMember(String dimNumber) {
        String defaltDimMember = null;
        if (dimNumber.equals(SysDimensionEnum.Scenario.getNumber())) {
            defaltDimMember = "NoScenario";
        } else if (dimNumber.equals(SysDimensionEnum.Process.getNumber())) {
            defaltDimMember = "IRpt";
        } else if (dimNumber.equals(SysDimensionEnum.AuditTrail.getNumber())) {
            defaltDimMember = "EntityInput";
        } else if (dimNumber.equals(SysDimensionEnum.DataType.getNumber())) {
            defaltDimMember = "Budget";
        } else if (dimNumber.equals(SysDimensionEnum.Currency.getNumber())) {
            defaltDimMember = "CNone";
        } else if (dimNumber.equals(SysDimensionEnum.InternalCompany.getNumber())) {
            defaltDimMember = "ICNone";
        } else if (dimNumber.equals(SysDimensionEnum.ChangeType.getNumber())) {
            defaltDimMember = "CurrentPeriod";
        }
        return defaltDimMember;
    }

    private boolean fillDimInfo(IPartitionSetting partitionSetting, String panel, List<Map<String, String>> dimtypeMap, Map<String, String> metricDim, Map<Long, List<PropertyObj>> dimPropertys, Long modelId, Long bizModelId, boolean isCheck) {
        ArrayList<RowColPartition> rowColPartition = new ArrayList<RowColPartition>(10);
        if (panel.equals("rowdimpanel1")) {
            partitionSetting.setRowPartition(rowColPartition);
        } else {
            partitionSetting.setColPartition(rowColPartition);
        }
        List<String> tabKeys = this.getRowColPartTabKeys(panel.equals("rowdimpanel1"));
        for (String tabKey : tabKeys) {
            RowColPartition p = new RowColPartition();
            rowColPartition.add(p);
            ArrayList<DefaultRowColDimensionEntry> pe = new ArrayList<DefaultRowColDimensionEntry>(16);
            p.setRowColDimensionEntries(pe);
            for (Map<String, String> dimtype : dimtypeMap) {
                Boolean isMetricInRow;
                String key = dimtype.get("sign");
                if (key.equals("ebf7_metric_row") || key.equals("ebf7_metric_col")) continue;
                DefaultRowColDimensionEntry rcde = new DefaultRowColDimensionEntry();
                pe.add(rcde);
                String number = dimtype.get("number");
                DefaultDimension dimEntity = new DefaultDimension(Long.valueOf(dimtype.get("id") + ""), dimtype.get("name"), number, Integer.valueOf(dimtype.get("seq")));
                rcde.setDimension((IDimension)dimEntity);
                ArrayList<DefaultDimMember> members = new ArrayList<DefaultDimMember>(16);
                rcde.setMembers(members);
                String curPartF7Key = this.getCurPartF7Key(key, tabKey);
                long dimViewId = this.getDimViewId(curPartF7Key, number, this.getDataSetId());
                if (this.getCache(curPartF7Key) != null && kd.bos.util.StringUtils.isNotEmpty((String)this.getCache(curPartF7Key))) {
                    List dimMaps = (List)SerializationUtils.fromJsonString((String)this.getCache(curPartF7Key), List.class);
                    List<Object> memIds = new ArrayList(10);
                    String memModel = dimtype.get("entity") + "";
                    boolean isMemberProp = SysDimensionEnum.Entity.getNumber().equals(number) || !SysDimensionEnum.include((String)number, (Boolean)false);
                    Set permMemIds = DimMembPermHelper.getPermMembIds((String)number, (Long)modelId, (Long)bizModelId, (Long)dimViewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                    Map memEntitys = DimensionPropertyServiceHelper.getInstance().queryMembersCustomProperties(memIds, memModel);
                    if (isMemberProp) {
                        StringBuilder errorMsg = new StringBuilder();
                        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
                        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                        for (Map map : dimMaps) {
                            DefaultDimMember dimMember;
                            String type = map.get("type") + "";
                            long id = IDUtils.toLong(map.get("id"));
                            String name = map.get("name") + "";
                            String dimNumber = map.get("number") + "";
                            if (kd.bos.util.StringUtils.isEmpty((String)type)) {
                                type = RangeF7PropertyCataEnum.Member.getIndex();
                            }
                            boolean valid = true;
                            if (RangeF7PropertyCataEnum.Member.getIndex().equals(type)) {
                                if (isCheck && permMemIds != null && !permMemIds.contains(id)) {
                                    errorMsg.append(name).append("\u3001");
                                    continue;
                                }
                                memIds.add(id);
                                dimMember = new DefaultDimMember(IDUtils.toLong((Object)(map.get("id") + "")), map.get("name") + "", map.get("number") + "", Integer.parseInt(map.get("scope") + ""));
                            } else {
                                Long propId = IDUtils.toLong(map.get("id"));
                                if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
                                    CustomProperty property;
                                    List propertyMemberSort = memberPropCache.getMembersByPropValues(modelCacheHelper.getDimension(number).getId(), Long.valueOf(dimViewId), propId);
                                    if (CollectionUtils.isEmpty((Collection)propertyMemberSort) && (property = memberPropCache.getProperty(propId)) != null) {
                                        CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(number, property.getNumber(), dimNumber);
                                        propertyMemberSort = memberPropCache.getMembersByPropValues(modelCacheHelper.getDimension(number).getId(), Long.valueOf(dimViewId), propertyValue.getId());
                                    }
                                    if (CollectionUtils.isNotEmpty((Collection)propertyMemberSort)) {
                                        if (permMemIds != null) {
                                            propertyMemberSort.removeIf(member -> !permMemIds.contains(member.getId()));
                                            if (CollectionUtils.isEmpty((Collection)propertyMemberSort)) {
                                                errorMsg.append(name).append("\u3001");
                                                valid = false;
                                            }
                                        }
                                    } else {
                                        errorMsg.append(name).append("\u3001");
                                        valid = false;
                                    }
                                }
                                dimMember = new DefaultDimMember(propId, map.get("name") + "", map.get("number") + "", Integer.parseInt(map.get("scope") + ""));
                            }
                            dimMember.setType(type);
                            TemplateModelHelper.setMemProperty(dimMember, memEntitys, rcde.getDimension().getPropertyEntries());
                            members.add(dimMember);
                            if (!valid) continue;
                            memIds.add(id);
                        }
                        if (memIds.isEmpty()) {
                            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\uff08%1\uff09\u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"ReportQueryDesigner_10", (String)"epm-eb-formplugin", (Object[])new Object[]{dimtype.get("name")}));
                            return true;
                        }
                    } else {
                        memIds = dimMaps.stream().map(mem -> IDUtils.toLong(mem.get("id"))).collect(Collectors.toList());
                        if (permMemIds != null && !permMemIds.containsAll(memIds) && isCheck) {
                            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\uff08%1\uff09\u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"ReportQueryDesigner_10", (String)"epm-eb-formplugin", (Object[])new Object[]{dimtype.get("name")}));
                            return true;
                        }
                        for (Map map : dimMaps) {
                            DefaultDimMember dimMember = new DefaultDimMember(IDUtils.toLong((Object)(map.get("id") + "")), map.get("name") + "", map.get("number") + "", Integer.parseInt(map.get("scope") + ""));
                            TemplateModelHelper.setMemProperty(dimMember, memEntitys, rcde.getDimension().getPropertyEntries());
                            members.add(dimMember);
                        }
                    }
                }
                if ((isMetricInRow = this.getMetricPosition()) == null || (!isMetricInRow.booleanValue() || !panel.equalsIgnoreCase("rowdimpanel1")) && (isMetricInRow.booleanValue() || !panel.equalsIgnoreCase("coldimpanel1"))) continue;
                ArrayList<DefaultMetricDimMmeber> metricmembers = new ArrayList<DefaultMetricDimMmeber>(16);
                p.setMetricDimMmebers(metricmembers);
                String cacheValue = this.getCache(metricDim.get("sign") + "_" + tabKey);
                if (cacheValue == null) continue;
                List metricMaps = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
                List memIds = metricMaps.stream().map(mem -> IDUtils.toLong(mem.get("id"))).collect(Collectors.toList());
                Set permMemIds = DimMembPermHelper.getReadPermMembIds((String)"Metric", (Long)modelId, (Long)bizModelId, null, (boolean)true);
                if (permMemIds != null && !permMemIds.containsAll(memIds) && isCheck) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1\u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"ReportQueryDesigner_11", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Metric.getChineseName()}));
                    return true;
                }
                for (Map map : metricMaps) {
                    DefaultMetricDimMmeber metricmem = new DefaultMetricDimMmeber();
                    metricmem.setId(Long.valueOf(map.get("id") + ""));
                    metricmem.setNumber(map.get("number") + "");
                    metricmem.setName(map.get("name") + "");
                    String decimalnum = map.get("decimalnum") == null ? "2" : map.get("decimalnum") + "";
                    metricmem.setDecimalnum(decimalnum);
                    metricmem.setShowNumber(map.get("showNumber") + "");
                    metricmembers.add(metricmem);
                }
            }
        }
        return false;
    }

    private Boolean getMetricPosition() {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        if (pointEntry.isEmpty()) {
            return null;
        }
        Set<String> f7Keys = pointEntry.keySet();
        if (f7Keys.contains("ebf7_metric_row")) {
            return true;
        }
        if (f7Keys.contains("ebf7_metric_col")) {
            return false;
        }
        return null;
    }

    private void setDimensionViews(ITemplateModel templateModel, String memberTree, String sign, Long viewId) {
        if (templateModel != null && sign != null && ("epm_entitymembertree".equals(memberTree) || "epm_userdefinedmembertree".equals(memberTree) || "epm_changetypemembertree".equals(memberTree) || "epm_icmembertree".equals(memberTree))) {
            if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                templateModel.getDimemsionViews().put(sign, viewId);
            } else {
                templateModel.getDimemsionViews().remove(sign);
            }
        }
    }

    private void showViewMsg(String msg, Boolean isShow) {
        if (isShow.booleanValue()) {
            this.getView().showTipNotification(msg);
        }
    }

    private ITemplateModel newTemplateModel(Long dataSetId, DynamicObject rptDy) {
        long modelId;
        DefaultTemplateModel templateModel = new DefaultTemplateModel();
        BgTemplate templateBaseInfo = new BgTemplate();
        if (rptDy != null) {
            templateBaseInfo.setId(Long.valueOf(rptDy.getLong("id")));
            templateBaseInfo.setName(rptDy.getString("name"));
            templateBaseInfo.setNumber(rptDy.getString("number"));
            templateBaseInfo.setDataunit(rptDy.getString("dataunit"));
            modelId = rptDy.getLong("model_id");
            templateBaseInfo.setModelID(Long.valueOf(modelId));
            templateBaseInfo.setCatalog(Long.valueOf(rptDy.getLong("reportCatalog_id")));
            templateBaseInfo.setVarBase((String)rptDy.get("varbaseforeb"));
            templateBaseInfo.setDatasetID(dataSetId);
            templateBaseInfo.setBizModel(this.getModelCacheHelper().getBusModelByDataSet(dataSetId));
            templateBaseInfo.setTemplatetype(Integer.parseInt(BgTemplateTypeEnum.DYNAMIC.getNumber()));
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date nowDate = TimeServiceHelper.getCurrentSystemTime();
            String tempId = format.format(nowDate);
            templateBaseInfo.setId(Long.valueOf(Long.parseLong(tempId)));
            templateBaseInfo.setName(tempId);
            templateBaseInfo.setNumber(tempId);
            templateBaseInfo.setDataunit("0");
            modelId = this.getModelId();
            templateBaseInfo.setModelID(Long.valueOf(modelId));
            templateBaseInfo.setCatalog(Long.valueOf(0L));
            templateBaseInfo.setVarBase("");
            templateBaseInfo.setDatasetID(dataSetId);
            templateBaseInfo.setBizModel(this.getModelCacheHelper().getBusModelByDataSet(dataSetId));
            templateBaseInfo.setTemplatetype(Integer.parseInt(BgTemplateTypeEnum.DYNAMIC.getNumber()));
        }
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        templateModel.setModelId(Long.valueOf(modelId));
        return templateModel;
    }

    protected boolean isWebScheme(DynamicObject querySchemeDy) {
        return true;
    }

    private void initDefaultPanelDims(Map<String, List<DynamicObject>> dataSetDimDysMap, Long modelId, Long dataSetId) {
        String dimNum;
        List<Long> defaultValues;
        List<String> initColDim;
        List<String> initRowDim;
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        DynamicObject querySchemeDy = ReportQueryHelper.getUserQuerySchemeDy(this.getUserId(), modelId, dataSetId, false);
        Map<String, Map<String, String>> userQueryScheme = new HashMap<String, Map<String, String>>(16);
        if (querySchemeDy != null) {
            String templateModelJson = querySchemeDy.getString("templatemodel");
            String dataJson = querySchemeDy.getString("data");
            if (kd.bos.util.StringUtils.isNotEmpty((String)templateModelJson) && !this.isFromTargetCusReport()) {
                ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateModelJson);
                ReportQueryDesignerHelper instance = ReportQueryDesignerHelper.getInstance();
                Map<String, Map<String, String>> pointEntry = instance.getPointEntryFromTemplateModel(templateModel, this.getDataSetId());
                this.setCache("allPoint", SerializationUtils.toJsonString(pointEntry));
                this.loadPageInfoByTemplateModel(templateModel);
                return;
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)dataJson)) {
                userQueryScheme = (Map)SerializationUtils.fromJsonString((String)dataJson, Map.class);
            }
        }
        this.setMetricGroupField(userQueryScheme);
        if (this.isFromTargetCusReport()) {
            initRowDim = this.getDefaultDimsByTargetData("rowdim", true);
            initColDim = this.getDefaultDimsByTargetData("coldim", true);
        } else {
            initRowDim = ReportQueryHelper.getDimsByQueryScheme("rowdim", userQueryScheme, true);
            initColDim = ReportQueryHelper.getDimsByQueryScheme("coldim", userQueryScheme, true);
        }
        ArrayList<String> rowColDims = new ArrayList<String>(16);
        rowColDims.addAll(initRowDim);
        rowColDims.addAll(initColDim);
        dataSetDimDysMap = ReportQueryHelper.orderMapByQuery(dataSetDimDysMap, rowColDims);
        ArrayList<String> rowCtrlKeys = new ArrayList<String>(16);
        ArrayList colCtrlKeys = new ArrayList(16);
        ArrayList pageCtrlKeys = new ArrayList(16);
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey("pagedimpanel");
        LinkedHashMap<String, Map<String, String>> ctlsMap = new LinkedHashMap<String, Map<String, String>>();
        if (dataSetDimDysMap.size() > 0) {
            for (Map.Entry<String, List<DynamicObject>> entity : dataSetDimDysMap.entrySet()) {
                String ctrKey;
                ArrayList<String> ctrlKeys;
                String suffix;
                if (entity.getValue() == null || entity.getValue().size() == 0) continue;
                DynamicObject dimDy = entity.getValue().get(0);
                String dimNumber = dimDy.getString("dimnum").toLowerCase();
                if (initRowDim.contains(dimNumber)) {
                    suffix = "row";
                    ctrlKeys = rowCtrlKeys;
                } else if (initColDim.contains(dimNumber)) {
                    suffix = "col";
                    ctrlKeys = colCtrlKeys;
                } else {
                    suffix = "page";
                    ctrlKeys = pageCtrlKeys;
                }
                if (ctlsMap.containsKey(ctrKey = ReportQueryDesignerHelper.getInstance().getControlKeyByDimNum(this.getModelId(), this.getDataSetId(), dimNumber, suffix))) continue;
                Map<String, String> map = this.getMapByDy(dimDy, suffix);
                if (dimNumber.equalsIgnoreCase("metric")) {
                    map.put("pos", this.getCache("metrigroupfield"));
                }
                ctlsMap.put(ctrKey, map);
                ctrlKeys.add(ctrKey);
            }
        }
        this.setCache("allPoint", SerializationUtils.toJsonString(ctlsMap));
        Long busModelId = ReportQueryHelper.getDataModelByDataSetId(dataSetId);
        Map<Long, Long> dimViewMap = ReportQueryHelper.getViewByDataSet(modelCache, dataSetId);
        Map<String, List<Long>> mappingMap = new HashMap(16);
        TargetSchemeService instance = TargetSchemeService.getInstance();
        long pkId = IDUtils.toLong((Object)this.getPkIdFromTargetData());
        String targetFlag = this.getTargetFlag();
        if ("scheme".equalsIgnoreCase(targetFlag)) {
            DynamicObject targetScheme = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bgm_targetscheme");
            DynamicObject dynamicObject = targetScheme.getDynamicObject("model");
            long srcModelId = dynamicObject.getLong("id");
            IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
            Map mappingNumberMap = instance.getMappingMapByTargetScheme(targetScheme, dynamicObject, srcModelId, srcModelCache, dataSetId.longValue(), false);
            List dimensionList = srcModelCache.getDimensionList(dataSetId);
            for (Map.Entry entry : mappingNumberMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                Optional<Dimension> first = dimensionList.stream().filter(x -> x.getNumber().equals(dimNumber)).findFirst();
                if (!first.isPresent()) continue;
                List memberNumbers = (List)entry.getValue();
                ArrayList<Long> memberNumberIds = new ArrayList<Long>(memberNumbers.size());
                for (String memberNumber : memberNumbers) {
                    Member member = srcModelCache.getMemberByAnyView(busModelId, dimNumber, memberNumber);
                    if (member == null) continue;
                    memberNumberIds.add(member.getId());
                }
                mappingMap.put(dimNumber, memberNumberIds);
            }
        } else if ("record".equalsIgnoreCase(targetFlag)) {
            mappingMap = instance.getMappingByTargetRecord(pkId, dataSetId.longValue(), busModelId);
        }
        if (this.isFromTargetCusReport() && !mappingMap.isEmpty()) {
            for (Map.Entry entry : mappingMap.entrySet()) {
                String key = (String)entry.getKey();
                Dimension dimension = this.getModelCacheHelper().getDimension(key);
                if (dimension == null || View.NoViewDimNums.contains(dimension.getNumber())) continue;
                Long viewGroupByBusModelAndDimNumber = this.getModelCacheHelper().getViewGroupByBusModelAndDimNumber(busModelId, key);
                Long viewId = dimViewMap.get(dimension.getId());
                Long search = DimensionViewServiceHelper.queryViewIdByMemberId((Long)modelId, (Long)busModelId, (Long)dimension.getId(), (Long)viewGroupByBusModelAndDimNumber, new HashSet((Collection)entry.getValue()), (Long)viewId);
                if (!IDUtils.isNotNull((Long)search)) continue;
                dimViewMap.put(dimension.getId(), search);
            }
            this.setCache("targetDimView", SerializationUtils.toJsonString(dimViewMap));
        }
        HashSet<String> needLockDim = new HashSet<String>(16);
        if (rowCtrlKeys.size() > 0) {
            for (String f7CtlKey : pageCtrlKeys) {
                defaultValues = this.isFromTargetCusReport() ? this.getTargetMappingMemIdsByCtrlKey(f7CtlKey, mappingMap, userQueryScheme, needLockDim, dimViewMap) : this.getQueryMemIdsByCtrlKey(f7CtlKey, userQueryScheme);
                Long defaultValue = defaultValues.size() == 0 ? Long.valueOf(0L) : defaultValues.get(0);
                this.setDefaultSingleDim(modelId, busModelId, f7CtlKey, Long.parseLong((String)((Map)ctlsMap.get(f7CtlKey)).get("id")), (String)((Map)ctlsMap.get(f7CtlKey)).get("number"), dimViewMap, defaultValue);
            }
        }
        if (rowCtrlKeys.size() > 0) {
            for (String rowCtrlKey : rowCtrlKeys) {
                if (this.isFromTargetCusReport()) {
                    defaultValues = this.getTargetMappingMemIdsByCtrlKey(rowCtrlKey, mappingMap, userQueryScheme, needLockDim, dimViewMap);
                    dimNum = this.getDimNumByCtrlKey(rowCtrlKey);
                    this.getLeafMembers(modelCache, defaultValues, dimViewMap, dimNum);
                } else {
                    defaultValues = this.getQueryMemIdsByCtrlKey(rowCtrlKey, userQueryScheme);
                }
                this.cacheCtrlDefValue(busModelId, rowCtrlKey, ctlsMap, dimViewMap, defaultValues);
            }
        }
        if (colCtrlKeys.size() > 0) {
            for (String colCtrlKey : colCtrlKeys) {
                if (this.isFromTargetCusReport()) {
                    DynamicObjectCollection tarDecSchemes;
                    defaultValues = this.getTargetMappingMemIdsByCtrlKey(colCtrlKey, mappingMap, userQueryScheme, needLockDim, dimViewMap);
                    dimNum = this.getDimNumByCtrlKey(colCtrlKey);
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum) && "record".equals(this.getTargetFlag()) && CollectionUtils.isNotEmpty((Collection)(tarDecSchemes = QueryServiceHelper.query((String)"eb_decompose_scheme", (String)"id,number,status", (QFilter[])new QFilter("targetrecord", "=", (Object)pkId).toArray())))) {
                        String schemeStatus = ((DynamicObject)tarDecSchemes.get(0)).getString("status");
                        if (!DecomposeSchemeStatus.SAVE.getNumber().equals(schemeStatus)) {
                            this.getLeafMembers(modelCache, defaultValues, dimViewMap, dimNum);
                        }
                    }
                } else {
                    defaultValues = this.getQueryMemIdsByCtrlKey(colCtrlKey, userQueryScheme);
                }
                this.cacheCtrlDefValue(busModelId, colCtrlKey, ctlsMap, dimViewMap, defaultValues);
            }
        }
        this.setAllDimCache(ctlsMap);
        this.setInitPartInfo();
        this.cacheNeedLockDims(needLockDim);
    }

    private void cacheNeedLockDims(Set<String> needLockDim) {
        if (this.isFromTargetCusReport()) {
            this.setCache("needLockDim", SerializationUtils.serializeToBase64(needLockDim));
        }
    }

    private Set<String> getNeedLockDims() {
        String cache = this.getCache("needLockDim");
        if (cache == null) {
            cache = (String)this.getFormCustomParam("needLockDim");
            this.setCache("needLockDim", cache);
        }
        if (cache != null) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return null;
    }

    private void setInitPartInfo() {
        String curPartF7Key;
        this.cachePartTabKeys(true, Collections.singletonList("rowpart1"));
        this.cachePartTabKeys(false, Collections.singletonList("colpart1"));
        List<Map<String, String>> row = this.getPointEntry("row");
        List<Map<String, String>> col = this.getPointEntry("col");
        ArrayList<String> rowCacheF7Keys = new ArrayList<String>(10);
        ArrayList<String> colCacheF7Keys = new ArrayList<String>(10);
        if (row.size() > 0) {
            for (Map<String, String> dimInfo : row) {
                curPartF7Key = this.getCurPartF7Key(dimInfo.get("sign"), "rowpart1");
                rowCacheF7Keys.add(curPartF7Key);
            }
        }
        if (col.size() > 0) {
            for (Map<String, String> dimInfo : col) {
                curPartF7Key = this.getCurPartF7Key(dimInfo.get("sign"), "colpart1");
                colCacheF7Keys.add(curPartF7Key);
            }
        }
        this.cacheCurPartF7Keys("rowpart1", rowCacheF7Keys);
        this.cacheCurPartF7Keys("colpart1", colCacheF7Keys);
        this.toAddNewTab();
    }

    private void setAllDimCache(Map<String, Map<String, String>> allDimMap) {
        ArrayList<String> pageFields = new ArrayList<String>(16);
        ArrayList<String> rowFields = new ArrayList<String>(16);
        ArrayList<String> colFields = new ArrayList<String>(16);
        ArrayList<String> metricFields = new ArrayList<String>(16);
        for (Map.Entry<String, Map<String, String>> entry : allDimMap.entrySet()) {
            String suffix;
            Map<String, String> map = entry.getValue();
            String f7Key = map.get("sign");
            switch (suffix = ReportQueryHelper.getCtrlKeySuffix(f7Key)) {
                case "page": {
                    pageFields.add(f7Key);
                    break;
                }
                case "row": {
                    rowFields.add(f7Key);
                    break;
                }
                case "col": {
                    colFields.add(f7Key);
                    break;
                }
                case "position": {
                    metricFields.add(f7Key);
                }
            }
        }
        this.setFieldCache("coldim", colFields);
        this.setFieldCache("rowdim", rowFields);
        this.setFieldCache("pagedim", pageFields);
        this.setFieldCache("metricdim", metricFields);
    }

    private void setFieldCache(String type, List<String> fields) {
        if (fields.size() > 0) {
            String fieldsJson = SerializationUtils.toJsonString(fields);
            this.setCache(type + "Fields", fieldsJson);
        } else {
            this.clearCache(type + "Fields");
        }
    }

    private void cacheCtrlDefValue(Long busModelId, String ctrlKey, Map<String, Map<String, String>> ctlsMap, Map<Long, Long> dimViewMap, List<Long> defaultValues) {
        Map<String, String> defValueMap = this.getDefaultMulDim(busModelId, ctrlKey, Long.parseLong(ctlsMap.get(ctrlKey).get("id")), ctlsMap.get(ctrlKey).get("number"), dimViewMap, defaultValues);
        String namesStr = "";
        String valuesStr = "";
        if (defValueMap != null) {
            namesStr = defValueMap.get("name");
            valuesStr = defValueMap.get("value");
        }
        ctlsMap.get(ctrlKey).put("defvalue", valuesStr);
        ctlsMap.get(ctrlKey).put("defname", namesStr);
        String cachePartF7key = this.getCurPartF7Key(ctrlKey, "rowdimpanel1".equals(ctlsMap.get(ctrlKey).get("panel")) ? "rowpart1" : "colpart1");
        this.setCache(cachePartF7key, valuesStr);
    }

    private Map<String, String> getDefaultMulDim(Long businessmodelId, String ctrlKey, long dimId, String dimNum, Map<Long, Long> dimViewMap, List<Long> defaultValues) {
        List<Long> defMemIds;
        LinkedHashMap<String, Map<String, String>> sortedDimMems = new LinkedHashMap<String, Map<String, String>>(16);
        Long viewId = dimViewMap.getOrDefault(dimId, 0L);
        if (dimViewMap.containsKey(dimId)) {
            if (this.isFromTargetCusReport()) {
                defMemIds = defaultValues;
            } else {
                Map<Long, DynamicObject> memDysMap = ReportQueryHelper.getMemsByDataSet(viewId, dimId);
                List<DynamicObject> DefDys = ReportQueryHelper.getDefDys(memDysMap);
                List memIds = DefDys.stream().map(defDy -> defDy.getLong("memid")).collect(Collectors.toList());
                defMemIds = memIds.stream().filter(defaultValues::contains).collect(Collectors.toList());
                if (defMemIds.size() == 0) {
                    for (int i = 0; i < 5 && i < DefDys.size(); ++i) {
                        defMemIds.add(DefDys.get(i).getLong("memid"));
                    }
                }
            }
        } else {
            Set<Long> memIds = this.getMemByDimView(dimNum, viewId);
            ArrayList<Long> hasPermMembIds = new ArrayList<Long>(16);
            List<Member> members = this.getPermTreeNode(businessmodelId, dimNum, hasPermMembIds, viewId);
            if (CollectionUtils.isEmpty(hasPermMembIds) || CollectionUtils.isEmpty(members)) {
                return null;
            }
            HashSet curPermMemIds = new HashSet(memIds);
            curPermMemIds.retainAll(hasPermMembIds);
            defMemIds = defaultValues.stream().filter(curPermMemIds::contains).collect(Collectors.toList());
            if (defMemIds.size() == 0) {
                if (!"metric".equalsIgnoreCase(dimNum)) {
                    if (members.size() > 0) {
                        int limitCount = 0;
                        for (Member member : members) {
                            if (limitCount < 5) {
                                long temMemId = member.getId();
                                if (!curPermMemIds.contains(temMemId)) continue;
                                defMemIds.add(member.getId());
                                ++limitCount;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (members.size() > 0) {
                    Map allDims = (Map)SerializationUtils.fromJsonString((String)this.getCache("allPoint"), Map.class);
                    boolean isAccount = allDims.values().stream().anyMatch(map -> ((String)map.get("number")).equalsIgnoreCase("Account"));
                    Member money = members.stream().filter(node -> node.getNumber().equalsIgnoreCase("Money")).findAny().orElse(null);
                    Member perNode = null;
                    if (isAccount && money != null && hasPermMembIds.contains(money.getId())) {
                        perNode = money;
                    } else {
                        Optional<Member> findFirst = members.stream().filter(tem -> curPermMemIds.contains(tem.getId())).findFirst();
                        if (findFirst.isPresent()) {
                            perNode = findFirst.get();
                        }
                    }
                    if (perNode != null && curPermMemIds.contains(perNode.getId())) {
                        defMemIds.add(perNode.getId());
                    }
                } else {
                    return null;
                }
            }
        }
        if (defMemIds.size() == 0) {
            return null;
        }
        for (Long memId : defMemIds) {
            Member member = this.getModelCacheHelper().getMemberByAnyView(businessmodelId, dimNum, memId);
            if (member == null) continue;
            sortedDimMems.put(member.getName(), ReportQueryHelper.getDimMap(member.getId(), member.getNumber(), member.getName(), ctrlKey, member.getShowNumber()));
        }
        String dimNameStr = String.join((CharSequence)",", sortedDimMems.keySet());
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("name", dimNameStr);
        result.put("value", SerializationUtils.toJsonString(sortedDimMems.values()));
        return result;
    }

    private void getLeafMembers(IModelCacheHelper modelCache, List<Long> defaultValues, Map<Long, Long> dimViewMap, String dimNum) {
        ArrayList<Long> defaultValuesNew = new ArrayList<Long>(16);
        for (Long memberId : defaultValues) {
            Dimension dimension = modelCache.getDimension(dimNum);
            if (dimension == null) continue;
            Long viewId = dimViewMap.get(dimension.getId());
            Member member = null;
            member = modelCache.getMember(dimNum, viewId, memberId);
            if (member != null && !member.isLeaf()) {
                List memberList = member.getAllMembers();
                for (Member mem : memberList) {
                    if (mem.getNumber().contains("offsetentry")) continue;
                    defaultValuesNew.add(mem.getId());
                }
                continue;
            }
            defaultValuesNew.add(memberId);
        }
        defaultValues.clear();
        defaultValues.addAll(defaultValuesNew);
    }

    private void setDefaultSingleDim(Long modelId, Long busModelId, String ctrlKey, long dimId, String dimNum, Map<Long, Long> dimViewMap, Long defaultValue) {
        Long memId = 0L;
        Member member = null;
        long viewId = dimViewMap.getOrDefault(dimId, 0L);
        if (IDUtils.isNotEmptyLong((Long)defaultValue).booleanValue()) {
            memId = defaultValue;
            member = this.getModelCacheHelper().getMemberByAnyView(busModelId, dimNum, memId);
        } else {
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            if ("AuditTrail".equalsIgnoreCase(dimNum)) {
                member = modelCacheHelper.getMember(dimNum, null, "EntityInput");
            } else if ("ChangeType".equalsIgnoreCase(dimNum)) {
                member = modelCacheHelper.getRootMember(dimNum, Long.valueOf(viewId));
            } else if ("Currency".equalsIgnoreCase(dimNum)) {
                member = modelCacheHelper.getMember(dimNum, null, "CNY");
            } else if ("DataType".equalsIgnoreCase(dimNum)) {
                member = modelCacheHelper.getMember(dimNum, null, "Budget");
            } else if ("Version".equalsIgnoreCase(dimNum)) {
                member = modelCacheHelper.getMember(dimNum, null, "VNone");
            } else if ("Entity".equalsIgnoreCase(dimNum)) {
                List members;
                Member rootMember = this.getModelCacheHelper().getRootMember(dimNum, Long.valueOf(viewId));
                if (rootMember != null && CollectionUtils.isNotEmpty((Collection)(members = this.getModelCacheHelper().getMemberSort(dimNum, Long.valueOf(viewId), rootMember.getNumber(), 20)))) {
                    member = (Member)members.get(0);
                }
            } else if (!SysDimensionEnum.include((String)dimNum, (Boolean)true)) {
                Dimension dimension = modelCacheHelper.getDimension(dimNum);
                String noneNumber = dimension.getNoneNumber();
                member = modelCacheHelper.getMember(dimNum, Long.valueOf(viewId), noneNumber);
            } else {
                member = this.setDefaultSingleDim(busModelId, dimId, dimNum, dimViewMap, defaultValue);
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
        if (member != null) {
            Set permMemIds = DimMembPermHelper.getReadPermMembIds((String)dimNum, (Long)modelId, (Long)busModelId, (Long)viewId, (boolean)true);
            if (permMemIds == null || permMemIds.contains(member.getId())) {
                map.put("id", member.getId().toString());
                map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
                map.put("number", member.getNumber());
                map.put("name", member.getName());
                map.put("pid", "");
            } else if (permMemIds.size() > 0) {
                member = this.modelCacheHelper.getMember(dimNum, Long.valueOf(viewId), (Long)permMemIds.iterator().next());
                map.put("id", member.getId().toString());
                map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
                map.put("number", member.getNumber());
                map.put("name", member.getName());
                map.put("pid", "");
            }
        }
        this.setCache(ctrlKey, SerializationUtils.toJsonString(map));
    }

    private Member setDefaultSingleDim(Long busModelId, long dimId, String dimNum, Map<Long, Long> dimViewMap, Long defaultValue) {
        Long memId = 0L;
        Map<Long, DynamicObject> memDysMap = null;
        Long viewId = dimViewMap.getOrDefault(dimId, 0L);
        if (dimViewMap.containsKey(dimId)) {
            memDysMap = ReportQueryHelper.getMemsByDataSet(viewId, dimId);
            List<DynamicObject> DefDys = ReportQueryHelper.getDefDys(memDysMap);
            List memIds = DefDys.stream().map(defDy -> defDy.getLong("memid")).collect(Collectors.toList());
            if (memIds.contains(defaultValue)) {
                memId = defaultValue;
            } else if (memIds.size() > 0) {
                memId = (Long)memIds.get(0);
            }
        } else {
            Member child;
            Set<Long> memIds = this.getMemByDimView(dimNum, viewId);
            ArrayList<Long> hasPermMembIds = new ArrayList<Long>(16);
            List<Member> permTreeNode = this.getPermTreeNode(busModelId, dimNum, hasPermMembIds, viewId);
            if (permTreeNode == null) {
                return null;
            }
            HashSet<Long> curPermMemIds = new HashSet<Long>(memIds);
            curPermMemIds.retainAll(hasPermMembIds);
            if (curPermMemIds.contains(defaultValue)) {
                memId = defaultValue;
            } else if (permTreeNode.size() > 0 && curPermMemIds.size() > 0 && (child = (Member)permTreeNode.stream().filter(node -> curPermMemIds.contains(node.getId())).findFirst().orElse(null)) != null) {
                memId = child.getId();
            }
        }
        return this.getModelCacheHelper().getMember(dimNum, viewId, memId);
    }

    private List<Member> getPermTreeNode(Long busModelId, String dimNum, List<Long> hasPermMembIds, Long viewId) {
        Long modelId = this.getModelId();
        List<Member> members = ReportQueryHelper.getPermTreeNode(dimNum, hasPermMembIds, busModelId, modelId, viewId);
        String account = "account";
        boolean flag = dimNum.equalsIgnoreCase(account);
        if (flag) {
            List<Long> accountIds = ReportQueryHelper.getAccountByDataSet(this.getDataSetId());
            hasPermMembIds.retainAll(accountIds);
        }
        return members;
    }

    protected String getCurNodeCacheName() {
        String tabKey = this.getCache("cache_tab");
        return this.getCurNodeCacheName(tabKey);
    }

    private String getCurNodeCacheName(String tabKey) {
        if (kd.bos.util.StringUtils.isEmpty((String)tabKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u770b\u9879\u4e3a\u7a7a", (String)"ReportQueryDesigner_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String result = "";
        result = tabKey + "_nodeid";
        return result;
    }

    private Set<Long> getMemByDimView(String dimNum, Long viewId) {
        HashSet<Long> result = new HashSet(16);
        List members = new ArrayList(10);
        if (SysDimensionEnum.Account.getNumber().equals(dimNum)) {
            Dimension dimension = this.getModelCacheHelper().getDimension(dimNum);
            members = dimension.getAllMembersByDataSetId(this.getDataSetId());
        } else {
            members = this.getModelCacheHelper().getMembers(viewId, dimNum);
        }
        result = members.stream().map(BaseCache::getId).collect(Collectors.toSet());
        return result;
    }

    private List<Long> getQueryMemIdsByCtrlKey(String ctrlKey, Map<String, Map<String, String>> userQueryScheme) {
        List<Long> memIds = new ArrayList<Long>(16);
        String dimNum = this.getDimNumByCtrlKey(ctrlKey);
        if (!kd.bos.util.StringUtils.isEmpty((String)dimNum) && userQueryScheme != null && userQueryScheme.containsKey(dimNum) && userQueryScheme.get(dimNum).size() > 0) {
            if (kd.bos.util.StringUtils.isEmpty((String)userQueryScheme.get(dimNum).get("mem"))) {
                return memIds;
            }
            List<String> memIdStrs = Arrays.asList(userQueryScheme.get(dimNum).get("mem").split(","));
            memIds = memIdStrs.stream().map(Long::parseLong).collect(Collectors.toList());
        }
        return memIds;
    }

    private String getDimNumByCtrlKey(String ctrlKey) {
        String baseCtrlKey;
        String dimNum = "";
        Map<String, String> baseKeyMap = ReportQueryDesignerHelper.getInstance().getAllF7Map(this.getModelId(), this.getDataSetId(), true);
        if (baseKeyMap.containsKey(baseCtrlKey = ReportQueryHelper.getF7BaseKey(ctrlKey))) {
            dimNum = baseKeyMap.get(baseCtrlKey);
        }
        return dimNum;
    }

    private List<Long> getTargetMappingMemIdsByCtrlKey(String ctrlKey, Map<String, List<Long>> mappingMap, Map<String, Map<String, String>> userQueryScheme, Set<String> needLockDim, Map<Long, Long> dimViewMap) {
        List<Long> memIds = new ArrayList<Long>(16);
        String dimNum = this.getDimNumByCtrlKey(ctrlKey);
        if (!kd.bos.util.StringUtils.isEmpty((String)dimNum)) {
            Dimension dimension = this.getModelCacheHelper().getDimension(dimNum);
            IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            if (mappingMap.containsKey(dimNum)) {
                String pkId = this.getPkIdFromTargetData();
                if (SysDimensionEnum.Entity.getNumber().equals(dimNum)) {
                    if (this.isFromTargetCusReport()) {
                        if ("scheme".equals(this.getTargetFlag())) {
                            DynamicObjectCollection records = QueryServiceHelper.query((String)"bgm_targetschemerecord", (String)"id,number,entity", (QFilter[])new QFilter("targetscheme", "=", (Object)IDUtils.toLong((Object)pkId)).toArray());
                            if (CollectionUtils.isNotEmpty((Collection)records)) {
                                if (dimension != null) {
                                    for (DynamicObject record : records) {
                                        String srcEntity = record.getString("entity");
                                        List entityMembers = Arrays.stream(srcEntity.split(",")).collect(Collectors.toList());
                                        for (String number : entityMembers) {
                                            Long viewId = dimViewMap.get(dimension.getId());
                                            Member member = cacheHelper.getMember(dimNum, viewId, number);
                                            if (member == null) continue;
                                            memIds.add(member.getId());
                                        }
                                    }
                                }
                            } else {
                                memIds = this.getQueryMemIdsByCtrlKey(ctrlKey, userQueryScheme);
                            }
                        } else if ("record".equals(this.getTargetFlag())) {
                            memIds = mappingMap.get(dimNum);
                        }
                    } else {
                        memIds = this.getQueryMemIdsByCtrlKey(ctrlKey, userQueryScheme);
                    }
                    if (dimension != null) {
                        this.setTarDimMemberLongNumberCache(memIds, dimNum, cacheHelper, dimViewMap.get(dimension.getId()));
                    }
                } else {
                    memIds = mappingMap.get(dimNum);
                    if (CollectionUtils.isNotEmpty(memIds)) {
                        Member structOfMember;
                        if (memIds.size() > 1) {
                            if (dimension != null) {
                                this.setTarDimMemberLongNumberCache(memIds, dimNum, cacheHelper, dimViewMap.get(dimension.getId()));
                            }
                        } else if (dimension != null && (structOfMember = cacheHelper.getMember(dimNum, dimViewMap.get(dimension.getId()), memIds.get(0))) != null) {
                            if (structOfMember.isLeaf()) {
                                needLockDim.add(dimNum);
                            } else {
                                this.setTarDimMemberLongNumberCache(memIds, dimNum, cacheHelper, dimViewMap.get(dimension.getId()));
                            }
                        }
                    }
                }
            }
        }
        return memIds;
    }

    private void setTarDimMemberLongNumberCache(List<Long> memIds, String dimNum, IModelCacheHelper cacheHelper, Long viewId) {
        ArrayList<String> longNumbers = new ArrayList<String>(memIds.size());
        String tarCacheKey = "cache_tar_" + dimNum;
        for (Long memId : memIds) {
            Member structOfMember = cacheHelper.getMember(dimNum, viewId, memId);
            if (structOfMember == null) continue;
            longNumbers.add(structOfMember.getLongNumber());
        }
        this.setCache(tarCacheKey, SerializationUtils.toJsonString(longNumbers));
    }

    private Map<String, String> getMapByDy(DynamicObject dimDy, String suffix) {
        String panelParent = this.getCtrlPanelBySuffix(suffix);
        String memberTreeModel = dimDy.getString("membermodel");
        String dimNumber = dimDy.getString("dimnum");
        String ctrKey = ReportQueryDesignerHelper.getInstance().getControlKeyByDimNum(this.getModelId(), this.getDataSetId(), dimNumber, suffix);
        return ReportQueryHelper.getDimMap(dimDy.getLong("dimid"), dimNumber, dimDy.getString("dimname"), dimDy.getInt("dseq"), memberTreeModel, ctrKey, panelParent);
    }

    private String getCtrlPanelBySuffix(String suffix) {
        String panelParent = "";
        if (suffix.equalsIgnoreCase("page")) {
            panelParent = "pagedimpanel1";
        } else if (suffix.equalsIgnoreCase("row")) {
            panelParent = "rowdimpanel1";
        } else if (suffix.equalsIgnoreCase("col")) {
            panelParent = "coldimpanel1";
        }
        return panelParent;
    }

    private List<String> getDefaultDimsByTargetData(String sign, boolean isLower) {
        List<String> dimList = new ArrayList<String>(16);
        if (sign.equals("rowdim")) {
            dimList.add(SysDimensionEnum.Entity.getNumber());
            dimList.add(SysDimensionEnum.Account.getNumber());
        } else if (sign.equals("coldim")) {
            dimList.add(SysDimensionEnum.BudgetPeriod.getNumber());
        }
        if (isLower) {
            dimList = dimList.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        return dimList;
    }

    private String getPkIdFromTargetData() {
        return (String)this.getView().getFormShowParameter().getCustomParam("targetPkId");
    }

    private boolean getIsShareNode() {
        Object isShareNode = this.getView().getFormShowParameter().getCustomParam("isMyShareNode");
        if (isShareNode == null) {
            return false;
        }
        return (Boolean)isShareNode;
    }

    private String getTargetFlag() {
        return (String)this.getView().getFormShowParameter().getCustomParam("targetFlag");
    }

    private void setMetricGroupField(Map<String, Map<String, String>> userQueryScheme) {
        String pos;
        String posVal = "2";
        if (userQueryScheme != null && userQueryScheme.containsKey(SysDimensionEnum.Metric.getNumber()) && !kd.bos.util.StringUtils.isEmpty((String)(pos = userQueryScheme.get(SysDimensionEnum.Metric.getNumber()).get("pos")))) {
            posVal = pos;
        }
        this.setCache("metrigroupfield", posVal);
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    private void allDrag(IFormView view, Page page) {
        String tab = this.getCache("cache_tab");
        boolean isDrop = true;
        this.getControl("pagedimpanel1").setDroppable(isDrop);
        this.getControl("rowdimpanel1").setDroppable(isDrop);
        this.getControl("coldimpanel1").setDroppable(isDrop);
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> {
            view.getControl(e.getSign()).setDroppable(isDrop);
            view.getControl(e.getSign()).setDraggable(isDrop);
        }));
    }

    protected Map<String, Map<String, String>> getPointEntry() {
        Map<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        String pointEntry = this.getCache("allPoint");
        if (pointEntry == null) {
            pointEntry = (String)this.getFormCustomParam("allPoint");
        }
        if (pointEntry == null && this.getTemplateModelFromShowParam() != null) {
            ReportQueryDesignerHelper instance = ReportQueryDesignerHelper.getInstance();
            result = instance.getPointEntryFromTemplateModel(this.getTemplateModelFromShowParam(), this.getDataSetId());
            this.setCache("allPoint", SerializationUtils.toJsonString(result));
            return result;
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)pointEntry)) {
            result = (Map)SerializationUtils.fromJsonString((String)pointEntry, Map.class);
            this.setCache("allPoint", pointEntry);
        }
        return result;
    }

    private List<Map<String, String>> getPointEntry(String panel) {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        if (pointEntry.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9762\u677f\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"ReportQueryDesigner_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(10);
        for (Map.Entry<String, Map<String, String>> entry : pointEntry.entrySet()) {
            String key = entry.getKey();
            Map<String, String> dimInfo = entry.getValue();
            if (!key.endsWith(panel)) continue;
            dimList.add(dimInfo);
        }
        return dimList;
    }

    private Map<String, List<DynamicObject>> getDataSetDimDysMap(Long modelId, Long dataSetId) {
        String account;
        String dimFields = "entryentity.datasetdim.id as dimid,entryentity.datasetdim.number as dimnum,entryentity.datasetdim.name as dimname,entryentity.datasetdim.membermodel as membermodel,entryentity.datasetdim.version as version,entryentity.datasetdim.dseq as dseq";
        QFilter dimFilter = new QFilter("id", "=", (Object)dataSetId);
        DynamicObjectCollection dataSetDimDys = QueryServiceHelper.query((String)"eb_dataset", (String)dimFields, (QFilter[])new QFilter[]{dimFilter});
        if (dataSetDimDys == null || dataSetDimDys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u7ef4\u5ea6\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ReportQueryDesigner_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map<String, List<DynamicObject>> dataSetDimDysMap = dataSetDimDys.stream().collect(Collectors.groupingBy(dimDy -> dimDy.getString("dimnum").toLowerCase()));
        if (!dataSetDimDysMap.containsKey(account = "account") || !dataSetDimDysMap.containsKey("metric")) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
            ArrayList<String> dimList = new ArrayList<String>(16);
            dimList.add("Account");
            dimList.add("Metric");
            filters.add(new QFilter("number", "in", dimList));
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            filters.add(new QFilter("model", "=", (Object)modelId));
            String accountFields = "id as dimid,number as dimnum,name as dimname,dseq,membermodel as membermodel,'' as version ";
            DynamicObjectCollection otherDimDys = QueryServiceHelper.query((String)"epm_dimension", (String)accountFields, (QFilter[])filters.toArray(new QFilter[0]));
            Map<String, List<DynamicObject>> otherDimDysMap = otherDimDys.stream().collect(Collectors.groupingBy(dimDy -> dimDy.getString("dimnum").toLowerCase()));
            dataSetDimDysMap.put("account", otherDimDysMap.get("account"));
            dataSetDimDysMap.put("metric", otherDimDysMap.get("metric"));
        }
        return dataSetDimDysMap;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException var3) {
            throw new RuntimeException(var3);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith("ebf7")) {
            if (key.endsWith("row") || key.endsWith("col")) {
                TextEdit edit = new TextEdit();
                edit.setKey(e.getKey());
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else if (key.endsWith("page")) {
                BasedataEdit edit = new BasedataEdit();
                edit.setKey(e.getKey());
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                e.setControl((Control)edit);
            }
        }
    }

    private void setCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    protected String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void clearCache(String cacheKey) {
        this.getPageCache().remove(cacheKey);
    }

    @Override
    public Long getModelId() {
        String modelId = this.getCache("model");
        if (modelId == null) {
            modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.setCache("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    protected Long getDataSetId() {
        String dataset = this.getCache("dataset");
        if (dataset == null) {
            dataset = this.getView().getFormShowParameter().getCustomParam("dataset").toString();
            this.setCache("dataset", dataset);
        }
        return IDUtils.toLong((Object)dataset);
    }

    @Override
    public void cachePartTabKeys(boolean isRow, List<String> tabKeys) {
        Long dataSetId = this.getDataSetId();
        if (isRow) {
            this.setCache("all_row_part_keys" + dataSetId, SerializationUtils.toJsonString(tabKeys));
            return;
        }
        this.setCache("all_col_part_keys" + dataSetId, SerializationUtils.toJsonString(tabKeys));
    }

    @Override
    public void cacheCurPartF7Keys(String partTabKey, List<String> curPartF7Keys) {
        Long dataSetId = this.getDataSetId();
        this.setCache(partTabKey + dataSetId, SerializationUtils.toJsonString(curPartF7Keys));
    }

    @Override
    public List<String> getCurPartF7Keys(String partTabKey) {
        Long dataSetId = this.getDataSetId();
        String cache = this.getCache(partTabKey + dataSetId);
        if (cache != null) {
            return (List)SerializationUtils.fromJsonString((String)cache, List.class);
        }
        return new ArrayList<String>(10);
    }

    @Override
    public void updateRowColPartAfterMoveOut(String F7Key) {
        boolean isRow = F7Key.endsWith("_row");
        List<String> tabKeys = this.getRowColPartTabKeys(isRow);
        for (String tabKey : tabKeys) {
            List<String> curPartF7Keys = this.getCurPartF7Keys(tabKey);
            String curPartF7Key = this.getCurPartF7Key(F7Key, tabKey);
            curPartF7Keys.removeIf(e -> e.equals(curPartF7Key));
            this.cacheCurPartF7Keys(tabKey, curPartF7Keys);
            this.clearCache(curPartF7Key);
            this.clearCurPartDimViewId(curPartF7Key);
        }
    }

    @Override
    public void updateRowColPartAfterMoveIn(String F7Key) {
        boolean isRow = F7Key.endsWith("_row");
        List<String> tabKeys = this.getRowColPartTabKeys(isRow);
        for (String tabKey : tabKeys) {
            String newPartF7Key = this.getCurPartF7Key(F7Key, tabKey);
            List<String> curPartF7Keys = this.getCurPartF7Keys(tabKey);
            curPartF7Keys.add(newPartF7Key);
            this.cacheCurPartF7Keys(tabKey, curPartF7Keys);
        }
    }

    @Override
    public void delRowColPart(boolean isRowPart, String toDelPartKey) {
        String tabControlKey = isRowPart ? "rowtabap" : "coltabap";
        List<String> tabKeys = this.getRowColPartTabKeys(isRowPart);
        Tab tab = (Tab)this.getControl(tabControlKey);
        if (StringUtil.isEmptyString((String)toDelPartKey) || !toDelPartKey.contains("part")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u533a\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportQueryDesigner_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (tabKeys.size() <= this.getPartMinSize()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u4fdd\u7559\u81f3\u5c11%1\u4e2a\u5206\u533a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5173\u95ed\u3002", (String)"ReportQueryDesigner_16", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getPartMinSize()}));
            return;
        }
        tab.deleteControls(new String[]{toDelPartKey});
        tabKeys.remove(toDelPartKey);
        this.toAddNewTab(tabKeys, isRowPart);
        this.clearCurPartCache(toDelPartKey);
        this.cachePartTabKeys(isRowPart, tabKeys);
    }

    public void delMultiRowColPart(boolean isRowPart, List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        String tabControlKey = isRowPart ? "rowtabap" : "coltabap";
        List<String> tabKeys = this.getRowColPartTabKeys(isRowPart);
        Tab tab = (Tab)this.getControl(tabControlKey);
        ArrayList<String> toDelPartKeys = new ArrayList<String>(10);
        for (String id : keys) {
            toDelPartKeys.add(id);
        }
        if (toDelPartKeys.size() == 0) {
            return;
        }
        if (tabKeys.size() - toDelPartKeys.size() < this.getPartMinSize()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u4fdd\u7559\u81f3\u5c11%1\u4e2a\u5206\u533a\uff0c\u4e0d\u5141\u8bb8\u5168\u90e8\u5173\u95ed\u3002", (String)"ReportQueryDesigner_18", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getPartMinSize()}));
            return;
        }
        tab.deleteControls(toDelPartKeys.toArray(new String[0]));
        tabKeys.removeAll(toDelPartKeys);
        this.toAddNewTab(tabKeys, isRowPart);
        for (String toDelPartKey : toDelPartKeys) {
            this.clearCurPartCache(toDelPartKey);
        }
        this.cachePartTabKeys(isRowPart, tabKeys);
    }

    public void clearRowColPart(boolean isRowPart) {
        String tabControlKey = isRowPart ? "rowtabap" : "coltabap";
        List<String> tabKeys = this.getRowColPartTabKeys(isRowPart);
        Tab tab = (Tab)this.getControl(tabControlKey);
        ArrayList toDelPartKeys = new ArrayList(10);
        if (tabKeys.size() == 0) {
            return;
        }
        tab.deleteControls(tabKeys.toArray(new String[0]));
        tabKeys.removeAll(toDelPartKeys);
        for (String toDelPartKey : toDelPartKeys) {
            this.clearCurPartCache(toDelPartKey);
        }
        this.cachePartTabKeys(isRowPart, tabKeys);
    }

    @Override
    public void addRowColPart(boolean isRow) {
        List<String> allRowOrColTabKeys = this.getRowColPartTabKeys(isRow);
        if (allRowOrColTabKeys.size() >= this.getPartMaxSize()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u591a\u53ef\u589e\u52a0%1\u4e2a\u5206\u533a\u3002", (String)"ReportQueryDesigner_17", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getPartMaxSize()}));
            return;
        }
        String lastPartKey = allRowOrColTabKeys.get(allRowOrColTabKeys.size() - 1);
        String lastPartIndex = lastPartKey.substring(7);
        String pre_rowColPart = isRow ? "rowpart" : "colpart";
        String newPartKey = pre_rowColPart + (Integer.parseInt(lastPartIndex) + 1);
        allRowOrColTabKeys.add(newPartKey);
        this.toAddNewTab(allRowOrColTabKeys, isRow);
        this.cachePartTabKeys(isRow, allRowOrColTabKeys);
        this.updateRowColPartAfterAddPart(isRow, newPartKey, lastPartKey);
        this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
    }

    @Override
    public void updateRowColPartAfterAddPart(boolean isRowPart, String newPartKey, String lastPartKey) {
        List<String> lastPartF7Keys = this.getCurPartF7Keys(lastPartKey);
        ArrayList<String> newPartF7Keys = new ArrayList<String>(10);
        String rowColPartPanel = isRowPart ? "rowdimpanel1" : "coldimpanel1";
        long dataSetId = this.getDataSetId();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String lastPartF7Key : lastPartF7Keys) {
            String newPartF7Key = lastPartF7Key.replace(lastPartKey, newPartKey);
            String f7Key = lastPartF7Key.replace("_" + lastPartKey, "");
            newPartF7Keys.add(newPartF7Key);
            String cacheValue = this.getCache(lastPartF7Key);
            if (kd.bos.util.StringUtils.isNotEmpty((String)cacheValue)) {
                List dimMaps = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
                List memNames = dimMaps.stream().map(mem -> (String)mem.get("name")).collect(Collectors.toList());
                dataEntity.set(f7Key, memNames);
                this.setCache(newPartF7Key, cacheValue);
            }
            Long dimViewId = this.getDimViewId(lastPartF7Key, this.getDimNumByCtrlKey(f7Key), dataSetId);
            this.cacheCurPartDimViewId(newPartF7Key, dimViewId);
        }
        this.getView().updateView(rowColPartPanel);
        this.cacheCurPartF7Keys(newPartKey, newPartF7Keys);
    }

    private void toAddNewTab(List<String> rowColPartTabKeys, boolean isRowPart) {
        Tab tabEdit = (Tab)this.getControl("coltabap");
        if (isRowPart) {
            tabEdit = (Tab)this.getControl("rowtabap");
        }
        TabAp tabap = new TabAp();
        tabap.setKey(tabEdit.getKey());
        tabap.setGrow(0);
        for (int i = 0; i < rowColPartTabKeys.size(); ++i) {
            String tabKey = rowColPartTabKeys.get(i);
            TabPageAp page = this.createNewTabPageAp(tabKey, isRowPart, i + 1, rowColPartTabKeys.size());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"ReportQueryProcess_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata(tabap.getKey(), features);
        tabEdit.selectTab(rowColPartTabKeys.get(rowColPartTabKeys.size() - 1));
        tabEdit.activeTab(rowColPartTabKeys.get(rowColPartTabKeys.size() - 1));
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(16);
        closeMap.put("closable", rowColPartTabKeys.size() > 1);
        rowColPartTabKeys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
    }

    @Override
    public void switchRowColPart(String selectedPartKey) {
        String rowColPanel = selectedPartKey.contains("row") ? "rowdimpanel1" : "coldimpanel1";
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map<String, Map<String, String>> allDimMap = this.getPointEntry();
        ArrayList<Map<String, String>> valueList = new ArrayList<Map<String, String>>(allDimMap.values());
        DataEntityPropertyCollection propertyCollection = dataEntity.getDataEntityType().getProperties();
        for (Map map : valueList) {
            String key = (String)map.get("sign");
            if (!propertyCollection.containsKey((Object)key)) continue;
            String curPartF7Key = key + "_" + selectedPartKey;
            if (!rowColPanel.equals(map.get("panel"))) continue;
            ArrayList<String> memNames = new ArrayList<String>(10);
            if (kd.bos.util.StringUtils.isNotEmpty((String)this.getCache(curPartF7Key))) {
                List dimMaps = (List)SerializationUtils.fromJsonString((String)this.getCache(curPartF7Key), List.class);
                for (Map entity : dimMaps) {
                    RangeEnum scope = RangeEnum.getRangeByVal((String)String.valueOf(entity.get("scope")));
                    if (scope != null && scope != RangeEnum.ONLY) {
                        memNames.add((String)entity.get("name") + scope.getName());
                        continue;
                    }
                    memNames.add((String)entity.get("name"));
                }
            }
            dataEntity.set(key, (Object)StringUtils.join(memNames, (String)","));
        }
        this.getView().updateView(rowColPanel);
    }

    @Override
    public String getCurPartF7Key(String key, String tabKey) {
        return key + "_" + tabKey;
    }

    @Override
    public String getCurRowColTabKey(boolean isRowPartTab) {
        if (isRowPartTab) {
            Tab tab = (Tab)this.getControl("rowtabap");
            return tab.getCurrentTab();
        }
        Tab tab = (Tab)this.getControl("coltabap");
        return tab.getCurrentTab();
    }

    @Override
    public void clearCurPartCache(String currentTab) {
        List<String> curPartF7Keys = this.getCurPartF7Keys(currentTab);
        this.getPageCache().batchRemove(curPartF7Keys);
    }

    @Override
    public List<String> getRowColPartTabKeys(boolean isRow) {
        Long dataSetId = this.getDataSetId();
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        String allPartTabKeys = this.getCache("all_col_part_keys" + dataSetId);
        if (isRow) {
            allPartTabKeys = this.getCache("all_row_part_keys" + dataSetId);
        }
        if (allPartTabKeys != null) {
            return (List)SerializationUtils.fromJsonString((String)allPartTabKeys, List.class);
        }
        return allTabKeys;
    }

    private void analyseRange(String actionId, List<Map<String, String>> list, Long viewId) {
        List<Map<String, String>> multiSelectF7ReturnValue = this.getMultiSelectF7ReturnValue(list, actionId, viewId);
        if (ReportQueryHelper.checkControlKey(actionId)) {
            ArrayList<String> names = new ArrayList<String>(multiSelectF7ReturnValue.size());
            for (Map<String, String> map : multiSelectF7ReturnValue) {
                RangeEnum scope = RangeEnum.getRangeByVal((String)map.get("scope"));
                if (scope != null && scope != RangeEnum.ONLY) {
                    names.add(map.get("name") + scope.getName());
                    continue;
                }
                names.add(map.get("name"));
            }
            String nameText = String.join((CharSequence)",", names);
            String curPartTabKey = this.getCurRowColTabKey(actionId.endsWith("_row"));
            String cacheF7ValueKey = this.getCurPartF7Key(actionId, curPartTabKey);
            String oldCache = this.getCache(cacheF7ValueKey);
            this.setCache(cacheF7ValueKey + "_old", oldCache);
            this.setCache(cacheF7ValueKey, SerializationUtils.toJsonString(multiSelectF7ReturnValue));
            Object value = this.getModel().getValue(actionId);
            if (value instanceof String && nameText.equals(value)) {
                nameText = nameText + " ";
            }
            this.getModel().setValue(actionId, (Object)nameText);
        }
    }

    private void cacheCurPartDimViewId(String curPartCacheF7Key, Object viewId) {
        if (viewId != null) {
            this.setCache(curPartCacheF7Key + "viewId", String.valueOf(viewId));
        }
    }

    private void clearCurPartDimViewId(String curPartCacheF7Key) {
        this.clearCache(curPartCacheF7Key + "viewId");
    }

    private boolean isFloatShow() {
        return ShowType.Floating == this.getView().getFormShowParameter().getOpenStyle().getShowType();
    }

    public void tabClose(TabCloseEvent tabCloseEvent) {
        List tabKeys = tabCloseEvent.getTabKeys();
        if (CollectionUtils.isEmpty((Collection)tabKeys)) {
            String needCloseId = this.getCache("needCloseId");
            if (kd.bos.util.StringUtils.isNotEmpty((String)needCloseId)) {
                tabKeys = (List)JSONObject.parseObject((String)needCloseId, List.class);
            }
            this.clearCache("needCloseId");
        }
        Tab tab = (Tab)tabCloseEvent.getSource();
        this.delMultiRowColPart("rowtabap".equals(tab.getKey()), tabKeys);
        this.click((EventObject)new ClickEvent((Object)this.getControl("btn_ok")));
    }
}

