/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.designer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.ReportQueryDesignerConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.IAreaRangeEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;

public class ReportQueryDesignerHelper
implements ReportQueryDesignerConstant {
    private static final ReportQueryDesignerHelper instance = new ReportQueryDesignerHelper();

    public static ReportQueryDesignerHelper getInstance() {
        return instance;
    }

    public Map<String, Map<String, String>> getPointEntryFromTemplateModel(ITemplateModel templateModel, Long dataSetId) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        if (templateModel == null) {
            return result;
        }
        this.checkDimensionisAll(templateModel);
        List pageEntry = templateModel.getPagemembentry();
        IAreaRangeEntry areaRangeEntry = templateModel.getAreaRangeEntry();
        List rowdimensions = areaRangeEntry.getRowdimensions();
        List coldimensions = areaRangeEntry.getColdimensions();
        if (rowdimensions.size() > 0) {
            for (IDimension dimension : rowdimensions) {
                this.getDimInfoMap(templateModel.getModelId(), dataSetId, dimension, "rowdimpanel1", "row", result);
            }
        }
        if (coldimensions.size() > 0) {
            for (IDimension dimension : coldimensions) {
                this.getDimInfoMap(templateModel.getModelId(), dataSetId, dimension, "coldimpanel1", "col", result);
            }
        }
        if (templateModel.getAreaRangeEntry().isMetricInRow() != null) {
            this.addMetricDim(templateModel, result);
        }
        if (pageEntry.size() > 0) {
            for (IPageDimensionEntry pageDim : pageEntry) {
                IDimension dimension = pageDim.getDimension();
                this.getDimInfoMap(templateModel.getModelId(), dataSetId, dimension, "pagedimpanel1", "page", result);
            }
        }
        return result;
    }

    private void addMetricDim(ITemplateModel template, Map<String, Map<String, String>> allDimMap) {
        if (template.getAreaRangeEntry() == null) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        ArrayList<String> dimList = new ArrayList<String>(16);
        dimList.add("Metric");
        filters.add(new QFilter("number", "in", dimList));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        Long modelId = template.getModelId();
        filters.add(new QFilter("model", "=", (Object)modelId));
        String metricFields = "id as dimid,number as dimnum,name as dimname,dseq,membermodel as membermodel";
        DynamicObject metricDy = QueryServiceHelper.queryOne((String)"epm_dimension", (String)metricFields, (QFilter[])filters.toArray(new QFilter[0]));
        String dimNum = metricDy.getString("dimnum");
        Boolean isMetricInRow = template.getAreaRangeEntry().isMetricInRow();
        String rowCol = isMetricInRow != false ? "row" : "col";
        String ctrKey = "ebf7_" + dimNum.toLowerCase() + "_" + rowCol;
        String panel = isMetricInRow != false ? "rowdimpanel1" : "coldimpanel1";
        String memberTreeModel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimNum);
        Map<String, String> map = ReportQueryHelper.getDimMap(metricDy.getLong("dimid"), dimNum, metricDy.getString("dimname"), metricDy.getInt("dseq"), memberTreeModel, ctrKey, panel);
        map.put("pos", isMetricInRow != false ? "1" : "2");
        allDimMap.put(ctrKey, map);
    }

    private void getDimInfoMap(Long modelId, Long dataSetId, IDimension dimension, String panel, String suffix, Map<String, Map<String, String>> result) {
        HashMap<String, String> map = new HashMap<String, String>();
        String number = dimension.getNumber();
        map.put("id", dimension.getId().toString());
        map.put("number", number);
        map.put("name", dimension.getName());
        String ctrlKey = this.getControlKeyByDimNum(modelId, dataSetId, number, suffix);
        map.put("sign", ctrlKey);
        map.put("seq", dimension.getDSeq().toString());
        map.put("entity", dimension.getMemberModel());
        map.put("panel", panel);
        result.put(ctrlKey, map);
    }

    public String getControlKeyByDimNum(Long modelId, Long dataSetId, String dimNum, String suffix) {
        String controlKey = "";
        Map<String, String> f7KeyMap = this.getAllF7Map(modelId, dataSetId, true);
        if (f7KeyMap.size() > 0) {
            for (Map.Entry<String, String> f7Key : f7KeyMap.entrySet()) {
                if (!dimNum.equalsIgnoreCase(f7Key.getValue())) continue;
                controlKey = f7Key.getKey() + "_" + suffix;
            }
        }
        return controlKey;
    }

    public Map<String, String> getAllF7Map(Long modelId, Long dataSetId, Boolean isCheckBizModel) {
        LinkedHashMap<String, String> f7KeyMap = new LinkedHashMap<String, String>(16);
        List<Object> bizModelDims = new ArrayList(16);
        if (isCheckBizModel.booleanValue()) {
            bizModelDims = this.getBizModelDims(dataSetId);
        }
        AtomicInteger userdefined_index = new AtomicInteger(1);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimensionMap = orCreate.getDimensions();
        for (Dimension dimension : dimensionMap.values()) {
            String dimnumber = dimension.getNumber();
            if (bizModelDims.size() > 0 && !bizModelDims.contains(dimnumber)) continue;
            String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
            boolean isuserdefined = false;
            if ("epm_userdefinedmembertree".equals(memberTreemodel)) {
                isuserdefined = true;
            }
            String f7key = "ebf7_" + dimnumber.toLowerCase();
            if (isuserdefined) {
                f7key = "ebf7_customize" + userdefined_index.get();
                userdefined_index.incrementAndGet();
            }
            f7KeyMap.put(f7key, dimnumber);
        }
        return f7KeyMap;
    }

    private List<String> getBizModelDims(Long dataSetId) {
        ArrayList<String> dimsList = new ArrayList<String>(16);
        String dimFields = "entryentity.datasetdim.id as dimid,entryentity.datasetdim.number as dimnum,entryentity.datasetdim.name as dimname,entryentity.datasetdim.dseq as dseq";
        QFilter dimFilter = new QFilter("id", "=", (Object)dataSetId);
        DynamicObjectCollection dataSetDimDys = QueryServiceHelper.query((String)"eb_dataset", (String)dimFields, (QFilter[])new QFilter[]{dimFilter});
        if (dataSetDimDys != null && dataSetDimDys.size() > 0) {
            for (DynamicObject dataSetDimDy : dataSetDimDys) {
                dimsList.add(dataSetDimDy.getString("dimnum"));
            }
            if (!dimsList.contains(SysDimensionEnum.Account.getNumber())) {
                dimsList.add(SysDimensionEnum.Account.getNumber());
            }
        }
        return dimsList;
    }

    public void checkDimensionisAll(ITemplateModel templateModel) {
        boolean isAllDims = AbstractReportPlugin.checkDimensionisAll((ITemplateModel)templateModel);
        if (!isAllDims && templateModel.getViewpointmembentry() != null) {
            for (IViewPointDimensionEntry viewPointDimensionEntry : templateModel.getViewpointmembentry()) {
                DefaultPageDimensionEntry pageDimensionEntry = new DefaultPageDimensionEntry();
                pageDimensionEntry.setDimension(viewPointDimensionEntry.getDimension());
                pageDimensionEntry.setMembers((List)Lists.newArrayList((Object[])new IDimensionMember[]{viewPointDimensionEntry.getMember()}));
                templateModel.addPagemembentry((IPageDimensionEntry)pageDimensionEntry);
            }
            templateModel.getViewpointmembentry().clear();
        }
    }
}

