/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.designer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.ReportQueryDesignerConstant;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.pageinteraction.model.Area;
import kd.epm.eb.common.pageinteraction.model.BaseEditElement;
import kd.epm.eb.common.pageinteraction.model.Element;
import kd.epm.eb.common.pageinteraction.model.Page;
import kd.epm.eb.common.pageinteraction.model.TextEditElement;
import kd.epm.eb.common.utils.DataEntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.CommonMethod;
import kd.epm.eb.formplugin.report.designer.ReportQueryDesignerHelper;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.formplugin.utils.TemplateModelHelper;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IAreaRangeEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.metric.DefaultMetricDimMmeber;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.partition.RowColPartition;
import org.apache.commons.collections4.CollectionUtils;

public class ReportQueryDesignerListPlugin
extends AbstractFormPlugin
implements DynamicPage,
CommonMethod,
ReportQueryDesignerConstant {
    private EntityMetadata entityMeta = null;
    private IModelCacheHelper modelCacheHelper;

    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
        this.addItemClickListeners(new String[]{"toolbaraprowpartion"});
        this.addItemClickListeners(new String[]{"toolbaraprankpartion"});
    }

    private Set<String> getAllF7Keys() {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        return pointEntry.keySet();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPageData();
    }

    private void initPageData() {
        ITemplateModel templateModel = this.getTemplateModelFromShowParam();
        if (templateModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6templateModel\u6570\u636e\u5931\u8d25\u3002", (String)"ReportQueryDesignerListPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long datasetId = this.getDataSetFormShowParam();
        if (IDUtils.isNotNull((Long)datasetId)) {
            this.getModel().setValue("dataset", (Object)datasetId);
        }
        this.buildUpdatePage();
        this.initPartitionPageData(templateModel);
    }

    private void buildUpdatePage() {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        ArrayList<Map<String, String>> pageDimList = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : pointEntry.entrySet()) {
            String key = entry.getKey();
            Map<String, String> dimInfo = entry.getValue();
            if (!key.endsWith("page")) continue;
            pageDimList.add(dimInfo);
        }
        this.initPageDimPanelInfo(pageDimList);
    }

    private void setRowColPartEntryVisible(List<Map<String, String>> dimList, String partEntryEntity) {
        if (dimList.isEmpty()) {
            return;
        }
        ArrayList<String> visibleKeys = new ArrayList<String>();
        ArrayList<String> hideKeys = new ArrayList<String>();
        Set f7Keys = dimList.stream().map(e -> (String)e.get("sign")).collect(Collectors.toSet());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection colEntryEntity = dataEntity.getDynamicObjectCollection(partEntryEntity);
        DataEntityPropertyCollection properties = colEntryEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (f7Keys.contains(name)) {
                visibleKeys.add(name);
                continue;
            }
            hideKeys.add(name);
        }
        this.getView().setVisible(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), hideKeys.toArray(new String[0]));
    }

    private void initPageDimPanelInfo(List<Map<String, String>> pageDimList) {
        Page page = new Page();
        this.buildUpdateAreaPanel(pageDimList, page, "pagedimpanel");
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    public void buildUpdateAreaPanel(List<Map<String, String>> pageDimList, Page page, String areaPanel) {
        Area area = new Area(areaPanel);
        Style sl = this.getStyle();
        for (Map<String, String> dimInfo : pageDimList) {
            BaseEditElement f7;
            if (dimInfo == null) continue;
            String number = dimInfo.get("number");
            Dimension dimension = this.getModelCacheHelper().getDimension(number);
            String name = dimension != null ? dimension.getName() : dimInfo.get("name");
            String sign = dimInfo.get("sign");
            if ("pagedimpanel".equals(areaPanel)) {
                f7 = new BaseEditElement(name, sign, SysDimensionEnum.getMemberTreemodelByNumber((String)number));
                f7.setDisplayProp("name");
            } else {
                f7 = new TextEditElement(name, sign, SysDimensionEnum.getMemberTreemodelByNumber((String)number));
                ((TextEditElement)f7).setNumber(number);
            }
            f7.addUserObject("memList", null);
            f7.addUserObject("id", (Object)dimInfo.get("id"));
            f7.setHeight(new LocaleString("45px"));
            f7.setStyle(sl);
            f7.setWidth(new LocaleString("182px"));
            f7.setFontSize(12);
            f7.setFieldTextAlign("left");
            f7.setLabelDirection("v");
            area.addElement((Element)f7);
        }
        page.addArea(area);
    }

    private Style getStyle() {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("0");
        mg.setBottom("0");
        mg.setRight("0");
        mg.setLeft("10px");
        sl.setMargin(mg);
        return sl;
    }

    private void initPartitionPageData(ITemplateModel templateModel) {
        List pageDimList = templateModel.getPagemembentry();
        Boolean metricInRow = templateModel.getAreaRangeEntry().isMetricInRow();
        this.updateEntryEntityName(templateModel.getAreaRangeEntry());
        this.buildPartitionInfo(templateModel.getPartitionSetting().getRowPartition(), true, metricInRow);
        this.buildPartitionInfo(templateModel.getPartitionSetting().getColPartition(), false, metricInRow);
        this.buildPageDimPanelInfo(pageDimList);
    }

    private void updateEntryEntityName(IAreaRangeEntry areaRangeEntry) {
        Map<String, String> allDimF7KeyMap = this.getAllDimF7KeyMap();
        List rowdimensions = areaRangeEntry.getRowdimensions();
        List coldimensions = areaRangeEntry.getColdimensions();
        this.updateEntryEntityName(rowdimensions, allDimF7KeyMap);
        this.updateEntryEntityName(coldimensions, allDimF7KeyMap);
    }

    private void updateEntryEntityName(List<IDimension> dimensions, Map<String, String> allDimF7KeyMap) {
        for (IDimension dimension : dimensions) {
            String number = dimension.getNumber();
            String controlKey = allDimF7KeyMap.get(number);
            EntryGrid rowEntryGrid = (EntryGrid)this.getControl("rowentryentity");
            EntryGrid colEntryGrid = (EntryGrid)this.getControl("colentryentity");
            if (this.getControl(controlKey) == null) continue;
            if (rowEntryGrid.getItems().contains(this.getControl(controlKey))) {
                rowEntryGrid.setColumnProperty(controlKey, "header", (Object)new LocaleString(dimension.getName()));
                continue;
            }
            if (!colEntryGrid.getItems().contains(this.getControl(controlKey))) continue;
            colEntryGrid.setColumnProperty(controlKey, "header", (Object)new LocaleString(dimension.getName()));
        }
    }

    private void buildPageDimPanelInfo(List<IPageDimensionEntry> pageDimList) {
        if (CollectionUtils.isEmpty(pageDimList)) {
            return;
        }
        Map<String, String> allF7Map = this.getAllDimF7KeyMap();
        for (IPageDimensionEntry pageDimensionEntry : pageDimList) {
            IDimension dimension = pageDimensionEntry.getDimension();
            String dimNumber = dimension.getNumber();
            List members = pageDimensionEntry.getMembers();
            String f7Key = allF7Map.get(dimNumber);
            if (!CollectionUtils.isNotEmpty((Collection)members) || members.size() <= 0) continue;
            IDimensionMember member = (IDimensionMember)members.get(0);
            this.getModel().setValue(f7Key, (Object)member.getId());
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
            map.put("id", member.getId().toString());
            map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
            map.put("number", member.getNumber());
            map.put("name", member.getName());
            map.put("pid", "");
            this.setCache(f7Key, SerializationUtils.toJsonString(map));
        }
    }

    private void buildPartitionInfo(List<RowColPartition> rowColPartitions, boolean isRowPart, Boolean metricInRow) {
        if (rowColPartitions.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u5217\u5206\u533a\u4fe1\u606f\u5931\u8d25\u3002", (String)"ReportQueryDesignerListPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String rowCol = isRowPart ? "row" : "col";
        ArrayList<String> rowColPartKeys = new ArrayList<String>(10);
        String pre_part = isRowPart ? "rowpart" : "colpart";
        String entryEntity = isRowPart ? "rowentryentity" : "colentryentity";
        Map<String, String> allF7Map = this.getAllDimF7KeyMap();
        int i = 0;
        for (RowColPartition rowColPartition : rowColPartitions) {
            String curPartCacheF7Key;
            String rowColPartKey = pre_part + ++i;
            rowColPartKeys.add(rowColPartKey);
            List rowColDimensionEntries = rowColPartition.getRowColDimensionEntries();
            if (CollectionUtils.isEmpty((Collection)rowColDimensionEntries)) continue;
            List metricDimMmebers = rowColPartition.getMetricDimMmebers();
            ArrayList<String> curPartCacheF7Keys = new ArrayList<String>(10);
            int newRow = this.getModel().createNewEntryRow(entryEntity);
            for (IRowColDimensionEntry iRowColDimensionEntry : rowColDimensionEntries) {
                IDimension dimension = iRowColDimensionEntry.getDimension();
                String dimNumber = dimension.getNumber();
                if ("Metric".equals(dimNumber)) continue;
                List members = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)iRowColDimensionEntry.getMembers())) {
                    members = iRowColDimensionEntry.getMembers();
                }
                String f7Key = allF7Map.get(dimNumber);
                this.getModel().setValue(this.getEntryEntityPartKey(isRowPart), (Object)rowColPartKey, newRow);
                ArrayList<String> names = new ArrayList<String>(members.size());
                for (IDimensionMember member : members) {
                    RangeEnum scope = RangeEnum.getRangeByVal((int)member.getScope());
                    if (scope != null && scope != RangeEnum.ONLY) {
                        names.add(member.getName() + scope.getName());
                        continue;
                    }
                    names.add(member.getName());
                }
                this.getModel().setValue(f7Key, (Object)kd.epm.eb.common.utils.StringUtils.join(names, (String)","), newRow);
                curPartCacheF7Key = this.getPartCacheF7Key(f7Key, rowColPartKey);
                if (members.size() > 0) {
                    this.setCache(curPartCacheF7Key, SerializationUtils.toJsonString(members));
                }
                curPartCacheF7Keys.add(curPartCacheF7Key);
            }
            if (metricInRow == null) continue;
            if (metricInRow.booleanValue() && isRowPart || !metricInRow.booleanValue() && !isRowPart) {
                String f7key = "ebf7_metric_" + rowCol;
                curPartCacheF7Key = this.getCurPartF7Key(f7key, rowColPartKey);
                curPartCacheF7Keys.add(curPartCacheF7Key);
                if (metricDimMmebers.size() > 0) {
                    Object[] names = metricDimMmebers.stream().map(IBaseEntry::getName).toArray();
                    this.getModel().setValue(f7key, (Object)kd.epm.eb.common.utils.StringUtils.join((Object[])names, (String)","), newRow);
                    this.setCache(curPartCacheF7Key, SerializationUtils.toJsonString((Object)metricDimMmebers));
                }
            }
            this.cacheCurPartF7Keys(rowColPartKey, curPartCacheF7Keys);
        }
        this.cachePartKeys(isRowPart, rowColPartKeys);
    }

    private void cacheCurPartF7Keys(String rowColPartKey, List<String> curPartCacheF7Keys) {
        Long dataSetId = this.getDataSetId();
        this.setCache(rowColPartKey + dataSetId, SerializationUtils.toJsonString(curPartCacheF7Keys));
    }

    private String getEntryEntityPartKey(boolean isRowEntry) {
        if (isRowEntry) {
            return "rowpartkey";
        }
        return "colpartkey";
    }

    public void cachePartKeys(boolean isRow, List<String> tabKeys) {
        Long dataSetId = this.getDataSetId();
        if (isRow) {
            this.setCache("all_row_part_keys" + dataSetId, SerializationUtils.toJsonString(tabKeys));
            return;
        }
        this.setCache("all_col_part_keys" + dataSetId, SerializationUtils.toJsonString(tabKeys));
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    private String getPartCacheF7Key(String f7Key, String partPartKey) {
        return f7Key + "_" + partPartKey;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryColumnVisible();
    }

    private String getCurPartF7Key(String key, String curPartKey) {
        return key + "_" + curPartKey;
    }

    private void setEntryColumnVisible() {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        ArrayList<Map<String, String>> rowDimList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> colDimList = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : pointEntry.entrySet()) {
            String key = entry.getKey();
            Map<String, String> dimInfo = entry.getValue();
            if (key.endsWith("row")) {
                rowDimList.add(dimInfo);
                continue;
            }
            if (!key.endsWith("col")) continue;
            colDimList.add(dimInfo);
        }
        this.setRowColPartEntryVisible(rowDimList, "rowentryentity");
        this.setRowColPartEntryVisible(colDimList, "colentryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            this.updatePartitionInfo();
        }
    }

    private void updatePartitionInfo() {
        ITemplateModel templateModel = this.getTemplateModelFromShowParam();
        IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
        Boolean isMetricInRow = this.getMetricPosition();
        Map<String, String> metricDim = new HashMap<String, String>();
        if (isMetricInRow != null) {
            String metricF7Key = isMetricInRow != false ? "ebf7_metric_row" : "ebf7_metric_col";
            metricDim = this.getPointEntry().get(metricF7Key);
        }
        boolean rowInfoWhole = this.updatePartitionInfo(partitionSetting, true, isMetricInRow, metricDim);
        boolean colInfoWhole = this.updatePartitionInfo(partitionSetting, false, isMetricInRow, metricDim);
        if (rowInfoWhole && colInfoWhole) {
            this.getView().returnDataToParent((Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
            this.getView().close();
        }
    }

    private boolean updatePartitionInfo(IPartitionSetting partitionSetting, boolean isRowPart, Boolean isMetricInRow, Map<String, String> metricDim) {
        List rowColPartition = partitionSetting.getRowPartition();
        if (!isRowPart) {
            rowColPartition = partitionSetting.getColPartition();
        }
        rowColPartition.clear();
        List<Map<String, String>> rowColPointEntry = this.getPointEntry(isRowPart ? "row" : "col");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(isRowPart ? "rowentryentity" : "colentryentity");
        for (DynamicObject object : entryEntity) {
            String partKey = object.getString(this.getEntryEntityPartKey(isRowPart));
            RowColPartition p = new RowColPartition();
            rowColPartition.add(p);
            ArrayList<DefaultRowColDimensionEntry> pe = new ArrayList<DefaultRowColDimensionEntry>(16);
            p.setRowColDimensionEntries(pe);
            for (Map<String, String> dimtype : rowColPointEntry) {
                String key = dimtype.get("sign");
                if (key.equals("ebf7_metric_row") || key.equals("ebf7_metric_col")) continue;
                DefaultRowColDimensionEntry rcde = new DefaultRowColDimensionEntry();
                pe.add(rcde);
                DefaultDimension dimEntity = new DefaultDimension(Long.valueOf(dimtype.get("id") + ""), dimtype.get("name"), dimtype.get("number"), Integer.valueOf(dimtype.get("seq")));
                rcde.setDimension((IDimension)dimEntity);
                ArrayList<DefaultDimMember> members = new ArrayList<DefaultDimMember>(16);
                rcde.setMembers(members);
                String curPartF7Key = this.getCurPartF7Key(key, partKey);
                if (this.getCache(curPartF7Key) == null || StringUtils.isEmpty((String)this.getCache(curPartF7Key))) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5b8c\u5584\u7ef4\u5ea6\u201c%1\u201d\u7684\u4fe1\u606f\u3002", (String)"ReportQueryDesignerListPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[]{dimtype.get("name")}));
                    return false;
                }
                List dimMaps = (List)SerializationUtils.fromJsonString((String)this.getCache(curPartF7Key), List.class);
                List memIds = dimMaps.stream().map(mem -> IDUtils.toLong(mem.get("id"))).collect(Collectors.toList());
                String memModel = dimtype.get("entity") + "";
                Map memEntitys = DimensionPropertyServiceHelper.getInstance().queryMembersCustomProperties(memIds, memModel);
                for (Map map : dimMaps) {
                    DefaultDimMember dimMember = new DefaultDimMember(IDUtils.toLong((Object)(map.get("id") + "")), map.get("name") + "", map.get("number") + "", Integer.parseInt(map.get("scope") + ""));
                    TemplateModelHelper.setMemProperty(dimMember, memEntitys, rcde.getDimension().getPropertyEntries());
                    members.add(dimMember);
                }
                if (isMetricInRow == null || isMetricInRow.booleanValue() && !isRowPart || !isMetricInRow.booleanValue() && isRowPart) continue;
                ArrayList<DefaultMetricDimMmeber> metricmembers = new ArrayList<DefaultMetricDimMmeber>(16);
                p.setMetricDimMmebers(metricmembers);
                String metricF7PartCacheKey = this.getPartCacheF7Key(metricDim.get("sign"), partKey);
                String cacheMetricMemValue = this.getCache(metricF7PartCacheKey);
                if (cacheMetricMemValue == null || StringUtils.isEmpty((String)cacheMetricMemValue)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c\u5ea6\u91cf\u201d\u4fe1\u606f\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"ReportQueryDesignerListPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                List metricMaps = (List)SerializationUtils.fromJsonString((String)cacheMetricMemValue, List.class);
                for (Map map : metricMaps) {
                    DefaultMetricDimMmeber metricmem = new DefaultMetricDimMmeber();
                    metricmem.setId(Long.valueOf(map.get("id") + ""));
                    metricmem.setNumber(map.get("number") + "");
                    metricmem.setName(map.get("name") + "");
                    String decimalnum = map.get("decimalnum") == null ? "2" : map.get("decimalnum") + "";
                    metricmem.setDecimalnum(decimalnum);
                    metricmembers.add(metricmem);
                }
            }
        }
        return true;
    }

    private Boolean getMetricPosition() {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        if (pointEntry.isEmpty()) {
            return null;
        }
        Set<String> f7Keys = pointEntry.keySet();
        if (f7Keys.contains("ebf7_metric_row")) {
            return true;
        }
        if (f7Keys.contains("ebf7_metric_col")) {
            return false;
        }
        return null;
    }

    public String getCurrentDimNumber(String controlKey) {
        return this.getDimNumByCtrlKey(controlKey);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith("ebf7") && key.endsWith("page")) {
            BasedataEdit edit = new BasedataEdit();
            edit.setKey(e.getKey());
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            e.setControl((Control)edit);
        }
    }

    private String getDimNumByCtrlKey(String ctrlKey) {
        String baseCtrlKey;
        String dimNum = "";
        Map<String, String> baseKeyMap = ReportQueryDesignerHelper.getInstance().getAllF7Map(this.getModelId(), this.getDataSetId(), true);
        if (baseKeyMap.containsKey(baseCtrlKey = ReportQueryHelper.getF7BaseKey(ctrlKey))) {
            dimNum = baseKeyMap.get(baseCtrlKey);
        }
        return dimNum;
    }

    private ITemplateModel getTemplateModelFromShowParam() {
        String customParam = this.getCache("TemplateModel");
        if (customParam == null) {
            customParam = (String)this.getView().getFormShowParameter().getCustomParam("TemplateModel");
            this.setCache("TemplateModel", customParam);
        }
        return TemplateModelJSONUtil.parseITemplateModel((String)customParam);
    }

    private Long getDataSetFormShowParam() {
        String datasetStr = this.getCache("dataset");
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)datasetStr)) {
            datasetStr = (String)this.getView().getFormShowParameter().getCustomParam("dataset");
            this.setCache("dataset", datasetStr);
        }
        return IDUtils.toLong((Object)datasetStr);
    }

    private Map<String, Map<String, String>> getPointEntry() {
        Map<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        String pointEntry = this.getCache("allPoint");
        if (pointEntry == null) {
            pointEntry = (String)this.getView().getFormShowParameter().getCustomParam("allPoint");
        }
        if (pointEntry == null && this.getTemplateModelFromShowParam() != null) {
            ReportQueryDesignerHelper instance = ReportQueryDesignerHelper.getInstance();
            result = instance.getPointEntryFromTemplateModel(this.getTemplateModelFromShowParam(), this.getDataSetId());
            this.setCache("allPoint", SerializationUtils.toJsonString(result));
            return result;
        }
        if (!StringUtils.isEmpty((String)pointEntry)) {
            result = (Map)SerializationUtils.fromJsonString((String)pointEntry, Map.class);
            this.setCache("allPoint", pointEntry);
        }
        return result;
    }

    private List<Map<String, String>> getPointEntry(String panel) {
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        if (pointEntry.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9762\u677f\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u3002", (String)"ReportQueryDesignerListPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : pointEntry.entrySet()) {
            String key = entry.getKey();
            Map<String, String> dimInfo = entry.getValue();
            if (!key.endsWith(panel)) continue;
            dimList.add(dimInfo);
        }
        return dimList;
    }

    private Map<String, String> getAllDimF7KeyMap() {
        LinkedHashMap<String, String> f7KeyMap = new LinkedHashMap<String, String>(16);
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        pointEntry.forEach((f7key, dimInfo) -> {
            f7KeyMap.put((String)f7key, (String)dimInfo.get("number"));
            f7KeyMap.put((String)dimInfo.get("number"), (String)f7key);
        });
        return f7KeyMap;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getCache("model");
        if (modelId == null) {
            modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.setCache("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    private Long getDataSetId() {
        String dataset = this.getCache("dataset");
        if (dataset == null) {
            dataset = this.getView().getFormShowParameter().getCustomParam("dataset").toString();
            this.setCache("dataset", dataset);
        }
        return IDUtils.toLong((Object)dataset);
    }

    private String getCache(String cacheKey) {
        return this.getPageCache().get(cacheKey);
    }

    private void setCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException var3) {
            throw new RuntimeException(var3);
        }
    }

    private void bindCtrlMapping() {
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        if (this.entityMeta == null) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            this.entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        Map<String, Map<String, String>> pointEntry = this.getPointEntry();
        pointEntry.values().forEach(dimInfo -> {
            String f7Key = (String)dimInfo.get("sign");
            if (!props.containsKey((Object)f7Key) && f7Key.endsWith("page")) {
                DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("pagedimpanel")), (MainEntityType)mainEntityType, (String)f7Key, (String)((String)dimInfo.get("entity")), (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        });
    }
}

