/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.designer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.ReportQueryDesignerConstant;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.report.designer.ReportQueryDesignerHelper;
import kd.epm.eb.formplugin.report.designer.ShareSettingDto;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import org.apache.commons.collections4.CollectionUtils;

public class ShareQuerySettingPlugin
extends AbstractBaseFormPlugin
implements ReportQueryDesignerConstant {
    public static final String CACHE_TEMPLATETYPE = "templatetype";
    private static final String CACHE_SELECTSHEAR = "cache_selectshare";
    private static final String CALLBACK_SELECTSHARE_COMFIRM = "callback_selectshare_confirm";
    private static final String RECEIVER = "receiver";
    private static final String ENTRYENTITY = "entryentity";
    private IModelCacheHelper modelCacheHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(RECEIVER);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntryEntityData();
    }

    private void initEntryEntityData() {
        ITemplateModel templateModel = this.getTemplateModelFromShowParam();
        Map<String, List<IDimensionMember>> pageDimMemValue = this.getPageDimMemValue(templateModel);
        Map<String, Map<String, String>> allPointEntry = this.getPointEntryFromTemplateModel(templateModel);
        Map<Object, Object> dimVisible = new HashMap(16);
        if (this.isMyShareNode()) {
            ShareSettingDto shareSetting = this.getQuerySettingFormParam();
            if (shareSetting != null) {
                dimVisible = shareSetting.getDimVisible();
            }
        } else {
            dimVisible = this.getDimDefHideMap(allPointEntry);
        }
        this.updateData(dimVisible, allPointEntry, pageDimMemValue);
    }

    private void updateData(Map<String, String> dimDefHideMap, Map<String, Map<String, String>> allPointEntry, Map<String, List<IDimensionMember>> pageDimMemValue) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRYENTITY);
        allPointEntry.forEach((f7Key, dimInfo) -> {
            String number = (String)dimInfo.get("number");
            int newRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, newRow);
            entryRowEntity.set("number", (Object)number);
            entryRowEntity.set("name", dimInfo.get("name"));
            entryRowEntity.set("hide", (Object)"0".equals(dimDefHideMap.get(number)));
            List members = (List)pageDimMemValue.get(number);
            if (f7Key.endsWith("page") && members != null) {
                List names = members.stream().map(IBaseEntry::getName).collect(Collectors.toList());
                entryRowEntity.set("defvalue", (Object)String.join((CharSequence)",", names));
                if (members.size() == 1 && !"ebf7_entity_page".equals(f7Key)) {
                    entryRowEntity.set("hide", (Object)true);
                }
            }
        });
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private boolean isMyShareNode() {
        return (Boolean)this.getFormCustomParam("isMyShareNode");
    }

    private ShareSettingDto getQuerySettingFormParam() {
        String param_querySetting = (String)this.getFormCustomParam("querysetting");
        if (param_querySetting != null) {
            return (ShareSettingDto)SerializationUtils.fromJsonString((String)param_querySetting, ShareSettingDto.class);
        }
        return new ShareSettingDto();
    }

    private Map<String, List<IDimensionMember>> getPageDimMemValue(ITemplateModel templateModel) {
        HashMap<String, List<IDimensionMember>> pageDimMemValue = new HashMap<String, List<IDimensionMember>>(16);
        List pagemembentry = templateModel.getPagemembentry();
        if (pagemembentry.size() > 0) {
            for (IPageDimensionEntry pageDimensionEntry : pagemembentry) {
                IDimension dimension = pageDimensionEntry.getDimension();
                List members = pageDimensionEntry.getMembers();
                pageDimMemValue.put(dimension.getNumber(), members);
            }
        }
        return pageDimMemValue;
    }

    private Map<String, String> getDimDefHideMap(Map<String, Map<String, String>> allPointEntry) {
        HashMap<String, String> dimDefHideMap = new HashMap<String, String>(16);
        ArrayList page = new ArrayList(10);
        allPointEntry.forEach((f7Key, dimInfo) -> {
            if (f7Key.endsWith("page")) {
                page.add(dimInfo);
            }
        });
        allPointEntry.forEach((f7Key, dimInfo) -> {
            boolean hide = f7Key.endsWith("page") && page.size() == 1 && !"Entity".equals(dimInfo.get("number"));
            dimDefHideMap.put((String)dimInfo.get("number"), hide ? "0" : "1");
        });
        return dimDefHideMap;
    }

    private Map<String, Map<String, String>> getPointEntryFromTemplateModel(ITemplateModel templateModel) {
        ReportQueryDesignerHelper instance = ReportQueryDesignerHelper.getInstance();
        return instance.getPointEntryFromTemplateModel(templateModel, this.getDataSetId());
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    public Long getModelId() {
        String modelId = this.getCache("model");
        if (modelId == null) {
            modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.setCache("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    private ITemplateModel getTemplateModelFromShowParam() {
        String customParam = this.getCache("TemplateModel");
        if (customParam == null) {
            customParam = (String)this.getView().getFormShowParameter().getCustomParam("TemplateModel");
            this.setCache("TemplateModel", customParam);
        }
        return TemplateModelJSONUtil.parseITemplateModel((String)customParam);
    }

    private void setCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isMyShareNode()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RECEIVER});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (RECEIVER.equals(key)) {
            this.addUserAndGroupFilter(listShowParameter);
        }
    }

    private void addUserAndGroupFilter(ListShowParameter listShowParameter) {
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "!=", (Object)this.getUserId()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            this.doOK();
        }
    }

    private void doOK() {
        if (this.isMyShareNode()) {
            this.toUpdateQuerySetting();
            return;
        }
        this.toShare();
    }

    private void toUpdateQuerySetting() {
        ShareSettingDto shareSettingDto = this.getShareSettingDto();
        this.returnDataToParent(shareSettingDto);
        this.getView().close();
    }

    private void toShare() {
        DynamicObjectCollection users = (DynamicObjectCollection)this.getModel().getValue(RECEIVER);
        if (CollectionUtils.isEmpty((Collection)users)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63a5\u6536\u4eba\u3002", (String)"ShareQuerySettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>(16);
        List<Long> selIds = users.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList());
        Map<Long, Set<Long>> existsReceiveMap = ReportQueryHelper.judgeIsRepeatShare(this.getUserId(), selIds, this.getReportId(), true);
        ArrayList<String> sharedUserNames = new ArrayList<String>(10);
        for (DynamicObject user : users) {
            HashMap<String, String> map = new HashMap<String, String>(3);
            Long id = user.getLong("fbasedataid.id");
            String name = user.getString("fbasedataid.name");
            map.put("id", user.getString("fbasedataid.id"));
            map.put("number", user.getString("fbasedataid.number"));
            map.put("name", name);
            userMaps.add(map);
            if (existsReceiveMap.size() <= 0 || !existsReceiveMap.containsKey(id)) continue;
            sharedUserNames.add(name);
        }
        this.setCache(CACHE_SELECTSHEAR, SerializationUtils.toJsonString(userMaps));
        if (sharedUserNames.size() > 0) {
            String confirmMsg = ResManager.loadResFormat((String)"\u8be5\u62a5\u8868\u5df2\u7ecf\u5206\u4eab\u7ed9%s\uff0c\u518d\u6b21\u5206\u4eab\u4f1a\u5c06\u539f\u6709\u62a5\u8868\u8986\u76d6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ShareQuerySettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", sharedUserNames)});
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SELECTSHARE_COMFIRM, (IFormPlugin)this));
        } else {
            this.doSelectShareUser(userMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent msgBoxEvt) {
        super.confirmCallBack(msgBoxEvt);
        String callBackId = msgBoxEvt.getCallBackId();
        if (callBackId.equals(CALLBACK_SELECTSHARE_COMFIRM) && msgBoxEvt.getResult().equals((Object)MessageBoxResult.Yes)) {
            String selectSharesCache = this.getCache(CACHE_SELECTSHEAR);
            if (StringUtils.isEmpty((String)selectSharesCache)) {
                return;
            }
            List selectShares = (List)SerializationUtils.fromJsonString((String)selectSharesCache, List.class);
            this.doSelectShareUser(selectShares);
        }
    }

    public void doSelectShareUser(List<Map<String, String>> userMaps) {
        if (userMaps == null || userMaps.size() == 0) {
            return;
        }
        String templateModelData = this.getTemplateModelData();
        CustomTreeNode root = this.getCacheTreeNode();
        if (root == null) {
            return;
        }
        Map dataMap = new HashMap(16);
        String curTreeNodId = this.getCurrentNodeId();
        String reportId = null;
        String reportName = "";
        CustomTreeNode curNode = root.getTreeNode(curTreeNodId, 10);
        if (curNode != null) {
            reportId = curNode.getId();
            dataMap = curNode.getData();
            reportName = curNode.getName();
        }
        if (reportId == null) {
            return;
        }
        String finalReportName = this.getReportName(reportName);
        String shareUserId = String.valueOf(this.getUserId());
        String description = this.getDescription(finalReportName, reportId, dataMap);
        MainEntityType shareType = EntityMetadataCache.getDataEntityType((String)"eb_reportshare");
        ArrayList<String> msgList = new ArrayList<String>(16);
        ArrayList<DynamicObject> shareReportDys = new ArrayList<DynamicObject>(16);
        QFilter filter2 = new QFilter("id", "=", (Object)IDUtils.toLong((Object)reportId));
        QFilter[] filter = new QFilter[]{filter2};
        Boolean isShare = this.isShareNode();
        String formId = isShare != false ? "eb_reportshare" : "eb_reportquery";
        String selFields = isShare != false ? "id,reportcatalog,formid,reportid" : "id,reportcatalog";
        DynamicObject repShareDy = QueryServiceHelper.queryOne((String)formId, (String)selFields, (QFilter[])filter);
        Long catalogId = ReportQueryHelper.getCatalogId(this.getCurTab(), reportId, isShare);
        Date shareDate = new Date(System.currentTimeMillis());
        Long modelId = this.getModelId();
        String templateType = this.getTemplateType();
        List<Long> shareUserIds = userMaps.stream().map(m -> IDUtils.toLong(m.get("id"))).collect(Collectors.toList());
        List shareUserNames = userMaps.stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
        Long msgId = this.sendMessageToReceivers(shareUserIds, curTreeNodId);
        if (msgId == null || msgId == 0L) {
            msgList.add(shareUserNames + " " + ResManager.loadKDString((String)"\u5206\u4eab\u5931\u8d25", (String)"ShareQuerySettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        msgList.add(shareUserNames + " " + ResManager.loadKDString((String)"\u5206\u4eab\u6210\u529f", (String)"ShareQuerySettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String shareQuerySettingStr = SerializationUtils.toJsonString((Object)this.getShareSettingDto());
        for (Map<String, String> userMap : userMaps) {
            String kId = userMap.get("id");
            DynamicObject doSharType = new DynamicObject((DynamicObjectType)shareType);
            doSharType.set("number", dataMap.get("number"));
            doSharType.set("name", (Object)finalReportName);
            doSharType.set(RECEIVER, (Object)kId);
            doSharType.set("sharers", (Object)shareUserId);
            doSharType.set("sharedate", (Object)shareDate);
            doSharType.set("islook", (Object)"B");
            doSharType.set("sharestatus", (Object)"A");
            doSharType.set("status", (Object)"A");
            doSharType.set("modelid", (Object)modelId);
            doSharType.set(CACHE_TEMPLATETYPE, (Object)templateType);
            doSharType.set("description", (Object)description);
            doSharType.set("data", (Object)templateModelData);
            doSharType.set("querysetting", (Object)shareQuerySettingStr);
            if (this.isShareNode(curNode).booleanValue()) {
                if (repShareDy != null) {
                    doSharType.set("reportcatalog", (Object)repShareDy.getLong("reportcatalog"));
                    doSharType.set("formid", (Object)repShareDy.getString("formid"));
                    doSharType.set("reportid", (Object)repShareDy.getLong("id"));
                }
            } else {
                doSharType.set("reportcatalog", (Object)catalogId);
                doSharType.set("formid", (Object)(this.getCurTab().equals("tab_rptquery") ? "eb_templateentity" : "eb_reportquery"));
                doSharType.set("reportid", (Object)reportId);
            }
            doSharType.set("messageid", (Object)msgId);
            doSharType.set("flagId", (Object)this.getCache("flagId"));
            doSharType.set("dataset", (Object)this.getDataSetId());
            shareReportDys.add(doSharType);
        }
        List<Long> selIds = userMaps.stream().map(usermap -> Long.parseLong((String)usermap.get("id"))).collect(Collectors.toList());
        List selNum = userMaps.stream().map(usermap -> (String)usermap.get("number")).collect(Collectors.toList());
        Map<Long, Set<Long>> existsReciveMap = ReportQueryHelper.judgeIsRepeatShare(this.getUserId(), selIds, reportId, false);
        List<Long> existsIDs = existsReciveMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (existsIDs.size() > 0) {
            ReportQueryHelper.delRepeatShare(existsIDs);
        }
        if (shareReportDys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])shareReportDys.toArray(new DynamicObject[0]));
        }
        if (msgList.size() > 0) {
            this.getView().showSuccessNotification(String.join((CharSequence)"; ", msgList));
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u4eab", "ShareQuerySettingPlugin_01", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u62a5\u8868%1$s\u5206\u4eab\u7ed9\u7528\u6237\uff1a%2$s\u3002", "ShareQuerySettingPlugin_02", "epm-eb-formplugin");
        String[] opDescArgs = new String[]{reportId, selNum.toString()};
        this.writeLog(null, "share", opName, opDesc, opDescArgs);
    }

    private ShareSettingDto getShareSettingDto() {
        ShareSettingDto shareSettingDto = this.getQuerySettingFormParam();
        Map<String, String> dimVisible = shareSettingDto.getDimVisible();
        dimVisible.clear();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject object : entryEntity) {
            String number = object.getString("number");
            boolean hide = object.getBoolean("hide");
            dimVisible.put(number, hide ? "0" : "1");
        }
        return shareSettingDto;
    }

    private Long getDataSetId() {
        return (Long)this.getFormCustomParam("dataset");
    }

    public Boolean isShareNode() {
        Boolean result = false;
        CustomTreeNode root = this.getCacheTreeNode();
        if (root == null) {
            return result;
        }
        String curTreeNodId = this.getCurrentNodeId();
        CustomTreeNode curNode = root.getTreeNode(curTreeNodId, 10);
        return this.isShareNode(curNode);
    }

    public Boolean isShareNode(CustomTreeNode customTreeNode) {
        HashMap dataMap;
        boolean result = false;
        if (customTreeNode != null && customTreeNode.getData() != null && (dataMap = (HashMap)customTreeNode.getData()).containsKey("sharers")) {
            result = true;
        }
        return result;
    }

    public Long sendMessageToReceivers(List<Long> shareUserIds, String curTreeNodId) {
        MessageInfo messageInfo = new MessageInfo();
        LocaleString title = new LocaleString();
        LocaleString tag = new LocaleString();
        List<Object> receivers = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmssSSS");
        String flagId = sdf.format(new Date());
        this.setCache("flagId", flagId);
        title.setLocaleValue(ResManager.loadResFormat((String)"\u4f60\u597d\uff0c%1,\u7ed9\u4f60\u5206\u4eab\u4e86\u9884\u7b97\u62a5\u8868\uff0c\u8bf7\u6253\u5f00\u94fe\u63a5\u67e5\u770b", (String)"ShareQuerySettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
        tag.setLocaleValue(ResManager.loadKDString((String)"\u9884\u7b97\u62a5\u8868", (String)"ShareQuerySettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        receivers = shareUserIds;
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)title);
        messageInfo.setUserIds(receivers);
        messageInfo.setSenderId(Long.valueOf(this.getUserId()));
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setMessageTag((ILocaleString)tag);
        String currentUrl = UrlService.getDomainContextUrl();
        messageInfo.setContentUrl(currentUrl + "/?formId=eb_reportqueryprocess&pkId=" + this.getModelId() + "/" + "tab_myinterest" + "/" + curTreeNodId + "/" + flagId);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private String getTemplateType() {
        return (String)this.getFormCustomParam(CACHE_TEMPLATETYPE);
    }

    private String getCurrentNodeId() {
        return (String)this.getFormCustomParam("currentNodeId");
    }

    private String getTemplateModelData() {
        String customParam = this.getCache("TemplateModel");
        if (customParam == null) {
            customParam = (String)this.getView().getFormShowParameter().getCustomParam("TemplateModel");
            if (customParam == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u8868\u6a21\u578b\u5931\u8d25\u3002", (String)"ShareQuerySettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.setCache("TemplateModel", customParam);
        }
        return customParam;
    }

    private CustomTreeNode getCacheTreeNode() {
        String cache = this.getCache("cacheTreeNode");
        if (cache == null) {
            cache = (String)this.getFormCustomParam("cacheTreeNode");
        }
        if (StringUtils.isEmpty((String)cache)) {
            return null;
        }
        return (CustomTreeNode)JSONObject.parseObject((String)cache, CustomTreeNode.class);
    }

    private String getReportId() {
        return (String)this.getFormCustomParam("reportId");
    }

    public String getReportName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        String result = name;
        String[] names = name.split("\\(");
        if (names.length > 1) {
            result = names[0];
        }
        return result;
    }

    public String getDescription(String finalreportName, String reportid, Map<?, ?> dataMap) {
        String description = ResManager.loadKDString((String)"\u62a5\u8868\u5206\u4eab", (String)"ShareQuerySettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String tab = this.getCurTab();
        if (tab.equals("tab_rptquery")) {
            description = finalreportName;
        } else {
            QFilter filter = new QFilter("number", "=", dataMap.get("number"));
            QFilter filter2 = new QFilter("reportcatalog", "=", (Object)IDUtils.toLong(dataMap.get("catalog")));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportquery", (String)"id,description", (QFilter[])new QFilter[]{filter, filter2});
            if (dynamicObject != null) {
                description = dynamicObject.getString("description");
            }
        }
        return description;
    }

    private String getCurTab() {
        return (String)this.getFormCustomParam("cache_tab");
    }
}

