/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportHelper;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;

public class BgmReportExportAddPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BgmReportExportAddPlugin.class);
    private Map<String, Set<String>> errorInfoMap = null;

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData("entryentity");
        this.setBtnVisible();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object processIdsJson = customParams.get("allReportProcessId");
        if (processIdsJson == null) {
            return;
        }
        List processIds = (List)SerializationUtils.fromJsonString((String)processIdsJson.toString(), ArrayList.class);
        if (processIds == null || processIds.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)processIds);
        DynamicObjectCollection reportProcess = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, template, entity, modifier, modifydate", (QFilter[])new QFilter[]{filter});
        if (reportProcess.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> processMap = reportProcess.stream().collect(Collectors.toMap(k -> k.getLong("id"), k -> k));
        Object sourceType = customParams.get("sourceType");
        Object sourceId = customParams.get("schemeId");
        for (Long processId : processIds) {
            DynamicObject process = processMap.get(processId);
            if (process == null) continue;
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("reportprocess", (Object)process.getLong("id"), newEntryRow);
            this.getModel().setValue("template", (Object)process.getLong("template"), newEntryRow);
            this.getModel().setValue("entity", (Object)process.getLong("entity"), newEntryRow);
            if (sourceType != null) {
                this.getModel().setValue("sourcetype", (Object)sourceType.toString(), newEntryRow);
                if (sourceId != null) {
                    this.getModel().setValue("source", (Object)ConvertUtils.toLong(sourceId), newEntryRow);
                }
            }
            this.getModel().setValue("modifier", (Object)process.getLong("modifier"), newEntryRow);
            this.getModel().setValue("modifytime", (Object)process.getDate("modifydate"), newEntryRow);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultSelect();
    }

    private void setBtnVisible() {
        Object pageType = this.getView().getFormShowParameter().getCustomParam("pageType");
        if (pageType == null || "add".equals(pageType.toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_adjustrange", "btn_export"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_ok"});
        }
    }

    private void setDefaultSelect() {
        Object curProcessIdJson;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object processIdsJson = customParams.get("reportProcessIdSet");
        if (processIdsJson == null) {
            return;
        }
        List processIds = (List)SerializationUtils.fromJsonString((String)processIdsJson.toString(), ArrayList.class);
        if (processIds.size() == 0 && (curProcessIdJson = customParams.get("curProcessId")) != null) {
            processIds.add(ConvertUtils.toLong(curProcessIdJson));
        }
        ArrayList<Integer> toSelectRows = new ArrayList<Integer>(16);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            long reportProcessId = dynamicObject.getLong("reportprocess");
            if (!processIds.contains(reportProcessId)) continue;
            toSelectRows.add(i);
        }
        if (toSelectRows.size() == 0) {
            return;
        }
        int[] rows = new int[toSelectRows.size()];
        int index = 0;
        for (Integer toSelectRow : toSelectRows) {
            rows[index++] = toSelectRow;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(rows, 0);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_adjustrange", "btn_export"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ok".equals(key)) {
            this.returnSelectReportProcess();
        } else if ("btn_adjustrange".equals(key)) {
            this.openAdjustPage();
        } else if ("btn_export".equals(key)) {
            this.exportSelectedProcess();
        }
    }

    private void returnSelectReportProcess() {
        int[] rows;
        ArrayList<Object[]> retValues = new ArrayList<Object[]>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int row : rows = entryGrid.getSelectRows()) {
            Object[] retValue = new Object[4];
            retValue[0] = this.getModel().getValue("reportprocess", row);
            Object templateObj = this.getModel().getValue("template", row);
            String templateNumber = "";
            String templateName = "";
            if (templateObj instanceof DynamicObject) {
                DynamicObject template = (DynamicObject)templateObj;
                templateNumber = template.getString("number");
                templateName = template.getString("name");
            }
            retValue[1] = templateNumber;
            retValue[2] = templateName;
            Object entityObj = this.getModel().getValue("entity", row);
            String entityName = "";
            if (entityObj instanceof DynamicObject) {
                DynamicObject entity = (DynamicObject)entityObj;
                entityName = entity.getString("name");
            }
            retValue[3] = entityName;
            retValues.add(retValue);
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(retValues));
        this.getView().close();
    }

    private void openAdjustPage() {
        Map taskProcessIdMap;
        List<Long> selectedProcess = this.getSelectedProcess();
        if (selectedProcess == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bgm_reportexport");
        formShowParameter.addCustPlugin("kd.epm.eb.formplugin.report.excel.BgmReportExportDataPlugin");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("reportProcessIdSet", SerializationUtils.toJsonString(selectedProcess));
        String taskProcessMapJson = (String)customParams.get("taskProcessIdMap");
        Map map = taskProcessIdMap = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taskProcessMapJson) ? (Map)SerializationUtils.deSerializeFromBase64((String)taskProcessMapJson) : null;
        if (taskProcessIdMap != null) {
            customParams.put("taskProcessIdMap", SerializationUtils.serializeToBase64((Object)taskProcessIdMap));
        }
        formShowParameter.setCustomParams(customParams);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("800px");
        styleCss.setWidth("1200px");
        openStyle.setInlineStyleCss(styleCss);
        formShowParameter.setCustomParam("addItems", (Object)"true");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void exportSelectedProcess() {
        List<Long> selectedProcess = this.getSelectedProcess();
        if (selectedProcess == null) {
            return;
        }
        try {
            List<ReportExportDataRequest> reportExportDataRequestList = this.createReportExportDataRequestList(selectedProcess);
            if (this.errorInfoMap != null && this.errorInfoMap.size() > 0) {
                ArrayList<String> errorInfos = new ArrayList<String>(16);
                for (Map.Entry<String, Set<String>> entry : this.errorInfoMap.entrySet()) {
                    String key = entry.getKey();
                    Set<String> value = entry.getValue();
                    for (String s : value) {
                        errorInfos.add(ResManager.loadResFormat((String)"%1:%2", (String)"BgmReportExportDataPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{s, key}));
                    }
                }
                this.getPageCache().put("reportExportDataRequestList", SerializationUtils.serializeToBase64(reportExportDataRequestList));
                String errorTitle = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u51fa\u4e2d\u5b58\u5728\u4e0d\u7b26\u5408\u5408\u6cd5\u6027\u6821\u9a8c\u7684\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(errorTitle, String.join((CharSequence)"\n", errorInfos), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("exportDataConfirm"));
            } else {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportCloseCallBack");
                Map<String, String> returnTipsMap = ReportExportDataController.getInstance().exportReportData(reportExportDataRequestList, this.getView(), closeCallBack);
                if (returnTipsMap != null) {
                    String success = returnTipsMap.get("success");
                    String failed = returnTipsMap.get("failed");
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)success)) {
                        this.getView().returnDataToParent(returnTipsMap);
                        this.getView().close();
                    } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failed)) {
                        this.getView().showTipNotification(failed);
                    }
                }
            }
        }
        catch (Exception exception) {
            DynamicObject dynamicObject;
            String exportFileId = this.getPageCache().get("exportfileid");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
                dynamicObject.set("status", (Object)"2");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
            log.error(this.getClass().getName());
            log.error((Throwable)exception);
            if (exception instanceof KDBizException) {
                throw new KDBizException(exception.getMessage());
            }
            throw new KDBizException(ThrowableHelper.toString((Exception)exception));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("exportDataConfirm".equals(callBackId) && result == MessageBoxResult.Yes) {
            try {
                String reportExportDataRequestListStr = this.getPageCache().get("reportExportDataRequestList");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reportExportDataRequestListStr)) {
                    List reportExportDataRequestList = (List)SerializationUtils.deSerializeFromBase64((String)reportExportDataRequestListStr);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportCloseCallBack");
                    Map<String, String> returnTipsMap = ReportExportDataController.getInstance().exportReportData(reportExportDataRequestList, this.getView(), closeCallBack);
                    if (returnTipsMap != null) {
                        String success = returnTipsMap.get("success");
                        String failed = returnTipsMap.get("failed");
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)success)) {
                            this.getView().showSuccessNotification(success);
                        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failed)) {
                            this.getView().showTipNotification(failed);
                        }
                    }
                }
            }
            catch (Exception exception) {
                DynamicObject dynamicObject;
                log.error((Throwable)exception);
                String exportFileId = this.getPageCache().get("exportfileid");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
                    dynamicObject.set("status", (Object)"2");
                    SaveServiceHelper.update((DynamicObject)dynamicObject);
                }
                log.error(this.getClass().getName());
                log.error((Throwable)exception);
                if (exception instanceof KDBizException) {
                    throw new KDBizException(exception.getMessage());
                }
                throw new KDBizException(ThrowableHelper.toString((Exception)exception));
            }
        }
    }

    private List<ReportExportDataRequest> createReportExportDataRequestList(List<Long> selectedProcesses) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgView = ConvertUtils.toLong(customParams.get("orgViewId"));
        ProcessTypeEnum processType = (ProcessTypeEnum)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("processtype")));
        Long modelId = ConvertUtils.toLong(customParams.get("model"));
        ReportExportTypeEnum exportType = ReportExportTypeEnum.EXPORT_DATA.toString().equals(customParams.get("exportType")) ? ReportExportTypeEnum.EXPORT_DATA : ReportExportTypeEnum.EXPORT_TEMPLATE;
        String taskProcessMapJson = (String)customParams.get("taskProcessIdMap");
        Map taskProcessIdMap = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taskProcessMapJson) ? (Map)SerializationUtils.deSerializeFromBase64((String)taskProcessMapJson) : null;
        long processId = IDUtils.toLong(customParams.get("processId"));
        ArrayList<ReportExportDataRequest> reportExportDataRequests = new ArrayList<ReportExportDataRequest>(16);
        HashMap<Long, DynamicObject> processes = new HashMap<Long, DynamicObject>(16);
        String fields = "id, template.id, template.name, template.number, entity.id, entity.name, entity.number";
        DynamicObjectCollection processInfos = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", selectedProcesses)});
        processInfos.forEach(e -> processes.put(e.getLong("id"), (DynamicObject)e));
        this.errorInfoMap = new HashMap<String, Set<String>>(16);
        Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMember(processes, customParams, processId, processType);
        for (Long selectedProcess : selectedProcesses) {
            DynamicObject process = (DynamicObject)processes.get(selectedProcess);
            long templateId = process.getLong("template.id");
            long taskProcessId = 0L;
            taskProcessId = taskProcessIdMap != null ? taskProcessIdMap.getOrDefault(selectedProcess, 0L) : processId;
            long entityId = process.getLong("entity.id");
            Map<String, String> pageDimMemberMap = allPageDimMemberMap.get(selectedProcess);
            if (pageDimMemberMap == null) continue;
            ReportExportDataRequest reportExportDataRequest = new ReportExportDataRequest(Long.valueOf(templateId), Long.valueOf(entityId), orgView, selectedProcess, Long.valueOf(taskProcessId), processType, modelId, Boolean.valueOf(false), Boolean.valueOf(false), pageDimMemberMap, ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa", (String)"BgmReportExportDataPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getSheetName(process), exportType, true);
            reportExportDataRequest.setFormId(this.getBizEntityNumber());
            reportExportDataRequest.setShowDimName(true);
            reportExportDataRequest.setUserId(this.getUserId());
            reportExportDataRequest.setFilterMemberList(this.getFilter());
            reportExportDataRequests.add(reportExportDataRequest);
        }
        return reportExportDataRequests;
    }

    private List<Map<String, List<MemberCondition>>> getFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterInfo = (String)formShowParameter.getCustomParam("filterInfo");
        if (StringUtils.isNotEmpty((String)filterInfo)) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)filterInfo);
        }
        return null;
    }

    private Map<Long, Map<String, String>> getAllPageDimMember(Map<Long, DynamicObject> selectedProcesses, Map<String, Object> customParams, long processId, ProcessTypeEnum processType) {
        HashMap<Long, Map<String, String>> allPageDimMemberMap = new HashMap<Long, Map<String, String>>(16);
        Map<String, Long> defaultDimensionNumberIdMap = this.getDefaultDimensionNumberIdMap(customParams);
        Long period = ConvertUtils.toLong((Object)customParams.get("period"));
        for (Map.Entry<Long, DynamicObject> entry : selectedProcesses.entrySet()) {
            Long process = entry.getKey();
            DynamicObject processInfo = entry.getValue();
            Long templateId = processInfo.getLong("template.id");
            try {
                Map<String, String> dimMemberNumberMap = ReportExportHelper.getInstance().getDimMemberNumberMap(this.getView(), allPageDimMemberMap, defaultDimensionNumberIdMap, this.getModelId(), period, processType, processId, process, templateId, processInfo.getLong("entity.id"), processInfo.getString("entity.number"), ConvertUtils.toLong((Object)customParams.get("orgViewId")), null);
                allPageDimMemberMap.put(process, dimMemberNumberMap);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                String number = processInfo.getString("template.number");
                String name = processInfo.getString("template.name");
                Set strings = this.errorInfoMap.computeIfAbsent(e.getMessage(), t -> new HashSet(16));
                strings.add(name + "\u3010" + number + "\u3011");
            }
        }
        return allPageDimMemberMap;
    }

    private Map<String, Long> getDefaultDimensionNumberIdMap(Map<String, Object> customParams) {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        result.put(SysDimensionEnum.BudgetPeriod.getNumber(), ConvertUtils.toLong((Object)customParams.get("period")));
        result.put(SysDimensionEnum.DataType.getNumber(), ConvertUtils.toLong((Object)customParams.get("dataType")));
        result.put(SysDimensionEnum.Version.getNumber(), ConvertUtils.toLong((Object)customParams.get("version")));
        return result;
    }

    private String getSheetName(DynamicObject process) {
        return process.getString("template.name") + "_" + process.getString("entity.name");
    }

    private List<Long> getSelectedProcess() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"BgmReportExportAddPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<Long> selectedProcessIds = new ArrayList<Long>(16);
        for (int row : rows) {
            Object processId = this.getModel().getValue("reportprocess", row);
            selectedProcessIds.add(ConvertUtils.toLong((Object)processId));
        }
        return selectedProcessIds;
    }

    @Override
    public Long getModelId() {
        return ConvertUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }
}

