/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import org.apache.commons.lang3.StringUtils;

public class BgmReportExportByOrgPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BgmReportExportByOrgPlugin.class);
    private static final ReportExportDataController reportExportDataController = ReportExportDataController.getInstance();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    @Override
    public Long getModelId() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        return IDUtils.toLong((Object)model);
    }

    private Long getSchemeAssignId() {
        Object schemeAssignId = this.getView().getFormShowParameter().getCustomParam("schemeAssignId");
        return IDUtils.toLong((Object)schemeAssignId);
    }

    private Long getSchemeId() {
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
        return IDUtils.toLong((Object)schemeId);
    }

    private Long getPeriodId() {
        Object period = this.getView().getFormShowParameter().getCustomParam("period");
        return IDUtils.toLong((Object)period);
    }

    private Long getDataTypeId() {
        Object dataType = this.getView().getFormShowParameter().getCustomParam("dataType");
        return IDUtils.toLong((Object)dataType);
    }

    private Long getVersionId() {
        Object version = this.getView().getFormShowParameter().getCustomParam("version");
        return IDUtils.toLong((Object)version);
    }

    private Long getOrgViewId() {
        Object orgViewId = this.getView().getFormShowParameter().getCustomParam("orgViewId");
        return IDUtils.toLong((Object)orgViewId);
    }

    private Long getCurrentEntityId() {
        Object currentEntity = this.getView().getFormShowParameter().getCustomParam("currentEntity");
        return IDUtils.toLong((Object)currentEntity);
    }

    private Long getDataSetId() {
        Object dataSetId = this.getView().getFormShowParameter().getCustomParam("dataSetId");
        return IDUtils.toLong((Object)dataSetId);
    }

    private Set<Long> getTemplateIdSet() {
        Object templateIdSet = this.getView().getFormShowParameter().getCustomParam("templateIdSet");
        if (templateIdSet != null) {
            return (Set)SerializationUtils.deSerializeFromBase64((String)templateIdSet.toString());
        }
        return new HashSet<Long>(16);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                Object orgrange = this.getModel().getValue("orgrange");
                if (orgrange == null) {
                    return;
                }
                ReportExportDataRequest request = new ReportExportDataRequest();
                request.setEntityId(this.getCurrentEntityId());
                String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6", (String)"BgmReportExportDataPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                request.setFileName(fileName);
                request.setExportData(true);
                request.setProcessType(ProcessTypeEnum.REPORT);
                request.setExportTypeEnum(ReportExportTypeEnum.EXPORT_BY_ORG);
                request.setEntityViewId(this.getOrgViewId());
                request.setReportProcessId(this.getSchemeAssignId());
                request.setModelId(this.getModelId());
                request.setExportByOrgTemplateIdSet(this.getTemplateIdSet());
                request.setSchemeId(this.getSchemeId());
                request.setPeriodId(this.getPeriodId());
                request.setDataTypeId(this.getDataTypeId());
                request.setVersionId(this.getVersionId());
                request.setDataSetId(this.getDataSetId());
                request.setUserId(this.getUserId());
                RangeEnum rangeByVal = RangeEnum.getRangeByVal((int)Integer.parseInt(orgrange.toString()));
                request.setExportByOrgRange(rangeByVal);
                ArrayList<ReportExportDataRequest> reportExportDataRequestList = new ArrayList<ReportExportDataRequest>(16);
                reportExportDataRequestList.add(request);
                Map<String, String> returnTipsMap = reportExportDataController.exportReportData(reportExportDataRequestList, this.getView(), null);
                if (returnTipsMap != null) {
                    String success = returnTipsMap.get("success");
                    String failed = returnTipsMap.get("failed");
                    if (StringUtils.isNotBlank((CharSequence)success)) {
                        this.getView().showSuccessNotification(success);
                    } else if (StringUtils.isNotBlank((CharSequence)failed)) {
                        this.getView().showTipNotification(failed);
                    }
                }
                this.getView().returnDataToParent(returnTipsMap);
                this.getView().close();
                break;
            }
        }
    }
}

