/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgmReportExportFileRulePlugin
extends AbstractFormPlugin {
    public static final String BGM_FILESHEETNAMERULE = "bgm_filesheetnamerule";
    public static final String BTN_GO = "btngo";
    public static final String BTN_BACK = "btnback";
    public static final String BTN_CONFIRM = "bar_confirm";
    public static final String ENTRYENTITY_TOSELECT = "toselectentryentity";
    public static final String ENTRYENTITY_SELECTED = "selectentryentity";

    public void initialize() {
        super.initialize();
    }

    private List<FiledMember> getToSelectFiledMembers() {
        return Arrays.asList(new FiledMember("report.number", ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"BgmReportExportFileRulePlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("report.name", ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("entity.number", ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"BgmReportExportFileRulePlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("entity.name", ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("period.number", ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801", (String)"BgmReportExportFileRulePlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("period.name", ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("datatype.number", ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u7f16\u7801", (String)"BgmReportExportFileRulePlugin_07", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("datatype.name", ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("version.number", ResManager.loadKDString((String)"\u7248\u672c\u7f16\u7801", (String)"BgmReportExportFileRulePlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("version.name", ResManager.loadKDString((String)"\u7248\u672c\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), false), new FiledMember("fixvalue", ResManager.loadKDString((String)"\u56fa\u5b9a\u503c", (String)"BgmReportExportFileRulePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), false));
    }

    public void afterCreateNewData(EventObject e) {
        this.initPageData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFixValueEnable();
    }

    private void initPageData() {
        int i;
        boolean isfileNameSelect = this.isFileNameSelect();
        List<FiledMember> selectedFiledMember = this.getSelectedFiledMember();
        boolean isExistSelected = CollectionUtils.isNotEmpty(selectedFiledMember);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRYENTITY_TOSELECT);
        Set selectedFiledMemberNumberSet = selectedFiledMember.stream().map(FiledMember::getFiledNumber).collect(Collectors.toSet());
        List<FiledMember> toSelectFiledMembers = this.getToSelectFiledMembers();
        int n = i = isfileNameSelect ? 2 : 0;
        while (i < toSelectFiledMembers.size()) {
            FiledMember filedMember = toSelectFiledMembers.get(i);
            int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY_TOSELECT);
            this.getModel().setValue("tobeselectobj", (Object)filedMember.getFiledName(), newEntryRow);
            this.getModel().setValue("tobeselectnumber", (Object)filedMember.getFiledNumber(), newEntryRow);
            if (isExistSelected && selectedFiledMemberNumberSet.contains(filedMember.getFiledNumber())) {
                this.getModel().setValue("isselect", (Object)"1", newEntryRow);
            }
            ++i;
        }
        this.getModel().deleteEntryData(ENTRYENTITY_SELECTED);
        if (isExistSelected) {
            int[] ints = this.getModel().batchCreateNewEntryRow(ENTRYENTITY_SELECTED, selectedFiledMember.size());
            int i2 = 0;
            for (FiledMember filedMember : selectedFiledMember) {
                this.getModel().setValue("selectedobj", (Object)filedMember.getFiledName(), ints[i2]);
                this.getModel().setValue("selectednumber", (Object)filedMember.getFiledNumber(), ints[i2]);
                ++i2;
            }
        }
        this.getModel().setValue("joiner", this.getView().getFormShowParameter().getCustomParam("joiner"));
        this.getModel().setValue("fixvalue", this.getView().getFormShowParameter().getCustomParam("fixvalue"));
        this.getModel().endInit();
        this.cacheSelectedFiledMember();
    }

    private List<FiledMember> getSelectedFiledMember() {
        String selectedFiledStr = this.getView().getPageCache().get("selectedFiledStr");
        if (selectedFiledStr == null) {
            selectedFiledStr = (String)this.getView().getFormShowParameter().getCustomParam("selectedFiledStr");
        }
        if (selectedFiledStr == null) {
            return new ArrayList<FiledMember>();
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)selectedFiledStr);
    }

    private void cacheSelectedFiledMember() {
        ArrayList<FiledMember> selectedFiledMember = new ArrayList<FiledMember>();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY_SELECTED);
        if (CollectionUtils.isNotEmpty((Collection)entity)) {
            for (DynamicObject object : entity) {
                FiledMember filedMember = new FiledMember();
                filedMember.setFiledName(object.getString("selectedobj"));
                filedMember.setFiledNumber(object.getString("selectednumber"));
                filedMember.setSelected(true);
                selectedFiledMember.add(filedMember);
            }
        }
        this.getView().getPageCache().put("selectedFiledStr", SerializationUtils.serializeToBase64(selectedFiledMember));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_GO, BTN_BACK, BTN_CONFIRM});
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_GO.equals(key) || BTN_BACK.equals(key)) {
            if (this.checkSelectRows(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"BgmReportExportFileRulePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BTN_CONFIRM.equals(key) && this.beforeConfirmCheck()) {
            evt.setCancel(true);
        }
    }

    private boolean beforeConfirmCheck() {
        List<FiledMember> selectedFiled = this.getSelectedFiledMember();
        if (selectedFiled.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u9009\u5c5e\u6027\u3002", (String)"BgmReportExportFileRulePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        Set<String> selectedFiledMemberNumberSet = selectedFiled.stream().map(FiledMember::getFiledNumber).collect(Collectors.toSet());
        return this.checkFixValueFormat(selectedFiledMemberNumberSet);
    }

    private boolean checkFixValueFormat(Set<String> selectedFiledMemberNumberSet) {
        String fixValue = (String)this.getModel().getValue("fixvalue");
        if (selectedFiledMemberNumberSet.contains("fixvalue") && StringUtils.isEmpty((String)fixValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u56fa\u5b9a\u503c\u3002", (String)"BgmReportExportFileRulePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FA5A-Za-z0-9]+$");
        Matcher matcher = pattern.matcher(fixValue);
        if (selectedFiledMemberNumberSet.contains("fixvalue") && !matcher.matches()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u503c\u53ea\u5141\u8bb8\u5305\u542b\u6c49\u5b57\u3001\u5b57\u6bcd\u548c\u6570\u5b57\u3002", (String)"BgmReportExportFileRulePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkSelectRows(String key) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_SELECTED);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(ENTRYENTITY_TOSELECT);
        if (BTN_GO.equals(key)) {
            return entryGrid1.getSelectRows().length == 0;
        }
        return entryGrid.getSelectRows().length == 0;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btngo": {
                this.dealGo();
                this.setFixValueEnable();
                break;
            }
            case "btnback": {
                this.dealBack();
                this.setFixValueEnable();
                break;
            }
            case "bar_confirm": {
                this.dealConfirm();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("moveentryup".equals(key) || "moveentrydown".equals(key)) {
            this.cacheSelectedFiledMember();
        }
    }

    private void dealConfirm() {
        HashMap<String, Object> nameFormatInfo = new HashMap<String, Object>(4);
        List<FiledMember> selectedFiled = this.getSelectedFiledMember();
        if (selectedFiled.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u9009\u5c5e\u6027\u3002", (String)"BgmReportExportFileRulePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String joiner = (String)this.getModel().getValue("joiner");
        String fixvalue = (String)this.getModel().getValue("fixvalue");
        nameFormatInfo.put("selectedFiled", selectedFiled);
        nameFormatInfo.put("joiner", joiner);
        nameFormatInfo.put("fixvalue", fixvalue);
        nameFormatInfo.put("namesource", this.isFileNameSelect() ? "filename" : "sheetname");
        this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(nameFormatInfo));
        this.getView().close();
    }

    private void dealBack() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_SELECTED);
        int[] rows = entryGrid.getSelectRows();
        this.getModel().deleteEntryRows(ENTRYENTITY_SELECTED, rows);
        this.cacheSelectedFiledMember();
        Set selectedFiledMemberNumberSet = this.getSelectedFiledMember().stream().map(FiledMember::getFiledNumber).collect(Collectors.toSet());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection selectedEntity = dataEntity.getDynamicObjectCollection(ENTRYENTITY_TOSELECT);
        Iterator iterator = selectedEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject object;
            boolean isSelected = selectedFiledMemberNumberSet.contains((object = (DynamicObject)iterator.next()).getString("tobeselectnumber"));
            object.set("isselect", (Object)(isSelected ? "1" : "0"));
        }
        this.getView().updateView(ENTRYENTITY_TOSELECT);
    }

    private void dealGo() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_TOSELECT);
        int[] rows = entryGrid.getSelectRows();
        this.getModel().beginInit();
        for (int row : rows) {
            String name = (String)this.getModel().getValue("tobeselectobj", row);
            String number = (String)this.getModel().getValue("tobeselectnumber", row);
            int newRow = this.getModel().createNewEntryRow(ENTRYENTITY_SELECTED);
            this.getModel().setValue("selectedobj", (Object)name, newRow);
            this.getModel().setValue("selectednumber", (Object)number, newRow);
            this.getModel().setValue("isselect", (Object)"1", row);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_SELECTED);
        this.getView().updateView(ENTRYENTITY_TOSELECT);
        this.cacheSelectedFiledMember();
    }

    private void setFixValueEnable() {
        List<FiledMember> selectedFiledMember = this.getSelectedFiledMember();
        Set selectedFiledMemberNumberSet = selectedFiledMember.stream().map(FiledMember::getFiledNumber).collect(Collectors.toSet());
        this.getView().setEnable(Boolean.valueOf(selectedFiledMemberNumberSet.contains("fixvalue")), new String[]{"fixvalue"});
    }

    private boolean isFileNameSelect() {
        Object isFileNameSelect = this.getView().getFormShowParameter().getCustomParams().get("source");
        if (isFileNameSelect != null) {
            return StringUtils.equals((String)"filename", (String)isFileNameSelect.toString());
        }
        return false;
    }

    public static class FiledMember
    implements Serializable {
        private static final long serialVersionUID = -63398745577377277L;
        private String filedName;
        private String filedNumber;
        private boolean isSelected;

        public FiledMember() {
        }

        public FiledMember(String filedNumber, String filedName, boolean isSelected) {
            this.filedName = filedName;
            this.filedNumber = filedNumber;
            this.isSelected = isSelected;
        }

        public String getFiledName() {
            return this.filedName;
        }

        public void setFiledName(String filedName) {
            this.filedName = filedName;
        }

        public String getFiledNumber() {
            return this.filedNumber;
        }

        public void setFiledNumber(String filedNumber) {
            this.filedNumber = filedNumber;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }
    }
}

