/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.report.excel.constants.ImportDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.spread.template.spread.IReportModelSupport;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BgmReportImportDataPlugin
extends AbstractFormPlugin
implements BeforeAttachmentUploadListener,
UploadListener,
IReportModelSupport {
    private static final Log log = LogFactory.getLog(BgmReportImportDataPlugin.class);
    private Long modelId = 0L;

    @Override
    public Long getModelId() {
        String modelIdStr;
        if (this.modelId != 0L) {
            return this.modelId;
        }
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelId != null && StringUtils.isNotEmpty((CharSequence)(modelIdStr = modelId.toString())) && !"0".equals(modelIdStr)) {
            this.modelId = Long.valueOf(modelIdStr);
        }
        if (IDUtils.isEmptyLong((Long)this.modelId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgmReportImportDataPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return this.modelId;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
        attach.addBeforeUploadListener((BeforeAttachmentUploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            Object maxcell;
            Object maxfile;
            String fileUrl;
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            DynamicObjectCollection eb_businessmodel = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])filter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)eb_businessmodel)) {
                for (DynamicObject dynamicObject : eb_businessmodel) {
                    OlapReportService.getInstance().checkBindRuleToTemplate(Long.valueOf(dynamicObject.getLong("id")));
                }
            }
            if (StringUtils.isEmpty((CharSequence)(fileUrl = this.getPageCache().get("fileUrl")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"BgmReportImportDataPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            Object timeout = this.getModel().getValue("timeout");
            if (timeout != null) {
                map.put("timeout", timeout);
            }
            if ((maxfile = this.getModel().getValue("maxfile")) != null) {
                map.put("maxfile", maxfile);
            }
            Object maxsheet = this.getModel().getValue("maxsheet");
            if (timeout != null) {
                map.put("maxsheet", maxsheet);
            }
            if ((maxcell = this.getModel().getValue("maxcell")) != null) {
                map.put("maxcell", maxcell);
            }
            ImportDataTypeEnum importDataTypeEnum = this.getImportDataTypeEnum();
            customParams.put("importDataType", importDataTypeEnum.getCode());
            map.put("customParams", customParams);
            map.put("fileUrl", fileUrl);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private ImportDataTypeEnum getImportDataTypeEnum() {
        Object importdatatype = this.getModel().getValue("importdatatype");
        if (importdatatype instanceof String) {
            ImportDataTypeEnum enumByCode = ImportDataTypeEnum.getEnumByCode((String)importdatatype.toString());
            return enumByCode == null ? ImportDataTypeEnum.value_cover_import : enumByCode;
        }
        return ImportDataTypeEnum.value_cover_import;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private List<String> getUploadUrlListFromCache() {
        String fileUrl = this.getPageCache().get("fileUrl");
        List urls = StringUtils.isEmpty((CharSequence)fileUrl) ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        return urls;
    }

    public void upload(UploadEvent evt) {
        String isCancel = this.getView().getPageCache().get("isCancel");
        if ("true".equals(isCancel)) {
            this.getPageCache().remove("isCancel");
        } else {
            super.upload(evt);
            List<String> urls = this.getUploadUrlListFromCache();
            for (Object url : evt.getUrls()) {
                urls.add((String)((Map)url).get("url"));
            }
            if (urls.size() > 0) {
                this.getPageCache().put("fileUrl", SerializationUtils.toJsonString(urls));
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        List<String> urls = this.getUploadUrlListFromCache();
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("fileUrl", SerializationUtils.toJsonString(urls));
    }

    public IEbSpreadManager getSpreadManager() {
        return null;
    }

    public void setEbSpreadManager(IEbSpreadManager ebSpreadManager) {
    }

    public void cacheSpreadManager() {
    }

    public void beforeAttachmentUpload(BeforeAttachmentUploadEvent beforeAttachmentUploadEvent) {
        List sourceAttachments = beforeAttachmentUploadEvent.getSourceAttachments();
        List<String> uploadUrlListFromCache = this.getUploadUrlListFromCache();
        int maxFileCount = 1;
        if (CollectionUtils.isNotEmpty((Collection)sourceAttachments)) {
            Object maxfile = this.getView().getFormShowParameter().getCustomParam("maxfile");
            if (maxfile == null) {
                maxfile = this.getModel().getValue("maxfile");
            }
            if (maxfile != null) {
                maxFileCount = Math.min(Integer.parseInt(maxfile.toString()), 100);
            }
            if (sourceAttachments.size() > maxFileCount || CollectionUtils.isNotEmpty(uploadUrlListFromCache) && uploadUrlListFromCache.size() + sourceAttachments.size() > maxFileCount) {
                beforeAttachmentUploadEvent.getCancelAttachments().addAll(sourceAttachments);
                beforeAttachmentUploadEvent.setCancel(true);
                this.getView().getPageCache().put("isCancel", "true");
                beforeAttachmentUploadEvent.setMsg(ResManager.loadResFormat((String)"\u6570\u636e\u5bfc\u5165\u4ec5\u5141\u8bb8\u4e0a\u4f20%1\u4e2a\u6587\u4ef6\u3002", (String)"BgmReportImportDataTask_006", (String)"epm-eb-formplugin", (Object[])new Object[]{maxFileCount}));
            } else {
                this.getView().getPageCache().remove("isCancel");
            }
        }
    }
}

