/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.excel.service.ExportLogService;
import org.apache.commons.collections4.CollectionUtils;

public class ExportFileListPlugin
extends AbstractFormPlugin
implements SetFilterListener {
    private TempFileCache cache;
    private static final Log log = LogFactory.getLog(ExportFileListPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ExportLogService.getInstance().refreshExportLogList(this.getModelId());
        if ("eb_exportdata_bg".equals(this.getView().getFormShowParameter().getCustomParam("sourceFormId"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_cancelexport"});
        }
    }

    @Override
    public Long getModelId() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        return IDUtils.toLong((Object)model);
    }

    private BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOperateKey().equals("refresh")) {
            ExportLogService.getInstance().refreshExportLogList(this.getModelId());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_download".equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() > 0) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_exportfilelist", (String)"id,url,filename,downloadcount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                int hasUrlCount = 0;
                ArrayList<String> fileName = new ArrayList<String>(16);
                for (DynamicObject dy : dynamicObjects) {
                    if (StringUtil.isEmptyString((String)dy.getString("url"))) continue;
                    if (ApplicationTypeEnum.EB.getAppnum().equals(this.getBizAppId())) {
                        ImportAndExportUtil.addTempFileCheck((String)dy.getString("url"), (String)"bgm_rptpreparation", (String)ApplicationTypeEnum.EB.getAppnum(), (int)10000);
                    } else {
                        String processType = this.getPageCache().get("current_rpt_type");
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)processType)) {
                            ImportAndExportUtil.addTempFileCheck((String)dy.getString("url"), (String)(ProcessTypeEnum.TASK.getNumber().equals(processType) ? "eb_executetask" : "bgm_rptpreparation"), (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
                        } else {
                            ImportAndExportUtil.addTempFileCheck((String)dy.getString("url"), (String)"eb_exportfilelist", (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
                        }
                    }
                    fileName.add(dy.getString("filename"));
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)dy.getString("url"));
                    ++hasUrlCount;
                    int download = dy.getInt("downloadcount") + 1;
                    dy.set("downloadcount", (Object)download);
                }
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4e0b\u8f7d", "ExportFileListPlugin_009", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4e0b\u8f7d\u6587\u4ef6:%1$s", "ExportFileListPlugin_008", "epm-eb-formplugin");
                this.writeLog(null, "download", opName, opDesc, new String[]{String.join((CharSequence)",", fileName)});
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                if (hasUrlCount == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u672a\u751f\u6210\u53ef\u5bfc\u51fa\u7684\u6587\u4ef6\u3002", (String)"ExportFileListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ExportFileListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            billList.refreshData();
            billList.clearSelection();
        } else if ("bar_delete".equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() > 0) {
                this.getPageCache().put("selectData", SerializationUtils.toJsonString((Object)selectedRows.getPrimaryKeyValues()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u6240\u9009\u8bb0\u5f55\u5417\uff1f", (String)"ExportFileListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ExportFileListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if ("btn_cancelexport".equalsIgnoreCase(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ExportFileListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            Set<Long> exportLogIds = Arrays.stream(primaryKeyValues).map(IDUtils::toLong).collect(Collectors.toSet());
            Set<Long> canCancelExportLogIds = ExportLogService.getInstance().getCanCancelExportLogIds(exportLogIds);
            if (CollectionUtils.isEmpty(canCancelExportLogIds)) {
                billList.refreshData();
                billList.clearSelection();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u6b63\u5728\u5bfc\u51fa\u201d\u6216\u201c\u6392\u961f\u4e2d\u201d\u7684\u5bfc\u51fa\u8bb0\u5f55\u3002", (String)"ExportFileListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                ExportLogService.getInstance().cancelExportLogs(canCancelExportLogIds);
                String tips = ResManager.loadKDString((String)"\u5bfc\u51fa\u5df2\u53d6\u6d88\u3002", (String)"ExportFileListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (canCancelExportLogIds.size() != exportLogIds.size()) {
                    tips = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u5bfc\u51fa\u72b6\u6001\u4e3a\u201c\u6b63\u5728\u5bfc\u51fa\u201d\u6216\u201c\u6392\u961f\u4e2d\u201d\u7684\u5bfc\u51fa\u8bb0\u5f55\u3002", (String)"ExportFileListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                this.getView().showSuccessNotification(tips);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                String errorMessage = ResManager.loadResFormat((String)"\u53d6\u6d88\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\uff1a%1\u3002", (String)"ExportFileListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()});
                if (e instanceof KDBizException) {
                    errorMessage = e.getMessage();
                }
                this.getView().showTipNotification(errorMessage);
            }
            billList.refreshData();
            billList.clearSelection();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String select;
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("delete_comfirm".equals(key) && e.getResult().equals((Object)MessageBoxResult.Yes) && StringUtils.isNotEmpty((String)(select = this.getPageCache().get("selectData")))) {
            List collect = (List)SerializationUtils.fromJsonString((String)select, Object.class);
            QFilter qFilter = new QFilter("id", "in", (Object)collect);
            qFilter.and("status", "not in", Arrays.asList(ExportFileStatusEnum.EXPORT_ING.getIndex(), ExportFileStatusEnum.IMPORT_ING.getIndex(), ExportFileStatusEnum.EXPORT_CANCEL_ING.getIndex()));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_exportfilelist", (String)"url, id, message, creater", (QFilter[])new QFilter[]{qFilter});
            ArrayList<Long> ids = new ArrayList<Long>(16);
            if (CollectionUtils.isNotEmpty((Collection)query)) {
                for (DynamicObject dynamicObject : query) {
                    if (StringUtils.isNotEmpty((String)dynamicObject.getString("url"))) {
                        this.getCache().remove(dynamicObject.getString("url"));
                    }
                    ids.add(dynamicObject.getLong("id"));
                    String message = dynamicObject.getString("message");
                    ExportLogService.getInstance().clearExportLogCache(message, this.getModelId(), dynamicObject.getLong("id"), dynamicObject.getLong("creater"));
                }
            }
            if (ids.size() > 0) {
                DeleteServiceHelper.delete((String)"eb_exportfilelist", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
            billList.clearSelection();
            if (ids.size() > 0 && ids.size() == collect.size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExportFileListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ids.size() > 0 && ids.size() < collect.size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff0c\u5df2\u6392\u9664\u6b63\u5728\u5bfc\u5165\u3001\u5bfc\u51fa\u6216\u53d6\u6d88\u4e2d\u7684\u8bb0\u5f55\u3002", (String)"ExportFileListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6b63\u5728\u5bfc\u5165\u3001\u5bfc\u51fa\u6216\u53d6\u6d88\u4e2d\u7684\u8bb0\u5f55\u3002", (String)"ExportFileListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public TempFileCache getCache() {
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        return this.cache;
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Long userId = this.getUserId();
        Long modelId = this.getModelId();
        Iterator iterator = setFilterEvent.getQFilters().iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            String property = next.getProperty();
            if (!"creater".equals(property)) continue;
            iterator.remove();
        }
        boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(modelId);
        if (!modelManage) {
            setFilterEvent.getQFilters().add(new QFilter("creater", "=", (Object)userId));
        }
        setFilterEvent.setOrderBy("createdate desc");
    }
}

