/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.report.excel.exception.KDEpmExportCancelException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxFloatRowException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportTimeoutException;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.report.reportview.FixReportProcess;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pageviewpanel.PageViewPanelDraw;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.AutoFloatHelper;
import kd.epm.eb.spread.utils.ReportDimFilterUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIFixReportProcess
extends FixReportProcess {
    private static final Log log = LogFactory.getLog(FixReportProcess.class);
    private XSSFWorkbook workbook = null;
    private String fileName = null;
    private String sheetName = null;
    private static final int MAX_REFRESH_ROWS = 500000;
    private boolean batchRefreshRows = true;
    private int batchRowSize = 1000;
    private boolean isRefreshData = true;
    private boolean rebuildWithPreviewData;
    private ReportExportTypeEnum exportTypeEnum;
    private Long exportLogId;
    private int maxExportSize = 2000000;
    private boolean isImportData = false;
    private int totalValueSize = 0;
    private Member currentCellMetricMember = null;

    public POIFixReportProcess(ISpreadContainer spreadContainer, String sheetName, ReportExportTypeEnum exportTypeEnum, boolean isRefreshData) {
        this.spreadContainer = spreadContainer;
        this.isRefreshData = isRefreshData;
        this.sheetName = sheetName;
        this.exportTypeEnum = exportTypeEnum;
    }

    public POIFixReportProcess(Long exportLogId, ISpreadContainer spreadContainer, String sheetName, ReportExportTypeEnum exportTypeEnum, boolean isRefreshData, int maxExportSize, int maxExportFloatRowSize) {
        this.exportLogId = exportLogId;
        this.spreadContainer = spreadContainer;
        this.isRefreshData = isRefreshData;
        this.sheetName = sheetName;
        this.exportTypeEnum = exportTypeEnum;
        this.maxExportSize = maxExportSize;
    }

    public void setImportData(boolean importData) {
        this.isImportData = importData;
    }

    public void setSpreadContainer(ISpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
    }

    public ReportExportTypeEnum getExportTypeEnum() {
        return this.exportTypeEnum;
    }

    public void setExportTypeEnum(ReportExportTypeEnum exportTypeEnum) {
        this.exportTypeEnum = exportTypeEnum;
    }

    public boolean isRefreshData() {
        return this.isRefreshData;
    }

    public void setRefreshData(boolean refreshData) {
        this.isRefreshData = refreshData;
    }

    protected void rebuildPageView() {
        ITemplateModel templateModel = this.getTemplateModel();
        this.setCacheVar(templateModel, SpreadTypeEnum.SPREADTYPE_REPORT.getIndex());
        PageViewPanelDraw pageViewPanelDraw = new PageViewPanelDraw(null, templateModel, this.getSpreadManager());
        pageViewPanelDraw.setNeedlockpage(false);
        pageViewPanelDraw.setShowHideDim(false);
        pageViewPanelDraw.setDefaultDimMember(this.getDefaultDimMember());
        pageViewPanelDraw.setExtraQfilter(this.getExtraQfilter());
        pageViewPanelDraw.setDrillthrough_key(this.getDrillthrough_key());
        pageViewPanelDraw.build();
    }

    @Override
    protected void invokeSpreadJson() {
        String serial;
        this.rebuildWithPreviewData = false;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_exportinfo", (String)"spreadserial", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)this.getTemplateModel().getTemplateBaseInfo().getId())});
        if (dynamicObject != null && StringUtils.isNotEmpty((CharSequence)(serial = dynamicObject.getString("spreadserial")))) {
            this.rebuildWithPreviewData = true;
            this.getspreadContainer().rebuildSpread(serial);
            super.invokeDeleteRowCol(false);
        }
        if (!this.rebuildWithPreviewData) {
            super.invokeSpreadJson();
        }
    }

    @Override
    protected void resolveSpreadLock() {
        if (!this.isImportData) {
            super.resolveSpreadLock();
        }
    }

    @Override
    protected void afterResolveStyles() {
        super.afterResolveStyles();
    }

    @Override
    protected void firstRefreshData() {
        if (!this.isRefreshData) {
            return;
        }
        try {
            OlapQuerySync olapQuerySync = new OlapQuerySync(this.getTemplateModel(), this.getSpreadManager(), this.getspreadContainer(), this.getModelCacheHelper());
            olapQuerySync.setProcessId(this.getTaskProcessId());
            olapQuerySync.setProcessType(this.getProcessType());
            Member orgMember = this.getModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong((Object)this.getCurrentEntityViewId()), this.getCurrentEntityNumber());
            if (orgMember != null) {
                olapQuerySync.setCurrentOrgLongNumber(orgMember.getLongNumber());
                olapQuerySync.setCurrentOrgNumber(orgMember.getNumber());
                this.setCurrentEntityLongNumber(orgMember.getLongNumber());
            }
            List<Map<String, List<MemberCondition>>> filterMemberList = this.getFilterWithFilterAndCentralized();
            ArrayList filterMemberNumberList = new ArrayList(filterMemberList.size());
            if (CollectionUtils.isNotEmpty(filterMemberList)) {
                MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getTemplateModel().getModelId());
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getTemplateModel().getModelId());
                Long bizModel = this.getTemplateModel().getTemplateBaseInfo().getBizModel();
                ReportDimFilterUtils.resolveFilterMember(filterMemberList, (MemberPropCache)memberPropCache, (IModelCacheHelper)modelCacheHelper, filterMemberNumberList, (Long)bizModel, (String)this.getCurrentEntityNumber());
            }
            if (CollectionUtils.isNotEmpty(filterMemberNumberList)) {
                olapQuerySync.setFilterMemberNumberList(filterMemberNumberList);
            }
            List floatRows = olapQuerySync.onlyQueryFloatMembers();
            List multiAreaManager = this.getSpreadManager().getMultiAreaManager();
            if (CollectionUtils.isNotEmpty(filterMemberNumberList) && CollectionUtils.isNotEmpty((Collection)floatRows)) {
                for (FloatRows floatRow : floatRows) {
                    MultiAreaManager multiAreaManager1;
                    List rowpartitionDims;
                    Optional<MultiAreaManager> multiAreaManagerFind = multiAreaManager.stream().filter(x -> x.getAreaIndex().equals(floatRow.getNumber())).findFirst();
                    if (CollectionUtils.isEmpty((Collection)floatRow.getFloatRows()) || !multiAreaManagerFind.isPresent() || CollectionUtils.isEmpty((Collection)(rowpartitionDims = (multiAreaManager1 = multiAreaManagerFind.get()).getRowpartitionDims()))) continue;
                    ArrayList<Map> needFilterCollection = new ArrayList<Map>(16);
                    for (Map filter : filterMemberNumberList) {
                        Set keys = filter.keySet();
                        if (keys.size() == 0) continue;
                        keys.retainAll(rowpartitionDims);
                        if (keys.size() != filter.size()) continue;
                        needFilterCollection.add(filter);
                    }
                    if (CollectionUtils.isEmpty(needFilterCollection)) continue;
                    List floatRows1 = floatRow.getFloatRows();
                    Iterator iterator = floatRows1.iterator();
                    while (iterator.hasNext()) {
                        FloatRows.FloatRow next = (FloatRows.FloatRow)iterator.next();
                        HashSet<Boolean> needRemove = new HashSet<Boolean>(needFilterCollection.size());
                        for (Map filterMap : needFilterCollection) {
                            Boolean oneFilterNeedRemove = Boolean.FALSE;
                            for (int i = 0; i < floatRow.getFloatDims().size(); ++i) {
                                String dimnumber = (String)floatRow.getFloatDims().get(i);
                                if (!rowpartitionDims.contains(dimnumber)) continue;
                                Set filterMembers = (Set)filterMap.get(dimnumber);
                                String member = (String)next.getColItems().get(i);
                                if (CollectionUtils.isEmpty((Collection)filterMembers) || filterMembers.contains(member)) continue;
                                oneFilterNeedRemove = Boolean.TRUE;
                                break;
                            }
                            needRemove.add(oneFilterNeedRemove);
                        }
                        if (needRemove.contains(Boolean.FALSE)) continue;
                        iterator.remove();
                    }
                }
            }
            this.sortFloatRows(floatRows);
            this.setRowSeqAndRowForamt(floatRows);
            this.refreshFloatMembers(new OlapQuerySync.ViewArea(0, 500000, 0, 50), floatRows);
            this.removeRefreshRows();
            if (this.isBatchRefreshRows()) {
                int index = 0;
                for (int i = 0; i < 500000; i += this.batchRowSize) {
                    if (index++ % 1000 == 0) {
                        ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
                    }
                    this.refreshCellData(false, new OlapQuerySync.ViewArea(i, i + this.batchRowSize, 0, 50), false, null);
                }
            } else {
                this.refreshCellData(false, new OlapQuerySync.ViewArea(0, 500000, 0, 50), false, null);
            }
            ExportExceptionHelper.getInstance().judgeMaxExportSize(this.totalValueSize, this.maxExportSize);
        }
        catch (Exception e) {
            if (e instanceof KDEpmExportMaxFloatRowException || e instanceof KDEpmExportMaxException || e instanceof KDEpmExportCancelException || e instanceof KDEpmExportTimeoutException) {
                throw e;
            }
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            log.error("POIFixReportProcess firstRefreshData:" + e.getMessage(), (Throwable)e);
            String errorInfo = e.getMessage();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)errorInfo)) {
                errorInfo = ThrowableHelper.toString((Exception)e);
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u5bfc\u51fa\u6570\u636e\u67e5\u8be2\u591a\u7ef4\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%2\u3002", (String)"POIFixReportProcess_01", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getTemplateModel().getTemplateBaseInfo().getName(), errorInfo}));
        }
    }

    @Override
    protected void refreshFloatMembers(OlapQuerySync.ViewArea viewArea, List<FloatRows> floatRows) {
        if (!this.isRefreshData) {
            return;
        }
        if (!this.getSpreadManager().isHasFloat()) {
            return;
        }
        if (floatRows != null && !floatRows.isEmpty()) {
            AutoFloatHelper autoFloatHelper = new AutoFloatHelper(this.getView(), this.getSpreadManager(), this.getspreadContainer(), this.getTemplateModel(), this.exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE);
            autoFloatHelper.setMemberDisplayType(this.getMemberDisplayType());
            String areaOverLap = "onlyone";
            if (this.getTemplateModel().getAreaRanges().size() > 1) {
                areaOverLap = FixTemplateProcessHelper.checkRowColOverlapOnAreas(this.getTemplateModel().getAreaRanges());
            }
            autoFloatHelper.setAreaOverLap(areaOverLap);
            autoFloatHelper.setCurrentEntityMember(this.getCurrentEntityNumber());
            autoFloatHelper.setFilterMemberList(this.getFilterWithFilterAndCentralized());
            int rows = viewArea.getEndrow() - viewArea.getStartrow();
            autoFloatHelper.autoFloatByMember(floatRows, rows, true);
            this.cacheSpreadManager();
            Set<Integer> needHiddenByTemplateFilter = this.hiddenByTemplateFilter(floatRows, viewArea);
            if (CollectionUtils.isNotEmpty(needHiddenByTemplateFilter)) {
                CommonServiceHelper.handleLog((Log)log, (String)"needHiddenByTemplateFilter", (String)JSONUtils.toString(needHiddenByTemplateFilter));
                this.getspreadContainer().setRowsVisible(new ArrayList<Integer>(needHiddenByTemplateFilter), false);
            }
        }
    }

    @Override
    protected void refreshCellData(boolean isSave, OlapQuerySync.ViewArea viewArea, boolean needSyncRefreshData, List<FloatRows> floatRows) {
        if (!this.isRefreshData) {
            return;
        }
        if (viewArea == null || this.getTemplateModel() == null || this.getTemplateModel().getAreaRanges() == null || this.getTemplateModel().getAreaRanges().isEmpty()) {
            return;
        }
        this.refreshFloatMembers(viewArea, floatRows);
        Map<String, Set<CellDimMember>> allDimMems = this.getAllDimensionMembers(viewArea);
        if (allDimMems != null && allDimMems.size() > 0) {
            OlapQuerySync olapQuerySync = new OlapQuerySync(this.getTemplateModel(), this.getSpreadManager(), this.getspreadContainer(), this.getView().getPageId(), viewArea, this.getRefreshedRows(), allDimMems, this.getModelCacheHelper());
            olapQuerySync.setRptEntityId(IDUtils.toLong((Object)this.getPageCache().get("current_report_id")));
            olapQuerySync.setProcessId(this.getTaskProcessId());
            olapQuerySync.setProcessType(this.getProcessType());
            Set bizRuleSet = this.getBizRules();
            if (bizRuleSet != null && bizRuleSet.size() > 0) {
                olapQuerySync.setBizRules(bizRuleSet);
            }
            olapQuerySync.setIsRuleExecution(this.isRuleExecution());
            olapQuerySync.setExport(true);
            Counter counter = new Counter();
            Map datas = olapQuerySync.onlyQueryData(counter, false);
            if (datas != null) {
                this.totalValueSize += datas.size();
            }
            olapQuerySync.refreshFixCellData(datas, counter);
            this.cacheSpreadManager();
        }
    }

    @Override
    protected boolean outsideViewArea(Set<Integer> refreshedRows, int row, int relatedRow) {
        return relatedRow < 0;
    }

    @Override
    public boolean isExportTemplate() {
        return this.exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE;
    }

    @Override
    public void setRowColMemberForExportTemplate(Member member, ECell c, String memNumber) {
        if (member != null) {
            c.setValue((Object)member.getName());
        }
    }

    protected void setPanelVisible() {
    }

    protected void iniControl() {
    }

    @Override
    protected void hideOrShowMenu() {
    }

    @Override
    public IEbSpreadManager getSpreadManager() {
        if (this.ebSpreadManager != null) {
            return this.ebSpreadManager;
        }
        String serial = this.getPageCache().get("spread_mananger_cache_key");
        if (StringUtils.isNotEmpty((CharSequence)serial) && serial.contains("areaManager")) {
            this.ebSpreadManager = FixSpreadManagerSerializerUtil.read((String)serial);
        }
        return this.ebSpreadManager;
    }

    @Override
    public void cacheSpreadManager() {
    }

    @Override
    public boolean beginSaveReportData() {
        IEbSpreadManager ebSpreadManager = this.getSpreadManager();
        HashMap<String, String> pageViewMemberMap = new HashMap<String, String>(16);
        for (Map.Entry pageviewdim : ebSpreadManager.getPageViewDims().entrySet()) {
            pageViewMemberMap.put((String)pageviewdim.getKey(), ((PageViewDimMember)pageviewdim.getValue()).getNumber());
        }
        return this.doSaveReportData(pageViewMemberMap);
    }

    public boolean isBatchRefreshRows() {
        return this.batchRefreshRows;
    }

    public void setBatchRefreshRows(boolean batchRefreshRows) {
        this.batchRefreshRows = batchRefreshRows;
    }

    public int getBatchRowSize() {
        return this.batchRowSize;
    }

    public void setBatchRowSize(int batchRowSize) {
        this.batchRowSize = batchRowSize;
    }

    public ISpreadContainer getspreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new POISpreadContainer(this.workbook, this.fileName, this.sheetName, this.exportLogId);
        }
        return this.spreadContainer;
    }

    @Override
    protected boolean backFloatF7Scopes(String dimNumber, MemberF7Parameter f7Param, Set<Long> seletedIds, boolean isQuickAddNew) {
        ((POISpreadContainer)this.spreadContainer).getOperateMaps().put("backFloatF7Scopes", this.getF7Result(dimNumber, f7Param));
        return false;
    }

    public Boolean checkDimNeedRelationFilter(String dim) {
        if (this.isImportData) {
            return Boolean.FALSE;
        }
        return super.checkDimNeedRelationFilter(dim);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public void cellValueUpdate(CellValueEvent cellValueEvent) {
        super.cellValueUpdate(cellValueEvent);
        cellValueEvent.setSetValueNull(false);
    }

    public String getBizEntityNumber() {
        if (this.exportTypeEnum == null) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"POIFixReportProcess_04", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return super.getBizEntityNumber();
    }

    @Override
    public void setFilterMemberMap(List<Map<String, List<MemberCondition>>> filterMemberMap) {
        if (CollectionUtils.isNotEmpty(filterMemberMap)) {
            this.getPageCache().put(this.getProcessId() + "filterMemberCache", ObjectSerialUtil.toByteSerialized(filterMemberMap));
        }
    }

    @Override
    public void handleFilterHidden(List<Map<String, List<MemberCondition>>> filterMemberList) {
        super.handleFilterHidden(filterMemberList);
    }

    @Override
    public List<Map<String, List<MemberCondition>>> getFilterWithFilterAndCentralized() {
        String filterInfoStr = this.getPageCache().get(this.getProcessId() + "filterMemberCache");
        if (StringUtils.isEmpty((CharSequence)filterInfoStr)) {
            return new ArrayList<Map<String, List<MemberCondition>>>(16);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)filterInfoStr);
    }

    public Member getCurrentCellMetricMember() {
        return this.currentCellMetricMember;
    }

    public void afterEnumSpreadF7LookUpData(Member metricMember) {
        super.afterEnumSpreadF7LookUpData(metricMember);
        this.currentCellMetricMember = metricMember;
    }

    protected void putInSaveDataContext(BgTemplate templateBaseInfo) {
        OlapTraceServiceHelper.setTraceOpInfo((String)templateBaseInfo.getNumber());
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.ReportImport));
    }

    @Override
    protected void replaceFormulaCellValue(int displayTypeIndex) {
        super.replaceFormulaCellValue(displayTypeIndex);
        Map formulaMap = this.getSpreadManager().getFormulaMap();
        if (formulaMap != null && formulaMap.size() > 0) {
            if (!(this.getspreadContainer() instanceof POISpreadContainer)) {
                return;
            }
            Map formulaCellsMap = ((POISpreadContainer)this.getspreadContainer()).getFormulaCellsMap();
            if (formulaCellsMap != null && formulaCellsMap.size() > 0) {
                XSSFFormulaEvaluator evaluator = ((POISpreadContainer)this.getspreadContainer()).getWorkbook().getCreationHelper().createFormulaEvaluator();
                for (Map.Entry entry : formulaCellsMap.entrySet()) {
                    XSSFCell cell1;
                    XSSFRow row;
                    String key = (String)entry.getKey();
                    String[] split = key.split(":");
                    if (split.length != 2 || (row = ((POISpreadContainer)this.getspreadContainer()).getSheet().getRow(Integer.parseInt(split[0]))) == null || (cell1 = row.getCell(Integer.parseInt(split[1]))) == null || cell1.getCellType() != CellType.FORMULA) continue;
                    evaluator.evaluateFormulaCell((Cell)cell1);
                }
            }
        }
    }
}

