/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.command;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportHelper {
    public static DynamicObject queryTemplateDynamicObj(Long templateId) {
        String selectFields = "id,name,number,templatetype,dataunit,model,templateCatalog,dataset,isrelation,dimrelationinfo,dimrelationinfo2,data,varbaseforeb";
        return BusinessDataServiceHelper.loadSingle((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
    }

    public static ITemplateModel buildTemplateModel(DynamicObject dyna, IPageCache pageCache, Long entityViewId) {
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setTemplatetype(dyna.getInt("templatetype"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("model.id")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("templateCatalog.id")));
        templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset.id")));
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        DynamicObjectCollection dimrelationinfos = dyna.getDynamicObjectCollection("dimrelationinfo2");
        List dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        templateBaseInfo.setDimRelations(dimRelations);
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        pageCache.put("varbaseforeb", dyna.getString("varbaseforeb"));
        Long busModelId = dyna.getLong("dataset.businessmodel.id");
        templateBaseInfo.setBizModel(busModelId);
        String data = dyna.getString("data");
        ITemplateModel templateModel = !StringUtils.isEmpty((CharSequence)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel((String)String.valueOf(templateBaseInfo.getTemplatetype()));
        if (templateModel != null) {
            templateModel.setTemplateBaseInfo(templateBaseInfo);
            if (IDUtils.isNotEmptyLong((Long)entityViewId).booleanValue()) {
                long currentEntityViewId = entityViewId;
                Optional<IPageDimensionEntry> optional = templateModel.getPagemembentry().stream().filter(entry -> SysDimensionEnum.Entity.getNumber().equals(entry.getDimension().getNumber())).findFirst();
                if (currentEntityViewId > 0L && optional.isPresent()) {
                    templateModel.getDimemsionViews().put(SysDimensionEnum.Entity.getNumber(), currentEntityViewId);
                }
            }
            if (templateModel instanceof FixTemplateModel) {
                FixSpreadManager fixSpreadManager = new FixSpreadManager();
                fixSpreadManager.initModelObj(templateModel);
                fixSpreadManager.getMembersWithFloat(templateModel);
                templateModel.getAreaRanges().forEach(multiAreaSetting -> multiAreaSetting.setUserStyle("1".equals(CommonUtils.getReportColorType((Long)dyna.getLong("model.id")))));
            }
        }
        return templateModel;
    }

    public static ITemplateModel setDefaultPageDimMapToTemplateModel(Map<String, String> defaultDimMemberMap, ITemplateModel templateModel, IModelCacheHelper modelCacheHelper) {
        List pagemembentry = templateModel.getPagemembentry();
        List viewpointmembentry = templateModel.getViewpointmembentry();
        Set viewPointMemnerEntry = viewpointmembentry.stream().map(x -> x.getDimension().getNumber()).collect(Collectors.toSet());
        if (defaultDimMemberMap != null && !defaultDimMemberMap.isEmpty()) {
            for (Map.Entry<String, String> entry : defaultDimMemberMap.entrySet()) {
                if (CollectionUtils.isNotEmpty(viewPointMemnerEntry) && viewPointMemnerEntry.contains(entry.getKey())) continue;
                Long dimViewId = (Long)templateModel.getDimemsionViews().get(entry.getKey());
                Member member = modelCacheHelper.getMember(entry.getKey(), dimViewId, entry.getValue());
                if (member == null) continue;
                DefaultPageDimensionEntry pageDimensionEntry = new DefaultPageDimensionEntry();
                DefaultDimension defaultDimension = new DefaultDimension();
                defaultDimension.setNumber(entry.getKey());
                pageDimensionEntry.setDimension((IDimension)defaultDimension);
                DefaultDimMember dimensionMember = new DefaultDimMember();
                dimensionMember.setId(member.getId());
                dimensionMember.setNumber(member.getNumber());
                pageDimensionEntry.addOneMember((IDimensionMember)dimensionMember);
                boolean flag = false;
                for (IPageDimensionEntry dimensionEntry : pagemembentry) {
                    if (!StringUtils.equals((CharSequence)dimensionEntry.getDimension().getNumber(), (CharSequence)entry.getKey())) continue;
                    dimensionEntry.getMembers().clear();
                    dimensionEntry.addOneMember((IDimensionMember)dimensionMember);
                    flag = true;
                    break;
                }
                if (flag) continue;
                templateModel.addPagemembentry((IPageDimensionEntry)pageDimensionEntry);
            }
        }
        return templateModel;
    }
}

