/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.POIExportCallerEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.report.excel.exception.KDEpmExportCancelException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportMaxFloatRowException;
import kd.epm.eb.common.report.excel.exception.KDEpmExportTimeoutException;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebSpread.util.SpreadUtils;
import kd.epm.eb.formplugin.report.excel.POIDynamicReportProcess;
import kd.epm.eb.formplugin.report.excel.POIFixReportProcess;
import kd.epm.eb.formplugin.report.excel.command.ExportHelper;
import kd.epm.eb.formplugin.report.excel.helper.ExportTemplateHelper;
import kd.epm.eb.formplugin.report.excel.helper.POISheetMergeHelper;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportHelper;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportJobCacheHelper;
import kd.epm.eb.formplugin.report.excel.service.ExportLogService;
import kd.epm.eb.formplugin.reportscheme.helper.ReportPreparationListHelper;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.ReportDimFilterUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Shape;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIExportCommand
extends AbstractTask
implements BgTaskExecuteConstant {
    private static final Log log = LogFactory.getLog(POIExportCommand.class);
    private IFormView formView;
    private IPageCache pageCache;
    public static final String EXPORTFILE_ID = "exportfileid";
    private double ratio = 1.0;
    private ReportExportTaskRequest reportExportTaskRequest = null;
    private Map<Long, Map<Integer, String>> floatRowRangeMap;
    private Map<Long, DynamicObject> templateInfoMap = new HashMap<Long, DynamicObject>(16);
    public int exportTimeout = 3600;
    private int maxExportSize = 2000000;
    private int maxExportFloatRowSize = 100000;
    private boolean needFlush = true;
    private final Set<String> moreThanMaxExportSizeTemplateInfos = new HashSet<String>(16);
    private final Set<String> moreThanMaxExportFloatRowSizeTemplateInfos = new HashSet<String>(16);
    private Map<String, Set<String>> errorInfoMap = null;
    private IModelCacheHelper modelCacheHelper = null;
    private Long periodId = 0L;
    private Long dataTypeId = 0L;
    private Long versionId = 0L;
    private double preExportProgress = 0.0;
    private double currentExportProgress = 0.0;

    private static String getOrgTip() {
        return new MultiLangEnumBridge("\u7ec4\u7ec7\uff1a", "ControlRuleGroupAddPlugin_7", "epm-eb-formplugin").loadKDString();
    }

    private static String getTemplateTip() {
        return new MultiLangEnumBridge("\u6a21\u677f\uff1a", "AdjustBillStateEnum_7", "epm-eb-common").loadKDString();
    }

    public POIExportCommand(IFormView formView) {
        Objects.requireNonNull(formView);
        this.formView = formView;
        this.pageCache = (IPageCache)formView.getService(IPageCache.class);
    }

    public final IFormView initFormView() {
        String formId = "bgm_exportbyorg";
        String pageId = UUID.randomUUID() + "";
        FormShowParameter params = new FormShowParameter();
        params.setPageId(pageId);
        params.setAppId("bgm");
        params.setFormId(formId);
        params.setCacheExpireTime(System.currentTimeMillis() - 0x6DDD00L);
        FormConfig cfg = new FormConfig();
        cfg.setEntityTypeId(formId);
        params.setFormConfig(cfg);
        FormView fv = new FormView();
        fv.addService(IPageCache.class, (Object)new PageCache(pageId));
        fv.initialize(params);
        IFormController srv = (IFormController)fv.getService(IFormController.class);
        try {
            MethodUtils.invokeMethod((Object)srv, (String)"loadData", (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("POIExportCommand:MethodUtils.invokeMethod error:");
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return fv;
    }

    public POIExportCommand(ReportExportTaskRequest reportExportTaskRequest) {
        IFormView view;
        if (reportExportTaskRequest == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)reportExportTaskRequest.getExportDataRequests())) {
            return;
        }
        this.formView = view = this.initFormView();
        this.pageCache = view.getPageCache();
        this.reportExportTaskRequest = reportExportTaskRequest;
        this.maxExportFloatRowSize = this.reportExportTaskRequest.getMaxExportFloatRowSize();
        this.maxExportSize = this.reportExportTaskRequest.getMaxExportSize();
        this.exportTimeout = this.reportExportTaskRequest.getExportTimeout();
        this.pageCache.put(EXPORTFILE_ID, reportExportTaskRequest.getExportLogId() + "");
    }

    public POIExportCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        log.info("export start:traceId:" + RequestContext.get().getTraceId());
        if (this.reportExportTaskRequest == null) {
            return;
        }
        String errorMessage = "";
        String exportFileId = this.reportExportTaskRequest.getExportLogId() + "";
        try {
            log.info("--export setTimeout");
            ExportExceptionHelper.getInstance().setTimeout(exportFileId, this.exportTimeout);
            log.info("--export judgeExportCancel");
            ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
            log.info("--export updateExportFileStatus");
            this.updateExportFileStatus(exportFileId, null, ExportFileStatusEnum.EXPORT_ING.getIndex());
            log.info("--export updateExportLogOrder");
            ExportLogService.getInstance().updateExportLogOrder(this.reportExportTaskRequest.getExportLogId(), 0);
            log.info("--export updateExportLogOrderInQueue");
            ExportLogService.getInstance().updateExportLogOrderInQueue();
            log.info("--export doExecute");
            this.doExecute();
            log.info("--export doExecute end");
            ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
        }
        catch (KDEpmExportCancelException exportCancelException) {
            log.info("--export exportCancelException");
            log.error((Throwable)exportCancelException);
            ExportLogService.getInstance().updateExportFileStatus(this.reportExportTaskRequest.getExportLogId() + "", null, ExportFileStatusEnum.EXPORT_CANCEL_END.getIndex(), null);
        }
        catch (KDEpmExportTimeoutException timeoutException) {
            log.info("--export timeoutException");
            log.error((Throwable)timeoutException);
            errorMessage = ResManager.loadKDString((String)"\u5bfc\u51fa\u8d85\u65f6\uff0c\u672a\u80fd\u5168\u90e8\u5bfc\u51fa\uff0c\u8bf7\u51cf\u5c11\u62a5\u8868\u6570\u91cf\u540e\u91cd\u8bd5\u3002", (String)"POIExportCommand_007", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            ExportLogService.getInstance().updateExportFileStatus(this.reportExportTaskRequest.getExportLogId() + "", null, ExportFileStatusEnum.PART_END.getIndex(), errorMessage);
        }
        finally {
            this.afterExecute();
        }
    }

    private void checkExportTemplateIsPreview(Set<Long> templateIdSet) {
        if (CollectionUtils.isEmpty(templateIdSet)) {
            return;
        }
        QFilter qFilter1 = new QFilter("id", "in", templateIdSet);
        qFilter1.and("templatetype", "=", (Object)"1");
        DynamicObjectCollection dynamicTemplateQuery = QueryServiceHelper.query((String)"eb_templateentity", (String)"id", (QFilter[])qFilter1.toArray());
        HashSet<Long> dynamicTemplateIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicTemplateQuery) {
            dynamicTemplateIds.add(dynamicObject.getLong("id"));
        }
        templateIdSet.removeIf(dynamicTemplateIds::contains);
        if (CollectionUtils.isNotEmpty(templateIdSet)) {
            QFilter qFilter = new QFilter("template", "in", templateIdSet);
            Map hasPreViewTemplateInfoMap = BusinessDataServiceHelper.loadFromCache((String)"eb_exportinfo", (String)"template", (QFilter[])qFilter.toArray());
            if (hasPreViewTemplateInfoMap.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u9884\u7b97\u4f53\u7cfb-\u9884\u7b97\u6a21\u677f\u5217\u8868\uff0c\u5bf9\u5bfc\u51fa\u7684\u6a21\u677f\u8fdb\u884c\u9884\u89c8\u3001\u53d1\u5e03\u6216\u6a21\u677f\u5347\u7ea7\u540e\u518d\u5bfc\u51fa\u3002", (String)"POIFixReportProcess_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            HashMap<Long, DynamicObject> hasPreViewTemplateMap = new HashMap<Long, DynamicObject>(16);
            HashSet<Long> hasNotPreViewTemplateIds = new HashSet<Long>(16);
            if (hasPreViewTemplateInfoMap.size() != templateIdSet.size()) {
                for (Map.Entry entry : hasPreViewTemplateInfoMap.entrySet()) {
                    DynamicObject value = (DynamicObject)entry.getValue();
                    hasPreViewTemplateMap.put(value.getLong("template.id"), value);
                }
                for (Long templateId : templateIdSet) {
                    DynamicObject dynamicObject = (DynamicObject)hasPreViewTemplateMap.get(templateId);
                    if (dynamicObject != null) continue;
                    hasNotPreViewTemplateIds.add(templateId);
                }
            }
            HashSet<String> hasNotPreViewTemplateNumbers = new HashSet<String>(16);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateentity", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", hasNotPreViewTemplateIds)});
            for (DynamicObject dynamicObject : query) {
                hasNotPreViewTemplateNumbers.add(dynamicObject.getString("number"));
            }
            log.info("exportCommand:hasNotPreViewTemplateNumbers" + SerializationUtils.toJsonString(hasNotPreViewTemplateNumbers));
            if (hasNotPreViewTemplateNumbers.size() <= 10 && hasNotPreViewTemplateNumbers.size() > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u524d\u5f80\u9884\u7b97\u4f53\u7cfb-\u9884\u7b97\u6a21\u677f\u5217\u8868\uff0c\u5bf9\u6a21\u677f\u201c%1\u201d\u8fdb\u884c\u9884\u89c8\u3001\u53d1\u5e03\u6216\u6a21\u677f\u5347\u7ea7\u540e\u518d\u5bfc\u51fa\u3002", (String)"POIFixReportProcess_02", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", hasNotPreViewTemplateNumbers)}));
            }
            if (hasNotPreViewTemplateNumbers.size() > 10) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u9884\u7b97\u4f53\u7cfb-\u9884\u7b97\u6a21\u677f\u5217\u8868\uff0c\u5bf9\u5bfc\u51fa\u7684\u6a21\u677f\u8fdb\u884c\u9884\u89c8\u3001\u53d1\u5e03\u6216\u6a21\u677f\u5347\u7ea7\u540e\u518d\u5bfc\u51fa\u3002", (String)"POIFixReportProcess_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getExportfileId() {
        return this.formView.getPageCache().get(EXPORTFILE_ID);
    }

    private Set<Long> checkSheetName() {
        ArrayList<String> sheetNames = new ArrayList<String>(16);
        int index = 0;
        HashSet<Long> templateIdSet = new HashSet<Long>(16);
        for (ReportExportDataRequest exportDataRequest : this.reportExportTaskRequest.getExportDataRequests()) {
            String sheetName = exportDataRequest.getSheetName();
            if (StringUtils.isBlank((CharSequence)sheetName)) continue;
            String newSheetName = sheetNames.contains(sheetName) ? (sheetName.length() > 31 - (index + "").length() ? sheetName.substring(0, 31 - (index + "").length()) + index : sheetName + index) : (sheetName.length() > 31 ? sheetName.substring(0, 31) : exportDataRequest.getSheetName());
            if (sheetNames.contains(newSheetName)) {
                newSheetName = newSheetName.length() > 31 - (index + "").length() ? newSheetName.substring(0, 31 - (index + "").length()) + index : newSheetName + index;
            }
            exportDataRequest.setSheetName(newSheetName);
            sheetNames.add(newSheetName);
            templateIdSet.add(exportDataRequest.getTemplateId());
            ++index;
        }
        return templateIdSet;
    }

    private void cacheContextParam(ReportExportDataRequest request) {
        this.pageCache.put("current_org", request.getEntityId() + "");
        this.pageCache.put("current_rpt", request.getTemplateId() + "");
        this.pageCache.put("current_rpt_type", request.getProcessType().getNumber());
        this.pageCache.put("current_processid", request.getReportProcessId() + "");
        this.pageCache.put("current_report_id", request.getProcessId() + "");
    }

    private AbstractReportPlugin initReportPlugin(ReportExportDataRequest request, ITemplateModel templateModel, IModelCacheHelper modelCacheHelper, POISpreadContainer spreadContainer, boolean isRefreshData) {
        Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), request.getEntityViewId(), request.getEntityId());
        if (orgMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5728\u7ec4\u7ec7\u89c6\u56fe\u201c%1\u201d\u91cc\u627e\u4e0d\u5230\u7ec4\u7ec7\u201c%2\u201d\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{request.getEntityViewId(), request.getEntityId()}));
        }
        boolean isFixReport = BgTemplateTypeEnum.EBFIX.getNumber().equals(String.valueOf(templateModel.getTemplateBaseInfo().getTemplatetype()));
        if (spreadContainer != null) {
            spreadContainer.setCurrentSheet(request.getSheetName());
        }
        Long exportLogId = this.reportExportTaskRequest.getExportLogId();
        AbstractReportPlugin abstractReportPlugin = isFixReport ? new POIFixReportProcess(exportLogId, (ISpreadContainer)spreadContainer, request.getSheetName(), request.getExportTypeEnum(), isRefreshData, this.maxExportSize, this.maxExportFloatRowSize) : new POIDynamicReportProcess(exportLogId, (ISpreadContainer)spreadContainer, request.getSheetName(), isRefreshData, this.maxExportSize);
        abstractReportPlugin.setView(this.formView);
        abstractReportPlugin.initialize();
        abstractReportPlugin.setProcessId(request.getProcessId());
        abstractReportPlugin.setTaskProcessId(request.getReportProcessId());
        abstractReportPlugin.setProcessType(request.getProcessType().getNumber());
        abstractReportPlugin.setTemplateModel(templateModel);
        templateModel = ExportHelper.setDefaultPageDimMapToTemplateModel(request.getDefaultDimMemberMap(), templateModel, modelCacheHelper);
        Map dimensionView = templateModel.getDimensionView();
        dimensionView.put(SysDimensionEnum.Entity.getNumber(), request.getEntityViewId());
        abstractReportPlugin.setDefaultDimMember(ReportExportHelper.getInstance().getDefaultDimMemberIdMap(request.getDefaultDimMemberMap(), modelCacheHelper, dimensionView));
        abstractReportPlugin.setCurrentEntityNumber(orgMember.getNumber());
        abstractReportPlugin.setCurrentEntityLongNumber(orgMember.getLongNumber());
        abstractReportPlugin.setCurrentEntityViewId(request.getEntityViewId() + "");
        ((POISpreadContainer)abstractReportPlugin.getspreadContainer()).setPoiHelper(new POIHelper());
        this.getPageCache().put("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)templateModel.getTemplateBaseInfo()));
        this.getPageCache().put("CURRENT_PERIOD", request.getPeriodId() + "");
        if (request.getExportTypeEnum() == ReportExportTypeEnum.EXPORT_DATA || request.getExportTypeEnum() == ReportExportTypeEnum.EXPORT_TEMPLATE && request.isExportData()) {
            if (CollectionUtils.isNotEmpty((Collection)request.getFilterMemberList())) {
                abstractReportPlugin.setFilterMemberMap(request.getFilterMemberList());
            } else {
                Map filterMember = ReportDimFilterUtils.getDefaultFilter(null, (IModelCacheHelper)modelCacheHelper, (String)orgMember.getNumber(), (ITemplateModel)templateModel, (IPageCache)this.getPageCache(), (Long)request.getProcessId(), (Long)request.getEntityViewId());
                if (filterMember != null && !filterMember.isEmpty()) {
                    ArrayList<Map> list = new ArrayList<Map>(16);
                    list.add(filterMember);
                    abstractReportPlugin.setFilterMemberMap(list);
                    request.setFilterMemberList(list);
                }
            }
        }
        abstractReportPlugin.afterCreateNewData(null);
        if (request.getExportTypeEnum() == ReportExportTypeEnum.EXPORT_DATA || request.getExportTypeEnum() == ReportExportTypeEnum.EXPORT_TEMPLATE && request.isExportData()) {
            abstractReportPlugin.handleFilterHidden(request.getFilterMemberList());
        }
        return abstractReportPlugin;
    }

    private IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return this.modelCacheHelper;
        }
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    public void doExecute() {
        log.info("exportCommand:traceId:" + RequestContext.get().getTraceId());
        if (this.reportExportTaskRequest == null || CollectionUtils.isEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
            if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
                ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u62a5\u8868\u3002", (String)"POIExportCommand_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ReportExportDataRequest request = (ReportExportDataRequest)this.reportExportTaskRequest.getExportDataRequests().get(0);
        ReportExportTypeEnum exportTypeEnum = request.getExportTypeEnum();
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_BY_ORG) {
            this.exportByOrg(request);
        } else {
            Set<Long> templateIdSet = this.checkSheetName();
            this.checkExportTemplateIsPreview(templateIdSet);
            String fileName = request.getFileName();
            List<Workbook> workbookList = this.writeToWorkbookV1(POIExportCallerEnum.REPORT);
            if (CollectionUtils.isEmpty(workbookList)) {
                return;
            }
            if (CollectionUtils.isEmpty(workbookList)) {
                if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
                    ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u62a5\u8868\u3002", (String)"POIExportCommand_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (workbookList.size() == 1) {
                this.downloadWorkBook(workbookList.get(0), fileName);
            } else {
                this.zipDownloadWorkBook(workbookList, fileName);
            }
            workbookList.clear();
            ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
        }
    }

    private boolean initReportExportDataRequestByOrg(ReportPreparationListHelper reportPreparationListHelper, ReportExportDataRequest request, Member exportOrg, Map<Long, Map<String, String>> allPageDimMemberMap, Map<String, Long> defaultDimensionNumberIdMap, Set<Long> exportByOrgTemplateIdSet) {
        Long modelId = request.getModelId();
        Long entityViewId = request.getEntityViewId();
        List<ReportProcess> currentEntityAllReportProcess = reportPreparationListHelper.getCurrentEntityAllReportProcess(modelId, request.getPeriodId(), request.getDataTypeId(), request.getVersionId(), this.getModelCacheHelper(modelId), entityViewId, request.getSchemeId(), exportOrg.getId(), exportByOrgTemplateIdSet);
        if (CollectionUtils.isEmpty(currentEntityAllReportProcess)) {
            return false;
        }
        ReportSchemeTemplateSortService.getInstance().sortTemplateForExport(currentEntityAllReportProcess, exportByOrgTemplateIdSet, request.getReportProcessId());
        this.reportExportTaskRequest.getExportDataRequests().clear();
        for (ReportProcess entityAllReportProcess : currentEntityAllReportProcess) {
            Map<String, String> dimMemberNumberMap;
            ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
            Long templateId = entityAllReportProcess.getTemplateId();
            try {
                dimMemberNumberMap = ReportExportHelper.getInstance().getDimMemberNumberMap(this.formView, allPageDimMemberMap, defaultDimensionNumberIdMap, modelId, request.getPeriodId(), request.getProcessType(), request.getReportProcessId(), entityAllReportProcess.getId(), templateId, exportOrg.getId(), exportOrg.getNumber(), entityViewId, null);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                DynamicObject dynamicObject = this.templateInfoMap.get(templateId);
                if (dynamicObject != null) {
                    String number = dynamicObject.getString("number");
                    String name = dynamicObject.getString("name");
                    Set strings = this.errorInfoMap.computeIfAbsent(e.getMessage(), t -> new HashSet(16));
                    strings.add(name + "\u3010" + number + "\u3011");
                    continue;
                }
                log.error("dynamicObject is null.templateId=" + templateId);
                continue;
            }
            ReportExportDataRequest reportExportDataRequest = new ReportExportDataRequest();
            reportExportDataRequest.setModelId(modelId);
            reportExportDataRequest.setProcessType(request.getProcessType());
            reportExportDataRequest.setProcessId(entityAllReportProcess.getId());
            reportExportDataRequest.setReportProcessId(request.getReportProcessId());
            reportExportDataRequest.setDefaultDimMemberMap(dimMemberNumberMap);
            reportExportDataRequest.setExportTypeEnum(request.getExportTypeEnum());
            reportExportDataRequest.setExportData(request.isExportData());
            reportExportDataRequest.setEntityViewId(request.getEntityViewId());
            reportExportDataRequest.setEntityId(exportOrg.getId());
            reportExportDataRequest.setTemplateId(templateId);
            reportExportDataRequest.setSheetName(this.templateInfoMap.get(templateId) == null ? "" + templateId : this.templateInfoMap.get(templateId).getString("name"));
            this.reportExportTaskRequest.getExportDataRequests().add(reportExportDataRequest);
        }
        Set<Long> templateIdSet = this.checkSheetName();
        this.checkExportTemplateIsPreview(templateIdSet);
        return true;
    }

    private void exportByOrg(ReportExportDataRequest request) {
        ReportExportTypeEnum exportTypeEnum = request.getExportTypeEnum();
        if (exportTypeEnum != ReportExportTypeEnum.EXPORT_BY_ORG) {
            return;
        }
        Long modelId = request.getModelId();
        Long entityViewId = request.getEntityViewId();
        Long entityId = request.getEntityId();
        RangeEnum exportByOrgRange = request.getExportByOrgRange();
        Member exportOrg = this.getModelCacheHelper(modelId).getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId);
        if (exportOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"POIExportCommand_004", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        log.info("exportByOrg:member != null");
        HashMap<Long, Map<String, String>> allPageDimMemberMap = new HashMap<Long, Map<String, String>>(16);
        HashMap<String, Long> defaultDimensionNumberIdMap = new HashMap<String, Long>(16);
        defaultDimensionNumberIdMap.put(SysDimensionEnum.DataType.getNumber(), request.getDataTypeId());
        defaultDimensionNumberIdMap.put(SysDimensionEnum.Version.getNumber(), request.getVersionId());
        defaultDimensionNumberIdMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), request.getPeriodId());
        List exportOrgRange = this.getModelCacheHelper(modelId).getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, exportOrg.getNumber(), exportByOrgRange.getIndex());
        if (CollectionUtils.isEmpty((Collection)exportOrgRange)) {
            if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
                ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u62a5\u8868\u3002", (String)"POIExportCommand_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
        Set<Long> entityTreeIdSet = reportPreparationListHelper.getEntityTreeIdSet(modelId, request.getSchemeId(), request.getDataSetId(), entityViewId);
        if (CollectionUtils.isEmpty(entityTreeIdSet)) {
            if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
                ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u62a5\u8868\u3002", (String)"POIExportCommand_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set exportByOrgTemplateIdSet = request.getExportByOrgTemplateIdSet();
        if (CollectionUtils.isEmpty((Collection)exportByOrgTemplateIdSet)) {
            if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
                ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u62a5\u8868\u3002", (String)"POIExportCommand_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)exportByOrgTemplateIdSet)});
        for (DynamicObject dynamicObject : query) {
            this.templateInfoMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        boolean hasCanDownloadWorkBook = false;
        List collect = exportOrgRange.stream().filter(t -> entityTreeIdSet.contains(t.getId())).collect(Collectors.toList());
        int totalEntitySize = collect.size();
        this.ratio = 1.0 / (double)totalEntitySize;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outStream);
        try {
            this.errorInfoMap = new HashMap<String, Set<String>>(16);
            for (Member member : collect) {
                ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
                boolean hasCanExportRequest = this.initReportExportDataRequestByOrg(reportPreparationListHelper, request, member, allPageDimMemberMap, defaultDimensionNumberIdMap, exportByOrgTemplateIdSet);
                if (!hasCanExportRequest) continue;
                List<Workbook> workbooks = this.writeToWorkbookV1(POIExportCallerEnum.REPORT);
                log.info("---export by org writeToWorkbookV1 after");
                if (CollectionUtils.isEmpty(workbooks)) continue;
                for (Workbook workbook : workbooks) {
                    this.zipWorkBook(zipOutputStream, workbook, member.getNumber() + "_" + member.getName());
                    hasCanDownloadWorkBook = true;
                }
                this.preExportProgress = this.currentExportProgress;
                this.currentExportProgress = 0.0;
            }
        }
        catch (KDEpmExportCancelException | KDEpmExportTimeoutException exportCancelException) {
            log.error(exportCancelException);
        }
        if (hasCanDownloadWorkBook) {
            try {
                outStream.close();
                zipOutputStream.close();
                this.downWorkBook(outStream, request.getFileName());
            }
            catch (IOException e) {
                log.error("exportByOrg:outStream.close error:");
                log.error((Throwable)e);
            }
        } else {
            if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
                ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u62a5\u8868\u3002", (String)"POIExportCommand_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Workbook> writeToWorkbookV1(POIExportCallerEnum caller) {
        ArrayList<Workbook> workbookList = new ArrayList<Workbook>(16);
        if (this.reportExportTaskRequest == null || CollectionUtils.isEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
            return workbookList;
        }
        SpreadUtils.SetLicenseKey((boolean)true);
        ReportExportDataRequest reportExportDataRequest = (ReportExportDataRequest)this.reportExportTaskRequest.getExportDataRequests().get(0);
        Long modelId = reportExportDataRequest.getModelId();
        String fileName = reportExportDataRequest.getFileName();
        ReportExportTypeEnum exportTypeEnum = reportExportDataRequest.getExportTypeEnum();
        log.info("exportCommand:modelId:" + modelId);
        POISpreadContainer spreadContainer = new POISpreadContainer(this.reportExportTaskRequest.getExportLogId(), fileName, false);
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper(spreadContainer);
        int requestIndex = 0;
        SXSSFWorkbook baseWorkBook = null;
        HashMap<String, Short> styleMap = new HashMap<String, Short>(16);
        String workbookType = "";
        int totalSize = this.reportExportTaskRequest.getExportDataRequests().size();
        try {
            for (ReportExportDataRequest request : this.reportExportTaskRequest.getExportDataRequests()) {
                DynamicObject dynamicObject;
                if ((IDUtils.isEmptyLong((Long)this.periodId).booleanValue() || IDUtils.isEmptyLong((Long)this.dataTypeId) | IDUtils.isEmptyLong((Long)this.versionId)) && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"period, datatype, version", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)request.getProcessId())})) != null) {
                    this.periodId = dynamicObject.getLong("period");
                    this.dataTypeId = dynamicObject.getLong("datatype");
                    this.versionId = dynamicObject.getLong("version");
                }
                request.setPeriodId(this.periodId);
                request.setDataTypeId(this.dataTypeId);
                request.setVersionId(this.versionId);
                ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
                DoExportRequestReturn requestReturn = this.doExportRequest(request, this.getModelCacheHelper(modelId), exportTemplateHelper, spreadContainer, caller);
                if (requestReturn == null) continue;
                Workbook workbook = requestReturn.getWorkbook();
                workbookType = requestReturn.getRequestType();
                if (baseWorkBook == null) {
                    baseWorkBook = new SXSSFWorkbook((XSSFWorkbook)workbook, this.needFlush ? 100 : 100000, true, true);
                } else {
                    int colOffset = 0;
                    int rowOffset = 0;
                    if (ReportExportTypeEnum.EXPORT_DATA == request.getExportTypeEnum() && request.getIncludePageDim().booleanValue() || ReportExportTypeEnum.EXPORT_BY_ORG == request.getExportTypeEnum()) {
                        rowOffset = 2;
                    } else if (ReportExportTypeEnum.EXPORT_TEMPLATE == request.getExportTypeEnum()) {
                        ITemplateModel templateModel = ExportHelper.buildTemplateModel(ExportHelper.queryTemplateDynamicObj(request.getTemplateId()), this.getPageCache(), request.getEntityViewId());
                        rowOffset = exportTemplateHelper.getTemplateRowOffset(templateModel, false);
                        colOffset = 1;
                    }
                    POISheetMergeHelper.mergeWorkBook(this.needFlush, (Workbook)baseWorkBook, workbook, workbookType, styleMap, this.reportExportTaskRequest.getExportLogId(), colOffset, rowOffset);
                }
                this.updateExportFileProgress(this.getExportfileId(), this.getRatio(requestIndex, totalSize));
                ++requestIndex;
                spreadContainer.setWorkbook(null);
                requestReturn.setWorkbook(null);
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (KDEpmExportCancelException | KDEpmExportTimeoutException exportCancelException) {
            log.info("---export writeToWorkbookV1 exportCancelException");
            log.error(exportCancelException);
        }
        finally {
            if (totalSize > 1 && exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
                POISheetMergeHelper.mergeWorkBook(this.needFlush, baseWorkBook, exportTemplateHelper.getOtherSheetWorkBook(), workbookType, styleMap, null, 0, 0);
            }
            if (baseWorkBook != null) {
                workbookList.add((Workbook)baseWorkBook);
            }
        }
        return workbookList;
    }

    private DoExportRequestReturn doExportRequest(ReportExportDataRequest request, IModelCacheHelper modelCacheHelper, ExportTemplateHelper exportTemplateHelper, POISpreadContainer spreadContainer, POIExportCallerEnum caller) {
        String workbookType;
        AbstractReportPlugin abstractReportPlugin;
        ReportExportTypeEnum exportTypeEnum;
        log.info("---begin export doExportRequest");
        DoExportRequestReturn result = new DoExportRequestReturn();
        IEbSpreadManager noRefreshDataSpreadManager = null;
        this.cacheContextParam(request);
        long modelId = request.getModelId();
        ITemplateModel templateModel = ExportHelper.buildTemplateModel(ExportHelper.queryTemplateDynamicObj(request.getTemplateId()), this.getPageCache(), request.getEntityViewId());
        templateModel.setModelId(Long.valueOf(modelId));
        ExportExceptionHelper.getInstance().judgeExportCancel(this.reportExportTaskRequest.getExportLogId());
        if (request.getDataUnit() != null) {
            templateModel.getTemplateBaseInfo().setDataunit(request.getDataUnit() + "");
        }
        boolean isRefreshData = (exportTypeEnum = request.getExportTypeEnum()) == ReportExportTypeEnum.EXPORT_DATA || exportTypeEnum == ReportExportTypeEnum.EXPORT_BY_ORG ? true : request.isExportData();
        spreadContainer.setHasRebuild(false);
        spreadContainer.setNewCellStyleMap(new HashMap(16));
        spreadContainer.setEnumRowColMap(new HashMap(16));
        spreadContainer.setCurrentCellEnumItems(new ArrayList(16));
        try {
            log.info("export initReportPlugin begin.");
            abstractReportPlugin = this.initReportPlugin(request, templateModel, modelCacheHelper, spreadContainer, isRefreshData);
        }
        catch (KDEpmExportMaxException e) {
            log.error((Throwable)e);
            log.error("report {} more than max export size.", (Object)request.getReportProcessId());
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), request.getEntityViewId(), request.getEntityId());
            String reportInfo = POIExportCommand.getTemplateTip() + templateModel.getTemplateBaseInfo().getNumber() + " " + templateModel.getTemplateBaseInfo().getName();
            if (member != null) {
                reportInfo = reportInfo + "\uff0c" + POIExportCommand.getOrgTip() + member.getNumber() + " " + member.getName();
            }
            this.moreThanMaxExportSizeTemplateInfos.add(reportInfo);
            return null;
        }
        catch (KDEpmExportMaxFloatRowException e) {
            log.error("report {} more than max export float row size.", (Object)request.getReportProcessId());
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), request.getEntityViewId(), request.getEntityId());
            String reportInfo = templateModel.getTemplateBaseInfo().getNumber();
            if (member != null) {
                reportInfo = reportInfo + " " + member.getNumber();
            }
            this.moreThanMaxExportFloatRowSizeTemplateInfos.add(reportInfo);
            return null;
        }
        XSSFWorkbook workbook = spreadContainer.getWorkbook();
        if (workbook == null || spreadContainer.getSheet() == null) {
            return null;
        }
        Sheet sheet = workbook.getSheet(request.getSheetName());
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_DATA || exportTypeEnum == ReportExportTypeEnum.EXPORT_BY_ORG) {
            if (abstractReportPlugin instanceof POIDynamicReportProcess) {
                this.setIsShowEmptyRowAndCol(abstractReportPlugin, spreadContainer, request);
            }
            this.setShowDimNameAndNumberInfo(abstractReportPlugin, spreadContainer, request);
            Boolean includePageDim = request.getIncludePageDim();
            Boolean divideCell = request.getDivideCell();
            if (divideCell.booleanValue()) {
                this.divideCell((Workbook)workbook, request.getSheetName(), request.isRemoveRange());
            }
            if (includePageDim.booleanValue() || exportTypeEnum == ReportExportTypeEnum.EXPORT_BY_ORG) {
                this.includePageDim((Workbook)workbook, request.getSheetName(), templateModel, templateModel.getPagemembentry(), request.getEntityViewId(), modelCacheHelper, spreadContainer);
            }
        } else {
            boolean isIncludeFilter = false;
            if (CollectionUtils.isNotEmpty((Collection)request.getFilterMemberList())) {
                Map stringListMap;
                List filterMemberList = request.getFilterMemberList();
                if (filterMemberList.size() >= 2) {
                    isIncludeFilter = true;
                } else if (filterMemberList.size() == 1 && (stringListMap = (Map)filterMemberList.get(0)).size() > 1 && stringListMap.containsKey("templateFilter")) {
                    isIncludeFilter = true;
                }
            }
            AbstractReportPlugin noRefreshDataAbstractReportPlugin = null;
            if (request.isExportData()) {
                noRefreshDataAbstractReportPlugin = this.initReportPlugin(request, templateModel, modelCacheHelper, new POISpreadContainer(), false);
                if (abstractReportPlugin instanceof POIDynamicReportProcess && isIncludeFilter) {
                    this.setShowDimNameAndNumberInfo(abstractReportPlugin, spreadContainer, request);
                }
                noRefreshDataSpreadManager = noRefreshDataAbstractReportPlugin.getSpreadManager();
            } else {
                noRefreshDataSpreadManager = abstractReportPlugin.getSpreadManager();
            }
            if (this.reportExportTaskRequest.getExportDataRequests().size() == 1) {
                exportTemplateHelper.setOtherSheetWorkBook((Workbook)workbook);
            }
            exportTemplateHelper.handleExportTemplateWorkbook(sheet, templateModel, noRefreshDataSpreadManager, abstractReportPlugin, noRefreshDataAbstractReportPlugin, modelCacheHelper, request, isIncludeFilter);
        }
        if (caller == POIExportCallerEnum.RPA) {
            this.buildFloatAreaRow(request.getTemplateId(), abstractReportPlugin);
        }
        if (CommonUtils.exportFormatValue((Long)modelId) && exportTypeEnum != ReportExportTypeEnum.EXPORT_TEMPLATE) {
            this.formatCellValue(sheet);
        }
        workbook.setSheetName(0, request.getSheetName());
        Sheet sheetAt = workbook.getSheetAt(0);
        if (sheetAt.getProtect()) {
            sheetAt.protectSheet(null);
        }
        result.setWorkbook((Workbook)workbook);
        log.info("---begin export doExportRequest gc");
        if (abstractReportPlugin instanceof POIDynamicReportProcess) {
            workbookType = "dynamic";
            POIDynamicReportProcess poiDynamicReportProcess = (POIDynamicReportProcess)abstractReportPlugin;
            poiDynamicReportProcess.setWorkbook(null);
            ((POISpreadContainer)poiDynamicReportProcess.getspreadContainer()).setWorkbook(null);
            poiDynamicReportProcess.setSpreadContainer(null);
            IEbSpreadManager spreadManager = abstractReportPlugin.getSpreadManager();
            IEBook ebook = spreadManager.getEbook();
            for (ISheet next : ebook) {
                next.getTable().clear();
            }
            if (noRefreshDataSpreadManager != null) {
                IEBook ebook1 = noRefreshDataSpreadManager.getEbook();
                for (ISheet next : ebook1) {
                    next.getTable().clear();
                }
            }
        } else {
            workbookType = "fix";
            POIFixReportProcess poiFixReportProcess = (POIFixReportProcess)abstractReportPlugin;
            poiFixReportProcess.setWorkbook(null);
            ((POISpreadContainer)poiFixReportProcess.getspreadContainer()).setWorkbook(null);
            poiFixReportProcess.setSpreadContainer(null);
            FixSpreadManager fixSpreadManager = (FixSpreadManager)abstractReportPlugin.getSpreadManager();
            for (MultiAreaManager multiAreaManager : fixSpreadManager.getMultiAreaManager()) {
                multiAreaManager.getData().getDataSheet().getTable().clear();
                multiAreaManager.getData().getDataSheet().clear();
            }
            if (noRefreshDataSpreadManager != null) {
                FixSpreadManager fixSpreadManager1 = (FixSpreadManager)noRefreshDataSpreadManager;
                for (MultiAreaManager multiAreaManager : fixSpreadManager1.getMultiAreaManager()) {
                    multiAreaManager.getData().getDataSheet().getTable().clear();
                    multiAreaManager.getData().getDataSheet().clear();
                }
            }
        }
        result.setRequestType(workbookType);
        return result;
    }

    private void formatCellValue(Sheet sheet) {
        DataFormatter dataFormatter = new DataFormatter();
        for (Row r : sheet) {
            for (Cell c : r) {
                CellStyle cellStyle;
                double cellValue;
                CellType cellType = c.getCellType();
                if (cellType != CellType.NUMERIC || (cellValue = c.getNumericCellValue()) % 1.0 == 0.0 || (cellStyle = c.getCellStyle()) == null) continue;
                String formattedValue = dataFormatter.formatRawCellContents(cellValue, (int)cellStyle.getDataFormat(), cellStyle.getDataFormatString());
                try {
                    double v = this.parseNumericString(formattedValue);
                    if (formattedValue.contains("%")) {
                        v /= 100.0;
                    }
                    c.setCellValue(v);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    c.setCellValue(formattedValue);
                }
            }
        }
    }

    private double parseNumericString(String str) {
        String cleanedValue = str.replaceAll("[%,$\u20ac\u00a3\u00b0m]", "");
        return Double.parseDouble(cleanedValue);
    }

    private void buildFloatAreaRow(long templateId, AbstractReportPlugin abstractReportPlugin) {
        ExportTemplateHelper exportTemplateHelper = new ExportTemplateHelper();
        Map<Integer, String> floatAreaRow = exportTemplateHelper.getFloatAreaRow(abstractReportPlugin.getSpreadManager().getMultiAreaManager());
        this.getFloatRowRangeMap().put(templateId, floatAreaRow);
    }

    private void setShowDimNameAndNumberInfo(AbstractReportPlugin abstractReportPlugin, POISpreadContainer spreadContainer, ReportExportDataRequest request) {
        boolean showDimName = request.isShowDimName();
        boolean showDimNumber = request.isShowDimNumber();
        boolean showDimNameNumber = request.isShowDimNameNumber();
        boolean showDimSimNameNumber = request.isShowDimSimNameNumber();
        boolean showDimLongNumber = request.isShowDimLongNumber();
        boolean showDimLongName = request.isShowDimLongName();
        boolean showDimLongNameNumber = request.isShowDimLongNameNumber();
        boolean showSimName = request.isShowSimName();
        if (abstractReportPlugin instanceof POIDynamicReportProcess) {
            ((POIDynamicReportProcess)abstractReportPlugin).setWorkbook(spreadContainer.getWorkbook());
        } else {
            ((POIFixReportProcess)abstractReportPlugin).setWorkbook(spreadContainer.getWorkbook());
        }
        if (showDimNumber) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.NUMBER.getIndex(), null);
        } else if (showDimNameNumber) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex(), null);
        } else if (showDimName) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.NAME.getIndex(), null);
        } else if (showSimName) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.SIMPLENAME.getIndex(), null);
        } else if (showDimSimNameNumber) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex(), null);
        } else if (showDimLongNumber) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.LONGNUMBER.getIndex(), null);
        } else if (showDimLongName) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.LONGNAME.getIndex(), null);
        } else if (showDimLongNameNumber) {
            abstractReportPlugin.buildSpreadRowColDimension(MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex(), null);
        }
    }

    private void setIsShowEmptyRowAndCol(AbstractReportPlugin abstractReportPlugin, POISpreadContainer spreadContainer, ReportExportDataRequest request) {
        if (abstractReportPlugin instanceof POIDynamicReportProcess) {
            POIDynamicReportProcess poiDynamicReportProcess = (POIDynamicReportProcess)abstractReportPlugin;
            poiDynamicReportProcess.setWorkbook(spreadContainer.getWorkbook());
            poiDynamicReportProcess.hideShowEmptyRows(request.isShowEmptyRow());
            poiDynamicReportProcess.hideShowEmptyCols(request.isShowEmptyCol());
            if (request.isShowDimNumber()) {
                poiDynamicReportProcess.buildSpreadRowColDimension(MemberDisplayTypeEnum.NUMBER.getIndex(), null);
            } else if (request.isShowDimNameNumber()) {
                poiDynamicReportProcess.buildSpreadRowColDimension(MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex(), null);
            }
        }
    }

    private void divideCell(Workbook workbook, String sheetName, boolean removeRange) {
        Sheet sheetAt = StringUtils.isNotEmpty((CharSequence)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
        List mergedRegions = sheetAt.getMergedRegions();
        HashSet<Integer> removeIndex = new HashSet<Integer>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            removeIndex.add(i);
        }
        for (CellRangeAddress mergedRegion : mergedRegions) {
            Object cellValue;
            Cell cell;
            int firstRow = mergedRegion.getFirstRow();
            int lastRow = mergedRegion.getLastRow();
            int firstColumn = mergedRegion.getFirstColumn();
            int lastColumn = mergedRegion.getLastColumn();
            Row row = sheetAt.getRow(firstRow);
            if (row == null || (cell = row.getCell(firstColumn)) == null || (cellValue = POIHelper.getCellValue((Cell)cell)) == null || StringUtils.isBlank((CharSequence)cellValue.toString())) continue;
            for (int i = firstRow; i <= lastRow; ++i) {
                for (int j = firstColumn; j <= lastColumn; ++j) {
                    Cell cell1;
                    Row row1 = sheetAt.getRow(i);
                    if (row1 == null || (cell1 = row1.getCell(j)) == null) continue;
                    POIHelper.setCellValue((XSSFSheet)((XSSFSheet)sheetAt), (int)i, (int)j, (Object)cellValue);
                }
            }
        }
        if (removeRange) {
            sheetAt.removeMergedRegions(removeIndex);
        }
    }

    private void includePageDim(Workbook workbook, String sheetName, ITemplateModel templateModel, List<IPageDimensionEntry> pagemembentry, long orgViewId, IModelCacheHelper modelCacheHelper, POISpreadContainer poiSpreadContainer) {
        Row memberRow;
        Map dimemsionViews = templateModel.getDimemsionViews();
        Sheet sheet = StringUtils.isNotEmpty((CharSequence)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        int lastRowNum = sheet.getLastRowNum();
        List mergedRegions = sheet.getMergedRegions();
        ArrayList<CellRangeAddress> newMergedRegions = new ArrayList<CellRangeAddress>(16);
        HashSet<Integer> deleteIndex = new HashSet<Integer>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            deleteIndex.add(i);
            CellRangeAddress cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (cellAddresses.getFirstColumn() == cellAddresses.getLastColumn() && cellAddresses.getFirstRow() == cellAddresses.getLastRow()) continue;
            cellAddresses.setFirstRow(cellAddresses.getFirstRow() + 2);
            cellAddresses.setLastRow(cellAddresses.getLastRow() + 2);
            newMergedRegions.add(cellAddresses);
        }
        sheet.removeMergedRegions(deleteIndex);
        POIHelper.shiftRows((Integer)0, (Integer)lastRowNum, (Integer)2, (Sheet)sheet, (POISpreadContainer)poiSpreadContainer, (Boolean)Boolean.FALSE);
        for (CellRangeAddress mergedRegion : newMergedRegions) {
            sheet.addMergedRegion(mergedRegion);
        }
        try {
            PaneInformation paneInformation = sheet.getPaneInformation();
            if (paneInformation != null) {
                short horizontalSplitPosition = paneInformation.getHorizontalSplitPosition();
                short verticalSplitPosition = paneInformation.getVerticalSplitPosition();
                boolean freezePane = paneInformation.isFreezePane();
                if (freezePane) {
                    sheet.createFreezePane((int)verticalSplitPosition, horizontalSplitPosition + 2, (int)paneInformation.getVerticalSplitLeftColumn(), paneInformation.getHorizontalSplitTopRow() + 2);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("move paneInformation has exception.");
        }
        try {
            Drawing pictureDrawing = sheet.getDrawingPatriarch();
            if (pictureDrawing != null) {
                for (Shape shape : pictureDrawing) {
                    if (!(shape instanceof XSSFPicture)) continue;
                    XSSFPicture xssfPicture = (XSSFPicture)shape;
                    XSSFClientAnchor clientAnchor = xssfPicture.getClientAnchor();
                    clientAnchor.setRow1(clientAnchor.getRow1() + 2);
                    clientAnchor.setRow2(clientAnchor.getRow2() + 2);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("move pictureDrawing has exception.");
        }
        try {
            List dataValidations = sheet.getDataValidations();
            if (CollectionUtils.isNotEmpty((Collection)dataValidations)) {
                ((XSSFSheet)sheet).getCTWorksheet().unsetDataValidations();
                for (DataValidation dataValidation : dataValidations) {
                    CellRangeAddress[] cellRangeAddresses;
                    CellRangeAddressList regions = dataValidation.getRegions();
                    if (regions != null && (cellRangeAddresses = regions.getCellRangeAddresses()) != null) {
                        for (CellRangeAddress cellRangeAddress : cellRangeAddresses) {
                            cellRangeAddress.setFirstRow(cellRangeAddress.getFirstRow() + 2);
                            cellRangeAddress.setLastRow(cellRangeAddress.getLastRow() + 2);
                        }
                    }
                    DataValidation validation = sheet.getDataValidationHelper().createValidation(dataValidation.getValidationConstraint(), dataValidation.getRegions());
                    sheet.addValidationData(validation);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("move dataValidations has exception.");
        }
        Row dimRow = sheet.getRow(0);
        if (dimRow == null) {
            dimRow = sheet.createRow(0);
        }
        if ((memberRow = sheet.getRow(1)) == null) {
            memberRow = sheet.createRow(1);
        }
        dimRow.setHeight((short)300);
        memberRow.setHeight((short)300);
        for (int i = 0; i < pagemembentry.size(); ++i) {
            IPageDimensionEntry pageDimensionEntry = pagemembentry.get(i);
            IDimension dimension = pageDimensionEntry.getDimension();
            List members = pageDimensionEntry.getMembers();
            IDimensionMember dimensionMember = (IDimensionMember)members.get(0);
            Cell cell = dimRow.createCell(i);
            Dimension dimension1 = modelCacheHelper.getDimension(dimension.getNumber());
            cell.setCellValue(dimension1 == null ? "" : dimension1.getName());
            cell.setCellStyle(cellStyle);
            Cell memberCell = memberRow.createCell(i);
            memberCell.setCellStyle(cellStyle);
            Member member = modelCacheHelper.getMember(dimension.getNumber(), (Long)dimemsionViews.get(dimension.getNumber()), dimensionMember.getNumber());
            if (StringUtils.equals((CharSequence)SysDimensionEnum.Entity.getNumber(), (CharSequence)dimension.getNumber())) {
                member = modelCacheHelper.getMember(dimension.getNumber(), Long.valueOf(orgViewId), dimensionMember.getNumber());
            }
            memberCell.setCellValue(member == null ? "" : member.getName());
        }
    }

    public void downloadWorkBook(Workbook workbook, String fileName) {
        if (workbook == null) {
            return;
        }
        try {
            String url = ImportAndExportUtil.writeFile((Workbook)workbook, (String)fileName, (int)43200);
            String processType = this.formView.getPageCache().get("current_rpt_type");
            if (StringUtils.isNotEmpty((CharSequence)processType)) {
                ImportAndExportUtil.addTempFileCheck((String)url, (String)(ProcessTypeEnum.TASK.getNumber().equals(processType) ? "eb_executetask" : "bgm_rptpreparation"), (String)ApplicationTypeEnum.BGM.getAppnum(), (int)43200);
            }
            ((IClientViewProxy)this.formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
            String exportFileId = this.getExportfileId();
            this.updateExportFileStatus(exportFileId, url, ExportFileStatusEnum.EXPORT_END.getIndex());
        }
        catch (IOException ex) {
            String exportFileId = this.getExportfileId();
            log.info("--export downloadWorkBook update failed");
            this.updateExportFileStatus(exportFileId, null, ExportFileStatusEnum.EXPORT_FAIL.getIndex());
            throw new KDException(ex.getMessage());
        }
        finally {
            try {
                if (workbook instanceof SXSSFWorkbook) {
                    SXSSFWorkbook sxssfWorkbook = (SXSSFWorkbook)workbook;
                    this.deleteSXSStempFile(sxssfWorkbook);
                }
                workbook.close();
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
            }
        }
    }

    public void deleteSXSStempFile(SXSSFWorkbook workbook) {
        workbook.dispose();
    }

    private void updateExportFileStatus(String exportFileId, String url, String status) {
        ExportLogService.getInstance().updateExportFileStatus(exportFileId, url, status, null);
    }

    private void updateExportFileProgress(String exportFileId, String progress) {
        ExportLogService.getInstance().updateExportFileProgress(exportFileId, progress);
    }

    public String getRatio(Integer number1, Integer number2) {
        DecimalFormat df = new DecimalFormat("0");
        if (number2 != 0) {
            if (((ReportExportDataRequest)this.reportExportTaskRequest.getExportDataRequests().get(0)).getExportTypeEnum() == ReportExportTypeEnum.EXPORT_BY_ORG) {
                double percentProgress;
                this.currentExportProgress = percentProgress = (double)((float)((double)number1.intValue() / (double)number2.intValue())) * this.ratio + this.preExportProgress;
                return df.format(percentProgress * 100.0) + "%";
            }
            return df.format((float)((double)number1.intValue() / (double)number2.intValue()) * 100.0f) + "%";
        }
        return "0%";
    }

    public void zipWorkBook(ZipOutputStream zipOutputStream, Workbook workbook, String excelFileName) {
        ImportAndExportUtil.zipWorkBook((ZipOutputStream)zipOutputStream, (Workbook)workbook, (String)excelFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downWorkBook(ByteArrayOutputStream outStream, String fileName) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", (InputStream)inStream, 43200);
            String processType = this.getPageCache().get("current_rpt_type");
            if (StringUtils.isNotEmpty((CharSequence)processType)) {
                ImportAndExportUtil.addTempFileCheck((String)url, (String)(ProcessTypeEnum.TASK.getNumber().equals(processType) ? "eb_executetask" : "bgm_rptpreparation"), (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
            }
            ((IClientViewProxy)this.formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
            String exportFileId = this.getExportfileId();
            this.updateExportFileStatus(exportFileId, url, ExportFileStatusEnum.EXPORT_END.getIndex());
        }
        catch (Exception exception) {
            String exportFileId = this.getExportfileId();
            log.info("--export downWorkBook update failed");
            this.updateExportFileStatus(exportFileId, null, ExportFileStatusEnum.EXPORT_FAIL.getIndex());
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException e) {
                log.error("epm-eb:exportdata");
                log.error((Throwable)e);
            }
        }
    }

    private void zipDownloadWorkBook(List<Workbook> workbooks, String fileName) {
        if (CollectionUtils.isEmpty(workbooks)) {
            return;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outStream);
        try {
            for (Workbook workbook : workbooks) {
                this.zipWorkBook(zipOutputStream, workbook, workbook.getSheetName(0));
            }
        }
        catch (Exception exception) {
            log.error("epm-eb:exportdata");
            log.error((Throwable)exception);
            throw new KDBizException("system is error, please call manager." + exception.getMessage());
        }
        finally {
            try {
                outStream.close();
                zipOutputStream.close();
            }
            catch (IOException e) {
                log.error("epm-eb:exportdata");
                log.error((Throwable)e);
            }
        }
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", (InputStream)inStream, 43200);
            String processType = this.getPageCache().get("current_rpt_type");
            if (StringUtils.isNotEmpty((CharSequence)processType)) {
                ImportAndExportUtil.addTempFileCheck((String)url, (String)(ProcessTypeEnum.TASK.getNumber().equals(processType) ? "eb_executetask" : "bgm_rptpreparation"), (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
            }
            ((IClientViewProxy)this.formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
            String exportFileId = this.getExportfileId();
            this.updateExportFileStatus(exportFileId, url, ExportFileStatusEnum.EXPORT_END.getIndex());
        }
        catch (Exception exception) {
            String exportFileId = this.getExportfileId();
            log.info("--export zipDownloadWorkBook update failed");
            this.updateExportFileStatus(exportFileId, null, ExportFileStatusEnum.EXPORT_FAIL.getIndex());
        }
    }

    protected void afterExecute() {
        if (this.reportExportTaskRequest == null) {
            return;
        }
        ArrayList<String> errorMessageList = new ArrayList<String>(16);
        String errorMessage = "";
        if (CollectionUtils.isNotEmpty(this.moreThanMaxExportSizeTemplateInfos)) {
            errorMessage = ResManager.loadResFormat((String)"\u62a5\u8868\uff1a%1\u8d85\u8fc7\u5355\u4e2a\u62a5\u8868\u5bfc\u51fa\u7684\u6700\u5927\u6d6e\u52a8\u884c\u9650\u5236%2\uff0c\u4e0d\u5141\u8bb8\u5bfc\u51fa\u3002", (String)"POIExportCommand_005", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", this.moreThanMaxExportSizeTemplateInfos), this.maxExportSize});
            errorMessageList.add(errorMessage);
        }
        if (CollectionUtils.isNotEmpty(this.moreThanMaxExportFloatRowSizeTemplateInfos)) {
            errorMessage = ResManager.loadResFormat((String)"\u62a5\u8868\uff1a%1\u8d85\u8fc7\u5355\u4e2a\u62a5\u8868\u5bfc\u51fa\u7684\u6700\u5927\u6d6e\u52a8\u884c\u9650\u5236%2\uff0c\u4e0d\u5141\u8bb8\u5bfc\u51fa\u3002", (String)"POIExportCommand_006", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", this.moreThanMaxExportFloatRowSizeTemplateInfos), this.maxExportFloatRowSize});
            errorMessageList.add(errorMessage);
        }
        if (this.errorInfoMap != null && this.errorInfoMap.size() > 0) {
            ArrayList<String> errorInfos = new ArrayList<String>(16);
            for (Map.Entry<String, Set<String>> entry : this.errorInfoMap.entrySet()) {
                String key = entry.getKey();
                Set<String> value = entry.getValue();
                for (String s : value) {
                    errorInfos.add(ResManager.loadResFormat((String)"%1:%2", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{s, key}));
                }
            }
            errorMessage = String.join((CharSequence)"\uff1b", errorInfos);
            errorMessageList.add(errorMessage);
        }
        if (CollectionUtils.isNotEmpty(errorMessageList)) {
            ExportLogService.getInstance().updateExportFileStatus(this.reportExportTaskRequest.getExportLogId() + "", null, ExportFileStatusEnum.PART_END.getIndex(), String.join((CharSequence)";", errorMessageList));
        }
        ExportExceptionHelper.getInstance().removeCancelExportLogIdCache(this.reportExportTaskRequest.getExportLogId());
        if (this.reportExportTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
            ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
        }
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public void setExportDataRequests(List<ReportExportDataRequest> exportDataRequests) {
        this.reportExportTaskRequest.setExportDataRequests(exportDataRequests);
    }

    public Map<Long, Map<Integer, String>> getFloatRowRangeMap() {
        if (this.floatRowRangeMap == null) {
            this.floatRowRangeMap = new HashMap<Long, Map<Integer, String>>(16);
        }
        return this.floatRowRangeMap;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
    }

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void setNeedFlush(boolean needFlush) {
        this.needFlush = needFlush;
    }

    static class DoExportRequestReturn {
        private Workbook workbook;
        private String requestType;

        DoExportRequestReturn() {
        }

        public Workbook getWorkbook() {
            return this.workbook;
        }

        public void setWorkbook(Workbook workbook) {
            this.workbook = workbook;
        }

        public String getRequestType() {
            return this.requestType;
        }

        public void setRequestType(String requestType) {
            this.requestType = requestType;
        }
    }
}

