/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.formplugin.report.excel.domain.ImportSheetManager;
import kd.epm.eb.formplugin.report.excel.entity.ImportCell;
import kd.epm.eb.formplugin.report.excel.entity.ReportImportDataErrorInfo;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportErrorManager {
    Map<String, Workbook> errorWorkBookMap = new HashMap<String, Workbook>(16);
    private final List<ReportImportDataErrorInfo> importDataErrorInfos = new ArrayList<ReportImportDataErrorInfo>(16);
    private final Map<Integer, Map<String, List<ReportImportDataErrorInfo>>> importDataSheetErrorInfosMap = new HashMap<Integer, Map<String, List<ReportImportDataErrorInfo>>>(16);
    private final Map<Integer, Map<String, List<ReportImportDataErrorInfo>>> importDataCellErrorInfosMap = new HashMap<Integer, Map<String, List<ReportImportDataErrorInfo>>>(16);

    public Map<String, Workbook> getErrorWorkBookMap() {
        return this.errorWorkBookMap;
    }

    public void addErrorInfo(String errorInfo) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(ReportImportDataErrorInfo.ErrorLevel.FILE, errorInfo);
        this.importDataErrorInfos.add(reportImportDataErrorInfo);
    }

    public void addSheetErrorInfo(Integer currentWorkbookIndex, String errorInfo, String sheetName) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(ReportImportDataErrorInfo.ErrorLevel.SHEET, errorInfo, sheetName, 0, 0);
        List reportImportDataErrorInfos = this.importDataSheetErrorInfosMap.computeIfAbsent(currentWorkbookIndex, t -> new HashMap(16)).computeIfAbsent(sheetName, t -> new ArrayList(16));
        reportImportDataErrorInfos.add(reportImportDataErrorInfo);
    }

    public void addCellErrorInfo(Integer currentWorkbookIndex, String errorInfo, String sheetName, int rowIndex, int colIndex) {
        ReportImportDataErrorInfo reportImportDataErrorInfo = new ReportImportDataErrorInfo(ReportImportDataErrorInfo.ErrorLevel.CELL, errorInfo, sheetName, rowIndex, colIndex);
        List reportImportDataErrorInfos = this.importDataCellErrorInfosMap.computeIfAbsent(currentWorkbookIndex, t -> new HashMap(16)).computeIfAbsent(sheetName, t -> new ArrayList(16));
        reportImportDataErrorInfos.add(reportImportDataErrorInfo);
    }

    public boolean hasSheetOrCellErrorInfo(Integer currentWorkBookIndex, String sheetName) {
        return this.hasSheetErrorInfo(currentWorkBookIndex, sheetName) || this.hasCellErrorInfo(currentWorkBookIndex, sheetName);
    }

    public boolean hasErrorInfo() {
        return CollectionUtils.isNotEmpty(this.importDataErrorInfos);
    }

    public boolean hasSheetErrorInfo(Integer currentWorkBookIndex, String sheetName) {
        if (this.importDataSheetErrorInfosMap.size() == 0) {
            return false;
        }
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataSheetErrorInfosMap = this.importDataSheetErrorInfosMap.get(currentWorkBookIndex);
        if (reportImportDataSheetErrorInfosMap != null && reportImportDataSheetErrorInfosMap.size() > 0) {
            List<ReportImportDataErrorInfo> reportImportDataErrorInfos = reportImportDataSheetErrorInfosMap.get(sheetName);
            return CollectionUtils.isNotEmpty(reportImportDataErrorInfos);
        }
        return false;
    }

    public boolean hasCellErrorInfo(Integer currentWorkBookIndex, String sheetName) {
        if (this.importDataCellErrorInfosMap.size() == 0) {
            return false;
        }
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataCellErrorInfosMap = this.importDataCellErrorInfosMap.get(currentWorkBookIndex);
        if (reportImportDataCellErrorInfosMap != null && reportImportDataCellErrorInfosMap.size() > 0) {
            List<ReportImportDataErrorInfo> reportImportDataErrorInfos = reportImportDataCellErrorInfosMap.get(sheetName);
            return CollectionUtils.isNotEmpty(reportImportDataErrorInfos);
        }
        return false;
    }

    public void writeTableData2ErrorWorkBook(Integer currentWorkBookIndex, String fileName, String sheetName, List<List<ImportCell>> tableData) {
        boolean hasErrorInfo;
        if (this.importDataSheetErrorInfosMap.size() == 0 && this.importDataCellErrorInfosMap.size() == 0) {
            return;
        }
        ImportSheetManager importSheetManager = new ImportSheetManager(sheetName, tableData);
        DataFormatter formatter = new DataFormatter();
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataSheetErrorInfosMap = this.importDataSheetErrorInfosMap.get(currentWorkBookIndex);
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataCellErrorInfosMap = this.importDataCellErrorInfosMap.get(currentWorkBookIndex);
        List<Object> reportImportDataSheetErrorInfos = new ArrayList(16);
        if (reportImportDataSheetErrorInfosMap != null) {
            reportImportDataSheetErrorInfos = reportImportDataSheetErrorInfosMap.get(sheetName);
        }
        List<Object> reportImportDataCellErrorInfos = new ArrayList(16);
        if (reportImportDataCellErrorInfosMap != null) {
            reportImportDataCellErrorInfos = reportImportDataCellErrorInfosMap.get(sheetName);
        }
        boolean bl = hasErrorInfo = CollectionUtils.isNotEmpty(reportImportDataSheetErrorInfos) || CollectionUtils.isNotEmpty(reportImportDataCellErrorInfos);
        if (hasErrorInfo) {
            Workbook workbook = this.errorWorkBookMap.get(fileName);
            if (workbook == null) {
                workbook = new XSSFWorkbook();
                this.errorWorkBookMap.put(fileName, workbook);
            }
            Sheet sheet = workbook.createSheet(sheetName);
            int rowOffset = 0;
            int colOffset = 0;
            if (CollectionUtils.isNotEmpty(reportImportDataSheetErrorInfos)) {
                rowOffset = 1;
            }
            if (CollectionUtils.isNotEmpty(reportImportDataCellErrorInfos)) {
                colOffset = 1;
            }
            for (int rowIndex = 0; rowIndex < tableData.size(); ++rowIndex) {
                List<ImportCell> colList = tableData.get(rowIndex);
                if (CollectionUtils.isEmpty(colList)) continue;
                int excelRowIndex = rowIndex + rowOffset;
                Row row = sheet.getRow(excelRowIndex);
                if (row == null) {
                    row = sheet.createRow(excelRowIndex);
                }
                for (int colIndex = 0; colIndex < colList.size(); ++colIndex) {
                    String cellValue = importSheetManager.getCellValue(rowIndex, colIndex);
                    ImportCell importCell = colList.get(colIndex);
                    if (StringUtils.isBlank((CharSequence)cellValue)) continue;
                    int excelColIndex = colIndex + colOffset;
                    Cell cell = row.getCell(excelColIndex);
                    if (cell == null) {
                        cell = row.createCell(excelColIndex);
                    }
                    cell.setCellValue(importCell.getDataValue(formatter));
                }
            }
        }
    }

    private CellStyle createErrorInfoStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor(IndexedColors.RED.index);
        font.setBold(true);
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    public void buildErrorWorkBook(String fileName, Integer currentWorkBookIndex) {
        String sheetName;
        if (this.importDataSheetErrorInfosMap.size() == 0 && this.importDataCellErrorInfosMap.size() == 0) {
            return;
        }
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataSheetErrorInfosMap = this.importDataSheetErrorInfosMap.get(currentWorkBookIndex);
        Map<String, List<ReportImportDataErrorInfo>> reportImportDataCellErrorInfosMap = this.importDataCellErrorInfosMap.get(currentWorkBookIndex);
        Workbook workbook = this.errorWorkBookMap.get(fileName);
        if (workbook == null) {
            return;
        }
        CellStyle cellStyle = this.createErrorInfoStyle(workbook);
        boolean hasErrorInfo = false;
        if (reportImportDataSheetErrorInfosMap != null && reportImportDataSheetErrorInfosMap.size() > 0) {
            hasErrorInfo = true;
            for (Map.Entry<String, List<ReportImportDataErrorInfo>> entry : reportImportDataSheetErrorInfosMap.entrySet()) {
                Cell cell;
                sheetName = entry.getKey();
                List<ReportImportDataErrorInfo> value = entry.getValue();
                List errorInfos = value.stream().map(ReportImportDataErrorInfo::getErrorDesc).collect(Collectors.toList());
                Sheet sheet = workbook.getSheet(sheetName);
                if (sheet == null) {
                    sheet = workbook.createSheet(sheetName);
                }
                sheet.setColumnWidth(0, 25784);
                Row row = sheet.getRow(0);
                if (row == null) {
                    row = sheet.createRow(0);
                }
                if ((cell = row.getCell(0)) == null) {
                    cell = row.createCell(0);
                } else {
                    errorInfos.add(POIHelper.getCellValue((Cell)cell) + "");
                }
                cell.setCellValue(String.join((CharSequence)";", errorInfos));
                cell.setCellStyle(cellStyle);
            }
        }
        if (reportImportDataCellErrorInfosMap != null && reportImportDataCellErrorInfosMap.size() > 0) {
            hasErrorInfo = true;
            for (Map.Entry<String, List<ReportImportDataErrorInfo>> entry : reportImportDataCellErrorInfosMap.entrySet()) {
                sheetName = entry.getKey();
                List<ReportImportDataErrorInfo> errorInfos = entry.getValue();
                Sheet sheet = workbook.getSheet(sheetName);
                if (sheet == null) {
                    sheet = workbook.createSheet(sheetName);
                }
                sheet.setColumnWidth(0, 25784);
                for (ReportImportDataErrorInfo errorInfo : errorInfos) {
                    Cell cell;
                    StringBuilder errorInfoStr = new StringBuilder();
                    int rowIndex = errorInfo.getRowIndex();
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) {
                        row = sheet.createRow(rowIndex);
                    }
                    if ((cell = row.getCell(0)) == null) {
                        cell = row.createCell(0);
                    } else {
                        errorInfoStr.append(POIHelper.getCellValue((Cell)cell));
                    }
                    if (StringUtils.isNotBlank((CharSequence)errorInfoStr)) {
                        cell.setCellValue(errorInfoStr + ";" + errorInfo.getErrorDesc());
                    } else {
                        cell.setCellValue(errorInfo.getErrorDesc());
                    }
                    cell.setCellStyle(cellStyle);
                }
            }
        }
        if (hasErrorInfo) {
            this.errorWorkBookMap.put(fileName, workbook);
        }
    }

    public List<ReportImportDataErrorInfo> getImportDataErrorInfos() {
        return this.importDataErrorInfos;
    }
}

