/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.domain;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.formplugin.report.excel.domain.ImportBaseManager;
import kd.epm.eb.formplugin.report.excel.domain.ImportSheetManager;
import kd.epm.eb.formplugin.report.excel.entity.ImportExcelFileInfo;
import kd.epm.eb.formplugin.report.excel.helper.ExcelXlsxReader;
import kd.epm.eb.formplugin.report.excel.helper.ExportTemplateHelper;
import kd.epm.eb.formplugin.report.excel.helper.ImportStreamHelper;
import kd.epm.eb.spread.report.excel.constant.ReportImportTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImportExcelManager {
    private static final Log log = LogFactory.getLog(ImportExcelManager.class);
    private final ImportBaseManager importBaseManager;
    private XSSFReader.SheetIterator sheetIterator;
    private int sheetCount = 0;
    private final List<String> sheetNames = new ArrayList<String>(16);
    private ExcelXlsxReader excelXlsxReader;
    private XMLReader parser;
    private final ImportExcelFileInfo importExcelFileInfo;
    private static final Set<String> ignoreSheetNames = Sets.newHashSet((Object[])new String[]{ExportTemplateHelper.dataValidSourceSheetName, ExportTemplateHelper.floatTemplateImportDescSheetName, ExportTemplateHelper.hiddenDataValidDataSourceSheetName});

    public ImportExcelManager(ImportExcelFileInfo importExcelFileInfo, ImportBaseManager importBaseManager) {
        this.importBaseManager = importBaseManager;
        this.importExcelFileInfo = importExcelFileInfo;
        this.build();
    }

    private void readSheetInfo(InputStream inputStream) throws Exception {
        IOUtils.setByteArrayMaxOverride((int)0x64000000);
        OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
        XSSFReader xssfReader = new XSSFReader(pkg);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        while (sheets.hasNext()) {
            InputStream ignored = sheets.next();
            Throwable throwable = null;
            try {
                ++this.sheetCount;
                this.sheetNames.add(sheets.getSheetName());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        if (this.sheetCount > this.importBaseManager.getMaxSheetCount()) {
            String errorInfo = ResManager.loadResFormat((String)"\u6bcf\u4e2aExcel\u6700\u5927\u5141\u8bb8\u5bfc\u5165%1\u4e2aSheet\u9875\u7b7e\uff0c%2\u5b58\u5728%3\u4e2aSheet\u9875\u7b7e\u3002", (String)"ImportExcelManager_01", (String)"epm-eb-formplugin", (Object[])new Object[]{this.importBaseManager.getMaxSheetCount(), this.importExcelFileInfo.getFileName(), this.sheetCount});
            throw new KDBizException(errorInfo);
        }
        int totalSheetCount = this.importBaseManager.getTotalSheetCount();
        this.importBaseManager.setTotalSheetCount(totalSheetCount += this.sheetCount);
    }

    private void build() {
        try (ByteArrayOutputStream outputStream = ImportStreamHelper.cacheInputStream(this.importExcelFileInfo.getInputStream());){
            if (outputStream == null || outputStream.size() == 0) {
                return;
            }
            try (InputStream inputStream = ImportStreamHelper.getInputStream(outputStream);){
                this.readSheetInfo(inputStream);
            }
            inputStream = ImportStreamHelper.getInputStream(outputStream);
            var4_9 = null;
            try {
                OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
                XSSFReader xssfReader = new XSSFReader(pkg);
                ExcelXlsxReader excelXlsxReader = new ExcelXlsxReader();
                excelXlsxReader.setStylesTable(xssfReader.getStylesTable());
                excelXlsxReader.setSst(xssfReader.getSharedStringsTable());
                XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
                XMLReader parser = XMLReaderFactory.createXMLReader();
                parser.setContentHandler(excelXlsxReader);
                this.parser = parser;
                this.sheetIterator = sheetIterator;
                this.excelXlsxReader = excelXlsxReader;
            }
            catch (Throwable throwable) {
                var4_9 = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (var4_9 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            var4_9.addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("build ImportExcelManager error.");
            log.error((Throwable)e);
            String errorInfo = ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20excel\u6587\u4ef6\u3002", (String)"BgmReportImportDataPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (e instanceof KDBizException) {
                errorInfo = e.getMessage();
            }
            this.importBaseManager.getImportErrorManager().addErrorInfo(errorInfo);
        }
    }

    private boolean checkByImportType() {
        if (this.importBaseManager.getImportTypeEnum() == ReportImportTypeEnum.IMPORT_SINGLE) {
            String errorInfo;
            boolean flag = false;
            boolean hasEnumDataValidSheet = false;
            if (this.sheetNames.size() > 1 + ignoreSheetNames.size()) {
                String errorInfo2 = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e2d\u542b\u6709\u591a\u4e2a\u9875\u7b7e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.importBaseManager.getImportErrorManager().addErrorInfo(errorInfo2);
                return false;
            }
            for (String sheetName : this.sheetNames) {
                if (StringUtils.equals((CharSequence)sheetName, (CharSequence)ExportTemplateHelper.dataValidSourceSheetName)) {
                    flag = true;
                }
                if (!sheetName.startsWith(ExportTemplateHelper.hiddenDataValidDataSourceSheetName)) continue;
                hasEnumDataValidSheet = true;
            }
            int maxSheetSize = 1;
            if (flag) {
                maxSheetSize = hasEnumDataValidSheet ? 4 : 3;
                if (this.sheetCount > maxSheetSize) {
                    errorInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e2d\u542b\u6709\u591a\u4e2a\u9875\u7b7e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.importBaseManager.getImportErrorManager().addErrorInfo(errorInfo);
                    return false;
                }
            } else {
                if (hasEnumDataValidSheet) {
                    maxSheetSize = 2;
                }
                if (this.sheetCount > maxSheetSize) {
                    errorInfo = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e2d\u542b\u6709\u591a\u4e2a\u9875\u7b7e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BgmReportImportDataPlugin_07", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.importBaseManager.getImportErrorManager().addErrorInfo(errorInfo);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean beforeImport() {
        boolean checkPass = this.checkByImportType();
        return checkPass;
    }

    public void execute() {
        boolean checkPass = this.beforeImport();
        if (checkPass) {
            this.doImport();
        }
        this.afterImport();
    }

    private boolean ignoreSheet(String sheetName) {
        return ignoreSheetNames.contains(sheetName) || sheetName.startsWith(ExportTemplateHelper.hiddenDataValidDataSourceSheetName);
    }

    private void doImport() {
        try {
            while (this.sheetIterator.hasNext()) {
                InputStream sheet = this.sheetIterator.next();
                String sheetName = this.sheetIterator.getSheetName();
                if (this.ignoreSheet(sheetName)) continue;
                this.excelXlsxReader.setCurCol(0);
                this.excelXlsxReader.setCurRow(0);
                this.excelXlsxReader.setTElement(false);
                this.excelXlsxReader.setTotalCellSize(0);
                this.excelXlsxReader.setMaxReadCellCount(this.importBaseManager.getMaxCellCount());
                InputSource sheetSource = new InputSource(sheet);
                this.parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                try {
                    this.parser.parse(sheetSource);
                }
                catch (KDBizException e) {
                    this.importBaseManager.getImportErrorManager().addSheetErrorInfo(this.importBaseManager.getCurrentWorkBookIndex(), e.getMessage(), sheetName);
                }
                ImportSheetManager importSheetManager = new ImportSheetManager(sheetName, this.excelXlsxReader.getCurrentSheetTableData(), this.importBaseManager);
                importSheetManager.setFileName(this.importExcelFileInfo.getFileName());
                importSheetManager.execute();
                this.excelXlsxReader.getCurrentSheetTableData().clear();
                sheet.close();
                int globalSheetIndex = this.importBaseManager.getGlobalSheetIndex();
                this.importBaseManager.setGlobalSheetIndex(++globalSheetIndex);
            }
        }
        catch (IOException | SAXException e) {
            log.error((Throwable)e);
        }
    }

    private void afterImport() {
        this.importBaseManager.getImportErrorManager().buildErrorWorkBook(this.importExcelFileInfo.getFileName(), this.importBaseManager.getCurrentWorkBookIndex());
    }
}

