/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.entity;

import kd.epm.eb.formplugin.report.excel.helper.ExcelXlsxReader;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ImportCell {
    private ExcelXlsxReader.CellDataType nextDataType = ExcelXlsxReader.CellDataType.SSTINDEX;
    private short formatIndex;
    private String formatString;
    private String originalValue;
    private String value;

    public ImportCell(short formatIndex, String formatString, String value) {
        this.formatIndex = formatIndex;
        this.formatString = formatString;
        this.value = value;
    }

    public ImportCell(ExcelXlsxReader.CellDataType nextDataType, short formatIndex, String formatString, String originalValue, String value) {
        this.nextDataType = nextDataType;
        this.formatIndex = formatIndex;
        this.formatString = formatString;
        this.originalValue = originalValue;
        this.value = value;
    }

    public ExcelXlsxReader.CellDataType getNextDataType() {
        return this.nextDataType;
    }

    public void setNextDataType(ExcelXlsxReader.CellDataType nextDataType) {
        this.nextDataType = nextDataType;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public short getFormatIndex() {
        return this.formatIndex;
    }

    public void setFormatIndex(short formatIndex) {
        this.formatIndex = formatIndex;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDataValue(DataFormatter formatter) {
        String thisStr = "";
        switch (this.nextDataType) {
            case BOOL: {
                char first = this.originalValue.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: 
            case FORMULA: {
                thisStr = this.originalValue;
                break;
            }
            case INLINESTR: {
                XSSFRichTextString rtsi = new XSSFRichTextString(this.originalValue);
                thisStr = rtsi.toString();
                break;
            }
            case SSTINDEX: {
                thisStr = this.value;
                break;
            }
            case NUMBER: {
                if (this.formatString != null) {
                    if (DateUtil.isADateFormat((int)this.formatIndex, (String)this.formatString) || ExcelXlsxReader.specialDateFormatIndex.contains(this.formatIndex)) {
                        thisStr = formatter.formatRawCellContents(Double.parseDouble(this.originalValue), (int)this.formatIndex, this.formatString);
                        thisStr = thisStr.replace("T", " ");
                        thisStr = thisStr.replace("00:00:00", "");
                        return thisStr;
                    }
                    if (this.formatString.contains("%")) {
                        thisStr = formatter.formatRawCellContents(Double.parseDouble(this.originalValue), (int)this.formatIndex, this.formatString).trim();
                        return thisStr;
                    }
                }
                thisStr = this.value;
                break;
            }
            case DATE: {
                thisStr = formatter.formatRawCellContents(Double.parseDouble(this.originalValue), (int)this.formatIndex, this.formatString);
                thisStr = thisStr.replace("T", " ");
                thisStr = thisStr.replace("00:00:00", "");
                break;
            }
            default: {
                thisStr = " ";
            }
        }
        return thisStr.trim();
    }
}

