/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.report.excel.exception.KDEpmExportCancelException;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.report.excel.helper.ExportTemplateHelper;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Shape;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFPicture;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;

public class POISheetMergeHelper {
    private static final Log log = LogFactory.getLog(POISheetMergeHelper.class);

    public static void copyCellValue(Cell cell, Cell fromCell) {
        CellType cellType = fromCell.getCellType();
        SXSSFCell toCell = (SXSSFCell)cell;
        if (cellType != CellType.FORMULA) {
            toCell.setCellType(cellType);
        }
        switch (cellType) {
            case STRING: {
                toCell.setCellValue(fromCell.getRichStringCellValue());
                break;
            }
            case NUMERIC: {
                toCell.setCellValue(fromCell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                POISheetMergeHelper.copyCtCellFormulaValue(fromCell, (Cell)toCell);
                break;
            }
            case BOOLEAN: {
                toCell.setCellValue(fromCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                toCell.setCellValue((double)fromCell.getErrorCellValue());
                break;
            }
            case BLANK: {
                toCell.setBlank();
                break;
            }
        }
    }

    private static void copyCtCellFormulaValue(Cell fromCell, Cell toCell) {
        POISheetMergeHelper.updateCtCellFormulaValue(toCell, fromCell.getCellFormula());
    }

    private static void updateCtCellFormulaValue(Cell cell, String shiftedFormula) {
        if (shiftedFormula != null) {
            try {
                cell.removeFormula();
                cell.setCellFormula(shiftedFormula);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void mergeWorkBook(boolean needFlush, Workbook baseWorkBook, Workbook fromWorkBook, String workbookType, Map<String, Short> styleMap, Long exportLogId, int colOffset, int rowOffset) {
        if (baseWorkBook == null) {
            return;
        }
        for (Sheet fromSheet : fromWorkBook) {
            int lastRowNum = fromSheet.getLastRowNum();
            SXSSFSheet sheet = (SXSSFSheet)baseWorkBook.createSheet(fromSheet.getSheetName());
            SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
            if (StringUtils.isNotEmpty((String)fromSheet.getSheetName()) && fromSheet.getSheetName().startsWith(ExportTemplateHelper.hiddenDataValidDataSourceSheetName)) {
                baseWorkBook.setSheetHidden(baseWorkBook.getSheetIndex((Sheet)sheet), true);
            }
            try {
                ArrayList value;
                ExportExceptionHelper.getInstance().judgeExportCancel(exportLogId);
                POISheetMergeHelper.setDefaultSheetStyle(sheet, fromSheet);
                POISheetMergeHelper.copySheetPicture(baseWorkBook, sheet, fromSheet, drawingPatriarch);
                POISheetMergeHelper.copyMergedRegions(sheet, fromSheet);
                POISheetMergeHelper.copyPaneInformation(sheet, fromSheet);
                POISheetMergeHelper.copyDataValid(sheet, fromSheet);
                HashMap<Integer, Set> colGroupLevelMap = new HashMap<Integer, Set>(16);
                HashMap<Integer, Set> rowGroupLevelMap = new HashMap<Integer, Set>(16);
                int i = 0;
                for (Row fromRow : fromSheet) {
                    if (i++ % 1000 == 0) {
                        ExportExceptionHelper.getInstance().judgeExportCancel(exportLogId);
                    }
                    if (fromRow == null || fromRow.getLastCellNum() < 1) continue;
                    int rowIndex = fromRow.getRowNum();
                    SXSSFRow row = sheet.createRow(rowIndex);
                    CellStyle fromRowStyle = fromRow.getRowStyle();
                    if (fromRowStyle != null) {
                        int fromHashCode = fromRowStyle.hashCode();
                        XSSFFont fromFont = ((XSSFCellStyle)fromRowStyle).getFont();
                        int fromFontHashCode = fromFont.hashCode();
                        Short index = styleMap.get(fromHashCode + "#" + fromFontHashCode);
                        if (index == null) {
                            CellStyle rowStyle = baseWorkBook.createCellStyle();
                            rowStyle.cloneStyleFrom(fromRowStyle);
                            row.setRowStyle(rowStyle);
                            styleMap.put(fromHashCode + "#" + fromFontHashCode, rowStyle.getIndex());
                        } else {
                            CellStyle cellStyleAt = baseWorkBook.getCellStyleAt((int)index.shortValue());
                            row.setRowStyle(cellStyleAt);
                        }
                    }
                    short height = fromRow.getHeight();
                    row.setHeight(height);
                    int outlineLevel = fromRow.getOutlineLevel();
                    if (outlineLevel > 0 && rowGroupLevelMap != null) {
                        Set integers = rowGroupLevelMap.computeIfAbsent(outlineLevel, t -> new LinkedHashSet(16));
                        integers.add(rowIndex);
                    }
                    boolean j = false;
                    for (Cell fromCell : fromRow) {
                        int columnOutlineLevel;
                        if (fromCell == null) continue;
                        int colIndex = fromCell.getColumnIndex();
                        CellStyle fromColumnStyle = fromSheet.getColumnStyle(colIndex);
                        if (fromColumnStyle != null) {
                            Integer fromHashCode = fromColumnStyle.hashCode();
                            XSSFFont fromFont = ((XSSFCellStyle)fromColumnStyle).getFont();
                            int fromFontHashCode = fromFont.hashCode();
                            Short index = styleMap.get(fromHashCode + "#" + fromFontHashCode);
                            if (index == null) {
                                CellStyle cellStyle = baseWorkBook.createCellStyle();
                                cellStyle.cloneStyleFrom(fromColumnStyle);
                                sheet.setDefaultColumnStyle(colIndex, cellStyle);
                                styleMap.put(fromHashCode + "#" + fromFontHashCode, cellStyle.getIndex());
                            } else {
                                CellStyle cellStyleAt = baseWorkBook.getCellStyleAt((int)index.shortValue());
                                sheet.setDefaultColumnStyle(colIndex, cellStyleAt);
                            }
                        }
                        Cell cell = row.createCell(colIndex);
                        POISheetMergeHelper.copyCellValue(cell, fromCell);
                        CellStyle fromCellStyle = fromCell.getCellStyle();
                        if (fromCellStyle != null) {
                            int fromHashCode = fromCellStyle.hashCode();
                            XSSFFont fromFont = ((XSSFCellStyle)fromCellStyle).getFont();
                            int fromFontHashCode = fromFont.hashCode();
                            Short index = styleMap.get(fromHashCode + "#" + fromFontHashCode);
                            if (index == null) {
                                CellStyle cellStyle = baseWorkBook.createCellStyle();
                                try {
                                    cellStyle.cloneStyleFrom(fromCellStyle);
                                    if ("dynamic".equalsIgnoreCase(workbookType)) {
                                        cellStyle.setBorderRight(BorderStyle.THIN);
                                        cellStyle.setBorderLeft(BorderStyle.THIN);
                                        cellStyle.setBorderTop(BorderStyle.THIN);
                                        cellStyle.setBorderBottom(BorderStyle.THIN);
                                    }
                                    cell.setCellStyle(cellStyle);
                                    styleMap.put(fromHashCode + "#" + fromFontHashCode, cellStyle.getIndex());
                                }
                                catch (Exception e) {
                                    log.error((Throwable)e);
                                }
                            } else {
                                CellStyle cellStyleAt = baseWorkBook.getCellStyleAt((int)index.shortValue());
                                cell.setCellStyle(cellStyleAt);
                            }
                        }
                        sheet.setColumnHidden(colIndex, fromSheet.isColumnHidden(colIndex));
                        sheet.setColumnWidth(colIndex, fromSheet.getColumnWidth(colIndex));
                        Comment fromCellComment = fromCell.getCellComment();
                        if (fromCellComment != null) {
                            ClientAnchor clientAnchor = fromCellComment.getClientAnchor();
                            XSSFClientAnchor xssfClientAnchor = new XSSFClientAnchor();
                            xssfClientAnchor.setDx1(clientAnchor.getDx1());
                            xssfClientAnchor.setDx2(clientAnchor.getDx2());
                            xssfClientAnchor.setDy1(clientAnchor.getDy1());
                            xssfClientAnchor.setDy2(clientAnchor.getDy2());
                            xssfClientAnchor.setCol1(clientAnchor.getCol1() + colOffset);
                            xssfClientAnchor.setCol2(clientAnchor.getCol2() + colOffset);
                            xssfClientAnchor.setRow1(clientAnchor.getRow1() + rowOffset);
                            xssfClientAnchor.setRow2(clientAnchor.getRow2() + rowOffset);
                            RichTextString text = fromCellComment.getString();
                            Comment cellComment = drawingPatriarch.createCellComment((ClientAnchor)xssfClientAnchor);
                            cellComment.setString(text);
                            cell.setCellComment(cellComment);
                        }
                        if ((columnOutlineLevel = fromSheet.getColumnOutlineLevel(colIndex)) <= 0 || colGroupLevelMap == null) continue;
                        Set integers1 = colGroupLevelMap.computeIfAbsent(columnOutlineLevel, t -> new LinkedHashSet(16));
                        integers1.add(colIndex);
                    }
                    if (rowIndex > 98 && needFlush) {
                        ArrayList value2;
                        if (colGroupLevelMap != null && colGroupLevelMap.size() > 0) {
                            for (Map.Entry entry : colGroupLevelMap.entrySet()) {
                                value2 = new ArrayList((Collection)entry.getValue());
                                sheet.groupColumn(((Integer)value2.get(0)).intValue(), ((Integer)value2.get(value2.size() - 1)).intValue());
                                sheet.setColumnGroupCollapsed(((Integer)value2.get(0)).intValue(), true);
                            }
                            colGroupLevelMap = null;
                        }
                        if (rowGroupLevelMap != null && rowGroupLevelMap.size() > 0) {
                            for (Map.Entry entry : rowGroupLevelMap.entrySet()) {
                                value2 = new ArrayList((Collection)entry.getValue());
                                sheet.groupRow(((Integer)value2.get(0)).intValue(), ((Integer)value2.get(value2.size() - 1)).intValue());
                                sheet.setRowGroupCollapsed(((Integer)value2.get(0)).intValue(), true);
                            }
                            rowGroupLevelMap = null;
                        }
                    }
                    if (!needFlush || rowIndex <= Math.min(lastRowNum, 98)) continue;
                    try {
                        sheet.flushRows();
                    }
                    catch (IOException iOException) {}
                }
                if (colGroupLevelMap != null && colGroupLevelMap.size() > 0) {
                    for (Map.Entry entry : colGroupLevelMap.entrySet()) {
                        value = new ArrayList((Collection)entry.getValue());
                        sheet.groupColumn(((Integer)value.get(0)).intValue(), ((Integer)value.get(value.size() - 1)).intValue());
                        sheet.setColumnGroupCollapsed(((Integer)value.get(0)).intValue(), true);
                    }
                }
                if (rowGroupLevelMap == null || rowGroupLevelMap.size() <= 0) continue;
                for (Map.Entry entry : rowGroupLevelMap.entrySet()) {
                    value = new ArrayList((Collection)entry.getValue());
                    sheet.groupRow(((Integer)value.get(0)).intValue(), ((Integer)value.get(value.size() - 1)).intValue());
                    sheet.setRowGroupCollapsed(((Integer)value.get(0)).intValue(), true);
                }
            }
            catch (KDEpmExportCancelException e) {
                log.error((Throwable)e);
                int sheetIndex = baseWorkBook.getSheetIndex(fromSheet.getSheetName());
                baseWorkBook.removeSheetAt(sheetIndex);
                throw e;
            }
        }
    }

    private static void copyDataValid(SXSSFSheet sheet, Sheet fromSheet) {
        try {
            List dataValidations = fromSheet.getDataValidations();
            if (CollectionUtils.isNotEmpty((Collection)dataValidations)) {
                DataValidationHelper dataValidationHelper = sheet.getDataValidationHelper();
                for (DataValidation dataValidation : dataValidations) {
                    DataValidationConstraint validationConstraint = dataValidation.getValidationConstraint();
                    String[] explicitListValues = validationConstraint.getExplicitListValues();
                    DataValidationConstraint explicitListConstraint = null;
                    if (explicitListValues != null && explicitListValues.length > 0) {
                        explicitListConstraint = dataValidationHelper.createExplicitListConstraint(explicitListValues);
                    } else {
                        String formula1 = validationConstraint.getFormula1();
                        explicitListConstraint = dataValidationHelper.createFormulaListConstraint(formula1);
                    }
                    if (explicitListConstraint == null) continue;
                    DataValidation validation = dataValidationHelper.createValidation(explicitListConstraint, dataValidation.getRegions().copy());
                    sheet.addValidationData(validation);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("copy dataValidations has exception.");
        }
    }

    private static void copySheetPicture(Workbook baseWorkBook, SXSSFSheet sheet, Sheet fromSheet, SXSSFDrawing drawingPatriarch) {
        try {
            Drawing fromSheetDrawingPatriarch = fromSheet.getDrawingPatriarch();
            if (fromSheetDrawingPatriarch != null) {
                for (Shape shape : fromSheetDrawingPatriarch) {
                    ClientAnchor anchor = (ClientAnchor)shape.getAnchor();
                    if (!(shape instanceof XSSFPicture)) continue;
                    XSSFPicture xssfPicture = (XSSFPicture)shape;
                    XSSFPictureData pictureData = xssfPicture.getPictureData();
                    int pictureType = xssfPicture.getPictureData().getPictureType();
                    int pictureIndex = baseWorkBook.addPicture(pictureData.getData(), pictureType);
                    SXSSFPicture picture = drawingPatriarch.createPicture(anchor, pictureIndex);
                    picture.setNoFill(xssfPicture.isNoFill());
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("copy fromSheetDrawingPatriarch has exception.");
        }
    }

    private static void setDefaultSheetStyle(SXSSFSheet sheet, Sheet fromSheet) {
        int defaultColumnWidth = fromSheet.getDefaultColumnWidth();
        short defaultRowHeight = fromSheet.getDefaultRowHeight();
        float defaultRowHeightInPoints = fromSheet.getDefaultRowHeightInPoints();
        sheet.setDefaultColumnWidth(defaultColumnWidth);
        sheet.setDefaultRowHeight(defaultRowHeight);
        sheet.setDefaultRowHeightInPoints(defaultRowHeightInPoints);
    }

    private static void copyMergedRegions(SXSSFSheet sheet, Sheet fromSheet) {
        List mergedRegions = fromSheet.getMergedRegions();
        for (CellRangeAddress mergedRegion : mergedRegions) {
            try {
                sheet.addMergedRegion(mergedRegion);
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
        }
    }

    private static void copyPaneInformation(SXSSFSheet sheet, Sheet fromSheet) {
        try {
            boolean freezePane;
            PaneInformation paneInformation = fromSheet.getPaneInformation();
            if (paneInformation != null && (freezePane = paneInformation.isFreezePane())) {
                short horizontalSplitPosition = paneInformation.getHorizontalSplitPosition();
                short verticalSplitPosition = paneInformation.getVerticalSplitPosition();
                short horizontalSplitTopRow = paneInformation.getHorizontalSplitTopRow();
                short verticalSplitLeftColumn = paneInformation.getVerticalSplitLeftColumn();
                sheet.createFreezePane((int)verticalSplitPosition, (int)horizontalSplitPosition, (int)verticalSplitLeftColumn, (int)horizontalSplitTopRow);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error("copy paneInformation has exception.");
        }
    }
}

