/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.report.excel.helper.TemplateHelper;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportExportHelper {
    private static final ReportExportHelper INSTANCE = new ReportExportHelper();
    public static String[] pageDimList = new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Metric.getNumber()};

    private ReportExportHelper() {
    }

    public static ReportExportHelper getInstance() {
        return INSTANCE;
    }

    public List<IPageDimensionEntry> sortPageDimList(List<IPageDimensionEntry> pageDimensionEntryList) {
        if (CollectionUtils.isEmpty(pageDimensionEntryList)) {
            return pageDimensionEntryList;
        }
        if (pageDimensionEntryList.size() == 1) {
            return pageDimensionEntryList;
        }
        ArrayList<IPageDimensionEntry> result = new ArrayList<IPageDimensionEntry>(16);
        block0: for (String s : pageDimList) {
            for (IPageDimensionEntry pageDimensionEntry : pageDimensionEntryList) {
                if (!StringUtils.equals((CharSequence)s, (CharSequence)pageDimensionEntry.getDimension().getNumber())) continue;
                result.add(pageDimensionEntry);
                pageDimensionEntryList.remove(pageDimensionEntry);
                continue block0;
            }
        }
        if (CollectionUtils.isNotEmpty(pageDimensionEntryList)) {
            result.addAll(pageDimensionEntryList);
        }
        return result;
    }

    public Map<String, String> sortPageDimMap(Map<String, String> defaultPageDimMemberMap, List<IPageDimensionEntry> pagemembentry) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        if (defaultPageDimMemberMap == null || defaultPageDimMemberMap.size() == 0) {
            return result;
        }
        if (defaultPageDimMemberMap.size() == 1) {
            return defaultPageDimMemberMap;
        }
        for (String dimNum : pageDimList) {
            String s = defaultPageDimMemberMap.get(dimNum);
            if (StringUtils.isBlank((CharSequence)s)) continue;
            result.put(dimNum, s);
            defaultPageDimMemberMap.remove(dimNum);
        }
        for (IPageDimensionEntry pageDimensionEntry : pagemembentry) {
            String dimNum = pageDimensionEntry.getDimension().getNumber();
            String s = defaultPageDimMemberMap.get(dimNum);
            if (StringUtils.isBlank((CharSequence)s)) continue;
            result.put(dimNum, s);
            defaultPageDimMemberMap.remove(dimNum);
        }
        if (defaultPageDimMemberMap.size() > 0) {
            result.putAll(defaultPageDimMemberMap);
        }
        return result;
    }

    public Map<String, Long> getDefaultDimMemberIdMap(Map<String, String> defaultDimMemberMap, IModelCacheHelper modelCacheHelper, Map<String, Long> dimemsionViews) {
        HashMap<String, Long> defaultDimMember = new HashMap<String, Long>(16);
        if (defaultDimMemberMap == null) {
            return defaultDimMember;
        }
        for (Map.Entry<String, String> entry : defaultDimMemberMap.entrySet()) {
            Long dimViewId = dimemsionViews.get(entry.getKey());
            Member member = modelCacheHelper.getMember(entry.getKey(), dimViewId, entry.getValue());
            if (member == null) continue;
            defaultDimMember.put(entry.getKey(), member.getId());
        }
        return defaultDimMember;
    }

    public Map<String, String> getDimMemberNumberMap(IFormView formView, Map<Long, Map<String, String>> allPageDimMemberMap, Map<String, Long> defaultDimensionNumberIdMap, Long modelId, Long periodId, ProcessTypeEnum processTypeEnum, Long processId, Long reportProcessId, Long templateId, Long orgId, String orgNumber, Long entityViewId, Set<String> errorInfos) {
        formView.getPageCache().put("CURRENT_PERIOD", periodId + "");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, String> dimMemberNumberMap = allPageDimMemberMap.get(reportProcessId);
        if (dimMemberNumberMap != null) {
            return dimMemberNumberMap;
        }
        dimMemberNumberMap = new HashMap<String, String>(16);
        ITemplateModel templateModel = this.getTemplateModel(templateId);
        if (templateModel == null || CollectionUtils.isEmpty((Collection)templateModel.getPagemembentry())) {
            return dimMemberNumberMap;
        }
        Map dimemsionViews = templateModel.getDimensionView();
        dimemsionViews.put(SysDimensionEnum.Entity.getNumber(), entityViewId);
        Long datasetID = templateModel.getTemplateBaseInfo().getDatasetID();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(datasetID);
        List pagemembentry = templateModel.getPagemembentry();
        Map<String, List<Member>> getDimSelectMembersMap = this.getDimSelectMembersMap(formView, modelId, processTypeEnum, processId, modelCacheHelper, templateModel, IDUtils.toLong((Object)templateId), (Long)dimemsionViews.get(SysDimensionEnum.Entity.getNumber()));
        formView.getPageCache().put("templateId", String.valueOf(templateId));
        Map dimRelationMap = ReportHelper.getDimRelationMap((IFormView)formView, (Long)reportProcessId);
        List dimRelationList = ReportHelper.getDimRelation((IFormView)formView, (Long)reportProcessId);
        HashSet<String> notInTemplateScopeAssignDimNum = new HashSet<String>(16);
        HashSet<String> notPermAssignDimNum = new HashSet<String>(16);
        HashSet<String> notInRelationAssignDimNum = new HashSet<String>(16);
        boolean pagedimInRelation = false;
        if (!dimRelationMap.isEmpty()) {
            for (IPageDimensionEntry dimensionEntry : pagemembentry) {
                IDimension dimension = dimensionEntry.getDimension();
                String number = dimension.getNumber();
                if (!dimRelationMap.containsKey(number)) continue;
                pagedimInRelation = true;
                break;
            }
        }
        Map dimensionMap = modelCacheHelper.getDimensionMap(datasetID);
        for (IPageDimensionEntry dimensionEntry : pagemembentry) {
            String finalmember;
            Set permMemIds;
            IDimension dimension = dimensionEntry.getDimension();
            String number = dimension.getNumber();
            Dimension dimension1 = (Dimension)dimensionMap.get(number);
            Long viewId = (Long)dimemsionViews.get(number);
            String dimName = dimension1 == null ? number : dimension1.getName();
            List<Member> dimSelectMembers = getDimSelectMembersMap.get(number);
            if (SysDimensionEnum.Entity.getNumber().equals(number)) {
                permMemIds = DimMembPermHelper.getPermMembIds((String)number, (Long)modelId, (Long)bizModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                if (permMemIds != null && !permMemIds.contains(orgId)) {
                    notPermAssignDimNum.add(dimName);
                    continue;
                }
                dimMemberNumberMap.put(number, orgNumber);
                continue;
            }
            if (CollectionUtils.isEmpty(dimSelectMembers)) {
                notInTemplateScopeAssignDimNum.add(dimName);
                continue;
            }
            if (SysDimensionEnum.Version.getNumber().equals(number) || SysDimensionEnum.DataType.getNumber().equals(number)) {
                permMemIds = DimMembPermHelper.getPermMembIds((String)number, (Long)modelId, (Long)bizModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                if (permMemIds != null && !permMemIds.contains(defaultDimensionNumberIdMap.get(number))) {
                    notPermAssignDimNum.add(number);
                    continue;
                }
                if (dimSelectMembers.stream().noneMatch(t -> IDUtils.equals((Object)t.getId(), defaultDimensionNumberIdMap.get(number)))) {
                    notInTemplateScopeAssignDimNum.add(dimName);
                    continue;
                }
            }
            Member defaultMember = null;
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(number)) {
                Long period = defaultDimensionNumberIdMap.get(number);
                boolean match = dimSelectMembers.stream().anyMatch(member -> member.getId().equals(period));
                if (match) {
                    defaultMember = modelCacheHelper.getMember(number, viewId, defaultDimensionNumberIdMap.get(number));
                }
            } else {
                defaultMember = modelCacheHelper.getMember(number, viewId, defaultDimensionNumberIdMap.get(number));
            }
            String string = finalmember = defaultMember == null ? null : defaultMember.getNumber();
            if (pagedimInRelation && dimRelationMap.containsKey(number)) {
                List members1;
                Set<Member> mergeMembers;
                List mergeRelationMemberIds;
                HashSet<Member> members = new HashSet<Member>(dimSelectMembers);
                boolean hasNotLeaf = false;
                for (Map.Entry<String, String> entry : dimMemberNumberMap.entrySet()) {
                    Member currentMember;
                    String dim = entry.getKey();
                    if (!dimRelationMap.containsKey(dim) || (currentMember = modelCacheHelper.getMember(dim, (Long)dimemsionViews.get(dim), entry.getValue())) == null || currentMember.isLeaf()) continue;
                    hasNotLeaf = true;
                    break;
                }
                if (!hasNotLeaf && !(mergeRelationMemberIds = (mergeMembers = this.mergeRelation(modelCacheHelper, bizModelId, number, periodId, members, dimMemberNumberMap, dimRelationMap, dimRelationList)).stream().map(BaseCache::getId).collect(Collectors.toList())).contains(defaultDimensionNumberIdMap.get(number))) {
                    if (SysDimensionEnum.Version.getNumber().equals(number) || SysDimensionEnum.DataType.getNumber().equals(number)) {
                        notInRelationAssignDimNum.add(dimName);
                        continue;
                    }
                    List members12 = mergeMembers.stream().filter(Member::isLeaf).sorted(Comparator.comparing(Member::disableToInt).thenComparing(BaseCache::getSeq)).collect(Collectors.toList());
                    if (!members12.isEmpty()) {
                        finalmember = ((Member)members12.get(0)).getNumber();
                    }
                }
                if (finalmember == null && (defaultMember == null || defaultMember.isLeaf()) && !(members1 = members.stream().filter(e -> !e.isLeaf()).sorted(Comparator.comparing(Member::disableToInt).thenComparing(BaseCache::getSeq)).collect(Collectors.toList())).isEmpty()) {
                    finalmember = ((Member)members1.get(0)).getNumber();
                }
            }
            if (finalmember == null) {
                Member member1 = dimSelectMembers.get(0);
                finalmember = member1 != null ? member1.getNumber() : null;
            }
            dimMemberNumberMap.put(number, finalmember);
        }
        String errorInfo = null;
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(notPermAssignDimNum)) {
            errorInfo = ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u65e0\u201c%1\u201d\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"ReportExportHelper_01", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", notPermAssignDimNum)});
        }
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(notInTemplateScopeAssignDimNum)) {
            errorInfo = ResManager.loadResFormat((String)"\u4e0b\u8fbe\u7684\u201c%1\u201d\u5728\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"ReportExportHelper_02", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", notInTemplateScopeAssignDimNum)});
        }
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(notInRelationAssignDimNum)) {
            errorInfo = ResManager.loadResFormat((String)"\u4e0b\u8fbe\u7684\u201c%1\u201d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb\u51b2\u7a81\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"ReportExportHelper_03", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", notInRelationAssignDimNum)});
        }
        if (errorInfos == null) {
            if (errorInfo != null) {
                throw new KDBizException(errorInfo);
            }
        } else if (errorInfo != null) {
            errorInfos.add(errorInfo);
        }
        return dimMemberNumberMap;
    }

    public Map<String, List<Member>> getDimSelectMembersMap(IFormView formView, Long modelId, ProcessTypeEnum processTypeEnum, Long processId, IModelCacheHelper modelCacheHelper, ITemplateModel templateModel, Long templateId, Long entityViewId) {
        HashMap<String, List<Long>> dimSelectMembers;
        if (templateModel == null || CollectionUtils.isEmpty((Collection)templateModel.getPagemembentry())) {
            return new HashMap<String, List<Member>>(0);
        }
        Map dimemsionViews = templateModel.getDimemsionViews();
        dimemsionViews.put(SysDimensionEnum.Entity.getNumber(), entityViewId);
        Map<Long, HashMap<String, List<Long>>> allDimSelectMemberIds = new HashMap(16);
        String dimSelectMemberIdsCache = formView.getPageCache().get("allDimSelectMemberIds");
        if (dimSelectMemberIdsCache != null && (dimSelectMembers = (Map)(allDimSelectMemberIds = (Map)SerializationUtils.deSerializeFromBase64((String)dimSelectMemberIdsCache)).get(templateId)) != null) {
            return this.switchMemberMap(modelCacheHelper, dimSelectMembers, dimemsionViews);
        }
        dimSelectMembers = new HashMap(16);
        Long datasetID = templateModel.getTemplateBaseInfo().getDatasetID();
        Long bizModel = modelCacheHelper.getBusModelByDataSet(datasetID);
        List pageDimensionEntryList = templateModel.getPagemembentry();
        Map varValus = ReportVarUtil.getVarValues((String)processTypeEnum.getNumber(), (Long)templateModel.getModelId(), (Long)processId, (String)templateModel.getTemplateBaseInfo().getVarBase());
        for (IPageDimensionEntry pageDimensionEntry : pageDimensionEntryList) {
            IDimension dimension = pageDimensionEntry.getDimension();
            List members = pageDimensionEntry.getMembers();
            String dimNumber = dimension.getNumber();
            Long viewId = (Long)dimemsionViews.get(dimNumber);
            Set permMemIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModel, (Long)viewId, (boolean)true);
            ArrayList<Long> allSelectMembers = new ArrayList<Long>(16);
            for (IDimensionMember dimensionMember : members) {
                List singleScopeMembers;
                if (TemplateVarUtil.checkIsVar((IDimensionMember)dimensionMember, (String)dimNumber).booleanValue()) {
                    dimensionMember.setNumber(ReportVarUtil.getRealDimByVar((Long)modelId, (String)dimensionMember.getNumber(), (String)dimNumber, (Map)varValus));
                }
                if ((singleScopeMembers = modelCacheHelper.getMember(dimNumber, viewId, dimensionMember.getNumber(), dimensionMember.getScope())) == null || singleScopeMembers.size() <= 0) continue;
                for (Member singleScopeMember : singleScopeMembers) {
                    if (permMemIds != null && !permMemIds.contains(singleScopeMember.getId())) continue;
                    allSelectMembers.add(singleScopeMember.getId());
                }
            }
            dimSelectMembers.put(dimNumber, allSelectMembers);
        }
        allDimSelectMemberIds.put(templateId, dimSelectMembers);
        formView.getPageCache().put("allDimSelectMemberIds", SerializationUtils.serializeToBase64(allDimSelectMemberIds));
        return this.switchMemberMap(modelCacheHelper, dimSelectMembers, dimemsionViews);
    }

    private Map<String, List<Member>> switchMemberMap(IModelCacheHelper modelCacheHelper, Map<String, List<Long>> dimSelectMemberIds, Map<String, Long> dimemsionViews) {
        HashMap<String, List<Member>> getDimSelectMembersMap = new HashMap<String, List<Member>>(16);
        for (Map.Entry<String, List<Long>> entry : dimSelectMemberIds.entrySet()) {
            Dimension dimension = modelCacheHelper.getDimension(entry.getKey());
            Long viewId = dimemsionViews.get(entry.getKey());
            List<Long> memberIds = entry.getValue();
            if (dimension == null || !CollectionUtils.isNotEmpty(memberIds)) continue;
            List members = dimension.getMembers(memberIds, viewId);
            getDimSelectMembersMap.put(entry.getKey(), members);
        }
        return getDimSelectMembersMap;
    }

    public ITemplateModel getTemplateModel(Long templateId) {
        DynamicObject templateDynamicObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_templateentity").getDynamicObjectType());
        return this.getTemplateModel(templateDynamicObject);
    }

    private ITemplateModel getTemplateModel(DynamicObject templateDynamicObject) {
        return TemplateHelper.parseTemplateModel((DynamicObject)templateDynamicObject);
    }

    public Set<Member> mergeRelation(IModelCacheHelper modelCache, Long bizModelId, String dimNumber, Long periodId, Set<Member> members, Map<String, String> dimMemberNumberMap, Map<String, Set<String>> dimRelationMap, List<Long> dimRelationList) {
        if (!dimRelationMap.isEmpty() && dimRelationMap.containsKey(dimNumber)) {
            Set dimRelMemSet = DimensionRelationUtils.getRelationMemNum((IModelCacheHelper)modelCache, (Long)bizModelId, (String)dimNumber, (Long)periodId, dimMemberNumberMap, dimRelationMap, dimRelationList);
            members = CollectionUtils.isNotEmpty((Collection)dimRelMemSet) ? members.stream().filter(e -> dimRelMemSet.contains(e.getNumber()) || !e.isLeaf()).collect(Collectors.toSet()) : members.stream().filter(e -> !e.isLeaf()).collect(Collectors.toSet());
        }
        return members;
    }
}

