/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;
import org.apache.commons.collections4.CollectionUtils;

public class ReportExportJobCacheHelper {
    public static String getReportExportJobInfoCacheKey(Long modelId) {
        return "epm-eb-reportexport-" + RequestContext.get().getCurrUserId() + "#" + modelId;
    }

    public static String getReportExportJobInfoCacheKey(Long modelId, Long exportLogCreatorId) {
        if (IDUtils.isEmptyLong((Long)exportLogCreatorId).booleanValue()) {
            return ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(modelId);
        }
        return "epm-eb-reportexport-" + exportLogCreatorId + "#" + modelId;
    }

    public static Set<Integer> convertToHashCodeSet(List<ReportExportDataRequest> reportExportDataRequests) {
        HashSet<Integer> result = new HashSet<Integer>(16);
        for (ReportExportDataRequest reportExportDataRequest : reportExportDataRequests) {
            result.add(reportExportDataRequest.hashCode());
        }
        return result;
    }

    public static void clear(String cacheKey) {
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").remove(cacheKey);
    }

    public static void remove(String cacheKey, ReportExportTaskRequest reportExportTaskRequest) {
        if (reportExportTaskRequest == null || CollectionUtils.isEmpty((Collection)reportExportTaskRequest.getExportDataRequests())) {
            return;
        }
        String id = reportExportTaskRequest.getExportLogId() + "";
        List<Map<String, List<Integer>>> jobInfoHashCodeList = ReportExportJobCacheHelper.getJobInfoHashCodeList(cacheKey);
        if (CollectionUtils.isNotEmpty(jobInfoHashCodeList)) {
            jobInfoHashCodeList.removeIf(t -> t.get(id) != null);
        }
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").put(cacheKey, (Object)SerializationUtils.toJsonString(jobInfoHashCodeList));
    }

    public static void cache(String cacheKey, ReportExportTaskRequest reportExportTaskRequest) {
        HashMap<String, Set<Integer>> cacheInfo = new HashMap<String, Set<Integer>>(16);
        String exportReportJobInfoListStr = (String)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").get(cacheKey);
        List reportExportDataRequests = reportExportTaskRequest.getExportDataRequests();
        Set<Integer> result = ReportExportJobCacheHelper.convertToHashCodeSet(reportExportDataRequests);
        List<HashMap<String, Set<Integer>>> cacheList = new ArrayList(16);
        if (StringUtils.isNotEmpty((String)exportReportJobInfoListStr)) {
            cacheList = (List)SerializationUtils.fromJsonString((String)exportReportJobInfoListStr, List.class);
        }
        cacheInfo.put(reportExportTaskRequest.getExportLogId() + "", result);
        cacheList.add(cacheInfo);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").put(cacheKey, (Object)SerializationUtils.toJsonString(cacheList));
    }

    public static List<Map<String, List<Integer>>> getJobInfoHashCodeList(String cacheKey) {
        String exportReportJobInfoListStr = (String)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("epm").get(cacheKey);
        if (StringUtils.isEmpty((String)exportReportJobInfoListStr)) {
            return new ArrayList<Map<String, List<Integer>>>(16);
        }
        return SerializationUtils.fromJsonStringToList((String)exportReportJobInfoListStr, Map.class);
    }
}

