/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.excel.mq.consumer;

import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.formplugin.report.excel.command.POIExportCommand;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportJobCacheHelper;
import kd.epm.eb.formplugin.report.excel.service.ExportLogService;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;

public class ReportExportConsumer
implements Runnable {
    private static final Log log = LogFactory.getLog(ReportExportConsumer.class);
    private ReportExportTaskRequest reportExportTaskRequest = null;

    public ReportExportTaskRequest getReportExportTaskRequest() {
        return this.reportExportTaskRequest;
    }

    public ReportExportConsumer(ReportExportTaskRequest reportExportTaskRequest) {
        if (reportExportTaskRequest == null) {
            return;
        }
        this.reportExportTaskRequest = reportExportTaskRequest;
        if (CollectionUtils.isNotEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
            ReportExportJobCacheHelper.cache(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
        }
    }

    @Override
    public void run() {
        this.doExport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport() {
        if (this.reportExportTaskRequest == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.reportExportTaskRequest.getExportDataRequests())) {
            return;
        }
        try {
            log.info("reportExport:traceId:" + RequestContext.get().getTraceId());
            log.info("reportExport:tenantId:" + RequestContext.get().getTenantId());
            log.info("reportExport:userName:" + RequestContext.get().getUserName());
            POIExportCommand poiExportCommand = new POIExportCommand(this.reportExportTaskRequest);
            Future submit = null;
            try {
                submit = EpmThreadPools.exportConsumerExecuteThreadPool.submit((Runnable)new ExportRunnable(poiExportCommand));
                submit.get(this.reportExportTaskRequest.getExportTimeout(), TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                submit.cancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"POIExportCommand_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.info("ReportExportConsumer reportExportTaskRequest:" + SerializationUtils.toJsonString((Object)this.reportExportTaskRequest));
            log.error(e.getMessage(), (Throwable)e);
            String errMsg = e.getCause() instanceof KDBizException ? e.getCause().getMessage() : e.getMessage();
            String exceptionInfo = ResManager.loadResFormat((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff1a%1\u3002", (String)"POIExportCommand_02", (String)"epm-eb-formplugin", (Object[])new Object[]{errMsg + ", " + RequestContext.get().getTraceId()});
            log.info("--export consumer doExport update failed");
            ExportLogService.getInstance().updateExportFileStatus(this.reportExportTaskRequest.getExportLogId() + "", null, ExportFileStatusEnum.EXPORT_FAIL.getIndex(), exceptionInfo);
        }
        finally {
            ReportExportJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportExportTaskRequest.getModelId()), this.reportExportTaskRequest);
        }
    }

    static class ExportRunnable
    implements Runnable {
        private final POIExportCommand poiExportCommand;

        public ExportRunnable(POIExportCommand poiExportCommand) {
            this.poiExportCommand = poiExportCommand;
        }

        @Override
        public void run() {
            this.poiExportCommand.execute();
        }
    }
}

