/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.mob;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.formplugin.report.mob.MobReportDisplayConfig;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.jetbrains.annotations.NotNull;

public class MobReportHelper {
    public static final String HEADERCELL_BACKCOLOR = "#E6E8EE";

    public static IEBook configToSpreadBook(MobReportDisplayConfig mobReportDisplayConfig, IModelCacheHelper modelCacheHelper, Long businessModel) {
        if (mobReportDisplayConfig != null && mobReportDisplayConfig.getDimensions() != null) {
            int i;
            EBook ebook = new EBook(new String[]{"Sheet1"});
            ISheet sheet = ebook.getSheet(0);
            HashMap sheetDefaults = Maps.newHashMapWithExpectedSize((int)1);
            sheetDefaults.put("colWidth", "100");
            sheet.setSheetDefaults((Map)sheetDefaults);
            StyleCell styleCell = null;
            sheet.setStyleCell(true);
            styleCell = (StyleCell)sheet.getECell(0, 0);
            String rowName = ResManager.loadKDString((String)"\u884c\u540d\u79f0", (String)"MobReportHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String colName = ResManager.loadKDString((String)"\u5217\u540d\u79f0", (String)"MobReportHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            styleCell.setValue((Object)(rowName + " \\ " + colName));
            styleCell.setLocked(true);
            styleCell.setBackColor(HEADERCELL_BACKCOLOR);
            styleCell.setUserObject("dimNumbers", mobReportDisplayConfig.getDimensions());
            boolean row = true;
            boolean col = true;
            int headerRowIndex = 0;
            int headerColIndex = 0;
            if (mobReportDisplayConfig.getRowNames() != null) {
                i = 1;
                for (String name : mobReportDisplayConfig.getRowNames()) {
                    styleCell = (StyleCell)sheet.getECell(i++, headerColIndex);
                    styleCell.setValue((Object)name);
                    styleCell.setBackColor(HEADERCELL_BACKCOLOR);
                }
            }
            if (mobReportDisplayConfig.getColNames() != null) {
                i = 1;
                for (String name : mobReportDisplayConfig.getColNames()) {
                    styleCell = (StyleCell)sheet.getECell(headerRowIndex, i++);
                    styleCell.setValue((Object)name);
                    styleCell.setBackColor(HEADERCELL_BACKCOLOR);
                }
            }
            String[] dimNumbers = mobReportDisplayConfig.getDimensions().toArray(new String[0]);
            if (mobReportDisplayConfig.getMembers() != null) {
                for (int r = 0; r < mobReportDisplayConfig.getMembers().size(); ++r) {
                    List<String[]> rowMems = mobReportDisplayConfig.getMembers().get(r);
                    for (int c = 0; c < rowMems.size(); ++c) {
                        Map<String, String> dimMemNumbers = MobReportHelper.toMap(dimNumbers, rowMems.get(c));
                        styleCell = (StyleCell)sheet.getECell(r + 1, c + 1);
                        styleCell.setUserObject("memNumbers", dimMemNumbers);
                        styleCell.setValue((Object)MobReportHelper.getMemberDisplay(modelCacheHelper, dimNumbers, dimMemNumbers, businessModel));
                        styleCell.setLocked(true);
                    }
                }
            } else {
                styleCell = (StyleCell)sheet.getECell(0, 1);
                styleCell.setBackColor(HEADERCELL_BACKCOLOR);
                styleCell = (StyleCell)sheet.getECell(1, 0);
                styleCell.setBackColor(HEADERCELL_BACKCOLOR);
            }
            return ebook;
        }
        return null;
    }

    public static MobReportDisplayConfig spreadBookToConfig(IEBook ebook, List<String> rowColDims) {
        if (ebook != null) {
            ECell eCell;
            int i;
            MobReportDisplayConfig mobReportDisplayConfig = new MobReportDisplayConfig();
            ISheet sheet = ebook.getSheet(0);
            MobReportHelper.clearEmptyRowCol(sheet);
            int maxRowCount = sheet.getMaxRowCount();
            int maxColCount = sheet.getMaxColumnCount();
            int headerRowIndex = 0;
            int headerColIndex = 0;
            ArrayList<String> rowNames = new ArrayList<String>(16);
            ArrayList<String> colNames = new ArrayList<String>(16);
            List<String> rowColDimNumbers = rowColDims;
            ArrayList<List<String[]>> rowColMemNumbers = new ArrayList<List<String[]>>(16);
            mobReportDisplayConfig.setRowNames(rowNames);
            mobReportDisplayConfig.setColNames(colNames);
            mobReportDisplayConfig.setDimensions(rowColDimNumbers);
            mobReportDisplayConfig.setMembers(rowColMemNumbers);
            for (i = 1; i < maxRowCount; ++i) {
                eCell = sheet.getECell(i, headerColIndex);
                rowNames.add(String.valueOf(eCell.getValue() == null ? "" : eCell.getValue()));
            }
            for (i = 1; i < maxColCount; ++i) {
                eCell = sheet.getECell(headerRowIndex, i);
                colNames.add(eCell.getValue() == null ? "" : String.valueOf(eCell.getValue()));
            }
            for (int r = 1; r < maxRowCount; ++r) {
                ArrayList<String[]> cols = new ArrayList<String[]>(16);
                rowColMemNumbers.add(cols);
                for (int c = 1; c < maxColCount; ++c) {
                    eCell = sheet.getECell(r, c);
                    String value = (String)eCell.getValue();
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        if (value.contains("...")) {
                            cols.add(MobReportHelper.toArray(rowColDimNumbers, new HashMap<String, String>(8)));
                            continue;
                        }
                        cols.add(MobReportHelper.toArray(rowColDimNumbers, (Map)eCell.getUserObject("memNumbers")));
                        continue;
                    }
                    cols.add(MobReportHelper.toArray(rowColDimNumbers, (Map)eCell.getUserObject("memNumbers")));
                }
            }
            return mobReportDisplayConfig.getMembers().size() > 0 ? mobReportDisplayConfig : null;
        }
        return null;
    }

    public static ISheet clearEmptyRowCol(ISheet sheet) {
        List table = sheet.getTable();
        ListIterator iterator = table.listIterator(table.size());
        while (iterator.hasPrevious()) {
            boolean isRowEmpty = true;
            List previous = (List)iterator.previous();
            for (Object cell : previous) {
                if (cell == null || cell.getValue() == null) continue;
                isRowEmpty = false;
            }
            if (!isRowEmpty) continue;
            iterator.remove();
        }
        int colCount = sheet.getMaxColumnCount();
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>(8);
        for (int i = colCount - 1; i > 0; --i) {
            for (List rows : table) {
                ECell cell = (ECell)rows.get(i);
                if (cell == null || cell.getValue() == null) continue;
                map.put(i, false);
            }
        }
        for (List rows : table) {
            int index = rows.size();
            ListIterator eCellListIterator = rows.listIterator(index);
            while (eCellListIterator.hasPrevious()) {
                ECell previous = (ECell)eCellListIterator.previous();
                if (map.containsKey(--index) || index == 0) continue;
                eCellListIterator.remove();
            }
        }
        return sheet;
    }

    public static String getMemberDisplay(IModelCacheHelper modelCacheHelper, String[] orderedDimNumbers, Map<String, String> dimMemNumbers, Long businessModel) {
        if (modelCacheHelper != null && dimMemNumbers != null && orderedDimNumbers != null) {
            StringJoiner joiner = new StringJoiner(",");
            Object rowDimNumber = null;
            Object colDimNumber = null;
            for (int j = 0; j < orderedDimNumbers.length; ++j) {
                String dimNumber = orderedDimNumbers[j];
                String memNumber = dimMemNumbers.get(dimNumber);
                if (!kd.bos.util.StringUtils.isNotEmpty((String)memNumber)) continue;
                Member cacheMember = modelCacheHelper.getMemberByAnyView(businessModel, dimNumber, memNumber);
                if (cacheMember != null) {
                    joiner.add(cacheMember.getName());
                    continue;
                }
                joiner.add(memNumber);
            }
            return joiner.toString();
        }
        return null;
    }

    public static Map<String, String> toMap(String[] dimNumbers, String[] memNumbers) {
        if (dimNumbers != null && memNumbers != null && dimNumbers.length == memNumbers.length) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (int i = 0; i < dimNumbers.length; ++i) {
                map.put(dimNumbers[i], memNumbers[i]);
            }
            return map;
        }
        return null;
    }

    public static String[] toArray(List<String> dimNumbers, Map<String, String> memNumbers) {
        if (dimNumbers != null && memNumbers != null) {
            String[] mems = new String[dimNumbers.size()];
            for (int i = 0; i < dimNumbers.size(); ++i) {
                mems[i] = memNumbers.get(dimNumbers.get(i));
            }
            return mems;
        }
        return null;
    }

    public static void saveConfig(@NotNull BgTemplate bgTemplate, String mobconfig, IModelCacheHelper modelCacheHelper) {
        MobReportDisplayConfig mobReportDisplayConfig = null;
        QFilter[] qFilters = new QFilter[]{new QFilter("template", "=", (Object)bgTemplate.getId())};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mobreportconfig", (String)"number,template,mobconfig", (QFilter[])qFilters);
        if (kd.bos.util.StringUtils.isNotEmpty((String)mobconfig) && !"clear".equals(mobconfig)) {
            mobReportDisplayConfig = (MobReportDisplayConfig)SerializationUtils.fromJsonString((String)mobconfig, MobReportDisplayConfig.class);
        } else {
            DeleteServiceHelper.delete((String)"eb_mobreportconfig", (QFilter[])qFilters);
            if (dynamicObject != null) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.MobReportConfig.getType(), Collections.singletonList(dynamicObject.getLong("id"))});
            }
        }
        if (mobReportDisplayConfig != null) {
            if (dynamicObject == null) {
                dynamicObject = ORM.create().newDynamicObject("eb_mobreportconfig");
                dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            }
            dynamicObject.set("template", (Object)bgTemplate.getId());
            dynamicObject.set("number", (Object)bgTemplate.getNumber());
            dynamicObject.set("mobconfig", (Object)new String(Base64.getEncoder().encode(GZIPUtils.compress((String)mobconfig))));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            List quotes = QuoteBuilder.build((Long)bgTemplate.getModelID(), (Long)bgTemplate.getDatasetID(), mobReportDisplayConfig.retrieveQuoteMembers(), (MemberQuoteResourceEnum)MemberQuoteResourceEnum.MobReportConfig, (Long)dynamicObject.getLong("id"), (IModelCacheHelper)modelCacheHelper);
            if (quotes.size() > 0) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
        }
    }

    public static void deleteConfig(Collection<Long> templateIds) {
        QFilter[] qFilters;
        DynamicObject[] dynamicObjects;
        if (templateIds != null && templateIds.size() > 0 && (dynamicObjects = BusinessDataServiceHelper.load((String)"eb_mobreportconfig", (String)"id", (QFilter[])(qFilters = new QFilter[]{new QFilter("template", "in", templateIds)}))) != null && dynamicObjects.length > 0) {
            Set configIds = Arrays.stream(dynamicObjects).map(e -> e.getLong("id")).collect(Collectors.toSet());
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.MobReportConfig.getType(), configIds});
            DeleteServiceHelper.delete((String)"eb_mobreportconfig", (QFilter[])qFilters);
        }
    }

    public static void resolveVar(Long modelId, MobReportDisplayConfig mobReportDisplayConfig, Map<String, Map<String, String>> varValues) {
        if (mobReportDisplayConfig == null || varValues == null || mobReportDisplayConfig.getDimensions() == null || mobReportDisplayConfig.getMembers() == null) {
            return;
        }
        for (int i = 0; i < mobReportDisplayConfig.getDimensions().size(); ++i) {
            String dimNumber = mobReportDisplayConfig.getDimensions().get(i);
            if (!varValues.containsKey(dimNumber)) continue;
            for (List<String[]> col : mobReportDisplayConfig.getMembers()) {
                for (String[] mem : col) {
                    String memNumber;
                    if (mem == null || (memNumber = mem[i]) == null) continue;
                    mem[i] = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memNumber, (String)dimNumber, varValues);
                }
            }
        }
    }

    public static TreeNode buildAllTree(IModelCacheHelper modelCacheHelper, Set<Long> values, String dimnumber, Long viewId) {
        Long parentId;
        Member member;
        if (modelCacheHelper == null || values == null || values.size() == 0 || StringUtils.isEmpty((CharSequence)dimnumber)) {
            return null;
        }
        Dimension dimension = modelCacheHelper.getDimension(dimnumber);
        if (dimension == null) {
            return null;
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setText(dimension.getName());
        rootNode.setParentid("");
        rootNode.setId("0");
        rootNode.setLongNumber(dimension.getNumber());
        HashMap<Long, TreeNode> treeNodeMap = new HashMap<Long, TreeNode>(16);
        for (Long entityId : values) {
            member = modelCacheHelper.getMember(dimnumber, viewId, entityId);
            if (member == null || member.isDisable()) continue;
            parentId = member.getParentId();
            TreeNode treeNode = MobReportHelper.buildTreeNode(member);
            treeNodeMap.put(entityId, treeNode);
        }
        for (Long entityId : values) {
            member = modelCacheHelper.getMember(dimnumber, viewId, entityId);
            if (member == null || member.isDisable()) continue;
            parentId = member.getParentId();
            TreeNode parentNode = (TreeNode)treeNodeMap.get(parentId);
            TreeNode node = (TreeNode)treeNodeMap.get(entityId);
            if (parentNode == null) {
                Member orgParentMember = null;
                List parents = modelCacheHelper.getParents(viewId, member, false);
                for (Member parent : parents) {
                    if (!values.contains(parent.getId())) continue;
                    orgParentMember = parent;
                    break;
                }
                if (orgParentMember == null) {
                    rootNode.addChild(node);
                    continue;
                }
                TreeNode node1 = (TreeNode)treeNodeMap.get(orgParentMember.getId());
                if (node1 == null) {
                    rootNode.addChild(node);
                    continue;
                }
                node1.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return rootNode;
    }

    private static TreeNode buildTreeNode(Member member) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(member.getId() + "");
        treeNode.setText(member.getName());
        treeNode.setParentid(member.getParentId() + "");
        treeNode.setLongNumber(member.getLongNumber());
        treeNode.setLeaf(member.isLeaf());
        return treeNode;
    }

    public static Map<Long, Integer> getListData(Long approveBillId, Long source_id, Set<Long> tempidList, Long model, Long orgId) {
        List<Long> taskProcessIds = MobReportHelper.getTaskProcessIds(approveBillId, source_id, model);
        if (CollectionUtils.isEmpty(taskProcessIds)) {
            return null;
        }
        QFBuilder builder = new QFBuilder("task.tasklist.model", "=", (Object)model);
        builder.add("id", "in", taskProcessIds);
        builder.add("template", "in", tempidList);
        builder.add("templatetype", "=", (Object)"eb_templateentity");
        builder.add("task.tasklist.id", "=", (Object)source_id);
        builder.add("org.id", "=", (Object)orgId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)" task.tasklist.id as taskListId,task.taskseq,task.id,tempseq,template.id as tempid", (QFilter[])builder.toArray(), (String)"task.tasklist.id,org.longNumber,task.taskseq,tempseq");
        Iterator iterator = dataSet.iterator();
        ArrayList<HashMap> queryResultList = new ArrayList<HashMap>(16);
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            HashMap map = Maps.newHashMapWithExpectedSize((int)3);
            map.put("taskId", next.getLong("task.id"));
            map.put("tempid", next.getLong("tempid"));
            map.put("tempseq", next.getInteger("tempseq"));
            queryResultList.add(map);
        }
        List<Object> findTask = new ArrayList(16);
        if (!CollectionUtils.isEmpty(queryResultList)) {
            Map<Object, List<Map>> collect = queryResultList.stream().collect(Collectors.groupingBy(x -> x.get("taskId")));
            for (Map.Entry entry : collect.entrySet()) {
                Set tempid;
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue()) || tempidList.size() != entry.getValue().size() || !(tempid = entry.getValue().stream().map(x -> x.get("tempid")).collect(Collectors.toSet())).containsAll(tempidList)) continue;
                findTask = entry.getValue();
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(findTask)) {
            HashMap<Long, Integer> tempSeqMap = new HashMap<Long, Integer>(findTask.size());
            for (Map map : findTask) {
                tempSeqMap.put((Long)map.get("tempid"), (Integer)map.get("tempseq"));
            }
            return tempSeqMap;
        }
        return null;
    }

    private static List<Long> getTaskProcessIds(Long approveBillId, Long source_id, Long model) {
        QFilter qFilter;
        DynamicObject dynamicObject;
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (IDUtils.isNotNull((Long)approveBillId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_approvebill", (String)"eborgid,dim_datatype,dim_period,dim_version,orgviewid,entryentity.tempid", (QFilter[])(qFilter = new QFilter("id", "=", (Object)approveBillId)).toArray())) != null) {
            Long period = dynamicObject.getLong("dim_period.id");
            Long version = dynamicObject.getLong("dim_version.id");
            Long datatype = dynamicObject.getLong("dim_datatype.id");
            Long viewId = dynamicObject.getLong("orgviewid.id");
            HashSet tempIds = new HashSet(16);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.forEach(e -> tempIds.add(e.getLong("tempid.id")));
            HashSet entityIds = new HashSet(16);
            Long entity = dynamicObject.getLong("eborgid.id");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entity);
            List entitys = modelCacheHelper.getChildren(member, true);
            entitys.forEach(e -> entityIds.add(e.getId()));
            qFilter = new QFilter("org", "in", entityIds);
            qFilter.and("template", "in", tempIds);
            qFilter.and("task.tasklist.year", "=", (Object)period);
            qFilter.and("task.tasklist.version", "=", (Object)version);
            qFilter.and("task.tasklist.datatype", "=", (Object)datatype);
            qFilter.and("task.tasklist", "=", (Object)source_id);
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id", (QFilter[])qFilter.toArray());
            ids.forEach(e -> result.add(e.getLong("id")));
        }
        return result;
    }

    public static Set<Long> getHasMobConfigProcess(Set<Long> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return null;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_mobreportconfig", (String)"template,mobconfig", (QFilter[])new QFilter[]{new QFilter("template", "in", templateIds)});
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return null;
        }
        Set<Long> collect = dynamicObjects.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getString("mobconfig"))).map(x -> x.getLong("template")).collect(Collectors.toSet());
        return collect;
    }
}

