/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.mob;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.report.mob.MobReportHelper;

public class MobReportListPlugin
extends AbstractMobFormPlugin
implements BeforeBindDataListener,
CreateListDataProviderListener {
    public static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        BillList billList;
        Label infobtn;
        super.registerListener(e);
        this.addClickListeners(new String[]{"cardflexpanelap"});
        Label approveinfolab = (Label)this.getControl("approveinfolab");
        if (approveinfolab != null) {
            approveinfolab.addClickListener((ClickListener)this);
        }
        if ((infobtn = (Label)this.getControl("infobtn")) != null) {
            infobtn.addClickListener((ClickListener)this);
        }
        if ((billList = (BillList)this.getView().getControl("billlistap")) != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
        }
    }

    private QFilter getqFilter() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        long id = dataEntity.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return qFilter;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        if (dataEntity != null) {
            Control approveinfolab;
            String approveinfo;
            Control orglab;
            Control createrlab = this.getControl("createrlab");
            if (createrlab != null) {
                ((Label)createrlab).setText(ResManager.loadResFormat((String)"\u521b\u5efa\u4eba\uff1a%1", (String)"MobReportListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{((DynamicObject)model.getValue("createrid")).getString("name")}));
            }
            if ((orglab = this.getControl("orglab")) != null) {
                ((Label)this.getControl("orglab")).setText(ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1", (String)"MobReportListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{((DynamicObject)model.getValue("eborgid")).getString("name")}));
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createdate = format.format(dataEntity.getDate("createdate"));
            Control createtimelab = this.getControl("createtimelab");
            if (createtimelab != null) {
                ((Label)createtimelab).setText(ResManager.loadResFormat((String)"\u521b\u5efa\u65e5\u671f\uff1a%1\u3002", (String)"MobReportListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{createdate}));
            }
            if (StringUtils.isNotEmpty((String)(approveinfo = dataEntity.getString("approveinfo"))) && (approveinfolab = this.getControl("approveinfolab")) != null) {
                ((Label)approveinfolab).setText(ResManager.loadResFormat((String)"\u5ba1\u6279\u8bf4\u660e\uff1a%1\u3002", (String)"MobReportListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{approveinfo}));
            }
            this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)approveinfo)), new String[]{"infobtn"});
            this.setFilter();
        }
    }

    private Map<String, String> getTemplateName(Object approveId, Object entryid) {
        QFilter qFilter = new QFilter("modelid", "=", (Object)this.getModelId());
        if (entryid == null) {
            Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
            if (pkid != null) {
                qFilter.and(new QFilter(ENTRYENTITY, "=", (Object)IDUtils.toLong((Object)pkid)));
            }
            Object approveStr = this.getView().getFormShowParameter().getCustomParam("approveId");
            if (pkid != null) {
                qFilter.and(new QFilter("id", "=", (Object)IDUtils.toLong((Object)approveStr)));
            }
        } else {
            qFilter.and(new QFilter("id", "=", approveId));
            qFilter.and(new QFilter(ENTRYENTITY, "=", entryid));
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"entryentity,entryentity.tempid.name,entryentity.tempid.dataset,entryentity.tempid.dataset.businessmodel,dim_period", (QFilter[])qFilter.toArray());
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        if (dynamicObject != null) {
            resultMap.put("templatename", dynamicObject.getString("entryentity.tempid.name"));
            resultMap.put("businessmodel", dynamicObject.getString("entryentity.tempid.dataset.businessmodel"));
            resultMap.put("dataset", dynamicObject.getString("entryentity.tempid.dataset"));
            resultMap.put("period", dynamicObject.getString("dim_period"));
        }
        return resultMap;
    }

    private long getModelId() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        return dataEntity.getLong("modelid.id");
    }

    public void click(EventObject evt) {
        Object[] entryPrimaryKeyValues;
        BillList billList;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("approveinfolab".equals(key) || "infobtn".equals(key)) {
            String approveinfo;
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            if (dataEntity != null && StringUtils.isNotEmpty((String)(approveinfo = dataEntity.getString("approveinfo")))) {
                this.showCustomConfirm(approveinfo);
            }
        } else if ("cardflexpanelap".equals(key) && (billList = (BillList)this.getView().getControl("billlistap")) != null && !billList.getSelectedRows().isEmpty() && (entryPrimaryKeyValues = billList.getSelectedRows().getEntryPrimaryKeyValues()).length > 0) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("eb_mobreportdetail");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            Object entryPrimaryKeyValue = entryPrimaryKeyValues[0];
            if (entryPrimaryKeyValue != null) {
                showParameter.setCustomParam("pkid", entryPrimaryKeyValue);
            } else {
                Object pkid = this.getView().getFormShowParameter().getCustomParam("pkid");
                if (pkid != null) {
                    showParameter.setCustomParam("pkid", (Object)IDUtils.toLong((Object)pkid));
                }
            }
            showParameter.setCustomParam("sourceid", (Object)this.getModel().getDataEntity().getString("source_id"));
            showParameter.setCustomParam("datatype", (Object)this.getModel().getDataEntity().getString("dim_datatype.id"));
            showParameter.setCustomParam("version", (Object)this.getModel().getDataEntity().getString("dim_version.id"));
            Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
            Map<String, String> templateName = this.getTemplateName(primaryKeyValues[0], entryPrimaryKeyValues[0]);
            showParameter.setCaption(templateName.getOrDefault("templatename", ""));
            showParameter.setCustomParam("dataset", (Object)templateName.getOrDefault("dataset", "0"));
            showParameter.setCustomParam("businessmodel", (Object)templateName.getOrDefault("businessmodel", "0"));
            showParameter.setCustomParam("approveOrgId", (Object)((DynamicObject)this.getModel().getValue("eborgid")).getLong("id"));
            Object orgviewid = this.getModel().getValue("orgviewid");
            if (orgviewid != null) {
                showParameter.setCustomParam("orgViewId", (Object)((DynamicObject)orgviewid).getLong("id"));
            }
            showParameter.setCustomParam("rptProcessType", (Object)this.getModel().getDataEntity().getString("rptprocesstype"));
            showParameter.setCustomParam("period", (Object)templateName.getOrDefault("period", "0"));
            showParameter.setCustomParam("approveBillId", this.getModel().getValue("id"));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "viewdetail");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showCustomConfirm(String approveInfo) {
        String title = ResManager.loadKDString((String)"\u5ba1\u6279\u8bf4\u660e", (String)"MobReportListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.None;
        ConfirmTypes confirmTypes = ConfirmTypes.Default;
        this.getView().showConfirm(title, approveInfo, options, confirmTypes, null);
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        this.setFilter();
    }

    private void setFilter() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList != null) {
            billList.setFilter(qFilter1);
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObject dataEntity = MobReportListPlugin.this.getModel().getDataEntity();
                String rptprocesstype = dataEntity.getString("rptprocesstype");
                if (StringUtils.isNotEmpty((String)rptprocesstype) && "2".equals(rptprocesstype)) {
                    DynamicObjectCollection data = super.getData(start, 10000);
                    if (CollectionUtils.isEmpty((Collection)data)) {
                        return data;
                    }
                    Set<Long> templateIdSet = data.stream().map(x -> x.getDynamicObject("entryentity.tempid").getLong("id")).collect(Collectors.toSet());
                    Set<Long> hasMobConfigProcess = MobReportHelper.getHasMobConfigProcess(templateIdSet);
                    Map templateSortInfoMap = ReportSchemeTemplateSortService.getInstance().getTemplateSortMap(Long.valueOf(dataEntity.getLong("source_id")), templateIdSet);
                    if (CollectionUtils.isNotEmpty(hasMobConfigProcess)) {
                        Set hasMobConfig = data.stream().filter(x -> hasMobConfigProcess.contains(x.getDynamicObject("entryentity.tempid").getLong("id"))).collect(Collectors.toSet());
                        data.removeAll(hasMobConfig);
                        List collectNoConfig = data.stream().sorted((o1, o2) -> ((Integer)templateSortInfoMap.get(o1.getDynamicObject("entryentity.tempid").getLong("id"))).compareTo((Integer)templateSortInfoMap.get(o2.getDynamicObject("entryentity.tempid").getLong("id")))).collect(Collectors.toList());
                        List collectHasConfig = hasMobConfig.stream().sorted((o1, o2) -> ((Integer)templateSortInfoMap.get(o1.getDynamicObject("entryentity.tempid").getLong("id"))).compareTo((Integer)templateSortInfoMap.get(o2.getDynamicObject("entryentity.tempid").getLong("id")))).collect(Collectors.toList());
                        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                        for (DynamicObject dynamicObject : collectHasConfig) {
                            dynamicObject.set("entryentity.seq", (Object)23);
                        }
                        dynamicObjectCollection.addAll(collectHasConfig);
                        for (DynamicObject dynamicObject : collectNoConfig) {
                            dynamicObject.set("entryentity.seq", (Object)33);
                        }
                        dynamicObjectCollection.addAll(collectNoConfig);
                        return dynamicObjectCollection;
                    }
                    List collect = data.stream().sorted((o1, o2) -> ((Integer)templateSortInfoMap.get(o1.getDynamicObject("entryentity.tempid").getLong("id"))).compareTo((Integer)templateSortInfoMap.get(o2.getDynamicObject("entryentity.tempid").getLong("id")))).collect(Collectors.toList());
                    for (DynamicObject dynamicObject : collect) {
                        dynamicObject.set("entryentity.seq", (Object)33);
                    }
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    dynamicObjectCollection.addAll(collect);
                    return dynamicObjectCollection;
                }
                if (IDUtils.isNull((long)dataEntity.getLong("id")) || IDUtils.isNull((long)dataEntity.getLong("source_id"))) {
                    return super.getData(start, limit);
                }
                DynamicObjectCollection data = super.getData(start, 10000);
                if (CollectionUtils.isEmpty((Collection)data)) {
                    return data;
                }
                Set<Long> tempid_id = data.stream().map(x -> x.getLong("tempid_id")).collect(Collectors.toSet());
                Map<Long, Integer> sortInfo = MobReportHelper.getListData(dataEntity.getLong("id"), dataEntity.getLong("source_id"), tempid_id, MobReportListPlugin.this.getModelId(), ((DynamicObject)MobReportListPlugin.this.getModel().getValue("eborgid")).getLong("id"));
                Set<Long> templateIdSet = data.stream().map(x -> x.getDynamicObject("entryentity.tempid").getLong("id")).collect(Collectors.toSet());
                Set<Long> hasMobConfigProcess = MobReportHelper.getHasMobConfigProcess(templateIdSet);
                if (CollectionUtils.isNotEmpty(hasMobConfigProcess)) {
                    List collect;
                    Set hasMobConfig = data.stream().filter(x -> hasMobConfigProcess.contains(x.getDynamicObject("entryentity.tempid").getLong("id"))).collect(Collectors.toSet());
                    data.removeAll(hasMobConfig);
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    for (DynamicObject dynamicObject : hasMobConfig) {
                        dynamicObject.set("entryentity.seq", (Object)23);
                    }
                    if (sortInfo != null) {
                        collect = hasMobConfig.stream().sorted((o1, o2) -> (Integer)sortInfo.get(o1.getLong("tempid_id")) - (Integer)sortInfo.get(o2.getLong("tempid_id"))).collect(Collectors.toList());
                        dynamicObjectCollection.addAll((Collection)collect);
                    } else {
                        dynamicObjectCollection.addAll(hasMobConfig);
                    }
                    for (DynamicObject dynamicObject : data) {
                        dynamicObject.set("entryentity.seq", (Object)33);
                    }
                    if (sortInfo != null) {
                        collect = data.stream().sorted((o1, o2) -> (Integer)sortInfo.get(o1.getLong("tempid_id")) - (Integer)sortInfo.get(o2.getLong("tempid_id"))).collect(Collectors.toList());
                        dynamicObjectCollection.addAll(collect);
                    } else {
                        dynamicObjectCollection.addAll((Collection)data);
                    }
                    return dynamicObjectCollection;
                }
                if (sortInfo != null) {
                    List collect = data.stream().sorted((o1, o2) -> (Integer)sortInfo.get(o1.getLong("tempid_id")) - (Integer)sortInfo.get(o2.getLong("tempid_id"))).collect(Collectors.toList());
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    dynamicObjectCollection.addAll(collect);
                    for (DynamicObject dynamicObject : collect) {
                        dynamicObject.set("entryentity.seq", (Object)33);
                    }
                    return dynamicObjectCollection;
                }
                return data;
            }
        });
    }
}

