/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.mob;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class MobReportMembSettingF7Plugin
extends AbstractFormPlugin {
    private static final String MAINCONTENTPANEL = "maincontentpanel";
    private static final String DIMPANEL = "dimpanel";
    private static final String CACHED_MEMBER_SELECTED = "CACHED_MEMBER_SELECTED";
    private static final String F7_PREFIX = "ebf7_";
    private SpreadSelector spreadSelector = null;
    private Map<String, String> f7KeyMap = null;
    private List<Map<String, String>> listDimInfos = null;
    private IModelCacheHelper modelCacheHelper;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        FlexPanelAp dimPanel = this.createDimPanel(this.getListDimInfos(formShowParameter));
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", MAINCONTENTPANEL);
        mapHead.put("items", (String)dimPanel.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private FlexPanelAp createDimPanel(List<Map<String, String>> dimInfos) {
        FlexPanelAp flexPanleAp = new FlexPanelAp();
        flexPanleAp.setKey(DIMPANEL);
        if (dimInfos != null) {
            for (Map<String, String> dimInfo : dimInfos) {
                String fieldKey = F7_PREFIX + dimInfo.get("number").toLowerCase();
                FieldAp fieldAp = new FieldAp();
                fieldAp.setId(fieldKey);
                fieldAp.setKey(fieldKey);
                fieldAp.setName(new LocaleString(dimInfo.get("name")));
                fieldAp.setBackColor("#FFFFFF");
                fieldAp.setFireUpdEvt(true);
                TextField field = new TextField();
                field.setId(fieldKey);
                field.setKey(fieldKey);
                field.setEditStyle(1);
                fieldAp.setField((Field)field);
                flexPanleAp.getItems().add(fieldAp);
            }
        }
        return flexPanleAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("getEntityType", exp.getMessage()), new Object[0]);
        }
        for (Map<String, String> dimInfo : this.getListDimInfos()) {
            TextProp textProp1 = new TextProp();
            textProp1.setName(F7_PREFIX + dimInfo.get("number").toLowerCase());
            textProp1.setDisplayName(new LocaleString(dimInfo.get("name")));
            textProp1.setDbIgnore(true);
            textProp1.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp1);
        }
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.f7KeyMap = this.getF7KeyMap();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (this.f7KeyMap != null) {
            DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
            for (Map.Entry<String, String> entry : this.f7KeyMap.entrySet()) {
                if (!this.isF7Key(entry.getKey())) continue;
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                List<Map<String, String>> listDimInfos = this.getListDimInfos(formShowParameter);
                String[] split = entry.getKey().split("-");
                if (split.length != 2) continue;
                for (Map<String, String> listDimInfo : listDimInfos) {
                    String selectNumber;
                    if (!entry.getValue().equals(listDimInfo.get("number")) || !StringUtils.isNotEmpty((String)(selectNumber = listDimInfo.get("selectNumber")))) continue;
                    if (selectNumber.startsWith("@")) {
                        QFilter qFilter1 = new QFilter("model", "=", (Object)this.getModelId());
                        qFilter1.and("dimension", "=", (Object)IDUtils.toLong((Object)listDimInfo.get("id")));
                        qFilter1.and("number", "=", (Object)selectNumber);
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"name", (QFilter[])new QFilter[]{qFilter1});
                        if (dynamicObject == null) continue;
                        dataEntity.set(split[0], (Object)dynamicObject.getString("name"));
                        e.setDataEntity((Object)dataEntity);
                        continue;
                    }
                    Member number = orCreate.getMemberByAnyView(this.getBusModelId(), listDimInfo.get("number"), selectNumber);
                    dataEntity.set(split[0], (Object)(number == null ? null : number.getName()));
                    e.setDataEntity((Object)dataEntity);
                }
            }
        }
    }

    public SpreadSelector getSpreadSelector() {
        String serial;
        if (this.spreadSelector == null && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)(serial = this.getView().getParentView().getPageCache().get("spread_selector_cache_key")))) {
            this.spreadSelector = (SpreadSelector)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return this.spreadSelector;
    }

    @Override
    public void beforeBindData(EventObject e) {
        FlexPanelAp dimPanel = this.createDimPanel(this.getListDimInfos());
        Container myFldPanel = (Container)this.getView().getControl(MAINCONTENTPANEL);
        myFldPanel.getItems().addAll(((Container)dimPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (this.isF7Key(ctrlKey)) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            this.getView().returnDataToParent((Object)this.getPageCache().get(CACHED_MEMBER_SELECTED));
            this.getView().close();
        } else if (this.isF7Key(key)) {
            String keyWithIndex = key + "-" + this.getIndex();
            String dimNumber = this.getF7KeyMap().get(keyWithIndex);
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)this.getModelId(), (String)dimNumber));
            Map<String, String> dimInfo = this.getDimInfo(dimNumber);
            Map<String, Long> viewIds = this.getViewIds();
            Long viewId = viewIds == null ? null : viewIds.get(dimNumber);
            ArrayList varSelect = new ArrayList(16);
            if (dimInfo != null && dimInfo.get("members") != null) {
                Map rangeMembers = (Map)SerializationUtils.fromJsonString((String)dimInfo.get("members"), Map.class);
                HashMap selectRange = new HashMap(16);
                rangeMembers.forEach((k, v) -> {
                    Member member = modelCacheHelper.getMember(dimNumber, viewId, k);
                    if (member != null) {
                        selectRange.put(member.getId(), Integer.valueOf(v));
                    }
                    if (k.startsWith("@")) {
                        varSelect.add(k);
                    }
                });
                f7Param.setSelectRange(selectRange);
            }
            if (CollectionUtils.isNotEmpty(varSelect)) {
                f7Param.setShowVariable(true);
                f7Param.addVarFilter(new QFilter("number", "in", varSelect));
            }
            f7Param.setBusModelId(this.getBusModelId());
            if ("Account".equals(dimNumber)) {
                f7Param.setDatasetId(this.getDatasetId());
            }
            f7Param.setViewId(viewId);
            Map<String, String> memberSelected = this.getCachedMemberSelected(dimNumber);
            if (memberSelected != null) {
                f7Param.setSelectIds(Collections.singleton(IDUtils.toLong((Object)memberSelected.get("id"))));
            }
            f7Param.setReturnClassName(ListSelectedRow.class.getName());
            f7Param.setReturnAllData(true);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.isF7Key(actionId) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && rows.size() > 0) {
            HashMap<String, String> memberInfo = new HashMap<String, String>(16);
            memberInfo.put("id", rows.get(0).getDataMap().get("memberid") + "");
            memberInfo.put("scope", "10");
            memberInfo.put("number", rows.get(0).getDataMap().get("number") + "");
            memberInfo.put("name", rows.get(0).getDataMap().get("name") + "");
            memberInfo.put("pid", rows.get(0).getDataMap().get("pid") + "");
            this.getModel().setValue(actionId, memberInfo.get("name"));
            String key = actionId + "-" + this.getIndex();
            this.cacheMemberSelected(this.getF7KeyMap().get(key), memberInfo);
        }
    }

    private String getIndex() {
        SpreadSelector spreadSelector = this.getSpreadSelector();
        String index = "";
        if (spreadSelector != null) {
            int startRow = spreadSelector.getStartRow();
            int startCol = spreadSelector.getStartCol();
            index = startRow + ":" + startCol;
        }
        return index;
    }

    public Map<String, String> getF7KeyMap() {
        if (this.f7KeyMap == null) {
            this.listDimInfos = this.getListDimInfos();
            if (this.listDimInfos != null) {
                this.f7KeyMap = new HashMap<String, String>(16);
                for (Map<String, String> dimInfo : this.listDimInfos) {
                    this.f7KeyMap.put(dimInfo.get("number"), F7_PREFIX + dimInfo.get("number").toLowerCase());
                    this.f7KeyMap.put(F7_PREFIX + dimInfo.get("number").toLowerCase() + "-" + this.getIndex(), dimInfo.get("number"));
                }
            }
        }
        return this.f7KeyMap;
    }

    private void cacheMemberSelected(String dimNumber, Map<String, String> memNumber) {
        String str = this.getPageCache().get(CACHED_MEMBER_SELECTED);
        HashMap<String, Map<String, String>> memberSelected = null;
        memberSelected = StringUtils.isNotEmpty((String)str) ? (HashMap<String, Map<String, String>>)SerializationUtils.fromJsonString((String)str, Map.class) : new HashMap<String, Map<String, String>>(16);
        memberSelected.put(dimNumber, memNumber);
        this.getPageCache().put(CACHED_MEMBER_SELECTED, SerializationUtils.toJsonString(memberSelected));
    }

    private Map<String, Map<String, String>> getCachedMemberSelected() {
        String str = this.getPageCache().get(CACHED_MEMBER_SELECTED);
        if (StringUtils.isNotEmpty((String)str)) {
            return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return null;
    }

    private Map<String, String> getCachedMemberSelected(String dimNumber) {
        Map<String, Map<String, String>> members = this.getCachedMemberSelected();
        if (members != null) {
            return members.get(dimNumber);
        }
        return null;
    }

    public List<Map<String, String>> getListDimInfos() {
        return this.getListDimInfos(this.getView().getFormShowParameter());
    }

    public List<Map<String, String>> getListDimInfos(FormShowParameter formShowParameter) {
        String listDimInfosStr;
        if (this.listDimInfos == null && formShowParameter != null && StringUtils.isNotEmpty((String)(listDimInfosStr = (String)formShowParameter.getCustomParam("listDimInfos")))) {
            this.listDimInfos = (List)SerializationUtils.fromJsonString((String)listDimInfosStr, List.class);
        }
        return this.listDimInfos;
    }

    private Map<String, String> getDimInfo(String dimNumber) {
        if (dimNumber != null) {
            this.listDimInfos = this.getListDimInfos();
            if (this.listDimInfos != null) {
                for (Map<String, String> dimInfo : this.listDimInfos) {
                    if (dimInfo == null || !dimNumber.equals(dimInfo.get("number"))) continue;
                    return dimInfo;
                }
            }
        }
        return null;
    }

    private boolean isF7Key(String key) {
        return key != null && key.startsWith(F7_PREFIX);
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper != null) {
            return this.modelCacheHelper;
        }
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        return this.modelCacheHelper;
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    private Long getBusModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_BUSMODEL_ID"));
    }

    private Long getDatasetId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("DATASETID"));
    }

    private Map<String, Long> getViewIds() {
        return (Map)this.getView().getFormShowParameter().getCustomParam("viewIds");
    }
}

