/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.mob;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.mob.MobReportDisplayConfig;
import kd.epm.eb.formplugin.report.mob.MobReportHelper;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.event.SpreadActionListener;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.listener.ISpreadBaseSupport;
import kd.epm.eb.spread.model.MenuItem;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.DefaultTemplateModel;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IAreaRangeEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import org.apache.commons.collections4.CollectionUtils;

public class MobReportSettingPlugin
extends AbstractFormPlugin
implements SpreadActionListener,
ISpreadBaseSupport {
    private static Log logger = LogFactory.getLog(MobReportSettingPlugin.class);
    private static final String BGTEMPLATE_INFO = "bgtemplate_info";
    private static final String TEMPLATE_MODEL = "TemplateModel";
    private static final String SPREADAP = "spreadap";
    private static final String SPREAD_SELECTOR_CACHE_KEY = "spread_selector_cache_key";
    private String rect;
    private ITemplateModel templateModel;
    private IModelCacheHelper modelCacheHelper = null;
    private SpreadContainer spreadContainer = null;
    private SpreadSelector spreadSelector = null;
    private IEBook book = null;
    private ISheet sheet = null;

    public String getRect() {
        if (this.rect != null) {
            return this.rect;
        }
        this.rect = this.getView().getParentView().getPageCache().get("rect");
        return this.rect;
    }

    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)new MySpreadActionAdapter(this, this.getSpreadKey()));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        MobReportDisplayConfig mobReportDisplayConfig;
        DynamicObject dynamicObject;
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        parentPageCache.put("mob_pageid", this.getView().getPageId());
        parentPageCache.put("pageid", this.getView().getPageId());
        String mobReportDisplayConfigStr = this.getView().getParentView().getPageCache().get("MobReportDisplayConfig");
        if ("clear".equals(mobReportDisplayConfigStr)) {
            mobReportDisplayConfigStr = null;
        }
        if (StringUtils.isEmpty((String)mobReportDisplayConfigStr) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_mobreportconfig", (String)"mobconfig", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)this.getTemplateId())})) != null && StringUtils.isNotEmpty((String)dynamicObject.getString("mobconfig"))) {
            mobReportDisplayConfigStr = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(dynamicObject.getString("mobconfig"))));
            this.getView().getParentView().getPageCache().put("MobReportDisplayConfig", mobReportDisplayConfigStr);
        }
        if (StringUtils.isNotEmpty((String)mobReportDisplayConfigStr)) {
            mobReportDisplayConfig = (MobReportDisplayConfig)SerializationUtils.fromJsonString((String)mobReportDisplayConfigStr, MobReportDisplayConfig.class);
        } else {
            mobReportDisplayConfig = new MobReportDisplayConfig();
            mobReportDisplayConfig.setDimensions(this.getTemplateModel().getRowcolDims());
        }
        this.initSpreadAp(mobReportDisplayConfig);
        this.hideContextMenu();
        this.autoFitColumn();
        CellArea dataCellArea = new CellArea(1, 1, 1, 1);
        this.getspreadContainer().lockCells(Collections.singletonList(dataCellArea));
        this.getspreadContainer().frozenSheet(new SheetFrozenInfo(Integer.valueOf(1), null, Integer.valueOf(1), null));
    }

    private void autoFitColumn() {
        LinkedList<Integer> autoFitCols = new LinkedList<Integer>();
        int maxColumnCount = this.getSpreadSheet().getMaxColumnCount();
        for (int i = 0; i < maxColumnCount; ++i) {
            autoFitCols.add(i);
        }
        this.getspreadContainer().setColsAutoFit(autoFitCols);
    }

    private void hideContextMenu() {
        ArrayList showItems = new ArrayList(16);
        ArrayList<MenuItem> hideItems = new ArrayList<MenuItem>(16);
        ArrayList contextMenuItemsEnums = Lists.newArrayList((Object[])ContextMenuItemsEnum.values());
        for (ContextMenuItemsEnum contextMenuItemsEnum : contextMenuItemsEnums) {
            MenuItem menuItem = new MenuItem(contextMenuItemsEnum.getNumber());
            hideItems.add(menuItem);
        }
        this.getspreadContainer().hideShowContextMenuItems(hideItems, showItems);
    }

    private void initSpreadAp(MobReportDisplayConfig mobReportDisplayConfig) {
        byte[] bb;
        if (mobReportDisplayConfig == null) {
            return;
        }
        Long busModelId = this.getBusModelId();
        this.book = MobReportHelper.configToSpreadBook(mobReportDisplayConfig, this.getModelCacheHelper(), busModelId);
        try {
            String spreadJson = this.book.toJsonWithRealRowCol();
            bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadJson));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        this.getspreadContainer().rebuildSpread("base64" + new String(bb));
        this.getspreadContainer().closeToolbar(Boolean.valueOf(false));
        this.cacheSpreadBook();
    }

    public void fillSpreadAp(ISheet iSheet) {
        if (iSheet.getTable().size() > 0) {
            String mobReportDisplayConfigStr = this.getView().getParentView().getPageCache().get("MobReportDisplayConfig");
            if (StringUtils.isNotEmpty((String)mobReportDisplayConfigStr)) {
                int startRow = this.getSpreadSelector().getStartRow();
                int startCol = this.getSpreadSelector().getStartCol();
                this.getPageCache().put("startRow", String.valueOf(startRow));
                this.getPageCache().put("startCol", String.valueOf(startCol));
                int endRow = this.getSpreadSelector().getEndRow();
                int endCol = this.getSpreadSelector().getEndCol();
                ArrayList<ECell> cells = new ArrayList<ECell>(16);
                for (int r = startRow; r <= endRow; ++r) {
                    for (int c = startCol; c <= endCol; ++c) {
                        ECell eCell = this.getSpreadSheet().getECell(r, c);
                        if (eCell.getValue() == null || r == 0 && c == 0) continue;
                        cells.add(eCell);
                    }
                }
                if (cells.size() > 0) {
                    this.getPageCache().put("iSheet", SerializationUtils.serializeToBase64((Object)iSheet));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u8986\u76d6\uff1f", (String)"MobReportSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("isCover", (IFormPlugin)this));
                } else {
                    this.fillSpreadAp(iSheet, startRow, startCol);
                }
            } else {
                this.fillSpreadAp(iSheet, this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
            }
        }
        this.getspreadContainer().setSelections(new CellArea(0, 0, 1, 1), true);
    }

    public void fillSpreadAp(ISheet iSheet, int startRow, int startCol) {
        IMultiAreaSetting areaRangeByArea;
        if (iSheet == null || startRow == 0 || startCol == 0) {
            return;
        }
        if (this.getTemplateModel() instanceof FixTemplateModel && (areaRangeByArea = this.getTemplateModel().getAreaRangeByArea(this.getRect())) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u533a\u5185\u6570\u636e\u3002", (String)"MobReportSettingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<ECell> updateCells = new ArrayList<ECell>(16);
        ArrayList fixMemberAreas = new ArrayList(16);
        this.sheet = this.getSpreadSheet();
        int maxRow = this.sheet.getMaxRowCount();
        int maxCol = this.sheet.getMaxColumnCount();
        this.getPageCache().put("maxRow", String.valueOf(maxRow));
        this.getPageCache().put("maxCol", String.valueOf(maxCol));
        ISheet changedSheet = this.delteEmptyCell(iSheet);
        changedSheet.iteratorECells(cell -> {
            if (cell != null) {
                int row = cell.getRow() + startRow;
                int col = cell.getCol() + startCol;
                if (row < maxRow && col < maxCol) {
                    ECell eCell = this.sheet.getECell(row, col);
                    fixMemberAreas.add(new CellArea(row, col, maxRow, maxCol));
                    if (eCell != null) {
                        if (cell.hasUserObject()) {
                            eCell.setUserObject(cell.getUserObject());
                        }
                        Object value = cell.getValue() == null ? "" : cell.getValue();
                        eCell.setValue(cell.isFloatCell() ? "..." + value : value);
                        eCell.setFloatCell(cell.isFloatCell());
                        updateCells.add(eCell);
                    }
                }
            }
        });
        this.getspreadContainer().resetCell(fixMemberAreas);
        this.fillRowColName(updateCells);
        if (updateCells.size() > 0) {
            this.getspreadContainer().updateCellValue2(updateCells);
            List<ECell> floatCells = updateCells.stream().filter(ECell::isFloatCell).collect(Collectors.toList());
            if (floatCells.size() > 0) {
                this.setFloatCellStyle(floatCells);
            }
        }
        this.cacheSpreadBook();
    }

    private ISheet delteEmptyCell(ISheet iSheet) {
        List table = iSheet.getTable();
        Iterator iterator = table.iterator();
        while (iterator.hasNext()) {
            List next = (List)iterator.next();
            Iterator it = next.iterator();
            while (it.hasNext()) {
                ECell cell = (ECell)it.next();
                if (cell != null) continue;
                it.remove();
            }
            if (next.size() != 0) continue;
            iterator.remove();
        }
        return iSheet;
    }

    private void fillRowColName(List<ECell> cells) {
        if (this.getTemplateModel() instanceof DefaultTemplateModel) {
            ECell eCell;
            Integer key;
            String value;
            Member member;
            String memberNum;
            Map map;
            Dimension dimension;
            IAreaRangeEntry areaRangeEntry = this.getTemplateModel().getAreaRangeEntry();
            boolean isHideMetric = this.getTemplateModel().getIsHideMetric();
            Boolean metricInRow = areaRangeEntry.isMetricInRow();
            ArrayList<ECell> updateCells = new ArrayList<ECell>(16);
            List colDimensions = areaRangeEntry.getColdimensions();
            List rowDimensions = areaRangeEntry.getRowdimensions();
            HashMap<Integer, String> rowNameMap = new HashMap<Integer, String>(16);
            HashMap<Integer, String> colNameMap = new HashMap<Integer, String>(16);
            if (rowDimensions.size() == 1 && (isHideMetric || Boolean.FALSE.equals(metricInRow))) {
                IDimension iDimension = (IDimension)rowDimensions.get(0);
                dimension = this.getModelCacheHelper().getDimension(iDimension.getNumber());
                for (ECell eCell2 : cells) {
                    map = (Map)eCell2.getUserObject("memNumbers");
                    if (map == null || !StringUtils.isNotEmpty((String)(memberNum = (String)map.get(iDimension.getNumber()))) || (member = dimension.getStructOfMember(memberNum)) == null || rowNameMap.containsKey(eCell2.getRow())) continue;
                    rowNameMap.put(eCell2.getRow(), member.getName());
                }
                for (Map.Entry entry : rowNameMap.entrySet()) {
                    value = (String)entry.getValue();
                    key = (Integer)entry.getKey();
                    eCell = new ECell();
                    eCell.setValue((Object)value);
                    eCell.setRow(key.intValue());
                    eCell.setCol(0);
                    this.sheet.setECell(key.intValue(), 0, eCell);
                    updateCells.add(eCell);
                }
                this.getspreadContainer().updateCellValue2(updateCells);
            }
            updateCells.clear();
            if (colDimensions.size() == 1 && (isHideMetric || Boolean.TRUE.equals(metricInRow))) {
                IDimension iDimension = (IDimension)colDimensions.get(0);
                dimension = this.getModelCacheHelper().getDimension(iDimension.getNumber());
                for (ECell eCell3 : cells) {
                    map = (Map)eCell3.getUserObject("memNumbers");
                    if (map == null || !StringUtils.isNotEmpty((String)(memberNum = (String)map.get(iDimension.getNumber()))) || (member = dimension.getStructOfMember(memberNum)) == null || colNameMap.containsKey(eCell3.getCol())) continue;
                    colNameMap.put(eCell3.getCol(), member.getName());
                }
                for (Map.Entry entry : colNameMap.entrySet()) {
                    value = (String)entry.getValue();
                    key = (Integer)entry.getKey();
                    eCell = new ECell();
                    eCell.setValue((Object)value);
                    eCell.setRow(0);
                    eCell.setCol(key.intValue());
                    this.sheet.setECell(0, key.intValue(), eCell);
                    updateCells.add(eCell);
                }
                this.getspreadContainer().updateCellValue2(updateCells);
            }
        } else if (this.getTemplateModel() instanceof FixTemplateModel) {
            ECell eCell;
            String memberNum;
            Map map;
            Dimension dimension;
            IMultiAreaSetting areaRangeByArea = this.getTemplateModel().getAreaRangeByArea(this.getRect());
            if (areaRangeByArea == null) {
                return;
            }
            ArrayList<ECell> updateCells = new ArrayList<ECell>(16);
            List rowDims = areaRangeByArea.getRowdims();
            List colDims = areaRangeByArea.getColdims();
            HashMap<Integer, String> rowNameMap = new HashMap<Integer, String>(16);
            HashMap<Integer, String> colNameMap = new HashMap<Integer, String>(16);
            if (CollectionUtils.isEmpty((Collection)rowDims) || CollectionUtils.isEmpty((Collection)colDims)) {
                return;
            }
            if (rowDims.size() == 1) {
                dimension = this.getModelCacheHelper().getDimension((String)rowDims.get(0));
                for (ECell eCell4 : cells) {
                    Member member;
                    map = (Map)eCell4.getUserObject("memNumbers");
                    if (map == null || !StringUtils.isNotEmpty((String)(memberNum = (String)map.get(rowDims.get(0)))) || (member = dimension.getStructOfMember(memberNum)) == null || colNameMap.containsKey(eCell4.getCol())) continue;
                    rowNameMap.put(eCell4.getRow(), member.getName());
                }
                for (Map.Entry entry : rowNameMap.entrySet()) {
                    eCell = new ECell();
                    eCell.setValue(entry.getValue());
                    eCell.setRow(((Integer)entry.getKey()).intValue());
                    eCell.setCol(0);
                    this.sheet.setECell(((Integer)entry.getKey()).intValue(), 0, eCell);
                    updateCells.add(eCell);
                }
                this.getspreadContainer().updateCellValue2(updateCells);
            }
            updateCells.clear();
            if (colDims.size() == 1) {
                dimension = this.getModelCacheHelper().getDimension((String)colDims.get(0));
                for (ECell eCell5 : cells) {
                    Member member;
                    map = (Map)eCell5.getUserObject("memNumbers");
                    if (map == null || !StringUtils.isNotEmpty((String)(memberNum = (String)map.get(colDims.get(0)))) || (member = dimension.getStructOfMember(memberNum)) == null || colNameMap.containsKey(eCell5.getCol())) continue;
                    colNameMap.put(eCell5.getCol(), member.getName());
                }
                for (Map.Entry entry : colNameMap.entrySet()) {
                    eCell = new ECell();
                    eCell.setValue(entry.getValue());
                    eCell.setRow(0);
                    eCell.setCol(((Integer)entry.getKey()).intValue());
                    this.sheet.setECell(0, ((Integer)entry.getKey()).intValue(), eCell);
                    updateCells.add(eCell);
                }
                this.getspreadContainer().updateCellValue2(updateCells);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("isCover".equals(callBackId) && MessageBoxResult.Yes.name().equals(e.getResult().name())) {
            ISheet iSheet = (ISheet)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("iSheet"));
            String startRow = this.getPageCache().get("startRow");
            String startCol = this.getPageCache().get("startCol");
            this.fillSpreadAp(iSheet, Integer.parseInt(startRow), Integer.parseInt(startCol));
        }
    }

    private void resetSheetStyles() {
        int maxRow = this.sheet.getMaxRowCount();
        int maxCol = this.sheet.getMaxColumnCount();
        AreasStyle headerAreasStyle = new AreasStyle();
        headerAreasStyle.setStyle(new CellStyleInfo().ofBkc("#E6E8EE"));
        headerAreasStyle.setRange(Arrays.asList(new CellArea(0, 0, 1, maxCol), new CellArea(0, 0, maxRow, 1)));
        AreasStyle dataAreasStyle = new AreasStyle();
        dataAreasStyle.setStyle(new CellStyleInfo().ofBkc("#FFFFFF"));
        CellArea dataCellArea = new CellArea(1, 1, this.sheet.getMaxRowCount(), this.sheet.getMaxColumnCount());
        dataAreasStyle.setRange(Collections.singletonList(dataCellArea));
        this.getspreadContainer().setCellStyle(Collections.singletonList(headerAreasStyle));
        this.getspreadContainer().setCellStyle(Collections.singletonList(dataAreasStyle));
        this.getspreadContainer().lockCells(Collections.singletonList(dataCellArea));
    }

    private void setFloatCellStyle(List<ECell> eCells) {
        if (eCells != null) {
            this.getspreadContainer().setFListCells(eCells, false, false);
        }
    }

    public void click(EventObject evt) {
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("btnok")) {
            List rowColDims = this.getTemplateModel().getRowcolDims();
            MobReportDisplayConfig mobReportDisplayConfig = MobReportHelper.spreadBookToConfig(this.getSpreadBook(), rowColDims);
            if (mobReportDisplayConfig != null) {
                if (this.checkComplete(mobReportDisplayConfig.getMembers()).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u5bf9\u5e94\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MobReportSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getParentView().getPageCache().put("MobReportDisplayConfig", SerializationUtils.toJsonString((Object)mobReportDisplayConfig));
            } else {
                this.getView().getParentView().getPageCache().put("MobReportDisplayConfig", "clear");
            }
            this.getView().close();
        }
    }

    private Boolean checkComplete(List<List<String[]>> members) {
        boolean hasUncompletedMember = false;
        block0: for (List<String[]> member : members) {
            block1: for (String[] strings : member) {
                if (strings == null) continue;
                List<String> list = Arrays.asList(strings);
                for (String str : list) {
                    if (StringUtils.isEmpty((String)str)) {
                        hasUncompletedMember = true;
                        continue block1;
                    }
                    if (!hasUncompletedMember) continue;
                    break block0;
                }
            }
        }
        return hasUncompletedMember;
    }

    public void itemClick(ItemClickEvent evt) {
        SpreadSelector selector = this.getSpreadSelector();
        int insertCount = 5;
        int maxRow = 0;
        int maxCol = 0;
        switch (evt.getItemKey()) {
            case "addrow": {
                int realMaxRows = this.getSpreadSheet().getMaxRowCount();
                if (realMaxRows >= 1000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb81000\u884c\u3002", (String)"MobReportSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (realMaxRows + insertCount > 1000) {
                    insertCount = 1000 - realMaxRows;
                }
                for (int i = 0; i < insertCount; ++i) {
                    this.getSpreadSheet().insertRow(selector.getEndRow() + 1);
                }
                this.getspreadContainer().insertRowsBelow(selector.getEndRow(), insertCount, true);
                this.cacheSpreadBook();
                this.resetSheetStyles();
                this.getPageCache().put("maxRow", String.valueOf(this.getSpreadSheet().getMaxRowCount()));
                break;
            }
            case "delrow": {
                if (selector.getStartRow() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"MobReportSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                LinkedList<Integer> rows = new LinkedList<Integer>();
                for (int i = selector.getEndRow(); i >= selector.getStartRow(); --i) {
                    this.getSpreadSheet().delRow(i);
                    rows.add(i);
                    this.getspreadContainer().setSelections(new CellArea(Math.max(i - 1, 0), 0, 1, 1), true);
                }
                this.getspreadContainer().deleteRowCol(rows, null);
                this.cacheSpreadBook();
                break;
            }
            case "addcol": {
                int realMaxCols = this.getSpreadSheet().getMaxColumnCount();
                if (realMaxCols >= 50) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb850\u5217\u3002", (String)"MobReportSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (int i = 0; i < insertCount; ++i) {
                    this.getSpreadSheet().insertColumn(selector.getEndCol() + 1);
                }
                this.getspreadContainer().insertColsAfter(selector.getEndCol(), insertCount, true);
                this.resetSheetStyles();
                this.cacheSpreadBook();
                this.getPageCache().put("maxCol", String.valueOf(this.getSpreadSheet().getMaxColumnCount()));
                break;
            }
            case "delcol": {
                if (selector.getStartCol() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5217\u3002", (String)"MobReportSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                LinkedList<Integer> cols = new LinkedList<Integer>();
                for (int i = selector.getEndCol(); i >= selector.getStartCol(); --i) {
                    this.getSpreadSheet().delColumn(i);
                    cols.add(i);
                    this.getspreadContainer().setSelections(new CellArea(0, Math.max(i - 1, 0), 1, 1), true);
                }
                this.getspreadContainer().deleteRowCol(null, cols);
                this.cacheSpreadBook();
                break;
            }
            case "movetoprev": {
                if (selector.getStartRow() == 0 && selector.getStartCol() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6216\u4e00\u5217\u3002", (String)"MobReportSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selector.getStartRow() == 1 && selector.getStartCol() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c1\u884c\u3002", (String)"MobReportSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selector.getStartCol() == 1 && selector.getStartRow() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c1\u5217\u3002", (String)"MobReportSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selector.getStartRow() == 0 && selector.getStartCol() != 0) {
                    this.move(selector, true, false);
                } else if (selector.getStartCol() == 0 && selector.getStartRow() != 0) {
                    this.move(selector, true, true);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6216\u4e00\u5217\u3002", (String)"MobReportSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.cacheSpreadBook();
                break;
            }
            case "movetonex": {
                if (selector.getStartRow() == 0 && selector.getStartCol() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6216\u4e00\u5217\u3002", (String)"MobReportSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selector.getStartCol() == this.getSpreadSheet().getMaxColumnCount() - 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e1\u5217\u3002", (String)"MobReportSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.cacheSpreadBook();
                    return;
                }
                String maxColStr = this.getPageCache().get("maxCol");
                if (StringUtils.isNotEmpty((String)maxColStr)) {
                    maxCol = Integer.parseInt(maxColStr);
                    if (selector.getStartCol() == maxCol - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e1\u5217\u3002", (String)"MobReportSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.cacheSpreadBook();
                        return;
                    }
                }
                if (selector.getStartRow() == this.getSpreadSheet().getMaxRowCount() - 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e1\u884c\u3002", (String)"MobReportSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.cacheSpreadBook();
                    return;
                }
                String maxRowStr = this.getPageCache().get("maxRow");
                if (StringUtils.isNotEmpty((String)maxRowStr)) {
                    maxRow = Integer.parseInt(maxRowStr);
                    if (selector.getStartRow() == maxRow - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e1\u884c\u3002", (String)"MobReportSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.cacheSpreadBook();
                        return;
                    }
                }
                if (selector.getStartRow() == 0 && selector.getStartCol() != 0) {
                    this.move(selector, false, false);
                } else if (selector.getStartCol() == 0 && selector.getStartRow() != 0) {
                    this.move(selector, false, true);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6216\u4e00\u5217\u3002", (String)"MobReportSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.cacheSpreadBook();
            }
        }
    }

    private void move(SpreadSelector selector, Boolean isFoward, Boolean ismoveRow) {
        if (ismoveRow.booleanValue()) {
            if (selector.getEndRow() - selector.getStartRow() > 0) {
                return;
            }
            int index = selector.getStartRow();
            if (isFoward.booleanValue()) {
                this.moveRowForward(index);
            } else {
                this.moveRowBack(index);
            }
        } else {
            if (selector.getEndCol() - selector.getStartCol() > 0) {
                return;
            }
            int index = selector.getStartCol();
            if (isFoward.booleanValue()) {
                this.moveLineForward(index);
            } else {
                this.moveLineBack(index);
            }
        }
        this.cacheSpreadBook();
        this.resetSheetStyles();
    }

    private Long getTemplateId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("template_id"));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    private Long getBusModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_BUSMODEL_ID"));
    }

    private Long getDatasetId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("DATASETID"));
    }

    private ITemplateModel getTemplateModel() {
        String selectFields;
        DynamicObject dyna;
        if (this.templateModel != null) {
            return this.templateModel;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String template = pageCache.get(TEMPLATE_MODEL);
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL);
        }
        if (StringUtils.isEmpty((String)template) && (dyna = BusinessDataServiceHelper.loadSingle((String)"eb_templateentity", (String)(selectFields = "id,name,number,templatetype,dataunit,dataset,data"), (QFilter[])new QFilter("id", "=", (Object)this.getTemplateId()).toArray())) != null) {
            template = dyna.getString("data");
        }
        this.templateModel = TemplateModelJSONUtil.parseITemplateModel((String)template);
        String baseinfo = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        if (StringUtils.isNotEmpty((String)baseinfo)) {
            this.templateModel.setTemplateBaseInfo((BgTemplate)ObjectSerialUtil.deSerializedBytes((String)baseinfo));
        }
        return this.templateModel;
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    public String getSpreadKey() {
        return SPREADAP;
    }

    public SpreadContainer getspreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
        }
        return this.spreadContainer;
    }

    public SpreadSelector getSpreadSelector() {
        if (this.spreadSelector == null) {
            String serial = this.getPageCache().get(SPREAD_SELECTOR_CACHE_KEY);
            this.spreadSelector = kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)serial) ? (SpreadSelector)ObjectSerialUtil.deSerializedBytes((String)serial) : new SpreadSelector(1, 1, 0, 0);
        }
        return this.spreadSelector;
    }

    public void setSpreadSelector(SpreadSelector spreadSelector) {
        this.spreadSelector = spreadSelector;
        this.cacheSpreadSelector();
    }

    public void cacheSpreadSelector() {
        if (this.spreadSelector == null) {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, null);
        } else {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, ObjectSerialUtil.toByteSerialized((Object)this.spreadSelector));
        }
    }

    public void cellClick(SpreadSelector selector) {
        ECell eCell = this.getSpreadSheet().getECell(selector.getStartRow(), selector.getStartCol());
        if (eCell.isFloatCell()) {
            this.openMemSelectF7(eCell);
        }
        this.showDimensionInfoOnBottom();
    }

    private void openMemSelectF7(ECell eCell) {
        if (eCell == null || eCell.getUserObject("floatInfo") == null) {
            return;
        }
        MultiAreaSetting.FloatInfo floatInfo = (MultiAreaSetting.FloatInfo)eCell.getUserObject("floatInfo");
        ArrayList listDimInfos = new ArrayList(16);
        for (IRowColDimensionEntry entry : floatInfo.getPartition().getRowColDimensionEntries()) {
            Map selectedMems;
            Map map;
            if (!entry.isFloat() || entry.getDimension() == null || entry.getMembers() == null) continue;
            String dimNumber = entry.getDimension().getNumber();
            Dimension d = this.getModelCacheHelper().getDimension(dimNumber);
            HashMap<String, String> dimInfos = new HashMap<String, String>();
            dimInfos.put("id", String.valueOf(d.getId()));
            dimInfos.put("name", d.getName());
            dimInfos.put("number", d.getNumber());
            dimInfos.put("entity", d.getMemberModel());
            dimInfos.put("shortnumber", d.getShortNumber());
            HashMap rangeMembers = new HashMap(16);
            entry.getMembers().forEach(m -> rangeMembers.put(m.getNumber(), m.getScope() + ""));
            dimInfos.put("members", SerializationUtils.toJsonString(rangeMembers));
            Object f7mumberInfo = eCell.getUserObject("f7mumberInfo");
            if (f7mumberInfo != null && (map = (Map)(selectedMems = (Map)f7mumberInfo).get(dimNumber)) != null) {
                dimInfos.put("selectNumber", (String)map.get("number"));
            }
            listDimInfos.add(dimInfos);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_mobreport_membsetlist");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("KEY_BUSMODEL_ID", (Object)this.getBusModelId());
        formShowParameter.setCustomParam("DATASETID", (Object)this.getDatasetId());
        formShowParameter.setCustomParam("listDimInfos", (Object)SerializationUtils.toJsonString(listDimInfos));
        formShowParameter.setCustomParam("viewIds", eCell.getUserObject("viewIds"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_mobreport_membsetlist"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("eb_mobreport_membsetlist".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof String) {
            Map selectedMems = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            if (selectedMems == null) {
                return;
            }
            HashMap selectedMemNumbers = new HashMap(16);
            selectedMems.forEach((k, v) -> {
                String cfr_ignored_0 = (String)selectedMemNumbers.put(k, v.get("number"));
            });
            ECell eCell = this.getSpreadSheet().getECellNotAdd(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
            if (eCell != null) {
                String[] orderedDimNumbers = this.getTemplateModel().getRowcolDims().toArray(new String[0]);
                HashMap<String, String> memNumbers = (HashMap<String, String>)eCell.getUserObject("memNumbers");
                if (memNumbers == null) {
                    memNumbers = new HashMap<String, String>(16);
                }
                memNumbers.putAll(selectedMemNumbers);
                eCell.setValue((Object)MobReportHelper.getMemberDisplay(this.getModelCacheHelper(), orderedDimNumbers, memNumbers, this.getBusModelId()));
                eCell.setUserObject("f7mumberInfo", (Object)selectedMems);
                this.cacheSpreadBook();
                this.getspreadContainer().updateCellValue2(Collections.singletonList(eCell));
            }
        }
    }

    private void showDimensionInfoOnBottom() {
        this.getspreadContainer().setDisplayContent(null, "", null);
    }

    public void cellValueUpdate(CellValueEvent e) {
        ECell eCell = e.getCell();
        if (this.isRowHeaderCell(eCell) || this.isColHeaderCell(eCell)) {
            this.getSpreadSheet().getECell(eCell.getRow(), eCell.getCol()).setValue(e.getNewValue());
        }
    }

    private boolean isRowHeaderCell(ECell eCell) {
        return eCell != null && eCell.getRow() == 0 && eCell.getCol() != 0;
    }

    private boolean isColHeaderCell(ECell eCell) {
        return eCell != null && eCell.getCol() == 0 && eCell.getRow() != 0;
    }

    private IEBook getSpreadBook() {
        if (this.book == null) {
            String str = this.getPageCache().get("SPREAD_BOOK_CACHE_KEY");
            if (StringUtils.isNotEmpty((String)str)) {
                this.book = (IEBook)ObjectSerialUtil.deSerializedBytes((String)str);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f13\u5b58\u6570\u636e\u83b7\u53d6\u5f02\u5e38\u3002\u8bf7\u9000\u51fa\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"MobReportSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return this.book;
    }

    private void cacheSpreadBook() {
        long beginTime = System.currentTimeMillis();
        this.getPageCache().put("SPREAD_BOOK_CACHE_KEY", this.book == null ? null : ObjectSerialUtil.toByteSerialized((Object)this.book));
        long endTime = System.currentTimeMillis();
        logger.info("\n cacheSpreadBook spend time = " + (endTime - beginTime));
    }

    private ISheet getSpreadSheet() {
        if (this.sheet == null) {
            this.book = this.getSpreadBook();
            if (this.book != null) {
                this.sheet = this.book.getSheet(0);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f13\u5b58\u6570\u636e\u83b7\u53d6\u5f02\u5e38\u3002\u8bf7\u9000\u51fa\u9875\u9762\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"MobReportSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return this.sheet;
    }

    private void moveRowForward(int start) {
        List rows = this.getSpreadSheet().getTable();
        List<ECell> selectedRow = this.fillEmptyCell((List)rows.get(start));
        for (int j = 0; j < selectedRow.size(); ++j) {
            ECell eCell = selectedRow.get(j);
            eCell.setRow(start - 1);
            eCell.setCol(j);
        }
        List<ECell> lastRow = this.fillEmptyCell((List)rows.get(start - 1));
        for (int j = 0; j < lastRow.size(); ++j) {
            ECell eCell = lastRow.get(j);
            eCell.setRow(start);
            eCell.setCol(j);
        }
        this.getspreadContainer().setSelections(new CellArea(start - 1, 0, 1, 50), true);
        this.getspreadContainer().updateCellValue2(selectedRow);
        this.getspreadContainer().updateCellValue2(lastRow);
        Collections.swap(rows, start, start - 1);
    }

    private List<ECell> fillEmptyCell(List<ECell> list) {
        ArrayList<ECell> collect = new ArrayList<ECell>(16);
        for (ECell eCell : list) {
            if (eCell == null) {
                ECell cell = new ECell();
                collect.add(cell);
                continue;
            }
            collect.add(eCell);
        }
        return collect;
    }

    private List<ECell> fillEmptyCell(List<ECell> list, int row) {
        ArrayList<ECell> collect = new ArrayList<ECell>(16);
        for (int i = 0; i < list.size(); ++i) {
            ECell eCell = list.get(i);
            if (eCell == null) {
                ECell cell = new ECell();
                cell.setRow(row);
                cell.setCol(i);
                collect.add(cell);
                continue;
            }
            eCell.setRow(row);
            eCell.setCol(i);
            collect.add(eCell);
        }
        return collect;
    }

    private void moveRowBack(int start) {
        List rows = this.getSpreadSheet().getTable();
        List<ECell> selectedRow = this.fillEmptyCell((List)rows.get(start));
        for (int i = 0; i < selectedRow.size(); ++i) {
            ECell eCell = selectedRow.get(i);
            if (eCell == null) continue;
            eCell.setRow(start + 1);
            eCell.setCol(i);
        }
        List<ECell> lastRow = this.fillEmptyCell((List)rows.get(start + 1));
        for (int i = 0; i < lastRow.size(); ++i) {
            ECell eCell = lastRow.get(i);
            if (eCell == null) continue;
            eCell.setRow(start);
            eCell.setCol(i);
        }
        this.getspreadContainer().setSelections(new CellArea(start + 1, 0, 1, 50), true);
        this.getspreadContainer().updateCellValue2(selectedRow);
        this.getspreadContainer().updateCellValue2(lastRow);
        Collections.swap(rows, start, start + 1);
    }

    private void moveLineForward(int start) {
        List rows = this.getSpreadSheet().getTable();
        ArrayList<List> list = new ArrayList<List>(16);
        for (int i = 0; i < rows.size(); ++i) {
            List row = this.fillEmptyCell((List)rows.get(i), i);
            ECell selectedCell = (ECell)row.get(start);
            selectedCell.setRow(i);
            selectedCell.setCol(start - 1);
            ECell lastCell = (ECell)row.get(start - 1);
            lastCell.setRow(i);
            lastCell.setCol(start);
            Collections.swap((List)rows.get(i), start, start - 1);
            list.add(row);
        }
        for (List row : list) {
            this.getspreadContainer().updateCellValue2(row);
        }
        this.getspreadContainer().setSelections(new CellArea(0, start - 1, 1000, 1), true);
    }

    private void moveLineBack(int start) {
        List rows = this.getSpreadSheet().getTable();
        ArrayList<List> list = new ArrayList<List>(16);
        for (int i = 0; i < rows.size(); ++i) {
            List row = this.fillEmptyCell((List)rows.get(i), i);
            ECell selectedCell = (ECell)row.get(start);
            selectedCell.setRow(i);
            selectedCell.setCol(start + 1);
            ECell lastCell = (ECell)row.get(start + 1);
            lastCell.setRow(i);
            lastCell.setCol(start);
            Collections.swap((List)rows.get(i), start, start + 1);
            this.getspreadContainer().updateCellValue2(row);
            list.add(row);
        }
        for (List row : list) {
            this.getspreadContainer().updateCellValue2(row);
        }
        this.getspreadContainer().setSelections(new CellArea(0, start + 1, 1000, 1), true);
    }

    private static class MySpreadActionAdapter
    extends SpreadJsAction {
        public MySpreadActionAdapter(kd.bos.form.plugin.AbstractFormPlugin plugin, String spreadkey) {
            super(plugin, spreadkey);
        }

        public void updateCellValue(SpreadEvent event) {
            List values;
            SpreadPostDataInfo data = ((Spread)event.getSource()).getPostDataInfo();
            if (data != null && data.getValues() != null && (values = (data = event.getPostData()).getValues()) != null) {
                for (LinkedHashMap value : values) {
                    this.getPlugin().cellValueUpdate(new CellValueEvent(null, value.get("v"), new ECell(((Integer)value.get("r")).intValue(), ((Integer)value.get("c")).intValue())));
                }
                this.getPlugin().cacheSpreadBook();
                this.getPlugin().resetSheetStyles();
            }
        }

        private MobReportSettingPlugin getPlugin() {
            return (MobReportSettingPlugin)this.plugin;
        }
    }
}

