/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.mob;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.MobileTreeListPlugin;
import kd.bos.list.MobileTreeList;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class MobReportSingleF7Plugin
extends MobileTreeListPlugin {
    public static final String FORM_ID = "mob_report_singlef7";

    public Map<String, Object> packageData(Map<String, Object> map, boolean isContainConfig, boolean isNeedParent) {
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl("mobiletreelistap");
        List children = (List)map.get("children");
        TreeNode parentNode = (TreeNode)map.get("parentNode");
        HashMap<String, Object> listData = new HashMap<String, Object>();
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)mobiletreeList.getKey());
        if (children == null) {
            return new HashMap<String, Object>();
        }
        List<Map<String, Object>> childrenDatas = this.getRowDatas(children, null);
        if (parentNode != null && isNeedParent) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", parentNode.getId());
            data.put("mt", parentNode.getText());
            data.put("hp", !"".equals(parentNode.getParentid()));
            data.put("hc", !parentNode.isLeaf());
            data.put("ca", parentNode.isCheckable());
            data.put("children", childrenDatas);
            listData.put("data", data);
        } else {
            listData.put("data", childrenDatas);
        }
        int pageIndex = Integer.parseInt(map.get("pageIndex").toString());
        int dataCount = Integer.parseInt(map.get("total").toString());
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        int first_pagerow = 0;
        if (cache.get(this.getView().getPageId() + mobiletreeList.getFirstPageKey()) != null) {
            first_pagerow = Integer.parseInt(cache.get(this.getView().getPageId() + mobiletreeList.getFirstPageKey()));
        }
        listData.put("hasMore", first_pagerow + (pageIndex - 1) * mobiletreeList.getPageRow() < dataCount);
        listData.put("pageIndex", pageIndex);
        if (isContainConfig) {
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            ArrayList<Object> pkIds = new ArrayList<Object>();
            for (ListSelectedRow listSelectedRow : mobiletreeList.getListShowParameter().getListSelectedRowCollection()) {
                pkIds.add(listSelectedRow.getPrimaryKeyValue());
            }
            configMap.put("isMust", mobiletreeList.getListShowParameter().isMustInput());
            configMap.put("isMulti", mobiletreeList.isMulti());
            configMap.put("title", new LocaleString(this.getView().getFormShowParameter().getCaption()));
            Map<String, Object> selectData = this.getSelectData(pkIds, parentNode);
            if (selectData.size() > 0) {
                configMap.put("selected", this.getRowDatas((List)selectData.get("children"), pkIds));
            }
            configMap.put("onlyEndNode", mobiletreeList.isOnlySelectLeaf());
            configMap.put("sft", mobiletreeList.isShowFrequent());
            listData.put("config", configMap);
        }
        return listData;
    }

    private Map<String, Object> getSelectData(List<Object> pkIds, TreeNode treeNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        if (CollectionUtils.isEmpty(pkIds) || treeNode == null) {
            return map;
        }
        for (Object pkId : pkIds) {
            TreeNode treeNode1 = treeNode.getTreeNode(String.valueOf(pkId));
            children.add(treeNode1);
        }
        map.put("children", children);
        return map;
    }

    private List<Map<String, Object>> getRowDatas(List<TreeNode> children, List<Object> pkIds) {
        ArrayList<Map<String, Object>> rowdatas = new ArrayList<Map<String, Object>>(10);
        children.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(children)) {
            return rowdatas;
        }
        if (pkIds != null && !pkIds.isEmpty()) {
            Map treeNodeMap = children.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity()));
            for (Object pkId : pkIds) {
                this.addRowData(rowdatas, (TreeNode)treeNodeMap.get(pkId.toString()));
            }
        } else {
            for (TreeNode node : children) {
                this.addRowData(rowdatas, node);
            }
        }
        return rowdatas;
    }

    private void addRowData(List<Map<String, Object>> rowdatas, TreeNode node) {
        if (node != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", node.getId());
            data.put("mt", node.getText());
            data.put("hp", !"".equals(node.getParentid()));
            List children = node.getChildren();
            data.put("hc", CollectionUtils.isNotEmpty((Collection)children));
            data.put("ca", true);
            rowdatas.add(data);
        }
    }

    public Map<String, Object> getChildrenTreeNode(QFilter qFilter, int start, int limit, String currentid, boolean isOnlySelectLeaf) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object tree = this.getView().getFormShowParameter().getCustomParam("tree");
        TreeNode parentNode = null;
        if (tree != null) {
            TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)tree.toString(), TreeNode.class);
            ArrayList childrenList = new ArrayList();
            if (qFilter != null) {
                ArrayList hitNode = new ArrayList(16);
                Object value = qFilter.getValue();
                if (value != null) {
                    String valueStr = value.toString();
                    String[] split = valueStr.split("#");
                    if (split.length > 1) {
                        treeNode.getTreeNodeListByText(hitNode, split[1], 999);
                    }
                    if (hitNode.size() > 0) {
                        childrenList.addAll(hitNode);
                        parentNode = this.buildTreeNode(treeNode);
                    }
                }
            } else if ("0".equals(currentid)) {
                List children = treeNode.getChildren();
                if (children != null) {
                    for (TreeNode child : children) {
                        TreeNode node = this.buildTreeNode(child);
                        childrenList.add(node);
                    }
                    parentNode = this.buildTreeNode(treeNode);
                    parentNode.setChildren(treeNode.getChildren());
                }
            } else {
                Map<String, Object> childById = this.getChildById(currentid, treeNode);
                if (childById != null && childById.size() > 0 && childById.get("children") != null) {
                    childrenList.addAll((List)childById.get("children"));
                    parentNode = (TreeNode)childById.get("parentNode");
                }
            }
            map.put("children", childrenList);
            map.put("pageIndex", 0);
            map.put("total", childrenList.size());
            map.put("parentNode", parentNode);
            return map;
        }
        return map;
    }

    private Map<String, Object> getChildById(String id, TreeNode treeNode) {
        TreeNode temp = treeNode.getTreeNode(id);
        if (temp != null) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            result.put("parentNode", temp);
            result.put("children", temp.getChildren());
            return result;
        }
        return null;
    }

    @NotNull
    private TreeNode buildTreeNode(TreeNode child) {
        TreeNode node = new TreeNode();
        node.setId(child.getId());
        String name = child.getText();
        node.setText(name);
        node.setParentid(child.getParentid());
        node.setLongNumber(child.getLongNumber());
        node.setChildren(child.getChildren());
        node.setLeaf(child.isLeaf());
        node.setCheckable(true);
        return node;
    }
}

