/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.tree.templatecatalog.ReportCustomTreeBuilder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.report.query.ReportQueryBasePlugin;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.spread.utils.ReportHelper;

public class CustomTreePlugin
extends ReportQueryBasePlugin {
    private static final String CALLBACK_MODELCLICK = "modelclick";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ArrayList<String> clickCtrKeys = new ArrayList<String>(Arrays.asList("expand_all", "shrink_all", "expand_current", "shrink_current", "btn_up", "btn_down", "modelswitch", "lockicon", "unlockicon", "treepanelswitch"));
        this.addClickListeners(clickCtrKeys.toArray(new String[clickCtrKeys.size()]));
        this.addItemClickListeners(new String[]{"tbmain", "floatmenuap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.alertWarn(true);
        this.setModelFilter();
        this.lockunlockLeftTree("unlockicon");
        String pkIdFromMessCenter = this.getPkIdFromMessCenter();
        if (StringUtils.isNotEmpty((String)pkIdFromMessCenter)) {
            this.getView().getFormShowParameter().setAppId("bgm");
            String[] pkId = pkIdFromMessCenter.split("/");
            String modelId = pkId[0];
            this.setCache("KEY_MODEL_ID", modelId);
            this.updateModelLables();
            return;
        }
        String tarPkId = this.getPkIdFromTargetData();
        if (StringUtils.isNotEmpty((String)tarPkId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"modelswitch"});
            String modelId = this.getFromPageModelId();
            this.setCache("KEY_MODEL_ID", modelId);
            this.updateModelLables();
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatelistpanelap", "btn_schemesaveas", "selectscheme"});
        this.updateModelLables();
    }

    private void setModelFilter() {
        QFilter filter1 = new QFilter("id", "=", (Object)this.getModelId());
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("model");
        this.getView().getFormShowParameter().setAppId("bgm");
        List modelFilters = ModelUtil.getModelFilter((IFormView)this.getView());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(modelFilters.size());
        for (QFilter filter : modelFilters) {
            filter.or(filter1);
            filters.add(filter);
        }
        basedataEdit.setQFilters(filters);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "modelswitch": {
                this.showModelForm();
                break;
            }
            case "btn_refresh": {
                if (this.isFromTargetCusReport()) {
                    this.clearCache("cache_is_init_load_scheme");
                    this.setCache("cacheTargetRefresh", "1");
                    this.getModel().setValue("selectscheme", (Object)"");
                    this.getView().updateView("selectscheme");
                }
                this.refreshCustomTree();
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "modelclick": {
                this.modelCallBack(evt);
                break;
            }
            case "catalog_close": {
                this.reportCatalogCallBack(evt);
                break;
            }
        }
    }

    private void reportCatalogCallBack(ClosedCallBackEvent evt) {
        ArrayList ids;
        ArrayList arrayList = ids = evt.getReturnData() == null ? null : (ArrayList)evt.getReturnData();
        if (ids != null && ids.size() > 0) {
            Long nodeid = (Long)ids.get(0);
            this.setCache("curNodeId", IDUtils.toString((Object)nodeid));
            this.refreshCustomTree();
        }
    }

    private void modelCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData;
        if (evt.getReturnData() instanceof ListSelectedRowCollection && (returnData = (ListSelectedRowCollection)evt.getReturnData()).size() > 0) {
            Long oldModelId;
            Long model = IDUtils.toLong((Object)returnData.get(0).getPrimaryKeyValue());
            if (model.equals(oldModelId = this.getModelId())) {
                return;
            }
            this.setModelLabel(returnData.get(0).getName());
            this.getModel().setValue("model", (Object)model);
            this.setCache("KEY_MODEL_ID", model.toString());
            this.clearCache("cache_f7key_dim_map");
            this.clearCache("cache_dimcontent_visiable");
            this.clearCache("cache_alldims");
            this.closeAllTab();
            this.refreshCustomTree();
            this.saveUserSelectModel(model);
            ReportHelper.setLongNameNumDisVisible((Long)this.getModelId(), (IFormView)this.getView());
        }
    }

    private void saveUserSelectModel(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
    }

    private void showModelForm() {
        Long modelId = this.getModelId();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("epm_model");
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setLookUp(true);
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            listShowParameter.setSelectedRow((Object)modelId);
        }
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_MODELCLICK));
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        qFilterList.addAll(ReportQueryHelper.getDefModelFilter(this.getView()));
        if (listShowParameter.getCustomParams() != null) {
            listShowParameter.getCustomParams().put("noNeedDefaultQFilter", "true");
        }
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (itemKey = c.getKey()) {
            case "modelswitch": {
                this.showModelForm();
                break;
            }
            case "expand_all": {
                CustomTreeNode customTreeNode = this.getCacheTree();
                if (customTreeNode == null) {
                    return;
                }
                String cacheCurrentNode = this.getCacheCurrentNode();
                CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
                ArrayList<CustomTreeNode> list = new ArrayList<CustomTreeNode>(16);
                if (customTreeNode != null) {
                    list.add(customTreeNode);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                if (StringUtils.isEmpty((String)cacheCurrentNode) && customTreeNode != null) {
                    cacheCurrentNode = customTreeNode.getId();
                }
                map.put("list", list);
                map.put("selectId", cacheCurrentNode);
                map.put("expandAll", "true");
                customControl.setData(map);
                break;
            }
            case "shrink_all": {
                CustomTreeNode customTreeNode = this.getCacheTree();
                if (customTreeNode == null) {
                    return;
                }
                String cacheCurrentNode = this.getCacheCurrentNode();
                CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
                ArrayList<CustomTreeNode> list = new ArrayList<CustomTreeNode>(16);
                if (customTreeNode != null) {
                    list.add(customTreeNode);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                if (StringUtils.isEmpty((String)cacheCurrentNode) && customTreeNode != null) {
                    cacheCurrentNode = customTreeNode.getId();
                }
                map.put("list", list);
                map.put("selectId", cacheCurrentNode);
                map.put("expandAll", "false");
                customControl.setData(map);
                break;
            }
            case "expand_current": {
                CustomTreeNode customTreeNode = this.getCacheTree();
                if (customTreeNode == null) {
                    return;
                }
                String cacheCurrentNode = this.getCacheCurrentNode();
                CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
                ArrayList<CustomTreeNode> list = new ArrayList<CustomTreeNode>(16);
                if (customTreeNode != null) {
                    list.add(customTreeNode);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                if (StringUtils.isEmpty((String)cacheCurrentNode) && customTreeNode != null) {
                    cacheCurrentNode = customTreeNode.getId();
                }
                map.put("list", list);
                map.put("selectId", cacheCurrentNode);
                map.put("expandCurr", "true");
                customControl.setData(map);
                break;
            }
            case "shrink_current": {
                CustomTreeNode customTreeNode = this.getCacheTree();
                if (customTreeNode == null) {
                    return;
                }
                String cacheCurrentNode = this.getCacheCurrentNode();
                CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
                ArrayList<CustomTreeNode> list = new ArrayList<CustomTreeNode>(16);
                if (customTreeNode != null) {
                    list.add(customTreeNode);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                if (StringUtils.isEmpty((String)cacheCurrentNode) && customTreeNode != null) {
                    cacheCurrentNode = customTreeNode.getId();
                }
                map.put("list", list);
                map.put("selectId", cacheCurrentNode);
                map.put("expandCurr", "false");
                customControl.setData(map);
                break;
            }
            case "lockicon": 
            case "unlockicon": {
                this.lockunlockLeftTree(itemKey);
                break;
            }
            case "btn_up": 
            case "btn_down": {
                this.downAndUpMember(itemKey);
                break;
            }
            case "treepanelswitch": {
                this.switchShowLeftPanel(false);
                break;
            }
        }
    }

    private void downAndUpMember(String key) {
        CustomTreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return;
        }
        String cacheCurrentNode = this.getCacheCurrentNode();
        if (StringUtils.isEmpty((String)cacheCurrentNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5206\u7c7b\u8282\u70b9\u3002", (String)"ReportQueryProcess_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CustomTreeNode treeNode = cacheTree.getTreeNode(cacheCurrentNode, 10);
        if (treeNode == null) {
            return;
        }
        if (!this.isCatalog(treeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u5206\u7c7b\u8282\u70b9\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String parentId = treeNode.getParentId();
        CustomTreeNode parent = cacheTree.getTreeNode(parentId, 10);
        if (parent == null) {
            return;
        }
        boolean issuccess = false;
        List children = parent.getChildren();
        List collect = children.stream().filter(x -> !x.getCategory().startsWith("report") && !x.getCategory().equals("dim-category")).collect(Collectors.toList());
        if (parent == null || collect.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u8282\u70b9\u7684\u7236\u8282\u70b9\u53ea\u6709\u4e00\u4e2a\u4e0b\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u4e0a\u79fb\u6216\u4e0b\u79fb\u3002", (String)"ReportQueryProcess_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (collect.size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u8282\u70b9\u7684\u7236\u8282\u70b9\u53ea\u6709\u4e00\u4e2a\u4e0b\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u4e0a\u79fb\u6216\u4e0b\u79fb\u3002", (String)"ReportQueryProcess_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList brothers = new ArrayList(collect);
        int index = brothers.indexOf(treeNode);
        if (index < 0) {
            return;
        }
        if ("btn_up".equals(key) && index == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u8282\u70b9\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"ReportQueryProcess_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("btn_down".equals(key) && index == brothers.size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u8282\u70b9\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u4e0b\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"ReportQueryProcess_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CustomTreeNode toswap = null;
        toswap = "btn_up".equals(key) ? (CustomTreeNode)brothers.get(index - 1) : (CustomTreeNode)brothers.get(index + 1);
        this.swapTemplateCatalog(treeNode, toswap);
        issuccess = true;
        if (issuccess) {
            this.refreshCustomTree();
        }
    }

    private void swapTemplateCatalog(CustomTreeNode curReportCataLogTree, CustomTreeNode toswap) {
        DynamicObject[] objs;
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{IDUtils.toLong((Object)curReportCataLogTree.getId()), IDUtils.toLong((Object)toswap.getId())});
        for (DynamicObject obj : objs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)ORM.create().newDynamicObject("eb_reportcatalog").getDataEntityType())) {
            if (obj.getString("id").equals(curReportCataLogTree.getId())) {
                obj.set("sequence", (Object)toswap.getSeq());
                continue;
            }
            obj.set("sequence", (Object)curReportCataLogTree.getSeq());
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("init".equals(eventName)) {
            if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                return;
            }
            this.refreshCustomTree();
        } else if ("addcategory".equals(eventName)) {
            if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                return;
            }
            CustomTreeNode customTreeNode = this.getCustomEventNode(e);
            if (customTreeNode == null) {
                return;
            }
            if (customTreeNode.getCategory().equals("report-public") || this.isCatalog(customTreeNode) && StringUtils.isNotEmpty((String)customTreeNode.getLongnumber()) && customTreeNode.getLongnumber().startsWith("root.02_sys")) {
                this.checkPermission(this.getView(), "public_update");
            } else {
                this.checkPermission(this.getView(), "btn_saveasinterest");
            }
            this.newReportCatalog(true, customTreeNode);
        } else if ("remove".equals(eventName)) {
            CustomTreeNode customTreeNode = this.getCustomEventNode(e);
            if (customTreeNode == null) {
                return;
            }
            if (!StringUtils.isNotEmpty((String)customTreeNode.getCategory()) || !customTreeNode.getCategory().startsWith("report")) {
                if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                    return;
                }
                if (customTreeNode.getCategory().equals("report-public") || this.isCatalog(customTreeNode) && StringUtils.isNotEmpty((String)customTreeNode.getLongnumber()) && customTreeNode.getLongnumber().startsWith("root.02_sys")) {
                    this.checkPermission(this.getView(), "public_update");
                } else {
                    this.checkPermission(this.getView(), "remove");
                }
                this.deleteReportCatalog(customTreeNode);
            }
        } else if ("edit".equals(eventName)) {
            CustomTreeNode customEventNode = this.getCustomEventNode(e);
            if (customEventNode == null) {
                return;
            }
            if (!StringUtils.isNotEmpty((String)customEventNode.getCategory()) || !customEventNode.getCategory().startsWith("report")) {
                if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                    return;
                }
                if (customEventNode.getCategory().equals("report-public") || this.isCatalog(customEventNode) && StringUtils.isNotEmpty((String)customEventNode.getLongnumber()) && customEventNode.getLongnumber().startsWith("root.02_sys")) {
                    this.checkPermission(this.getView(), "public_update");
                } else {
                    this.checkPermission(this.getView(), "edit");
                }
                this.newReportCatalog(false, customEventNode);
            }
        }
    }

    private void deleteReportCatalog(CustomTreeNode customTreeNode) {
        if (StringUtils.isEmpty((String)customTreeNode.getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"ReportQueryProcess_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isRootCatalog(customTreeNode.getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ReportQueryProcess_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.isCatalog(customTreeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u5206\u7c7b\u8282\u70b9\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (customTreeNode.getNumber().equalsIgnoreCase("share")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6211\u7684\u5206\u4eab\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ReportQueryProcess_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map map = ReportCustomTreeBuilder.categoryHasReport((CustomTreeNode)customTreeNode, (Long)this.getModelId(), (Long)UserUtils.getUserId());
        if (((Boolean)map.get("hasReport")).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u4e0b\u6709\u62a5\u8868\u5b58\u5728\uff0c\u9700\u5c06\u8be5\u5206\u7c7b\u4e0b\u62a5\u8868\u79fb\u52a8\u5230\u5176\u4ed6\u5206\u7c7b\u4e0b\u540e\u5220\u9664\u8be5\u5206\u7c7b\u3002", (String)"ReportQueryProcess_102", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setCache("deleCategory", JSONObject.toJSONString(map.get("categoryId")));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\u6240\u9009\u5206\u7c7b\uff1f", (String)"ReportQueryProcess_103", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_reportcatalog_comfirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent msgBoxEvt) {
        super.confirmCallBack(msgBoxEvt);
        String callBackId = msgBoxEvt.getCallBackId();
        if (callBackId.equals("delete_reportcatalog_comfirm")) {
            this.delRptCatalogConfirmCallBack(msgBoxEvt);
        }
    }

    private void delRptCatalogConfirmCallBack(MessageBoxClosedEvent mbce) {
        if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            String cache = this.getCache("deleCategory");
            if (StringUtils.isEmpty((String)cache)) {
                return;
            }
            HashSet needDeleteCategoryId = (HashSet)JSONObject.parseObject((String)cache, HashSet.class);
            if (needDeleteCategoryId != null && needDeleteCategoryId.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_reportcatalog"), (Object[])needDeleteCategoryId.toArray());
            }
            this.clearCache("deleCategory");
            this.refreshCustomTree();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReportQueryProcess_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void newReportCatalog(boolean isAddNew, CustomTreeNode customTreeNode) {
        String nodeId = customTreeNode.getId();
        String treeNodeStr = customTreeNode.getName();
        if (StringUtils.isEmpty((String)nodeId)) {
            if (StringUtils.isEmpty((String)treeNodeStr)) {
                nodeId = "0";
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"ReportQueryProcess_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (!this.isCatalog(customTreeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u5206\u7c7b\u8282\u70b9\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (nodeId == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("model", this.getModelId().toString());
        params.put("user", String.valueOf(this.getUserId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "catalog_close");
        long curNodeId = Long.parseLong(nodeId);
        if (isAddNew) {
            if (customTreeNode != null && customTreeNode.getNumber().equalsIgnoreCase("share")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6211\u7684\u5206\u4eab\u8282\u70b9\u4e0d\u80fd\u4f5c\u4e3a\u7236\u8282\u70b9\u3002", (String)"ReportQueryProcess_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            params.put("parent", curNodeId);
            this.showTemplateCatalogForm("eb_reportcatalog", params, closeCallBack, ShowType.Modal, 0L);
        } else {
            if (this.isRootCatalog(nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ReportQueryProcess_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (customTreeNode != null && customTreeNode.getNumber().equalsIgnoreCase("share")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6211\u7684\u5206\u4eab\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ReportQueryProcess_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            long id = Long.parseLong(nodeId);
            this.showTemplateCatalogForm("eb_reportcatalog", params, closeCallBack, ShowType.Modal, id);
        }
    }

    private void showTemplateCatalogForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public boolean isRootCatalog(String nodeid) {
        CustomTreeNode root = this.getCacheTree();
        if (root == null) {
            return false;
        }
        CustomTreeNode treenode = root.getTreeNode(nodeid, 10);
        return treenode != null && (StringUtils.isEmpty((String)treenode.getParentId()) || treenode.getParentId().equalsIgnoreCase("0"));
    }

    private Long alertWarn(boolean isAlert) {
        this.checkErrorDisplayed = isAlert;
        return this.getModelId();
    }

    private void lockunlockLeftTree(String key) {
        Boolean isLock = "unlockicon".equalsIgnoreCase(key);
        this.getView().setVisible(isLock, new String[]{"lockicon"});
        this.getView().setVisible(Boolean.valueOf(isLock == false), new String[]{"unlockicon"});
        this.setCache("cache_lockLeftTree", isLock != false ? "1" : "0");
    }

    private void updateModelLables() {
        DynamicObject query;
        Long modelId = this.getModelId();
        if (IDUtils.isNotNull((Long)modelId) && (query = QueryServiceHelper.queryOne((String)"epm_model", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)})) != null) {
            String modelname = query.getString("name");
            this.setModelLabel(modelname);
        }
    }
}

