/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.tree.templatecatalog.ReportCustomTreeBuilder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.report.designer.ShareSettingDto;
import kd.epm.eb.formplugin.report.query.ReportQueryBasePlugin;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.formplugin.task.multi.TabInfo;
import kd.epm.eb.formplugin.task.multi.TabManager;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.commons.collections4.CollectionUtils;

public class QueryListPlugin
extends ReportQueryBasePlugin
implements HyperLinkClickListener,
SetFilterListener,
MainPage,
TabCloseListener {
    private static final Log log = LogFactory.getLog(QueryListPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap1");
        billList.addSetFilterListener((SetFilterListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setCache("cache_tab", this.isFromTargetCusReport() ? "tab_dimset" : "tab_myinterest");
        this.addListPanelListener();
        this.addItemClickListeners(new String[]{"tbmain", "floatmenuap"});
        this.addTabListeners();
    }

    private void addTabListeners() {
        Tab reporttab = (Tab)this.getControl("reporttab");
        if (reporttab != null) {
            reporttab.addTabSelectListener(this::tabReportSelected);
            reporttab.addTabCloseListener(this::tabClose);
        }
    }

    private void tabReportSelected(TabSelectEvent tabSelectEvent) {
        String nodeId = this.getCacheCurrentNode();
        if (!nodeId.equalsIgnoreCase(tabSelectEvent.getTabKey())) {
            this.fireClickTreeNodeAndFocus(tabSelectEvent.getTabKey());
        }
    }

    public void afterCreateNewData(EventObject e) {
        String tabKey = this.isFromTargetCusReport() ? "tab_dimset" : "tab_myinterest";
        this.setCache("cache_tab", tabKey);
        this.initShowPanelStatus();
        String pkIdFromMessCenter = this.getPkIdFromMessCenter();
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)pkIdFromMessCenter)) {
            this.getView().getFormShowParameter().setAppId("bgm");
            String[] pkId = pkIdFromMessCenter.split("/");
            String modelId = pkId[0];
            this.setCache("KEY_MODEL_ID", modelId);
            String flagid = pkId[3];
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_reportshare", (String)"id,data", (QFilter[])new QFilter[]{new QFilter("flagid", "=", (Object)flagid)});
            if (dynamicObject == null) {
                return;
            }
            this.setCache("curNodeId", dynamicObject.getString("id"));
            return;
        }
        String tarPkId = this.getPkIdFromTargetData();
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)tarPkId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_schemesaveas", "selectscheme"});
            this.setCache("cache_tar_scheme_first", "scheme");
            this.setCache("templatetype", BgTemplateTypeEnum.DYNAMIC.getNumber());
            this.setCache("isreport", "1");
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatelistpanelap", "btn_schemesaveas", "selectscheme", "flexpanelap6"});
        this.setBtnVisiable("tab_myinterest", Boolean.TRUE);
        this.switchShowLeftPanel(true);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("click".equals(eventName) && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)e.getEventArgs())) {
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)e.getEventArgs())) {
                return;
            }
            this.getView().hideLoading(true);
            CustomTreeNode customTreeNode = this.getCustomEventNode(e);
            if (customTreeNode != null) {
                this.setCache("curNodeId", customTreeNode.getId());
                if ("report".equals(customTreeNode.getCategory()) || "report-share".equals(customTreeNode.getCategory()) || "report-public".equals(customTreeNode.getCategory())) {
                    if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                        return;
                    }
                    TreeNodeEvent event = new TreeNodeEvent((Object)"click", (Object)"", (Object)customTreeNode.getId());
                    this.clickTreeNode(event);
                } else if ("dim-category".equals(customTreeNode.getCategory())) {
                    if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                        return;
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"treepanelswitchpanelrpt"});
                    this.showTarget(customTreeNode);
                } else {
                    if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                        return;
                    }
                    if ("tab_myinterest".equals(this.getCache("cache_tab"))) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"myinterestpanel"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatelistpanelap", "accountpanel", "myreportlistpanel"});
                        Boolean isShare = "share-category".equals(customTreeNode.getCategory());
                        String shareSign = "";
                        if (isShare.booleanValue()) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"billlistap2"});
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"billlistap1"});
                            shareSign = "share";
                        } else {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"billlistap2"});
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"billlistap1"});
                        }
                        Set childId = customTreeNode.getChildId(true);
                        this.isShowBillList(true);
                        QFilter qFilter = null;
                        if (CollectionUtils.isNotEmpty((Collection)childId)) {
                            qFilter = new QFilter("reportcatalog", "in", (Object)childId);
                            this.refreshBillList(qFilter, shareSign);
                            this.setCache("longNumber", customTreeNode.getLongnumber());
                            this.setCache("curNode", JSONObject.toJSONString((Object)customTreeNode));
                        }
                        this.setBtnVisiable("tab_myinterest", Boolean.TRUE);
                    } else {
                        this.setBtnVisiable("", true);
                        this.isShowBillList(true);
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountpanel"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatelistpanelap", "myinterestpanel", "myreportlistpanel"});
                        this.refreshDimSetList();
                    }
                }
            }
        } else if ("closeTab".equals(eventName)) {
            this.closeTab(e.getEventArgs());
        } else if ("closeTabs".equals(eventName)) {
            ArrayList<String> keys = new ArrayList<String>(16);
            Object keys_obj = JSONUtils.parse((String)e.getEventArgs(), Object.class);
            if (keys_obj instanceof List) {
                List key_list = (List)keys_obj;
                for (Object item : key_list) {
                    Object id_obj;
                    if (!(item instanceof Map) || (id_obj = ((Map)item).get("id")) == null) continue;
                    keys.add(String.valueOf(id_obj));
                }
            }
            if (CollectionUtils.isNotEmpty(keys)) {
                this.setCache("needCloseId", JSONObject.toJSONString(keys));
            }
        } else if ("edit".equals(eventName)) {
            CustomTreeNode customEventNode = this.getCustomEventNode(e);
            if (customEventNode == null) {
                return;
            }
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)customEventNode.getCategory()) && customEventNode.getCategory().startsWith("report")) {
                if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                    return;
                }
                if (customEventNode.getCategory().equals("report-public") || this.isCatalog(customEventNode) && StringUtils.isNotEmpty((String)customEventNode.getLongnumber()) && customEventNode.getLongnumber().startsWith("root.02_sys")) {
                    this.checkPermission(this.getView(), "public_update");
                } else {
                    this.checkPermission(this.getView(), "edit");
                }
                this.openReportQueryForm("baseinfo_close", customEventNode, "edit");
            }
        } else if ("remove".equals(eventName)) {
            Optional<TabInfo> first;
            CustomTreeNode customEventNode = this.getCustomEventNode(e);
            if (customEventNode == null) {
                return;
            }
            if (!kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)customEventNode.getCategory()) || !customEventNode.getCategory().startsWith("report")) {
                return;
            }
            if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                return;
            }
            if (customEventNode.getCategory().equals("report-public") || this.isCatalog(customEventNode) && StringUtils.isNotEmpty((String)customEventNode.getLongnumber()) && customEventNode.getLongnumber().startsWith("root.02_sys")) {
                this.checkPermission(this.getView(), "public_update");
            } else {
                this.checkPermission(this.getView(), "remove");
            }
            if (this.isHaveShareRecord(customEventNode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5206\u4eab\u8bb0\u5f55\uff0c\u65e0\u6cd5\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_99", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            TabManager tabManager = this.getTabManager("tab_myinterest");
            if (tabManager != null && (first = tabManager.getTabs().stream().filter(x -> x.getTabKey().equals(customEventNode.getId())).findFirst()).isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5df2\u6253\u5f00\u8bf7\u5173\u95ed\u540e\u518d\u5220\u9664\u3002", (String)"ReportQueryProcess_104", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setCache("removeReport", customEventNode.getId());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff1f", (String)"ReportQueryProcess_105", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("uninterest_comfirm", (IFormPlugin)this));
        } else if ("addReport".equals(eventName)) {
            CustomTreeNode customEventNode = this.getCustomEventNode(e);
            if (customEventNode == null) {
                return;
            }
            if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                return;
            }
            if (customEventNode.getCategory().equals("report-public") || this.isCatalog(customEventNode) && StringUtils.isNotEmpty((String)customEventNode.getLongnumber()) && customEventNode.getLongnumber().startsWith("root.02_sys")) {
                this.checkPermission(this.getView(), "public_update");
            } else {
                this.checkPermission(this.getView(), "btn_saveasinterest");
            }
            long userSelectDatasetId = UserSelectUtils.getUserSelectDatasetId((IFormView)this.getView(), (long)this.getModelId());
            if (IDUtils.isNull((long)userSelectDatasetId)) {
                DynamicObject dynamicObject = DataSetServiceHelper.loadDefault((Long)this.getModelId());
                if (dynamicObject == null) {
                    log.info("\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u9ed8\u8ba4\u6570\u636e\u96c6");
                    return;
                }
                userSelectDatasetId = dynamicObject.getLong("id");
            }
            String name = ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"ReportQueryProcess_52", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showLoading(new LocaleString(name));
            String formId = "eb_reportquery";
            BaseShowParameter showParam = new BaseShowParameter();
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("operate", "add");
            showParam.setFormId(formId);
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            String caption = "";
            params.put("templateid", IDUtils.toString((Object)userSelectDatasetId));
            ShareSettingDto shareSettingDto = new ShareSettingDto();
            this.setShareQuerySettingValue(shareSettingDto);
            params.put("querysetting", SerializationUtils.toJsonString((Object)shareSettingDto));
            showParam.setStatus(OperationStatus.ADDNEW);
            params.put("addReportNode", JSONObject.toJSONString((Object)customEventNode));
            params.put("addReport", "true");
            caption = ResManager.loadKDString((String)"\u65b0\u589e\u62a5\u8868", (String)"ReportQueryProcess_106", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            showParam.setCaption(caption);
            StyleCss css = new StyleCss();
            css.setWidth("480px");
            css.setHeight("400px");
            showParam.getOpenStyle().setInlineStyleCss(css);
            String model = this.getCache("KEY_MODEL_ID");
            params.put("modelid", model);
            params.put("user", String.valueOf(this.getUserId()));
            params.put("templatetype", "1");
            showParam.setCustomParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "interest_close");
            showParam.setCloseCallBack(closeCallBack);
            this.getView().hideLoading(true);
            this.getView().showForm((FormShowParameter)showParam);
        } else if ("start".equals(eventName)) {
            CustomTreeNode customEventNode = this.getCustomEventNode(e);
            if (customEventNode == null) {
                return;
            }
            boolean isShareNode = "report-share".equals(customEventNode.getCategory());
            boolean isPublickNode = "report-public".equals(customEventNode.getCategory());
            if (isShareNode || isPublickNode) {
                DynamicObject query;
                if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                    return;
                }
                if (isShareNode) {
                    this.checkPermission(this.getView(), "btn_start");
                } else {
                    this.checkPermission(this.getView(), "public_update");
                }
                String name = ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"ReportQueryProcess_52", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showLoading(new LocaleString(name));
                String formId = "eb_reportquery";
                BaseShowParameter showParam = new BaseShowParameter();
                HashMap<String, String> params = new HashMap<String, String>(16);
                params.put("operate", isShareNode ? "sharestart" : "publicstart");
                showParam.setFormId(formId);
                showParam.getOpenStyle().setShowType(ShowType.Modal);
                String caption = "";
                params.put("id", customEventNode.getId());
                String querySetting = "";
                String entityName = "eb_reportquery";
                if (isShareNode) {
                    entityName = "eb_reportshare";
                }
                if ((query = QueryServiceHelper.queryOne((String)entityName, (String)"querysetting,data", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)customEventNode.getId()))})) == null) {
                    return;
                }
                params.put("TemplateModel", query.getString("data"));
                querySetting = query.getString("querysetting");
                ShareSettingDto shareSettingDto = new ShareSettingDto();
                if (StringUtils.isNotEmpty((String)querySetting)) {
                    shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)querySetting, ShareSettingDto.class);
                }
                params.put("addReport", "true");
                this.setShareQuerySettingValue(shareSettingDto);
                params.put("querysetting", SerializationUtils.toJsonString((Object)shareSettingDto));
                showParam.setStatus(OperationStatus.ADDNEW);
                caption = ResManager.loadKDString((String)"\u6536\u85cf-\u62a5\u8868\u4fe1\u606f", (String)"ReportQueryProcess_115", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                showParam.setCaption(caption);
                StyleCss css = new StyleCss();
                css.setWidth("480px");
                css.setHeight("400px");
                showParam.getOpenStyle().setInlineStyleCss(css);
                String model = this.getCache("KEY_MODEL_ID");
                params.put("modelid", model);
                params.put("user", String.valueOf(this.getUserId()));
                params.put("templatetype", "1");
                showParam.setCustomParams(params);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "startCloseCallBack");
                showParam.setCloseCallBack(closeCallBack);
                this.getView().hideLoading(true);
                this.getView().showForm((FormShowParameter)showParam);
            }
        } else if ("unStart".equals(eventName)) {
            CustomTreeNode customEventNode = this.getCustomEventNode(e);
            if (customEventNode == null) {
                return;
            }
            if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                return;
            }
            boolean isShareNode = "report-share".equals(customEventNode.getCategory());
            boolean isPublickNode = "report-public".equals(customEventNode.getCategory());
            if (isShareNode || isPublickNode) {
                if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
                    return;
                }
                if (isShareNode) {
                    this.checkPermission(this.getView(), "btn_start");
                } else {
                    this.checkPermission(this.getView(), "public_update");
                }
                this.setCache("unStart", customEventNode.getId());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u5df2\u88ab\u6536\u85cf\uff0c\u82e5\u4f60\u9009\u62e9\u53d6\u6d88\u6536\u85cf\uff0c\u8be5\u62a5\u8868\u5c06\u4ece\u4f60\u7684\u79c1\u6709\u5206\u7c7b\u4e2d\u79fb\u9664\u3002", (String)"ReportQueryProcess_110", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unstart_comfirm", (IFormPlugin)this));
            }
        }
    }

    private void showTarget(CustomTreeNode customTreeNode) {
        boolean tarSchemeFirstFlag = StringUtils.isNotEmpty((String)this.getCache("cache_tar_scheme_first"));
        if (tarSchemeFirstFlag) {
            if (!this.isLeftTreeLocked()) {
                this.switchShowLeftPanel(false);
            }
            if (tarSchemeFirstFlag) {
                this.clearCache("cache_tar_scheme_first");
            }
        }
        this.setBtnVisiable("tab_dimset", false);
        this.isShowBillList(false);
        this.setShowDimPanel(true);
        this.clearCache(null, "viewId");
        this.setCache("dataset", customTreeNode.getId());
        ReportQueryHelper.initReportContent(this.getView());
        this.showInContainerDesigner(null, false, Boolean.TRUE);
        this.handleTab2DataSet(customTreeNode);
        this.isShowAllDimPanel(true);
        this.getView().updateView();
    }

    public void refreshDimSetList() {
        BillList billList = (BillList)this.getView().getControl("billlistap4");
        QFilter filter = this.dataDimFilter();
        billList.setFilter(filter);
        billList.setClearSelection(true);
        billList.setOrderBy("\"createtime asc\"");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        if (e.getSource() instanceof BillList) {
            BillList billList = (BillList)e.getSource();
            String currTab = this.getCache("cache_tab");
            String currNodeId = this.getCacheCurrentNode();
            if ("tab_dimset".equals(currTab) && "billlistap4".equals(billList.getKey())) {
                e.getQFilters().add(this.dataDimFilter());
            } else if ("tab_myinterest".equals(currTab)) {
                if ("billlistap2".equals(billList.getKey())) {
                    QFilter qFilter5 = new QFilter("receiver", "=", (Object)ReportQueryHelper.getUserId());
                    QFilter qFilter6 = new QFilter("sharestatus", "=", (Object)"A");
                    QFilter qFilter7 = new QFilter("modelid", "=", (Object)this.getModelId());
                    e.getQFilters().add(qFilter5.and(qFilter6).and(qFilter7));
                } else {
                    e.getQFilters().add(this.getInterestFilter(currNodeId));
                    e.setOrderBy("reportcatalog,sequence");
                }
            }
        } else {
            return;
        }
    }

    public QFilter getInterestFilter(String nodeId) {
        QFilter qFilter = null;
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)nodeId)) {
            CustomTreeNode cacheTree = this.getCacheTree();
            if (cacheTree == null) {
                return qFilter;
            }
            CustomTreeNode treeNode = cacheTree.getTreeNode(nodeId, 10);
            Set childId = treeNode.getChildId(true);
            this.isShowBillList(true);
            if (CollectionUtils.isNotEmpty((Collection)childId)) {
                qFilter = new QFilter("reportcatalog", "in", (Object)childId);
                this.setCache("longNumber", treeNode.getLongnumber());
                this.setCache("curNode", JSONObject.toJSONString((Object)treeNode));
            }
        }
        return qFilter;
    }

    private QFilter dataDimFilter() {
        String selectFields = "id,parent";
        QFilter fmodelid = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"eb_datasetcatalog", (String)selectFields, (QFilter[])new QFilter[]{fmodelid});
        String currId = this.getCacheCurrentNode();
        ArrayList<String> dataDimChildIds = new ArrayList<String>();
        ReportQueryHelper.getDataDimChilds(currId, docs, dataDimChildIds);
        QFilter dataDimFilter = new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)currId));
        if (dataDimChildIds.size() > 0) {
            dataDimFilter = dataDimFilter.or(new QFilter("catalog", "in", ReportQueryHelper.getLongList(dataDimChildIds)));
        }
        if (this.isFromTargetCusReport()) {
            List<Long> dataSetIds = this.getDataSetIdsByTarget();
            dataDimFilter.and(new QFilter("id", "in", dataSetIds));
        }
        return dataDimFilter;
    }

    private void isShowAllDimPanel(Boolean isShowAll) {
        this.getView().setVisible(isShowAll, new String[]{"eb_dopanel", "eb_rowcoldimpanel", "pagetitlepanel"});
    }

    private void handleTab2DataSet(CustomTreeNode curNode) {
        String reportTabKey;
        String tabKey = this.getCache("cache_tab");
        TabManager tabManager = this.getTabManager(tabKey);
        TabInfo tabInfo = tabManager.searchTab(reportTabKey = curNode.getId());
        if (tabInfo == null) {
            tabInfo = new TabInfo(reportTabKey, curNode.getName());
            tabManager.addTabInfo(tabInfo);
        }
        tabManager.setSelectTabInfo(reportTabKey);
        Tab reporttab = (Tab)this.getControl("reporttab");
        reporttab.activeTab(reportTabKey);
        this.refreReportTab(tabManager);
        this.cacheTabManager(tabKey);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("uninterest_comfirm")) {
            this.uninterestConfirmCallBack(messageBoxClosedEvent);
        } else if (callBackId.equals("unstart_comfirm") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            String unStart = this.getCache("unStart");
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)unStart)) {
                QFilter qFilter = new QFilter("creator", "=", (Object)UserUtils.getUserId());
                qFilter.and("sourceid", "=", (Object)IDUtils.toLong((Object)unStart));
                DeleteServiceHelper.delete((String)"eb_reportquery", (QFilter[])new QFilter[]{qFilter});
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf\u6210\u529f", (String)"ReportQueryProcess_113", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("collection", new MultiLangEnumBridge("\u53d6\u6d88\u6536\u85cf", "ReportQueryProcess_114", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d6\u6d88\u6536\u85cf\u6210\u529f", "ReportQueryProcess_113", "epm-eb-formplugin"));
            this.clearCache("unStart");
            this.refreshCustomTree();
        }
    }

    private void uninterestConfirmCallBack(MessageBoxClosedEvent mbce) {
        if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            String nodeid = this.getCache("removeReport");
            if (StringUtils.isEmpty((String)nodeid)) {
                return;
            }
            DeleteServiceHelper.delete((String)"eb_reportquery", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)nodeid))});
            ReportQueryHelper.deleleUserQuerySchemeDy(this.getUserId(), this.getModelId(), IDUtils.toLong((Object)nodeid), true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"ReportQueryProcess_79", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.clearCache("removeReport");
            this.removeReportTab(IDUtils.toLong((Object)nodeid));
            this.refreshCustomTree();
        }
    }

    public boolean isHaveShareRecord(CustomTreeNode node) {
        HashMap map = (HashMap)node.getData();
        if (map == null || map.isEmpty()) {
            return false;
        }
        String number = (String)map.get("number");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("modelid", "=", (Object)this.getModelId()));
        filters.add(new QFilter("sharers", "=", (Object)UserUtils.getUserId()));
        filters.add(new QFilter("number", "=", (Object)number));
        filters.add(new QFilter("templatetype", "not in", (Object)new String[]{"M", "E"}));
        return QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])filters.toArray(new QFilter[0]));
    }

    private void openReportQueryForm(String callBackId, CustomTreeNode customTreeNode, String operate) {
        if (customTreeNode == null) {
            return;
        }
        CustomTreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return;
        }
        CustomTreeNode parentNode = cacheTree.getTreeNode(customTreeNode.getParentId(), 10);
        String formId = "eb_reportquery";
        BaseShowParameter showParam = new BaseShowParameter();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("operate", operate);
        showParam.setFormId(formId);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        String caption = "";
        params.put("id", customTreeNode.getId());
        showParam.setPkId((Object)customTreeNode.getId());
        showParam.setStatus(OperationStatus.EDIT);
        caption = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"ReportQueryProcess_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        params.put("addReportNode", JSONObject.toJSONString((Object)parentNode));
        params.put("addReport", "true");
        showParam.setCaption(caption);
        StyleCss css = new StyleCss();
        css.setWidth("480px");
        css.setHeight("400px");
        showParam.getOpenStyle().setInlineStyleCss(css);
        String model = this.getCache("KEY_MODEL_ID");
        params.put("modelid", model);
        params.put("user", String.valueOf(this.getUserId()));
        params.put("templatetype", "1");
        showParam.setCustomParams(params);
        if (!StringUtils.isEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParam.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)showParam);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "baseinfo_close": {
                ArrayList ids;
                if (evt.getReturnData() == null || !evt.getReturnData().toString().contains("success")) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4fee\u6539\u6210\u529f\u3002", (String)"ReportQueryProcess_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                Map returnData = (Map)evt.getReturnData();
                Object id = returnData.get("id");
                if (!(id instanceof ArrayList) || !CollectionUtils.isNotEmpty((Collection)(ids = (ArrayList)id))) break;
                this.refreshCustomTree(true);
                break;
            }
            case "interest_close": {
                Object returnData = evt.getReturnData();
                if (returnData == null) {
                    return;
                }
                Map result = (Map)returnData;
                if (!result.containsKey("result") || !"success".equals(result.get("result"))) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"ReportQueryProcess_107", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "ReportQueryProcess_80", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f", "ReportQueryProcess_107", "epm-eb-formplugin"));
                Object id = result.get("id");
                if (id != null) {
                    List ids = (List)id;
                    this.setCache("curNodeId", ids.get(0) + "");
                }
                this.refreshCustomTree();
                break;
            }
            case "startCloseCallBack": {
                Object returnData = evt.getReturnData();
                if (returnData == null) {
                    return;
                }
                Map result = (Map)returnData;
                if (!result.containsKey("result") || !"success".equals(result.get("result"))) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f", (String)"ReportQueryProcess_111", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("collection", new MultiLangEnumBridge("\u6536\u85cf", "ReportQueryProcess_112", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6536\u85cf\u6210\u529f", "ReportQueryProcess_111", "epm-eb-formplugin"));
                this.refreshCustomTree();
                break;
            }
        }
    }

    private void refreshBillList(QFilter qFilter, String shareSingle) {
        QFilter myQfilter = null;
        BillList billList = null;
        if ("share".equals(shareSingle)) {
            QFilter qFilter1 = new QFilter("receiver", "=", (Object)ReportQueryHelper.getUserId());
            QFilter qFilter2 = new QFilter("sharestatus", "=", (Object)"A");
            QFilter qFilter3 = new QFilter("modelid", "=", (Object)this.getModelId());
            QFilter qFilter4 = new QFilter("templatetype", "not in", (Object)new String[]{"M", "E"});
            myQfilter = qFilter1.and(qFilter2).and(qFilter3).and(qFilter4);
            billList = (BillList)this.getView().getControl("billlistap2");
        } else {
            billList = (BillList)this.getView().getControl("billlistap1");
            myQfilter = qFilter;
        }
        billList.setFilter(myQfilter);
        billList.setClearSelection(true);
        billList.setOrderBy("number,createtime asc");
        billList.refresh();
    }

    private void addListPanelListener() {
        BillList billlistap1 = (BillList)this.getControl("billlistap1");
        BillList billlistap2 = (BillList)this.getControl("billlistap2");
        BillList billlistap4 = (BillList)this.getControl("billlistap4");
        billlistap1.addHyperClickListener((HyperLinkClickListener)this);
        billlistap2.addHyperClickListener((HyperLinkClickListener)this);
        billlistap4.addHyperClickListener((HyperLinkClickListener)this);
        billlistap1.addSetFilterListener((SetFilterListener)this);
        billlistap2.addSetFilterListener((SetFilterListener)this);
        billlistap4.addSetFilterListener((SetFilterListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        String currTab = this.getCache("cache_tab");
        if ("tab_dimset".equals(currTab)) {
            String node = null;
            BillList billListap = (BillList)this.getControl("billlistap4");
            ListSelectedRow selectedRow = billListap.getCurrentSelectedRowInfo();
            node = selectedRow.getPrimaryKeyValue().toString();
            TreeNodeEvent event = new TreeNodeEvent((Object)"dim", (Object)"", (Object)node);
            if (this.isFromTargetCusReport() || kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)this.getPkIdFromMessCenter())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"treepanelswitchpanelrpt"});
            }
            this.clickTreeNode(event);
        } else {
            String node = null;
            String curLongNumber = this.getCache("longNumber");
            BillList billListap = (BillList)this.getControl("billlistap1");
            if (ReportCustomTreeBuilder.isShareNode((String)curLongNumber)) {
                billListap = (BillList)this.getControl("billlistap2");
            }
            ListSelectedRow selectedRow = billListap.getCurrentSelectedRowInfo();
            node = selectedRow.getPrimaryKeyValue().toString();
            TreeNodeEvent event = new TreeNodeEvent((Object)"click", (Object)"", (Object)node);
            this.clickTreeNode(event);
        }
    }

    private void setBtnVisiable(String tabKey, Boolean isList) {
        IFormView view = this.getView();
        if (isList.booleanValue()) {
            view.setVisible(Boolean.valueOf(false), new String[]{"btn_interest", "btn_share", "btn_sharerecord", "btn_baseinfo", "btn_attachement", "exportdata", "show_dimname", "metricdisplay", "showsetting", "btn_querysetting", "btn_close", "btn_exit1", "btn_expendrow", "btn_shrinkrow", "btn_schemesaveas", "selectscheme"});
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_exit", "btn_refresh", "move", "btn_listshare", "btn_listsharerecord"});
            String curLongNumber = this.getCache("longNumber");
            if (ReportCustomTreeBuilder.isShareNode((String)curLongNumber) || this.isFromTargetCusReport()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"move"});
            }
        } else {
            if (this.isFromTargetCusReport()) {
                view.setVisible(Boolean.valueOf(true), new String[]{"exportdata", "show_dimname", "metricdisplay", "showsetting", "btn_schemesaveas", "selectscheme", "btn_close", "btn_exit1", "btn_expendrow", "btn_shrinkrow"});
                view.setEnable(Boolean.valueOf(true), new String[]{"btn_schemesaveas", "selectscheme"});
                view.setVisible(Boolean.valueOf(false), new String[]{"btn_interest", "btn_baseinfo", "btn_uninterest", "btn_share", "btn_sharerecord", "btn_saveasinterest", "btn_attachement", "btn_querysetting", "btn_exit"});
            } else {
                view.setVisible(Boolean.valueOf(true), new String[]{"btn_baseinfo", "btn_interest", "btn_uninterest", "btn_refresh", "btn_share", "btn_sharerecord", "btn_saveasinterest", "exportdata", "show_dimname", "metricdisplay", "showsetting", "btn_close", "btn_exit1", "btn_expendrow", "btn_shrinkrow"});
                view.setEnable(Boolean.valueOf(true), new String[]{"btn_uninterest"});
                view.setVisible(Boolean.valueOf(false), new String[]{"btn_attachement", "btn_querysetting", "btn_exit", "btn_schemesaveas", "selectscheme"});
            }
            view.setVisible(Boolean.valueOf(false), new String[]{"move", "btn_listshare", "btn_listsharerecord"});
        }
    }

    public void clickTreeNode(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.setCache("curNodeId", nodeId);
        CustomTreeNode allTree = this.getCacheTree();
        if (allTree == null) {
            return;
        }
        CustomTreeNode curNode = allTree.getTreeNode(nodeId, 10);
        this.clearCache("TemplateModel");
        this.clearCache("dataset");
        this.clearCache("cache_f7key_dim_map");
        this.clearCache("cache_BizModel_dims");
        this.clearCache("reportqueryid");
        if (curNode == null) {
            return;
        }
        if (this.isCatalog(curNode)) {
            this.setBtnVisiable("tab_myinterest", false);
            this.isShowBillList(true);
            Set childId = curNode.getChildId(true);
            QFilter qFilter = null;
            if (CollectionUtils.isNotEmpty((Collection)childId)) {
                qFilter = new QFilter("reportcatalog", "in", (Object)childId);
                this.refreshBillList(qFilter, "");
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"treepanelswitchpanelrpt"});
            if (this.isFromTargetCusReport()) {
                this.showTarget(curNode);
            } else {
                this.setBtnVisiable("tab_myinterest", false);
                this.isShowBillList(false);
                this.myInterestNodeClick(evt, curNode);
            }
        }
        boolean tarSchemeFirstFlag = kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)this.getCache("cache_tar_scheme_first"));
        if (!(this.isCatalog(curNode) || StringUtils.isEmpty((String)evt.getSource().toString()) && !tarSchemeFirstFlag)) {
            if (!this.isLeftTreeLocked()) {
                this.switchShowLeftPanel(false);
            }
            if (tarSchemeFirstFlag) {
                this.clearCache("cache_tar_scheme_first");
            }
        }
    }

    private void myInterestNodeClick(TreeNodeEvent evt, CustomTreeNode customTreeNode) {
        if (customTreeNode == null) {
            return;
        }
        this.treeFocusId(customTreeNode.getId());
        this.setCache("reportqueryid", customTreeNode.getId());
        this.setShowDimPanel(true);
        ReportQueryHelper.initReportContent(this.getView());
        this.showReport(customTreeNode);
        String templatemodleCache = this.getCache("TemplateModel");
        if (!kd.epm.eb.common.utils.StringUtils.isEmpty((String)templatemodleCache)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"eb_dopanel"});
        }
    }

    private void setShowDimPanel(Boolean isShow) {
        if (!isShow.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.setCache("cache_dimcontent_visiable", "0");
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"eb_dimcontentpanel"});
            this.setCache("cache_dimcontent_visiable", "1");
        }
    }

    private void isShowBillList(Boolean isShow) {
        IFormView view = this.getView();
        view.setVisible(isShow, new String[]{"billlistpanel"});
        view.setVisible(Boolean.valueOf(isShow == false), new String[]{"reportpanel", "floatmenuap", "flexpanelap6"});
        if (!isShow.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"eb_dimcontentpanel"});
            this.setCache("cache_dimcontent_visiable", "1");
        }
    }

    private void showReport(CustomTreeNode node) {
        this.enableAllReportToolbar();
        Map dataMap = node.getData();
        if (!dataMap.containsKey("templatetype")) {
            return;
        }
        if (dataMap.containsKey("customdimfielter")) {
            this.setCache("customdimfielter", dataMap.get("customdimfielter").toString());
        } else {
            this.clearCache("customdimfielter");
        }
        String datasetId = dataMap.containsKey("dataset") ? (String)dataMap.get("dataset") : "0";
        this.setCache("dataset", datasetId);
        String rptQueryId = node.getId();
        this.setCache("curNodeId", rptQueryId);
        if (dataMap.containsKey("sharers")) {
            this.loadReportById(rptQueryId, "eb_reportshare");
        } else {
            this.loadReportById(rptQueryId, "eb_reportquery");
        }
    }

    private void loadReportById(Object reportQueryId, String baseFormId) {
        DynamicObject rptQueryDy = BusinessDataServiceHelper.loadSingle((Object)reportQueryId, (String)baseFormId);
        String templateType = kd.epm.eb.common.utils.StringUtils.isEmpty((String)rptQueryDy.getString("templatetype")) ? "1" : rptQueryDy.getString("templatetype");
        String isReport = "1";
        BgTemplate templateBaseInfo = this.getBaseInfoByTemplate(rptQueryDy);
        this.handleTab2DyReport(templateBaseInfo);
        ITemplateModel templateModel = null;
        String data = (String)rptQueryDy.get("data");
        Long bizModel = 0L;
        templateModel = !StringUtils.isEmpty((String)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel();
        if (templateModel != null && templateModel.getTemplateBaseInfo() != null) {
            bizModel = templateModel.getTemplateBaseInfo().getBizModel();
        }
        templateBaseInfo.setBizModel(bizModel);
        if (rptQueryDy.containsProperty("querysetting") && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)rptQueryDy.getString("querysetting"))) {
            ShareSettingDto shareSettingDto = new ShareSettingDto();
            String string = rptQueryDy.getString("querysetting");
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)string) && (shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)string, ShareSettingDto.class)) != null && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)shareSettingDto.getDataUnit())) {
                String dataUnit = shareSettingDto.getDataUnit();
                templateBaseInfo.setDataunit(dataUnit.substring(dataUnit.length() - 1, dataUnit.length()));
            }
            this.setCache("querysetting" + reportQueryId, rptQueryDy.getString("querysetting"));
            log.info("querySetting isNotEmpty.");
        } else {
            this.setCache("querysetting" + reportQueryId, SerializationUtils.toJsonString((Object)new ShareSettingDto()));
            log.info("querySetting isEmpty.");
        }
        if (templateModel != null) {
            templateModel.setTemplateBaseInfo(templateBaseInfo);
            this.setReportCache(templateType, isReport, templateModel, data, templateBaseInfo);
        }
        this.cacheDimViews(templateModel);
        boolean isShareNode = baseFormId.equals("eb_reportshare");
        this.showInContainerDesigner(templateModel, isShareNode, kd.epm.eb.common.utils.StringUtils.isEmpty((String)data));
    }

    @Override
    protected void beforeShowDesigner(String pageId, boolean isFloatForm) {
        IFormView view = this.getView().getView(this.getCache("floatDesignerPageId"));
        if (view != null) {
            this.setCache("isNoExecuteShowInDesigner", "1");
            view.close();
            this.getView().sendFormAction(view);
            this.clearCache("isNoExecuteShowInDesigner");
        }
        if (isFloatForm) {
            this.setCache("floatDesignerPageId", pageId);
        }
    }

    private void setReportCache(String templateType, String isReport, ITemplateModel templateModel, String data, BgTemplate templateBaseInfo) {
        this.setCache("templatetype", templateType);
        this.setCache("isreport", isReport);
        this.setCache("bgtemplate_info", ObjectSerialUtil.toByteSerialized((Object)templateBaseInfo));
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)data)) {
            this.setCache("TemplateModel", TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        } else {
            this.clearCache("TemplateModel");
        }
    }

    private void cacheDimViews(ITemplateModel templateModel) {
        this.clearCache(null, "viewId");
        Object dimViews = null;
        if (templateModel != null && templateModel.getDimemsionViews() != null && templateModel.getDimemsionViews().size() > 0) {
            for (Map.Entry entry : templateModel.getDimemsionViews().entrySet()) {
                String viewId;
                String[] keySplit = ((String)entry.getKey()).split("_");
                String dimNumber = keySplit[0];
                String string = viewId = entry.getValue() == null ? null : String.valueOf(entry.getValue());
                if (keySplit.length == 1) {
                    this.setCache(this.getControlKeyByDimNum(dimNumber, "page") + "viewId", viewId);
                    continue;
                }
                if (keySplit.length <= 1) continue;
                if (keySplit[1] != null && keySplit[1].startsWith("c")) {
                    this.setCache(this.getControlKeyByDimNum(dimNumber, "col") + "viewId", viewId);
                    continue;
                }
                if (keySplit[1] == null || !keySplit[1].startsWith("r")) continue;
                this.setCache(this.getControlKeyByDimNum(dimNumber, "row") + "viewId", viewId);
            }
        }
    }

    String getControlKeyByDimNum(String dimNum, String suffix) {
        String controlKey = "";
        Map<Object, Object> f7KeyMap = new LinkedHashMap(16);
        f7KeyMap = this.getCache("cache_f7key_dim_map") != null ? (Map)ObjectSerialUtil.deSerializedBytes((String)this.getCache("cache_f7key_dim_map")) : this.getAllF7Map(true);
        if (f7KeyMap.size() > 0) {
            for (Map.Entry<Object, Object> f7Key : f7KeyMap.entrySet()) {
                if (!dimNum.equalsIgnoreCase((String)f7Key.getValue())) continue;
                controlKey = (String)f7Key.getKey() + "_" + suffix;
            }
        }
        return controlKey;
    }

    private List<String> getBizModelDims() {
        QFilter dimFilter;
        String dimFields;
        DynamicObjectCollection dataSetDimDys;
        List<String> dimsList = new ArrayList<String>(16);
        if (this.getCache("cache_BizModel_dims") != null) {
            dimsList = (List)SerializationUtils.fromJsonString((String)this.getCache("cache_BizModel_dims"), List.class);
        } else if (!StringUtils.isEmpty((String)this.getCache("dataset")) && (dataSetDimDys = QueryServiceHelper.query((String)"eb_dataset", (String)(dimFields = "entryentity.datasetdim.id as dimid,entryentity.datasetdim.number as dimnum,entryentity.datasetdim.name as dimname,entryentity.datasetdim.dseq as dseq"), (QFilter[])new QFilter[]{dimFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)this.getCache("dataset")))})) != null && dataSetDimDys.size() > 0) {
            for (DynamicObject dataSetDimDy : dataSetDimDys) {
                dimsList.add(dataSetDimDy.getString("dimnum"));
            }
            if (!dimsList.contains(SysDimensionEnum.Account.getNumber())) {
                dimsList.add(SysDimensionEnum.Account.getNumber());
            }
            String dimsStr = SerializationUtils.toJsonString(dimsList);
            this.setCache("cache_BizModel_dims", dimsStr);
        }
        return dimsList;
    }

    private Map<String, String> getAllF7Map(Boolean isCheckBizmodel) {
        LinkedHashMap<String, String> f7KeyMap = new LinkedHashMap(16);
        if (this.getCache("cache_f7key_dim_map") != null) {
            f7KeyMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getCache("cache_f7key_dim_map"));
        } else {
            List<Object> bizModelDims = new ArrayList(16);
            if (isCheckBizmodel.booleanValue()) {
                bizModelDims = this.getBizModelDims();
            }
            Long modelId = this.getModelId();
            AtomicInteger userdefined_index = new AtomicInteger(1);
            Map dimensionMap = this.getModelCacheHelper().getDimensions();
            for (Dimension dimension : dimensionMap.values()) {
                String dimnumber = dimension.getNumber();
                if (bizModelDims.size() > 0 && !bizModelDims.contains(dimnumber)) continue;
                String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
                boolean isuserdefined = false;
                if ("epm_userdefinedmembertree".equals(memberTreemodel)) {
                    isuserdefined = true;
                }
                String f7key = "ebf7_" + dimnumber.toLowerCase();
                if (isuserdefined) {
                    f7key = "ebf7_customize" + userdefined_index.get();
                    userdefined_index.incrementAndGet();
                }
                f7KeyMap.put(f7key, dimnumber);
            }
            this.setCache("cache_f7key_dim_map", ObjectSerialUtil.toByteSerialized(f7KeyMap));
        }
        return f7KeyMap;
    }

    private void handleTab2DyReport(BgTemplate templateBaseInfo) {
        String reportTabKey;
        String tabKey = this.isFromTargetCusReport() ? "tab_dimset" : "tab_myinterest";
        TabManager tabManager = this.getTabManager(tabKey);
        TabInfo tabInfo = tabManager.searchTab(reportTabKey = templateBaseInfo.getId().toString());
        if (tabInfo == null) {
            tabInfo = new TabInfo(reportTabKey, templateBaseInfo.getName());
            tabManager.addTabInfo(tabInfo);
        }
        tabManager.setSelectTabInfo(reportTabKey);
        Tab reporttab = (Tab)this.getControl("reporttab");
        reporttab.activeTab(reportTabKey);
        this.refreReportTab(tabManager);
        this.cacheTabManager(tabKey);
    }

    private void refreReportTab(String tabKey) {
        TabManager tabManager = this.getTabManager(tabKey);
        if (tabManager != null) {
            this.refreReportTab(tabManager);
        }
    }

    private void refreReportTab(TabManager tabManager) {
        TabAp tabap = new TabAp();
        tabap.setKey("reporttab");
        tabap.setName(new LocaleString("reporttab"));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>(16);
        Iterator<TabInfo> it = tabManager.iterator();
        while (it.hasNext()) {
            TabInfo tab = it.next();
            TabPageAp page = new TabPageAp();
            page.setKey(tab.getTabKey());
            page.setName(new LocaleString(tab.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"ReportQueryProcess_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("reporttab", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(16);
        closeMap.put("closable", true);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
    }

    private BgTemplate getBaseInfoByTemplate(DynamicObject dy) {
        BgTemplate templateBaseInfo = new BgTemplate();
        String formId = dy.getDynamicObjectType().getName();
        Long catalog = 0L;
        long dataSet = 0L;
        if (formId.equalsIgnoreCase("eb_reportquery")) {
            catalog = dy.getDynamicObject("reportcatalog").getLong("id");
            dataSet = dy.getLong("dataset_id");
        } else if (formId.equalsIgnoreCase("eb_reportshare")) {
            catalog = dy.getLong("reportcatalog");
            dataSet = dy.getLong("dataset_id");
        } else if (formId.equalsIgnoreCase("eb_templateentity")) {
            catalog = dy.getDynamicObject("templateCatalog").getLong("id");
            dataSet = dy.getLong("dataset_id");
        }
        templateBaseInfo.setId(Long.valueOf(dy.getLong("id")));
        templateBaseInfo.setName(dy.getString("name"));
        templateBaseInfo.setNumber(dy.getString("number"));
        templateBaseInfo.setDatasetID(Long.valueOf(dataSet));
        if (dy.getDynamicObjectType().getProperties().containsKey((Object)"dataunit")) {
            templateBaseInfo.setDataunit(dy.getString("dataunit"));
        } else {
            templateBaseInfo.setDataunit("0");
        }
        if (dy.getDynamicObjectType().getProperties().containsKey((Object)"varbaseforeb")) {
            templateBaseInfo.setVarBase((String)dy.get("varbaseforeb"));
            this.getPageCache().put("varbaseforeb", (String)dy.get("varbaseforeb"));
        }
        templateBaseInfo.setModelID(IDUtils.toLong((Object)this.getCache("KEY_MODEL_ID")));
        templateBaseInfo.setCatalog(catalog);
        return templateBaseInfo;
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getCache("KEY_MODEL_ID"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelid"));
            if (IDUtils.isNull((Long)modelId)) {
                modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
            }
            if (IDUtils.isNull((Long)modelId)) {
                if (this.checkErrorDisplayed) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"ReportQueryProcess_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.checkErrorDisplayed = false;
                }
            } else {
                this.setCache("KEY_MODEL_ID", modelId.toString());
            }
        }
        return modelId == null ? Long.valueOf(0L) : modelId;
    }

    private void initShowPanelStatus() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportpanel", "templatelistpanelap", "accountpanel", "myinterestpanel", "myreportlistpanel"});
    }

    public void tabClose(TabCloseEvent tabCloseEvent) {
        List tabKeys = tabCloseEvent.getTabKeys();
        if (CollectionUtils.isNotEmpty((Collection)tabKeys)) {
            for (String tabKey : tabKeys) {
                this.closeTab(tabKey);
            }
        } else {
            List list;
            String needCloseId = this.getCache("needCloseId");
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)needCloseId) && CollectionUtils.isNotEmpty((Collection)(list = (List)JSONObject.parseObject((String)needCloseId, List.class)))) {
                for (String tabKey : list) {
                    this.closeTab(tabKey);
                }
            }
            this.clearCache("needCloseId");
        }
    }
}

