/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.template.entity.TemplateTaskDto;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.ReportQueryDesignerConstant;
import kd.epm.eb.common.ebcommon.common.enums.MetricDatatypeEnum;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.report.designer.ShareSettingDto;
import kd.epm.eb.formplugin.report.query.ReportQueryBasePlugin;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.formplugin.report.query.ShareRecordPOJO;
import kd.epm.eb.formplugin.report.query.UserInfoPOJO;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.formplugin.report.reportview.FixReportProcess;
import kd.epm.eb.formplugin.task.multi.TabInfo;
import kd.epm.eb.formplugin.task.multi.TabManager;
import kd.epm.eb.formplugin.template.templateview.DynamicTemplateProcess;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.stylecontroller.SpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.styleset.SheetMetricDimStyleController;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class QueryReportPlugin
extends ReportQueryBasePlugin
implements MainPage,
ReportQueryDesignerConstant,
ItemClickListener {
    private static final Log log = LogFactory.getLog(QueryReportPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ArrayList<String> clickCtrKeys = new ArrayList<String>(Arrays.asList("designer_ok", "designer_cancel", "designer_float", "designer_switchlist", "treepanelswitchrpt"));
        this.addClickListeners(clickCtrKeys.toArray(new String[clickCtrKeys.size()]));
        this.addItemClickListeners(new String[]{"tbmain", "floatmenuap"});
    }

    public void initialize() {
        super.initialize();
        String curRepType = this.getCache("templatetype");
        String isReport = this.getCache("isreport");
        this.initReportPlugin(curRepType, isReport);
    }

    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("dimdesigner".equals(operation)) {
            this.showSettingRpt(com);
        } else if ("close_designer".equals(operation)) {
            this.setShowDimPanel(false);
        } else if ("show_designer".equals(operation)) {
            this.setShowDimPanel(true);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "designer_cancel": {
                this.checkBeforeOperation("designer_cancel");
                break;
            }
            case "designer_ok": {
                this.checkBeforeOperation("designer_ok");
                break;
            }
            case "btn_interest": {
                this.checkBeforeOperation("checkBeforeInterst");
                break;
            }
            case "designer_float": {
                this.toOpenFloatDesigner();
                break;
            }
            case "designer_switchlist": {
                this.checkBeforeOperation("openDesignerListPage");
                break;
            }
            case "treepanelswitchrpt": {
                this.switchShowLeftPanel(true);
                break;
            }
        }
    }

    private void toOpenFloatDesigner() {
        boolean isMyShareNode = Boolean.parseBoolean(this.getCache("isMyShareNode"));
        String operation = isMyShareNode ? "openFloatDesignerShare" : "openFloatDesigner";
        CommandParam commandParam = new CommandParam("eb_reportqueryprocess", "eb_rptquerydesigner", operation, new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_interest": {
                this.checkBeforeOperation("checkBeforeInterst");
                break;
            }
            case "btn_uninterest": {
                this.clickUnInterest();
                break;
            }
            case "btn_saveasinterest": {
                this.checkBeforeOperation("checkBeforeSaveInterest");
                break;
            }
            case "btn_baseinfo": {
                this.openRptQueryInfo("baseinfo_close", "edit");
                break;
            }
            case "btn_share": {
                if (this.judgeIsSaved()) {
                    this.checkBeforeOperation("checkBeforeShare");
                    break;
                }
                this.showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u5206\u4eab\u3002", (String)"ReportQueryProcess_75", (String)"epm-eb-formplugin", (Object[])new Object[0]), itemKey);
                break;
            }
            case "floatmenuitemap": {
                this.setShowDimPanel();
                break;
            }
            case "btn_sharerecord": 
            case "btn_listsharerecord": {
                this.showShareRepordList();
                break;
            }
            case "exportdata": {
                TabInfo tabInfo;
                if (this.dynamicReportProcess == null) break;
                String exportFileName = null;
                TabManager tabManager = this.getTabManager("tab_myinterest");
                exportFileName = tabManager != null && (tabInfo = tabManager.getSelectedTabInfo()) != null ? tabInfo.getTabName() : this.getView().getFormShowParameter().getCaption();
                this.dynamicReportProcess.exportSpread();
                break;
            }
            case "btn_schemesaveas": {
                this.checkBeforeOperation("checkExistRptTarScheme");
                break;
            }
            case "btn_close": {
                this.closeTab(this.getCacheCurrentNode());
                break;
            }
            case "btn_exit1": {
                this.showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5173\u95ed\u5f53\u524d\u6240\u6709\u5df2\u6253\u5f00\u62a5\u8868\u5e76\u9000\u51fa\u5373\u5e2d\u67e5\u8be2\uff1f", (String)"ReportQueryProcess_71", (String)"epm-eb-formplugin", (Object[])new Object[0]), itemKey);
                break;
            }
            case "btn_expendrow": {
                SpreadSelector selector;
                if (this.dynamicReportProcess == null || (selector = this.dynamicReportProcess.getSpreadSelector()) == null) break;
                this.dynamicReportProcess.expandAll(selector.getStartRow(), selector.getStartCol());
                break;
            }
            case "btn_shrinkrow": {
                SpreadSelector selector;
                if (this.dynamicReportProcess == null || (selector = this.dynamicReportProcess.getSpreadSelector()) == null) break;
                this.dynamicReportProcess.collapseAll(selector.getStartRow(), selector.getStartCol());
                break;
            }
            case "metricdisplay": {
                this.showFormMetricDisplay();
                break;
            }
            case "showsetting": {
                this.checkBeforeOperation("checkBeforeSetting");
                break;
            }
            case "move": {
                this.openReportQueryMoveForm();
                break;
            }
            case "btn_listshare": {
                this.handleListShareClick();
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    private void handleListShareClick() {
        CustomTreeNode currentSelectNode = this.getCurrentSelectNode();
        if (currentSelectNode != null) {
            ListSelectedRowCollection selectedRows;
            Boolean isShare = "share-category".equals(currentSelectNode.getCategory());
            BillList billListap = (BillList)this.getControl("billlistap1");
            if (isShare.booleanValue()) {
                billListap = (BillList)this.getControl("billlistap2");
            }
            if ((selectedRows = billListap.getSelectedRows()).size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u5206\u4eab\u7684\u62a5\u8868\u3002", (String)"ReportQueryProcess_116", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> selectIds = new ArrayList<String>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                selectIds.add(IDUtils.toString((Object)selectedRow.getPrimaryKeyValue()));
            }
            HashMap<String, Serializable> shareInfo = new HashMap<String, Serializable>(2);
            shareInfo.put("ids", selectIds);
            shareInfo.put("isShare", isShare);
            if (!isShare.booleanValue()) {
                ArrayList<Long> temp = new ArrayList<Long>(selectIds.size());
                for (String selectId : selectIds) {
                    temp.add(IDUtils.toLong((Object)selectId));
                }
                boolean b = ReportQueryHelper.exitPublicReport(this.getModelId(), temp);
                if (b) {
                    this.checkPermission(this.getView(), "public_update");
                }
            }
            this.getPageCache().put("shareCache", SerializationUtils.toJsonString(shareInfo));
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("bos_user");
            showParameter.setFormId("bos_usertreelistf7");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setHeight("680");
            css.setWidth("1060");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.setLookUp(true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "btn_listshare");
            showParameter.setCloseCallBack(closeCallBack);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "!=", (Object)this.getUserId()));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void openReportQueryMoveForm() {
        boolean isPublic;
        BillList billListap = (BillList)this.getControl("billlistap1");
        ListSelectedRowCollection selectedRows = billListap.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u79fb\u52a8\u7684\u62a5\u8868\u3002", (String)"ReportQueryProcess_108", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> selectIds = new ArrayList<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            selectIds.add(selectedRow.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_reportquery"));
        Set reportcatalog = Arrays.stream(load).map(dynamicObject -> dynamicObject.getLong("reportcatalog.id")).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_reportcatalog", (String)"longnumber", (QFilter[])new QFilter("id", "in", reportcatalog).toArray());
        int publicCount = 0;
        int selfCount = 0;
        for (DynamicObject dynamicObject2 : dynamicObjects) {
            String longNumber = dynamicObject2.getString("longnumber");
            if (!kd.bos.util.StringUtils.isNotEmpty((String)longNumber)) continue;
            if (longNumber.startsWith("root.02_sys")) {
                ++publicCount;
                continue;
            }
            if (!longNumber.startsWith("root.01_sys")) continue;
            ++selfCount;
        }
        if (publicCount > 0 && selfCount > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79c1\u6709\u548c\u5171\u4eab\u5206\u7c7b\u4e0b\u62a5\u8868\u4e0d\u652f\u6301\u540c\u65f6\u79fb\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"QueryReportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean bl = isPublic = publicCount > 0;
        if (isPublic) {
            this.checkPermission(this.getView(), "public_update");
        } else {
            this.checkPermission(this.getView(), "edit");
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setFormId("eb_rptquerymove");
        formShowParameter.setCustomParam("isPublic", (Object)isPublic);
        formShowParameter.setCustomParam("selectIds", (Object)SerializationUtils.serializeToBase64(selectIds));
        CustomTreeNode currentSelectNode = this.getCurrentSelectNode();
        if (currentSelectNode != null) {
            formShowParameter.setCustomParam("oldCateName", (Object)currentSelectNode.getName());
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rptquerymove"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u79fb\u52a8", (String)"ReportQueryProcess_109", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void openQueryShowSettingForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("dataset", (Object)this.getDataSetId());
        String cache_templateModel = this.getCache("TemplateModel");
        if (cache_templateModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6templateModel\u5931\u8d25\uff01", (String)"QueryReportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)cache_templateModel);
        formShowParameter.setCustomParam("TemplateModel", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        String querySettingCacheKey = "querysetting" + this.getCache("reportqueryid");
        String cache_querySetting = this.getCache(querySettingCacheKey);
        if (cache_querySetting != null) {
            Map<String, Integer> metricDisplay;
            ShareSettingDto shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)cache_querySetting, ShareSettingDto.class);
            if (shareSettingDto != null && MapUtils.isEmpty(metricDisplay = shareSettingDto.getMetricDisplay())) {
                shareSettingDto.setMetricDisplay(this.getMetricDisplays());
                cache_querySetting = SerializationUtils.toJsonString((Object)shareSettingDto);
            }
            formShowParameter.setCustomParam("querysetting", (Object)cache_querySetting);
        } else {
            formShowParameter.setCustomParam("metricdisplay", (Object)SerializationUtils.toJsonString(this.getMetricDisplays()));
        }
        formShowParameter.setFormId("eb_queryshowsetting");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "queryshowsetting"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u8bbe\u7f6e", (String)"QueryReportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    public void showShareRepordList() {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId("eb_reportshare");
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setCustomParam("noNeedDefaultQFilter", (Object)"true");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public boolean judgeIsSaved() {
        CustomTreeNode root = this.getCacheTree();
        String nodeId = this.getCacheCurrentNode();
        if (root == null || kd.bos.util.StringUtils.isEmpty((String)nodeId)) {
            return false;
        }
        CustomTreeNode curNode = root.getTreeNode(nodeId, 10);
        if (curNode == null) {
            return false;
        }
        Long modelId = this.getModelId();
        Long userId = this.getUserId();
        HashMap map = (HashMap)curNode.getData();
        String number = (String)map.get("number");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("model", "=", (Object)modelId));
        if (this.isShareNode(curNode).booleanValue()) {
            return true;
        }
        if (!"report-public".equals(curNode.getCategory())) {
            filters.add(new QFilter("creator", "=", (Object)userId));
        }
        filters.add(new QFilter("number", "=", (Object)number));
        Boolean result = QueryServiceHelper.exists((String)"eb_reportquery", (QFilter[])filters.toArray(new QFilter[0]));
        return result;
    }

    private void clickUnInterest() {
        CustomTreeNode root = this.getCacheTree();
        String errStr = ResManager.loadKDString((String)"\u5206\u7c7b\u8282\u70b9\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String nodeId = this.getCacheCurrentNode();
        if (root == null || kd.bos.util.StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(errStr);
            return;
        }
        CustomTreeNode curNode = root.getTreeNode(nodeId, 10);
        if (curNode == null) {
            return;
        }
        Map nodeData = curNode.getData();
        Map dataMap = nodeData;
        if (dataMap == null || !dataMap.containsKey("catalog")) {
            this.getView().showTipNotification(errStr);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u6267\u884c\u53d6\u6d88\u4fdd\u5b58\uff1f", (String)"ReportQueryProcess_77", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("uninterest_comfirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent msgBoxEvt) {
        super.confirmCallBack(msgBoxEvt);
        String callBackId = msgBoxEvt.getCallBackId();
        if (callBackId.equals("btn_exit1") && msgBoxEvt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().close();
        }
    }

    private void checkBeforeOperation(String key) {
        CommandParam commandParam = new CommandParam("eb_reportqueryprocess", "eb_rptquerydesigner", key, new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private void setShowDimPanel() {
        IFormView view;
        boolean isShow = "0".equals(this.getCache("cache_dimcontent_visiable"));
        this.setShowDimPanel(isShow);
        if (isShow && (view = this.getView().getView(this.getCache("floatDesignerPageId"))) != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"designer_float", "designer_switchlist"});
        }
    }

    private void setShowDimPanel(Boolean isShow) {
        if (!isShow.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"eb_dimcontentpanel"});
            this.setCache("cache_dimcontent_visiable", "0");
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"eb_dimcontentpanel"});
            this.setCache("cache_dimcontent_visiable", "1");
        }
    }

    private void showSettingRpt(CommandParam com) {
        List param = com.getParam();
        if (param == null || param.size() < 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u8ba1\u5668\u8fd4\u56de\u6570\u636e\u5f02\u5e38\u3002", (String)"ReportQueryProcess_73", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object nodeId = param.get(0);
        this.setCache("cache_designer_node_id", nodeId.toString());
        String operationKey = (String)param.get(1);
        String templateModelParam = (String)param.get(2);
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateModelParam);
        if (templateModel == null) {
            return;
        }
        if (this.isFromTargetCusReport()) {
            this.setCache("needLockDim" + nodeId, (String)param.get(4));
        }
        this.dealOperation(templateModel, operationKey);
    }

    private void dealOperation(ITemplateModel templateModel, String operationKey) {
        switch (operationKey) {
            case "refreshReport": {
                this.afterGetTemplateModel(templateModel);
                break;
            }
            case "openFloatDesigner": {
                this.openFloatDesigner(templateModel, false);
                break;
            }
            case "openFloatDesignerShare": {
                this.openFloatDesigner(templateModel, true);
                break;
            }
            case "checkExistRptTarScheme": {
                boolean exist = this.checkExistRptTarScheme(templateModel);
                if (exist) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u53e6\u5b58\u3002", (String)"ReportQueryProcess_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openReportQuerySchemeEditPage(templateModel);
                break;
            }
            case "checkBeforeInterst": {
                this.afterGetTemplateModel(templateModel);
                this.openRptQueryInfo("interest_close", "add");
                break;
            }
            case "checkBeforeSaveInterest": {
                this.afterGetTemplateModel(templateModel);
                this.openRptQueryInfo("interest_close", "saveas");
                break;
            }
            case "checkBeforeShare": {
                this.openQuerySettingPage(templateModel, false);
                break;
            }
            case "openDesignerListPage": {
                this.openDesignerListPage(templateModel);
                break;
            }
            case "loadReport": {
                this.loadReportByTemplateModel(templateModel);
                break;
            }
            case "datasetChange": {
                this.removeCache("querysetting" + this.getCacheCurrentNode());
                this.afterGetTemplateModel(templateModel);
                this.setCache("dataset", IDUtils.toString((Object)templateModel.getTemplateBaseInfo().getDatasetID()));
                break;
            }
            case "checkBeforeSetting": {
                this.openQueryShowSettingForm();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.startsWith("ebf7_")) {
            this.setHiddenDimControl(e);
        }
        if (key.equals("selectscheme")) {
            String selectScheme = (String)this.getModel().getValue("selectscheme");
            DynamicObject dynamicObject = this.queryOneTarRptScheme(selectScheme);
            if (dynamicObject == null) {
                String cache = this.getCache("cacheTargetRefresh");
                if (kd.bos.util.StringUtils.isNotEmpty((String)cache)) {
                    this.clearCache("cacheTargetRefresh");
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848", (String)"ReportQueryProcess_70", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String data = dynamicObject.getString("data");
            if (kd.bos.util.StringUtils.isEmpty((String)data)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u65e0\u9875\u9762\u7ef4\u5ea6\u3001\u884c\u7ef4\u5ea6\u3001\u5217\u7ef4\u5ea6\u7b49\u8bbe\u7f6e\u3002", (String)"ReportQueryProcess_66", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setCache("TemplateModel", data);
            this.showInContainerDesigner(TemplateModelJSONUtil.parseITemplateModel((String)data), false, false);
        }
    }

    private void setHiddenDimControl(PropertyChangedArgs e) {
        String ctrlKey = e.getProperty().getName();
        String suffix = ReportQueryHelper.getCtrlKeySuffix(ctrlKey);
        if (suffix.equals("row") || suffix.equals("col") || suffix.equals("page")) {
            String hiddenCtrl = ReportQueryHelper.getCtrlKeyPrefix(ctrlKey);
            IDataModel model = this.getModel();
            if (model.getDataEntity().getDataEntityType().getProperties().containsKey((Object)hiddenCtrl)) {
                ITemplateModel template = this.changeTemplateModeDimValue(e);
                if (template != null) {
                    this.setDataSetBizRuid(template);
                }
                model.setValue(hiddenCtrl, e.getChangeSet()[0].getNewValue());
            }
            if (suffix.equals("page") && e.getChangeSet()[0].getNewValue() != null) {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setCache(ctrlKey, newValue.getString("id"));
            }
        }
    }

    private void setDataSetBizRuid(ITemplateModel templateModel) {
        String curTab = this.getCache("cache_tab");
        if ("tab_dimset".equals(curTab)) {
            Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
            Map<String, Set<String>> bizRuleDimMember = this.getPageDimMemberByTemplate(templateModel);
            TemplateTaskDto templateTaskDto = new TemplateTaskDto(Long.valueOf(0L), null, bizRuleDimMember);
            RuleRelationService.getInstance().bindRuleToOneTemplate(templateTaskDto, datasetId.longValue(), false, templateModel.getModelId());
            if (CollectionUtils.isNotEmpty((Collection)templateTaskDto.getRuleIds())) {
                this.setReportBizRules(this.dynamicReportProcess);
                this.setCache("cache_bizRule_query", SerializationUtils.toJsonString((Object)templateTaskDto.getRuleIds()));
            } else {
                this.dynamicReportProcess.setBizRules(null);
                this.clearCache("cache_bizRule_query");
            }
        }
    }

    private Map<String, Set<String>> getPageDimMemberByTemplate(ITemplateModel templateModel) {
        HashMap<String, Set<String>> bizRuleDimMember = new HashMap<String, Set<String>>(16);
        if (templateModel == null || templateModel.getPagemembentry() == null) {
            return bizRuleDimMember;
        }
        for (IPageDimensionEntry p : templateModel.getPagemembentry()) {
            if (p.getDimension() == null || p.getMembers() == null || p.getMembers().isEmpty()) continue;
            HashSet<String> memNums = new HashSet<String>(16);
            memNums.add(((IDimensionMember)p.getMembers().get(0)).getNumber());
            bizRuleDimMember.put(p.getDimension().getNumber(), memNums);
        }
        return bizRuleDimMember;
    }

    private ITemplateModel changeTemplateModeDimValue(PropertyChangedArgs e) {
        String ctrlKey = e.getProperty().getName();
        ITemplateModel templateModel = null;
        String suffix = ReportQueryHelper.getCtrlKeySuffix(ctrlKey);
        if (suffix.equals("row") || suffix.equals("col") || suffix.equals("page")) {
            Map allMap = (Map)SerializationUtils.fromJsonString((String)this.getCache("allPoint"), Map.class);
            if (!allMap.containsKey(ctrlKey)) {
                return templateModel;
            }
            String dimNum = (String)((Map)allMap.get(ctrlKey)).get("number");
            String templatemodleCache = this.getCache("TemplateModel");
            String templateType = this.getCache("templatetype");
            if (BgTemplateTypeEnum.EBFIX.getNumber().equalsIgnoreCase(templateType) || kd.bos.util.StringUtils.isEmpty((String)templatemodleCache)) {
                return templateModel;
            }
            if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() == "") {
                return templateModel;
            }
            DynamicObject newDy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldDy = (DynamicObject)e.getChangeSet()[0].getOldValue();
            templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templatemodleCache);
            this.setTemplateModeMumberValue(templateModel, dimNum, newDy, oldDy, suffix);
            this.setCache("TemplateModel", TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        }
        return templateModel;
    }

    private void setTemplateModeMumberValue(ITemplateModel templateModel, String dimNum, DynamicObject newDy, DynamicObject oldDy, String suffix) {
        block5: {
            block7: {
                block6: {
                    if (templateModel == null) {
                        return;
                    }
                    if (!"row".equalsIgnoreCase(suffix)) break block6;
                    for (int index = 0; index < templateModel.getPartitionSetting().getRowPartition().size(); ++index) {
                        RowColPartition rowPart = (RowColPartition)templateModel.getPartitionSetting().getRowPartition().get(index);
                        this.setRowColMember(rowPart, dimNum, newDy, oldDy);
                    }
                    break block5;
                }
                if (!"col".equalsIgnoreCase(suffix)) break block7;
                for (int index = 0; index < templateModel.getPartitionSetting().getColPartition().size(); ++index) {
                    RowColPartition colPart = (RowColPartition)templateModel.getPartitionSetting().getColPartition().get(index);
                    this.setRowColMember(colPart, dimNum, newDy, oldDy);
                }
                break block5;
            }
            if (!"page".equalsIgnoreCase(suffix)) break block5;
            for (int index = 0; index < templateModel.getPagemembentry().size(); ++index) {
                IPageDimensionEntry pageDim = (IPageDimensionEntry)templateModel.getPagemembentry().get(index);
                if (!pageDim.getDimension().getNumber().equalsIgnoreCase(dimNum)) continue;
                String viewId = this.getViewId(dimNum, suffix, templateModel.getTemplateBaseInfo().getDatasetID());
                if (viewId != null) {
                    templateModel.getDimemsionViews().put(dimNum, Long.valueOf(viewId));
                }
                this.setMemberValue(dimNum, pageDim.getMembers(), newDy, oldDy);
                break;
            }
        }
    }

    private void setRowColMember(RowColPartition rowcolPart, String dimNum, DynamicObject newDy, DynamicObject oldDy) {
        for (int row = 0; row < rowcolPart.getRowColDimensionEntries().size(); ++row) {
            if (!((IRowColDimensionEntry)rowcolPart.getRowColDimensionEntries().get(row)).getDimension().getNumber().equalsIgnoreCase(dimNum)) continue;
            IRowColDimensionEntry rowDim = (IRowColDimensionEntry)rowcolPart.getRowColDimensionEntries().get(row);
            this.setMemberValue(dimNum, rowDim.getMembers(), newDy, oldDy);
            break;
        }
    }

    private String getViewId(String dimNum, String suffix, Long datasetId) {
        List viewIdList;
        Map viewGroupViewsByDataSet;
        String viewId = this.getPageCache().get(this.getControlKeyByDimNum(dimNum, suffix) + "viewId");
        if (viewId == null) {
            viewId = this.getPageCache().get(dimNum + "viewId");
        }
        if (kd.bos.util.StringUtils.isEmpty((String)viewId) && (viewGroupViewsByDataSet = this.getModelCacheHelper().getViewGroupViewsByDataSet(datasetId)).containsKey(dimNum) && CollectionUtils.isNotEmpty((Collection)(viewIdList = (List)viewGroupViewsByDataSet.get(dimNum)))) {
            viewId = IDUtils.toString(viewIdList.get(0));
        }
        return viewId;
    }

    private void setMemberValue(String dimNum, List<IDimensionMember> members, DynamicObject newDy, DynamicObject oldDy) {
        int scrop = RangeEnum.ONLY.getIndex();
        members.clear();
        members.add((IDimensionMember)new DefaultDimMember(Long.valueOf(newDy.getLong("id")), newDy.getString("name"), newDy.getString("number"), scrop));
    }

    String getControlKeyByDimNum(String dimNum, String suffix) {
        String controlKey = "";
        Map<Object, Object> f7KeyMap = new LinkedHashMap(16);
        f7KeyMap = this.getCache("cache_f7key_dim_map") != null ? (Map)ObjectSerialUtil.deSerializedBytes((String)this.getCache("cache_f7key_dim_map")) : this.getAllF7Map(true);
        if (f7KeyMap.size() > 0) {
            for (Map.Entry<Object, Object> f7Key : f7KeyMap.entrySet()) {
                if (!dimNum.equalsIgnoreCase((String)f7Key.getValue())) continue;
                controlKey = (String)f7Key.getKey() + "_" + suffix;
            }
        }
        return controlKey;
    }

    private Map<String, String> getAllF7Map(Boolean isCheckBizmodel) {
        LinkedHashMap<String, String> f7KeyMap = new LinkedHashMap(16);
        if (this.getCache("cache_f7key_dim_map") != null) {
            f7KeyMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getCache("cache_f7key_dim_map"));
        } else {
            List<Object> bizModelDims = new ArrayList(16);
            if (isCheckBizmodel.booleanValue()) {
                bizModelDims = this.getBizModelDims();
            }
            Long modelId = this.getModelId();
            AtomicInteger userdefined_index = new AtomicInteger(1);
            Map dimensionMap = this.getModelCacheHelper().getDimensions();
            for (Dimension dimension : dimensionMap.values()) {
                String dimnumber = dimension.getNumber();
                if (bizModelDims.size() > 0 && !bizModelDims.contains(dimnumber)) continue;
                String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
                boolean isuserdefined = false;
                if ("epm_userdefinedmembertree".equals(memberTreemodel)) {
                    isuserdefined = true;
                }
                String f7key = "ebf7_" + dimnumber.toLowerCase();
                if (isuserdefined) {
                    f7key = "ebf7_customize" + userdefined_index.get();
                    userdefined_index.incrementAndGet();
                }
                f7KeyMap.put(f7key, dimnumber);
            }
            this.setCache("cache_f7key_dim_map", ObjectSerialUtil.toByteSerialized(f7KeyMap));
        }
        return f7KeyMap;
    }

    private List<String> getBizModelDims() {
        QFilter dimFilter;
        String dimFields;
        DynamicObjectCollection dataSetDimDys;
        List<String> dimsList = new ArrayList<String>(16);
        if (this.getCache("cache_BizModel_dims") != null) {
            dimsList = (List)SerializationUtils.fromJsonString((String)this.getCache("cache_BizModel_dims"), List.class);
        } else if (!kd.bos.util.StringUtils.isEmpty((String)this.getCache("dataset")) && (dataSetDimDys = QueryServiceHelper.query((String)"eb_dataset", (String)(dimFields = "entryentity.datasetdim.id as dimid,entryentity.datasetdim.number as dimnum,entryentity.datasetdim.name as dimname,entryentity.datasetdim.dseq as dseq"), (QFilter[])new QFilter[]{dimFilter = new QFilter("id", "=", (Object)Long.parseLong(this.getCache("dataset")))})) != null && dataSetDimDys.size() > 0) {
            for (DynamicObject dataSetDimDy : dataSetDimDys) {
                dimsList.add(dataSetDimDy.getString("dimnum"));
            }
            if (!dimsList.contains(SysDimensionEnum.Account.getNumber())) {
                dimsList.add(SysDimensionEnum.Account.getNumber());
            }
            String dimsStr = SerializationUtils.toJsonString(dimsList);
            this.setCache("cache_BizModel_dims", dimsStr);
        }
        return dimsList;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (key) {
            case "interest_close": {
                if (returnData == null) {
                    return;
                }
                Map result = (Map)returnData;
                if (!result.containsKey("result") || !"success".equals(result.get("result"))) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"ReportQueryProcess_76", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "ReportQueryProcess_80", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6570\u636e\u96c6\u4fdd\u5b58\u6210\u529f\u3002", "ReportQueryProcess_81", "epm-eb-formplugin"));
                Object id = result.get("id");
                if (id != null) {
                    List ids = (List)id;
                    this.setCache("curNodeId", ids.get(0) + "");
                }
                this.refreshCustomTree();
                break;
            }
            case "btn_schemesaveas": {
                if (returnData == null) break;
                String schemeNumber = (String)returnData;
                this.setSelectSchemeCombo(schemeNumber);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53e6\u5b58\u65b9\u6848\u6210\u529f", (String)"ReportQueryProcess_68", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "eb_rptquerydesigner_list": {
                if (returnData != null) {
                    this.afterGetTemplateModel(TemplateModelJSONUtil.parseITemplateModel((String)returnData.toString()));
                }
                this.setShowDimPanel(true);
                break;
            }
            case "eb_querysetting": {
                if (returnData == null) break;
                ShareSettingDto shareSettingDto = (ShareSettingDto)SerializationUtils.deSerializeFromBase64((String)returnData.toString());
                this.updateDimPanelVisible(SerializationUtils.toJsonString((Object)shareSettingDto));
                break;
            }
            case "eb_rptquerydesigner": {
                this.setShowDimPanel(true);
                if (!Objects.equals(this.getCache("cache_designer_node_id"), this.getCacheCurrentNode()) || this.getCache("isNoExecuteShowInDesigner") != null) break;
                String templateModelCache = this.getCache("TemplateModel");
                this.showInContainerDesigner(TemplateModelJSONUtil.parseITemplateModel((String)templateModelCache), false, kd.bos.util.StringUtils.isEmpty((String)templateModelCache));
                break;
            }
            case "metricdisplay": {
                if (!(returnData instanceof String)) break;
                this.getOrCacheMetricDisplay((String)returnData);
                Control designerOk = this.getControl("designer_ok");
                if (designerOk != null) {
                    this.click((EventObject)new ClickEvent((Object)designerOk));
                    break;
                }
                this.clickRefresh();
                break;
            }
            case "queryshowsetting": {
                if (!(returnData instanceof String)) break;
                String cache = this.getCache("querysetting" + this.getCache("reportqueryid"));
                if (returnData.toString().equals(cache)) {
                    return;
                }
                ShareSettingDto shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)returnData.toString(), ShareSettingDto.class);
                boolean needRefersh = false;
                ShareSettingDto old = new ShareSettingDto();
                if (kd.bos.util.StringUtils.isNotEmpty((String)cache) && !(old = (ShareSettingDto)SerializationUtils.fromJsonString((String)cache, ShareSettingDto.class)).getDimVisible().equals(shareSettingDto.getDimVisible())) {
                    needRefersh = true;
                }
                this.setCache("querysetting" + this.getCache("reportqueryid"), returnData.toString());
                if (needRefersh) {
                    this.updateDimPanelVisible(returnData.toString());
                }
                Map<String, Integer> metricDisplay = shareSettingDto.getMetricDisplay();
                this.getOrCacheMetricDisplay(SerializationUtils.toJsonString(metricDisplay));
                if (this.dynamicReportProcess == null) break;
                this.dynamicReportProcess.itemClick(new ItemClickEvent((Object)this, shareSettingDto.getMemberShowType(), ""));
                if (!old.getDataUnit().equals(shareSettingDto.getDataUnit())) {
                    this.dataUnitChange(shareSettingDto.getDataUnit());
                }
                if (!old.getHideEmptyDataRow().equals(shareSettingDto.getHideEmptyDataRow()) || !old.getHideEmptyDatCol().equals(shareSettingDto.getHideEmptyDatCol())) {
                    String hideEmptyDatCol = shareSettingDto.getHideEmptyDatCol();
                    String hideEmptyDataRow = shareSettingDto.getHideEmptyDataRow();
                    if ("0".equals(hideEmptyDataRow) && "0".equals(hideEmptyDatCol)) {
                        this.hideShowEmptyCols(Boolean.TRUE);
                        this.hideShowEmptyRows(Boolean.TRUE);
                    } else if ("1".equals(hideEmptyDataRow) && "1".equals(hideEmptyDatCol)) {
                        this.hideShowEmptyRows(Boolean.FALSE);
                        this.hideShowEmptyCols(Boolean.FALSE);
                    } else if ("1".equals(hideEmptyDataRow) && "0".equals(hideEmptyDatCol)) {
                        this.hideShowEmptyRows(Boolean.FALSE);
                        this.hideShowEmptyCols(Boolean.TRUE);
                    } else if ("0".equals(hideEmptyDataRow) && "1".equals(hideEmptyDatCol)) {
                        this.hideShowEmptyRows(Boolean.TRUE);
                        this.hideShowEmptyCols(Boolean.FALSE);
                    }
                }
                if (!old.getMemberShowType().equals(shareSettingDto.getMemberShowType())) {
                    this.getOrCacheMemberShowType(shareSettingDto.getMemberShowType());
                }
                if (old.getMetricDisplay().equals(shareSettingDto.getMetricDisplay())) break;
                ITemplateModel templateModel = this.dynamicReportProcess.getTemplateModel();
                templateModel.setMetricCellStyleInfo(this.getMetricCellStyleInfo());
                this.dynamicReportProcess.setTemplateModel(templateModel);
                this.dynamicReportProcess.setCellStyles();
                SpreadStyleControlContext spreadStyleControlContext = new SpreadStyleControlContext(this.dynamicReportProcess.getSpreadManager());
                spreadStyleControlContext.setTemplateModel(templateModel);
                ArrayList<SheetMetricDimStyleController> spreadStyleControls = new ArrayList<SheetMetricDimStyleController>();
                spreadStyleControls.add(new SheetMetricDimStyleController());
                spreadStyleControls.forEach(stylecontrol -> stylecontrol.control(spreadStyleControlContext));
                this.dynamicReportProcess.getspreadContainer().setCellStyle(spreadStyleControlContext.getAreasStyles());
                break;
            }
            case "rptquerymove": {
                if (returnData == null) break;
                this.refreshCustomTree();
                break;
            }
            case "btn_listshare": {
                if (returnData == null) {
                    this.getPageCache().remove("shareCache");
                    return;
                }
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection selectUser = (ListSelectedRowCollection)returnData;
                ArrayList<UserInfoPOJO> userInfoPOJOS = new ArrayList<UserInfoPOJO>(selectUser.size());
                for (ListSelectedRow listSelectedRow : selectUser) {
                    userInfoPOJOS.add(new UserInfoPOJO(IDUtils.toLong((Object)listSelectedRow.getPrimaryKeyValue()), listSelectedRow.getNumber(), listSelectedRow.getName()));
                }
                this.handleShare(userInfoPOJOS);
                break;
            }
            case "btn_listshare_confirm": {
                if (returnData != null && ("skip".equals(returnData) || "continue".equals(returnData))) {
                    String shareCache = this.getPageCache().get("shareCache");
                    String selectUser = this.getPageCache().get("selectUser");
                    if (kd.bos.util.StringUtils.isEmpty((String)shareCache) || kd.bos.util.StringUtils.isEmpty((String)selectUser)) {
                        log.info("\u7f13\u5b58\u4fe1\u606f\u6216\u8005\u6240\u9009\u4eba\u5458\u4e3a\u7a7a");
                        this.getPageCache().remove("shareCache");
                        return;
                    }
                    Map shareInfo = (Map)SerializationUtils.fromJsonString((String)shareCache, Map.class);
                    Boolean isShare = shareInfo.getOrDefault("isShare", false);
                    List reportIds = (List)shareInfo.get("ids");
                    DynamicObjectCollection dynamicObjects = this.getDynamicObjects(reportIds, isShare);
                    String existsRecord = this.getPageCache().get("existsRecord");
                    ArrayList<ShareRecordPOJO> exitsRecord = new ArrayList(16);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)existsRecord)) {
                        exitsRecord = JSON.parseArray((String)existsRecord, ShareRecordPOJO.class);
                    }
                    List userInfo = JSON.parseArray((String)selectUser, Long.class);
                    this.shareToUser(isShare, dynamicObjects, userInfo, exitsRecord, "continue".equals(returnData));
                }
                this.getPageCache().remove("existsRecord");
                this.getPageCache().remove("selectUser");
                break;
            }
        }
    }

    private void handleShare(List<UserInfoPOJO> userInfoPOJOS) {
        Boolean isShare;
        String shareCache = this.getPageCache().get("shareCache");
        if (CollectionUtils.isEmpty(userInfoPOJOS) || kd.bos.util.StringUtils.isEmpty((String)shareCache)) {
            log.info("\u7f13\u5b58\u4fe1\u606f\u6216\u8005\u6240\u9009\u4eba\u5458\u4e3a\u7a7a");
            this.getPageCache().remove("shareCache");
            return;
        }
        Map shareInfo = (Map)SerializationUtils.fromJsonString((String)shareCache, Map.class);
        List reportIds = (List)shareInfo.get("ids");
        DynamicObjectCollection reportDyns = this.getDynamicObjects(reportIds, isShare = shareInfo.getOrDefault("isShare", false));
        if (CollectionUtils.isEmpty((Collection)reportDyns)) {
            this.getPageCache().remove("shareCache");
            log.info("\u6240\u9009\u62a5\u8868\u4e0d\u5b58\u5728");
            return;
        }
        ArrayList<ShareRecordPOJO> existsRecord = new ArrayList<ShareRecordPOJO>(16);
        List<Long> selectUserId = userInfoPOJOS.stream().map(x -> x.getId()).collect(Collectors.toList());
        Map<Long, Set<Long>> existsShareMap = ReportQueryHelper.judgeIsRepeatShare(this.getUserId(), selectUserId, reportIds, true, existsRecord);
        if (!existsShareMap.isEmpty()) {
            ImmutableMap userInfoMap = Maps.uniqueIndex(userInfoPOJOS, (Function)new Function<UserInfoPOJO, Long>(){

                public Long apply(UserInfoPOJO input) {
                    return input.getId();
                }
            });
            String title = ResManager.loadKDString((String)"\u5206\u4eab\u7ed3\u679c", (String)"ReportQueryProcess_118", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            OperationResult operationResult = new OperationResult();
            for (ShareRecordPOJO shareRecordPOJO : existsRecord) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setTitle(title);
                Optional<DynamicObject> report = reportDyns.stream().filter(x -> x.getLong("id") == shareRecordPOJO.getReportId().longValue()).findFirst();
                UserInfoPOJO userInfoPOJO = (UserInfoPOJO)userInfoMap.get((Object)shareRecordPOJO.getReceiverId());
                if (!report.isPresent() || userInfoPOJO == null) continue;
                DynamicObject dynamicObject = report.get();
                String msg = ResManager.loadResFormat((String)"%1(%2)\u5df2\u5206\u4eab\u7ed9%3\u3002", (String)"ReportQueryProcess_117", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("name"), dynamicObject.getString("number"), userInfoPOJO.getName()});
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(msg);
                operationResult.addErrorInfo(operateErrorInfo);
            }
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("eb_confirm");
            parameters.setShowTitle(false);
            parameters.setCustomParam("operateName", (Object)title);
            IPageCache pageCache = this.getPageCache();
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
            pageCache.put("operationresult", serialResult);
            ArrayList<String> list = new ArrayList<String>();
            int billCount = operationResult.getAllErrorOrValidateInfo().size();
            for (int i = 0; i < 5 && i < billCount; ++i) {
                IOperateInfo errorInfo = (IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(i);
                list.add(errorInfo.getMessage());
            }
            parameters.setCustomParam("hasMore", (Object)(operationResult.getAllErrorOrValidateInfo().size() > 5 ? 1 : 0));
            parameters.setCustomParam("errorMsg", list);
            String message = operationResult.getMessage();
            if (StringUtils.isNotEmpty((String)message) && operationResult.getMessageType() == 1) {
                parameters.setCustomParam("message", (Object)operationResult.getMessage());
            }
            parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_listshare_confirm"));
            String context = ResManager.loadResFormat((String)"\u5171%1\u5f20\u62a5\u8868\u5df2\u5206\u4eab\u8fc7\uff0c\u518d\u6b21\u5206\u4eab\u4f1a\u5c06\u539f\u6709\u8bb0\u5f55\u8986\u76d6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ReportQueryProcess_119", (String)"epm-eb-formplugin", (Object[])new Object[]{operationResult.getAllErrorOrValidateInfo().size()});
            parameters.setCustomParam("title", (Object)context);
            parameters.setCustomParam("moda", (Object)"select");
            parameters.setCustomParam("errorTitle", (Object)ResManager.loadKDString((String)"\u91cd\u590d", (String)"ReportQueryProcess_78", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("existsRecord", SerializationUtils.toJsonString(existsRecord));
            this.getPageCache().put("selectUser", SerializationUtils.toJsonString(selectUserId));
            this.getView().showForm(parameters);
        } else {
            this.shareToUser(isShare, reportDyns, selectUserId, null, false);
        }
    }

    private DynamicObjectCollection getDynamicObjects(List<String> reportIds, Boolean isShare) {
        List reportLongIds = reportIds.stream().map(x -> IDUtils.toLong((Object)x)).collect(Collectors.toList());
        QFilter filter2 = new QFilter("id", "in", reportLongIds);
        QFilter[] filter = new QFilter[]{filter2};
        String formId = isShare != false ? "eb_reportshare" : "eb_reportquery";
        String selFields = isShare != false ? "id,reportcatalog,formid,reportid,name,number,description,querysetting,dataset,data" : "id,reportcatalog,name,number,description,querysetting,dataset,data";
        DynamicObjectCollection reportDyns = QueryServiceHelper.query((String)formId, (String)selFields, (QFilter[])filter);
        return reportDyns;
    }

    private void shareToUser(Boolean isShare, DynamicObjectCollection reportDyns, List<Long> selectUserId, List<ShareRecordPOJO> exitsRecord, boolean isCover) {
        this.getPageCache().remove("shareCache");
        long[] msgIds = GlobalIdUtil.genGlobalLongIds((int)reportDyns.size());
        HashMap<Long, Long> reportAndMsgIdMap = new HashMap<Long, Long>(msgIds.length);
        List reportIdSet = reportDyns.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        for (int i = 0; i < reportIdSet.size(); ++i) {
            Long aLong = (Long)reportIdSet.get(i);
            reportAndMsgIdMap.put(aLong, msgIds[i]);
        }
        Map<String, Object> map = this.batchSendMessage(reportAndMsgIdMap, selectUserId, exitsRecord, isCover);
        if (map == null || !((Boolean)map.get("success")).booleanValue()) {
            log.info("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5206\u4eab\u5931\u8d25\uff1a", (Object)(map == null ? "" : map.toString()));
        }
        ArrayList<DynamicObject> shareReportDys = new ArrayList<DynamicObject>(16);
        Long modelId = this.getModelId();
        String shareUserId = String.valueOf(this.getUserId());
        HashSet<String> exitsRecordInfo = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(exitsRecord) && !isCover) {
            for (ShareRecordPOJO shareRecordPOJO : exitsRecord) {
                exitsRecordInfo.add(shareRecordPOJO.getReportId() + "_" + shareRecordPOJO.getReceiverId());
            }
        }
        ArrayList logInfo = new ArrayList(16);
        for (DynamicObject dynamicObject : reportDyns) {
            String finalReportName = this.getReportName(dynamicObject.getString("name"));
            String description = this.getDescription(finalReportName, dynamicObject);
            MainEntityType shareType = EntityMetadataCache.getDataEntityType((String)"eb_reportshare");
            String number = dynamicObject.getString("number");
            Long catalogId = dynamicObject.getLong("reportcatalog");
            Date shareDate = new Date(System.currentTimeMillis());
            String templateType = "1";
            String shareQuerySettingStr = dynamicObject.getString("querysetting");
            String templateData = dynamicObject.getString("data");
            long dataset = dynamicObject.getLong("dataset");
            long reportId = dynamicObject.getLong("id");
            for (Long userid : selectUserId) {
                if (!isCover && CollectionUtils.isNotEmpty(exitsRecordInfo) && exitsRecordInfo.contains(reportId + "_" + userid)) continue;
                DynamicObject doSharType = new DynamicObject((DynamicObjectType)shareType);
                doSharType.set("number", (Object)number);
                doSharType.set("name", (Object)finalReportName);
                HashMap<String, Object> temp = new HashMap<String, Object>(2);
                temp.put("report", finalReportName);
                temp.put("user", userid);
                logInfo.add(temp);
                doSharType.set("receiver", (Object)userid);
                doSharType.set("sharers", (Object)shareUserId);
                doSharType.set("sharedate", (Object)shareDate);
                doSharType.set("islook", (Object)"B");
                doSharType.set("sharestatus", (Object)"A");
                doSharType.set("status", (Object)"A");
                doSharType.set("modelid", (Object)modelId);
                doSharType.set("templatetype", (Object)templateType);
                doSharType.set("description", (Object)description);
                doSharType.set("data", (Object)templateData);
                doSharType.set("querysetting", (Object)shareQuerySettingStr);
                doSharType.set("reportcatalog", (Object)catalogId);
                doSharType.set("reportid", (Object)reportId);
                if (isShare.booleanValue()) {
                    doSharType.set("formid", (Object)dynamicObject.getString("formid"));
                } else {
                    doSharType.set("formid", (Object)"eb_reportquery");
                }
                doSharType.set("messageid", reportAndMsgIdMap.get(reportId));
                doSharType.set("flagId", (Object)this.getCache("flagId"));
                doSharType.set("dataset", (Object)dataset);
                shareReportDys.add(doSharType);
            }
        }
        if (isCover && exitsRecord.size() > 0) {
            List<Long> list = exitsRecord.stream().map(x -> x.getId()).collect(Collectors.toList());
            ReportQueryHelper.delRepeatShare(list);
        }
        if (shareReportDys.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])shareReportDys.toArray(new DynamicObject[0]));
            for (Map map2 : logInfo) {
                String rptName = (String)map2.get("report");
                Object userId = map2.get("user");
                this.writeLog(null, "share", new MultiLangEnumBridge("\u5206\u4eab", "ShareQuerySettingPlugin_01", "epm-eb-formplugin"), new MultiLangEnumBridge("\u62a5\u8868%1$s\u5206\u4eab\u7ed9\u7528\u6237\uff1a%2$s\u3002", "ShareQuerySettingPlugin_02", "epm-eb-formplugin"), new String[]{rptName, Convert.toStr(userId)});
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u4eab\u6210\u529f", (String)"QueryReportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private Map<String, Object> batchSendMessage(Map<Long, Long> reportAndMsgIdMap, List<Long> selectUserId, List<ShareRecordPOJO> exitsRecord, boolean isCover) {
        if (reportAndMsgIdMap.isEmpty() || CollectionUtils.isEmpty(selectUserId)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmssSSS");
        String flagId = sdf.format(new Date());
        this.setCache("flagId", flagId);
        LocaleString title = new LocaleString();
        LocaleString tag = new LocaleString();
        title.setLocaleValue(ResManager.loadResFormat((String)"\u4f60\u597d\uff0c%1,\u7ed9\u4f60\u5206\u4eab\u4e86\u9884\u7b97\u62a5\u8868\uff0c\u8bf7\u6253\u5f00\u94fe\u63a5\u67e5\u770b", (String)"QueryReportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
        tag.setLocaleValue(ResManager.loadKDString((String)"\u9884\u7b97\u62a5\u8868", (String)"QueryReportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(reportAndMsgIdMap.size());
        Set<Object> exitsReport = new HashSet(16);
        Set<Object> exitsReveiver = new HashSet(16);
        if (!isCover && CollectionUtils.isNotEmpty(exitsRecord)) {
            exitsReport = exitsRecord.stream().map(x -> x.getReportId()).collect(Collectors.toSet());
            exitsReveiver = exitsRecord.stream().map(x -> x.getReceiverId()).collect(Collectors.toSet());
        }
        for (Map.Entry<Long, Long> reportMap : reportAndMsgIdMap.entrySet()) {
            ArrayList<Long> tempUser = new ArrayList<Long>(selectUserId);
            if (exitsReport.contains(reportMap.getKey())) {
                tempUser.removeAll(exitsReveiver);
                if (CollectionUtils.isEmpty(tempUser)) continue;
            }
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageTitle((ILocaleString)title);
            messageInfo.setId(reportMap.getValue());
            messageInfo.setMessageContent((ILocaleString)title);
            messageInfo.setUserIds(tempUser);
            messageInfo.setSenderId(this.getUserId());
            messageInfo.setSendTime(new Date(System.currentTimeMillis()));
            messageInfo.setEntityNumber("eb_reportshare");
            messageInfo.setBizDataId(reportMap.getKey());
            messageInfo.setNestBillId(reportMap.getKey());
            messageInfo.setMessageTag((ILocaleString)tag);
            String currentUrl = UrlService.getDomainContextUrl();
            messageInfo.setContentUrl(currentUrl + "/?formId=eb_reportqueryprocess&pkId=" + this.getModelId() + "/" + "tab_myinterest" + "/" + reportMap.getKey() + "/" + flagId);
            messageInfos.add(messageInfo);
        }
        return MessageCenterServiceHelper.batchSendMessages(messageInfos);
    }

    public String getReportName(String name) {
        if (kd.bos.util.StringUtils.isEmpty((String)name)) {
            return "";
        }
        String result = name;
        String[] names = name.split("\\(");
        if (names.length > 1) {
            result = names[0];
        }
        return result;
    }

    public String getDescription(String finalreportName, DynamicObject report) {
        String description = ResManager.loadKDString((String)"\u62a5\u8868\u5206\u4eab", (String)"QueryReportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String tab = this.getCache("cache_tab");
        description = "tab_rptquery".equals(tab) ? finalreportName : report.getString("description");
        return description;
    }

    private void setSelectSchemeCombo(String selectNumber) {
        DynamicObjectCollection dynamicObjects = this.queryTarRptScheme(true);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String number = dynamicObject.getString("number");
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(dynamicObject.getString("name")));
                item.setValue(number);
                items.add(item);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("selectscheme");
            comboEdit.setComboItems(null);
            comboEdit.setComboItems(items);
        }
        this.getModel().setValue("selectscheme", (Object)selectNumber);
        this.getView().updateView("selectscheme");
    }

    private void updateDimPanelVisible(String querySetting) {
        CommandParam commandParam = new CommandParam("eb_reportqueryprocess", "eb_rptquerydesigner", "updateDimPanelVisible", new Object[]{querySetting});
        this.sendMsg(this.getView(), commandParam);
    }

    private void loadReportByTemplateModel(ITemplateModel templateModel) {
        HashMap<String, Long> defaultDimMember = new HashMap<String, Long>(16);
        templateModel.getPagemembentry().forEach(p -> defaultDimMember.put(p.getDimension().getNumber(), ((IDimensionMember)p.getMembers().get(0)).getId()));
        if (this.dynamicReportProcess == null) {
            this.initReportPlugin(BgTemplateTypeEnum.DYNAMIC.getNumber(), "1");
        }
        this.dynamicReportProcess.setTemplateModel(templateModel);
        this.dynamicReportProcess.setDefaultDimMember(defaultDimMember);
        this.dynamicReportProcess.afterCreateNewData(null);
        this.getSpreadContainer().closeToolbar();
        this.getSpreadContainer().setDisplayContent("", "", "");
        this.getSpreadContainer().setVirtualMode("virtualModelCallBack", true);
        this.getSpreadContainer().lockSheets(Collections.singletonList("Sheet1"));
        this.getPageCache().put("isVirtualMode", "1");
    }

    private void initReportPlugin(String reporttype, String isReport) {
        Long reportProcessId = IDUtils.toLong((Object)this.getPageCache().get("current_report_id"));
        Long taskProId = (Long)this.getView().getFormShowParameter().getCustomParam("taskprocessid");
        if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(reporttype)) {
            if ("1".equals(isReport)) {
                if (this.dynamicReportProcess == null) {
                    this.dynamicReportProcess = new DynamicReportProcess();
                    this.dynamicReportProcess.setNeedCheckPerm(true);
                }
                this.setReportBizRules(this.dynamicReportProcess);
                this.dynamicReportProcess.setTaskProcessId(taskProId);
                this.dynamicReportProcess.setProcessId(reportProcessId);
                this.dynamicReportProcess.setView(this.getView());
                this.dynamicReportProcess.initialize();
            } else {
                if (this.dynamicTemplateProcess == null) {
                    this.dynamicTemplateProcess = new DynamicTemplateProcess();
                }
                this.dynamicTemplateProcess.setSpreadKey(this.getSpreadKey());
                this.dynamicTemplateProcess.setView(this.getView());
                this.dynamicTemplateProcess.initialize();
            }
        } else {
            this.getView().addService(ISpreadAction.class, (Object)new ReportQuerySpreadAction(this));
        }
    }

    private void setReportBizRules(AbstractReportPlugin reportPlugin) {
        if (!kd.bos.util.StringUtils.isEmpty((String)this.getCache("cache_bizRule_query")) && reportPlugin != null) {
            Set bizRuleIds = (Set)SerializationUtils.fromJsonString((String)this.getCache("cache_bizRule_query"), Set.class);
            reportPlugin.setBizRules(bizRuleIds);
        }
    }

    private void openDesignerListPage(ITemplateModel templateModel) {
        String formId = "eb_rptquerydesigner_list";
        if (templateModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efatemplateModel\u5931\u8d25\u3002", (String)"QueryReportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("TemplateModel", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("dataset", (Object)this.getDataSetId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    private void openRptQueryInfo(String callBackId, String operate) {
        CustomTreeNode root = this.getCacheTree();
        String errStr = ResManager.loadKDString((String)"\u5206\u7c7b\u8282\u70b9\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (root == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u6811\u4e3a\u7a7a\u3002", (String)"ReportQueryProcess_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = this.getCache("curNodeId");
        if (kd.bos.util.StringUtils.isEmpty((String)nodeId)) {
            return;
        }
        CustomTreeNode curNode = root.getTreeNode(nodeId, 10);
        if (curNode == null) {
            return;
        }
        Boolean isShare = this.isShareNode(curNode);
        Boolean isCatalog = Boolean.FALSE;
        if (isCatalog.booleanValue()) {
            this.getView().showTipNotification(errStr);
            return;
        }
        TabManager tabManager = this.getTabManager("tab_myinterest");
        TabInfo selectedTabInfo = tabManager.getSelectedTabInfo();
        if (operate.equalsIgnoreCase("add") && selectedTabInfo != null && selectedTabInfo.getUserObject("isNew") == null && !isShare.booleanValue()) {
            String templatemodelCache = this.getPageCache().get("TemplateModel");
            if (!StringUtils.isEmpty((String)templatemodelCache)) {
                ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templatemodelCache);
                templatemodelCache = TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel);
                this.getPageCache().put("TemplateModel", templatemodelCache);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)IDUtils.toLong((Object)curNode.getId()), (String)"eb_reportquery");
                if (dynamicObject != null) {
                    dynamicObject.set("dataset", (Object)templateModel.getTemplateBaseInfo().getDatasetID());
                    dynamicObject.set("data", (Object)templatemodelCache);
                    dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                    String querySetting = this.getCache("querysetting" + nodeId);
                    dynamicObject.set("querysetting", (Object)querySetting);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"ReportQueryProcess_76", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "ReportQueryProcess_80", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\uff01", "ReportQueryProcess_76", "epm-eb-formplugin"));
            this.refreshCustomTree();
            return;
        }
        if (isShare.booleanValue() && operate.equalsIgnoreCase("saveas")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u4eab\u7ed9\u6211\u7684\u62a5\u8868\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ReportQueryProcess_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map nodeData = curNode.getData();
        Map dataMap = nodeData;
        if (dataMap == null || !dataMap.containsKey("catalog") && !dataMap.containsKey("reportcatalog")) {
            this.getView().showTipNotification(errStr);
            return;
        }
        if (this.isShareNode(curNode).booleanValue()) {
            if (operate.equalsIgnoreCase("add")) {
                this.openReportQueryForm(callBackId, nodeId, "shareadd", curNode);
            } else {
                this.openReportQueryForm(callBackId, nodeId, "shareread", curNode);
            }
        } else {
            this.openReportQueryForm(callBackId, nodeId, operate, curNode);
        }
    }

    private void openReportQueryForm(String callBackId, String nodeId, String operate, CustomTreeNode curNode) {
        ShareSettingDto shareSettingDto;
        String querySetting;
        if (kd.bos.util.StringUtils.isEmpty((String)nodeId)) {
            return;
        }
        CustomTreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return;
        }
        CustomTreeNode treeNode = cacheTree.getTreeNode(curNode.getParentId(), 10);
        if (treeNode == null) {
            return;
        }
        String formId = "eb_reportquery";
        BaseShowParameter showParam = new BaseShowParameter();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("operate", operate);
        showParam.setFormId(formId);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        params.put("addReportNode", JSONObject.toJSONString((Object)treeNode));
        String caption = "";
        if (operate.equals("edit")) {
            params.put("id", nodeId);
            showParam.setPkId((Object)nodeId);
            showParam.setStatus(OperationStatus.EDIT);
            caption = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"ReportQueryProcess_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else if (operate.equals("saveas")) {
            params.put("id", nodeId);
            querySetting = this.getCache("querysetting" + nodeId);
            shareSettingDto = new ShareSettingDto();
            if (kd.bos.util.StringUtils.isNotEmpty((String)querySetting)) {
                shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)querySetting, ShareSettingDto.class);
            }
            this.setShareQuerySettingValue(shareSettingDto);
            params.put("querysetting", SerializationUtils.toJsonString((Object)shareSettingDto));
            showParam.setStatus(OperationStatus.ADDNEW);
            caption = ResManager.loadKDString((String)"\u53e6\u5b58\u4e3a-\u62a5\u8868\u4fe1\u606f", (String)"ReportQueryProcess_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else if (operate.equals("shareread")) {
            if (curNode != null) {
                params.put("reportcatalog", curNode.getParentId());
            }
            params.put("id", nodeId);
            showParam.setStatus(OperationStatus.ADDNEW);
            caption = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"ReportQueryProcess_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else if (operate.equals("shareadd")) {
            params.put("id", nodeId);
            querySetting = this.getCache("querysetting" + nodeId);
            shareSettingDto = new ShareSettingDto();
            if (kd.bos.util.StringUtils.isNotEmpty((String)querySetting)) {
                shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)querySetting, ShareSettingDto.class);
            }
            this.setShareQuerySettingValue(shareSettingDto);
            params.put("querysetting", SerializationUtils.toJsonString((Object)shareSettingDto));
            showParam.setStatus(OperationStatus.ADDNEW);
            caption = ResManager.loadKDString((String)"\u62a5\u8868\u4fe1\u606f", (String)"ReportQueryProcess_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            params.put("templateid", nodeId);
            ShareSettingDto shareSettingDto2 = new ShareSettingDto();
            this.setShareQuerySettingValue(shareSettingDto2);
            params.put("querysetting", SerializationUtils.toJsonString((Object)shareSettingDto2));
            showParam.setStatus(OperationStatus.ADDNEW);
            caption = ResManager.loadKDString((String)"\u62a5\u8868\u4fe1\u606f", (String)"ReportQueryProcess_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        showParam.setCaption(caption);
        StyleCss css = new StyleCss();
        css.setWidth("480px");
        css.setHeight("400px");
        showParam.getOpenStyle().setInlineStyleCss(css);
        String model = this.getCache("KEY_MODEL_ID");
        params.put("modelid", model);
        params.put("user", String.valueOf(this.getUserId()));
        params.put("templatetype", "1");
        showParam.setCustomParams(params);
        if (!kd.bos.util.StringUtils.isEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParam.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void dataUnitChange(String key) {
        String changeunit = key.substring(key.length() - 1, key.length());
        this.cacheDataUnit(changeunit);
        if (this.dynamicReportProcess == null) {
            this.dynamicReportProcess = new DynamicReportProcess();
        }
        this.dynamicReportProcess.setView(this.getView());
        this.dynamicReportProcess.initialize();
        this.dynamicReportProcess.dataUnitChange(key);
    }

    public void cacheDataUnit(String changeunit) {
        this.getPageCache().put("dataunit", changeunit);
    }

    public String getCacheDataUnit() {
        return this.getPageCache().get("dataunit");
    }

    private void hideShowEmptyRows(Boolean isVisible) {
        this.hideShowEmptyRowCols(true, isVisible);
    }

    private void hideShowEmptyCols(Boolean isVisible) {
        this.hideShowEmptyRowCols(false, isVisible);
    }

    private void hideShowEmptyRowCols(boolean isRow, boolean isVisible) {
        if (this.dynamicReportProcess == null) {
            this.initReportPlugin("1", "1");
        }
        if (isRow) {
            this.dynamicReportProcess.hideShowEmptyRows(isVisible);
            if (isVisible) {
                this.setCache("isEmptyrowsVisible", "true");
            } else {
                this.setCache("isEmptyrowsVisible", "false");
            }
        } else {
            this.dynamicReportProcess.hideShowEmptyCols(isVisible);
            if (isVisible) {
                this.setCache("isEmptycolsVisible", "true");
            } else {
                this.setCache("isEmptycolsVisible", "false");
            }
        }
    }

    private void openReportQuerySchemeEditPage(ITemplateModel templateModel) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("model", this.getModelId());
        params.put("TemplateModel", TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        params.put("dataset", this.getDataSetId());
        params.put("tarPkId", this.getPkIdFromTargetData());
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("eb_reportscheme");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u65b9\u6848", (String)"ReportQueryProcess_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.setBillStatus(BillOperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "btn_schemesaveas");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean checkExistRptTarScheme(ITemplateModel templateModelNew) {
        DynamicObjectCollection dynamicObjects;
        String templateModelCache = this.getCache("TemplateModel");
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateModelCache);
        if (this.checkTemplateModel(templateModel, templateModelNew)) {
            String templateModelCacheNew = TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModelNew);
            this.setCache("TemplateModel", templateModelCacheNew);
            templateModel = templateModelNew;
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicObjects = this.queryTarRptScheme(true)))) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                ITemplateModel existTemplateModel = TemplateModelJSONUtil.parseITemplateModel((String)dynamicObject.getString("data"));
                if (this.checkTemplateModel(templateModel, existTemplateModel)) continue;
                return true;
            }
        }
        return false;
    }

    private DynamicObjectCollection queryTarRptScheme(boolean defaultFlag) {
        QFilter qFilter1 = new QFilter("targetid", "=", (Object)IDUtils.toLong((Object)this.getPkIdFromTargetData()));
        QFilter qFilter2 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qFilter3 = new QFilter("dataset", "=", (Object)this.getDataSetId());
        if (BooleanUtils.isFalse((Boolean)defaultFlag)) {
            qFilter3.and(new QFilter("number", "!=", (Object)"default"));
        }
        return QueryServiceHelper.query((String)"eb_reportscheme", (String)"id,name,number,data", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)"number asc");
    }

    private boolean checkTemplateModel(ITemplateModel templateModel, ITemplateModel templateModelNew) {
        long modelIdNew;
        String headAreaSettingStrNew;
        String pageMembPropEntryStrNew;
        String viewPointMembEntryStrNew;
        String hideDimEntryStrNew;
        String partitionSettingStrNew;
        String areaRangeEntryStrNew;
        if (templateModel == null || templateModelNew == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u6a21\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ReportQueryProcess_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List pageMembEntry = templateModel.getPagemembentry();
        pageMembEntry = pageMembEntry.stream().sorted(Comparator.comparing(e -> e.getDimension().getDSeq())).collect(Collectors.toList());
        String pageMembEntryStr = SerializationUtils.toJsonString(pageMembEntry);
        List pageMembEntryNew = templateModelNew.getPagemembentry();
        String pageMembEntryStrNew = SerializationUtils.toJsonString(pageMembEntryNew = pageMembEntryNew.stream().sorted(Comparator.comparing(e -> e.getDimension().getDSeq())).collect(Collectors.toList()));
        if (!pageMembEntryStr.equals(pageMembEntryStrNew)) {
            return true;
        }
        String areaRangeEntryStr = SerializationUtils.toJsonString((Object)templateModel.getAreaRangeEntry());
        if (!areaRangeEntryStr.equals(areaRangeEntryStrNew = SerializationUtils.toJsonString((Object)templateModelNew.getAreaRangeEntry()))) {
            return true;
        }
        String partitionSettingStr = SerializationUtils.toJsonString((Object)templateModel.getPartitionSetting());
        if (!partitionSettingStr.equals(partitionSettingStrNew = SerializationUtils.toJsonString((Object)templateModelNew.getPartitionSetting()))) {
            return true;
        }
        String hideDimEntryStr = SerializationUtils.toJsonString((Object)templateModel.getHidedimentry());
        if (!hideDimEntryStr.equals(hideDimEntryStrNew = SerializationUtils.toJsonString((Object)templateModelNew.getHidedimentry()))) {
            return true;
        }
        String viewPointMembEntryStr = SerializationUtils.toJsonString((Object)templateModel.getViewpointmembentry());
        if (!viewPointMembEntryStr.equals(viewPointMembEntryStrNew = SerializationUtils.toJsonString((Object)templateModelNew.getViewpointmembentry()))) {
            return true;
        }
        String pageMembPropEntryStr = SerializationUtils.toJsonString((Object)templateModel.getPagemembpropentry());
        if (!pageMembPropEntryStr.equals(pageMembPropEntryStrNew = SerializationUtils.toJsonString((Object)templateModelNew.getPagemembpropentry()))) {
            return true;
        }
        String headAreaSettingStr = SerializationUtils.toJsonString((Object)templateModel.getHeadAreaSetting());
        if (!headAreaSettingStr.equals(headAreaSettingStrNew = SerializationUtils.toJsonString((Object)templateModelNew.getHeadAreaSetting()))) {
            return true;
        }
        long modelId = templateModel.getModelId();
        return modelId != (modelIdNew = templateModelNew.getModelId().longValue());
    }

    private void openFloatDesigner(ITemplateModel templateModel, boolean isShareNode) {
        if (templateModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efatemplateModel\u5931\u8d25\u3002", (String)"QueryReportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        this.setCache("pagePool", SerializationUtils.toJsonString(new HashMap()));
        String pageId = this.getPageIdInCache(this.getPageCache(), "eb_rptquerydesigner");
        this.beforeShowDesigner(pageId, true);
        showParameter.setPageId(pageId);
        showParameter.setFormId("eb_rptquerydesigner");
        showParameter.setCustomParam("TemplateModel", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("dataset", (Object)this.getDataSetId());
        showParameter.setCustomParam("targetPkId", (Object)this.getPkIdFromTargetData());
        showParameter.setCustomParam("targetFlag", (Object)this.getTargetFlag());
        showParameter.setCustomParam("cur_node_id", (Object)this.getCacheCurrentNode());
        showParameter.setCustomParam("cache_tab", (Object)this.getCache("cache_tab"));
        showParameter.setCustomParam(this.getCurNodeCacheName(), (Object)this.getCache(this.getCurNodeCacheName()));
        String querySettingCacheKey = "querysetting" + this.getCache("reportqueryid");
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.getCache(querySettingCacheKey))) {
            String querySetting = this.getCache(querySettingCacheKey);
            showParameter.setCustomParam("querysetting", (Object)querySetting);
        }
        showParameter.setCustomParam("isMyShareNode", (Object)isShareNode);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_rptquerydesigner"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u8ba1\u5668", (String)"ReportQueryProcess_74", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        this.setShowDimPanel(false);
    }

    private void afterGetTemplateModel(ITemplateModel templateModel) {
        String templateType = BgTemplateTypeEnum.DYNAMIC.getNumber();
        String isReport = "1";
        templateModel.setMetricCellStyleInfo(this.getMetricCellStyleInfo());
        String dataUnit = this.getOrCacheUnit(null);
        String memberShowTypeBtnKey = this.getOrCacheMemberShowType(null);
        if (kd.bos.util.StringUtils.isNotEmpty((String)dataUnit)) {
            templateModel.getTemplateBaseInfo().setDataunit(dataUnit.replaceAll("btn_unit", ""));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)memberShowTypeBtnKey)) {
            templateModel.getTemplateBaseInfo().setDimMemDefaultDisplayType(FixReportProcess.getMemberDisplayTypeFromBtnKey((String)memberShowTypeBtnKey));
        }
        this.setCache("TemplateModel", TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        HashMap<String, Long> defaultDimMember = new HashMap<String, Long>(16);
        HashMap bizRuleDimMember = new HashMap(16);
        for (IPageDimensionEntry p : templateModel.getPagemembentry()) {
            defaultDimMember.put(p.getDimension().getNumber(), ((IDimensionMember)p.getMembers().get(0)).getId());
            HashSet<String> memNums = new HashSet<String>(16);
            memNums.add(((IDimensionMember)p.getMembers().get(0)).getNumber());
            bizRuleDimMember.put(p.getDimension().getNumber(), memNums);
        }
        if (this.dynamicReportProcess == null) {
            this.initReportPlugin(templateType, isReport);
        }
        this.dynamicReportProcess.setTemplateModel(templateModel);
        this.dynamicReportProcess.setDefaultDimMember(defaultDimMember);
        Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
        TemplateTaskDto templateTaskDto = new TemplateTaskDto(Long.valueOf(0L), null, bizRuleDimMember);
        RuleRelationService.getInstance().bindRuleToOneTemplate(templateTaskDto, datasetId.longValue(), false, templateModel.getModelId());
        if (CollectionUtils.isNotEmpty((Collection)templateTaskDto.getRuleIds())) {
            this.dynamicReportProcess.setBizRules(templateTaskDto.getRuleIds());
            this.setCache("cache_bizRule_query", SerializationUtils.toJsonString((Object)templateTaskDto.getRuleIds()));
        } else {
            this.dynamicReportProcess.setBizRules(null);
            this.clearCache("cache_bizRule_query");
        }
        this.dynamicReportProcess.afterCreateNewData(null);
        this.getSpreadContainer().setVirtualMode("virtualModelCallBack", true);
        this.getSpreadContainer().lockSheets(Collections.singletonList("Sheet1"));
        this.getSpreadContainer().closeToolbar();
        this.getPageCache().put("isVirtualMode", "1");
        this.getSpreadContainer().setDisplayContent("", "", "");
        this.reCacheQuerySetting();
        this.saveUserQueryFilter(templateModel);
        this.setDefaultSchemeOfTargetData();
    }

    private void reCacheQuerySetting() {
        String querySetting = this.getCache("querysetting" + this.getCacheCurrentNode());
        ShareSettingDto shareSettingDto = new ShareSettingDto();
        if (kd.bos.util.StringUtils.isNotEmpty((String)querySetting)) {
            shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)querySetting, ShareSettingDto.class);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.getOrCacheMetricDisplay(null))) {
            shareSettingDto.setMetricDisplay((Map)SerializationUtils.fromJsonString((String)this.getOrCacheMetricDisplay(null), Map.class));
        }
        String hideEmptyDatCol = shareSettingDto.getHideEmptyDatCol();
        String hideEmptyDataRow = shareSettingDto.getHideEmptyDataRow();
        if ("0".equals(hideEmptyDataRow) && "0".equals(hideEmptyDatCol)) {
            this.hideShowEmptyCols(Boolean.TRUE);
            this.hideShowEmptyRows(Boolean.TRUE);
        } else if ("1".equals(hideEmptyDataRow) && "1".equals(hideEmptyDatCol)) {
            this.hideShowEmptyRows(Boolean.FALSE);
            this.hideShowEmptyCols(Boolean.FALSE);
        } else if ("1".equals(hideEmptyDataRow) && "0".equals(hideEmptyDatCol)) {
            this.hideShowEmptyRows(Boolean.FALSE);
            this.hideShowEmptyCols(Boolean.TRUE);
        } else if ("0".equals(hideEmptyDataRow) && "1".equals(hideEmptyDatCol)) {
            this.hideShowEmptyRows(Boolean.TRUE);
            this.hideShowEmptyCols(Boolean.FALSE);
        }
        this.dataUnitChange(shareSettingDto.getDataUnit());
        shareSettingDto.setMemberShowType(this.getOrCacheMemberShowType(null));
        this.setCache("querysetting" + this.getCacheCurrentNode(), SerializationUtils.toJsonString((Object)shareSettingDto));
    }

    private void saveUserQueryFilter(ITemplateModel templateModel) {
        Long dataSet;
        if (!this.isFromTargetCusReport() && !IDUtils.isNull((Long)(dataSet = this.getDataSetId()))) {
            ReportQueryHelper.SaveUserQueryScheme(ReportQueryHelper.getUserId(), this.getModelId(), dataSet, templateModel);
        }
    }

    private void setDefaultSchemeOfTargetData() {
        boolean tarRecordClickFlag;
        if (!this.isFromTargetCusReport() || this.getCache("cache_is_init_load_scheme") != null) {
            return;
        }
        String currentNodeId = this.getCacheCurrentNode();
        if (kd.bos.util.StringUtils.isEmpty((String)currentNodeId)) {
            return;
        }
        CustomTreeNode cacheTree = this.getCacheTree();
        CustomTreeNode treeNode = cacheTree.getTreeNode(currentNodeId, 10);
        if (treeNode == null) {
            return;
        }
        boolean bl = tarRecordClickFlag = "record".equals(this.getTargetFlag()) && !this.isCatalog(treeNode);
        if ("scheme".equals(this.getTargetFlag()) || tarRecordClickFlag) {
            DynamicObject defaultScheme = this.queryOneTarRptScheme("default");
            if (defaultScheme == null) {
                this.saveDefaultRptTarScheme();
            } else {
                defaultScheme.set("data", (Object)this.getCache("TemplateModel"));
                defaultScheme.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"ReportQueryProcess_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                defaultScheme.set("modifier", (Object)UserUtils.getUserId());
                defaultScheme.set("modifytime", (Object)TimeServiceHelper.now());
                SaveServiceHelper.update((DynamicObject)defaultScheme);
            }
            this.setSelectSchemeCombo("default");
        }
        this.setCache("cache_is_init_load_scheme", "1");
    }

    private void saveDefaultRptTarScheme() {
        DynamicObjectCollection saveDatas = new DynamicObjectCollection();
        DynamicObject scheme = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportscheme");
        scheme.set("number", (Object)"default");
        scheme.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"ReportQueryProcess_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        long schemeId = GlobalIdUtil.genGlobalLongId();
        scheme.set("id", (Object)schemeId);
        long dataSetId = this.getDataSetId();
        scheme.set("dataset", (Object)dataSetId);
        scheme.set("data", (Object)this.getCache("TemplateModel"));
        scheme.set("model", (Object)this.getModelId());
        scheme.set("targetid", (Object)this.getPkIdFromTargetData());
        scheme.set("creator", (Object)UserUtils.getUserId());
        scheme.set("createtime", (Object)TimeServiceHelper.now());
        scheme.set("modifier", (Object)UserUtils.getUserId());
        scheme.set("modifytime", (Object)TimeServiceHelper.now());
        saveDatas.add((Object)scheme);
        if (saveDatas.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])saveDatas.toArray((Object[])new DynamicObject[0])));
        }
    }

    private DynamicObject queryOneTarRptScheme(String number) {
        QFilter qFilter1 = new QFilter("number", "=", (Object)number);
        QFilter qFilter2 = new QFilter("targetid", "=", (Object)IDUtils.toLong((Object)this.getPkIdFromTargetData()));
        QFilter qFilter3 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qFilter4 = new QFilter("dataset", "=", (Object)this.getDataSetId());
        return BusinessDataServiceHelper.loadSingle((String)"eb_reportscheme", (String)"id,name,number,data,modifier,modifytime", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
    }

    private void openQuerySettingPage(ITemplateModel templateModel, boolean isMyShareNode) {
        String formId = "eb_querysetting";
        if (templateModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efatemplateModel\u5931\u8d25\u3002", (String)"QueryReportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("TemplateModel", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("dataset", (Object)this.getDataSetId());
        showParameter.setCustomParam("cache_tab", (Object)this.getCache("cache_tab"));
        showParameter.setCustomParam("cacheTreeNode", (Object)JSONObject.toJSONString((Object)this.getCacheTree()));
        showParameter.setCustomParam("currentNodeId", (Object)this.getCacheCurrentNode());
        showParameter.setCustomParam("reportId", (Object)this.getCache("curNodeId"));
        showParameter.setCustomParam("isMyShareNode", (Object)isMyShareNode);
        if (isMyShareNode) {
            String querySettingCacheKey = "querysetting" + this.getCache("reportqueryid");
            String cache_querySetting = this.getCache(querySettingCacheKey);
            if (cache_querySetting != null) {
                showParameter.setCustomParam("querysetting", (Object)cache_querySetting);
            }
        } else {
            ShareSettingDto shareSettingDto = new ShareSettingDto();
            this.setShareQuerySettingValue(shareSettingDto);
            showParameter.setCustomParam("querysetting", (Object)SerializationUtils.toJsonString((Object)shareSettingDto));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u4eab\u8bbe\u7f6e", (String)"QueryReportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (isMyShareNode) {
            StyleCss css = new StyleCss();
            css.setHeight("450px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u8be2\u8bbe\u7f6e", (String)"QueryReportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(showParameter);
    }

    public void showFormMetricDisplay() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
        formShowParameter.setCustomParam("metricdisplay", (Object)SerializationUtils.toJsonString(this.getMetricDisplays()));
        formShowParameter.setFormId("eb_metricdisplay");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "metricdisplay"));
        this.getView().showForm(formShowParameter);
    }

    private Map<String, Integer> getMetricDisplays() {
        String templateStr;
        HashMap<String, Integer> metricDisplays = new HashMap<String, Integer>(16);
        List metricCellStyleInfos = this.getMetricCellStyleInfo();
        if ((metricCellStyleInfos == null || metricCellStyleInfos.isEmpty()) && kd.bos.util.StringUtils.isNotEmpty((String)(templateStr = this.getCacheTemplatemodel()))) {
            ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateStr);
            metricCellStyleInfos = templateModel.getMetricCellStyleInfo();
        }
        if (metricCellStyleInfos != null) {
            metricCellStyleInfos.forEach(e -> {
                Integer decimal = MetricUtils.formatStr2Decimal((String)e.getFm());
                if (decimal != null) {
                    metricDisplays.put(e.getMetricNumber(), decimal);
                }
            });
        }
        DynamicObjectCollection dynamicObjects = MetricUtils.getMetricsByDataType((Long)this.getModelId(), (Set)Sets.newHashSet((Object[])new String[]{MetricDatatypeEnum.CURRENT.getIndex(), MetricDatatypeEnum.NOT_CURRENT.getIndex(), MetricDatatypeEnum.RATE.getIndex()}));
        for (DynamicObject dynamicObject : dynamicObjects) {
            metricDisplays.putIfAbsent(dynamicObject.getString("number"), dynamicObject.getInt("decimalnum"));
        }
        return metricDisplays;
    }

    private class ReportQuerySpreadAction
    extends SpreadActionAdapter
    implements ISpreadAction {
        public ReportQuerySpreadAction(AbstractFormPlugin plugin) {
            super(plugin);
        }

        public void invokePluginMethod(SpreadEvent event) {
            String methodname = (String)event.getPostData().getInvokeParams().get("invokemethod");
            LinkedHashMap params = event.getPostData().getInvokeParams();
            try {
                if (QueryReportPlugin.this.dynamicReportProcess != null) {
                    MethodUtils.invokeMethod((Object)QueryReportPlugin.this.dynamicReportProcess, (String)methodname, (Object)params);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }

        public void showFormulaPanel(SpreadEvent event) {
        }

        public void f7Click(SpreadEvent event) {
        }

        public void cellIsLocked(SpreadEvent event) {
        }

        public void getLookupData(SpreadEvent event) {
        }

        public void setItemByIdFromClient(SpreadEvent event) {
        }

        public void askExecute(SpreadEvent event) {
        }
    }
}

