/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;

public class ReportCatalogEditPlugin
extends AbstractBasePlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get("model");
        Object objParent = map.get("parent");
        this.getModel().setValue("model_id", objModel);
        if (!"0".equals(objParent)) {
            this.getModel().setValue("parent", objParent);
            if (objModel == null || objParent == null) {
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)os)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        IDataModel model = this.getModel();
        super.beforeDoOperation(evt);
        String type = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (type.equals("save")) {
            String number = model.getDataEntity().getString("number");
            String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
            FormShowParameter fromShowParams = this.getView().getFormShowParameter();
            if (fromShowParams.getStatus() == OperationStatus.ADDNEW && StringUtils.isNotEmpty((String)checkNumber)) {
                throw new KDBizException(checkNumber);
            }
            String existsStr = this.checkResult();
            if (!StringUtils.isEmpty((String)existsStr)) {
                this.getView().showTipNotification(existsStr);
                evt.cancel = true;
                return;
            }
            if (model.getDataEntity().getLong("id") == 0L) {
                String modelId = model.getDataEntity().getString("model_id");
                String parentId = model.getDataEntity().getString("parent_id");
                int seq = this.getCurNodeSequence(modelId, parentId);
                this.getModel().setValue("sequence", (Object)seq);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && issuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter parent = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        int result = 0;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getModel().getDataEntity().getDataEntityType().getName(), (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            result = dcs.stream().map(seqDy -> seqDy.getInt("sequence")).max((a, b) -> a > b ? 1 : -1).get();
            ++result;
        } else {
            result = 1;
        }
        return result;
    }

    private Boolean checkExistsCatalog(int checkModel) {
        Boolean result = false;
        IDataModel model = this.getModel();
        Long modelId = model.getDataEntity().getLong("model_id");
        Long userId = model.getDataEntity().getLong("creator_id");
        String number = model.getDataEntity().getString("number");
        String name = model.getDataEntity().getString("name");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("creator", "=", (Object)userId));
        if (1 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number);
            filters.add(nameOrNum);
        } else if (2 == checkModel) {
            QFilter nameOrNum = new QFilter("name", "=", (Object)name);
            filters.add(nameOrNum);
        } else if (3 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number).or(new QFilter("name", "=", (Object)name));
            filters.add(nameOrNum);
        } else if (4 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number).and(new QFilter("name", "=", (Object)name));
            filters.add(nameOrNum);
        }
        filters.add(new QFilter("id", "!=", (Object)model.getDataEntity().getLong("id")));
        result = QueryServiceHelper.exists((String)"eb_reportcatalog", (QFilter[])filters.toArray(new QFilter[0]));
        return result;
    }

    private String checkResult() {
        Boolean numCheck = this.checkExistsCatalog(1);
        Boolean nameCheck = this.checkExistsCatalog(2);
        if (numCheck.booleanValue() && nameCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u548c\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportCatalogEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (numCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportCatalogEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (nameCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportCatalogEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

