/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.tree.templatecatalog.ReportCustomTreeBuilder;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.report.designer.ShareSettingDto;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.formplugin.task.multi.TabInfo;
import kd.epm.eb.formplugin.task.multi.TabManager;
import kd.epm.eb.formplugin.template.templateview.DynamicTemplateProcess;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import org.apache.commons.lang.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

public class ReportQueryBasePlugin
extends AbstractFormPlugin
implements EBPermission {
    protected boolean checkErrorDisplayed = true;
    public static final String CACHE_TAB = "cache_tab";
    public static final String CACHE_MODEL = "KEY_MODEL_ID";
    public static final String CACHE_TREE = "treeData";
    public static final String CACHE_LONGNUMBER = "longNumber";
    public static final String CACHE_CURRENT_NODEID = "curNodeId";
    public static final String CACHE_FIRST_LOAD = "firstLoad";
    public static final String CACHE_CURRENT_NODE = "curNode";
    public static final String CACHE_TEMPLATE_MODEL = "TemplateModel";
    public static final String CACHE_DATASET = "dataset";
    public static final String CACHE_TEMPLATETYPE = "templatetype";
    public static final String CACHE_ISREPORT = "isreport";
    public static final String CACHE_F7KEY_DIM_MAP = "cache_f7key_dim_map";
    public static final String CACHE_BIZMODLE_DIMS = "cache_BizModel_dims";
    public static final String CACHE_REPORTQUERY = "reportqueryid";
    public static final String CACHE_IS_INIT_LOAD_SCHEME = "cache_is_init_load_scheme";
    public static final String CACHE_DIMCONTENT_VISIABLE = "cache_dimcontent_visiable";
    public static final String CACHE_FLOAT_DESIGNER_PAGE_ID = "floatDesignerPageId";
    public static final String CACHE_NO_EXECUTE_SHOW_IN_DESIGNER = "isNoExecuteShowInDesigner";
    public static final String CACHE_VARBASE = "varbaseforeb";
    public static final String CALLBACK_CATALOG_CLOSE = "catalog_close";
    public static final String CALLBACK_INTEREST_CLOSE = "interest_close";
    public static final String CALLBACK_BASEINFO_CLOSE = "baseinfo_close";
    public static final String CALLBACK_DELETE_REPORTCATALOG_COMFIRM = "delete_reportcatalog_comfirm";
    public static final String CALLBACK_UNINTEREST_COMFIRM = "uninterest_comfirm";
    public static final String CALLBACK_UNSTART_COMFIRM = "unstart_comfirm";
    public static final String CALLBACK_SELECTSHARE_COMFIRM = "selectShares_confirm";
    public static final String DEFAULT = "default";
    public static final String CACHE_TAR_SCHEME_FIRST = "cache_tar_scheme_first";
    public static final String CACHE_BIZRULEIDS_QUERY = "cache_bizRule_query";
    public static final String CACHE_TARGET_REFRESH = "cacheTargetRefresh";
    protected static final String SCHEME = "scheme";
    protected static final String RECORD = "record";
    public static final String CACHE_ALLDIMS = "cache_alldims";
    public DynamicReportProcess dynamicReportProcess = null;
    public DynamicTemplateProcess dynamicTemplateProcess = null;
    public static final String PERM_EDIT = "edit";
    public static final String PERM_PUBLIC = "public_update";
    public static final String PERM_ADD = "btn_saveasinterest";
    public static final String PERM_REMOVE = "remove";
    public static final String PERM_START = "btn_start";
    private IModelCacheHelper modelCacheHelper;
    private TabManager tabManager = null;
    private ISpreadContainer spreadContainer = null;

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        AdminModelUtil.checkAdminModeBeforeClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"modelswitch", "treepanelswitchrpt"}));
        if (evt.getSource() instanceof Control) {
            CustomTreeNode currentSelectNode;
            this.upgradeIntercept(this.getView(), ((Control)evt.getSource()).getKey());
            String key = ((Control)evt.getSource()).getKey();
            if ((key.equals("btn_up") || key.equals("btn_down")) && (currentSelectNode = this.getCurrentSelectNode()) != null) {
                if (currentSelectNode.getCategory().equals("report-public") || this.isCatalog(currentSelectNode) && StringUtils.isNotEmpty((String)currentSelectNode.getLongnumber()) && currentSelectNode.getLongnumber().startsWith("root.02_sys")) {
                    this.checkPermission(this.getView(), PERM_PUBLIC);
                } else {
                    this.checkPermission(this.getView(), PERM_EDIT);
                }
            }
        }
    }

    public void checkViewPermPreOpen(PreOpenFormEventArgs e) {
        String pkIdFromMessCenter = (String)e.getFormShowParameter().getCustomParam("pkId");
        if (StringUtils.isNotEmpty((String)pkIdFromMessCenter)) {
            e.getFormShowParameter().setAppId("bgm");
            String[] pkId = pkIdFromMessCenter.split("/");
            e.getFormShowParameter().setCustomParam("model", (Object)pkId[0]);
        }
        super.checkViewPermPreOpen(e);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_exit", "btn_exit1", "btn_close"}));
        String itemKey = evt.getItemKey();
        this.upgradeIntercept(this.getView(), evt.getItemKey());
        CustomTreeNode currentSelectNode = this.getCurrentSelectNode();
        if (("btn_interest".equals(itemKey) || "btn_uninterest".equals(itemKey) || PERM_ADD.equals(itemKey) || "btn_share".equals(itemKey) || "btn_sharerecord".equals(itemKey) || "btn_listshare".equals(itemKey) || "btn_listsharerecord".equals(itemKey)) && currentSelectNode != null) {
            if (currentSelectNode.getCategory().equals("report-public") || this.isCatalog(currentSelectNode) && StringUtils.isNotEmpty((String)currentSelectNode.getLongnumber()) && currentSelectNode.getLongnumber().startsWith("root.02_sys")) {
                this.checkPermission(this.getView(), PERM_PUBLIC);
            } else {
                this.checkPermission(this.getView(), itemKey);
            }
        }
    }

    protected void setModelLabel(String modelname) {
        ((Label)this.getControl("modellabel")).setText(modelname);
        ((Label)this.getControl("modellabelrpt")).setText(modelname);
    }

    public String getPkIdFromTargetData() {
        return (String)this.getView().getFormShowParameter().getCustomParam("targetPkId");
    }

    public String getTargetFlag() {
        return (String)this.getView().getFormShowParameter().getCustomParam("targetFlag");
    }

    public String getFromPageModelId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CACHE_MODEL);
    }

    public String getPkIdFromMessCenter() {
        return (String)this.getView().getFormShowParameter().getCustomParam("pkId");
    }

    protected void showConfirm(String msg, String callBackId) {
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
    }

    public Boolean isShareNode(CustomTreeNode treenode) {
        HashMap dataMap;
        Boolean result = false;
        if (treenode != null && treenode.getData() != null && (dataMap = (HashMap)treenode.getData()).containsKey("sharers")) {
            result = true;
        }
        return result;
    }

    public void setShareQuerySettingValue(ShareSettingDto shareSettingDto) {
        shareSettingDto.setDataUnit(this.getOrCacheUnit(null));
        shareSettingDto.setHideEmptyDataRow(this.getOrCacheHideEmptyRow(null));
        shareSettingDto.setHideEmptyDatCol(this.getOrCacheHideEmptyCol(null));
        shareSettingDto.setMemberShowType(this.getOrCacheMemberShowType(null));
        String metricDisplayStr = this.getOrCacheMetricDisplay(null);
        if (StringUtils.isNotEmpty((String)metricDisplayStr)) {
            shareSettingDto.setMetricDisplay((Map)SerializationUtils.fromJsonString((String)metricDisplayStr, Map.class));
        }
    }

    public String getOrCacheUnit(String unit) {
        if (unit == null) {
            String cache = this.getCache("cache_data_unit" + this.getCacheCurrentNode());
            if (StringUtils.isEmpty((String)cache)) {
                return "btn_unit0";
            }
            return cache;
        }
        this.setCache("cache_data_unit" + this.getCacheCurrentNode(), unit);
        return null;
    }

    public String getOrCacheMemberShowType(String memberShowType) {
        if (memberShowType == null) {
            String cache = this.getCache("cache_member_showtype" + this.getCacheCurrentNode());
            if (StringUtils.isEmpty((String)cache)) {
                return "show_dimname";
            }
            return cache;
        }
        this.setCache("cache_member_showtype" + this.getCacheCurrentNode(), memberShowType);
        return null;
    }

    public String getOrCacheHideEmptyRow(String hideEmptyRow) {
        if (hideEmptyRow == null) {
            String cache = this.getCache("cache_hide_empty_row" + this.getCacheCurrentNode());
            if (StringUtils.isEmpty((String)cache)) {
                return "0";
            }
            return cache;
        }
        this.setCache("cache_hide_empty_row" + this.getCacheCurrentNode(), hideEmptyRow);
        return null;
    }

    public String getOrCacheHideEmptyCol(String hideEmptyCol) {
        if (hideEmptyCol == null) {
            String cache = this.getCache("cache_hide_empty_col" + this.getCacheCurrentNode());
            if (StringUtils.isEmpty((String)cache)) {
                return "0";
            }
            return cache;
        }
        this.setCache("cache_hide_empty_col" + this.getCacheCurrentNode(), hideEmptyCol);
        return null;
    }

    protected String getOrCacheMetricDisplay(String metricdisplay) {
        if (metricdisplay == null) {
            String cache = this.getCache("cache_metricdisplay" + this.getCacheCurrentNode());
            if (StringUtils.isEmpty((String)cache)) {
                return "";
            }
            return cache;
        }
        this.setCache("cache_metricdisplay" + this.getCacheCurrentNode(), metricdisplay);
        return null;
    }

    public List<MetricCellStyleInfo> getMetricCellStyleInfo() {
        Map metricDisplays;
        LinkedList<MetricCellStyleInfo> metricCellStyleInfos = new LinkedList<MetricCellStyleInfo>();
        String metricdisplayStr = this.getOrCacheMetricDisplay(null);
        if (StringUtils.isNotEmpty((String)metricdisplayStr) && (metricDisplays = (Map)SerializationUtils.fromJsonString((String)metricdisplayStr, Map.class)) != null && metricDisplays.size() > 0) {
            metricDisplays.forEach((k, v) -> metricCellStyleInfos.add(new MetricCellStyleInfo(k, MetricUtils.decimal2FormatStr((Integer)v))));
        }
        return metricCellStyleInfos;
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    public TabManager getTabManager(String tabKey) {
        if (this.tabManager != null) {
            return this.tabManager;
        }
        String curTabManagerName = this.getCurTabManagerCacheName(tabKey);
        String str = this.getCache(curTabManagerName);
        this.tabManager = StringUtils.isNotEmpty((String)str) ? (TabManager)ObjectSerialUtil.deSerializedBytes((String)str) : new TabManager();
        return this.tabManager;
    }

    public ISpreadContainer getSpreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.getView(), "report");
        }
        return this.spreadContainer;
    }

    protected void enableAllReportToolbar() {
        this.getSpreadContainer().lockToolbarItems(new ArrayList(16), (List)Lists.newArrayList((Object[])ToolBarItemsEnum.values()));
        this.getSpreadContainer().hideContextMenuItems(new ArrayList(16), (List)Lists.newArrayList((Object[])ContextMenuItemsEnum.values()));
    }

    public String getSpreadKey() {
        return "report";
    }

    protected void cacheTabManager(String tabKey) {
        if (this.tabManager != null) {
            String curTabManagerName = this.getCurTabManagerCacheName(tabKey);
            this.setCache(curTabManagerName, ObjectSerialUtil.toByteSerialized((Object)this.tabManager));
        }
    }

    protected void closeAllTab() {
        String tabKey = this.isFromTargetCusReport() ? "tab_dimset" : "tab_myinterest";
        TabManager tabManager = this.getTabManager(tabKey);
        if (tabManager.getTabCount() == 0) {
            return;
        }
        List collect = tabManager.getTabs().stream().map(x -> x.getTabKey()).collect(Collectors.toList());
        for (String s : collect) {
            this.closeTab(s);
        }
    }

    protected void closeTab(String key) {
        if (key != null && !key.isEmpty()) {
            String tabKey = this.isFromTargetCusReport() ? "tab_dimset" : "tab_myinterest";
            TabManager tabManager = this.getTabManager(tabKey);
            if (tabManager.getTabCount() == 0) {
                return;
            }
            tabManager.releaseTabByKey(key);
            this.getView().executeClientCommand("closeTab", new Object[]{key});
            if (tabManager.getTabCount() == 0) {
                CustomTreeNode cacheTreeNode = this.getCacheTree();
                if (cacheTreeNode == null) {
                    return;
                }
                this.switchShowLeftPanel(true);
                this.clearCache(CACHE_CURRENT_NODEID);
                if (this.isFromTargetCusReport()) {
                    this.setCache(CACHE_FIRST_LOAD, "false");
                }
                this.refreshCustomTree();
            } else {
                TabInfo firstTabInfo = tabManager.getFirstTabInfo();
                if (firstTabInfo != null) {
                    tabManager.setSelectTabInfo(firstTabInfo.getTabKey());
                    this.fireClickTreeNodeAndFocus(firstTabInfo.getTabKey());
                }
            }
            this.cacheTabManager(tabKey);
        }
    }

    protected void removeReportTab(Long key) {
        if (key != null && key != 0L) {
            String tabKey = "tab_myinterest";
            TabManager tabManager = this.getTabManager(tabKey);
            tabManager.releaseTabByKey(String.valueOf(key));
            this.getView().executeClientCommand("closeTab", new Object[]{String.valueOf(key)});
            TabInfo firstTabInfo = tabManager.getFirstTabInfo();
            if (firstTabInfo != null) {
                tabManager.setSelectTabInfo(firstTabInfo.getTabKey());
            } else {
                this.switchShowLeftPanel(true);
            }
            this.cacheTabManager(tabKey);
        }
    }

    private String getCurTabManagerCacheName(String tabKey) {
        if (StringUtils.isEmpty((String)tabKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u770b\u9879\u4e3a\u7a7a", (String)"ReportQueryProcess_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String result = "";
        result = tabKey + "_tabManager";
        return result;
    }

    protected void setCache(String cacheKey, String cacheValue) {
        this.getPageCache().put(cacheKey, cacheValue);
    }

    protected void clearCache(String cacheKey) {
        this.getPageCache().remove(cacheKey);
    }

    protected String getCache(String cacheKey) {
        return this.getPageCache().get(cacheKey);
    }

    protected void clearCache(String prefix, String suffix) {
        Set allCacheKeys = this.getPageCache().getAll().keySet();
        List keys = null;
        if (StringUtils.isNotEmpty((String)prefix) && StringUtils.isNotEmpty((String)suffix)) {
            keys = allCacheKeys.stream().filter(e -> e.startsWith(prefix) && e.endsWith(suffix)).collect(Collectors.toList());
        } else if (StringUtils.isNotEmpty((String)prefix)) {
            keys = allCacheKeys.stream().filter(e -> e.startsWith(prefix)).collect(Collectors.toList());
        } else if (StringUtils.isNotEmpty((String)suffix)) {
            keys = allCacheKeys.stream().filter(e -> e.endsWith(suffix)).collect(Collectors.toList());
        }
        if (keys != null && keys.size() > 0) {
            this.getPageCache().batchRemove(keys);
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getCache(CACHE_MODEL));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelid"));
            if (IDUtils.isNull((Long)modelId)) {
                modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
            }
            if (IDUtils.isNull((Long)modelId)) {
                if (this.checkErrorDisplayed) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"ReportQueryProcess_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.checkErrorDisplayed = false;
                }
            } else {
                this.setCache(CACHE_MODEL, modelId.toString());
            }
        }
        return modelId == null ? Long.valueOf(0L) : modelId;
    }

    public Long getDataSetId() {
        String dataset = this.getCache(CACHE_DATASET);
        if (StringUtils.isEmpty((String)dataset)) {
            return 0L;
        }
        return Long.parseLong(dataset);
    }

    public CustomTreeNode getCacheTree() {
        String cache = this.getCache(CACHE_TREE);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)cache)) {
            return (CustomTreeNode)JSONObject.parseObject((String)cache, CustomTreeNode.class);
        }
        return null;
    }

    public String getCacheCurrentNode() {
        String cache = this.getCache(CACHE_CURRENT_NODEID);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)cache)) {
            return IDUtils.toString((Object)cache);
        }
        return null;
    }

    public CustomTreeNode getCurrentSelectNode() {
        String cacheCurrentNode = this.getCacheCurrentNode();
        if (StringUtils.isEmpty((String)cacheCurrentNode)) {
            return null;
        }
        CustomTreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return null;
        }
        return cacheTree.getTreeNode(cacheCurrentNode, 10);
    }

    protected void switchShowLeftPanel(boolean showLeftTree) {
        SplitContainer splitContainer = (SplitContainer)this.getControl("flexpanelap11");
        splitContainer.hidePanel(SplitDirection.left, !showLeftTree);
        this.getView().setVisible(Boolean.valueOf(!showLeftTree), new String[]{"treepanelswitchpanelrpt"});
        this.setCache("cache_LeftTree_visiable", showLeftTree ? "1" : "0");
    }

    public void refreshCustomTree() {
        this.refreshCustomTree(true);
    }

    public void refreshCustomTree(boolean needClick) {
        String cacheCurrentNode;
        CustomTreeNode customTreeNode = null;
        String defaultStr = "";
        HashSet startReport = new HashSet(16);
        if (this.isFromTargetCusReport()) {
            List<Long> dataSetIds = this.getDataSetIdsByTarget();
            String cache = this.getCache(CACHE_FIRST_LOAD);
            if (CollectionUtils.isNotEmpty(dataSetIds) && StringUtils.isEmpty((String)cache)) {
                defaultStr = IDUtils.toString((Object)dataSetIds.get(0));
            }
            customTreeNode = ReportCustomTreeBuilder.getDimSetCataTree((Long)this.getModelId(), (String)this.getClass().getName());
            ReportCustomTreeBuilder.addExistDimSetNodes((CustomTreeNode)customTreeNode, dataSetIds);
        } else {
            customTreeNode = ReportCustomTreeBuilder.getCustomTreeNode((Long)this.getModelId(), (Long)UserUtils.getUserId());
            ReportCustomTreeBuilder.addRptNodes((CustomTreeNode)customTreeNode, (Long)UserUtils.getUserId(), (Long)this.getModelId(), startReport);
        }
        CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
        ArrayList<CustomTreeNode> list = new ArrayList<CustomTreeNode>(16);
        if (customTreeNode != null) {
            list.add(customTreeNode);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String string = cacheCurrentNode = StringUtils.isNotEmpty((String)defaultStr) ? defaultStr : this.getCacheCurrentNode();
        if (customTreeNode != null) {
            CustomTreeNode treeNode;
            cacheCurrentNode = StringUtils.isNotEmpty((String)cacheCurrentNode) ? ((treeNode = customTreeNode.getTreeNode(cacheCurrentNode, 10)) != null ? treeNode.getId() : customTreeNode.getId()) : customTreeNode.getId();
        }
        map.put("list", list);
        map.put("skip", TimeServiceHelper.now());
        map.put("selectId", cacheCurrentNode);
        if (needClick) {
            map.put("needClick", true);
        }
        map.put("startId", startReport);
        customControl.setData(map);
        if (customTreeNode == null) {
            this.clearCache(CACHE_TREE);
        } else {
            this.setCache(CACHE_CURRENT_NODEID, cacheCurrentNode);
            this.setCache(CACHE_TREE, JSONObject.toJSONString((Object)customTreeNode));
        }
    }

    protected List<Long> getDataSetIdsByTarget() {
        List<Long> dataSetIds = new ArrayList<Long>(16);
        if (SCHEME.equalsIgnoreCase(this.getTargetFlag())) {
            Long id = Long.valueOf(this.getPkIdFromTargetData());
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bgm_targetscheme", (String)"id,number,name,bizmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            Long bizModel = dynamicObject.getLong("bizmodel");
            dataSetIds.add(bizModel);
        } else if (RECORD.equalsIgnoreCase(this.getTargetFlag())) {
            String dataSetStr = (String)this.getView().getFormShowParameter().getCustomParam("tarDataSets");
            dataSetIds = (List)SerializationUtils.fromJsonString((String)dataSetStr, List.class);
        }
        return dataSetIds;
    }

    public void treeFocusId(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("focusId", id);
        map.put("skip", TimeServiceHelper.now());
        customControl.setData(map);
    }

    public String getCacheTemplatemodel() {
        String templatemodelCache = this.getCache(CACHE_TEMPLATE_MODEL);
        if (!StringUtils.isEmpty((String)templatemodelCache)) {
            return templatemodelCache;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u62a5\u8868\u6a21\u677f\u3002", (String)"ReportQueryProcess_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return null;
    }

    protected boolean isCatalog(CustomTreeNode curNode) {
        return curNode != null && StringUtils.isNotEmpty((String)curNode.getCategory()) && !curNode.getCategory().startsWith("report") && !curNode.getCategory().equals("dim-category");
    }

    protected void fireClickTreeNodeAndFocus(String tabRepKey) {
        CustomTreeNode currentNode;
        CustomTreeNode root = this.getCacheTree();
        if (root != null && (currentNode = root.getTreeNode(tabRepKey, 20)) != null) {
            this.setCache(CACHE_CURRENT_NODEID, currentNode.getId());
            this.refreshCustomTree();
        }
    }

    protected boolean isFromTargetCusReport() {
        return StringUtils.isNotEmpty((String)this.getPkIdFromTargetData());
    }

    protected boolean isLeftTreeLocked() {
        return "1".equals(this.getCache("cache_lockLeftTree"));
    }

    public void clickRefresh() {
        this.refreshCustomTree();
    }

    protected String getCurNodeCacheName() {
        String tabKey = this.getCache(CACHE_TAB);
        String result = this.getCurNodeCacheName(tabKey);
        return result;
    }

    private String getCurNodeCacheName(String tabKey) {
        if (StringUtils.isEmpty((String)tabKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u770b\u9879\u4e3a\u7a7a", (String)"ReportQueryProcess_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String result = "";
        result = tabKey + "_nodeid";
        return result;
    }

    protected void beforeShowDesigner(String pageId, boolean isFloatForm) {
        IFormView view = this.getView().getView(this.getCache(CACHE_FLOAT_DESIGNER_PAGE_ID));
        if (view != null) {
            this.setCache(CACHE_NO_EXECUTE_SHOW_IN_DESIGNER, "1");
            view.close();
            this.getView().sendFormAction(view);
            this.clearCache(CACHE_NO_EXECUTE_SHOW_IN_DESIGNER);
        }
        if (isFloatForm) {
            this.setCache(CACHE_FLOAT_DESIGNER_PAGE_ID, pageId);
        }
    }

    protected void showInContainerDesigner(ITemplateModel templateModel, boolean isShareNode, boolean isEmptyData) {
        String querySettingCacheKey;
        this.getView().setVisible(Boolean.valueOf(!isShareNode), new String[]{"designer_switchlist", "designer_float"});
        this.setCache("isMyShareNode", SerializationUtils.toJsonString((Object)isShareNode));
        FormShowParameter showParameter = new FormShowParameter();
        this.setCache("pagePool", SerializationUtils.toJsonString(new HashMap()));
        String pageId = this.getPageIdInCache(this.getPageCache(), "eb_rptquerydesigner");
        this.beforeShowDesigner(pageId, false);
        showParameter.setPageId(pageId);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam(CACHE_DATASET, (Object)this.getDataSetId());
        showParameter.setCustomParam("targetPkId", (Object)this.getPkIdFromTargetData());
        showParameter.setCustomParam("targetFlag", (Object)this.getTargetFlag());
        showParameter.setCustomParam(CACHE_TAB, (Object)(this.isFromTargetCusReport() ? "tab_dimset" : "tab_myinterest"));
        showParameter.setCustomParam("cur_node_id", (Object)this.getCache(CACHE_CURRENT_NODEID));
        showParameter.setCustomParam("cache_tree_node", (Object)this.getCache(CACHE_TREE));
        showParameter.setCustomParam("tab_myinterest_nodeid", (Object)this.getCache(CACHE_CURRENT_NODEID));
        if (templateModel != null && !isEmptyData) {
            showParameter.setCustomParam(CACHE_TEMPLATE_MODEL, (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        } else {
            showParameter.setCustomParam(this.isFromTargetCusReport() ? "tab_dimset_nodeid" : "tab_myinterest_nodeid", (Object)this.getCache(CACHE_DATASET));
        }
        showParameter.setCustomParam(CACHE_REPORTQUERY, (Object)this.getCache(CACHE_REPORTQUERY));
        if (this.isFromTargetCusReport()) {
            showParameter.setCustomParam("needLockDim", (Object)this.getCache("needLockDim" + this.getCacheCurrentNode()));
        }
        boolean showQuerySetting = this.getCache(querySettingCacheKey = "querysetting" + this.getCache(CACHE_REPORTQUERY)) != null;
        this.getView().setVisible(Boolean.valueOf(showQuerySetting), new String[]{"btn_querysetting"});
        if (showQuerySetting) {
            String querySetting = this.getCache(querySettingCacheKey);
            showParameter.setCustomParam("querysetting", (Object)querySetting);
            ShareSettingDto shareSettingDto = (ShareSettingDto)SerializationUtils.fromJsonString((String)querySetting, ShareSettingDto.class);
            this.getOrCacheUnit(shareSettingDto.getDataUnit());
            this.getOrCacheHideEmptyRow(shareSettingDto.getHideEmptyDataRow());
            this.getOrCacheHideEmptyCol(shareSettingDto.getHideEmptyDatCol());
            this.getOrCacheMemberShowType(shareSettingDto.getMemberShowType());
            if (shareSettingDto.getMetricDisplay() != null) {
                this.getOrCacheMetricDisplay(SerializationUtils.toJsonString(shareSettingDto.getMetricDisplay()));
            }
        }
        showParameter.setCustomParam("isMyShareNode", (Object)isShareNode);
        showParameter.setFormId("eb_rptquerydesigner");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("designer");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u8ba1\u5668", (String)"ReportQueryProcess_74", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    protected String getPageIdInCache(IPageCache pageCache, String formId) {
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
        return pageId;
    }

    @Nullable
    protected CustomTreeNode getCustomEventNode(CustomEventArgs e) {
        CustomTreeNode customTreeNode = null;
        if (e.getEventArgs().indexOf("id") == -1) {
            CustomTreeNode cacheTree = this.getCacheTree();
            if (cacheTree != null) {
                customTreeNode = cacheTree.getTreeNode(e.getEventArgs(), 20);
            }
        } else {
            customTreeNode = (CustomTreeNode)JSONObject.parseObject((String)e.getEventArgs(), CustomTreeNode.class);
        }
        return customTreeNode;
    }
}

