/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;

public class ReportQueryEditPlugin
extends AbstractFormPlugin {
    private static final String CACHE_TEMPLATEMODEL = "TemplateModel";
    private static final String KEY_REPORTCATALOG = "reportcatalog";
    private static final String KEY_CATEGORYSELECT = "categoryselect";
    private static final String BAR_SAVE = "btn_ok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValues();
        this.setEnableStatus();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        String modelId = (String)fromShowParams.getCustomParam("modelid");
        String userId = (String)fromShowParams.getCustomParam("user");
        String type = (String)fromShowParams.getCustomParam("templatetype");
        this.getPageCache().put("modelid", modelId);
        this.getPageCache().put("user", userId);
        this.getPageCache().put("templatetype", type);
        IDataModel model = this.getModel();
        Object value = model.getValue(KEY_REPORTCATALOG);
        if (value instanceof DynamicObject) {
            DynamicObject category = (DynamicObject)value;
            this.setCategoryCombolItem(category.getLong("id"));
        }
    }

    private void setEnableStatus() {
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        String operate = (String)fromShowParams.getCustomParam("operate");
        if (operate.equalsIgnoreCase("shareread")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "description", KEY_REPORTCATALOG});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_SAVE});
        }
    }

    private void initValues() {
        IDataModel model = this.getModel();
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        String id = (String)fromShowParams.getCustomParam("id");
        String templateID = (String)fromShowParams.getCustomParam("templateid");
        String modelId = (String)fromShowParams.getCustomParam("modelid");
        String userId = (String)fromShowParams.getCustomParam("user");
        String type = (String)fromShowParams.getCustomParam("templatetype");
        String operate = (String)fromShowParams.getCustomParam("operate");
        String querySetting = (String)fromShowParams.getCustomParam("querysetting");
        Long category = 0L;
        if (fromShowParams.getStatus() == OperationStatus.ADDNEW) {
            DynamicObject rptQueryDy;
            if (operate.equalsIgnoreCase("saveas") || operate.equalsIgnoreCase("publicstart")) {
                DynamicObject reportcatalog;
                rptQueryDy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_reportquery");
                model.setValue("number", (Object)rptQueryDy.getString("number"));
                model.setValue("name", (Object)rptQueryDy.getString("name"));
                model.setValue("templatetype", (Object)rptQueryDy.getString("templatetype"));
                model.setValue("template_id", (Object)rptQueryDy.getLong("template_id"));
                model.setValue("description", (Object)rptQueryDy.getString("description"));
                model.setValue("dataset_id", (Object)rptQueryDy.getLong("dataset_id"));
                model.setValue("querysetting", (Object)querySetting);
                if (operate.equalsIgnoreCase("publicstart")) {
                    model.setValue("sourceid", (Object)IDUtils.toLong((Object)id));
                }
                if ((reportcatalog = rptQueryDy.getDynamicObject(KEY_REPORTCATALOG)) != null) {
                    category = rptQueryDy.getDynamicObject(KEY_REPORTCATALOG).getLong("id");
                }
            } else if (operate.equalsIgnoreCase("shareread") || operate.equalsIgnoreCase("shareadd") || operate.equalsIgnoreCase("sharestart")) {
                rptQueryDy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_reportshare");
                model.setValue("dataset_id", (Object)rptQueryDy.getLong("dataset_id"));
                model.setValue("number", (Object)rptQueryDy.getString("number"));
                model.setValue("name", (Object)rptQueryDy.getString("name"));
                model.setValue("querysetting", (Object)querySetting);
                String catalog = (String)fromShowParams.getCustomParam(KEY_REPORTCATALOG);
                Long catalongId = StringUtils.isEmpty((String)catalog) ? 0L : Long.parseLong(catalog);
                if (catalongId != 0L) {
                    DynamicObject rptCatalogDy = BusinessDataServiceHelper.loadSingle((Object)catalongId, (String)"eb_reportcatalog");
                    model.setValue(KEY_REPORTCATALOG, (Object)rptCatalogDy);
                }
                if (operate.equalsIgnoreCase("sharestart")) {
                    model.setValue("sourceid", (Object)IDUtils.toLong((Object)id));
                    catalongId = 0L;
                }
                model.setValue("description", (Object)rptQueryDy.getString("description"));
                category = catalongId;
            } else {
                model.setValue("description", (Object)"");
                if (!StringUtils.isEmpty((String)templateID)) {
                    String tabCache = this.getParentCache().get("cache_tab");
                    if (tabCache.equalsIgnoreCase("tab_rptquery")) {
                        DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)templateID, (String)"eb_templateentity");
                        model.setValue("number", (Object)templateDy.getString("number"));
                        model.setValue("name", (Object)templateDy.getString("name"));
                        model.setValue("templatetype", (Object)templateDy.getString("templatetype"));
                        model.setValue("template", (Object)templateDy);
                        model.setValue("description", (Object)templateDy.getString("name"));
                        model.setValue("dataset_id", (Object)templateDy.getLong("dataset_id"));
                    } else if (tabCache.equalsIgnoreCase("tab_dimset")) {
                        Long[] datasetIds;
                        boolean exists = QueryServiceHelper.exists((String)"eb_dataset", (Object)templateID);
                        if (!exists && (datasetIds = DatasetServiceHelper.queryDatasetIds((Long)IDUtils.toLong((Object)modelId))).length > 0) {
                            templateID = IDUtils.toString((Object)datasetIds[0]);
                        }
                        DynamicObject dataSetDy = BusinessDataServiceHelper.loadSingle((Object)templateID, (String)"eb_dataset");
                        model.setValue("number", (Object)dataSetDy.getString("number"));
                        model.setValue("name", (Object)dataSetDy.getString("name"));
                        model.setValue("description", (Object)dataSetDy.getString("description"));
                        model.setValue("dataset_id", (Object)dataSetDy.getLong("id"));
                        model.setValue("querysetting", (Object)querySetting);
                        if (!StringUtils.isEmpty((String)type)) {
                            model.setValue("templatetype", (Object)type);
                        }
                    } else if (tabCache.equalsIgnoreCase("tab_myinterest")) {
                        Long[] datasetIds;
                        boolean exists = QueryServiceHelper.exists((String)"eb_dataset", (Object)templateID);
                        if (!exists && (datasetIds = DatasetServiceHelper.queryDatasetIds((Long)IDUtils.toLong((Object)modelId))).length > 0) {
                            templateID = IDUtils.toString((Object)datasetIds[0]);
                        }
                        DynamicObject dataSetDy = BusinessDataServiceHelper.loadSingle((Object)templateID, (String)"eb_dataset");
                        model.setValue("dataset_id", (Object)dataSetDy.getLong("id"));
                        model.setValue("querysetting", (Object)querySetting);
                        if (!StringUtils.isEmpty((String)type)) {
                            model.setValue("templatetype", (Object)type);
                        }
                    }
                } else {
                    model.setValue("templatetype", (Object)"1");
                }
            }
            CustomTreeNode addReportNode = this.getAddReportNode();
            if (addReportNode != null) {
                model.setValue(KEY_REPORTCATALOG, (Object)addReportNode.getId());
                category = IDUtils.toLong((Object)addReportNode.getId());
            }
            model.setValue("model_id", (Object)modelId);
            model.setValue("creator_id", (Object)userId);
            model.setValue("createtime", (Object)TimeServiceHelper.now());
        } else if (fromShowParams.getStatus() == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        this.setCategoryCombolItem(category);
    }

    private void setCategoryCombolItem(Long defaultCategory) {
        QFilter qFilter = null;
        String model = this.getPageCache().get("modelid");
        if (StringUtils.isEmpty((String)model)) {
            model = (String)this.getView().getFormShowParameter().getCustomParam("modelid");
        }
        qFilter = !StringUtils.isEmpty((String)model) ? new QFilter("model", "=", (Object)Long.parseLong(model)) : new QFilter("model", "=", (Object)0);
        String userId = this.getPageCache().get("user");
        if (StringUtils.isEmpty((String)userId)) {
            userId = (String)this.getView().getFormShowParameter().getCustomParam("user");
        }
        CustomTreeNode addReportNode = this.getAddReportNode();
        String publicStr = "root.02_sys";
        String defStr = "root.01_sys";
        if (addReportNode != null) {
            if (StringUtils.isNotEmpty((String)addReportNode.getLongnumber()) && addReportNode.getLongnumber().startsWith(publicStr)) {
                qFilter.and(new QFilter("longnumber", "like", (Object)(publicStr + "%")));
                this.getModel().setValue("type", (Object)"1");
            } else {
                if (!StringUtils.isEmpty((String)userId)) {
                    qFilter.and(new QFilter("creator", "=", (Object)Long.parseLong(userId)));
                } else {
                    qFilter.and(new QFilter("creator", "=", (Object)0));
                }
                qFilter.and(new QFilter("longnumber", "like", (Object)(defStr + "%")));
            }
        } else {
            if (!StringUtils.isEmpty((String)userId)) {
                qFilter.and(new QFilter("creator", "=", (Object)Long.parseLong(userId)));
            } else {
                qFilter.and(new QFilter("creator", "=", (Object)0));
            }
            qFilter.and(new QFilter("longnumber", "like", (Object)(defStr + "%")));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_reportcatalog", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter}, (String)"longnumber");
        ComboEdit rangeEdit = (ComboEdit)this.getControl(KEY_CATEGORYSELECT);
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            Long temp = 0L;
            boolean isIncludeDefault = false;
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(query.size());
            for (DynamicObject dynamicObject : query) {
                list.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("id")));
                if ("01_sys".equals(dynamicObject.getString("number")) || "02_sys".equals(dynamicObject.getString("number"))) {
                    temp = dynamicObject.getLong("id");
                }
                if (isIncludeDefault) continue;
                isIncludeDefault = dynamicObject.getLong("id") == defaultCategory.longValue();
            }
            if (!isIncludeDefault && temp != 0L) {
                defaultCategory = temp;
            }
            rangeEdit.setComboItems(list);
        }
        this.getModel().setValue(KEY_CATEGORYSELECT, (Object)defaultCategory);
        this.getModel().setValue(KEY_REPORTCATALOG, (Object)defaultCategory);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if (KEY_CATEGORYSELECT.equals(name)) {
            Object newValue = changeData.getNewValue();
            this.getModel().setValue(KEY_REPORTCATALOG, newValue);
        }
    }

    private boolean isNewQuery() {
        String entityId = this.getView().getParentView().getEntityId();
        return "eb_reportqueryprocess".equals(entityId);
    }

    private void setModelBaseInfo(ITemplateModel templateModel) {
        IDataModel model = this.getModel();
        if (templateModel != null && templateModel.getTemplateBaseInfo() != null) {
            BgTemplate templateBaseInfo = templateModel.getTemplateBaseInfo();
            templateBaseInfo.setName(model.getDataEntity().getString("name"));
            templateBaseInfo.setNumber(model.getDataEntity().getString("number"));
            templateBaseInfo.setCatalog(Long.valueOf(model.getDataEntity().getLong("createorg_id")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        IDataModel model = this.getModel();
        super.beforeDoOperation(evt);
        String type = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (type.equals("save")) {
            String number = model.getDataEntity().getString("number");
            String name = model.getDataEntity().getString("name");
            if (name == null || StringUtils.isEmpty((String)name)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
            if (StringUtils.isNotEmpty((String)checkNumber)) {
                throw new KDBizException(checkNumber);
            }
            String check = this.checkResult();
            if (!StringUtils.isEmpty((String)check)) {
                this.getView().showTipNotification(check);
                evt.cancel = true;
                return;
            }
            String templatemodelCache = this.getParentCache().get(CACHE_TEMPLATEMODEL);
            FormShowParameter fromShowParams = this.getView().getFormShowParameter();
            if (this.isAddReport()) {
                templatemodelCache = (String)fromShowParams.getCustomParam(CACHE_TEMPLATEMODEL);
            }
            if (!StringUtils.isEmpty((String)templatemodelCache)) {
                ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templatemodelCache);
                this.setModelBaseInfo(templateModel);
                templatemodelCache = TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel);
                this.getParentCache().put(CACHE_TEMPLATEMODEL, templatemodelCache);
                model.setValue("data", (Object)templatemodelCache);
            } else if (!this.isAddReport()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u62a5\u8868\u6a21\u677f\u3002", (String)"ReportQueryEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.cancel = true;
                return;
            }
        }
    }

    private boolean isAddReport() {
        Object addReport = this.getView().getFormShowParameter().getCustomParam("addReport");
        return addReport != null;
    }

    private CustomTreeNode getAddReportNode() {
        Object addReport = this.getView().getFormShowParameter().getCustomParam("addReportNode");
        if (addReport == null) {
            return null;
        }
        return (CustomTreeNode)JSONObject.parseObject((String)((String)addReport), CustomTreeNode.class);
    }

    private String checkResult() {
        CustomTreeNode addReportNode = this.getAddReportNode();
        String publicStr = "root.02_sys";
        boolean isPublic = addReportNode != null && StringUtils.isNotEmpty((String)addReportNode.getLongnumber()) && addReportNode.getLongnumber().startsWith(publicStr);
        Boolean numCheck = this.checkExistsModel(1, isPublic);
        Boolean nameCheck = this.checkExistsModel(2, isPublic);
        if (numCheck.booleanValue() && nameCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u548c\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportQueryEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (numCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportQueryEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (nameCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58", (String)"ReportQueryEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private Boolean checkExistsModel(int checkModel, Boolean isPublic) {
        Boolean result = false;
        IDataModel model = this.getModel();
        Long modelId = model.getDataEntity().getLong("model_id");
        Long userId = model.getDataEntity().getLong("creator_id");
        String number = model.getDataEntity().getString("number");
        String name = model.getDataEntity().getString("name");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("model", "=", (Object)modelId));
        if (!isPublic.booleanValue()) {
            filters.add(new QFilter("creator", "=", (Object)userId));
        }
        if (1 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number);
            filters.add(nameOrNum);
        } else if (2 == checkModel) {
            QFilter nameOrNum = new QFilter("name", "=", (Object)name);
            filters.add(nameOrNum);
        } else if (3 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number).or(new QFilter("name", "=", (Object)name));
            filters.add(nameOrNum);
        } else if (4 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number).and(new QFilter("name", "=", (Object)name));
            filters.add(nameOrNum);
        }
        filters.add(new QFilter("id", "!=", (Object)model.getDataEntity().getLong("id")));
        result = QueryServiceHelper.exists((String)"eb_reportquery", (QFilter[])filters.toArray(new QFilter[0]));
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("save")) {
            boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
            if (issuccess) {
                HashMap<String, Object> result = new HashMap<String, Object>(2);
                result.put("result", "success");
                result.put("id", e.getOperationResult().getSuccessPkIds());
                this.getView().returnDataToParent(result);
                this.getView().close();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u6ce8\u5931\u8d25", (String)"ReportQueryEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private IPageCache getParentCache() {
        return (IPageCache)this.getView().getParentView().getService(IPageCache.class);
    }
}

