/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TemplateUpdateStatus;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.report.query.ShareRecordPOJO;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class ReportQueryHelper {
    private static final String PAGEPANEL_PREFIX = "pagedim";
    private static final String ROWPANEL_PREFIX = "rowdim";
    private static final String COLPANEL_PREFIX = "coldim";
    private static final String METRICPANEL_PREFIX = "metricdim";

    public static List<Long> getAccountByDataSet(Long datasetId) {
        List<Long> result = new ArrayList<Long>(16);
        QFilter idFilter = new QFilter("dataset", "=", (Object)datasetId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String dimFields = "id,number";
        DynamicObjectCollection accountDys = QueryServiceHelper.query((String)"epm_accountmembertree", (String)dimFields, (QFilter[])new QFilter[]{idFilter, statusFilter, enableFilter});
        if (accountDys.size() > 0) {
            result = accountDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return result;
    }

    public static Boolean isPassCheckPerm(String dimNum, Long modelId) {
        long userId = ReportQueryHelper.getUserId();
        Boolean isPass = false;
        Boolean isHasRootPerm = ModelServiceHelper.isUserHasRootPermByModel((long)userId, (Long)modelId);
        Boolean isNeedCheckDataPerm = DimMembPermUtil.needCheckDataPerm((String)dimNum, (Long)modelId);
        if (isHasRootPerm.booleanValue() || !isNeedCheckDataPerm.booleanValue()) {
            isPass = true;
        }
        return isPass;
    }

    public static List<Member> getPermTreeNode(String dimNum, List<Long> hasPermMembIds, Long busModelId, Long modelId, Long viewId) {
        Member rootMember;
        Long userId = ReportQueryHelper.getUserId();
        Boolean isPass = ReportQueryHelper.isPassCheckPerm(dimNum, modelId);
        Set permMemberIds = DimMembPermHelper.getPermMemberIds((Long)userId, (String)dimNum, (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Collection memberSort = null;
        if (orCreate != null && (rootMember = orCreate.getRootMember(dimNum, viewId)) != null) {
            memberSort = orCreate.getMemberSort(dimNum, viewId, rootMember.getNumber(), RangeEnum.ALL.getIndex());
        }
        if (CollectionUtils.isNotEmpty((Collection)permMemberIds)) {
            hasPermMembIds.addAll(permMemberIds);
            if (memberSort != null) {
                List<Member> collect = memberSort.stream().filter(x -> hasPermMembIds.contains(x.getId())).collect(Collectors.toList());
                return collect;
            }
        } else {
            Boolean isNeedCheckDataPerm = DimMembPermUtil.needCheckDataPerm((String)dimNum, (Long)modelId);
            Boolean isHasRootPerm = ModelServiceHelper.isUserHasRootPermByModel((long)userId, (Long)modelId);
            if ((isHasRootPerm.booleanValue() || !isNeedCheckDataPerm.booleanValue()) && memberSort != null) {
                hasPermMembIds.addAll(memberSort.stream().map(x -> x.getId()).collect(Collectors.toSet()));
                return memberSort;
            }
        }
        return null;
    }

    public static Map<String, String> getDimMapByDy(DynamicObject dy) {
        LinkedHashMap<String, String> map = null;
        DataEntityPropertyCollection propertyCollection = dy.getDynamicObjectType().getProperties();
        if (propertyCollection.containsKey((Object)"name") && propertyCollection.containsKey((Object)"number")) {
            map = new LinkedHashMap<String, String>();
            map.put("id", dy.getString("id"));
            map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
            map.put("number", dy.getString("number"));
            map.put("name", dy.getString("name"));
            map.put("pid", "");
        }
        return map;
    }

    public static Map<String, String> getDimMap(Long id, String num, String name, String ctrlKey, String showNumber) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", id.toString());
        map.put("scope", String.valueOf(RangeEnum.ONLY.getIndex()));
        map.put("number", num);
        map.put("name", name);
        map.put("sign", ctrlKey);
        map.put("pid", "");
        map.put("showNumber", showNumber);
        return map;
    }

    public static Long getDefaultModel(IFormView view) {
        Long modelId = 0L;
        String selectFields = "model.id as id,model.number as number,model.name as name ";
        List<QFilter> selFilters = ReportQueryHelper.getSelModelFilter();
        DynamicObject selModelDy = QueryServiceHelper.queryOne((String)"epm_userselect", (String)selectFields, (QFilter[])selFilters.toArray(new QFilter[selFilters.size()]));
        if (selModelDy != null) {
            return selModelDy.getLong("id");
        }
        selectFields = "id,number,name ";
        List<QFilter> defFilters = ReportQueryHelper.getDefModelFilter(view);
        DynamicObject defModelDy = QueryServiceHelper.queryOne((String)"epm_model", (String)selectFields, (QFilter[])defFilters.toArray(new QFilter[defFilters.size()]));
        if (defModelDy != null) {
            return defModelDy.getLong("id");
        }
        return modelId;
    }

    private static List<QFilter> getSelModelFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("modifier", "=", (Object)ReportQueryHelper.getUserId()));
        filters.add(new QFilter("application", "=", (Object)ApplicationTypeEnum.BGM.getIndex()));
        filters.add(new QFilter("formid", "=", (Object)"eb_reportqueryprocess"));
        return filters;
    }

    public static List<QFilter> getDefModelFilter(IFormView view) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter qcf = ModelUtil.getModelQfilterByApp((IFormView)view);
        filters.add(qcf);
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "!=", (Object)"0"));
        return filters;
    }

    public static void initReportContent(IFormView view) {
        SpreadContainer spContainer = new SpreadContainer(view, "report");
        spContainer.setVirtualMode("virtualModelCallBack", false);
        EBook book = new EBook(new String[]{" "});
        book.addSheet((ISheet)new ESheet());
        spContainer.rebuildSpread(book.getEmptyJson());
    }

    public static void spreadAll(TreeView tree, TreeNode root) {
        if (root == null) {
            return;
        }
        root.setIsOpened(true);
        ReportQueryHelper.spreadOrcollapseAllNode(root, true);
        tree.updateNode(root);
    }

    public static void collapseAll(TreeView tree, TreeNode root) {
        if (root == null) {
            return;
        }
        root.setIsOpened(false);
        if (null != root.getChildren()) {
            root.setIsOpened(false);
            List secondLevelNodes = root.getChildren();
            for (TreeNode node : secondLevelNodes) {
                ReportQueryHelper.spreadOrcollapseAllNode(node, false);
            }
        }
        tree.updateNode(root);
    }

    public static void expandCurrentNode(TreeView tree, TreeNode root, IFormView view) {
        if (StringUtils.isBlank((String)tree.getTreeState().getFocusNodeId())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8282\u70b9\u540e\u518d\u5c55\u5f00\u5f53\u524d\u4e0b\u7ea7\u3002", (String)"ReportQueryHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (root == null) {
            return;
        }
        TreeNode currentNode = root.getTreeNode(tree.getTreeState().getFocusNodeId(), 20);
        ReportQueryHelper.spreadOrcollapseAllNode(currentNode, true);
        tree.updateNode(currentNode);
        tree.focusNode(currentNode);
    }

    public static void shrinkCurrentNode(TreeView tree, TreeNode root, IFormView view) {
        if (StringUtils.isBlank((String)tree.getTreeState().getFocusNodeId())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8282\u70b9\u540e\u518d\u6536\u7f29\u5f53\u524d\u4e0b\u7ea7\u3002", (String)"ReportQueryHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (root == null) {
            return;
        }
        TreeNode currentNode = root.getTreeNode(tree.getTreeState().getFocusNodeId(), 20);
        ReportQueryHelper.spreadOrcollapseAllNode(currentNode, false);
        tree.updateNode(currentNode);
        tree.focusNode(currentNode);
    }

    private static void spreadOrcollapseAllNode(TreeNode treenode, boolean state) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(state);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode node : nodes) {
                ReportQueryHelper.spreadOrcollapseAllNode(node, state);
            }
        }
    }

    private static void focusFirstChildNode(TreeView tree, TreeNode root) {
        if (root.getChildren() != null && !root.getChildren().isEmpty() && root.getChildren().get(0) != null) {
            tree.focusNode((TreeNode)root.getChildren().get(0));
            tree.treeNodeClick(root.getId(), ((TreeNode)root.getChildren().get(0)).getId());
        }
    }

    public static void updateControlMetadata(String key, Map<String, Object> ctl, IFormView view) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }

    public static void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        textFiled.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(textFiled);
        field.setField((Field)textFiled);
        FieldEdit control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public static String getF7BaseKey(String ctrlKey) {
        String baseKey = ctrlKey;
        int lastPos = ctrlKey.lastIndexOf("_");
        String suffix = ctrlKey.substring(lastPos + 1);
        if (suffix.equals("row") || suffix.equals("col") || suffix.equals("page") || suffix.equals("position")) {
            baseKey = ctrlKey.substring(0, lastPos);
        }
        return baseKey;
    }

    public static DynamicObject getShareReport(Long tempId, Long modelId, String reportNum) {
        QFilter filter1 = new QFilter("receiver", "=", (Object)ReportQueryHelper.getUserId());
        QFilter filter2 = new QFilter("reportcatalog", "=", (Object)tempId);
        QFilter filter3 = new QFilter("modelid", "=", (Object)modelId);
        QFilter filter4 = new QFilter("number", "=", (Object)reportNum);
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"eb_reportshare", (String)"id,dataset as dataset_id,reportcatalog,name,number,data,templatetype,0", (QFilter[])new QFilter[]{filter3, filter1, filter2, filter4});
        return dyna;
    }

    public static Long getCatalogId(String tab, String id, Boolean isShare) {
        Long catalogId = 0L;
        if (tab.equals("tab_rptquery")) {
            QFilter filter1 = new QFilter("id", "=", (Object)IDUtils.toLong((Object)id));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"templatecatalog", (QFilter[])new QFilter[]{filter1});
            if (dynamicObject != null) {
                catalogId = dynamicObject.getLong("templatecatalog");
            }
        } else if (tab.equals("tab_myinterest")) {
            QFilter filter1 = new QFilter("id", "=", (Object)IDUtils.toLong((Object)id));
            String formId = isShare != false ? "eb_reportshare" : "eb_reportquery";
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)formId, (String)"reportcatalog", (QFilter[])new QFilter[]{filter1});
            if (dynamicObject != null) {
                catalogId = dynamicObject.getLong("reportcatalog");
            }
        }
        return catalogId;
    }

    public static Map<String, String> getDimMap(Long id, String number, String name, int seq, String entity, String sign, String panel) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("id", id + "");
        map.put("number", number);
        map.put("name", name);
        map.put("seq", seq + "");
        map.put("entity", entity);
        map.put("sign", sign);
        map.put("panel", panel);
        return map;
    }

    public static void setViewValue(IFormView view, String key, Object value, Boolean isFireChange) {
        IDataModel model = view.getModel();
        if (!isFireChange.booleanValue()) {
            model.beginInit();
            model.setValue(key, value);
            view.updateView(key);
            model.endInit();
        } else {
            model.setValue(key, value);
        }
    }

    public static void getDataDimChilds(String nodeId, DynamicObjectCollection docs, List<String> dataDimChilds) {
        for (DynamicObject doc : docs) {
            if (!doc.getString("parent").equals(nodeId)) continue;
            dataDimChilds.add(doc.get("id").toString());
            ReportQueryHelper.getDataDimChilds(doc.get("id").toString(), docs, dataDimChilds);
        }
    }

    public static Map<Long, Set<Long>> judgeIsRepeatShare(Long sharer, List<Long> receivers, String reportid, Boolean isCheckStatus) {
        return ReportQueryHelper.judgeIsRepeatShare(sharer, receivers, Collections.singletonList(reportid), isCheckStatus, null);
    }

    public static boolean exitPublicReport(Long modelId, List<Long> reportIds) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("id", "in", reportIds);
        DynamicObjectCollection type = QueryServiceHelper.query((String)"eb_reportquery", (String)"type", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)type)) {
            return false;
        }
        boolean type1 = type.stream().anyMatch(x -> "1".equals(x.getString("type")));
        return type1;
    }

    public static Map<Long, Set<Long>> judgeIsRepeatShare(Long sharer, List<Long> receivers, List<String> reportid, Boolean isCheckStatus, List<ShareRecordPOJO> existsRecord) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("sharers", "=", (Object)sharer));
        filters.add(new QFilter("receiver", "in", receivers));
        filters.add(new QFilter("reportid", "in", reportid));
        if (isCheckStatus.booleanValue()) {
            filters.add(new QFilter("sharestatus", "=", (Object)"A"));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_reportshare", (String)"id,name,reportid,number,receiver,receiver.name", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = dynamicObject.getLong("id");
            Long reciverId = dynamicObject.getLong("receiver");
            if (existsRecord != null) {
                ShareRecordPOJO shareRecordPOJO = new ShareRecordPOJO();
                shareRecordPOJO.setReportId(dynamicObject.getLong("reportid"));
                shareRecordPOJO.setReceiverId(reciverId);
                shareRecordPOJO.setId(id);
                existsRecord.add(shareRecordPOJO);
            }
            if (result.containsKey(reciverId)) {
                ((Set)result.get(reciverId)).add(id);
                continue;
            }
            HashSet<Long> reportShareIds = new HashSet<Long>(16);
            reportShareIds.add(id);
            result.put(reciverId, reportShareIds);
        }
        return result;
    }

    public static int delRepeatShare(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return 0;
        }
        QFilter filter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{filter};
        return DeleteServiceHelper.delete((String)"eb_reportshare", (QFilter[])filters);
    }

    public static String getF7KeyByControls(List<ControlAp<?>> controlAps) {
        ArrayList<String> keys = new ArrayList<String>(16);
        if (controlAps == null || controlAps.size() == 0) {
            return "";
        }
        for (ControlAp<?> ap : controlAps) {
            if (!ReportQueryHelper.checkControlKey(ap.getKey())) continue;
            keys.add(ap.getKey());
        }
        return SerializationUtils.toJsonString(keys);
    }

    public static boolean checkControlKey(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return controlKey.startsWith("ebf7_");
    }

    public static String getCtrlKeySuffix(String ctrlKey) {
        int pos = ctrlKey.lastIndexOf("_");
        String suffix = ctrlKey.substring(pos + 1);
        return suffix;
    }

    public static String getCtrlKeyPrefix(String ctrlKey) {
        return ctrlKey.substring(0, ctrlKey.lastIndexOf("_"));
    }

    public static Set<Long> getLongList(List<String> idStrs) {
        Set<Long> result = new HashSet<Long>(16);
        if (idStrs != null && idStrs.size() > 0) {
            result = idStrs.stream().map(id -> IDUtils.toLong((Object)id)).collect(Collectors.toSet());
        }
        return result;
    }

    public static long getUserId() {
        return UserUtils.getUserId();
    }

    public static long getDataModelByDataSetId(long dataSetId) {
        long dataModlId = 0L;
        if (dataSetId == 0L) {
            return 0L;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("id", "=", (Object)dataSetId));
        String selectFields = "businessmodel_id as dataModlId";
        DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_dataset", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (dy != null) {
            dataModlId = dy.getLong("dataModlId");
        }
        return dataModlId;
    }

    public static long getDimViewId(IModelCacheHelper modelCacheHelper, long dataSet, long dimensionId) {
        return ReportQueryHelper.getDimViewId(modelCacheHelper, dataSet, dimensionId, (Boolean)true);
    }

    public static long getDimViewId(IModelCacheHelper modelCacheHelper, long dataSet, long dimensionId, Boolean isAll) {
        if (dimensionId == 0L || modelCacheHelper == null) {
            return 0L;
        }
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimensionId));
        if (dimension == null) {
            return 0L;
        }
        Long viewByDataSetAndDimNumber = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(dataSet), dimension.getNumber());
        if (IDUtils.isNull((Long)viewByDataSetAndDimNumber)) {
            return 0L;
        }
        return viewByDataSetAndDimNumber;
    }

    public static long getDimViewId(IModelCacheHelper modelCacheHelper, long dataSet, String dimNumber) {
        return ReportQueryHelper.getDimViewId(modelCacheHelper, dataSet, dimNumber, (Boolean)true);
    }

    public static long getDimViewId(IModelCacheHelper modelCacheHelper, long dataSet, String dimensionNumber, Boolean isAll) {
        if (dimensionNumber == null || modelCacheHelper == null) {
            return 0L;
        }
        Long viewByDataSetAndDimNumber = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(dataSet), dimensionNumber);
        if (IDUtils.isNull((Long)viewByDataSetAndDimNumber)) {
            return 0L;
        }
        return viewByDataSetAndDimNumber;
    }

    public static Map<Long, Long> getViewByDataSet(IModelCacheHelper modelCacheHelper, long dataSetId) {
        if (modelCacheHelper == null || IDUtils.isNull((long)dataSetId)) {
            return new HashMap<Long, Long>(16);
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        Map viewGroupViewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(dataSetId));
        for (Map.Entry temp : viewGroupViewsByDataSet.entrySet()) {
            Dimension dimension = modelCacheHelper.getDimension((String)temp.getKey());
            result.put(dimension.getId(), (Long)temp.getValue());
        }
        return result;
    }

    public static Map<Long, DynamicObject> getMemsByDataSet(long view, long dimid) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        String selectFields = "memberid as memid,dimension.number as dimnum,dimension as dimid ,id ,aggoprt,level,name,number";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("view", "=", (Object)view));
        filters.add(new QFilter("dimension", "=", (Object)dimid));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection memDys = QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        for (DynamicObject dy : memDys) {
            result.put(dy.getLong("memid"), dy);
        }
        return result;
    }

    public static List<DynamicObject> getDefDys(Map<Long, DynamicObject> memDysMap) {
        List<Object> result = new ArrayList(16);
        result = memDysMap.values().stream().filter(dy -> "2".equalsIgnoreCase(dy.getString("level"))).collect(Collectors.toList());
        if (result.size() == 0) {
            result = memDysMap.values().stream().filter(dy -> "1".equalsIgnoreCase(dy.getString("level"))).collect(Collectors.toList());
        }
        return result;
    }

    public static Long saveTemplate(ITemplateModel templateModel, String data) {
        BgTemplate bgTemplate = templateModel.getTemplateBaseInfo();
        DynamicObject t = ORM.create().newDynamicObject("eb_templateentity");
        Long tempId = DBServiceHelper.genGlobalLongId();
        t.set("id", (Object)String.valueOf(tempId));
        t.set("modifier", (Object)UserUtils.getUserId());
        t.set("creator", (Object)UserUtils.getUserId());
        t.set("name", (Object)bgTemplate.getName());
        t.set("number", (Object)bgTemplate.getNumber());
        t.set("model", (Object)bgTemplate.getModelID());
        t.set("dataunit", (Object)bgTemplate.getDataunit());
        t.set("dataset", (Object)bgTemplate.getDatasetID());
        t.set("templateCatalog", (Object)"-1");
        t.set("tempversion", (Object)TemplateUpdateStatus.SUCCEED.getValue());
        t.set("createTime", (Object)TimeServiceHelper.now());
        t.set("modifyTime", (Object)TimeServiceHelper.now());
        t.set("effectivedate", (Object)TimeServiceHelper.now());
        t.set("templatetype", (Object)BgTemplateTypeEnum.DYNAMIC.getNumber());
        t.set("data", (Object)data);
        t.set("isrelation", (Object)"1".equals(bgTemplate.getIsDimRelation()));
        DynamicObjectCollection dimrelationinfos = t.getDynamicObjectCollection("dimrelationinfo2");
        List dimRelations = bgTemplate.getDimRelations();
        if (dimRelations != null) {
            for (Long dimRelation : dimRelations) {
                DynamicObject basedata = new DynamicObject(dimrelationinfos.getDynamicObjectType());
                basedata.set("fbasedataid", (Object)dimRelation);
                dimrelationinfos.add((Object)basedata);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{t});
        return tempId;
    }

    public static void saveReportQuery(long id, ITemplateModel templateModel, Boolean isShareRpt) {
        String entryName;
        DynamicObject reportQueryDy;
        if (templateModel != null && (reportQueryDy = BusinessDataServiceHelper.loadSingleFromCache((String)(entryName = isShareRpt != false ? "eb_reportshare" : "eb_reportquery"), (String)"id,data", (QFilter[])new QFBuilder("id", "=", (Object)id).toArray())) != null) {
            String data = TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel);
            reportQueryDy.set("data", (Object)data);
            BusinessDataServiceHelper.save((IDataEntityType)reportQueryDy.getDataEntityType(), (Object[])new Object[]{reportQueryDy});
        }
    }

    public static List<String> getDimsByQueryScheme(String sign, Map<String, Map<String, String>> queryScheme, Boolean isLower) {
        List<String> dimList = new ArrayList<String>(16);
        if (queryScheme != null) {
            String dim2 = "";
            for (Map<String, String> queryDim : queryScheme.values()) {
                dim2 = queryDim.get("dim");
                if (!sign.equals(queryDim.get("posfix")) || dimList.contains(dim2)) continue;
                dimList.add(dim2);
            }
        }
        if (dimList.size() == 0) {
            if (sign.equals(ROWPANEL_PREFIX)) {
                dimList.add(SysDimensionEnum.Account.getNumber());
            } else if (sign.equals(COLPANEL_PREFIX)) {
                dimList.add(SysDimensionEnum.BudgetPeriod.getNumber());
                dimList.add(SysDimensionEnum.Metric.getNumber());
            }
        }
        if (isLower.booleanValue()) {
            dimList = dimList.stream().map(dim -> dim.toLowerCase()).collect(Collectors.toList());
        }
        return dimList;
    }

    public static Map<String, String> getQueryDimMap(String dim, List<String> memIds, String posfix, String pos) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("dim", dim);
        result.put("mem", String.join((CharSequence)",", memIds));
        result.put("posfix", posfix);
        result.put("pos", pos);
        return result;
    }

    public static Map<String, Map<String, String>> getUserQueryScheme(long userId, long modelId, long datasetId) {
        Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(16);
        DynamicObject querySchemeDy = ReportQueryHelper.getUserQuerySchemeDy(userId, modelId, datasetId, false);
        if (querySchemeDy != null && !StringUtils.isEmpty((String)querySchemeDy.getString("data"))) {
            result = (Map)SerializationUtils.fromJsonString((String)querySchemeDy.getString("data"), Map.class);
        }
        return result;
    }

    public static DynamicObject getUserQuerySchemeDy(long userId, long modelId, long datasetId, Boolean all) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("userid", "=", (Object)userId));
        filters.add(new QFilter("formid", "=", (Object)"eb_reportqueryprocess"));
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("dataset", "=", (Object)datasetId));
        if (!all.booleanValue()) {
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        DynamicObject querySchemeDy = QueryServiceHelper.queryOne((String)"eb_userparameter", (String)"id,data,templatemodel,paramtype", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        return querySchemeDy;
    }

    public static void deleleUserQuerySchemeDys(long userId, long modelId, List<Long> datasetIds, Boolean all) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("userid", "=", (Object)userId));
        filters.add(new QFilter("formid", "=", (Object)"eb_reportqueryprocess"));
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("dataset", "in", datasetIds));
        if (!all.booleanValue()) {
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        DeleteServiceHelper.delete((String)"eb_userparameter", (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }

    public static void deleleUserQuerySchemeDy(long userId, long modelId, long datasetId, Boolean all) {
        List<Long> datasetIds = Collections.singletonList(datasetId);
        ReportQueryHelper.deleleUserQuerySchemeDys(userId, modelId, datasetIds, all);
    }

    public static void SaveUserQueryScheme(long userId, long modelId, long datasetId, ITemplateModel templateModel) {
        ReportQueryHelper.deleleUserQuerySchemeDy(userId, modelId, datasetId, true);
        Date nowDate = TimeServiceHelper.now();
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_userparameter");
        rootDy.set("model", (Object)modelId);
        rootDy.set("dataset", (Object)datasetId);
        rootDy.set("userid", (Object)userId);
        rootDy.set("formid", (Object)"eb_reportqueryprocess");
        rootDy.set("paramtype", (Object)"0");
        rootDy.set("templatemodel", (Object)TemplateModelJSONUtil.toJSONString((ITemplateModel)templateModel));
        rootDy.set("status", (Object)"C");
        rootDy.set("enable", (Object)"1");
        rootDy.set("creator", (Object)userId);
        rootDy.set("createtime", (Object)nowDate);
        rootDy.set("number", (Object)"");
        rootDy.set("name", (Object)"");
        DynamicObject[] rootDys = new DynamicObject[]{rootDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
    }

    public static Map<String, List<DynamicObject>> orderMapByQuery(Map<String, List<DynamicObject>> datasetDimMap, List<String> orderDims) {
        LinkedHashMap<String, List<DynamicObject>> result = new LinkedHashMap<String, List<DynamicObject>>(datasetDimMap.size());
        for (String orderDim : orderDims) {
            if (!datasetDimMap.containsKey(orderDim)) continue;
            result.put(orderDim, datasetDimMap.get(orderDim));
        }
        List lastDims = datasetDimMap.keySet().stream().filter(dim -> !result.containsKey(dim)).collect(Collectors.toList());
        for (String lastDim : lastDims) {
            result.put(lastDim, datasetDimMap.get(lastDim));
        }
        return result;
    }
}

