/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.enums.ReportQueryStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserQueryResult;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;
import kd.epm.eb.formplugin.report.query.ReportQueryListPagePlugin;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class ReportQueryListDataPlugin
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log log = LogFactory.getLog(ReportQueryListDataPlugin.class);
    private static Map<String, String> tableFieldMap = new HashMap<String, String>(10);
    private static final String SELECTFIELDS = "id as repid, template,status as repstatus ,entity,entity.number as entitynumber,modifier.name as modifier ,modifydate,submituser.name as submitter,submitdate as submittime,approvebill,'' as auditor, 0 as versionconstrast";
    private static final String[] selectFiled;
    private static final String[] selectFiledFinish;
    private static final String[] selectFiledReview;
    private static final String[] selectFiledLeft;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        boolean noPermEmpty;
        Map customParam = reportQueryParam.getCustomParam();
        log.info("query reportQueryParam:{}", (Object)JSONObject.toJSONString((Object)customParam));
        if (customParam == null) {
            return this.noData(null);
        }
        HashSet orgSet = (HashSet)customParam.get("orgId");
        HashSet templateSet = (HashSet)customParam.get("tempId");
        HashSet noPermOrgSet = (HashSet)customParam.get("noPermOrgId");
        HashSet noPermTemplateSet = (HashSet)customParam.get("noPermTempId");
        String varCacheId = (String)customParam.get("varCacheId");
        boolean hasPremEmpty = orgSet == null || templateSet == null;
        boolean bl = noPermEmpty = noPermOrgSet == null || noPermTemplateSet == null;
        if (hasPremEmpty && noPermEmpty) {
            return this.noData(varCacheId);
        }
        List tableHeadFilterItems = reportQueryParam.getFilter().getTableHeadFilterItems();
        QFilter rowFilter = this.getRowFilter(customParam, orgSet, templateSet);
        String sortInfo = reportQueryParam.getSortInfo() == null ? "repnumber" : reportQueryParam.getSortInfo();
        String[] s = sortInfo.split(" ");
        if (s.length > 1) {
            sortInfo = tableFieldMap.get(s[0]) + " " + s[1];
        }
        HashSet currentStatus = (HashSet)customParam.get("currentStatus");
        StringBuilder sqlBd = new StringBuilder("repstatus in ( ");
        currentStatus.forEach(m -> sqlBd.append("'").append(m).append("'").append(","));
        String substring = sqlBd.substring(0, sqlBd.length() - 1);
        if (!hasPremEmpty && !noPermEmpty) {
            DataSet dataSetHasPerm = this.getProcess(rowFilter, null, customParam, orgSet, varCacheId);
            DataSet dataSetNoPerm = this.getTaskProcess(customParam, noPermOrgSet, noPermTemplateSet);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String qFilterStr = this.buildTableHeadFilter(tableHeadFilterItems, map);
            if (dataSetHasPerm.isEmpty() && dataSetNoPerm.isEmpty()) {
                return this.noData(varCacheId);
            }
            if (dataSetHasPerm.isEmpty()) {
                DataSet dataSet1 = dataSetNoPerm.filter(substring + ")").orderBy(new String[]{sortInfo});
                if (StringUtils.isNotEmpty((String)qFilterStr)) {
                    DataSet filter = dataSet1.filter(qFilterStr, map);
                    DataSet copy = dataSetNoPerm.copy();
                    this.countStatus(copy, varCacheId);
                    return filter;
                }
                DataSet copy = dataSetNoPerm.copy();
                this.countStatus(copy, varCacheId);
                return dataSet1;
            }
            if (dataSetNoPerm.isEmpty()) {
                DataSet dataSet1 = dataSetHasPerm.filter(substring + ")").orderBy(new String[]{sortInfo});
                if (StringUtils.isNotEmpty((String)qFilterStr)) {
                    DataSet filter = dataSet1.filter(qFilterStr, map);
                    DataSet copy = dataSetHasPerm.copy();
                    this.countStatus(copy, varCacheId);
                    return filter;
                }
                DataSet copy = dataSetHasPerm.copy();
                this.countStatus(copy, varCacheId);
                return dataSet1;
            }
            DataSet union = dataSetHasPerm.union(dataSetNoPerm).distinct();
            if (union.isEmpty()) {
                return this.noData(varCacheId);
            }
            DataSet dataSet1 = union.filter(substring + ")").orderBy(new String[]{sortInfo});
            if (StringUtils.isNotEmpty((String)qFilterStr)) {
                DataSet filter = dataSet1.filter(qFilterStr, map);
                DataSet copy = union.copy();
                this.countStatus(copy, varCacheId);
                return filter;
            }
            DataSet copy = union.copy();
            this.countStatus(copy, varCacheId);
            return dataSet1;
        }
        if (!hasPremEmpty) {
            DataSet dataSetHasPerm = this.getProcess(rowFilter, null, customParam, orgSet, varCacheId);
            if (dataSetHasPerm.isEmpty()) {
                return this.noData(varCacheId);
            }
            DataSet dataSet1 = dataSetHasPerm.filter(substring + ")").orderBy(new String[]{sortInfo});
            DataSet copy = dataSetHasPerm.copy();
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String qFilterStr = this.buildTableHeadFilter(tableHeadFilterItems, map);
            this.countStatus(copy, varCacheId);
            if (StringUtils.isNotEmpty((String)qFilterStr)) {
                DataSet filter = dataSet1.filter(qFilterStr, map);
                return filter;
            }
            return dataSet1;
        }
        if (!noPermEmpty) {
            DataSet dataSetNoPerm = this.getTaskProcess(customParam, noPermOrgSet, noPermTemplateSet);
            if (dataSetNoPerm.isEmpty()) {
                return this.noData(varCacheId);
            }
            this.countStatus(dataSetNoPerm.copy(), varCacheId);
            DataSet dataSet1 = dataSetNoPerm.filter(substring + ")").orderBy(new String[]{sortInfo});
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String qFilterStr = this.buildTableHeadFilter(tableHeadFilterItems, map);
            if (StringUtils.isNotEmpty((String)qFilterStr)) {
                DataSet filter = dataSet1.filter(qFilterStr, map);
                return filter;
            }
            return dataSet1;
        }
        return this.noData(varCacheId);
    }

    private DataSet getProcess(QFilter rowFilter, String sortInfo, Map<String, Object> customParam, Set<Long> org, String varCacheId) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"eb_reportprocess", (String)SELECTFIELDS, (QFilter[])rowFilter.toArray(), (String)sortInfo);
        dataSet = this.filterAuditorOrVersionConstratInfo(dataSet);
        TemplateUserQueryResult userTemplatePermDetails = TemplatePermServiceHelper.getUserTemplatePermDetails((Long)((Long)customParam.get("model")), (TemplateTypeEnum)TemplateTypeEnum.BUDGET, (Set)((HashSet)customParam.get("tempId")), (Set)((HashSet)customParam.get("orgId")), (Long)IDUtils.toLong((Object)customParam.get("orgviewid")));
        QFilter qFilter = new QFilter("model", "=", customParam.get("model"));
        qFilter.and("dataset.businessmodel", "=", customParam.get("businessModel"));
        DataSet templateSet = QueryServiceHelper.queryDataSet((String)"queryTemplate", (String)"eb_templateentity", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"number desc");
        DataSet reportAndTemplate = dataSet.join(templateSet).on("template", "id").select(selectFiled, new String[]{"number as repnumber", "name", "name as repname"}).finish();
        QFilter qFilterEntity = new QFilter("model", "=", customParam.get("model"));
        qFilterEntity.and("id", "in", org);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"queryEntity", (String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,name,number", (QFilter[])qFilterEntity.toArray(), null);
        DataSet finish = reportAndTemplate.join(orgDataSet).on("entity", "id").select(selectFiledFinish, new String[]{"name as entityName", "number as entityNumber"}).finish();
        HashSet noCheckProcessSet = (HashSet)customParam.get("noCheckProcessSet");
        if (userTemplatePermDetails != null && !userTemplatePermDetails.isHasAllPerm()) {
            DataSet dataSet1;
            Map templateEntityMap = userTemplatePermDetails.getTemplateEntityMap();
            if (templateEntityMap == null) {
                return this.noData(varCacheId);
            }
            HashSet<Long> processIdSet = new HashSet<Long>(16);
            DataSet copy = finish.copy();
            for (Row next : copy) {
                Set entityIds = (Set)templateEntityMap.get(next.getLong("template"));
                if (CollectionUtils.isEmpty((Collection)entityIds)) {
                    processIdSet.add(next.getLong("repid"));
                    continue;
                }
                if (entityIds.size() == 1 && entityIds.contains(0L) || entityIds.contains(next.getLong("entity"))) continue;
                processIdSet.add(next.getLong("repid"));
            }
            if (CollectionUtils.isNotEmpty(processIdSet)) {
                dataSet1 = this.filterByReportId(processIdSet, finish);
                if (CollectionUtils.isNotEmpty((Collection)noCheckProcessSet)) {
                    DataSet dataSet2 = this.filterByReportId(noCheckProcessSet, dataSet1);
                    return dataSet2;
                }
                return dataSet1;
            }
            if (CollectionUtils.isNotEmpty((Collection)noCheckProcessSet)) {
                dataSet1 = this.filterByReportId(noCheckProcessSet, finish);
                return dataSet1;
            }
            return finish;
        }
        if (CollectionUtils.isNotEmpty((Collection)noCheckProcessSet)) {
            DataSet dataSet1 = this.filterByReportId(noCheckProcessSet, finish);
            return dataSet1;
        }
        return finish;
    }

    private DataSet filterByReportId(Set<Long> noCheckProcessSet, DataSet dataSet1) {
        StringBuilder sqlBd1 = new StringBuilder("repid not in ( ");
        noCheckProcessSet.forEach(m -> sqlBd1.append(m).append(","));
        String substring1 = sqlBd1.substring(0, sqlBd1.length() - 1);
        return dataSet1.filter(substring1 + ")");
    }

    private DataSet getTaskProcess(Map<String, Object> customParam, HashSet<Long> noPermOrgSet, HashSet<Long> noPermTemplateSet) {
        QFilter rowFilter2 = new QFilter("model", "=", customParam.get("model"));
        rowFilter2.and(new QFilter("period", "=", customParam.get("period")));
        rowFilter2.and(new QFilter("version", "=", customParam.get("version")));
        rowFilter2.and(new QFilter("datatype", "=", customParam.get("datatype")));
        rowFilter2.and(new QFilter("entity", "in", noPermOrgSet));
        rowFilter2.and(new QFilter("template", "in", noPermTemplateSet));
        rowFilter2.and(new QFilter("status", "in", customParam.get("status")));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"noPerm", (String)"eb_reportprocess", (String)SELECTFIELDS, (QFilter[])rowFilter2.toArray(), null);
        dataSet = this.filterAuditorOrVersionConstratInfo(dataSet);
        QFilter qFilter = new QFilter("id", "in", noPermTemplateSet);
        DataSet templateSet = QueryServiceHelper.queryDataSet((String)"queryTemplate", (String)"eb_templateentity", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"number desc");
        DataSet reportAndTemplate = dataSet.join(templateSet).on("template", "id").select(selectFiled, new String[]{"number as repnumber", "name", "name as repname"}).finish();
        QFilter qFilterEntity = new QFilter("model", "=", customParam.get("model"));
        qFilterEntity.and("id", "in", noPermOrgSet);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"queryEntity", (String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,name,number", (QFilter[])qFilterEntity.toArray(), null);
        DataSet finish = reportAndTemplate.join(orgDataSet).on("entity", "id").select(selectFiledFinish, new String[]{"name as entityName", "number as entityNumber"}).finish();
        return finish;
    }

    private DataSet filterAuditorOrVersionConstratInfo(DataSet dataSet) {
        DataSet needQueryApproveInfoDataSet = dataSet.copy();
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(needQueryApproveInfoDataSet);
        HashSet<String> approvebillIdSet = new HashSet<String>(16);
        String id = null;
        Long reportId = 0L;
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return dataSet;
        }
        HashSet<Long> queryIds = new HashSet<Long>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            id = dynamicObject.getString("approvebill");
            approvebillIdSet.add(id);
            reportId = dynamicObject.getLong("repid");
            queryIds.add(reportId);
        }
        Map nextAuditorMap = null;
        approvebillIdSet.remove("0");
        queryIds.remove(0L);
        queryIds.remove(null);
        if (CollectionUtils.isNotEmpty(approvebillIdSet)) {
            nextAuditorMap = ApproveUtils.getInstance().getNextAuditor(new ArrayList(approvebillIdSet));
        }
        Set<Long> hasVersionConstrastIds = new VersionConstrastHelper().queryHasVersionConstrast(queryIds);
        if (nextAuditorMap != null && !nextAuditorMap.isEmpty() || !hasVersionConstrastIds.isEmpty()) {
            ArrayList<Object[]> objects = new ArrayList<Object[]>(16);
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                Long repid;
                String auditor;
                Object[] temp = new Object[selectFiled.length];
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                if (nextAuditorMap != null && (auditor = (String)nextAuditorMap.get(dynamicObject.getString("approvebill"))) != null) {
                    dynamicObject.set("auditor", (Object)auditor);
                }
                if (hasVersionConstrastIds.contains(repid = Long.valueOf(dynamicObject.getLong("repid")))) {
                    dynamicObject.set("versionconstrast", (Object)true);
                }
                temp[0] = dynamicObject.get("repid");
                temp[1] = dynamicObject.get("template");
                temp[2] = dynamicObject.get("repstatus");
                temp[3] = dynamicObject.get("entity");
                temp[4] = dynamicObject.get("entitynumber");
                temp[5] = dynamicObject.get("modifier");
                temp[6] = dynamicObject.get("modifydate");
                temp[7] = dynamicObject.get("submitter");
                temp[8] = dynamicObject.get("submittime");
                temp[9] = dynamicObject.get("approvebill");
                temp[10] = dynamicObject.get("auditor");
                temp[11] = dynamicObject.get("versionconstrast");
                objects.add(temp);
            }
            Iterator iterator = objects.iterator();
            DataSet resultDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(iterator, dataSet.getRowMeta());
            dataSet = dataSet.leftJoin(resultDataSet).on("repid", "repid").select(selectFiledReview, selectFiledLeft).finish();
        }
        return dataSet;
    }

    private DataSet noData(String varCacheId) {
        QFilter qFilter = new QFilter("id", "=", (Object)-1L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"eb_reportprocess", (String)SELECTFIELDS, (QFilter[])qFilter.toArray(), null);
        this.noDataEvent(varCacheId);
        return dataSet;
    }

    @Nullable
    private QFilter getRowFilter(Map<String, Object> customParam, HashSet<Long> orgSet, HashSet<Long> templateSet) {
        QFilter qFilter = null;
        if (CollectionUtils.isNotEmpty(orgSet) && CollectionUtils.isNotEmpty(templateSet)) {
            if (CollectionUtils.isNotEmpty(orgSet)) {
                qFilter = new QFilter("entity", "in", orgSet);
            }
            if (CollectionUtils.isNotEmpty(templateSet)) {
                if (qFilter != null) {
                    qFilter.and(new QFilter("template", "in", templateSet));
                } else {
                    qFilter = new QFilter("template", "in", templateSet);
                }
            }
        }
        if (qFilter != null) {
            this.setFilter(qFilter, customParam.get("model"), "model", "=");
        } else {
            qFilter = new QFilter("model", "=", customParam.get("model"));
        }
        this.setFilter(qFilter, customParam.get("period"), "period", "=");
        this.setFilter(qFilter, customParam.get("version"), "version", "=");
        this.setFilter(qFilter, customParam.get("datatype"), "datatype", "=");
        this.setFilter(qFilter, customParam.get("status"), "status", "in");
        return qFilter;
    }

    private String buildTableHeadFilter(List<FilterItemInfo> tableHeadFilterItems, Map<String, Object> map) {
        String s;
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(tableHeadFilterItems)) {
            for (FilterItemInfo tableHeadFilterItem : tableHeadFilterItems) {
                Map todayTime;
                Object value;
                if ("LIKE".equals(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, "%" + tableHeadFilterItem.getValue() + "%", tableFieldMap.get(tableHeadFilterItem.getPropName()), "like", map);
                    continue;
                }
                if ("not like".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, "%" + tableHeadFilterItem.getValue() + "%", tableFieldMap.get(tableHeadFilterItem.getPropName()), "not like", map);
                    continue;
                }
                if ("=".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    if (tableHeadFilterItem.getPropName().equals("modifydate") || tableHeadFilterItem.getPropName().equals("submittime") || tableHeadFilterItem.getPropName().equals("reviewtime")) {
                        value = tableHeadFilterItem.getValue();
                        if (value == null) continue;
                        this.setFilterStr(stringBuilder, DateTimeUtils.getDayStartTime((String)value.toString()), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                        this.setFilterStr(stringBuilder, DateTimeUtils.getDayEndTime((String)value.toString()), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                        continue;
                    }
                    this.setFilterStr(stringBuilder, tableHeadFilterItem.getValue(), tableFieldMap.get(tableHeadFilterItem.getPropName()), "=", map);
                    continue;
                }
                if ("<>".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, tableHeadFilterItem.getValue(), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<>", map);
                    continue;
                }
                if ("lIKE".equals(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, tableHeadFilterItem.getValue() + "%", tableFieldMap.get(tableHeadFilterItem.getPropName()), "like", map);
                    continue;
                }
                if ("like".equals(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, "%" + tableHeadFilterItem.getValue(), tableFieldMap.get(tableHeadFilterItem.getPropName()), "like", map);
                    continue;
                }
                if ("ISNULL".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, "", tableFieldMap.get(tableHeadFilterItem.getPropName()), "is null", map);
                    if (!"auditor".equals(tableFieldMap.get(tableHeadFilterItem.getPropName()))) continue;
                    stringBuilder.append(" 1=1  or auditor = '' and ");
                    continue;
                }
                if ("NOTISNULL".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    this.setFilterStr(stringBuilder, "", tableFieldMap.get(tableHeadFilterItem.getPropName()), "is not null", map);
                    if (!"auditor".equals(tableFieldMap.get(tableHeadFilterItem.getPropName()))) continue;
                    stringBuilder.append(" auditor != '' and ");
                    continue;
                }
                if ("TODAY".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    todayTime = DateTimeUtils.getTodayTime();
                    this.setFilterStr(stringBuilder, todayTime.get("startDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                    this.setFilterStr(stringBuilder, todayTime.get("endDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                    continue;
                }
                if ("THISWEEK".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    todayTime = DateTimeUtils.getThisWeekTime();
                    this.setFilterStr(stringBuilder, todayTime.get("startDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                    this.setFilterStr(stringBuilder, todayTime.get("endDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                    continue;
                }
                if ("THISMONTH".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    todayTime = DateTimeUtils.getThisMonthTime();
                    this.setFilterStr(stringBuilder, todayTime.get("startDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                    this.setFilterStr(stringBuilder, todayTime.get("endDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                    continue;
                }
                if ("LASTMONTH".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    Map lastMonthTime = DateTimeUtils.getLastMonthTime();
                    this.setFilterStr(stringBuilder, lastMonthTime.get("startDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                    this.setFilterStr(stringBuilder, lastMonthTime.get("endDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                    continue;
                }
                if ("LASTTHREEMONTH".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    Map lastThreeMonthTime = DateTimeUtils.getLastThreeMonthTime();
                    this.setFilterStr(stringBuilder, lastThreeMonthTime.get("startDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                    this.setFilterStr(stringBuilder, lastThreeMonthTime.get("endDate"), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                    continue;
                }
                if ("BETWEEN".equalsIgnoreCase(tableHeadFilterItem.getCompareType())) {
                    String endDate;
                    String startDate;
                    ArrayList list;
                    value = tableHeadFilterItem.getValue();
                    if (!(value instanceof ArrayList) || (list = (ArrayList)value).size() != 2 || (startDate = (String)list.get(0)).compareTo(endDate = (String)list.get(1)) >= 1) continue;
                    this.setFilterStr(stringBuilder, DateTimeUtils.getDayStartTime((String)startDate), tableFieldMap.get(tableHeadFilterItem.getPropName()), ">", map);
                    this.setFilterStr(stringBuilder, DateTimeUtils.getDayEndTime((String)endDate), tableFieldMap.get(tableHeadFilterItem.getPropName()), "<=", map);
                    continue;
                }
                if (!"IN".equalsIgnoreCase(tableHeadFilterItem.getCompareType()) || !"versionconstrast".equals(tableFieldMap.get(tableHeadFilterItem.getPropName()))) continue;
                if (tableHeadFilterItem.getValue() instanceof String) {
                    stringBuilder.append(" versionconstrast in (").append(tableHeadFilterItem.getValue()).append(") and ");
                    continue;
                }
                if (!(tableHeadFilterItem.getValue() instanceof Collection)) continue;
                stringBuilder.append(" versionconstrast in (").append(StringUtils.join((Collection)((Collection)tableHeadFilterItem.getValue()), (String)",")).append(") and ");
            }
        }
        if ((s = stringBuilder.toString()).length() > 4 && s.endsWith("and")) {
            return s.substring(0, s.length() - 4);
        }
        return s;
    }

    private void countStatus(DataSet dataSet, String varCacheId) {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>(16);
        Iterator iterator = dataSet.iterator();
        Integer all = 0;
        while (iterator.hasNext()) {
            Integer n;
            Integer n2;
            Row next = (Row)iterator.next();
            String repstatus = next.getString("repstatus");
            Integer integer = (Integer)statusMap.get(repstatus);
            if (integer == null) {
                integer = 1;
            } else {
                n2 = integer;
                n = integer = Integer.valueOf(integer + 1);
            }
            statusMap.put(repstatus, integer);
            n2 = all;
            n = all = Integer.valueOf(all + 1);
        }
        statusMap.put(ReportQueryStatusEnum.ALL.getNumber(), all);
        ICache cache = Cache.get();
        if (cache != null && StringUtils.isNotEmpty((String)varCacheId)) {
            cache.set("datacount" + varCacheId, SerializationUtils.toJsonString(statusMap), 5, TimeUnit.MINUTES);
        }
    }

    private void noDataEvent(String varCacheId) {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>(ReportQueryListPagePlugin.LAB_KEYS.size());
        for (String labKey : ReportQueryListPagePlugin.LAB_KEYS) {
            ReportQueryStatusEnum enumByKey = ReportQueryStatusEnum.getEnumByKey((String)labKey);
            if (enumByKey == null) continue;
            statusMap.put(enumByKey.getNumber(), 0);
        }
        ICache cache = Cache.get();
        if (cache != null && StringUtils.isNotEmpty((String)varCacheId)) {
            cache.set("datacount" + varCacheId, SerializationUtils.toJsonString(statusMap), 5, TimeUnit.MINUTES);
        }
    }

    private void setFilter(QFilter qFilter, Object object, String entry, String qcp) {
        if (StringUtils.isNotEmpty((String)entry) && object != null) {
            if (qFilter != null) {
                qFilter.and(new QFilter(entry, qcp, object));
            } else {
                qFilter = new QFilter(entry, qcp, object);
            }
        }
    }

    private void setFilterStr(StringBuilder stringBuilder, Object object, String entry, String qcp, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((String)entry) && object != null) {
            String key = entry;
            if (object instanceof String) {
                if (StringUtils.isEmpty((String)((String)object))) {
                    stringBuilder.append(" ").append(entry).append(" ").append(qcp).append(" and");
                } else {
                    stringBuilder.append(" ").append(entry).append(" ").append(qcp).append(" '").append(object).append("' and");
                }
            } else {
                int size = map.size();
                key = key + size;
                stringBuilder.append(" ").append(entry).append(" ").append(qcp).append(" ").append(key).append(" and");
                map.put(key, object);
            }
        }
    }

    static {
        tableFieldMap.put("repnumber", "repnumber");
        tableFieldMap.put("repname", "repname");
        tableFieldMap.put("template", "repname");
        tableFieldMap.put("repstatus", "repstatus");
        tableFieldMap.put("entity", "entityName");
        tableFieldMap.put("modifier", "modifier");
        tableFieldMap.put("modifydate", "modifydate");
        tableFieldMap.put("submitter", "submitter");
        tableFieldMap.put("submittime", "submittime");
        tableFieldMap.put("auditor", "auditor");
        tableFieldMap.put("versionconstrast", "versionconstrast");
        tableFieldMap.put("entitynumber", "entityNumber");
        selectFiled = new String[]{"repid", "template", "repstatus", "entity", "entitynumber", "modifier", "modifydate", "submitter", "submittime", "approvebill", "auditor", "versionconstrast"};
        selectFiledFinish = new String[]{"repid", "template", "repstatus", "entity", "entitynumber", "modifier", "modifydate", "submitter", "submittime", "repnumber", "repname", "approvebill", "auditor", "versionconstrast"};
        selectFiledReview = new String[]{"repid", "template", "repstatus", "entity", "entitynumber", "modifier", "modifydate", "submitter", "submittime", "approvebill"};
        selectFiledLeft = new String[]{"auditor", "versionconstrast"};
    }
}

