/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.events.CreateFilterInfoEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.constant.BgTaskConstant;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.entity.memberF7.SingleTreeF7Parameter;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ReportQueryStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.versionconstrast.VersionConstrastCheckDto;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.formplugin.adjustrecord.AdjustRecordHelper;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.approveBill.ApproveOptimization;
import kd.epm.eb.formplugin.executeanalyse.ReportFormPlugin;
import kd.epm.eb.formplugin.forecast.helper.ForecastHelper;
import kd.epm.eb.formplugin.report.RptPluginCommonLogic;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.formplugin.report.query.FilterParamPOJO;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.formplugin.report.reportview.FixReportProcess;
import kd.epm.eb.formplugin.reportscheme.helper.EntityDimPermHelper;
import kd.epm.eb.formplugin.task.command.BgExamineCheckCommand;
import kd.epm.eb.formplugin.task.command.BgExamineReportCommand;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.formplugin.task.multi.TabInfo;
import kd.epm.eb.formplugin.task.multi.TabManager;
import kd.epm.eb.formplugin.template.helper.TemplateHelper;
import kd.epm.eb.formplugin.templateperm.vo.SearchResult;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastExportHelper;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.domain.view.js.SpreadProperties;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ReportQueryListPagePlugin
extends ReportFormPlugin
implements BeforeF7SelectListener,
TabSelectListener,
TreeNodeClickListener,
SearchEnterListener,
IBgTaskExecutePlugin,
MainPage {
    private static final Log log = LogFactory.getLog(ReportQueryListPagePlugin.class);
    private static final String MODEL_F7 = "filterf7_model";
    private static final String BUSINESS_MODEL_F7 = "filterf7_businessmodel";
    private static final String ENTITY_MEMBER_F7 = "filterf7_entitymember";
    private static final String PERIOD_MEMBER_F7 = "filterf7_periodmember";
    private static final String VERSION_MEMBER_F7 = "filterf7_versionmember";
    private static final String DATA_TYPE_MEMBER_F7 = "filterf7_datatypemember";
    private static final String TEMP_ORG_LAB = "orglab";
    private static final String TEMP_TEMPLATE_LAB = "templatelab";
    private static final String ORG_TREE_VIEW = "orgtreeview";
    private static final String TEMP_TREE_VIEW = "temptreeview";
    private static final String BTN_BATCHOPEN = "btn_batchopen";
    private static final String READONLY = "readonly";
    private static final String CHECKED = "checked";
    private static final String SUBMITTED = "submitted";
    private static final String PREPARED = "prepared";
    private static final String NOTPREPARED = "notprepared";
    private static final String ALL = "all";
    private static final String INCOMPLETE = "incomplete";
    private static final String LAB_ALL = "lab_all";
    private static final String LAB_NOTPREPARED = "lab_notprepared";
    private static final String LAB_PREPARED = "lab_prepared";
    private static final String LAB_SUBMITTED = "lab_submitted";
    private static final String LAB_CHECKED = "lab_checked";
    private static final String LAB_READONLY = "lab_readonly";
    private static final String LAB_INCOMPLETE = "lab_incomplete";
    private static final String SELECTED_LAB = "select_lab";
    private static final String TABAP = "tabap";
    private static final String ORGTABPAGE = "orgtabpage";
    private static final String TEMPTABPAGE = "temptabpage";
    private static final String TREEVIEW_ID_CACHE = "treeEntity";
    private static final String TABSELECTED = "tabSelected";
    private static final String ORGIDSET = "orgIdSet";
    private static final String TEMPLATEIDSET = "templateIdSet";
    private static final String HASPERMORGIDSET = "hasPermOrgIdSet";
    private static final String HASPERMTEMPLATEIDSET = "hasPermtTemplateIdSet";
    private static final String NOPERMORGIDSET = "noPermOrgIdSet";
    private static final String NOPERMTEMPLATEIDSET = "noPermtTemplateIdSet";
    private static final String ORG_SERCH_BEFORE = "org_serch_before";
    private static final String ORG_SERCH_NEXT = "org_serch_next";
    private static final String TEMP_SERCH_BEFORE = "temp_serch_before";
    private static final String TEMP_SERCH_NEXT = "temp_serch_next";
    private static final String ORG_SEARCH = "orgsearch";
    private static final String TEMP_SEARCH = "tempsearch";
    private static final String SEARCH_TEXT_CACHE = "searchTextCache";
    private static final String LFOCUS = "lfocus";
    private static final String RFOCUS = "rfocus";
    private static final String ORGNODE = "orgnode";
    private static final String TEMPLATENODE = "templatenode";
    private static final String REPORT_FILTER_AP = "reportfilterap";
    private static final String SELECT_ALL = "selectall";
    public static final List<String> LAB_KEYS = Arrays.asList("lab_all", "lab_notprepared", "lab_prepared", "lab_submitted", "lab_checked", "lab_readonly", "lab_incomplete");
    public static final List<String> FILTER_MEMBER_F7 = Arrays.asList("filterf7_model", "filterf7_businessmodel", "filterf7_entitymember", "filterf7_periodmember", "filterf7_versionmember", "filterf7_datatypemember");
    private AbstractReportPlugin abstractReportPlugin = null;
    private Boolean isloaded = false;
    private static final String BTN_SHOWSETTING = "btn_showsetting";
    private Map<String, TreeNode> orgMap;
    private RptPluginCommonLogic rptPluginCommonLogic = null;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideNoBgmdItem();
    }

    @Override
    public Set<String> getOnlyBgmd() {
        HashSet<String> items = new HashSet<String>();
        items.add("btn_exportvc");
        items.add("btn_versionconstrast");
        return items;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String varCacheId = this.getPageCache().get("varCacheId");
        if (StringUtils.isNotEmpty((String)varCacheId)) {
            String dataCountStr;
            Map dataCount;
            this.getPageCache().remove(varCacheId);
            ICache cache = Cache.get();
            if (cache != null && (dataCount = (Map)SerializationUtils.fromJsonString((String)(dataCountStr = cache.get("datacount" + varCacheId)), Map.class)) != null) {
                for (String labKey : LAB_KEYS) {
                    ReportQueryStatusEnum enumByKey = ReportQueryStatusEnum.getEnumByKey((String)labKey);
                    if (enumByKey == null) continue;
                    Integer integer = dataCount.getOrDefault(enumByKey.getNumber(), 0);
                    Label label = (Label)this.getView().getControl(labKey);
                    if (label == null) continue;
                    label.setText(ReportQueryStatusEnum.getMessage((String)labKey, (int)integer));
                }
            }
        }
        this.getView().hideLoading();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("isReset"))) {
            queryParam.setCustomParam(new HashMap(1));
        } else if (StringUtils.isNotEmpty((String)this.getPageCache().get("clearF7"))) {
            queryParam.setCustomParam(new HashMap(1));
            this.getPageCache().remove("clearF7");
        } else {
            this.checkmodel();
            this.setUserSelect();
            Map<String, Object> customParam = this.getCustomParam();
            boolean b = this.checkParams(customParam);
            if (!b) {
                queryParam.setCustomParam(new HashMap(1));
            } else {
                queryParam.setCustomParam(customParam);
            }
        }
        this.getPageCache().remove(SELECT_ALL);
        String varCacheId = String.valueOf(GlobalIdUtil.genGlobalLongId());
        Map customParam = queryParam.getCustomParam();
        this.getPageCache().put("varCacheId", varCacheId);
        customParam.put("varCacheId", varCacheId);
        return super.verifyQuery(queryParam);
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if ("repstatus".equals(event.getColumnName())) continue;
            event.setSort(true);
            event.setFilter(true);
        }
    }

    public void beforeCreateFilterInfo(CreateFilterInfoEvent event) {
        super.beforeCreateFilterInfo(event);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.filterChange();
        this.updateModelLables();
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        super.setCellStyleRules(cellStyleRules);
        CellStyleRule cellStyleRule1 = new CellStyleRule();
        cellStyleRule1.setFieldKey("repstatus");
        cellStyleRule1.setForeColor(BgConstant.COLOR[0]);
        cellStyleRule1.setCondition("repstatus == '0' || repstatus == '11'");
        cellStyleRules.add(cellStyleRule1);
        CellStyleRule cellStyleRule2 = new CellStyleRule();
        cellStyleRule2.setFieldKey("repstatus");
        cellStyleRule2.setForeColor(BgConstant.COLOR[1]);
        cellStyleRule2.setCondition("repstatus == '5'");
        cellStyleRules.add(cellStyleRule2);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if ("reset".equals(key)) {
            this.getPageCache().put("isReset", "true");
            List<String> list = Arrays.asList(BUSINESS_MODEL_F7, ENTITY_MEMBER_F7, PERIOD_MEMBER_F7, VERSION_MEMBER_F7, DATA_TYPE_MEMBER_F7);
            this.resetF7Value(list);
            this.filterChange();
        }
        super.afterDoOperation(e);
    }

    public boolean checkParams(Map<String, Object> customParam) {
        if (customParam == null) {
            return false;
        }
        DynamicObject model_f7 = (DynamicObject)this.getModel().getValue(MODEL_F7);
        if (model_f7 == null) {
            return false;
        }
        customParam.put("model", model_f7.getLong("id"));
        DynamicObject business_model_f7 = (DynamicObject)this.getModel().getValue(BUSINESS_MODEL_F7);
        if (business_model_f7 == null) {
            return false;
        }
        customParam.put("businessModel", business_model_f7.getLong("id"));
        DynamicObject entitymember_f7 = (DynamicObject)this.getModel().getValue(ENTITY_MEMBER_F7);
        if (entitymember_f7 == null) {
            return false;
        }
        customParam.put("view", entitymember_f7.getLong("id"));
        DynamicObject periodmember_f7 = (DynamicObject)this.getModel().getValue(PERIOD_MEMBER_F7);
        if (periodmember_f7 == null) {
            return false;
        }
        customParam.put("period", periodmember_f7.getLong("id"));
        DynamicObject versionmember_f7 = (DynamicObject)this.getModel().getValue(VERSION_MEMBER_F7);
        if (versionmember_f7 == null) {
            return false;
        }
        customParam.put("version", versionmember_f7.getLong("id"));
        DynamicObject datatypemember_f7 = (DynamicObject)this.getModel().getValue(DATA_TYPE_MEMBER_F7);
        if (datatypemember_f7 == null) {
            return false;
        }
        customParam.put("datatype", datatypemember_f7.getLong("id"));
        Boolean allValue = (Boolean)this.getModel().getValue(ALL);
        Boolean notpreparedValue = (Boolean)this.getModel().getValue(NOTPREPARED);
        Boolean preparedValue = (Boolean)this.getModel().getValue(PREPARED);
        Boolean submittedValue = (Boolean)this.getModel().getValue(SUBMITTED);
        Boolean checkedValue = (Boolean)this.getModel().getValue(CHECKED);
        Boolean readonlyValue = (Boolean)this.getModel().getValue(READONLY);
        Boolean inCompleteValue = (Boolean)this.getModel().getValue(INCOMPLETE);
        if (!(allValue.booleanValue() || notpreparedValue.booleanValue() || preparedValue.booleanValue() || submittedValue.booleanValue() || checkedValue.booleanValue() || readonlyValue.booleanValue() || inCompleteValue.booleanValue())) {
            return false;
        }
        HashSet<String> status = new HashSet<String>(16);
        customParam.put("status", status);
        HashSet<String> currentStatus = new HashSet<String>(16);
        boolean isFirst = true;
        String currentLab = this.getPageCache().get(SELECTED_LAB);
        Set<String> checkStatus = this.getCheckStatus();
        if (StringUtils.isNotEmpty((String)currentLab)) {
            switch (currentLab) {
                case "lab_all": {
                    currentStatus.addAll(checkStatus);
                    break;
                }
                case "lab_notprepared": {
                    currentStatus.add(ReportQueryStatusEnum.NOTPREPARED.getNumber());
                    break;
                }
                case "lab_prepared": {
                    currentStatus.add(ReportQueryStatusEnum.PREPARED.getNumber());
                    break;
                }
                case "lab_submitted": {
                    currentStatus.add(ReportQueryStatusEnum.SUBMITTED.getNumber());
                    break;
                }
                case "lab_checked": {
                    currentStatus.add(ReportQueryStatusEnum.CHECKED.getNumber());
                    break;
                }
                case "lab_readonly": {
                    currentStatus.add(ReportQueryStatusEnum.READONLY.getNumber());
                    break;
                }
                case "lab_incomplete": {
                    currentStatus.add(ReportQueryStatusEnum.INCOMPLETE.getNumber());
                    break;
                }
            }
        }
        if (allValue.booleanValue()) {
            status.addAll(checkStatus);
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_ALL);
                currentStatus.addAll(checkStatus);
                isFirst = false;
            }
            customParam.put("currentStatus", currentStatus);
            return true;
        }
        if (notpreparedValue.booleanValue()) {
            status.add(ReportQueryStatusEnum.NOTPREPARED.getNumber());
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_NOTPREPARED);
                currentStatus.add(ReportQueryStatusEnum.NOTPREPARED.getNumber());
                isFirst = false;
            }
        }
        if (preparedValue.booleanValue()) {
            status.add(ReportQueryStatusEnum.PREPARED.getNumber());
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_PREPARED);
                currentStatus.add(ReportQueryStatusEnum.PREPARED.getNumber());
                isFirst = false;
            }
        }
        if (submittedValue.booleanValue()) {
            status.add(ReportQueryStatusEnum.SUBMITTED.getNumber());
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_SUBMITTED);
                currentStatus.add(ReportQueryStatusEnum.SUBMITTED.getNumber());
                isFirst = false;
            }
        }
        if (checkedValue.booleanValue()) {
            status.add(ReportQueryStatusEnum.CHECKED.getNumber());
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_CHECKED);
                currentStatus.add(ReportQueryStatusEnum.CHECKED.getNumber());
                isFirst = false;
            }
        }
        if (readonlyValue.booleanValue()) {
            status.add(ReportQueryStatusEnum.READONLY.getNumber());
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_READONLY);
                currentStatus.add(ReportQueryStatusEnum.READONLY.getNumber());
                isFirst = false;
            }
        }
        if (inCompleteValue.booleanValue()) {
            status.add(ReportQueryStatusEnum.INCOMPLETE.getNumber());
            if (isFirst && StringUtils.isEmpty((String)currentLab)) {
                this.handleClick(LAB_INCOMPLETE);
                currentStatus.add(ReportQueryStatusEnum.INCOMPLETE.getNumber());
                isFirst = false;
            }
        }
        customParam.put("currentStatus", currentStatus);
        return true;
    }

    private Set<String> getCheckStatus() {
        HashSet<String> set = new HashSet<String>(LAB_KEYS.size());
        for (String labKey : LAB_KEYS) {
            if (labKey.equals(LAB_ALL) || !((Boolean)this.getModel().getValue(labKey.replace("lab_", ""))).booleanValue()) continue;
            set.add(ReportQueryStatusEnum.getNumberByKey((String)labKey));
        }
        return set;
    }

    private Map<String, TreeNode> getOrgMap() {
        String orgNode;
        if (this.orgMap == null && StringUtils.isNotEmpty((String)(orgNode = this.getPageCache().get(ORGNODE)))) {
            this.orgMap = (Map)SerializationUtils.deSerializeFromBase64((String)orgNode);
        }
        return this.orgMap;
    }

    private Map<String, Object> getCustomParam() {
        Map templateMap;
        TreeNode treeNode;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String orgrange = (String)this.getModel().getValue("orgrange");
        String orgSelect = this.getPageCache().get(LFOCUS);
        if (StringUtils.isNotEmpty((String)orgrange) && StringUtils.isNotEmpty((String)orgSelect)) {
            String number;
            RangeEnum rangeEnum = RangeEnum.ONLY;
            switch (orgrange) {
                case "1": {
                    rangeEnum = RangeEnum.ONLY;
                    break;
                }
                case "2": {
                    rangeEnum = RangeEnum.DIRECTSUB;
                    break;
                }
                case "3": {
                    rangeEnum = RangeEnum.ALL;
                    break;
                }
                case "4": {
                    rangeEnum = RangeEnum.ALL_DETAIL_INCLUDE;
                    break;
                }
            }
            Map<String, TreeNode> orgMap = this.getOrgMap();
            if (orgMap == null || orgMap.size() == 0 || this.getModelId() == 0L) {
                return null;
            }
            TreeNode treeNode2 = orgMap.get(orgSelect);
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            String longNumber = treeNode2.getLongNumber();
            if (longNumber.contains("!")) {
                String[] split = longNumber.split("!");
                number = split[split.length - 1];
            } else {
                number = longNumber;
            }
            List members = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), this.getIdFormDynamicObject(ENTITY_MEMBER_F7), number, rangeEnum.getIndex());
            if (!members.isEmpty()) {
                String noPermOrgIdSetStr;
                String hasPermOrgIdSetStr = this.getPageCache().get(HASPERMORGIDSET);
                if (StringUtils.isNotEmpty((String)hasPermOrgIdSetStr)) {
                    Set hasPermOrgIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)hasPermOrgIdSetStr);
                    Set collect = members.stream().filter(x -> hasPermOrgIdSet.contains(x.getId())).map(x -> x.getId()).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(collect)) {
                        params.put("orgId", collect);
                    }
                }
                if (StringUtils.isNotEmpty((String)(noPermOrgIdSetStr = this.getPageCache().get(NOPERMORGIDSET)))) {
                    Set noPermOrgIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)noPermOrgIdSetStr);
                    Set collect = members.stream().filter(x -> noPermOrgIdSet.contains(x.getId())).map(x -> x.getId()).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(collect)) {
                        params.put("noPermOrgId", collect);
                    }
                }
            }
        }
        String tempSelect = this.getPageCache().get(RFOCUS);
        String templatenode = this.getPageCache().get(TEMPLATENODE);
        if (StringUtils.isNotEmpty((String)templatenode) && StringUtils.isNotEmpty((String)tempSelect) && (treeNode = (TreeNode)(templateMap = (Map)SerializationUtils.deSerializeFromBase64((String)templatenode)).get(tempSelect)) != null) {
            String noPermTemplateIdSetStr;
            HashSet<Long> templateId = new HashSet<Long>(16);
            this.getTemplateId(treeNode, templateId);
            String hasPermTemplateIdSetStr = this.getPageCache().get(HASPERMTEMPLATEIDSET);
            if (StringUtils.isNotEmpty((String)hasPermTemplateIdSetStr)) {
                Set hasPermTemplateIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)hasPermTemplateIdSetStr);
                Set collect = templateId.stream().filter(x -> hasPermTemplateIdSet.contains(x)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(collect)) {
                    params.put("tempId", collect);
                }
            }
            if (StringUtils.isNotEmpty((String)(noPermTemplateIdSetStr = this.getPageCache().get(NOPERMTEMPLATEIDSET)))) {
                Set noPermTemplateIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)noPermTemplateIdSetStr);
                Set collect = templateId.stream().filter(x -> noPermTemplateIdSet.contains(x)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(collect)) {
                    params.put("noPermTempId", collect);
                }
            }
        }
        Object periodValue = this.getModel().getValue(PERIOD_MEMBER_F7);
        Object versionValue = this.getModel().getValue(VERSION_MEMBER_F7);
        Object dataTypeValue = this.getModel().getValue(DATA_TYPE_MEMBER_F7);
        if (periodValue != null && versionValue != null && dataTypeValue != null) {
            params.put("period", ((DynamicObject)periodValue).getLong("id"));
            params.put("version", ((DynamicObject)versionValue).getLong("id"));
            params.put("datatype", ((DynamicObject)dataTypeValue).getLong("id"));
        }
        params.put("orgviewid", this.getIdFormDynamicObject(ENTITY_MEMBER_F7));
        return params;
    }

    private void getTemplateId(TreeNode treeNode, HashSet<Long> templateSet) {
        templateSet.add(IDUtils.toLong((Object)treeNode.getId()));
        if (treeNode.getChildren() != null) {
            for (TreeNode child : treeNode.getChildren()) {
                this.getTemplateId(child, templateSet);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterParamPOJO filterParamPOJO = (FilterParamPOJO)UserSelectUtils.getWholeUserSelect((IFormView)this.getView(), FilterParamPOJO.class);
        this.getPageCache().put("initF7", "true");
        if (filterParamPOJO != null) {
            this.initF7(filterParamPOJO);
        } else {
            Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_F7, (boolean)false);
            this.getModel().setValue(MODEL_F7, (Object)modelId);
            filterParamPOJO = new FilterParamPOJO();
            this.searchSchemeValue(filterParamPOJO);
            if (!this.isloaded.booleanValue()) {
                this.searchTaskValue(filterParamPOJO);
            }
            this.valideValue(filterParamPOJO);
            this.initF7(filterParamPOJO);
            this.setCheckBoxVal(true, true, true, true, true, true, true);
        }
        this.getPageCache().put(TABSELECTED, ORGTABPAGE);
        this.updateModelLables();
        if (StringUtils.isEmpty((String)this.getPageCache().get("isInit"))) {
            this.filterChange();
        }
        this.getPageCache().remove("initF7");
        ReportHelper.setLongNameNumDisVisible((Long)this.getModelId(), (IFormView)this.getView());
    }

    private void valideValue(FilterParamPOJO paramPOJO) {
        Set<Long> readDataTypes;
        Set<Long> readVersions = this.getPermMembs(SysDimensionEnum.Version.getNumber());
        if (CollectionUtils.isNotEmpty(readVersions) && !readVersions.contains(paramPOJO.getVersionId())) {
            ArrayList<Long> versionList = new ArrayList<Long>(readVersions);
            paramPOJO.setVersionId((Long)versionList.get(0));
        }
        if (CollectionUtils.isNotEmpty(readDataTypes = this.getPermMembs(SysDimensionEnum.DataType.getNumber())) && !readDataTypes.contains(paramPOJO.getDataTypeId())) {
            ArrayList<Long> dataTypeList = new ArrayList<Long>(readDataTypes);
            paramPOJO.setDataTypeId((Long)dataTypeList.get(0));
        }
    }

    private Set<Long> getPermMembs(String dimCode) {
        return DimMembPermHelper.getPermMembIds((String)dimCode, (Long)this.getModelId(), (Long)0L, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
    }

    private FilterParamPOJO searchTaskValue(FilterParamPOJO paramPOJO) {
        DynamicObject value;
        QFilter taskfilter;
        DynamicObject[] tasklist;
        paramPOJO.setModelId(this.getModelId());
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObject[] task = BusinessDataServiceHelper.load((String)"eb_task", (String)"id,tasklist", (QFilter[])filter.toArray(), (String)"modifydate desc", (int)1);
        if (task != null && task.length != 0 && (tasklist = BusinessDataServiceHelper.load((String)"eb_tasklist", (String)"id,bizmodel,year,version,datatype", (QFilter[])(taskfilter = new QFilter("id", "=", (Object)(value = task[0]).getLong("tasklist.id"))).toArray())) != null && tasklist.length != 0) {
            DynamicObject taskListValue = tasklist[0];
            paramPOJO.setBusinessId(taskListValue.getLong("bizmodel.id"));
            paramPOJO.setPeriodId(taskListValue.getLong("year.id"));
            paramPOJO.setVersionId(taskListValue.getLong("version.id"));
            paramPOJO.setDataTypeId(taskListValue.getLong("datatype.id"));
            QFilter disfilter = new QFilter("task", "=", (Object)taskListValue.getLong("id"));
            DynamicObject[] taskOrgList = BusinessDataServiceHelper.load((String)"eb_taskorg", (String)"id,distorgview", (QFilter[])disfilter.toArray(), (String)"modifydate desc", (int)1);
            if (taskOrgList != null && taskOrgList.length != 0) {
                DynamicObject obj = taskOrgList[0];
                paramPOJO.setOrgId(obj.getLong("distorgview.id"));
            }
        }
        this.setCheckValue(paramPOJO);
        return paramPOJO;
    }

    private FilterParamPOJO searchSchemeValue(FilterParamPOJO paramPOJO) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        paramPOJO.setModelId(this.getModelId());
        DynamicObject[] recordList = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"id,scheme,year,version,datatype", (QFilter[])filter.toArray(), (String)"assigntime desc", (int)1);
        if (recordList != null && recordList.length != 0) {
            DynamicObject value = recordList[0];
            paramPOJO.setPeriodId(value.getLong("year.id"));
            paramPOJO.setVersionId(value.getLong("version.id"));
            paramPOJO.setDataTypeId(value.getLong("datatype.id"));
            DynamicObject scheme = value.getDynamicObject("scheme");
            if (scheme != null) {
                paramPOJO.setBusinessId(scheme.getLong("bizrange.id"));
                paramPOJO.setOrgId(scheme.getLong("orgview.id"));
                this.isloaded = true;
            }
        }
        this.setCheckValue(paramPOJO);
        return paramPOJO;
    }

    private void setCheckValue(FilterParamPOJO paramPOJO) {
        paramPOJO.setAll(true);
        paramPOJO.setPrepared(true);
        paramPOJO.setNotprepared(true);
        paramPOJO.setReadonly(true);
        paramPOJO.setSubmitted(true);
        paramPOJO.setChecked(true);
        paramPOJO.setIncomplete(true);
    }

    private void setCheckBoxVal(boolean all_Val, boolean prepared_Val, boolean readonly_Val, boolean checked_Val, boolean submitted_Val, boolean notprepared_Val, boolean incomplete_Val) {
        this.getModel().setValue(ALL, (Object)all_Val);
        this.getModel().setValue(PREPARED, (Object)prepared_Val);
        this.getModel().setValue(READONLY, (Object)readonly_Val);
        this.getModel().setValue(CHECKED, (Object)checked_Val);
        this.getModel().setValue(SUBMITTED, (Object)submitted_Val);
        this.getModel().setValue(NOTPREPARED, (Object)notprepared_Val);
        this.getModel().setValue(INCOMPLETE, (Object)incomplete_Val);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{MODEL_F7, BUSINESS_MODEL_F7, ENTITY_MEMBER_F7, PERIOD_MEMBER_F7, VERSION_MEMBER_F7, DATA_TYPE_MEMBER_F7});
        this.addClickListeners(new String[]{LAB_ALL, LAB_NOTPREPARED, LAB_PREPARED, LAB_SUBMITTED, LAB_CHECKED, LAB_READONLY, LAB_INCOMPLETE, ORG_SERCH_BEFORE, ORG_SERCH_NEXT, TEMP_SERCH_BEFORE, TEMP_SERCH_NEXT, "treepanelswitchrpt", "showhidedetail", "btn_pagedim_float"});
        this.addItemClickListeners(new String[]{"btn_exportvc"});
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView templateTreeView = (TreeView)this.getControl(TEMP_TREE_VIEW);
        TreeView orgTreeView = (TreeView)this.getControl(ORG_TREE_VIEW);
        templateTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search sl = (Search)this.getControl(ORG_SEARCH);
        Search sr = (Search)this.getControl(TEMP_SEARCH);
        sl.addEnterListener((SearchEnterListener)this);
        sr.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "toolbaraprpt", "floatmenuap", "orgrange"});
        Tab reporttab = (Tab)this.getControl("reporttab");
        if (reporttab != null) {
            reporttab.addTabSelectListener(this::tabSelected);
        }
        for (String key : BgTaskConstant.getInstance().getF7Keys()) {
            BasedataEdit basedataEdit_eb = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit_eb == null) continue;
            basedataEdit_eb.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(BgTaskConstant.getInstance().getFilterKeys());
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        this.getView().hideLoading();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue(MODEL_F7);
        boolean bol = modelDy == null;
        switch (key) {
            case "filterf7_businessmodel": 
            case "filterf7_periodmember": 
            case "filterf7_versionmember": 
            case "filterf7_datatypemember": {
                if (bol) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportQueryListPagePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
                    if (qFilterList == null) {
                        qFilterList = new ArrayList<QFilter>(16);
                    }
                    qFilterList.add(new QFilter("model", "=", (Object)modelDy.getLong("id")));
                    showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                }
                if (key.equals(BUSINESS_MODEL_F7)) break;
                Object value = this.getModel().getValue(BUSINESS_MODEL_F7);
                if (value == null || bol) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ReportQueryListPagePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject dy = (DynamicObject)value;
                long businessId = dy.getLong("id");
                SingleTreeF7Parameter singleTreeF7Parameter = new SingleTreeF7Parameter();
                singleTreeF7Parameter.setCheckPerm(true);
                singleTreeF7Parameter.setOnlyLeaf(false);
                singleTreeF7Parameter.setKeepTree(true);
                this.switchSingleTreeF7(beforeF7SelectEvent, businessId, singleTreeF7Parameter);
                break;
            }
            case "filterf7_entitymember": {
                Object value = this.getModel().getValue(BUSINESS_MODEL_F7);
                if (value == null || bol) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ReportQueryListPagePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (!(beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter)) break;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                DynamicObject dy = (DynamicObject)value;
                long businessId = dy.getLong("id");
                List<Long> orgId = this.getOrgId(businessId);
                List dimensionListByBusModel = this.getIModelCacheHelper().getDimensionListByBusModel(Long.valueOf(businessId));
                Optional<Dimension> first = dimensionListByBusModel.stream().filter(x -> x.getNumber().equals(SysDimensionEnum.Entity.getNumber())).findFirst();
                if (!first.isPresent()) {
                    return;
                }
                Dimension dimension = first.get();
                qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
                qFilterList.add(new QFilter("dimension", "=", (Object)dimension.getId()));
                qFilterList.add(new QFilter("id", "in", orgId));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            case "filterf7_model": {
                if (!(beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter)) break;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                if (!this.isNewEbForm()) {
                    QFilter filter = new QFilter("reporttype", "=", (Object)"7");
                    qFilterList.add(filter);
                }
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            default: {
                if (!beforeF7SelectEvent.getProperty().getName().startsWith("ebf7_")) break;
                this.getRptPluginCommonLogic().beforeF7Select(beforeF7SelectEvent);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (MODEL_F7.equals(actionId)) {
            ListSelectedRowCollection result;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof ListSelectedRowCollection && (result = (ListSelectedRowCollection)returnData).size() > 0) {
                this.getModel().setValue(MODEL_F7, result.get(0).getPrimaryKeyValue());
            }
        } else if ("customSort".equals(actionId)) {
            this.getReportProcessPlugin().closedCallBack(closedCallBackEvent);
        } else if (actionId.startsWith("filter_")) {
            RptPluginCommonLogic.getInstance(this).closedCallBack(closedCallBackEvent);
        } else if (actionId.equals("callback_float_pagedim")) {
            RptPluginCommonLogic.getInstance(this).closedCallBack(closedCallBackEvent);
        } else if ("exportReportList".equals(actionId)) {
            this.exportReportList(closedCallBackEvent);
        } else if (BTN_SHOWSETTING.equals(actionId)) {
            this.showSettingCallback(closedCallBackEvent.getReturnData());
        } else if ("closeAdjustRecord".equals(actionId)) {
            this.getReportProcessPlugin().removeRemarkCol("remarkAdjrecord", true);
        }
    }

    private void showSettingCallback(Object returnData) {
        if (!(returnData instanceof Map)) {
            return;
        }
        Map map = (Map)returnData;
        AbstractReportPlugin plugin = this.getReportProcessPlugin();
        if (plugin != null) {
            map.values().forEach(key -> plugin.itemClick(new ItemClickEvent((Object)this, key, "")));
        }
    }

    private void exportReportList(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData != null) {
            List reportExportDataRequests = (List)returnData;
            Map<String, String> returnTipsMap = ReportExportDataController.getInstance().exportReportData(reportExportDataRequests, (IFormView)this.getView(), new CloseCallBack((IFormPlugin)this, "exportCloseCallBack"));
            if (returnTipsMap != null) {
                String success = returnTipsMap.get("success");
                String failed = returnTipsMap.get("failed");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)success)) {
                    this.getView().showSuccessNotification(success);
                    ApproveOptimization.getInstance().openDownloadPage((IFormView)this.getView(), this.getModelId());
                } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failed)) {
                    this.getView().showTipNotification(failed);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("isReset"))) {
            return;
        }
        if (newValue == null && FILTER_MEMBER_F7.contains(key)) {
            this.getPageCache().put("clearF7", "true");
            return;
        }
        String initF7 = this.getPageCache().get("initF7");
        switch (key) {
            case "filterf7_model": {
                DynamicObject modelDy = (DynamicObject)this.getModel().getValue(MODEL_F7);
                if (modelDy == null) break;
                List<String> list = Arrays.asList(BUSINESS_MODEL_F7, ENTITY_MEMBER_F7, PERIOD_MEMBER_F7, VERSION_MEMBER_F7, DATA_TYPE_MEMBER_F7);
                this.resetF7Value(list);
                Long modelId = modelDy.getLong("id");
                this.setDefaultF7(modelId);
                this.updateModelLables();
                this.getRptPluginCommonLogic().clearTabManager();
                if (StringUtils.isEmpty((String)initF7)) {
                    this.filterChange();
                }
                ReportHelper.setLongNameNumDisVisible((Long)this.getModelId(), (IFormView)this.getView());
                break;
            }
            case "filterf7_businessmodel": {
                DynamicObject orgViewF7 = (DynamicObject)this.getModel().getValue(ENTITY_MEMBER_F7);
                if (!(newValue instanceof DynamicObject) || orgViewF7 == null) break;
                Long oldOrgViewId = orgViewF7.getLong("id");
                Long newBusmodelid = ((DynamicObject)newValue).getLong("id");
                List<Long> orgViewId = this.getOrgId(newBusmodelid);
                if (!orgViewId.contains(oldOrgViewId)) {
                    this.resetF7Value(Collections.singletonList(ENTITY_MEMBER_F7));
                } else {
                    this.getModel().setValue(ENTITY_MEMBER_F7, null);
                }
                if (!StringUtils.isEmpty((String)initF7)) break;
                this.filterChange();
                break;
            }
            case "all": {
                if (newValue != null && Boolean.parseBoolean(newValue.toString())) {
                    this.getPageCache().put(SELECT_ALL, "1");
                    this.getPageCache().put("allSelect", "true");
                    this.getModel().setValue(NOTPREPARED, (Object)true);
                    this.getModel().setValue(PREPARED, (Object)true);
                    this.getModel().setValue(SUBMITTED, (Object)true);
                    this.getModel().setValue(CHECKED, (Object)true);
                    this.getModel().setValue(READONLY, (Object)true);
                    this.getModel().setValue(INCOMPLETE, (Object)true);
                    for (String labKey : LAB_KEYS) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{labKey});
                    }
                    this.getPageCache().put("statusChange", "true");
                    this.filterChange();
                    this.getPageCache().remove("allSelect");
                    break;
                }
                if (LAB_ALL.equals(this.getCurrentLab())) {
                    this.getPageCache().remove(SELECTED_LAB);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LAB_ALL});
                if (!StringUtils.isEmpty((String)initF7)) break;
                this.getPageCache().put("statusChange", "true");
                this.filterChange();
                break;
            }
            case "notprepared": {
                this.handelCheckBoxChange(newValue, LAB_NOTPREPARED);
                break;
            }
            case "prepared": {
                this.handelCheckBoxChange(newValue, LAB_PREPARED);
                break;
            }
            case "submitted": {
                this.handelCheckBoxChange(newValue, LAB_SUBMITTED);
                break;
            }
            case "checked": {
                this.handelCheckBoxChange(newValue, LAB_CHECKED);
                break;
            }
            case "readonly": {
                this.handelCheckBoxChange(newValue, LAB_READONLY);
                break;
            }
            case "incomplete": {
                this.handelCheckBoxChange(newValue, LAB_INCOMPLETE);
                break;
            }
            case "orgrange": {
                this.getView().showLoading(ResManager.getLocaleString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ICustomStatusTabAp_7", (String)"epm-eb-formplugin"));
                IReportView view = this.getView();
                view.refresh();
                break;
            }
            case "filterf7_periodmember": {
                if (!(newValue instanceof DynamicObject)) break;
                Long id = ((DynamicObject)newValue).getLong("id");
                Member periodMember = this.getIModelCacheHelper().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getMember(null, id);
                if (periodMember != null && periodMember.getLevel() == 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"ReportQueryListPagePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(PERIOD_MEMBER_F7, changeData.getOldValue());
                }
                if (!StringUtils.isEmpty((String)initF7)) break;
                this.filterChange();
                break;
            }
            case "filterf7_versionmember": {
                if (!(newValue instanceof DynamicObject)) break;
                Long id = ((DynamicObject)newValue).getLong("id");
                Member versionMember = this.getIModelCacheHelper().getDimension(SysDimensionEnum.Version.getNumber()).getMember(null, id);
                if (versionMember != null && versionMember.getLevel() == 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"ReportQueryListPagePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(VERSION_MEMBER_F7, changeData.getOldValue());
                }
                this.filterChange();
                break;
            }
            case "filterf7_datatypemember": {
                if (!(newValue instanceof DynamicObject)) break;
                Long id = ((DynamicObject)newValue).getLong("id");
                Member dataTypeMember = this.getIModelCacheHelper().getDimension(SysDimensionEnum.DataType.getNumber()).getMember(null, id);
                if (dataTypeMember != null && dataTypeMember.getLevel() == 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"ReportQueryListPagePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(DATA_TYPE_MEMBER_F7, changeData.getOldValue());
                }
                if (!StringUtils.isEmpty((String)initF7)) break;
                this.filterChange();
                break;
            }
            default: {
                if (BgTaskExecuteHelper.isF7Key(e.getProperty().getName())) {
                    Object ob = e.getChangeSet()[0].getNewValue();
                    if (ob == null) {
                        return;
                    }
                    this.getRptPluginCommonLogic().propertyChanged(e);
                    if (!StringUtils.isEmpty((String)initF7)) break;
                    this.filterChange();
                    break;
                }
                if (key.startsWith("filter_")) {
                    if (newValue != null && !"".equals(newValue)) break;
                    RptPluginCommonLogic.getInstance(this).refreshReportByFilterValueReset(key);
                    break;
                }
                if (!key.equals(ENTITY_MEMBER_F7)) break;
                this.filterChange();
            }
        }
    }

    private void resetList() {
        ReportFilter reportFilterAp = (ReportFilter)this.getView().getControl(REPORT_FILTER_AP);
        reportFilterAp.search();
        reportFilterAp.setCollapse(false);
        this.getPageCache().put(SEARCH_TEXT_CACHE, null);
        TreeView orgTree = (TreeView)this.getControl(ORG_TREE_VIEW);
        orgTree.deleteAllNodes();
        TreeView templateTree = (TreeView)this.getControl(TEMP_TREE_VIEW);
        templateTree.deleteAllNodes();
        this.getView().getPageCache().put("searchCondition", "");
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(REPORT_FILTER_AP, "updateSearchCondition", new Object[]{""});
    }

    private void handelCheckBoxChange(Object newValue, String labKey) {
        String allSelect = this.getPageCache().get("allSelect");
        if (allSelect != null) {
            return;
        }
        this.getPageCache().put("statusChange", "true");
        if (newValue != null && !Boolean.parseBoolean(newValue.toString())) {
            if (labKey.equals(this.getCurrentLab())) {
                this.getPageCache().remove(SELECTED_LAB);
            }
            this.getModel().setValue(ALL, (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{labKey});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LAB_ALL});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{labKey});
            this.handleAllSelect();
        }
        this.filterChange();
    }

    public void handleAllSelect() {
        Boolean notpreparedValue = (Boolean)this.getModel().getValue(NOTPREPARED);
        Boolean preparedValue = (Boolean)this.getModel().getValue(PREPARED);
        Boolean submittedValue = (Boolean)this.getModel().getValue(SUBMITTED);
        Boolean checkedValue = (Boolean)this.getModel().getValue(CHECKED);
        Boolean readonlyValue = (Boolean)this.getModel().getValue(READONLY);
        Boolean inCompleteValue = (Boolean)this.getModel().getValue(INCOMPLETE);
        if (notpreparedValue.booleanValue() && preparedValue.booleanValue() && submittedValue.booleanValue() && checkedValue.booleanValue() && readonlyValue.booleanValue() && inCompleteValue.booleanValue()) {
            this.getModel().setValue(ALL, (Object)true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{LAB_ALL});
        }
    }

    public boolean isallChecked() {
        Boolean notpreparedValue = (Boolean)this.getModel().getValue(NOTPREPARED);
        Boolean preparedValue = (Boolean)this.getModel().getValue(PREPARED);
        Boolean submittedValue = (Boolean)this.getModel().getValue(SUBMITTED);
        Boolean checkedValue = (Boolean)this.getModel().getValue(CHECKED);
        Boolean readonlyValue = (Boolean)this.getModel().getValue(READONLY);
        Boolean inCompleteValue = (Boolean)this.getModel().getValue(INCOMPLETE);
        return notpreparedValue != false && preparedValue != false && submittedValue != false && checkedValue != false && readonlyValue != false && inCompleteValue != false;
    }

    private void filterChange() {
        Object modelValue = this.getModel().getValue(MODEL_F7);
        Object businessValue = this.getModel().getValue(BUSINESS_MODEL_F7);
        Object entityValue = this.getModel().getValue(ENTITY_MEMBER_F7);
        Object periodValue = this.getModel().getValue(PERIOD_MEMBER_F7);
        Object versionValue = this.getModel().getValue(VERSION_MEMBER_F7);
        Object dataTypeValue = this.getModel().getValue(DATA_TYPE_MEMBER_F7);
        if (modelValue != null && businessValue != null && entityValue != null && periodValue != null && versionValue != null && dataTypeValue != null) {
            HashSet<Long> noCheckPermtemplate = new HashSet<Long>(16);
            HashSet<Long> noCheckPermOrg = new HashSet<Long>(16);
            HashSet<Long> porocessIdSet = new HashSet<Long>(16);
            String taskOrgSql = "select tet.fid from  \nt_eb_taskprocess tet \nleft join t_eb_task tet2  on tet.ftaskid = tet2.fid \nleft join t_eb_tasklist tet3 on tet3.fid  = tet2.ftasklistid\nwhere  tet3.fmodelid  =? and tet3.fbizmodelid  = ? and \ntet3.fyearid  =? and tet3.fversionid = ?  and tet3.fdatetypeid  =?";
            DB.query((DBRoute)DBRoute.of((String)"epm"), (String)taskOrgSql, (Object[])new Object[]{((DynamicObject)modelValue).getLong("id"), ((DynamicObject)businessValue).getLong("id"), ((DynamicObject)periodValue).getLong("id"), ((DynamicObject)versionValue).getLong("id"), ((DynamicObject)dataTypeValue).getLong("id")}, rs -> {
                while (rs.next()) {
                    porocessIdSet.add(rs.getLong("fid"));
                }
                return null;
            });
            if (CollectionUtils.isNotEmpty(porocessIdSet)) {
                this.queryExecutes(noCheckPermtemplate, noCheckPermOrg, porocessIdSet);
            }
            long modelId = ((DynamicObject)modelValue).getLong("id");
            long periodId = ((DynamicObject)periodValue).getLong("id");
            long versionId = ((DynamicObject)versionValue).getLong("id");
            long dataTypeId = ((DynamicObject)dataTypeValue).getLong("id");
            String entitySql = "SELECT  A.fentity entityid FROM t_eb_reportprocess A WHERE A.fmodel = ? AND A.fperiod = ? AND A.fversion = ? AND A.fdatatype = ? group by A.fentity";
            DataSet dataSet = DB.queryDataSet((String)"querySchemeProcessentity", (DBRoute)DBRoute.of((String)"epm"), (String)entitySql, (Object[])new Object[]{modelId, periodId, versionId, dataTypeId});
            Iterator iterator = dataSet.iterator();
            HashSet<Long> orgSet = new HashSet<Long>(16);
            HashSet<Long> templateSet = new HashSet<Long>(16);
            while (iterator.hasNext()) {
                Row next = (Row)iterator.next();
                Long entityid = next.getLong("entityid");
                orgSet.add(entityid);
            }
            String template = "SELECT  A.ftemplate template FROM t_eb_reportprocess A WHERE A.fmodel = ? AND A.fperiod = ? AND A.fversion = ? AND A.fdatatype = ? group by A.ftemplate";
            dataSet = DB.queryDataSet((String)"querySchemeProcesstemplate", (DBRoute)DBRoute.of((String)"epm"), (String)template, (Object[])new Object[]{modelId, periodId, versionId, dataTypeId});
            for (Row next : dataSet) {
                Long templateid = next.getLong("template");
                templateSet.add(templateid);
            }
            String statusChange = this.getPageCache().get("statusChange");
            if (StringUtils.isEmpty((String)statusChange)) {
                this.buildTreeCache(null, orgSet, templateSet, noCheckPermOrg, noCheckPermtemplate);
                this.refreshTree(this.getModelId());
            }
            this.getPageCache().remove("statusChange");
            ReportFilter reportFilterAp = (ReportFilter)this.getView().getControl(REPORT_FILTER_AP);
            reportFilterAp.search();
            reportFilterAp.setCollapse(false);
        }
        this.getPageCache().put("isInit", "true");
        this.getPageCache().remove("isReset");
    }

    private void queryExecutes(Set<Long> noCheckPermtemplate, Set<Long> noCheckPermOrg, Set<Long> porocessIdSet) {
        String sql = "select tp.forgid,tp.ftemplateid,tp.fid as fid from t_eb_taskprocess tp left join t_eb_taskproces_executors tes on tp.fid = tes.fid  left join t_eb_taskprosupervisor tep on tp.fid = tep.fid where tp.forgviewid = ?  and ( tes.fbasedataid = ? or tep.fsupervisorid = ?) ";
        DataSet dataSet = DB.queryDataSet((String)"queryExecutes", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{this.getIdFormDynamicObject(ENTITY_MEMBER_F7), UserUtils.getUserId(), UserUtils.getUserId()});
        ExecutersFilterFunction executersFilterFunction = new ExecutersFilterFunction(porocessIdSet);
        DataSet filter = dataSet.where((FilterFunction)executersFilterFunction);
        for (Row next : filter) {
            noCheckPermOrg.add(next.getLong("forgid"));
            noCheckPermtemplate.add(next.getLong("ftemplateid"));
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        if (controlKey.equals("spreadf7")) {
            return this.getPageCache().get("spreadf7_dimNumber");
        }
        String dimNumber = BgTaskExecuteHelper.getDimNumberFromF7Key((IFormView)this.getView(), controlKey);
        if (dimNumber.startsWith("filterf7_")) {
            dimNumber = dimNumber.equals(VERSION_MEMBER_F7) ? SysDimensionEnum.Version.getNumber() : (dimNumber.equals(DATA_TYPE_MEMBER_F7) ? SysDimensionEnum.DataType.getNumber() : (dimNumber.equals(PERIOD_MEMBER_F7) ? SysDimensionEnum.BudgetPeriod.getNumber() : dimNumber));
        }
        return dimNumber;
    }

    private void updateModelLables() {
        Object modelObj = this.getModel().getValue(MODEL_F7);
        if (modelObj instanceof DynamicObject) {
            String modelname = ((DynamicObject)modelObj).getString("name");
            Label modelLabel = (Label)this.getControl("modellabelrpt");
            if (modelLabel != null) {
                modelLabel.setText(modelname);
            }
        }
    }

    private void setDefaultF7(Long modelId) {
        Map viewsByBusModel;
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])modelFilter.toArray());
        long businessId = 0L;
        if (!query.isEmpty() && query.size() == 1) {
            DynamicObject dynamicObject = (DynamicObject)query.get(0);
            businessId = dynamicObject.getLong("id");
            this.getModel().setValue(BUSINESS_MODEL_F7, (Object)businessId);
        }
        QFBuilder qfBuilder = new QFBuilder();
        if (businessId != 0L && this.getModelId() != 0L && !(viewsByBusModel = this.getIModelCacheHelper().getViewsByBusModel(Long.valueOf(businessId))).isEmpty() && viewsByBusModel.containsKey(SysDimensionEnum.Entity.getNumber())) {
            this.getModel().setValue(ENTITY_MEMBER_F7, viewsByBusModel.get(SysDimensionEnum.Entity.getNumber()));
        }
        Date[] month = BgPeriodUtils.getPeriodOnMonth();
        QFilter periodFilter = new QFilter("startdate", "=", (Object)month[0]);
        periodFilter.and("enddate", "=", (Object)month[1]);
        qfBuilder.clear();
        qfBuilder.add(modelFilter).add(periodFilter);
        DynamicObject periodDy = QueryServiceHelper.queryOne((String)"epm_bperiodmembertree", (String)"id", (QFilter[])qfBuilder.toArray());
        if (periodDy != null && this.getModelId() != 0L) {
            String periodId = periodDy.getString("id");
            this.getModel().setValue(PERIOD_MEMBER_F7, (Object)periodId);
        }
        QFilter dataTypeFilter = new QFilter("number", "=", (Object)"Budget");
        qfBuilder.clear();
        qfBuilder.add(modelFilter).add(dataTypeFilter);
        DynamicObject dataTypeDy = QueryServiceHelper.queryOne((String)"epm_datatypemembertree", (String)"id", (QFilter[])qfBuilder.toArray());
        if (dataTypeDy != null && this.getModelId() != 0L) {
            String dataTypeId = dataTypeDy.getString("id");
            this.getModel().setValue(DATA_TYPE_MEMBER_F7, (Object)dataTypeId);
        }
    }

    private List<Long> getOrgId(Long businessId) {
        Map viewsByBusModel = this.getIModelCacheHelper().getViewGroupViewsByBusModel(businessId);
        List<Long> baseEntityId = new ArrayList<Long>(16);
        if (MapUtils.isNotEmpty((Map)viewsByBusModel)) {
            baseEntityId = (List)viewsByBusModel.get("Entity");
        }
        return baseEntityId;
    }

    private void initF7(FilterParamPOJO paramPOJO) {
        this.getModel().setValue(MODEL_F7, (Object)paramPOJO.getModelId());
        this.getModel().setValue(BUSINESS_MODEL_F7, (Object)paramPOJO.getBusinessId());
        this.getModel().setValue(ENTITY_MEMBER_F7, (Object)paramPOJO.getOrgId());
        this.getModel().setValue(PERIOD_MEMBER_F7, (Object)paramPOJO.getPeriodId());
        this.getModel().setValue(VERSION_MEMBER_F7, (Object)paramPOJO.getVersionId());
        this.getModel().setValue(DATA_TYPE_MEMBER_F7, (Object)paramPOJO.getDataTypeId());
        this.setCheckBoxVal(paramPOJO.getAll(), paramPOJO.getPrepared(), paramPOJO.getReadonly(), paramPOJO.getChecked(), paramPOJO.getSubmitted(), paramPOJO.getNotprepared(), paramPOJO.getIncomplete());
    }

    private void setUserSelect() {
        FilterParamPOJO paramPOJO = new FilterParamPOJO();
        Long modelId = this.getIdFormDynamicObject(MODEL_F7);
        paramPOJO.setModelId(modelId);
        paramPOJO.setBusinessId(this.getIdFormDynamicObject(BUSINESS_MODEL_F7));
        paramPOJO.setOrgId(this.getIdFormDynamicObject(ENTITY_MEMBER_F7));
        paramPOJO.setPeriodId(this.getIdFormDynamicObject(PERIOD_MEMBER_F7));
        paramPOJO.setVersionId(this.getIdFormDynamicObject(VERSION_MEMBER_F7));
        paramPOJO.setDataTypeId(this.getIdFormDynamicObject(DATA_TYPE_MEMBER_F7));
        paramPOJO.setAll(Boolean.parseBoolean(this.getModel().getValue(ALL).toString()));
        paramPOJO.setNotprepared(Boolean.parseBoolean(this.getModel().getValue(NOTPREPARED).toString()));
        paramPOJO.setPrepared(Boolean.parseBoolean(this.getModel().getValue(PREPARED).toString()));
        paramPOJO.setSubmitted(Boolean.parseBoolean(this.getModel().getValue(SUBMITTED).toString()));
        paramPOJO.setChecked(Boolean.parseBoolean(this.getModel().getValue(CHECKED).toString()));
        paramPOJO.setReadonly(Boolean.parseBoolean(this.getModel().getValue(READONLY).toString()));
        paramPOJO.setIncomplete(Boolean.parseBoolean(this.getModel().getValue(INCOMPLETE).toString()));
        UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
        UserSelectUtils.saveWholeUserSelect((IFormView)this.getView(), (long)this.getModelId(), (Object)paramPOJO);
    }

    private Long getIdFormDynamicObject(String key) {
        IDataModel dataModel = this.getModel();
        DynamicObject dynamicObject = (DynamicObject)dataModel.getValue(key);
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    private void resetF7Value(List<String> list) {
        list.forEach(str -> this.getModel().setValue(str, null));
        this.resetList();
    }

    private void buildTemplateTree() {
        TreeView treeView = (TreeView)this.getControl(TEMP_TREE_VIEW);
        treeView.deleteAllNodes();
        this.deleteAllNodeInCache("templatetab");
        TreeNode catalogRootNode = this.buildTemplateNodes();
        if (catalogRootNode == null) {
            return;
        }
        treeView.updateNode(catalogRootNode);
        treeView.addNode(catalogRootNode);
        treeView.expand(catalogRootNode.getId());
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
        this.cacheAllNode(catalogRootNode, treeNodeMap);
        this.getPageCache().put(TEMPLATENODE, SerializationUtils.serializeToBase64(treeNodeMap));
        this.getPageCache().put(TEMP_TREE_VIEW, SerializationUtils.toJsonString((Object)catalogRootNode));
        treeView.focusNode(catalogRootNode);
        Label label = (Label)this.getControl(TEMP_TEMPLATE_LAB);
        label.setText(catalogRootNode.getText());
        this.getPageCache().put(RFOCUS, catalogRootNode.getId());
    }

    @Override
    public void clickRefresh() {
    }

    @Override
    public Long getModelId() {
        Object value = this.getModel().getValue(MODEL_F7);
        if (value == null) {
            return 0L;
        }
        DynamicObject modelDy = (DynamicObject)value;
        return modelDy.getLong("id");
    }

    @Override
    public void workFlowStatusChanged() {
    }

    @Override
    public void fireCurrTreeNodeClick() {
    }

    @Override
    public QFilter setEntityFilter() {
        return null;
    }

    public void initialize() {
        super.initialize();
        this.initReportPlugin(this.getPageCache().get("current_rpt_type"));
    }

    @Override
    public AbstractReportPlugin getReportProcessPlugin() {
        if (this.abstractReportPlugin == null || !this.matchPluginType(this.abstractReportPlugin)) {
            this.initReportPlugin(this.getPageCache().get("current_rpt_type"));
        }
        return this.abstractReportPlugin;
    }

    private boolean matchPluginType(AbstractReportPlugin plugin) {
        String rpt_type = null;
        if (plugin == null || (rpt_type = this.getPageCache().get("current_rpt_type")) == null) {
            return true;
        }
        if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(rpt_type)) {
            return plugin instanceof DynamicReportProcess;
        }
        if (BgTemplateTypeEnum.EBFIX.getNumber().equals(rpt_type)) {
            return plugin instanceof FixReportProcess;
        }
        return true;
    }

    @Override
    public void initReportPlugin(String reporttype) {
        if (BgTemplateTypeEnum.EBFIX.getNumber().equals(reporttype)) {
            this.abstractReportPlugin = new FixReportProcess(this);
        } else if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(reporttype)) {
            this.abstractReportPlugin = new DynamicReportProcess(this);
        } else {
            this.getView().addService(ISpreadAction.class, (Object)new ReportQueryListSpreadAction((AbstractFormPlugin)this));
        }
        if (this.abstractReportPlugin != null) {
            this.abstractReportPlugin.setView((IFormView)this.getView());
            this.abstractReportPlugin.initialize();
            Long processId = IDUtils.toLong((Object)this.getPageCache().get("current_report_id"));
            this.abstractReportPlugin.setProcessId(processId);
            this.abstractReportPlugin.setTaskProcessId(IDUtils.toLong((Object)this.getPageCache().get("current_processid")));
            this.abstractReportPlugin.setProcessType(this.getPageCache().get("current_processtype"));
        }
    }

    @Override
    public void filterCurrentUser(QFBuilder qb) {
    }

    @Override
    public void switchShowLeftPanel(boolean showLeftTree) {
        this.setItemvisible(showLeftTree, "listpanel", "btnpanel", REPORT_FILTER_AP);
        this.setItemvisible(!showLeftTree, "multrptpanel");
    }

    private void setItemvisible(boolean isVisible, String ... items) {
        this.getView().setVisible(Boolean.valueOf(isVisible), items);
    }

    private void buildOrgTree() {
        TreeView orgView = (TreeView)this.getView().getControl(ORG_TREE_VIEW);
        orgView.deleteAllNodes();
        this.deleteAllNodeInCache("orgtab");
        TreeNode node = this.buildOrgNodes();
        orgView.updateNode(node);
        orgView.addNode(node);
        orgView.expand(node.getId());
        HashMap<String, TreeNode> treeNodesCache = new HashMap<String, TreeNode>(16);
        this.cacheAllNode(node, treeNodesCache);
        this.getPageCache().put(ORGNODE, SerializationUtils.serializeToBase64(treeNodesCache));
        this.getPageCache().put(ORG_TREE_VIEW, SerializationUtils.toJsonString((Object)node));
        if (node != null && node.getChildren() != null && node.getChildren().size() > 0) {
            node = (TreeNode)node.getChildren().get(0);
        }
        orgView.focusNode(node);
        Label label = (Label)this.getControl(TEMP_ORG_LAB);
        label.setText(node.getText());
        this.getPageCache().put(LFOCUS, node.getId());
    }

    private void cacheAllNode(TreeNode node, Map<String, TreeNode> treeNodesCache) {
        if (node == null || CollectionUtils.isEmpty((Collection)node.getChildren())) {
            return;
        }
        treeNodesCache.put(node.getId(), node);
        List children = node.getChildren();
        for (TreeNode child : children) {
            treeNodesCache.put(child.getId(), child);
            this.cacheAllNode(child, treeNodesCache);
        }
    }

    private void deleteAllNodeInCache(String tabName) {
        if (ORGTABPAGE.equals(tabName)) {
            this.getPageCache().remove(ORG_TREE_VIEW);
        } else if (TEMPTABPAGE.equals(tabName)) {
            this.getPageCache().remove(TEMP_TREE_VIEW);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_batchopen": {
                ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
                if (reportList == null) break;
                int[] selectedRows = reportList.getEntryState().getSelectedRows();
                if (selectedRows != null && selectedRows.length > 0) {
                    ArrayList<Long> ids = new ArrayList<Long>(16);
                    for (int i : selectedRows) {
                        DynamicObject rowData = reportList.getReportModel().getRowData(i);
                        if (rowData == null) continue;
                        ids.add(IDUtils.toLong((Object)rowData.get("repid")));
                    }
                    RptPluginCommonLogic.getInstance(this).batchOpenReports(ids, this.getIdFormDynamicObject(ENTITY_MEMBER_F7));
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u62a5\u8868\u3002", (String)"ReportQueryListPagePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            case "floatmenuitemap": {
                RptPluginCommonLogic.getInstance(this).switchHideShowPageDims();
                break;
            }
            case "examine_remark": {
                new BgExamineCheckCommand(itemKey).execute(this);
                break;
            }
            case "examine_report": {
                new BgExamineReportCommand(itemKey).execute(this);
                break;
            }
            case "exit": {
                this.showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u5f53\u524d\u6240\u6709\u5df2\u6253\u5f00\u62a5\u8868\u5e76\u9000\u51fa\uff1f", (String)"ReportQueryListPagePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), itemKey);
                break;
            }
            case "btn_close": {
                this.customEvent(new CustomEventArgs((Object)this, "reporttab", "closeTab", this.getView().getPageCache().get("current_report_id")));
                this.getView().getPageCache().remove(this.getSortInfoKey());
                break;
            }
            case "btn_weavedesc": {
                this.getRptPluginCommonLogic().openWeaveDesPage();
                break;
            }
            case "refresh1": {
                List<String> cacheAuditList;
                TabInfo tabInfo = this.getRptPluginCommonLogic().getTabManager().getSelectedTabInfo();
                if (tabInfo == null) break;
                this.fireReportTabSelectedEvent(tabInfo.getTabKey());
                if (!this.getRptPluginCommonLogic().isApproveBill() || (cacheAuditList = this.getRptPluginCommonLogic().getCacheAuditList()) == null || !cacheAuditList.contains(this.getPageCache().get("current_report_id"))) break;
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"save"});
                break;
            }
            case "btn_attachement": 
            case "upattachement": {
                this.getRptPluginCommonLogic().showAttchement(Boolean.TRUE);
                break;
            }
            case "delattachement": {
                this.getRptPluginCommonLogic().deleteAttachment();
                break;
            }
            case "exportdata": {
                TabInfo selectedTab;
                TabManager tabManager = RptPluginCommonLogic.getInstance(this).getTabManager();
                if (tabManager == null || (selectedTab = tabManager.getSelectedTabInfo()) == null) break;
                this.openExportDataPage(ReportExportTypeEnum.EXPORT_DATA, (ReportProcess)selectedTab.getUserObject("reportProcess"));
                break;
            }
            case "refresh": {
                this.filterChange();
                this.closeCondition();
                break;
            }
            case "btn_viewflowchart": {
                try {
                    ReportList reportList1 = (ReportList)this.getView().getControl("reportlistap");
                    int[] selectedRows = reportList1.getEntryState().getSelectedRows();
                    if (selectedRows.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ApproveOptimization_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    HashSet<Long> reportIds = new HashSet<Long>(selectedRows.length);
                    for (int selectedRow : selectedRows) {
                        DynamicObject rowData = reportList1.getReportModel().getRowData(selectedRow);
                        if (rowData == null) continue;
                        reportIds.add(rowData.getLong("repid"));
                    }
                    ApproveOptimization.getInstance().viewRptFlowChart((IFormView)this.getView(), reportIds);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportQueryListPagePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "btn_versionconstrast": {
                new VersionConstrastHelper().versionconstast(this, this.getReportProcessPlugin());
                break;
            }
            case "btn_exportvc": {
                new VersionConstrastExportHelper("0", true, false, this.getIdFormDynamicObject(ENTITY_MEMBER_F7)).exportBatch((AbstractFormPlugin)this, this.getModel());
                break;
            }
            case "btn_showsetting": {
                this.openShowSettingPage();
                break;
            }
            case "adjustremark": 
            case "adjustrecord": {
                String pageModel = "adjustremark".equals(itemKey) ? "01" : "02";
                AdjustRecordHelper.adjudtRecord((AbstractFormPlugin)this, this.getReportProcessPlugin(), pageModel, false);
                break;
            }
            default: {
                AbstractReportPlugin plugin = this.getReportProcessPlugin();
                if (plugin != null) {
                    plugin.itemClick(evt);
                    if (!"btn_showemptyrows".equals(itemKey)) break;
                    this.clickRefresh();
                    break;
                }
                super.itemClick(evt);
            }
        }
    }

    private void openShowSettingPage() {
        String reportType = this.abstractReportPlugin instanceof DynamicReportProcess ? BgTemplateTypeEnum.DYNAMIC.getNumber() : BgTemplateTypeEnum.EBFIX.getNumber();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bgm_report_showsetting");
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("reportType", (Object)reportType);
        showParameter.setCustomParam("reportProcessId", (Object)this.getCurrentReportProcessId());
        DynamicObject templateDyObj = this.getTemplateDynamicObj();
        showParameter.setCustomParam("defaultUnit", (Object)(templateDyObj == null ? "0" : templateDyObj.getString("dataunit")));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SHOWSETTING));
        showParameter.setCustomParam("dimShowType", (Object)this.getReportProcessPlugin().getMemberDisplayType());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private DynamicObject getTemplateDynamicObj() {
        Long currentReportProcessId = this.getCurrentReportProcessId();
        if (IDUtils.isNull((Long)currentReportProcessId)) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_reportprocess", (String)"id,template", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentReportProcessId)});
        if (dynamicObject == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("template.id"), (String)"eb_templateentity");
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("exportSelect".equals(itemKey) || "exportAll".equals(itemKey)) {
            ReportList reportList1 = (ReportList)this.getView().getControl("reportlistap");
            ArrayList selRows = (ArrayList)reportList1.getEntryState().get("selRows");
            if (reportList1.getReportModel().getRowCount() < 1) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u67e5\u8be2\u540e\u518d\u5bfc\u51fa\u3002", (String)"ReportQueryListPagePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                evt.setCancel(true);
            } else if ((selRows == null || selRows.size() < 1) && "exportSelect".equals(itemKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u884c\u3002", (String)"ReportQueryListPagePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            this.getPageCache().put("exportKey", itemKey);
        }
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), (IFormView)this.getView(), Sets.newHashSet((Object[])new String[]{"close", "exit"}));
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        String exportKey = this.getPageCache().get("exportKey");
        if ("exportSelect".equals(exportKey)) {
            ReportList billList = (ReportList)this.getView().getControl("reportlistap");
            ArrayList selRows = (ArrayList)billList.getEntryState().get("selRows");
            if (!data.isEmpty() && selRows.size() > 0) {
                Iterator arg5 = data.iterator();
                while (arg5.hasNext()) {
                    DynamicObject dyo = (DynamicObject)arg5.next();
                    int fseq = (Integer)dyo.get("fseq");
                    if (selRows.contains(fseq)) continue;
                    arg5.remove();
                }
            }
        }
        Set repid = data.stream().map(x -> x.getString("repid")).collect(Collectors.toSet());
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u51fa", "ReportQueryListPagePlugin_17", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u51fa\u6570\u636e:%1$s", "ReportQueryListPagePlugin_18", "epm-eb-formplugin");
        this.writeLog(null, "export", opName, opDesc, new String[]{String.join((CharSequence)",", repid)});
        this.getPageCache().remove("exportKey");
    }

    private void closeCondition() {
        ReportFilter reportFilterAp = (ReportFilter)this.getView().getControl(REPORT_FILTER_AP);
        reportFilterAp.setCollapse(true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (LAB_KEYS.contains(key)) {
            this.handleClick(key);
            this.getView().refresh();
        } else if (key.startsWith("filter_")) {
            RptPluginCommonLogic.getInstance(this).filterClick(key);
        } else if ("showhidedetail".equals(key)) {
            RptPluginCommonLogic.getInstance(this).showOrHideDetailLabelClick();
        } else if ("btn_pagedim_float".equals(key)) {
            String pageId = this.getPageIdAndCache(this.getPageCache(), "eb_rptpagedim_float");
            RptPluginCommonLogic.getInstance(this).openFloatPageDimForm(pageId);
        } else {
            switch (key) {
                case "org_serch_before": 
                case "temp_serch_before": {
                    this.searchNext(-1);
                    break;
                }
                case "org_serch_next": 
                case "temp_serch_next": {
                    this.searchNext(1);
                    break;
                }
                case "treepanelswitchrpt": {
                    this.switchShowLeftPanel(true);
                    break;
                }
            }
        }
    }

    private void openExportDataPage(ReportExportTypeEnum exportTypeEnum, ReportProcess reportProcess) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCustomParam("templateId", (Object)reportProcess.getTemplateId());
        formShowParameter.setCustomParam("entityId", (Object)reportProcess.getEntityId());
        formShowParameter.setCustomParam("processId", (Object)reportProcess.getProcessQuote().getSourceId2());
        formShowParameter.setCustomParam("reportProcessId", (Object)reportProcess.getId());
        formShowParameter.setCustomParam("entityName", (Object)reportProcess.getEntityName());
        formShowParameter.setCustomParam("versionName", (Object)this.getExportDataVersionName());
        formShowParameter.setCustomParam("orgViewId", (Object)reportProcess.getProcessQuote().getSourceId3());
        formShowParameter.setCustomParam("exportType", (Object)exportTypeEnum);
        formShowParameter.setCaption(exportTypeEnum == ReportExportTypeEnum.EXPORT_DATA ? ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"ReportPreparationListPlugin_excel_04", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f", (String)"ReportPreparationListPlugin_excel_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("isShowEmptyRow", (Object)this.isShowEmptyRow());
        formShowParameter.setCustomParam("isShowEmptyCol", (Object)this.isShowEmptyCol());
        MemberDisplayTypeEnum showDimType = this.getShowDimType();
        formShowParameter.setCustomParam("showDimType", (Object)showDimType.index);
        ITemplateModel templateModel = this.getReportProcessPlugin().getTemplateModel();
        if (templateModel == null) {
            return;
        }
        String currentDataUnitKey = this.getCurrentDataUnitKey();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)currentDataUnitKey)) {
            String changeunit = currentDataUnitKey.substring(currentDataUnitKey.length() - 1);
            formShowParameter.setCustomParam("dataUnit", (Object)changeunit);
        } else {
            formShowParameter.setCustomParam("dataUnit", (Object)templateModel.getTemplateBaseInfo().getDataunit());
        }
        formShowParameter.setCustomParam("processType", (Object)reportProcess.getProcessQuote().getProcessTypeEnum());
        formShowParameter.setCustomParam("billstatus", (Object)BgTaskExecuteHelper.getBillStatus(this.getCurrentReportProcessId()));
        Map<Object, Object> defaultDimMemberMap = new HashMap(16);
        HashMap<String, Long> dimNumIdMap = new HashMap<String, Long>(16);
        defaultDimMemberMap = this.getCurrentDefaultPageDimMemberMap(templateModel, dimNumIdMap);
        formShowParameter.setCustomParam("defaultDimMemberMap", (Object)SerializationUtils.toJsonString(defaultDimMemberMap));
        formShowParameter.setFormId("bgm_exportreportlist");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "exportReportList"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (CollectionUtils.isNotEmpty((Collection)this.getReportProcessPlugin().getFilterWithFilterAndCentralized())) {
            formShowParameter.setCustomParam("filterInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)this.getReportProcessPlugin().getFilterWithFilterAndCentralized()));
        }
        if (exportTypeEnum == ReportExportTypeEnum.EXPORT_TEMPLATE) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa", (String)"ReportPreparationListPlugin_excel_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setShowTitle(true);
        this.getView().showForm(formShowParameter);
    }

    private String getExportDataVersionName() {
        Long currentReportProcessId = this.getCurrentReportProcessId();
        if (IDUtils.isEmptyLong((Long)currentReportProcessId).booleanValue()) {
            return "";
        }
        DynamicObject reportProcessObj = BusinessDataServiceHelper.loadSingle((Object)currentReportProcessId, (String)"eb_reportprocess");
        if (reportProcessObj == null) {
            return "";
        }
        return reportProcessObj.getString("version.name");
    }

    private MemberDisplayTypeEnum getShowDimType() {
        String str = this.getPageCache().get("MemberDisplayType" + this.getCurrentReportProcessId());
        if (str != null) {
            int i = Integer.parseInt(str);
            for (MemberDisplayTypeEnum value : MemberDisplayTypeEnum.values()) {
                if (value.index != i) continue;
                return value;
            }
        }
        return MemberDisplayTypeEnum.NAME;
    }

    private boolean isShowEmptyRow() {
        String isEmptyrowsVisible = this.getPageCache().get("isEmptyrowsVisible");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isEmptyrowsVisible)) {
            return true;
        }
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)"true", (CharSequence)isEmptyrowsVisible);
    }

    private boolean isShowEmptyCol() {
        String isEmptycolsVisible = this.getPageCache().get("isEmptycolsVisible");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isEmptycolsVisible)) {
            return true;
        }
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)"true", (CharSequence)isEmptycolsVisible);
    }

    private Map<String, String> getCurrentDefaultPageDimMemberMap(ITemplateModel templateModel, Map<String, Long> dimIdMap) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        List pagemembentry = templateModel.getPagemembentry();
        for (IPageDimensionEntry dimensionEntry : pagemembentry) {
            String number = dimensionEntry.getDimension().getNumber();
            Object value = null;
            String f7serial = this.getPageCache().get("f7_mapping_cache");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)f7serial)) {
                Map dim_f7Key = (Map)ObjectSerialUtil.deSerializedBytes((String)f7serial);
                for (Map.Entry entry : dim_f7Key.entrySet()) {
                    String value1 = (String)entry.getValue();
                    String key = (String)entry.getKey();
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)value1, (CharSequence)number)) continue;
                    value = this.getModel().getValue(key);
                    break;
                }
            }
            if (value == null) continue;
            DynamicObject dynamicObject = (DynamicObject)value;
            result.put(number, dynamicObject.getString("number"));
            dimIdMap.put(number, dynamicObject.getLong("id"));
        }
        return result;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), (IFormView)this.getView())) {
            return;
        }
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<Long> ids = new ArrayList<Long>(1);
        DynamicObject rowData = reportList.getReportModel().getRowData(rowIndex);
        if (rowData != null) {
            ids.add(IDUtils.toLong((Object)rowData.get("repid")));
        }
        RptPluginCommonLogic.getInstance(this).batchOpenReports(ids, this.getIdFormDynamicObject(ENTITY_MEMBER_F7));
    }

    private void fireReportTabSelectedEvent(String tabKey) {
        TabSelectEvent event = new TabSelectEvent((Object)this.getView().getControl("reporttab"), tabKey);
        this.tabSelected(event);
    }

    protected void showConfirm(String msg, String callBackId) {
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("exit".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView source = (TreeView)evt.getSource();
        String key = source.getKey();
        String nodeId = (String)evt.getNodeId();
        if (ORG_TREE_VIEW.equals(key)) {
            this.getPageCache().put("orgSelectedNode", nodeId);
            Map<String, TreeNode> orgMap = this.getOrgMap();
            if (orgMap == null || orgMap.size() == 0) {
                return;
            }
            TreeNode treeNode = orgMap.get(nodeId);
            Label label = (Label)this.getControl(TEMP_ORG_LAB);
            label.setText(treeNode.getText());
            this.getPageCache().put(LFOCUS, treeNode.getId());
        } else if (TEMP_TREE_VIEW.equals(key)) {
            this.getPageCache().put("templateSelectedNode", nodeId);
            String templatenode = this.getPageCache().get(TEMPLATENODE);
            if (StringUtils.isNotEmpty((String)templatenode)) {
                Map templateMap = (Map)SerializationUtils.deSerializeFromBase64((String)templatenode);
                if (templateMap == null || templateMap.size() == 0) {
                    return;
                }
                TreeNode treeNode = (TreeNode)templateMap.get(nodeId);
                Label label = (Label)this.getControl(TEMP_TEMPLATE_LAB);
                label.setText(treeNode.getText());
                this.getPageCache().put(RFOCUS, treeNode.getId());
            }
        }
        IReportView view = this.getView();
        view.refresh();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjustremark"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"adjustremark"});
        if (tabKey != null && "reporttab".equals(((Tab)tabSelectEvent.getSource()).getKey())) {
            Object reportProcess;
            this.getRptPluginCommonLogic().getTabManager().setSelectTabInfo(tabKey);
            TabInfo tabInfo = this.getRptPluginCommonLogic().getTabManager().searchTab(tabKey);
            if (tabInfo != null && (reportProcess = tabInfo.getUserObject("reportProcess")) instanceof ReportProcess) {
                this.getRptPluginCommonLogic().setAppId();
                try {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap9", "flexpanelap10"});
                    ReportProcess process = (ReportProcess)reportProcess;
                    this.getRptPluginCommonLogic().loadReport(process);
                    AbstractReportPlugin plugin = this.getReportProcessPlugin();
                    if (plugin != null) {
                        this.getPageCache().put("current_processtype", plugin.getProcessType());
                        this.getPageCache().put("current_report_id", plugin.getProcessId() == null ? null : String.valueOf(plugin.getProcessId()));
                        this.getPageCache().put("current_processid", plugin.getTaskProcessId() == null ? null : String.valueOf(plugin.getTaskProcessId()));
                        new VersionConstrastHelper().tabSelected(this, plugin);
                        AdjustRecordHelper.tabSelected((AbstractFormPlugin)this, plugin);
                        if ((BgTaskStateEnum.UNDERWAY.getNumber().equals(process.getStatus()) || BgTaskStateEnum.COMPLETED.getNumber().equals(process.getStatus()) || BgTaskStateEnum.INCOMPLETE.getNumber().equals(process.getStatus())) && CommonUtils.approveAdjust((Long)this.getModelId())) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"adjustremark"});
                        }
                    }
                }
                catch (KDBizException ex) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap9", "flexpanelap10"});
                    this.getView().showErrorNotification(ex.getMessage());
                    return;
                }
                this.getRptPluginCommonLogic().cacheTabManager();
                this.getRptPluginCommonLogic().cacheLastActiveTab(tabKey);
                this.getRptPluginCommonLogic().addContextMenuItems();
                this.getRptPluginCommonLogic().workFlowStatusChangedRpt(BgTaskExecuteHelper.isExistApproveBill(IDUtils.toLong((Object)this.getPageCache().get("current_report_id"))));
                BgTaskExecuteHelper.hideExamineBtn((IFormView)this.getView(), this.getModelId());
                this.getView().setVisible(Boolean.valueOf(this.abstractReportPlugin instanceof DynamicReportProcess), new String[]{"btn_hideemptyrows", "btn_showemptyrows"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"unaudit", "showbizrulepanel", "eb_dimcontentpanel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"unlock"});
                this.setWeaveVisible();
            }
        } else {
            this.checkmodel();
            String currentTab = tabSelectEvent.getTabKey();
            this.getPageCache().put(TABSELECTED, currentTab);
            this.refreshTabInfo(currentTab);
        }
    }

    private void refreshTabInfo(String currentTab) {
        if (ORGTABPAGE.equals(currentTab)) {
            this.getPageCache().put(TREEVIEW_ID_CACHE, ORG_TREE_VIEW);
        } else if (TEMPTABPAGE.equals(currentTab)) {
            this.getPageCache().put(TREEVIEW_ID_CACHE, TEMP_TREE_VIEW);
        }
    }

    private void refreshTree(Long modelid) {
        String currentTab;
        DynamicObject modelDynamicObject;
        if (modelid == null && (modelDynamicObject = (DynamicObject)this.getModel().getValue(MODEL_F7)) != null) {
            modelid = modelDynamicObject.getLong("id");
        }
        if ((currentTab = this.getPageCache().get(TABSELECTED)) == null) {
            Tab tab = (Tab)this.getControl(TABAP);
            currentTab = tab.getCurrentTab();
            this.getPageCache().put(TABSELECTED, currentTab);
            if (ORGTABPAGE.equals(currentTab)) {
                this.getPageCache().put(TREEVIEW_ID_CACHE, ORG_TREE_VIEW);
            } else if (TEMPTABPAGE.equals(currentTab)) {
                this.getPageCache().put(TREEVIEW_ID_CACHE, TEMP_TREE_VIEW);
            }
        }
        Object value = this.getModel().getValue(ENTITY_MEMBER_F7);
        if (modelid != null && value != null) {
            this.buildLeftTree(modelid, null);
        } else {
            TreeView orgTree = (TreeView)this.getControl(ORG_TREE_VIEW);
            orgTree.deleteAllNodes();
            TreeView templateTree = (TreeView)this.getControl(TEMP_TREE_VIEW);
            templateTree.deleteAllNodes();
        }
        this.getPageCache().put(SEARCH_TEXT_CACHE, null);
    }

    private void buildLeftTree(Long modelid, String currentTab) {
        if (ORGTABPAGE.equals(currentTab)) {
            this.buildOrgTree();
        } else if (TEMPTABPAGE.equals(currentTab)) {
            this.buildTemplateTree();
        } else {
            this.buildOrgTree();
            this.buildTemplateTree();
        }
    }

    private void buildTreeCache(String currentTab, Set<Long> orgSet, Set<Long> templateSet, Set<Long> noCheckPermOrg, Set<Long> noCheckPermTemplate) {
        this.initOrgCache(orgSet, noCheckPermOrg);
        this.initTemplateCache(templateSet, noCheckPermTemplate, orgSet);
    }

    private void initTemplateCache(Set<Long> templateSet, Set<Long> noCheckPermTemplate, Set<Long> orgSet) {
        this.getPageCache().remove(TEMPLATEIDSET);
        this.getPageCache().remove(HASPERMTEMPLATEIDSET);
        this.getPageCache().remove(NOPERMTEMPLATEIDSET);
        if (templateSet.size() == 0) {
            return;
        }
        boolean modelManager = ModelServiceHelper.isModelManager((Long)this.getModelId());
        Set<Object> hasPermTemplateIdSet = new HashSet(16);
        Set<Long> businessTemplate = TemplateHelper.queryTemplateId(this.getIdFormDynamicObject(MODEL_F7), this.getIdFormDynamicObject(BUSINESS_MODEL_F7));
        templateSet.retainAll(businessTemplate);
        noCheckPermTemplate.retainAll(businessTemplate);
        hasPermTemplateIdSet = modelManager ? businessTemplate : TemplatePermServiceHelper.getUserHasPermTemplateIds((Long)this.getIdFormDynamicObject(MODEL_F7), (TemplateTypeEnum)TemplateTypeEnum.BUDGET, templateSet, orgSet, (Long)this.getIdFormDynamicObject(ENTITY_MEMBER_F7));
        templateSet.retainAll(hasPermTemplateIdSet);
        this.getPageCache().put(HASPERMTEMPLATEIDSET, SerializationUtils.serializeToBase64(templateSet));
        this.getPageCache().put(NOPERMTEMPLATEIDSET, SerializationUtils.serializeToBase64(noCheckPermTemplate));
        templateSet.addAll(noCheckPermTemplate);
        this.getPageCache().put(TEMPLATEIDSET, SerializationUtils.serializeToBase64(templateSet));
    }

    private void initOrgCache(Set<Long> orgSet, Set<Long> noCheckPermOrg) {
        this.getPageCache().remove(ORGIDSET);
        this.getPageCache().remove(HASPERMORGIDSET);
        this.getPageCache().remove(NOPERMORGIDSET);
        if (orgSet.size() == 0) {
            return;
        }
        boolean modelManager = ModelServiceHelper.isModelManager((Long)this.getModelId());
        Set<Object> hasPermOrgIdSet = new HashSet(16);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Dimension dimension = orCreate.getDimension(SysDimensionEnum.Entity.getNumber());
        List member = dimension.getMember(this.getIdFormDynamicObject(ENTITY_MEMBER_F7), orgSet);
        Set collect = member.stream().map(BaseCache::getId).collect(Collectors.toSet());
        if (modelManager) {
            if (CollectionUtils.isNotEmpty(collect)) {
                hasPermOrgIdSet.addAll(collect);
            }
        } else {
            Member rootMember;
            hasPermOrgIdSet = new EntityDimPermHelper().getHasPermOrgIdSet(this.getIdFormDynamicObject(MODEL_F7), this.getIdFormDynamicObject(BUSINESS_MODEL_F7), this.getIdFormDynamicObject(ENTITY_MEMBER_F7));
            hasPermOrgIdSet.retainAll(collect);
            log.info("modelid:{}, businessmodelid\uff1a{} orgIdSet:{}", new Object[]{this.getIdFormDynamicObject(MODEL_F7), this.getIdFormDynamicObject(BUSINESS_MODEL_F7), hasPermOrgIdSet});
            if (CollectionUtils.isNotEmpty(hasPermOrgIdSet) && (rootMember = orCreate.getRootMember(SysDimensionEnum.Entity.getNumber(), this.getIdFormDynamicObject(ENTITY_MEMBER_F7))) != null) {
                hasPermOrgIdSet.remove(rootMember.getId());
            }
        }
        if (hasPermOrgIdSet != null) {
            hasPermOrgIdSet.retainAll(orgSet);
            this.getPageCache().put(HASPERMORGIDSET, SerializationUtils.serializeToBase64(hasPermOrgIdSet));
            if (noCheckPermOrg != null && noCheckPermOrg.size() > 0) {
                noCheckPermOrg.retainAll(collect);
                this.getPageCache().put(NOPERMORGIDSET, SerializationUtils.serializeToBase64(noCheckPermOrg));
                hasPermOrgIdSet.addAll(noCheckPermOrg);
            }
            log.info("hasPermOrgIdSet size:{}", (Object)hasPermOrgIdSet.size());
            this.getPageCache().put(ORGIDSET, SerializationUtils.serializeToBase64(hasPermOrgIdSet));
        } else if (noCheckPermOrg != null && noCheckPermOrg.size() > 0) {
            noCheckPermOrg.retainAll(collect);
            log.info("noCheckPermOrg size:{}", (Object)noCheckPermOrg.size());
            this.getPageCache().put(ORGIDSET, SerializationUtils.serializeToBase64(noCheckPermOrg));
            this.getPageCache().put(NOPERMORGIDSET, SerializationUtils.serializeToBase64(noCheckPermOrg));
        }
    }

    private TreeNode buildTemplateNodes() {
        TreeNode node;
        String parentId;
        Object catalogId;
        TreeNode catalogRootNode = new TreeNode();
        catalogRootNode.setText(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"ReportPreparationListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String templateIdSetStr = this.getPageCache().get(TEMPLATEIDSET);
        if (StringUtils.isEmpty((String)templateIdSetStr)) {
            return catalogRootNode;
        }
        Set templateIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)templateIdSetStr);
        if (CollectionUtils.isEmpty((Collection)templateIdSet)) {
            return catalogRootNode;
        }
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        Map templateCatalog = BusinessDataServiceHelper.loadFromCache((String)"eb_templatecatalog", (String)"id,name,number,parent", (QFilter[])filter.toArray(), (String)"level,sequence");
        if (templateCatalog == null) {
            return catalogRootNode;
        }
        for (Map.Entry catalogObj : templateCatalog.entrySet()) {
            catalogId = catalogObj.getKey();
            DynamicObject dynamicObject = (DynamicObject)catalogObj.getValue();
            parentId = dynamicObject.getString("parent_id");
            String name = dynamicObject.getString("name");
            node = new TreeNode();
            node.setId(catalogId.toString());
            node.setText(name);
            node.setParentid(parentId);
            catalogMap.put(catalogId.toString(), node);
        }
        for (Map.Entry catalogObj : templateCatalog.entrySet()) {
            catalogId = catalogObj.getKey();
            DynamicObject dynamicObject = (DynamicObject)catalogObj.getValue();
            parentId = dynamicObject.getString("parent_id");
            String number = dynamicObject.getString("number");
            node = (TreeNode)catalogMap.get(catalogId.toString());
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put("hasTemplate", "0");
            node.setData(dataMap);
            TreeNode parentNode = (TreeNode)catalogMap.get(parentId);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"root", (CharSequence)number) && org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)parentId) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)catalogRootNode.getId())) {
                catalogRootNode = node;
                catalogRootNode.setParentid("");
                continue;
            }
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        QFilter filter1 = new QFilter("id", "in", (Object)templateIdSet);
        Map templateEntity = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity", (String)"id,name,number,templatecatalog", (QFilter[])filter1.toArray(), (String)"number");
        for (Map.Entry entry : templateEntity.entrySet()) {
            Object templateId = entry.getKey();
            DynamicObject templateObj = (DynamicObject)entry.getValue();
            String templatecatalog = templateObj.getDynamicObject("templatecatalog").getString("id");
            TreeNode node2 = new TreeNode();
            node2.setId(templateId.toString());
            node2.setText(templateObj.getString("name"));
            node2.setParentid(templatecatalog);
            TreeNode catalogNode = (TreeNode)catalogMap.get(templatecatalog);
            if (catalogNode == null) {
                catalogRootNode.addChild(node2);
                continue;
            }
            Map data = (Map)catalogNode.getData();
            data.put("hasTemplate", "1");
            catalogNode.addChild(node2);
        }
        ArrayList<TreeNode> needToDeleteNodes = new ArrayList<TreeNode>(16);
        for (Map.Entry catalogEntry : catalogMap.entrySet()) {
            TreeNode value = (TreeNode)catalogEntry.getValue();
            if (value.getData() == null) continue;
            this.templateCatalogNodeHasTemp(value, needToDeleteNodes);
        }
        for (TreeNode needToDeleteNode : needToDeleteNodes) {
            String id = needToDeleteNode.getId();
            catalogRootNode.getTreeNode(id, 20);
            catalogRootNode.deleteChildNode(id);
        }
        return catalogRootNode;
    }

    private void templateCatalogNodeHasTemp(TreeNode catalogNode, List<TreeNode> needToDeleteNodes) {
        if (catalogNode == null || CollectionUtils.isEmpty((Collection)catalogNode.getChildren())) {
            return;
        }
        List children = catalogNode.getChildren();
        for (TreeNode child : children) {
            this.templateCatalogNodeHasTemp(child, needToDeleteNodes);
            Map data = (Map)child.getData();
            if (data == null) continue;
            String hasTemplate = (String)data.get("hasTemplate");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)hasTemplate)) {
                Map data1 = (Map)catalogNode.getData();
                data1.put("hasTemplate", "1");
                continue;
            }
            needToDeleteNodes.add(child);
        }
    }

    private TreeNode buildOrgNodes() {
        Long parentId;
        Member member;
        TreeNode rootNode = new TreeNode();
        rootNode.setText(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ReportQueryListPagePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rootNode.setParentid("");
        rootNode.setId("-1");
        Long idFormDynamicObject = this.getIdFormDynamicObject(ENTITY_MEMBER_F7);
        Member rootMember = this.getIModelCacheHelper().getRootMember(SysDimensionEnum.Entity.getNumber(), idFormDynamicObject);
        if (rootMember == null) {
            log.error("\u6839\u6210\u5458\u83b7\u53d6\u5931\u8d25");
            return rootNode;
        }
        rootNode.setLongNumber(rootMember.getLongNumber());
        String orgIdSetStr = this.getPageCache().get(ORGIDSET);
        if (StringUtils.isEmpty((String)orgIdSetStr)) {
            return rootNode;
        }
        Set orgIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)orgIdSetStr);
        if (CollectionUtils.isEmpty((Collection)orgIdSet)) {
            return rootNode;
        }
        HashMap<Long, TreeNode> treeNodeMap = new HashMap<Long, TreeNode>(16);
        HashMap<Long, Member> memberInfoMap = new HashMap<Long, Member>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (Long entityId : orgIdSet) {
            member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), idFormDynamicObject, entityId);
            if (member == null) continue;
            memberInfoMap.put(entityId, member);
            parentId = member.getParentId();
            TreeNode treeNode = this.buildOrgTreeNode(parentId, entityId, member.getName(), member.getLongNumber());
            treeNodeMap.put(entityId, treeNode);
        }
        for (Long entityId : orgIdSet) {
            member = (Member)memberInfoMap.get(entityId);
            if (member == null) continue;
            parentId = member.getParentId();
            TreeNode parentNode = (TreeNode)treeNodeMap.get(parentId);
            TreeNode node = (TreeNode)treeNodeMap.get(entityId);
            if (parentNode == null) {
                Member orgParentMember = null;
                List parents = modelCacheHelper.getParents(idFormDynamicObject, member, false);
                for (Member parent : parents) {
                    if (!orgIdSet.contains(parent.getId())) continue;
                    orgParentMember = parent;
                    break;
                }
                if (orgParentMember == null) {
                    rootNode.addChild(node);
                    continue;
                }
                TreeNode node1 = (TreeNode)treeNodeMap.get(orgParentMember.getId());
                if (node1 == null) {
                    rootNode.addChild(node);
                    continue;
                }
                node1.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        this.sortOrgNodeByDimManger(rootNode, this.getOrgSeqOfDeep());
        return rootNode;
    }

    private TreeNode buildOrgTreeNode(Long parentId, Long orgId, String nodeName, String longNumber) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(orgId.toString());
        treeNode.setText(nodeName);
        treeNode.setParentid(parentId.toString());
        treeNode.setLongNumber(longNumber);
        return treeNode;
    }

    private Member getOrgParentMember(Member entity, Map<Long, Member> orgMemberMap) {
        if (orgMemberMap == null || entity == null) {
            return null;
        }
        ArrayList<Member> allParentMembers = new ArrayList<Member>(16);
        for (Member value : orgMemberMap.values()) {
            Member member;
            if (value.getId().equals(entity.getId()) || value.getLevel() >= entity.getLevel() || (member = this.compareAllChildIsParent(value, entity)) == null) continue;
            allParentMembers.add(value);
        }
        return allParentMembers.stream().max(Comparator.comparing(Member::getLevel)).orElse(null);
    }

    private Member compareAllChildIsParent(Member parent, Member entity) {
        if (parent == null || entity == null) {
            return null;
        }
        List children = parent.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            if (parent.getId().equals(entity.getId())) {
                return parent;
            }
            return null;
        }
        for (Member child : children) {
            if (child.getId().equals(entity.getId())) {
                return parent;
            }
            Member member = this.compareAllChildIsParent(child, entity);
            if (member == null) continue;
            return member;
        }
        return null;
    }

    private Map<Long, Integer> getOrgSeqOfDeep() {
        String orgIdSetStr = this.getPageCache().get(ORGIDSET);
        if (StringUtils.isEmpty((String)orgIdSetStr)) {
            return null;
        }
        Set orgIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)orgIdSetStr);
        HashMap<Long, Integer> orgSeqMap = new HashMap<Long, Integer>(16);
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        Long orgViewId = this.getIdFormDynamicObject(ENTITY_MEMBER_F7);
        Member rootMember = iModelCacheHelper.getRootMember(SysDimensionEnum.Entity.getNumber(), orgViewId);
        List memberSort = iModelCacheHelper.getMemberSort(SysDimensionEnum.Entity.getNumber(), orgViewId, rootMember.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        if (CollectionUtils.isNotEmpty((Collection)memberSort)) {
            int index = 0;
            for (Member member : memberSort) {
                Long memberId = member.getId();
                if (!orgIdSet.contains(memberId)) continue;
                orgSeqMap.put(memberId, index++);
            }
        }
        return orgSeqMap;
    }

    private void sortOrgNodeByDimManger(TreeNode node, final Map<Long, Integer> entityViewMemberSeq) {
        if (node == null || CollectionUtils.isEmpty((Collection)node.getChildren())) {
            return;
        }
        List children = node.getChildren();
        for (TreeNode child : children) {
            this.sortOrgNodeByDimManger(child, entityViewMemberSeq);
        }
        children.sort(new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                Integer seq1 = (Integer)entityViewMemberSeq.get(IDUtils.toLong((Object)o1.getId()));
                Integer seq2 = (Integer)entityViewMemberSeq.get(IDUtils.toLong((Object)o2.getId()));
                if (seq1 != null && seq2 != null && seq1.compareTo(seq2) != 0) {
                    return seq1.compareTo(seq2);
                }
                return -1;
            }
        });
    }

    private void handleClick(String key) {
        this.getPageCache().put(SELECTED_LAB, key);
        this.resetOtherLab(key);
    }

    private void resetOtherLab(String key) {
        for (String labKey : LAB_KEYS) {
            if (!key.equals(labKey)) {
                this.setLabelForceColor(labKey, "#212121");
                continue;
            }
            this.setLabelForceColor(labKey, "themeColor");
        }
    }

    private void setLabelForceColor(String oldKey, String s) {
        HashMap<String, String> oldMap = new HashMap<String, String>(1);
        oldMap.put("fc", s);
        this.getView().updateControlMetadata(oldKey, oldMap);
    }

    private String getCurrentLab() {
        return this.getPageCache().get(SELECTED_LAB);
    }

    private void checkmodel() {
        long datatypeId;
        long versionId;
        long periodId;
        long entityId;
        long businessId;
        long modelId = this.getIdFormDynamicObject(MODEL_F7);
        if (modelId == 0L) {
            this.getView().hideLoading();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportQueryListPagePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ((businessId = this.getIdFormDynamicObject(BUSINESS_MODEL_F7).longValue()) == 0L) {
            this.getView().hideLoading();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ReportQueryListPagePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ((entityId = this.getIdFormDynamicObject(ENTITY_MEMBER_F7).longValue()) == 0L) {
            this.getView().hideLoading();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"ReportQueryListPagePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ((periodId = this.getIdFormDynamicObject(PERIOD_MEMBER_F7).longValue()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u671f\u95f4\u3002", (String)"ReportQueryListPagePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ((versionId = this.getIdFormDynamicObject(VERSION_MEMBER_F7).longValue()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7248\u672c\u3002", (String)"ReportQueryListPagePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ((datatypeId = this.getIdFormDynamicObject(DATA_TYPE_MEMBER_F7).longValue()) == 0L) {
            this.getView().hideLoading();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b\u3002", (String)"ReportQueryListPagePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String currentTab = this.getPageCache().get(TABSELECTED);
        String text = searchEnterEvent.getText();
        if (StringUtils.isNotEmpty((String)text)) {
            if (ORGTABPAGE.equals(currentTab)) {
                Map<String, TreeNode> treeNodesMap = this.getOrgMap();
                if (treeNodesMap == null || treeNodesMap.isEmpty()) {
                    return;
                }
                this.searchTree(text, ORG_TREE_VIEW, treeNodesMap);
            } else if (TEMPTABPAGE.equals(currentTab)) {
                String tempNode = this.getPageCache().get(TEMPLATENODE);
                if (StringUtils.isEmpty((String)tempNode)) {
                    return;
                }
                Map treeNodesMap = (Map)SerializationUtils.deSerializeFromBase64((String)tempNode);
                if (treeNodesMap == null || treeNodesMap.isEmpty()) {
                    return;
                }
                this.searchTree(text, TEMP_TREE_VIEW, treeNodesMap);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ReportSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void searchTree(String text, String treeName, Map<String, TreeNode> treeNodesMap) {
        TreeView treeView = (TreeView)this.getControl(treeName);
        String rootNodeCache = this.getPageCache().get(treeName);
        Map<Long, Member> memberMap = this.buildOrgMemberMap();
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>(16);
            root.getTreeNodeListByText(hitNode, text, 999);
            SearchResult result = null;
            if (hitNode.size() > 0) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                treeView.focusNode(next);
                if (TEMP_TREE_VIEW.equals(treeName)) {
                    Label label = (Label)this.getControl(TEMP_TEMPLATE_LAB);
                    label.setText(next.getText());
                    this.getPageCache().put(RFOCUS, next.getId());
                } else {
                    Label label = (Label)this.getControl(TEMP_ORG_LAB);
                    label.setText(next.getText());
                    this.getPageCache().put(LFOCUS, next.getId());
                }
                this.expandSearchTreeNode(treeView, root, treeName, next, treeNodesMap, memberMap);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u91cd\u65b0\u641c\u7d22\u3002", (String)"TemplateUserPermPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put(treeName + "search_result", result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    private Map<Long, Member> buildOrgMemberMap() {
        HashMap<Long, Member> orgMemberMap = new HashMap<Long, Member>(16);
        String orgIdSet = this.getPageCache().get(ORGIDSET);
        if (StringUtils.isEmpty((String)orgIdSet)) {
            return orgMemberMap;
        }
        Set entityIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)orgIdSet);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (Long entityId : entityIdSet) {
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.getIdFormDynamicObject(ENTITY_MEMBER_F7), entityId);
            orgMemberMap.put(entityId, member);
        }
        return orgMemberMap;
    }

    private void expandSearchTreeNode(TreeView treeView, TreeNode rootNode, String treeName, TreeNode node, Map<String, TreeNode> treeNodesMap, Map<Long, Member> memberMap) {
        if (node == null || treeView == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)node.getParentid()) || treeNodesMap == null) {
            return;
        }
        if (rootNode != null) {
            treeView.expand(rootNode.getId());
        }
        String cacheKey = node.getParentid();
        treeView.expand(node.getId());
        TreeNode parentNode = treeNodesMap.get(cacheKey);
        if (parentNode != null) {
            treeView.expand(parentNode.getId());
            this.expandSearchTreeNode(treeView, null, treeName, parentNode, treeNodesMap, memberMap);
        } else {
            if (!ORG_TREE_VIEW.equals(treeName)) {
                return;
            }
            String nodeId = node.getId();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nodeId)) {
                return;
            }
            Member member = memberMap.get(IDUtils.toLong((Object)node));
            Member orgParentMember = this.getOrgParentMember(member, memberMap);
            if (orgParentMember != null && orgParentMember.getId() != null && (parentNode = treeNodesMap.get(String.valueOf(orgParentMember.getId()))) != null) {
                treeView.expand(parentNode.getId());
                this.expandSearchTreeNode(treeView, null, treeName, parentNode, treeNodesMap, memberMap);
            }
        }
    }

    private void searchNext(int i) {
        Map<Long, Member> memberMap = this.buildOrgMemberMap();
        String currentTab = this.getPageCache().get(TABSELECTED);
        String treeName = "orgtree";
        Map<String, TreeNode> treeNodesMap = new HashMap(16);
        if (ORGTABPAGE.equals(currentTab)) {
            String orgNode = this.getPageCache().get(ORGNODE);
            if (StringUtils.isEmpty((String)orgNode)) {
                return;
            }
            treeNodesMap = (Map)SerializationUtils.deSerializeFromBase64((String)orgNode);
            if (treeNodesMap == null || treeNodesMap.size() == 0) {
                return;
            }
            treeName = ORG_TREE_VIEW;
        } else if (TEMPTABPAGE.equals(currentTab)) {
            String tempNode = this.getPageCache().get(TEMPLATENODE);
            if (StringUtils.isEmpty((String)tempNode)) {
                return;
            }
            treeNodesMap = (Map)SerializationUtils.deSerializeFromBase64((String)tempNode);
            if (treeNodesMap == null || treeNodesMap.size() == 0) {
                return;
            }
            treeName = TEMP_TREE_VIEW;
        }
        String searchResultCache = this.getPageCache().get(treeName + "search_result");
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(treeName);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u884c\u5185\u5bb9\u3002", (String)"TemplateUserPermPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u884c\u5185\u5bb9\u3002", (String)"TemplateUserPermPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                Label label;
                tree.focusNode(next);
                if (TEMP_TREE_VIEW.equals(treeName)) {
                    label = (Label)this.getControl(TEMP_TEMPLATE_LAB);
                    label.setText(next.getText());
                    this.getPageCache().put(RFOCUS, next.getId());
                } else {
                    label = (Label)this.getControl(TEMP_ORG_LAB);
                    label.setText(next.getText());
                    this.getPageCache().put(LFOCUS, next.getId());
                }
                String rootNodeCache = this.getPageCache().get(treeName);
                if (rootNodeCache != null) {
                    TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
                    this.expandSearchTreeNode(tree, root, treeName, next, treeNodesMap, memberMap);
                }
                this.getPageCache().put(treeName + "search_result", ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"TemplateUserPermPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String getCurrentDataUnitKey() {
        return this.getPageCache().get("cacheDataUnit" + this.getCurrentReportProcessId());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().startsWith("formult`") || e.getKey().startsWith("showpath-name") || e.getKey().startsWith("cellf7")) {
            this.getReportProcessPlugin().onGetControl(e);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        String key = e.getEventArgs();
        if ("closeTab".equals(name)) {
            this.getPageCache().remove(this.getPageCache().get("current_report_id") + "filterMemberCache");
            this.getRptPluginCommonLogic().closeTab(key);
            this.getRptPluginCommonLogic().clearSelect(key);
        } else if ("closeTabs".equals(name)) {
            HashSet<String> keys = new HashSet<String>(16);
            Object keys_obj = JSONUtils.parse((String)key, Object.class);
            if (keys_obj instanceof List) {
                List key_list = (List)keys_obj;
                for (Object item : key_list) {
                    Object id_obj;
                    if (!(item instanceof Map) || (id_obj = ((Map)item).get("id")) == null) continue;
                    keys.add(String.valueOf(id_obj));
                }
            }
            if (keys.size() > 0) {
                this.getRptPluginCommonLogic().closeTabs(keys);
                this.getRptPluginCommonLogic().clearSelects(keys);
            }
        }
    }

    private void setWeaveVisible() {
        boolean exist = false;
        String templateId = this.getPageCache().get("current_rpt");
        if (kd.bos.util.StringUtils.isNotEmpty((String)templateId)) {
            exist = QueryServiceHelper.exists((String)"eb_weavedescentity", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)IDUtils.toLong((Object)templateId))});
        }
        this.getView().setVisible(Boolean.valueOf(exist), new String[]{"btn_weavedesc"});
    }

    private RptPluginCommonLogic getRptPluginCommonLogic() {
        if (this.rptPluginCommonLogic == null) {
            this.rptPluginCommonLogic = RptPluginCommonLogic.getInstance(this);
        }
        return this.rptPluginCommonLogic;
    }

    @Override
    public void destory() {
        super.destory();
        AbstractReportPlugin abstractReportPlugin = this.getReportProcessPlugin();
        if (abstractReportPlugin != null) {
            abstractReportPlugin.destory();
        }
    }

    private String getSortInfoKey() {
        return "sortInfo" + this.getCurrentReportProcessId();
    }

    private Long getCurrentReportProcessId() {
        return IDUtils.toLong((Object)this.getPageCache().get("current_report_id"));
    }

    @Override
    public void sendMsg(CommandParam com) {
        this.sendMsg((IFormView)this.getView(), com);
    }

    @Override
    public void examineRemark(String number) {
    }

    @Override
    public void versionConstrastRemark(Object versionConstrastDto) {
        new VersionConstrastHelper().versionConstrastRemark(versionConstrastDto);
    }

    @Override
    public void showInContainerDesigner(ShowType showType, List<Long> reportIds) {
    }

    public void dealMsg(CommandParam com) {
        if ("switchFloating".equals(com.getOperation())) {
            String data = (String)com.getParam().get(0);
            Map param = (Map)com.getParam().get(1);
            ForecastHelper.switchFloating(data, param, (IFormView)this.getView(), this);
        } else if ("switchFloatingVersion".equals(com.getOperation())) {
            VersionConstrastHelper.switchFloating(com, (IFormView)this.getView(), this);
        } else if ("refreshVersionConstrast".equals(com.getOperation())) {
            new VersionConstrastHelper().versionconstast(this, this.getReportProcessPlugin(), true);
        } else if ("remarkVersionConstrastColor".equals(com.getOperation()) && !com.getParam().isEmpty() && com.getParam().get(0) instanceof VersionConstrastCheckDto) {
            this.getReportProcessPlugin().getView().getFormShowParameter().setCustomParam("reportfloatrows" + this.getReportProcessPlugin().getProcessId(), (Object)"");
            this.getReportProcessPlugin().updateCellColorByVersionConstrast((VersionConstrastCheckDto)com.getParam().get(0), true);
        } else if ("versionConstrastRowClick".equals(com.getOperation()) && com.getParam().size() >= 2) {
            AbstractReportPlugin abstractReportPlugin = this.getReportProcessPlugin();
            if (abstractReportPlugin != null) {
                int row = Convert.toInt(com.getParam().get(0));
                int col = Convert.toInt(com.getParam().get(1));
                abstractReportPlugin.setSelectionsWithoutNotify(new CellArea(row, col, 1, 1), true);
            }
        } else if ("clearVersionConstrast".equals(com.getOperation())) {
            AbstractReportPlugin abstractReportPlugin = this.getReportProcessPlugin();
            if (abstractReportPlugin != null) {
                abstractReportPlugin.clearVersionConstrastResult();
            }
        } else if ("removeVersionMark".equals(com.getOperation())) {
            AbstractReportPlugin abstractReportPlugin = this.getReportProcessPlugin();
            if (abstractReportPlugin != null) {
                abstractReportPlugin.removeVersionMark();
            }
        } else if ("switchFloatingAdjustRecord".equals(com.getOperation())) {
            AdjustRecordHelper.switchFloating(com, (IFormView)this.getView(), this);
        } else if ("adjustRecordChanged".equals(com.getOperation())) {
            int row = (Integer)com.getParam().get(0);
            int col = (Integer)com.getParam().get(1);
            Object value = com.getParam().get(2);
            HashMap<String, Integer> valMap = new HashMap<String, Integer>(16);
            valMap.put(SpreadProperties.UpdataValueMethod.R.k(), row);
            valMap.put(SpreadProperties.UpdataValueMethod.C.k(), col);
            valMap.put(SpreadProperties.UpdataValueMethod.V.k(), (Integer)value);
            this.getReportProcessPlugin().getSpreadContainer().updateCellValue(Collections.singletonList(valMap));
        } else if ("showAdjustRecord".equals(com.getOperation())) {
            this.getReportProcessPlugin().removeRemarkCol("remarkAdjrecord", true);
            Boolean isShowAll = Convert.toBool(com.getParam().get(0));
            String jsonStr = this.getView().getPageCache().get("basePageJson_" + this.getCurrentReportProcessId());
            Map pageJson = (Map)JSONUtils.parse((String)jsonStr, HashMap.class);
            pageJson.put("isShowAll", String.valueOf(isShowAll));
            AdjustRecordHelper.showAllRecords((AbstractFormPlugin)this, this.getReportProcessPlugin(), pageJson);
        } else if ("adjustRecordClick".equals(com.getOperation())) {
            AbstractReportPlugin abstractReportPlugin = this.getReportProcessPlugin();
            int row = Convert.toInt(com.getParam().get(0));
            int col = Convert.toInt(com.getParam().get(1));
            abstractReportPlugin.setSelectionsWithoutNotify(new CellArea(row, col, 1, 1), true);
        } else {
            RptPluginCommonLogic.getInstance(this).dealMsg(com);
        }
    }

    private static class ExecutersFilterFunction
    extends FilterFunction {
        private Set<Long> ids;

        public ExecutersFilterFunction(Set<Long> ids) {
            this.ids = ids;
        }

        public boolean test(Row row) {
            return this.ids.contains(row.getLong("fid"));
        }
    }

    private class ReportQueryListSpreadAction
    extends SpreadActionAdapter
    implements ISpreadAction {
        public ReportQueryListSpreadAction(AbstractFormPlugin plugin) {
            super(plugin);
        }

        public void invokePluginMethod(SpreadEvent event) {
            String methodname = (String)event.getPostData().getInvokeParams().get("invokemethod");
            LinkedHashMap params = event.getPostData().getInvokeParams();
            try {
                if (ReportQueryListPagePlugin.this.abstractReportPlugin != null) {
                    MethodUtils.invokeMethod((Object)ReportQueryListPagePlugin.this.abstractReportPlugin, (String)methodname, (Object)params);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }

        public void showFormulaPanel(SpreadEvent event) {
        }

        public void f7Click(SpreadEvent event) {
        }

        public void cellIsLocked(SpreadEvent event) {
        }

        public void getLookupData(SpreadEvent event) {
        }

        public void setItemByIdFromClient(SpreadEvent event) {
        }

        public void askExecute(SpreadEvent event) {
        }
    }
}

