/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.MessageConstant;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTree;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTreeBuilder;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.lang.StringUtils;

public class ReportQueryMovePlugin
extends AbstractFormPlugin {
    private static final String ROWLIST = "rowlist";
    private static final String FOCUS = "focus";
    private static final String TREEROOT = "treeroot";
    public static final String RPTQUERYCATALOG = "rptquerycatalog";

    public void initialize() {
        super.initialize();
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    ReportQueryMovePlugin.this.searchMember(var1.getText().toLowerCase().trim());
                } else {
                    ReportQueryMovePlugin.this.getPageCache().put(ReportQueryMovePlugin.ROWLIST, null);
                    ReportQueryMovePlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    private void initTree() {
        TreeView treeview = (TreeView)this.getControl(RPTQUERYCATALOG);
        Boolean isPublic = (Boolean)this.getView().getFormShowParameter().getCustomParam("isPublic");
        TemplateCataLogTree rptQueryMoveCatalog = TemplateCataLogTreeBuilder.getRptQueryMoveCatalog((Long)this.getModelId(), (Long)UserUtils.getUserId(), (Boolean)isPublic);
        if (rptQueryMoveCatalog == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5206\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportQueryMovePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        TreeModel treeModel = new TreeModel((ITreeNode)rptQueryMoveCatalog);
        TreeNode treeNode = treeModel.buildEntryTree(treeview);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)treeNode));
    }

    @Override
    public Long getModelId() {
        return Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "btn_confirm": {
                this.moveReportQuery();
                break;
            }
        }
    }

    private void moveReportQuery() {
        TreeView tree = (TreeView)this.getControl(RPTQUERYCATALOG);
        Map map = tree.getTreeState().getFocusNode();
        if (map == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7c7b\u3002", (String)"ReportQueryMovePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String newNodeId = (String)map.get("id");
        String selectIds = (String)this.getView().getFormShowParameter().getCustomParam("selectIds");
        List pkIds = new ArrayList(10);
        if (!StringUtils.isNotEmpty((String)selectIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u62a5\u8868\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportQueryMovePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        pkIds = (List)SerializationUtils.deSerializeFromBase64((String)selectIds);
        String frompath = (String)this.getView().getFormShowParameter().getCustomParam("oldCateName");
        String toPath = (String)map.get("text");
        QFilter qFilter = new QFilter("reportcatalog", "=", (Object)IDUtils.toLong((Object)newNodeId));
        qFilter.and("model", "=", (Object)this.getModelId());
        DynamicObjectCollection sequence = QueryServiceHelper.query((String)"eb_reportquery", (String)"sequence,name", (QFilter[])new QFilter[]{qFilter});
        Integer maxSeq = 0;
        ArrayList<String> nameList = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty((Collection)sequence)) {
            for (DynamicObject dynamicObject : sequence) {
                nameList.add(dynamicObject.getString("name"));
                int sequence1 = dynamicObject.getInt("sequence");
                if (maxSeq >= sequence1) continue;
                maxSeq = sequence1;
            }
        }
        String updateSql = "update t_eb_reportquery set freportcatalogid = ? ,fsequence = ? where fid = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        Long cateId = IDUtils.toLong((Object)newNodeId);
        for (int i = 0; i < pkIds.size(); ++i) {
            Object o = pkIds.get(i);
            Object[] param = new Object[]{cateId, maxSeq + 1, o};
            params.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
        this.writeLog(null, "move", new MultiLangEnumBridge("\u79fb\u52a8", "BgTemplateListPlugin_45", "epm-eb-formplugin"), new MultiLangEnumBridge("%1$s\u62a5\u8868\u4ece%2$s\u79fb\u52a8\u81f3%3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", "ReportQueryMovePlugin_5", "epm-eb-formplugin"), new String[]{((Object)nameList).toString(), frompath, toPath});
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_reportquery"));
        this.getView().returnDataToParent((Object)newNodeId);
        this.getView().close();
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(RPTQUERYCATALOG);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        treeNodes = this.getTreeNodeListByText(root, treeNodes, text);
        List<TreeNode> alltreeNodes = new ArrayList<TreeNode>(16);
        alltreeNodes = this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (treeNodes.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ReportQueryMovePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
        TreeNode asd = treeNodes.get(0);
        this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)0));
        mTree.updateNode(asd);
        mTree.focusNode(asd);
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase().contains(text.toLowerCase())) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }
}

