/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.utils.CodeRuleUtil;

public class ReportQuerySchemeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BAR_SAVE = "btn_ok";
    private static final String SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_SAVE});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValues();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initValues() {
        IDataModel model = this.getModel();
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        Long modelId = (Long)fromShowParams.getCustomParam("model");
        String templateModel = (String)fromShowParams.getCustomParam("TemplateModel");
        Long datasetId = (Long)fromShowParams.getCustomParam("dataset");
        String tarPkId = (String)fromShowParams.getCustomParam("tarPkId");
        if (fromShowParams.getStatus() == OperationStatus.ADDNEW) {
            model.setValue("model", (Object)modelId);
            model.setValue("dataset", (Object)datasetId);
            model.setValue("data", (Object)templateModel);
            model.setValue("targetid", (Object)IDUtils.toLong((Object)tarPkId));
            model.setValue("creator", (Object)UserUtils.getUserId());
            model.setValue("createtime", (Object)TimeServiceHelper.now());
            model.setValue("modifier", (Object)UserUtils.getUserId());
            model.setValue("modifytime", (Object)TimeServiceHelper.now());
            model.setValue("number", (Object)CodeRuleUtil.getCodeRuleNumber("eb_reportscheme", null));
        } else if (fromShowParams.getStatus() == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        IDataModel model = this.getModel();
        super.beforeDoOperation(evt);
        String type = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (type.equals(SAVE)) {
            String number = model.getDataEntity().getString("number");
            String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
            if (StringUtils.isNotEmpty((String)checkNumber)) {
                throw new KDBizException(checkNumber);
            }
            String check = this.checkResult();
            if (!StringUtils.isEmpty((String)check)) {
                this.getView().showTipNotification(check);
                evt.cancel = true;
            }
        }
    }

    private String checkResult() {
        Boolean numCheck = this.checkExistsModel(1);
        Boolean nameCheck = this.checkExistsModel(2);
        if (numCheck.booleanValue() && nameCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u548c\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportQuerySchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (numCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ReportQuerySchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (nameCheck.booleanValue()) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ReportQuerySchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private Boolean checkExistsModel(int checkModel) {
        Boolean result = false;
        IDataModel dataModel = this.getModel();
        DynamicObject model = (DynamicObject)dataModel.getValue("model");
        Long modelId = model.getLong("id");
        DynamicObject dataset = (DynamicObject)dataModel.getValue("dataset");
        Long datasetId = dataset.getLong("id");
        Long targetId = dataModel.getDataEntity().getLong("targetid");
        String number = dataModel.getDataEntity().getString("number");
        String name = dataModel.getDataEntity().getString("name");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("dataset", "=", (Object)datasetId));
        filters.add(new QFilter("targetid", "=", (Object)targetId));
        if (1 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number);
            filters.add(nameOrNum);
        } else if (2 == checkModel) {
            QFilter nameOrNum = new QFilter("name", "=", (Object)name);
            filters.add(nameOrNum);
        } else if (3 == checkModel) {
            QFilter nameOrNum = new QFilter("number", "=", (Object)number).or(new QFilter("name", "=", (Object)name));
            filters.add(nameOrNum);
        } else if (4 == checkModel) {
            QFilter nameAndNum = new QFilter("number", "=", (Object)number).and(new QFilter("name", "=", (Object)name));
            filters.add(nameAndNum);
        }
        filters.add(new QFilter("id", "!=", (Object)dataModel.getDataEntity().getLong("id")));
        result = QueryServiceHelper.exists((String)"eb_reportscheme", (QFilter[])filters.toArray(new QFilter[0]));
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals(SAVE)) {
            boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
            if (isSuccess) {
                String number = (String)this.getModel().getValue("number");
                this.getView().returnDataToParent((Object)number);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53e6\u5b58\u65b9\u6848\u5931\u8d25", (String)"ReportQuerySchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }
}

