/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.ReportQueryDesignerConstant;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.designer.ReportQueryDesignerHelper;
import kd.epm.eb.formplugin.report.designer.ShareSettingDto;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ReportQueryShowSettingPlugin
extends AbstractFormPlugin
implements ReportQueryDesignerConstant {
    private static final String METRIC_ENTRYENTITY = "metricentryentity";
    private static final String DIM_ENTRYENTITY = "dimentryentity";
    private static final String CTRLKEY_BD_METRIC = "bd_metric";
    private static final String CTRLKEY_DECIMALNUM = "decimalnum";
    private static final String DEF_EMPTY_DISPLAY = "defemptydisplay";
    private static final String DEF_UNIT_DISPLAY = "defunitdisplay";
    private IModelCacheHelper modelCacheHelper;

    public void afterCreateNewData(EventObject e) {
        ShareSettingDto shareSetting = this.getQuerySettingFormParam();
        this.initMetricDisplay(shareSetting);
        this.initDimVisible(shareSetting);
        this.initEmtpyAndUnit(shareSetting);
        this.initMemberDisplay(shareSetting);
    }

    private void initMemberDisplay(ShareSettingDto shareSetting) {
        boolean hasLongNumberName = CollectionUtils.isNotEmpty((Collection)MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)this.getModelId()));
        ComboEdit comboEdit = (ComboEdit)this.getControl("membershowtype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.NAME.getDisplayName().loadKDString()), "show_dimname"));
        comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.SIMPLENAME.getDisplayName().loadKDString()), "btn_showsimname"));
        comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.NUMBER.getDisplayName().loadKDString()), "show_dimnumber"));
        comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.NAMEANDNUMBER.getDisplayName().loadKDString()), "show_dimnamenumber"));
        comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.SIMNAMENUMBER.getDisplayName().loadKDString()), "btn_showsimnamenum"));
        if (hasLongNumberName) {
            comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.LONGNUMBER.getDisplayName().loadKDString()), "btn_showlongnumber"));
            comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.LONGNAME.getDisplayName().loadKDString()), "btn_showlongname"));
            comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.LONGNAMENUMBER.getDisplayName().loadKDString()), "btn_showlongnamenum"));
        }
        String value = null;
        comboEdit.setComboItems(comboItems);
        value = shareSetting.getMemberShowType();
        if (value != null) {
            if (!hasLongNumberName && (value.equals("btn_showlongnumber") || value.equals("btn_showlongname") || value.equals("btn_showlongnamenum"))) {
                value = "show_dimname";
            }
            this.getModel().setValue("membershowtype", (Object)value);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("btn_confirm")) {
            ShareSettingDto shareSettingDto = this.getShareSettingDto();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)shareSettingDto));
            this.getView().close();
        }
    }

    private void initMetricDisplay(ShareSettingDto shareSettingDto) {
        DynamicObjectCollection metrics;
        Long modelId;
        String metricDisplayStr;
        this.getModel().deleteEntryData(METRIC_ENTRYENTITY);
        Map metricDisplayMap = shareSettingDto.getMetricDisplay();
        if (MapUtils.isEmpty(metricDisplayMap) && StringUtils.isNotEmpty((String)(metricDisplayStr = (String)this.getFormCustomParam("metricdisplay")))) {
            metricDisplayMap = (Map)SerializationUtils.fromJsonString((String)metricDisplayStr, Map.class);
        }
        if (IDUtils.isNotNull((Long)(modelId = this.getModelId())) && metricDisplayMap != null && (metrics = MetricUtils.getMetricsByNumber((Long)modelId, metricDisplayMap.keySet())) != null && metrics.size() > 0) {
            this.getModel().batchCreateNewEntryRow(METRIC_ENTRYENTITY, metrics.size());
            this.getModel().beginInit();
            int i = 0;
            for (DynamicObject metric : metrics) {
                this.getModel().setValue(CTRLKEY_BD_METRIC, (Object)metric.getLong("id"), i);
                this.getModel().setValue(CTRLKEY_DECIMALNUM, metricDisplayMap.get(metric.getString("number")), i);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(METRIC_ENTRYENTITY);
        }
    }

    private Map<String, Integer> loadDataFromUI() {
        HashMap<String, Integer> data = new HashMap<String, Integer>(16);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(METRIC_ENTRYENTITY);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                data.put(dynamicObject.getDynamicObject(CTRLKEY_BD_METRIC).getString("number"), dynamicObject.getInt(CTRLKEY_DECIMALNUM));
            }
        }
        return data;
    }

    private void initEmtpyAndUnit(ShareSettingDto shareSettingDto) {
        if (shareSettingDto != null) {
            String dataUnit = shareSettingDto.getDataUnit();
            this.getModel().setValue(DEF_UNIT_DISPLAY, (Object)dataUnit);
            String hideEmptyDataRow = shareSettingDto.getHideEmptyDataRow();
            String hideEmptyDatCol = shareSettingDto.getHideEmptyDatCol();
            if ("0".equals(hideEmptyDataRow) && "0".equals(hideEmptyDatCol)) {
                this.getModel().setValue(DEF_EMPTY_DISPLAY, (Object)"btn_showemptyall");
            } else if ("1".equals(hideEmptyDataRow) && "1".equals(hideEmptyDatCol)) {
                this.getModel().setValue(DEF_EMPTY_DISPLAY, (Object)"btn_hideemptyall");
            } else if ("0".equals(hideEmptyDataRow) && "1".equals(hideEmptyDatCol)) {
                this.getModel().setValue(DEF_EMPTY_DISPLAY, (Object)"btn_showemptyrow");
            } else if ("1".equals(hideEmptyDataRow) && "0".equals(hideEmptyDatCol)) {
                this.getModel().setValue(DEF_EMPTY_DISPLAY, (Object)"btn_showemptycol");
            }
        }
    }

    private void initDimVisible(ShareSettingDto shareSetting) {
        ITemplateModel templateModel = this.getTemplateModelFromShowParam();
        Map<String, List<IDimensionMember>> pageDimMemValue = this.getPageDimMemValue(templateModel);
        Map<String, Map<String, String>> allPointEntry = this.getPointEntryFromTemplateModel(templateModel);
        Map<String, String> dimVisible = new HashMap<String, String>(16);
        if (shareSetting != null) {
            dimVisible = shareSetting.getDimVisible();
        }
        this.updateData(dimVisible, allPointEntry, pageDimMemValue);
    }

    private void updateData(Map<String, String> dimDefHideMap, Map<String, Map<String, String>> allPointEntry, Map<String, List<IDimensionMember>> pageDimMemValue) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(DIM_ENTRYENTITY);
        allPointEntry.forEach((f7Key, dimInfo) -> {
            String number = (String)dimInfo.get("number");
            int newRow = this.getModel().createNewEntryRow(DIM_ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(DIM_ENTRYENTITY, newRow);
            entryRowEntity.set("number", (Object)number);
            entryRowEntity.set("name", dimInfo.get("name"));
            List members = (List)pageDimMemValue.get(number);
            if (StringUtils.isNotEmpty((String)((String)dimDefHideMap.get(number)))) {
                entryRowEntity.set("hide", (Object)"0".equals(dimDefHideMap.get(number)));
            } else if (f7Key.endsWith("page") && members != null && members.size() == 1 && !"ebf7_entity_page".equals(f7Key)) {
                entryRowEntity.set("hide", (Object)true);
            }
            if (f7Key.endsWith("page") && members != null) {
                List names = members.stream().map(IBaseEntry::getName).collect(Collectors.toList());
                entryRowEntity.set("defvalue", (Object)String.join((CharSequence)",", names));
            }
        });
        this.getModel().endInit();
    }

    private ShareSettingDto getQuerySettingFormParam() {
        String param_querySetting = (String)this.getFormCustomParam("querysetting");
        if (param_querySetting != null) {
            return (ShareSettingDto)SerializationUtils.fromJsonString((String)param_querySetting, ShareSettingDto.class);
        }
        return new ShareSettingDto();
    }

    private Map<String, List<IDimensionMember>> getPageDimMemValue(ITemplateModel templateModel) {
        HashMap<String, List<IDimensionMember>> pageDimMemValue = new HashMap<String, List<IDimensionMember>>(16);
        List pagemembentry = templateModel.getPagemembentry();
        if (pagemembentry.size() > 0) {
            for (IPageDimensionEntry pageDimensionEntry : pagemembentry) {
                IDimension dimension = pageDimensionEntry.getDimension();
                List members = pageDimensionEntry.getMembers();
                pageDimMemValue.put(dimension.getNumber(), members);
            }
        }
        return pageDimMemValue;
    }

    private Map<String, Map<String, String>> getPointEntryFromTemplateModel(ITemplateModel templateModel) {
        ReportQueryDesignerHelper instance = ReportQueryDesignerHelper.getInstance();
        return instance.getPointEntryFromTemplateModel(templateModel, this.getDataSetId());
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getCache("model");
        if (modelId == null) {
            modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.setCache("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    private ITemplateModel getTemplateModelFromShowParam() {
        String customParam = this.getCache("TemplateModel");
        if (customParam == null) {
            customParam = (String)this.getView().getFormShowParameter().getCustomParam("TemplateModel");
            this.setCache("TemplateModel", customParam);
        }
        return TemplateModelJSONUtil.parseITemplateModel((String)customParam);
    }

    private void setCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private ShareSettingDto getShareSettingDto() {
        ShareSettingDto shareSettingDto = this.getQuerySettingFormParam();
        Map<String, String> dimVisible = shareSettingDto.getDimVisible();
        Object membershowtype = this.getModel().getValue("membershowtype");
        if (membershowtype != null) {
            shareSettingDto.setMemberShowType((String)membershowtype);
        }
        dimVisible.clear();
        shareSettingDto.setMetricDisplay(this.loadDataFromUI());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DIM_ENTRYENTITY);
        for (DynamicObject object : entryEntity) {
            String number = object.getString("number");
            boolean hide = object.getBoolean("hide");
            dimVisible.put(number, hide ? "0" : "1");
        }
        shareSettingDto.setDataUnit((String)this.getModel().getValue(DEF_UNIT_DISPLAY));
        String emptyDisplay = (String)this.getModel().getValue(DEF_EMPTY_DISPLAY);
        if (emptyDisplay.equals("btn_showemptyall")) {
            shareSettingDto.setHideEmptyDataRow("0");
            shareSettingDto.setHideEmptyDatCol("0");
        } else if (emptyDisplay.equals("btn_hideemptyall")) {
            shareSettingDto.setHideEmptyDatCol("1");
            shareSettingDto.setHideEmptyDataRow("1");
        } else if (emptyDisplay.equals("btn_showemptycol") || emptyDisplay.equals("btn_hideemptyrow")) {
            shareSettingDto.setHideEmptyDataRow("1");
            shareSettingDto.setHideEmptyDatCol("0");
        } else if (emptyDisplay.equals("btn_showemptyrow") || emptyDisplay.equals("btn_hideemptycol")) {
            shareSettingDto.setHideEmptyDataRow("0");
            shareSettingDto.setHideEmptyDatCol("1");
        }
        return shareSettingDto;
    }

    private Long getDataSetId() {
        return (Long)this.getFormCustomParam("dataset");
    }
}

