/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.reportview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportSortDiminfoDto;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class FixReportProcessCustomSortPlugin
extends AbstractFormPlugin {
    private List<String> sortDimNumber = new ArrayList<String>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        List historySortInfo;
        String historyInfoStr;
        List<String> sortDimNumber = this.getSortDimNumber();
        if (CollectionUtils.isNotEmpty(sortDimNumber)) {
            this.setDimCombo(sortDimNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)(historyInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("historyInfo"))) && CollectionUtils.isNotEmpty((Collection)(historySortInfo = (List)SerializationUtils.fromJsonString((String)historyInfoStr, List.class)))) {
            Map map;
            int i;
            ArrayList<Map> temp = new ArrayList<Map>(16);
            for (i = 0; i < historySortInfo.size(); ++i) {
                map = (Map)historySortInfo.get(i);
                if (!sortDimNumber.contains((String)map.get("dimnumber"))) continue;
                temp.add(map);
            }
            this.getView().getModel().batchCreateNewEntryRow("entryentity", temp.size());
            this.getModel().beginInit();
            for (i = 0; i < temp.size(); ++i) {
                map = (Map)temp.get(i);
                this.getModel().setValue("dim_combo", (Object)((String)map.get("dimnumber")), i);
                this.getModel().setValue("sort_combo", (Object)((String)map.get("sortOrder")), i);
                this.getModel().setValue("order_combo", (Object)((String)map.get("orderBy")), i);
            }
            this.getModel().endInit();
        }
    }

    private void setDimCombo(List<String> sortDimNumber) {
        ComboEdit control = (ComboEdit)this.getControl("dim_combo");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (orCreate == null) {
            return;
        }
        for (String dimNumber : sortDimNumber) {
            Dimension dimension = orCreate.getDimension(dimNumber);
            if (dimension == null) continue;
            items.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        }
        control.setComboItems(items);
        control.setComboInputable(true);
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                Optional<DynamicObject> dim_combo1 = entryentity.stream().filter(x -> x.getString("dim_combo") == null).findFirst();
                if (dim_combo1.isPresent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FixReportProcessCustomSortPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set dim_combo = entryentity.stream().map(x -> x.get("dim_combo")).collect(Collectors.toSet());
                if (entryentity.size() > dim_combo.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u53bb\u9664\u91cd\u590d\u9879\uff0c\u518d\u91cd\u8bd5\u3002", (String)"FixReportProcessCustomSortPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<FixReportSortDiminfoDto> sortDiminfoDtos = new ArrayList<FixReportSortDiminfoDto>(entryentity.size());
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                    FixReportSortDiminfoDto temp = new FixReportSortDiminfoDto(dynamicObject.getString("sort_combo"), dynamicObject.getString("order_combo"), i + 1, dynamicObject.getString("dim_combo"), true);
                    sortDiminfoDtos.add(temp);
                }
                HashMap<String, Object> sortInfo = new HashMap<String, Object>(2);
                sortInfo.put("areaIndex", this.getAreaIndex());
                sortInfo.put("dimList", sortDiminfoDtos);
                this.getView().returnDataToParent(sortInfo);
                this.getView().close();
            } else {
                ArrayList sortDiminfoDtos = new ArrayList(16);
                HashMap<String, Object> sortInfo = new HashMap<String, Object>(2);
                sortInfo.put("areaIndex", this.getAreaIndex());
                sortInfo.put("dimList", sortDiminfoDtos);
                this.getView().returnDataToParent(sortInfo);
                this.getView().close();
            }
        }
    }

    @Override
    public Long getModelId() {
        Object modelid = this.getView().getFormShowParameter().getCustomParam("modelid");
        if (modelid != null) {
            return IDUtils.toLong((Object)modelid);
        }
        return 0L;
    }

    public List<String> getSortDimNumber() {
        Map temp;
        Object dimList;
        String sortMap;
        if (CollectionUtils.isEmpty(this.sortDimNumber) && (sortMap = (String)this.getView().getFormShowParameter().getCustomParam("sortMap")) != null && (dimList = (temp = (Map)SerializationUtils.fromJsonString((String)sortMap, Map.class)).get("dimList")) != null) {
            this.sortDimNumber = (List)dimList;
        }
        return this.sortDimNumber;
    }

    private String getAreaIndex() {
        Map temp;
        Object areaIndex;
        String sortMap = (String)this.getView().getFormShowParameter().getCustomParam("sortMap");
        if (sortMap != null && (areaIndex = (temp = (Map)SerializationUtils.fromJsonString((String)sortMap, Map.class)).get("areaIndex")) != null) {
            return (String)areaIndex;
        }
        return "";
    }
}

