/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.reportview;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.PluginInitHelper;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.reportview.FixReportProcess;
import kd.epm.eb.formplugin.report.reportview.utils.PasteCheckUtils;
import kd.epm.eb.spread.fix.FloatPasteInfo;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import org.apache.commons.collections.CollectionUtils;

public class FloatPasteCheckPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(FloatPasteCheckPlugin.class);
    public static final String ATTRIBUTE = "attribute";
    public static final String CACHHE_ATTRIBUTE = "cache_attribute";
    public static final String ATTRIBUTE_NUM = "attributeNum";
    private IEbSpreadManager ebSpreadManager;
    Long modelId;
    private IModelCacheHelper modelCacheHelper;

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_cancel", "btn_ok", "selectexist"});
        this.getEntryGrid().addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initTabap(this.getPasteInfoMap(false));
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        try {
            String tabKey = tabSelectEvent.getTabKey();
            if (StringUtils.isEmpty((String)tabKey)) {
                return;
            }
            this.getPageCache().put("currentTabKey", tabKey);
            this.refreshPasteEntry(this.getPasteInfoMap(true).get(tabKey));
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            CommonServiceHelper.dealException((IFormView)this.getView(), (String)"FloatPasteCheckPlugin.tabSelected", (Throwable)e);
        }
    }

    private void validEntryData(List<FloatPasteInfo> list, Map<String, Map<String, Set<String>>> totalCheckResult, IModelCacheHelper modelCacheHelper) {
        FloatPasteInfo floatPasteInfo;
        Dimension dimension;
        if (CollectionUtils.isNotEmpty(list) && (dimension = modelCacheHelper.getDimension((floatPasteInfo = list.get(0)).getDimNumber())) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(dimension.getName()).append("_");
            List propertys = floatPasteInfo.getDimPropertys() == null ? new ArrayList(10) : floatPasteInfo.getDimPropertys();
            propertys.forEach(propertyObj -> stringBuilder.append(propertyObj.getName()).append("_"));
            if (stringBuilder.length() > 0) {
                String tabName = stringBuilder.substring(0, stringBuilder.length() - 1);
                for (int i = 0; i < list.size(); ++i) {
                    Set strings;
                    List dimPropertys;
                    FloatPasteInfo pasteInfo = list.get(i);
                    String indexRow = ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a", (String)"FloatPasteCheckPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1});
                    List list2 = dimPropertys = pasteInfo.getDimPropertys() == null ? new ArrayList(10) : pasteInfo.getDimPropertys();
                    if (floatPasteInfo.isQuickAddNew() && 1 == pasteInfo.getDeal()) {
                        if (pasteInfo.getPasteValue() != null && pasteInfo.getPasteValue().length() > 50) {
                            Map cellErrorMap = totalCheckResult.computeIfAbsent(tabName, v -> new LinkedHashMap(16));
                            strings = cellErrorMap.computeIfAbsent(indexRow, v -> new LinkedHashSet(16));
                            strings.add(ResManager.loadKDString((String)"\u540d\u79f0\u957f\u5ea6\u8d85\u957f\uff0c\u4e0d\u80fd\u5927\u4e8e50", (String)"FloatPasteCheckPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        for (int j = 1; j <= dimPropertys.size(); ++j) {
                            PropertyObj propertyObj2 = (PropertyObj)dimPropertys.get(j - 1);
                            if (!propertyObj2.isAddMustInput() || !CollectionUtils.isEmpty((Collection)propertyObj2.getPropertyValueEntries()) && propertyObj2.getPropertyValueEntries().size() == 1 && !IDUtils.isNull((Long)((PropertyMemObj)propertyObj2.getPropertyValueEntries().get(0)).getId())) continue;
                            Map cellErrorMap = totalCheckResult.computeIfAbsent(tabName, v -> new LinkedHashMap(16));
                            Set strings2 = cellErrorMap.computeIfAbsent(indexRow, v -> new LinkedHashSet(16));
                            strings2.add(ResManager.loadResFormat((String)"\u672a\u8bbe\u7f6e\u201c%1\u201d\u6210\u5458", (String)"FloatPasteCheckPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{propertyObj2.getName()}));
                        }
                        continue;
                    }
                    if (2 != pasteInfo.getDeal() || !StringUtils.isEmpty((String)pasteInfo.getNumber()) && !IDUtils.isNull((Long)pasteInfo.getSelectedId())) continue;
                    Map cellErrorMap = totalCheckResult.computeIfAbsent(tabName, v -> new LinkedHashMap(16));
                    strings = cellErrorMap.computeIfAbsent(indexRow, v -> new LinkedHashSet(16));
                    strings.add(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u201c\u9009\u62e9\u5df2\u5b58\u5728\u6210\u5458\u201d", (String)"FloatPasteCheckPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void refreshPasteEntry(List<FloatPasteInfo> floatPasteInfos) {
        this.getModel().deleteEntryData("entryentity");
        if (CollectionUtils.isNotEmpty(floatPasteInfos)) {
            this.buildAttributeComboItems(floatPasteInfos);
            this.refreshDealComboItems(floatPasteInfos.get(0));
            this.fillEntryData(floatPasteInfos);
            this.setAttributeVisible();
            this.refreshEnable(floatPasteInfos);
        }
    }

    private void refreshDealComboItems(FloatPasteInfo pasteInfo) {
        String dimNumber = pasteInfo.getDimNumber();
        SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimNumber);
        boolean isSysPreset = enumByNumber != null;
        ComboEdit deal = (ComboEdit)this.getControl("deal");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(3);
        if (!isSysPreset && pasteInfo.isQuickAddNew()) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u65b0\u589e\u6210\u5458\u5e76\u586b\u5145", (String)"FloatPasteCheckPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])), String.valueOf(1)));
        }
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9009\u62e9\u5df2\u6709\u6210\u5458\u5e76\u586b\u5145", (String)"FloatPasteCheckPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0])), String.valueOf(2)));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u65b0\u589e\u4e5f\u4e0d\u586b\u5145", (String)"FloatPasteCheckPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0])), String.valueOf(3)));
        deal.setComboItems(items);
        deal.setComboInputable(true);
    }

    private void setAttributeVisible() {
        String s = this.getPageCache().get(ATTRIBUTE_NUM);
        int num = 0;
        if (StringUtils.isNotEmpty((String)s)) {
            num = Integer.parseInt(s);
        }
        for (int j = 0; j < 10; ++j) {
            this.getView().setVisible(Boolean.valueOf(j < num), new String[]{ATTRIBUTE + (j + 1)});
        }
    }

    private void refreshEnable(List<FloatPasteInfo> floatPasteInfos) {
        for (int i = 0; i < floatPasteInfos.size(); ++i) {
            FloatPasteInfo floatPasteInfo = floatPasteInfos.get(i);
            int deal = floatPasteInfo.getDeal();
            if (StringUtils.isEmpty((String)this.getPageCache().get(CACHHE_ATTRIBUTE))) {
                return;
            }
            if (2 == deal) {
                this.getView().setEnable(Boolean.valueOf(false), i, this.getPageCache().get(CACHHE_ATTRIBUTE).split(","));
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"selectexist"});
                continue;
            }
            if (1 == deal) {
                this.getView().setEnable(Boolean.valueOf(true), i, this.getPageCache().get(CACHHE_ATTRIBUTE).split(","));
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"selectexist"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, this.getPageCache().get(CACHHE_ATTRIBUTE).split(","));
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"selectexist"});
        }
    }

    private void fillEntryData(List<FloatPasteInfo> floatPasteInfos) {
        this.getModel().beginInit();
        int[] ints = this.getModel().batchCreateNewEntryRow("entryentity", floatPasteInfos.size());
        this.getModel().endInit();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        for (int i = 0; i < ints.length; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            if (rowEntity == null) continue;
            FloatPasteInfo floatPasteInfo = floatPasteInfos.get(i);
            rowEntity.set("cell", (Object)floatPasteInfo.getPosition());
            rowEntity.set("pastvalue", (Object)floatPasteInfo.getPasteValue());
            rowEntity.set("result", (Object)floatPasteInfo.getCheckResult());
            rowEntity.set("deal", (Object)floatPasteInfo.getDeal());
            if (2 == floatPasteInfo.getDeal() && StringUtils.isNotEmpty((String)floatPasteInfo.getNumber())) {
                rowEntity.set("selectexist", (Object)(floatPasteInfo.getName() + " " + floatPasteInfo.getNumber()));
            } else {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"selectexist"});
            }
            rowEntity.set("parent", (Object)floatPasteInfo.getParentNumber());
            Member member = modelCacheHelper.getMember(floatPasteInfo.getDimNumber(), floatPasteInfo.getViewId(), floatPasteInfo.getSelectedId());
            this.setAttributeDefaultValue(member, i, floatPasteInfo);
        }
        this.getView().updateView("entryentity");
    }

    private void setAttributeDefaultValue(Member member, int i, FloatPasteInfo floatPasteInfo) {
        Map defaultProp = floatPasteInfo.getDefaultProp();
        List dimPropertys = floatPasteInfo.getDimPropertys() == null ? new ArrayList(10) : floatPasteInfo.getDimPropertys();
        this.getModel().beginInit();
        for (int j = 1; j <= dimPropertys.size(); ++j) {
            this.getModel().setValue(ATTRIBUTE + j, null, i);
            PropertyObj propertyObj = (PropertyObj)dimPropertys.get(j - 1);
            String number = propertyObj.getNumber();
            if (member != null && defaultProp != null) {
                String propertyValueNumber;
                Map propMap = (Map)defaultProp.get(member.getNumber());
                if (propMap == null || !StringUtils.isNotEmpty((String)(propertyValueNumber = (String)propMap.get(number)))) continue;
                this.getModel().setValue(ATTRIBUTE + j, (Object)propertyValueNumber, i);
                continue;
            }
            List propertyValueEntries = propertyObj.getPropertyValueEntries();
            if (!CollectionUtils.isNotEmpty((Collection)propertyValueEntries) || propertyValueEntries.size() != 1 || !IDUtils.isNotNull((Long)((PropertyMemObj)propertyValueEntries.get(0)).getId())) continue;
            this.getModel().setValue(ATTRIBUTE + j, (Object)((PropertyMemObj)propertyValueEntries.get(0)).getId(), i);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void initTabap(Map<String, List<FloatPasteInfo>> floatPasteInfoMap) {
        if (floatPasteInfoMap == null || floatPasteInfoMap.size() == 0) {
            return;
        }
        TabAp tabap = new TabAp();
        tabap.setKey("tabap");
        tabap.setName(new LocaleString("tabap"));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>(10);
        Map.Entry<String, List<FloatPasteInfo>> listEntry = floatPasteInfoMap.entrySet().iterator().next();
        String tabKey = listEntry.getKey().toLowerCase(Locale.ROOT);
        this.getPageCache().put("currentTabKey", tabKey);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        for (Map.Entry<String, List<FloatPasteInfo>> entry : floatPasteInfoMap.entrySet()) {
            String key2 = entry.getKey();
            List<FloatPasteInfo> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            FloatPasteInfo next = value.get(0);
            keys.add(key2.toLowerCase(Locale.ROOT));
            String dimensionNumber = next.getDimNumber();
            Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(key2.toLowerCase(Locale.ROOT));
            List dimPropertys = next.getDimPropertys() == null ? new ArrayList(10) : next.getDimPropertys();
            StringBuilder stringBuilder = new StringBuilder(dimension.getName());
            stringBuilder.append("_");
            if (CollectionUtils.isNotEmpty(dimPropertys)) {
                for (PropertyObj dimProperty : dimPropertys) {
                    stringBuilder.append(dimProperty.getName()).append("_");
                }
            }
            tabPageAp.setName(new LocaleString(stringBuilder.substring(0, stringBuilder.length() - 1)));
            tabap.getItems().add(tabPageAp);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"", (String)"", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("tabap", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(1);
        closeMap.put("closable", false);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
        Tab modelTab = (Tab)this.getView().getControl("tabap");
        modelTab.activeTab(tabKey);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void buildAttributeComboItems(List<FloatPasteInfo> floatPasteInfos) {
        FloatPasteInfo floatPaste = floatPasteInfos.get(0);
        List areaPro = floatPaste.getDimPropertys() == null ? new ArrayList(10) : floatPaste.getDimPropertys();
        this.getPageCache().remove(ATTRIBUTE_NUM);
        this.getPageCache().remove(CACHHE_ATTRIBUTE);
        if (areaPro != null && areaPro.size() > 0) {
            int i = 1;
            StringBuilder sb = new StringBuilder();
            for (PropertyObj propertyObj : areaPro) {
                if (i > 10) continue;
                DynamicObjectCollection dynamicObjects = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertyValuie(propertyObj.getId(), "id,number,name");
                ComboEdit control = (ComboEdit)this.getControl(ATTRIBUTE + i);
                control.setCaption(new LocaleString(propertyObj.getName()));
                sb.append(ATTRIBUTE).append(i).append(",");
                ++i;
                if (!CollectionUtils.isNotEmpty((Collection)dynamicObjects)) continue;
                ArrayList<ComboItem> items = new ArrayList<ComboItem>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    items.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("id")));
                }
                control.setComboItems(items);
                control.setComboInputable(true);
            }
            if (StringUtils.isNotEmpty((String)sb.toString())) {
                this.getPageCache().put(CACHHE_ATTRIBUTE, sb.substring(0, sb.length() - 1));
            }
            this.getPageCache().put(ATTRIBUTE_NUM, String.valueOf(areaPro.size()));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("closed") == null) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u5c06\u4e0d\u4f1a\u5bf9\u8fd9\u4e9b\u5355\u5143\u683c\u505a\u4efb\u4f55\u5904\u7406\uff0c\u662f\u5426\u786e\u8ba4\u53d6\u6d88\uff1f", (String)"FloatPasteCheckPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("close".equals(key) && MessageBoxResult.Yes == evt.getResult()) {
            this.getPageCache().put("closed", "true");
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        try {
            String key;
            super.click(evt);
            Control control = (Control)evt.getSource();
            switch (key = control.getKey()) {
                case "btn_ok": {
                    Map<String, List<FloatPasteInfo>> pasteInfoMap = this.getPasteInfoMap(true);
                    PasteCheckUtils.getInstance().mainSubModelCheck(pasteInfoMap, this.getModelCacheHelper());
                    String result = this.getPageCache().get("validEntryResult");
                    Map<String, Map<String, Set<String>>> totalCheckResult = new HashMap(16);
                    if (StringUtils.isNotEmpty((String)result)) {
                        totalCheckResult = (Map)ObjectSerialUtil.deSerializedBytes((String)result);
                    }
                    for (Map.Entry<String, List<FloatPasteInfo>> entry : pasteInfoMap.entrySet()) {
                        List<FloatPasteInfo> value = entry.getValue();
                        this.validEntryData(value, totalCheckResult, this.getModelCacheHelper());
                    }
                    if (totalCheckResult.size() > 0) {
                        String message = PasteCheckUtils.getInstance().buildMessage(totalCheckResult);
                        if (StringUtils.isNotEmpty((String)message)) {
                            this.getView().showMessage("", message, MessageTypes.Default);
                            return;
                        }
                    } else {
                        this.getPageCache().remove("validEntryResult");
                    }
                    String pasteInfos = this.checkAddNewDimnums();
                    if (pasteInfos != null) {
                        this.getView().returnDataToParent((Object)pasteInfos);
                        this.getPageCache().put("closed", "true");
                        this.getView().close();
                    }
                    break;
                }
                case "btn_cancel": {
                    this.getView().close();
                    break;
                }
                case "selectexist": {
                    String currentIndexRow = this.getPageCache().get("currentIndexRow");
                    if (currentIndexRow != null) {
                        int row = Integer.parseInt(currentIndexRow);
                        if (row < 0 || this.getPasteInfos() == null || row >= this.getPasteInfos().size()) {
                            return;
                        }
                        FloatPasteInfo floatPasteInfo = this.getPasteInfos().get(row);
                        if (floatPasteInfo.getDeal() == 2) {
                            Point point = ExcelUtils.pos2Point((String)floatPasteInfo.getPosition());
                            AreaInfo areaInfo = this.getEbSpreadManager().getAreaInfoByRowCol(point.y, point.x);
                            this.getView().getPageCache().put("pasteValue", floatPasteInfo.getPasteValue());
                            this.getView().getPageCache().put("selectedId", floatPasteInfo.getSelectedId() == null ? null : floatPasteInfo.getSelectedId() + "");
                            this.getFixReportProcess().openF7Form(areaInfo, false, this.getView());
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + key);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            CommonServiceHelper.dealException((IFormView)this.getView(), (String)"FloatPasteCheckPlugin.click", (Throwable)e);
        }
    }

    @Override
    public Long getModelId() {
        if (this.modelId == null) {
            this.modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
        }
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    private String checkAddNewDimnums() {
        Map<String, List<FloatPasteInfo>> pasteInfoMap = this.getPasteInfoMap(true);
        LinkedHashMap<String, List> needToSaveDataMap = new LinkedHashMap<String, List>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Iterator<Map.Entry<String, List<FloatPasteInfo>>> iterator = pasteInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<FloatPasteInfo>> next = iterator.next();
            List list = (List)next.getValue();
            list.removeIf(floatPasteInfo -> 3 == floatPasteInfo.getDeal());
            if (CollectionUtils.isEmpty((Collection)list)) {
                iterator.remove();
            }
            for (FloatPasteInfo pasteInfo : list) {
                if (1 != pasteInfo.getDeal()) continue;
                List list2 = needToSaveDataMap.computeIfAbsent((String)next.getKey(), v -> new ArrayList(10));
                list2.add(pasteInfo);
            }
        }
        for (Map.Entry entry : needToSaveDataMap.entrySet()) {
            try {
                Boolean checkPass = PasteCheckUtils.getInstance().newDimMember((List)entry.getValue(), modelCacheHelper, this.getView(), (IFormPlugin)this);
                if (checkPass == null) {
                    return null;
                }
                if (!checkPass.booleanValue()) continue;
                PasteCheckUtils.getInstance().insertAttribute((List)entry.getValue(), modelCacheHelper.getModelobj().getId());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        ArrayList<FloatPasteInfo> floatPasteInfos = new ArrayList<FloatPasteInfo>(10);
        for (List<FloatPasteInfo> value : pasteInfoMap.values()) {
            floatPasteInfos.addAll(value);
        }
        return ObjectSerialUtil.toByteSerialized(floatPasteInfos);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getPageCache().put("currentIndexRow", String.valueOf(row));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int entryrow = e.getChangeSet()[0].getRowIndex();
        String valueStr = String.valueOf(newValue);
        FloatPasteInfo floatPasteInfo = this.getPasteInfos().get(entryrow);
        if (floatPasteInfo == null) {
            return;
        }
        if ("deal".equals(key)) {
            this.getPageCache().remove("checkresult");
            int deal = Integer.parseInt(valueStr);
            this.clearAttributeValue(entryrow);
            this.getView().setEnable(Boolean.valueOf(2 == deal), entryrow, new String[]{"selectexist"});
            floatPasteInfo.setDeal(deal);
            if (2 != deal) {
                floatPasteInfo.setNumber(null);
                floatPasteInfo.setSelectedId(null);
                this.getModel().setValue("selectexist", (Object)"", entryrow);
            }
            this.cachePasteInfos(floatPasteInfo, entryrow);
            this.refreshEnable(this.getPasteInfos());
        } else if ("selectexist".equals(key)) {
            if (newValue == null || StringUtils.isEmpty((String)valueStr)) {
                floatPasteInfo.setNumber(null);
                floatPasteInfo.setSelectedId(null);
                this.clearAttributeValue(entryrow);
                this.cachePasteInfos(floatPasteInfo, entryrow);
            }
        } else if (StringUtils.isNotEmpty((String)key) && key.startsWith(ATTRIBUTE)) {
            String index = key.substring(ATTRIBUTE.length());
            List dimPropertys = floatPasteInfo.getDimPropertys() == null ? new ArrayList(10) : floatPasteInfo.getDimPropertys();
            PropertyObj propertyObj = (PropertyObj)dimPropertys.get(Integer.parseInt(index) - 1);
            List propertyValueEntries = propertyObj.getPropertyValueEntries();
            propertyValueEntries.clear();
            if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)valueStr))) {
                propertyValueEntries.add(new PropertyMemObj(IDUtils.toLong((Object)valueStr), "", "", 10));
            }
            this.cachePasteInfos(floatPasteInfo, entryrow);
        }
    }

    private void clearAttributeValue(int entryrow) {
        String attributeKey = this.getPageCache().get(CACHHE_ATTRIBUTE);
        if (StringUtils.isNotEmpty((String)attributeKey)) {
            String[] split;
            for (String itemKey : split = attributeKey.split(",")) {
                this.getModel().setValue(itemKey, null, entryrow);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("cellF7".equals(key)) {
            Object returndata = closedCallBackEvent.getReturnData();
            if (returndata == null) {
                return;
            }
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returndata;
            if (rows.size() == 0) {
                return;
            }
            int entryrow = Integer.parseInt(String.valueOf(this.getEntryGrid().getEntryState().get("row")));
            FloatPasteInfo floatPasteInfo = this.getPasteInfos().get(entryrow);
            Long id = Long.valueOf(rows.get(0).getPrimaryKeyValue() + "");
            Member member = this.getModelCacheHelper().getMember(floatPasteInfo.getDimNumber(), floatPasteInfo.getViewId(), id);
            if (member == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6210\u5458\u5728\u5bf9\u5e94\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"FloatPasteCheckPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            floatPasteInfo.setSelectedId(id);
            floatPasteInfo.setNumber(member.getNumber());
            this.setAttributeDefaultValue(member, entryrow, floatPasteInfo);
            this.getModel().setValue("selectexist", (Object)(member.getName() + " " + member.getNumber()), entryrow);
            this.cachePasteInfos(floatPasteInfo, entryrow);
            this.refreshEnable(this.getPasteInfos());
        }
    }

    private IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelid);
        }
        return this.modelCacheHelper;
    }

    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    private List<FloatPasteInfo> getPasteInfos() {
        return this.getPasteInfoMap(true).get(this.getCurrentTabKey());
    }

    private String getCurrentTabKey() {
        return this.getPageCache().get("currentTabKey") == null ? "" : this.getPageCache().get("currentTabKey");
    }

    private Map<String, List<FloatPasteInfo>> getPasteInfoMap(boolean throwException) {
        String info = this.getPageCache().get("floatPasteInfoMap");
        if (StringUtils.isNotEmpty((String)info)) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)info);
        }
        info = (String)this.getView().getFormShowParameter().getCustomParam("floatPasteInfoMap");
        if (StringUtils.isEmpty((String)info)) {
            if (throwException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u53c2\u5931\u8d25\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\uff0c\u5e76\u91cd\u65b0\u586b\u5145\u6d6e\u52a8\u533a\u57df\u3002", (String)"FloatPasteCheckPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return Maps.newHashMap();
        }
        Map pasteMap = (Map)ObjectSerialUtil.deSerializedBytes((String)info);
        LinkedHashMap<String, List<FloatPasteInfo>> floatPasteInfoMap = new LinkedHashMap<String, List<FloatPasteInfo>>(pasteMap.size());
        for (Map.Entry entry : pasteMap.entrySet()) {
            String key = (String)entry.getKey();
            floatPasteInfoMap.put(key.toLowerCase(Locale.ROOT), (List<FloatPasteInfo>)entry.getValue());
        }
        this.getPageCache().put("floatPasteInfoMap", ObjectSerialUtil.toByteSerialized(floatPasteInfoMap));
        return floatPasteInfoMap;
    }

    private void cachePasteInfos(FloatPasteInfo floatPasteInfo, int index) {
        FloatPasteInfo sourceInfo;
        Map<String, List<FloatPasteInfo>> pasteInfoMap = this.getPasteInfoMap(true);
        List<FloatPasteInfo> list = pasteInfoMap.get(this.getCurrentTabKey());
        if (CollectionUtils.isNotEmpty(list) && index < list.size() && (sourceInfo = list.get(index)) != null && floatPasteInfo != null) {
            list.set(index, floatPasteInfo);
        }
        this.getPageCache().put("floatPasteInfoMap", ObjectSerialUtil.toByteSerialized(pasteInfoMap));
    }

    private IEbSpreadManager getEbSpreadManager() {
        if (this.ebSpreadManager != null) {
            return this.ebSpreadManager;
        }
        FixReportProcess fixReportProcess = this.getFixReportProcess();
        if (!fixReportProcess.getReportVersion().equals(this.getView().getFormShowParameter().getCustomParam("reportVersion"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7236\u9875\u9762\u5df2\u7ecf\u5207\u6362\u8fc7\u62a5\u8868\uff0c\u6216\u8005\u5237\u65b0\u8fc7\u62a5\u8868\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\u5e76\u91cd\u65b0\u586b\u5145\u6d6e\u52a8\u533a\u57df\u3002", (String)"FloatPasteCheckPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.ebSpreadManager = fixReportProcess.getSpreadManager();
        return this.ebSpreadManager;
    }

    private FixReportProcess getFixReportProcess() {
        IFormView parentview = this.getView().getParentView();
        if (parentview == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\uff0c\u5e76\u91cd\u65b0\u586b\u5145\u6d6e\u52a8\u533a\u57df\u3002", (String)"FloatPasteCheckPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FixReportProcess fixReportProcess = new FixReportProcess();
        new PluginInitHelper(parentview).initView((Object)fixReportProcess);
        return fixReportProcess;
    }

    private EntryGrid getEntryGrid() {
        return (EntryGrid)this.getControl("entryentity");
    }
}

