/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.reportview;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgTaskConstant;
import kd.epm.eb.common.entity.memberF7.SingleTreeF7Parameter;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberF7.ParameterF7Builder;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.PluginInitHelper;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.formplugin.spreadplugin.AbstractTemplateBasePlugin;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.headerarea.HeaderInfo;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import org.apache.commons.collections4.MapUtils;

public class ReportAnalysisPlugin
extends AbstractTemplateBasePlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
EbMembPerm {
    private static final String TREEVIEW = "treeviewap";
    private DynamicReportProcess dynamicReportProcess = null;
    private String FOCUSNODEID = "FOCUSNODEID";
    private Log log = LogFactory.getLog(ReportAnalysisPlugin.class);
    private static final String TOOLBARAP = "toolbarap";

    public void initialize() {
        super.initialize();
        if (this.dynamicReportProcess == null) {
            this.dynamicReportProcess = new DynamicReportProcess();
            new PluginInitHelper(this.getView()).initView((Object)this.dynamicReportProcess);
            this.dynamicReportProcess.initialize();
            this.dynamicReportProcess.setTaskProcessId(IDUtils.toLong((Object)this.getCustomFormParam("current_processid")));
            this.dynamicReportProcess.setProcessId(IDUtils.toLong((Object)this.getCustomFormParam("processId")));
            this.dynamicReportProcess.setProcessType((String)this.getCustomFormParam("processType"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        if (treeView != null) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        for (String key : BgTaskConstant.getInstance().getF7Keys()) {
            BasedataEdit basedataEdit_eb = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit_eb == null) continue;
            basedataEdit_eb.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.initTree();
        try {
            Object reportOrTaskPojoJsonStringObject;
            Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
            if (MapUtils.isNotEmpty((Map)customParamMap) && (reportOrTaskPojoJsonStringObject = customParamMap.get(ReportOrTaskPojo.class.getName())) instanceof String) {
                CacheUtils.put((IPageCache)this.getPageCache(), (String)ReportOrTaskPojo.class.getName(), (Object)((String)reportOrTaskPojoJsonStringObject));
            }
            this.refreshSpread(null);
            SpreadContainer spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
            spreadContainer.addContextMenuItems("viewComputeProcess", ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b", (String)"BgTaskExecutePlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        }
        catch (KDException ex) {
            this.log.error((Throwable)ex);
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_hideemptyrows": {
                this.hideShowEmptyRows(false);
                this.getPageCache().put("isEmptyrowsVisible", "false");
                break;
            }
            case "btn_showemptyrows": {
                this.hideShowEmptyRows(true);
                this.getPageCache().put("isEmptyrowsVisible", "true");
            }
        }
    }

    public void hideShowEmptyRows(boolean isVisible) {
        this.hideShowEmptyRowCols(true, isVisible);
    }

    public void hideShowEmptyRowCols(boolean isRow, boolean isVisible) {
        IEbSpreadManager spreadManager = this.getSpreadManager();
        HashSet<Integer> indexs = new HashSet<Integer>(16);
        HashSet<Integer> indexsWithData = new HashSet<Integer>(16);
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        if (sheet != null) {
            List table = sheet.getTable();
            List cells = null;
            int rStart = sheet.getValueAreaRowStart();
            int rEnd = sheet.getRealMaxRows();
            int cStart = sheet.getValueAreaColStart();
            int cEnd = sheet.getRealMaxCols();
            if (isRow) {
                block0: for (int i = rStart; i < rEnd; ++i) {
                    indexs.add(i);
                    for (int j = cStart; j < cEnd; ++j) {
                        cells = (List)table.get(i);
                        if (cells == null || cells.get(j) == null || ((ECell)cells.get(j)).getValue() == null) continue;
                        indexsWithData.add(i);
                        continue block0;
                    }
                }
            } else {
                block2: for (int i = cStart; i < cEnd; ++i) {
                    indexs.add(i);
                    for (int j = rStart; j < rEnd; ++j) {
                        cells = (List)table.get(j);
                        if (cells == null || cells.get(i) == null || ((ECell)cells.get(i)).getValue() == null) continue;
                        indexsWithData.add(i);
                        continue block2;
                    }
                }
            }
            indexs.removeAll(indexsWithData);
            if (isRow) {
                this.getspreadContainer().setRowsVisible((List)Lists.newArrayList(indexs), isVisible);
            } else {
                this.getspreadContainer().setColumnsVisible((List)Lists.newArrayList(indexs), isVisible);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String isEmptyrowsVisible = this.getPageCache().get("isEmptyrowsVisible");
        if ("0L".equals(evt.getNodeId())) {
            return;
        }
        this.cacheNodeId(String.valueOf(evt.getNodeId()));
        this.refreshSpread(null);
        if ("false".equals(isEmptyrowsVisible)) {
            this.hideShowEmptyRows(false);
            this.getPageCache().put("isEmptyrowsVisible", "false");
        } else if ("true".equals(isEmptyrowsVisible)) {
            this.hideShowEmptyRows(true);
            this.getPageCache().put("isEmptyrowsVisible", "true");
        }
    }

    private void refreshSpread(String focusmember) {
        String dimnumber = this.getFocusNodeId();
        this.initDefaultDimNumber();
        this.initTemplateModel(dimnumber, focusmember);
        this.dynamicReportProcess.setDrillthrough_key(dimnumber);
        this.dynamicReportProcess.setMockCreateNewData(false);
        this.dynamicReportProcess.setTaskProcessId(IDUtils.toLong((Object)this.getCustomFormParam("current_processid")));
        this.dynamicReportProcess.setProcessId(IDUtils.toLong((Object)this.getCustomFormParam("processId")));
        this.dynamicReportProcess.setProcessType((String)this.getCustomFormParam("processType"));
        this.dynamicReportProcess.afterCreateNewData(null);
        this.dynamicReportProcess.doubleClickLockedCell(0, 0);
    }

    private void initDefaultDimNumber() {
        Map defaultmember;
        HashMap<String, Long> defaultDimMember = new HashMap<String, Long>(16);
        String f7serial = this.getPageCache().get("f7_mapping_cache");
        if (f7serial == null) {
            f7serial = (String)this.getView().getFormShowParameter().getCustomParam("f7_mapping_key");
        }
        Map dim_f7Key = new HashMap(16);
        if (StringUtils.isNotEmpty((String)f7serial)) {
            dim_f7Key = (Map)ObjectSerialUtil.deSerializedBytes((String)f7serial);
        }
        if ((defaultmember = (Map)this.getView().getFormShowParameter().getCustomParam("defaultmember")) != null) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getTemplateModel().getModelId());
            defaultmember.forEach((K, V) -> {
                Member member = modelCacheHelper.getMember(K, (Long)this.getTemplateModel().getDimemsionViews().get(K), V);
                if (member != null) {
                    defaultDimMember.put((String)K, member.getId());
                }
            });
        }
        for (Map.Entry dim_entry : dim_f7Key.entrySet()) {
            IFormView parentview;
            String f7key = (String)dim_entry.getKey();
            String f7_dimnumber = (String)dim_entry.getValue();
            Object value = this.getModel().getValue(f7key);
            if (value == null && (parentview = this.getView().getParentView()) != null) {
                value = this.getView().getParentView().getModel().getValue(f7key);
            }
            if (value == null) continue;
            DynamicObject f7_obj = (DynamicObject)value;
            defaultDimMember.put(f7_dimnumber, (Long)f7_obj.get("id"));
        }
        this.dynamicReportProcess.setDefaultDimMember(defaultDimMember);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        if ("0L".equals(evt.getNodeId())) {
            return;
        }
        this.cacheNodeId(String.valueOf(evt.getNodeId()));
        this.refreshSpread(null);
    }

    public String getSpreadKey() {
        return "report";
    }

    private void initTree() {
        ITemplateModel templateModel = this.getTemplateModel();
        TreeNode root = new TreeNode(null, "0L", ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"ReportAnalysisPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        for (IPageDimensionEntry iPageDimensionEntry : templateModel.getPagemembentry()) {
            IDimension dimension = iPageDimensionEntry.getDimension();
            root.addChild(new TreeNode("0L", dimension.getNumber(), dimension.getName()));
        }
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addNode(root);
        treeView.focusNode((TreeNode)root.getChildren().get(0));
        this.cacheNodeId(((TreeNode)root.getChildren().get(0)).getId());
    }

    private void initTemplateModel(String dimnumber, String focusDimMemNumber) {
        ITemplateModel templateModel = this.getTemplateModel();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
        if (templateModel.getPartitionSetting().getRowPartition().size() > 0) {
            ((RowColPartition)templateModel.getPartitionSetting().getRowPartition().get(0)).getRowColDimensionEntries().clear();
        }
        Member member = null;
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)focusDimMemNumber)) {
            if (this.dynamicReportProcess != null && this.dynamicReportProcess.getDefaultDimMember() != null && this.dynamicReportProcess.getDefaultDimMember().containsKey(dimnumber)) {
                member = modelCacheHelper.getMember(dimnumber, (Long)templateModel.getDimemsionViews().get(dimnumber), this.dynamicReportProcess.getDefaultDimMember().get(dimnumber));
                String string = focusDimMemNumber = member != null ? member.getNumber() : null;
            }
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)focusDimMemNumber)) {
                EbSpreadManager ebSpreadManager = new EbSpreadManager();
                ebSpreadManager.initModelObj(templateModel);
                Map pagescope = ebSpreadManager.resolvePageMemberScope(templateModel);
                focusDimMemNumber = ((Member)((Set)pagescope.get(dimnumber)).iterator().next()).getNumber();
            }
        }
        member = modelCacheHelper.getMember(dimnumber, (Long)templateModel.getDimemsionViews().get(dimnumber), focusDimMemNumber);
        List childs = modelCacheHelper.getChildren(member, true);
        RowColPartition rowpartion = null;
        if (templateModel.getPartitionSetting().getRowPartition().size() > 0) {
            rowpartion = (RowColPartition)templateModel.getPartitionSetting().getRowPartition().get(0);
        }
        if (rowpartion == null) {
            rowpartion = new RowColPartition();
        }
        DefaultRowColDimensionEntry colDimensionEntry = new DefaultRowColDimensionEntry();
        DefaultDimension dimension = new DefaultDimension();
        dimension.setNumber(dimnumber);
        dimension.setName(modelCacheHelper.getDimension(dimnumber).getName());
        colDimensionEntry.setDimension((IDimension)dimension);
        for (Member child : childs) {
            DefaultDimMember dimensionMember = new DefaultDimMember();
            dimensionMember.setScope(10);
            dimensionMember.setName(child.getName());
            dimensionMember.setNumber(child.getNumber());
            colDimensionEntry.addOneMember((IDimensionMember)dimensionMember);
        }
        rowpartion.setRowColDimensionEntries((List)Lists.newArrayList((Object[])new IRowColDimensionEntry[]{colDimensionEntry}));
        templateModel.getPartitionSetting().setRowPartition((List)Lists.newArrayList((Object[])new RowColPartition[]{rowpartion}));
        this.refreshTemplateAreaRangeEntry(templateModel);
        if (this.dynamicReportProcess != null) {
            this.dynamicReportProcess.setTemplateModel(templateModel);
        }
        this.setTemplateModel(templateModel);
    }

    private void refreshTemplateAreaRangeEntry(ITemplateModel templateModel) {
        List colPartition;
        List rowPartition = templateModel.getPartitionSetting().getRowPartition();
        if (rowPartition != null && rowPartition.size() > 0) {
            ArrayList<IDimension> dimensions = new ArrayList<IDimension>(16);
            ArrayList<HeaderInfo> headerInfos = new ArrayList<HeaderInfo>(16);
            for (IRowColDimensionEntry entry : ((RowColPartition)rowPartition.get(0)).getRowColDimensionEntries()) {
                IDimension dimension = entry.getDimension();
                dimensions.add(dimension);
                headerInfos.add(new HeaderInfo("Dimension", dimension.getNumber()));
            }
            templateModel.getAreaRangeEntry().setRowdimensions(dimensions);
            templateModel.getAreaRangeEntry().setRowHeaders(headerInfos);
        }
        if ((colPartition = templateModel.getPartitionSetting().getColPartition()) != null && colPartition.size() > 0) {
            ArrayList<IDimension> dimensions = new ArrayList<IDimension>(16);
            ArrayList<HeaderInfo> headerInfos = new ArrayList<HeaderInfo>(16);
            for (IRowColDimensionEntry entry : ((RowColPartition)colPartition.get(0)).getRowColDimensionEntries()) {
                IDimension dimension = entry.getDimension();
                dimensions.add(dimension);
                headerInfos.add(new HeaderInfo("Dimension", dimension.getNumber()));
            }
            templateModel.getAreaRangeEntry().setColdimensions(dimensions);
            templateModel.getAreaRangeEntry().setColHeaders(headerInfos);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String dimnumber;
        String isEmptyrowsVisible = this.getPageCache().get("isEmptyrowsVisible");
        String key = e.getProperty().getName();
        String f7serial = this.getPageCache().get("f7_mapping_cache");
        HashMap dim_f7Key = (HashMap)ObjectSerialUtil.deSerializedBytes((String)f7serial);
        if (dim_f7Key == null) {
            dim_f7Key = new HashMap(16);
        }
        if ((dimnumber = this.getFocusNodeId()).equals(dim_f7Key.get(key))) {
            DynamicObject oldValueObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (e.getChangeSet()[0].getNewValue() == null) {
                this.getModel().setValue(key, (Object)oldValueObj.getLong("id"));
                return;
            }
            if (e.getChangeSet()[0].getOldValue() == null || e.getChangeSet()[0].getNewValue().equals(e.getChangeSet()[0].getOldValue())) {
                return;
            }
            this.refreshSpread(((DynamicObject)e.getChangeSet()[0].getNewValue()).getString("number"));
        } else {
            this.dynamicReportProcess.propertyChanged(e);
        }
        this.hideShowEmptyRows(false);
        if ("false".equals(isEmptyrowsVisible)) {
            this.hideShowEmptyRows(false);
            this.getPageCache().put("isEmptyrowsVisible", "false");
        } else if ("true".equals(isEmptyrowsVisible)) {
            this.hideShowEmptyRows(true);
            this.getPageCache().put("isEmptyrowsVisible", "true");
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    private void cacheNodeId(String nodeid) {
        this.getPageCache().put(this.FOCUSNODEID, nodeid);
    }

    private String getFocusNodeId() {
        return this.getPageCache().get(this.FOCUSNODEID);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ParameterF7Builder builder = new ParameterF7Builder("single");
        String key = e.getProperty().getName();
        BgTemplate templateBaseInfo = this.getTemplateModel().getTemplateBaseInfo();
        Long bizModel = templateBaseInfo.getBizModel();
        if (bizModel != null) {
            if ("Account".equals(this.getCurrentDimNumber(key))) {
                builder.setDataSetIds(Collections.singletonList(templateBaseInfo.getDatasetID()));
            }
            builder.setOpenAnalyseView(false).setDefauteViewid((Long)this.getTemplateModel().getDimemsionViews().get(this.getCurrentDimNumber(key))).setForceDisableView(true);
            this.switchSingleTreeF7(e, bizModel, (SingleTreeF7Parameter)builder.build());
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        return BgTaskExecuteHelper.getDimNumberFromF7Key(this.getView(), controlKey);
    }

    public Long getModelId() {
        return this.getTemplateModel().getModelId();
    }
}

