/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.reportview;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.enums.AttachementTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportAttachmentPlugin
extends AbstractFormPlugin {
    private static String ATTACHMENT_COUNT = "attachmentcount";

    public void initialize() {
        super.initialize();
        this.setControlTilte();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValues();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        Long reportprocess = this.getReportProcessId();
        Long approveBillId = ApproveBillHelper.getAppBillIdFromPage((IFormView)this.getView());
        Long modelId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_reportprocess", (String)"model", (String)"id", (Object[])new Object[]{reportprocess});
        String status = ApproveBillQuery.getInstance().getProcessStatusStr(reportprocess, approveBillId);
        Boolean readonly = (Boolean)fromShowParams.getCustomParam("readonly");
        if (StringUtils.equals((CharSequence)status, (CharSequence)BgTaskStateEnum.UNDERWAY.getNumber()) || StringUtils.equals((CharSequence)status, (CharSequence)BgTaskStateEnum.COMPLETED.getNumber()) || Boolean.TRUE.equals(readonly)) {
            if (StringUtils.equals((CharSequence)status, (CharSequence)BgTaskStateEnum.UNDERWAY.getNumber()) && ApproveAdjustUtils.getInstance().approveAdjust(modelId, reportprocess, this.getView(), approveBillId)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"conentpanel"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"conentpanel"});
            }
        }
        this.getModel().setDataChanged(false);
        this.getPageCache().put(ATTACHMENT_COUNT, String.valueOf(this.getModel().getValue("attachmentcount")));
    }

    private void initValues() {
        IDataModel model = this.getModel();
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        Long modelId = IDUtils.toLong((Object)fromShowParams.getCustomParam("modelId"));
        Long templateId = IDUtils.toLong((Object)fromShowParams.getCustomParam("templateId"));
        String arearange = (String)fromShowParams.getCustomParam("arearange");
        String memberskey = (String)fromShowParams.getCustomParam("memberskey");
        String type = (String)fromShowParams.getCustomParam("type");
        if (fromShowParams.getStatus() == OperationStatus.ADDNEW) {
            String numberStr = String.format("%s_%s", this.getReportProcessId(), arearange);
            model.setValue("number", (Object)numberStr);
            model.setValue("name", (Object)numberStr);
            model.setValue("type", (Object)type);
            model.setValue("modelid_id", (Object)modelId);
            model.setValue("templateId_id", (Object)templateId);
            model.setValue("reportprocess", (Object)this.getReportProcessId());
            model.setValue("arearange", (Object)arearange);
            model.setValue("memberskey", (Object)memberskey);
            model.setValue("creator_id", (Object)UserUtils.getUserId());
            model.setValue("createtime", (Object)TimeServiceHelper.now());
        }
    }

    private Long getReportProcessId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("reportprocess"));
    }

    private void setControlTilte() {
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        String type = (String)fromShowParams.getCustomParam("type");
        String caption = ResManager.loadKDString((String)"\u9644\u6ce8\uff1a", (String)"ReportAttachmentPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (AttachementTypeEnum.CELL.getValue().equals(type)) {
            caption = ResManager.loadResFormat((String)"\u5355\u5143\u683c%1", (String)"ReportAttachmentPlugin_1_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{caption});
        } else if (AttachementTypeEnum.TEMPLATE.getValue().equals(type)) {
            caption = ResManager.loadResFormat((String)"\u62a5\u8868%1", (String)"ReportAttachmentPlugin_2_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{caption});
        }
        LocaleString captionLocal = new LocaleString();
        captionLocal.put(Lang.defaultLang().toString(), (Object)caption);
        TextEdit edit = (TextEdit)this.getView().getControl("remark");
        edit.setCaption(captionLocal);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("save")) {
            boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
            if (issuccess) {
                HashMap<String, Object> backData = new HashMap<String, Object>(16);
                String memberskey = (String)this.getView().getFormShowParameter().getCustomParam("memberskey");
                String arearange = (String)this.getView().getFormShowParameter().getCustomParam("arearange");
                Long reportprocess = this.getReportProcessId();
                String tagType = (String)this.getView().getFormShowParameter().getCustomParam("type");
                backData.put("memberskey", memberskey);
                backData.put("arearange", arearange);
                backData.put("reportprocess", reportprocess);
                backData.put("type", tagType);
                backData.put("remark", this.getModel().getValue("remark"));
                this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(backData));
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ReportAttachmentPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String attachmentCount = String.valueOf(this.getModel().getValue("attachmentcount"));
        String remark = this.getModel().getDataEntity().getString("remark");
        if (!attachmentCount.equals(this.getPageCache().get(ATTACHMENT_COUNT)) && attachmentCount.equals("0")) {
            Object id = this.getModel().getValue("id");
            DeleteServiceHelper.delete((String)"eb_reportattachment", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        } else if (!attachmentCount.equals(this.getPageCache().get(ATTACHMENT_COUNT))) {
            Object id = this.getModel().getValue("id");
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("update t_eb_reportattachment set fattachmentcount='" + attachmentCount + "' where fid=" + id));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("save")) {
            String remark = this.getModel().getDataEntity().getString("remark");
            int count = this.getModel().getDataEntity().getInt("attachmentcount");
            if (StringUtils.isEmpty((CharSequence)remark) && count == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u6ce8\u548c\u9644\u4ef6\u4fe1\u606f\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"ReportAttachmentPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            }
        }
    }
}

