/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.reportview.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimMembActionEnum;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.tree.Recorder;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.cube.dimension.entitys.DimManagerInfo;
import kd.epm.eb.formplugin.dimension.action.ActionFactory;
import kd.epm.eb.formplugin.dimension.action.IAction;
import kd.epm.eb.model.utils.DimMemberNumberUtil;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.spread.fix.FloatPasteInfo;
import org.apache.commons.collections.CollectionUtils;

public class PasteCheckUtils {
    private static final PasteCheckUtils instance = new PasteCheckUtils();

    public static PasteCheckUtils getInstance() {
        return instance;
    }

    public void mainSubModelCheck(Map<String, List<FloatPasteInfo>> pasteInfoMap, IModelCacheHelper modelCacheHelper) {
        if (pasteInfoMap != null && pasteInfoMap.size() != 0 && modelCacheHelper != null) {
            for (Map.Entry<String, List<FloatPasteInfo>> entry : pasteInfoMap.entrySet()) {
                List<FloatPasteInfo> value = entry.getValue();
                this.doMainSubModelCheck(modelCacheHelper, value);
            }
        }
    }

    public void doMainSubModelCheck(IModelCacheHelper modelCacheHelper, List<FloatPasteInfo> value) {
        if (CollectionUtils.isNotEmpty(value)) {
            boolean control;
            Long viewId;
            FloatPasteInfo pasteInfo = value.get(0);
            String parentNumber = pasteInfo.getParentNumber();
            String dimNumber = pasteInfo.getDimNumber();
            Member member = modelCacheHelper.getMember(dimNumber, viewId = pasteInfo.getViewId(), parentNumber);
            if (member != null && (control = BgmdMainSubControlHelper.getInstance().validateDimControl(modelCacheHelper.getModelobj().getId(), dimNumber, IDUtils.toLong((Object)member.getId())))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u4e3b\u4f53\u7cfb\u8bbe\u7f6e\u7ba1\u63a7\u7b56\u7565\u4e3a\u975e\u660e\u7ec6\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"MainSubModel_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public Map<String, Map<String, String>> getPropByMember(Set<Member> memberSet) {
        HashMap<String, Map<String, String>> memberProps = new HashMap<String, Map<String, String>>(16);
        if (CollectionUtils.isEmpty(memberSet)) {
            return memberProps;
        }
        Map<Long, String> idNumberMap = memberSet.stream().collect(Collectors.toMap(BaseCache::getId, BaseCache::getNumber, (v1, v2) -> v1));
        ArrayList<Long> memberIds = new ArrayList<Long>(idNumberMap.keySet());
        List maps = CustomPropertyUtils.queryAllPropertyValue(memberIds);
        HashSet<Long> propValueIdSet = new HashSet<Long>(16);
        HashMap<Long, Set> memberPropValueMap = new HashMap<Long, Set>(16);
        if (CollectionUtils.isNotEmpty((Collection)maps)) {
            for (Map map : maps) {
                Set propValueIds = memberPropValueMap.computeIfAbsent((Long)map.get("fid"), v -> new HashSet(16));
                propValueIds.add((Long)map.get("fpropertyvalueid"));
                propValueIdSet.add((Long)map.get("fpropertyvalueid"));
            }
        }
        Map customPropertyValue = CustomPropertyUtils.getCustomPropertyValue(propValueIdSet, null);
        Collection values = customPropertyValue.values();
        for (DynamicObject value : values) {
            for (Map.Entry entry : memberPropValueMap.entrySet()) {
                Set propValueIds = (Set)entry.getValue();
                if (!propValueIds.contains(value.getLong("id"))) continue;
                Long memberId = (Long)entry.getKey();
                String memberNumber = idNumberMap.get(memberId);
                Map propMap = memberProps.computeIfAbsent(memberNumber, v -> new HashMap(16));
                propMap.put(value.getString("property.number"), value.getString("number"));
            }
        }
        return memberProps;
    }

    public String buildMessage(Map<String, Map<String, Set<String>>> totalCheckResult) {
        if (totalCheckResult != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Map<String, Set<String>>> mapEntry : totalCheckResult.entrySet()) {
                String key = mapEntry.getKey();
                Map<String, Set<String>> value = mapEntry.getValue();
                if (value == null || value.size() == 0) continue;
                stringBuilder.append(ResManager.loadKDString((String)"\u9875\u7b7e\uff1a", (String)"", (String)"", (Object[])new Object[0])).append(key).append("\n");
                value.forEach((indexRow, errorSet) -> {
                    String join = String.join((CharSequence)"\uff1b", errorSet);
                    stringBuilder.append("          ").append((String)indexRow).append(join).append("\u3002").append("\n");
                });
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.substring(0, stringBuilder.length() - 1);
            }
        }
        return null;
    }

    public DynamicObjectCollection queryDimensionPropertyValue(Long propertyId, String selectFields) {
        QFilter qFilter = new QFilter("property", "=", (Object)propertyId);
        return QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"dseq asc");
    }

    public void setPropMemberObj(List<PropertyObj> propertyObjs, FloatPasteInfo floatPasteInfo) {
        if (floatPasteInfo == null || propertyObjs == null || propertyObjs.size() == 0) {
            return;
        }
        for (PropertyObj propertyObj : propertyObjs) {
            DynamicObjectCollection dynamicObjects = this.queryDimensionPropertyValue(propertyObj.getId(), "id,number,name,dseq");
            if (dynamicObjects.size() <= 0) continue;
            ArrayList<PropertyMemObj> propertyMemObjs = new ArrayList<PropertyMemObj>(dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                PropertyMemObj propertyMemObj = new PropertyMemObj(Long.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"), dynamicObject.getString("number"), 10);
                propertyMemObj.setDseq(dynamicObject.getInt("dseq"));
                propertyMemObjs.add(propertyMemObj);
            }
            propertyObj.setPropertyValueEntries(propertyMemObjs);
        }
    }

    public Boolean newDimMember(List<FloatPasteInfo> floatPasteInfos, IModelCacheHelper modelCacheHelper, IFormView formView, IFormPlugin formPlugin) {
        if (floatPasteInfos == null || floatPasteInfos.size() == 0) {
            return false;
        }
        Recorder maxnum = new Recorder((Object)0);
        this.getMaxDimMemNumber(floatPasteInfos, (Recorder<Integer>)maxnum, modelCacheHelper);
        ArrayList<DimensionViewMember> dimensionViewMembers = new ArrayList<DimensionViewMember>(10);
        FloatPasteInfo pasteInfo = floatPasteInfos.get(0);
        String parentNumber = pasteInfo.getParentNumber();
        Long viewId = pasteInfo.getViewId();
        String dimnumber = pasteInfo.getDimNumber();
        Member parentMember = modelCacheHelper.getMember(dimnumber, viewId, parentNumber);
        if (parentMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u65b0\u589e\u6210\u5458\u7684\u4e0a\u7ea7\u6210\u5458[%1]\u4e0d\u5b58\u5728\u3002", (String)"FloatPasteCheckPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{parentNumber}));
        }
        if (formView != null) {
            Long parentMemberId = parentMember.getId();
            if (parentMember instanceof ViewMember) {
                parentMemberId = ((ViewMember)parentMember).getVid();
            }
            DimManagerInfo dimInfo = ActionFactory.buildDim(modelCacheHelper.getModelobj().getId(), parentMember.getDimension().getId(), parentMemberId, viewId);
            IAction action = ActionFactory.getAction(DimMembActionEnum.ADDCHILD, formView, formPlugin, formView.getModel(), formView.getPageCache(), dimInfo);
            action.beforeAction();
            if (!action.isBeforeAction()) {
                return null;
            }
        }
        for (FloatPasteInfo floatPasteInfo : floatPasteInfos) {
            if (parentMember.isDisable()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u65b0\u589e\u6210\u5458\u7684\u4e0a\u7ea7-%1\u5df2\u7ecf\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u6210\u5458\u3002", (String)"FloatPasteCheckPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{parentMember.getNumber()}));
            }
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentMember.getId(), (String)"epm_userdefinedmembertree");
            String number = DimMemberNumberUtil.getCodeNumber((IModelCacheHelper)modelCacheHelper, (String)dimnumber, (DynamicObject)parent, (boolean)false);
            if (StringUtils.isEmpty((String)number)) {
                number = this.getNumberByShortNumber(parentMember.getDimension().getShortNumber(), (Recorder<Integer>)maxnum, parentMember.getDimension().getId(), dimnumber);
            } else {
                String msg = DimMemberNumberUtil.doCheck((String)number);
                if (msg != null) {
                    throw new KDBizException(msg);
                }
            }
            floatPasteInfo.setNumber(number);
            DimensionViewMember dimensionViewMember = new DimensionViewMember();
            dimensionViewMember.setName(floatPasteInfo.getPasteValue());
            dimensionViewMember.setNumber(number);
            dimensionViewMember.setShowNumber(number);
            dimensionViewMembers.add(dimensionViewMember);
        }
        ViewMemberManager.getInstance().insertViewMemberToRawView(modelCacheHelper.getModelobj().getId().longValue(), dimnumber, viewId, parentNumber, dimensionViewMembers);
        return true;
    }

    private void getMaxDimMemNumber(List<FloatPasteInfo> floatPasteInfos, Recorder<Integer> maxnum, IModelCacheHelper modelCacheHelper) {
        Dimension dimension = modelCacheHelper.getDimension(floatPasteInfos.get(0).getDimNumber());
        List members = dimension.getAllMembersByAllView();
        String shortnumber = ((Member)members.get(0)).getDimension().getShortNumber();
        int max = 0;
        for (Member member : members) {
            if (!member.getNumber().startsWith(shortnumber)) continue;
            String temp_maxnum = member.getNumber().substring(member.getDimension().getShortNumber().length());
            try {
                max = Math.max(max, Integer.parseInt(temp_maxnum));
            }
            catch (Exception exception) {}
        }
        maxnum.setRecord((Object)(++max));
    }

    public String getNumberByShortNumber(String shortnumber, Recorder<Integer> maxnum, Long dimid, String dimnumber) {
        int record;
        StringBuilder ss = new StringBuilder(String.valueOf(maxnum.getRecord()));
        for (int begin = ss.length(); begin < 6; ++begin) {
            ss.insert(0, "0");
        }
        String number = shortnumber + ss;
        while (this.checkNumberExist(dimid, dimnumber, number)) {
            record = (Integer)maxnum.getRecord();
            maxnum.setRecord((Object)(++record));
            ss = new StringBuilder(String.valueOf(maxnum.getRecord()));
            for (int begin = ss.length(); begin < 6; ++begin) {
                ss.insert(0, "0");
            }
            number = shortnumber + ss;
        }
        record = (Integer)maxnum.getRecord();
        maxnum.setRecord((Object)(++record));
        return number;
    }

    public boolean checkNumberExist(Long dimid, String dimnumber, String number) {
        String memtree = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
        QFilter qFilter01 = new QFilter("dimension", "=", (Object)dimid);
        QFilter qFilter02 = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)memtree, (QFilter[])new QFilter[]{qFilter01, qFilter02});
    }

    public void insertAttribute(List<FloatPasteInfo> value, Long modelId) {
        if (value != null) {
            FloatPasteInfo floatPasteInfo = value.get(0);
            String dimNumber = floatPasteInfo.getDimNumber();
            Long viewId = floatPasteInfo.getViewId();
            List numbers = value.stream().map(FloatPasteInfo::getNumber).collect(Collectors.toList());
            List dynamicObjects = ViewMemberManager.getInstance().queryViewMemberByNumber(modelId.longValue(), dimNumber, viewId, numbers, "id,memberid,number,shownumber,name");
            Map<String, Long> numberIdMap = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getLong("memberid"), (v1, v2) -> v1));
            ArrayList<Object[]> paramsUserList = new ArrayList<Object[]>();
            for (int i = 0; i < value.size(); ++i) {
                FloatPasteInfo pasteInfo = value.get(i);
                List dimPropertys = pasteInfo.getDimPropertys();
                if (CollectionUtils.isEmpty((Collection)dimPropertys)) continue;
                for (PropertyObj dimProperty : dimPropertys) {
                    List propertyValueEntries = dimProperty.getPropertyValueEntries();
                    int seq = 1;
                    for (PropertyMemObj propertyValueEntry : propertyValueEntries) {
                        if (!IDUtils.isNotNull((Long)propertyValueEntry.getId())) continue;
                        Object[] objects = new Object[]{numberIdMap.get(pasteInfo.getNumber()), propertyValueEntry.getId(), seq, GlobalIdUtil.genGlobalLongId()};
                        ++seq;
                        paramsUserList.add(objects);
                    }
                }
            }
            String sql = "INSERT into t_eb_memberpropertyvalue(fid,fpropertyvalueid,fseq,fentryid)  values (?,?,?,?)";
            if (CollectionUtils.isNotEmpty(paramsUserList)) {
                DB.executeBatch((DBRoute)new DBRoute("epm"), (String)sql, paramsUserList);
            }
        }
    }
}

