/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.submission.controller;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.report.submission.vo.ReportSubmitRangeViewParam;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportSubmitRangeController {
    private static final ReportSubmitRangeController instance = new ReportSubmitRangeController();
    public static final Set<String> RPTFILTERSTATUS = Sets.newHashSet((Object[])new String[]{BgTaskStateEnum.UNPREPARED.getNumber(), BgTaskStateEnum.TEMPSAVE.getNumber(), BgTaskStateEnum.INCOMPLETE.getNumber()});
    public static final String BTN_ORGCOMMIT_CANCEL = "btn_orgcommit_cancel";
    public static final String BTN_ORGCOMMIT_OK = "btn_orgcommit_ok";
    public static final String SUBMITRANGECALLBACKID = "submitRangeCallBackId";

    private ReportSubmitRangeController() {
    }

    public static ReportSubmitRangeController getInstance() {
        return instance;
    }

    public void setVisible(IFormView formView) {
        if (formView == null) {
            return;
        }
        formView.setVisible(Boolean.valueOf(false), new String[]{BTN_ORGCOMMIT_CANCEL, BTN_ORGCOMMIT_OK});
    }

    public void openSubmitRangeView(AbstractListPlugin formPlugin, IFormView formView, ReportSubmitRangeViewParam reportSubmitRangeViewParam) {
        if (formView == null || reportSubmitRangeViewParam == null) {
            return;
        }
        if (!this.checkSubmitRptEnable(formView, reportSubmitRangeViewParam)) {
            return;
        }
        Long entityViewId = reportSubmitRangeViewParam.getEntityViewId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)reportSubmitRangeViewParam.getModelId());
        Set<Long> submitEntityIds = reportSubmitRangeViewParam.getSubmitEntityIds();
        if (ReportSubmitRangeController.getInstance().checkSubmitEntityHasInclude(submitEntityIds, entityViewId, modelCacheHelper)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u53ea\u5141\u8bb8\u9009\u62e9\u6ca1\u6709\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u7684\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u63d0\u4ea4\u8303\u56f4\u3002", (String)"ReportSubmitRangeController_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        Map<Long, Set<Long>> selectEntityReportProcessMap = reportSubmitRangeViewParam.getSelectEntityReportProcessMap();
        if (MapUtils.isNotEmpty(selectEntityReportProcessMap)) {
            HashSet reportProcessIds = new HashSet(16);
            for (Map.Entry<Long, Set<Long>> entry : selectEntityReportProcessMap.entrySet()) {
                reportProcessIds.addAll(entry.getValue());
            }
            OperationResult operationResult = new OperationResult();
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,status,entity.name,template.name", (QFilter[])new QFilter("id", "in", reportProcessIds).toArray());
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!BgTaskStateEnum.COMPLETED.getNumber().equals(dynamicObject.getString("status")) && !BgTaskStateEnum.UNDERWAY.getNumber().equals(dynamicObject.getString("status"))) continue;
                String message = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u201c%1\u201d\u7684\u62a5\u8868\u201c%2\u201d\u5df2\u63d0\u4ea4\u6216\u5df2\u5b8c\u6210\uff0c\u4e0d\u9700\u8981\u63d0\u4ea4\u3002", (String)"ReportSubmitRangeController_003", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("entity.name"), dynamicObject.getString("template.name")});
                ApproveBillCommon.addErrIntoResult((String)"", (String)message, (OperationResult)operationResult);
            }
            if (CollectionUtils.isNotEmpty((Collection)operationResult.getAllErrorInfo())) {
                formView.showOperationResult(operationResult);
                return;
            }
        } else {
            formShowParameter.setCustomParam("orgCommitCheck", (Object)"true");
        }
        formShowParameter.setFormId("bgm_reportsubmitrange");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, SUBMITRANGECALLBACKID));
        formShowParameter.setCustomParam("params", (Object)SerializationUtils.serializeToBase64((Object)reportSubmitRangeViewParam));
        formView.showForm(formShowParameter);
    }

    public boolean checkSubmitRptEnable(IFormView formView, ReportSubmitRangeViewParam reportSubmitRangeViewParam) {
        String taskNotEnableNames;
        if (reportSubmitRangeViewParam.getReportSubmitEnterEnum() == ProcessTypeEnum.REPORT) {
            if (ReportHelper.isRptSchemeClosed((Long)reportSubmitRangeViewParam.getSchemeAssignId())) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u7981\u7528\u6216\u5173\u95ed\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReportPreparationListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (reportSubmitRangeViewParam.getReportSubmitEnterEnum() == ProcessTypeEnum.TASK && StringUtils.isNotEmpty((CharSequence)(taskNotEnableNames = BgTaskExecuteHelper.isTaskNotEnable(reportSubmitRangeViewParam.getTaskIds())))) {
            formView.showErrorNotification(ResManager.loadResFormat((String)"\u5b50\u4efb\u52a1\u201c%1\u201d\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReportSubmitRangeController_001", (String)"epm-eb-formplugin", (Object[])new Object[]{taskNotEnableNames}));
            return false;
        }
        return true;
    }

    public void orgCommitVisible(IFormView formView, String treeNumber, boolean cancelCommit, boolean resetNodeCheck, TreeNode focusNode) {
        if (formView == null) {
            return;
        }
        formView.setVisible(Boolean.valueOf(!cancelCommit), new String[]{BTN_ORGCOMMIT_CANCEL, BTN_ORGCOMMIT_OK});
        formView.setVisible(Boolean.valueOf(cancelCommit), new String[]{"orgcommit", "orgbatchcommit", "lab_tasktransfer", "expand_all", "shrink_all", "expand_current", "shrink_current"});
        TreeView treeView = (TreeView)formView.getControl(treeNumber);
        if (treeView == null) {
            return;
        }
        treeView.setMulti(!cancelCommit);
        if (resetNodeCheck) {
            treeView.uncheckNodes(treeView.getTreeState().getCheckedNodeIds());
        }
        if (focusNode != null) {
            treeView.checkNode(focusNode);
        }
        this.orgCommitCache(formView, cancelCommit);
    }

    public void orgCommitEnable(IFormView formView, boolean cancelCommit) {
        if (formView == null) {
            return;
        }
        formView.setEnable(Boolean.valueOf(cancelCommit), new String[]{"btn_batchcommit", "btn_batchcancel", "btn_batchapprove", "btn_batchunapprove", "batch_commit", "examinecheck_inlist", "examinereport_inlist", "batchcheck_inlist", "btn_more_l"});
    }

    public void orgCommitCache(IFormView formView, boolean cancelCommit) {
        if (formView == null) {
            return;
        }
        if (cancelCommit) {
            formView.getPageCache().remove("orgCommitCheck");
        } else {
            formView.getPageCache().put("orgCommitCheck", "true");
        }
    }

    public boolean isOrgCommitCheckStatus(IFormView formView) {
        if (formView == null) {
            return false;
        }
        String orgCommitCheck = formView.getPageCache().get("orgCommitCheck");
        return "true".equals(orgCommitCheck);
    }

    public Map<ReportProcess, ReportProcess> getReportProcessMap(Long modelId, Long periodId, Long dataTypeId, Long versionId, Set<Long> entityIdSet, Set<Long> templateIdSet) {
        HashMap<ReportProcess, ReportProcess> reportProcessMap = new HashMap<ReportProcess, ReportProcess>(16);
        Map reportProcessListMap = ReportProcessAggService.getInstance().getReportProcessListMap(modelId, periodId, dataTypeId, versionId, entityIdSet, templateIdSet);
        for (Map.Entry entry : reportProcessListMap.entrySet()) {
            for (ReportProcess reportProcess : (List)entry.getValue()) {
                reportProcessMap.put(reportProcess, reportProcess);
            }
        }
        return reportProcessMap;
    }

    public boolean checkSubmitEntityHasInclude(Set<Long> submitEntityIds, Long entityViewId, IModelCacheHelper modelCacheHelper) {
        for (Long entryOrgId : submitEntityIds) {
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entryOrgId);
            if (member == null) continue;
            List parents = modelCacheHelper.getParents(entityViewId, member, false);
            for (Member parent : parents) {
                if (!submitEntityIds.contains(parent.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

