/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.report.submission.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.approveBill.ApproveBillAutoCreate;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.approveBill.ApproveBillCommon;
import kd.epm.eb.common.approveBill.Entity.ApproveBillCreateInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillRptTemp;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitInfo;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.F7PatternEnum;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.ReportOperationEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.enums.ExamineExecTypeEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.RptSubmitResult;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.approveBill.ApproveBillUtil;
import kd.epm.eb.formplugin.approveBill.CommitCommandUtil;
import kd.epm.eb.formplugin.approveBill.CommitExaminCheck;
import kd.epm.eb.formplugin.approveBill.MetricNotNullCheck;
import kd.epm.eb.formplugin.report.submission.controller.ReportSubmitRangeController;
import kd.epm.eb.formplugin.report.submission.dto.ReportBatchSubmitResponse;
import kd.epm.eb.formplugin.report.submission.enums.ReportSubmitTypeEnum;
import kd.epm.eb.formplugin.report.submission.vo.ReportSubmitRangeViewParam;
import kd.epm.eb.formplugin.reportscheme.helper.ReportPreparationListHelper;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.ListPanelDraw;
import kd.epm.eb.formplugin.task.command.TaskTreePanelDraw;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportSubmitRangePlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(ReportSubmitRangePlugin.class);
    private static final String addRowActionId = "memberselect";
    private static final String ORGENTRYENTITY = "orgentryentity";
    private static final String REPORTENTRYENTITY = "reportentryentity";
    private static final String REPORTCOUNT = "reportcount";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
        this.addClickListeners(new String[]{"switchdept", "btn_cancel", "btn_ok"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ORGENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String orgCommitCheck = (String)this.getFormCustomParam("orgCommitCheck");
        if (StringUtils.isNotEmpty((CharSequence)orgCommitCheck) && "true".equals(orgCommitCheck)) {
            this.getPageCache().put("orgCommitCheck", "true");
        }
        this.fillUserInfo();
        this.fillBaseInfo();
        this.fillLeftEntry();
        this.setVisible();
    }

    private Map<Long, Set<Long>> initReportProcessMap(Set<Long> entityIds) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return result;
        }
        Long modelId = params.getModelId();
        Long schemeId = params.getSchemeId();
        Long entityViewId = params.getEntityViewId();
        Long schemeAssignId = params.getSchemeAssignId();
        Long periodId = params.getPeriodId();
        Long dataTypeId = params.getDataTypeId();
        Long versionId = params.getVersionId();
        if (params.getReportSubmitEnterEnum() == ProcessTypeEnum.REPORT) {
            ReportPreparationListHelper reportPreparationListHelper = new ReportPreparationListHelper();
            Set<Long> templateTreeIdSet = reportPreparationListHelper.getTemplateTreeIdSet(modelId, schemeId);
            return new ReportPreparationListHelper().getCurrentUserReportProcessMap(modelId, params.getPeriodId(), params.getDataTypeId(), params.getVersionId(), ModelCacheContext.getOrCreate((Long)modelId), entityViewId, schemeId, entityIds, templateTreeIdSet, ReportSubmitRangeController.RPTFILTERSTATUS);
        }
        List<Map<String, Object>> taskProcessList = new ListPanelDraw(this.getModelId(), params.getRole(), params.getTaskListId() + "", null, null, null, this.getView(), false).getTaskProcessList(entityIds, 0L);
        Map<ReportProcess, ReportProcess> reportProcessMap = ReportSubmitRangeController.getInstance().getReportProcessMap(modelId, periodId, dataTypeId, versionId, entityIds, null);
        for (Map<String, Object> row : taskProcessList) {
            Long orgid = IDUtils.toLong((Object)row.get("orgid"));
            Long templateId = IDUtils.toLong((Object)row.get("template"));
            Set rptIds = result.computeIfAbsent(orgid, t -> new HashSet(16));
            ReportProcess reportProcess = new ReportProcess(modelId, templateId, orgid, periodId, dataTypeId, versionId);
            ReportProcess reportProcessFromDb = reportProcessMap.get(reportProcess);
            if (reportProcessFromDb == null || !ReportSubmitRangeController.RPTFILTERSTATUS.contains(reportProcessFromDb.getStatus())) continue;
            rptIds.add(reportProcessFromDb.getId());
        }
        return result;
    }

    private void fillLeftEntry() {
        Map<Long, Set<Long>> selectEntityReportProcessMap;
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return;
        }
        ReportSubmitTypeEnum submitType = this.getSubmitType();
        if (submitType == null) {
            return;
        }
        if (submitType == ReportSubmitTypeEnum.batch_org_commit) {
            Set<Long> selectedOrgIds = params.getSelectedOrgIds();
            DynamicObjectCollection result = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedOrgIds)});
            if (CollectionUtils.isEmpty((Collection)result)) {
                return;
            }
            Map<Long, Set<Long>> entityTemplateIdMap = this.initReportProcessMap(selectedOrgIds);
            this.getModel().beginInit();
            int[] createNewEntryRowIndex = this.getModel().batchCreateNewEntryRow(ORGENTRYENTITY, result.size());
            int index = 0;
            int reportcount = 0;
            for (DynamicObject dynamicObject : result) {
                Set<Long> templateIds = entityTemplateIdMap.get(dynamicObject.getLong("id"));
                if (CollectionUtils.isNotEmpty(templateIds)) {
                    reportcount = templateIds.size();
                }
                this.getModel().setValue("submitorgid", (Object)dynamicObject.getLong("id"), createNewEntryRowIndex[index]);
                this.getModel().setValue("submitorgnumber", (Object)dynamicObject.getString("number"), createNewEntryRowIndex[index]);
                this.getModel().setValue("submitorgname", (Object)dynamicObject.getString("name"), createNewEntryRowIndex[index]);
                this.getModel().setValue(REPORTCOUNT, (Object)reportcount, createNewEntryRowIndex[index]);
                ++index;
            }
            this.getModel().endInit();
            this.getView().updateView(ORGENTRYENTITY);
        } else if (submitType == ReportSubmitTypeEnum.batch_report_commit && (selectEntityReportProcessMap = params.getSelectEntityReportProcessMap()) != null && selectEntityReportProcessMap.size() > 0) {
            Set<Long> selectRptOrgIds = selectEntityReportProcessMap.keySet();
            Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"epm_entitymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "in", selectRptOrgIds)});
            this.getModel().beginInit();
            int[] createNewEntryRowIndex = this.getModel().batchCreateNewEntryRow(ORGENTRYENTITY, selectRptOrgIds.size());
            int index = 0;
            for (Map.Entry<Long, Set<Long>> entry : selectEntityReportProcessMap.entrySet()) {
                this.getModel().setValue("submitorgid", (Object)entry.getKey(), createNewEntryRowIndex[index]);
                DynamicObject dynamicObject = (DynamicObject)objectMap.get(entry.getKey());
                if (dynamicObject != null) {
                    this.getModel().setValue("submitorgnumber", (Object)dynamicObject.getString("number"), createNewEntryRowIndex[index]);
                    this.getModel().setValue("submitorgname", (Object)dynamicObject.getString("name"), createNewEntryRowIndex[index]);
                }
                this.getModel().setValue(REPORTCOUNT, (Object)entry.getValue().size(), createNewEntryRowIndex[index]);
                ++index;
            }
            this.getModel().endInit();
            this.getView().updateView(ORGENTRYENTITY);
        }
    }

    private void fillBaseInfo() {
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return;
        }
        this.getModel().setValue("period", (Object)params.getPeriodId());
        this.getModel().setValue("version", (Object)params.getVersionId());
        this.getModel().setValue("datatype", (Object)params.getDataTypeId());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Member periodMember = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, params.getPeriodId());
        Member versionMember = modelCacheHelper.getMember(SysDimensionEnum.Version.getNumber(), null, params.getVersionId());
        Member datatypeMember = modelCacheHelper.getMember(SysDimensionEnum.DataType.getNumber(), null, params.getDataTypeId());
        Label period = (Label)this.getControl("periodname");
        period.setText(periodMember.getName());
        Label version = (Label)this.getControl("versionname");
        version.setText(versionMember.getName());
        Label datatype = (Label)this.getControl("datatypename");
        datatype.setText(datatypeMember.getName());
    }

    private ReportSubmitRangeViewParam getParams() {
        Object params = this.getView().getFormShowParameter().getCustomParam("params");
        if (params == null) {
            return null;
        }
        return (ReportSubmitRangeViewParam)SerializationUtils.deSerializeFromBase64((String)params.toString());
    }

    private void setVisible() {
        this.getView().setEnable(Boolean.valueOf(this.getSubmitType() == ReportSubmitTypeEnum.batch_org_commit), new String[]{"btn_addrow"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_ok": {
                try {
                    this.submitReport(true, true);
                    break;
                }
                catch (Exception e) {
                    if (e instanceof KDBizException) {
                        throw new KDBizException(e.getMessage());
                    }
                    log.error("ReportSubmitRangePlugin" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6279\u91cf\u63d0\u4ea4\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002Trace ID\uff1a%1\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
                }
            }
            case "switchdept": {
                this.selectDept();
                break;
            }
        }
    }

    private Set<String> queryEntityNumberByIds(Set<Long> entityIds) {
        HashSet<String> submitEntityNumbers = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(entityIds)) {
            return submitEntityNumbers;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", entityIds)});
        for (DynamicObject dynamicObject : query) {
            submitEntityNumbers.add(dynamicObject.getString("number"));
        }
        return submitEntityNumbers;
    }

    private void submitReport(boolean needCheckExamine, boolean needCheckPrepared) {
        OperationResult operationResult;
        Serializable submitEntityId;
        boolean canCommit;
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return;
        }
        if (!ReportSubmitRangeController.getInstance().checkSubmitRptEnable(this.getView(), params)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORGENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u63d0\u4ea4\u7684\u7ec4\u7ec7\u3002", (String)"ReportSubmitRangePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> hasNotPermOrgIds = new HashSet<Long>(16);
        Set<Long> userPermEntityIds = this.getUserPermEntityIds();
        if (CollectionUtils.isEmpty(userPermEntityIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u63d0\u4ea4\u7684\u7ec4\u7ec7\u3002", (String)"ReportSubmitRangePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Long, String> orgDescMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            long submitorgid = dynamicObject.getLong("submitorgid");
            if (!userPermEntityIds.contains(submitorgid)) {
                hasNotPermOrgIds.add(submitorgid);
                continue;
            }
            String submitdesc = dynamicObject.getString("submitdesc");
            orgDescMap.put(submitorgid, submitdesc);
        }
        if (CollectionUtils.isNotEmpty(hasNotPermOrgIds)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%1\u201d\u7684\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u63d0\u4ea4\u8303\u56f4\u3002", (String)"ReportSubmitRangePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{hasNotPermOrgIds}));
            return;
        }
        Set<Long> submitEntityIds = orgDescMap.keySet();
        Long modelId = params.getModelId();
        Long bizModelId = params.getBizModelId();
        Long periodId = params.getPeriodId();
        Long dataTypeId = params.getDataTypeId();
        Long versionId = params.getVersionId();
        Long entityViewId = params.getEntityViewId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (ReportSubmitRangeController.getInstance().checkSubmitEntityHasInclude(submitEntityIds, entityViewId, modelCacheHelper)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u53ea\u5141\u8bb8\u9009\u62e9\u6ca1\u6709\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u7684\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u63d0\u4ea4\u8303\u56f4\u3002", (String)"ReportSubmitRangeController_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ProcessTypeEnum processTypeEnum = params.getReportSubmitEnterEnum();
        Long taskProcessId = ProcessTypeEnum.REPORT == processTypeEnum ? params.getSchemeAssignId() : params.getTaskListId();
        Map varValues = ReportVarUtil.getVarValues((Integer)processTypeEnum.getIndex(), (Long)params.getModelId(), (Long)taskProcessId);
        HashMap<Long, Long> processTaskIdMap = new HashMap<Long, Long>(16);
        Map entityRptMap = CommitCommandUtil.initReportProcessListMap(submitEntityIds, ProcessTypeEnum.REPORT == processTypeEnum ? null : processTaskIdMap, this.getParams(), this.getView());
        if (ProcessTypeEnum.TASK == processTypeEnum) {
            HashSet<Long> taskIds = new HashSet<Long>(16);
            for (Map.Entry entry : processTaskIdMap.entrySet()) {
                taskIds.add((Long)entry.getValue());
            }
            String taskNotEnableNames = BgTaskExecuteHelper.isTaskNotEnable(taskIds);
            if (StringUtils.isNotEmpty((CharSequence)taskNotEnableNames)) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5b50\u4efb\u52a1\u201c%1\u201d\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ReportSubmitRangeController_001", (String)"epm-eb-formplugin", (Object[])new Object[]{taskNotEnableNames}));
                return;
            }
            for (Long submitEntityId2 : submitEntityIds) {
                String errInfo = BgTaskDeployListService.getInstance().checkTaskMonitor(modelId, taskIds, ReportOperationEnum.SUBMIT, submitEntityId2, entityViewId);
                if (!StringUtils.isNotEmpty((CharSequence)errInfo)) continue;
                this.getView().showErrorNotification(errInfo);
                return;
            }
        }
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> hasNotCanSubmitRptEntityIds = new HashSet<Long>(16);
        if (ReportSubmitTypeEnum.batch_report_commit == params.getReportSubmitTypeEnum()) {
            needCheckPrepared = false;
        }
        if (needCheckPrepared) {
            boolean bl = ApproveBillUtil.isNoAgainPrompt(this.getModelId(), UserUtils.getUserId());
            boolean isUnWeaveReportConfirm = ControlParamsSettingUtil.getUnWeaveReportConfirm((Long)this.getModelId());
            needCheckPrepared = !bl && isUnWeaveReportConfirm;
        }
        Map<Object, DynamicObject> map = this.queryTemplateMap(null);
        ArrayList<ApproveBillRptTemp> unPreparedList = new ArrayList<ApproveBillRptTemp>(10);
        for (Map.Entry<Long, Set<ReportProcess>> entry : entityRptMap.entrySet()) {
            Set<ReportProcess> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) {
                hasNotCanSubmitRptEntityIds.add(entry.getKey());
                continue;
            }
            for (ReportProcess reportProcess : value) {
                if (needCheckPrepared && BgTaskStateEnum.UNPREPARED.getNumber().equals(reportProcess.getStatus())) {
                    ApproveBillRptTemp approveBillRptTemp = new ApproveBillRptTemp();
                    approveBillRptTemp.setRptId(reportProcess.getId());
                    DynamicObject dynamicObject = map.get(reportProcess.getTemplateId());
                    approveBillRptTemp.setTempName(dynamicObject.getString("name"));
                    approveBillRptTemp.setOrgId(reportProcess.getEntityId());
                    unPreparedList.add(approveBillRptTemp);
                }
                templateIds.add(reportProcess.getTemplateId());
            }
        }
        if (CollectionUtils.isNotEmpty(hasNotCanSubmitRptEntityIds)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", hasNotCanSubmitRptEntityIds)});
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u201c%1\u201d\u6ca1\u6709\u53ef\u63d0\u4ea4\u7684\u62a5\u8868\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", query.stream().map(t -> t.getString("name")).collect(Collectors.toSet()))}));
            return;
        }
        if (CollectionUtils.isNotEmpty(unPreparedList)) {
            CommitCommandUtil.showNotPromptConfirmWithCloseCallBack(unPreparedList, this.getView(), "eb_notprompt_confirm", (IFormPlugin)this, "", "rptPreparedCheckResult", this.getModelId(), entityViewId);
            return;
        }
        ReportBatchSubmitResponse reportSubmitResponse = new ReportBatchSubmitResponse();
        if (!new MetricNotNullCheck().checkMetricNotNull(modelId, processTypeEnum, entityViewId, periodId, dataTypeId, versionId, varValues, taskProcessId, entityRptMap, templateIds, reportSubmitResponse)) {
            if (CollectionUtils.isNotEmpty(reportSubmitResponse.getMetricNotNullCheckReports())) {
                new MetricNotNullCheck().showMetricNotNullCheck(this.getView(), (IFormPlugin)this, reportSubmitResponse.getMetricNotNullCheckReports(), modelId);
            }
            return;
        }
        HashMap<Long, Set> orgMap = new HashMap<Long, Set>(16);
        if (CollectionUtils.isNotEmpty(submitEntityIds)) {
            for (Long entityId : submitEntityIds) {
                Set entityIdSetByRange = (Set)orgMap.get(entityId);
                if (!CollectionUtils.isEmpty((Collection)entityIdSetByRange) || !CollectionUtils.isNotEmpty((Collection)(entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)entityViewId, (Long)entityId, (Integer)RangeEnum.ALL_EXCLUDE.getIndex())))) continue;
                orgMap.put(entityId, entityIdSetByRange);
            }
        }
        if (orgMap != null && !orgMap.isEmpty() && !(canCommit = new CommitCheck().checkCurrentSchemeOrTaskEntityReportCanOperation(modelId, params.getSchemeId(), params.getTaskListId(), processTypeEnum, entityViewId, periodId, dataTypeId, versionId, orgMap, this.getView(), null, true))) {
            return;
        }
        if (needCheckExamine) {
            new CommitExaminCheck().checkExamineIsOk(modelId, processTypeEnum, entityViewId, periodId, dataTypeId, versionId, varValues, taskProcessId, entityRptMap, templateIds, reportSubmitResponse);
            List<ExamineCheckReport> examineCheckReports = reportSubmitResponse.getExamineCheckReports();
            if (!new CommitExaminCheck().handleCheckReport(examineCheckReports, this.getView(), null, (IFormPlugin)this, ExamineExecTypeEnum.Commit)) {
                return;
            }
        }
        Map<Long, String> rptApproveDescFromCache = this.getRptApproveDescFromCache();
        HashSet<String> addBillNos = new HashSet<String>(16);
        Set<String> submitEntityNumbers = this.queryEntityNumberByIds(submitEntityIds);
        Map bailOrgRelationMap = BailOrgService.getInstance().getBailOrgRelationMap(modelId, submitEntityNumbers);
        Long bailOrgId = null;
        String appid = null;
        String formId = null;
        DynamicObject dynamicObjectCompany = (DynamicObject)this.getModel().getValue("company");
        Long departmentId = this.getModel().getValue("department") == null ? 0L : ((DynamicObject)this.getModel().getValue("department")).getLong("id");
        String position = this.getModel().getValue("position") == null ? "" : this.getModel().getValue("position").toString();
        Long creatorOrgId = dynamicObjectCompany == null ? 0L : ((DynamicObject)this.getModel().getValue("company")).getLong("id");
        ApproveBillAutoCreate approveBillAutoCreate = new ApproveBillAutoCreate();
        Map<Long, ApproveBillCreateInfo> approveBillInfos = this.getApproveBillInfo(modelId, periodId, dataTypeId, versionId, submitEntityIds);
        ArrayList<DynamicObject> toSaveApproveBillDynamicObjects = new ArrayList<DynamicObject>(16);
        Long approveBillSourceId = ProcessTypeEnum.REPORT == processTypeEnum ? params.getSchemeId() : params.getTaskListId();
        boolean forbidCommitParent = ControlParamsSettingUtil.forbidCommitParent((Long)modelId);
        HashMap<Serializable, ApproveBillSubMitInfo> entitySubMitInfoMap = new HashMap<Serializable, ApproveBillSubMitInfo>(16);
        HashMap<Serializable, HashSet<String>> entityBillNoMap = new HashMap<Serializable, HashSet<String>>(16);
        HashMap<String, Long> billNoIdMap = new HashMap<String, Long>(16);
        entityRptMap = RejectOnReportService.getInstance().filterEntityRptMap(entityRptMap);
        for (Map.Entry entry : entityRptMap.entrySet()) {
            String string;
            submitEntityId = (Long)entry.getKey();
            Set submitRptList = (Set)entry.getValue();
            LinkedHashSet<Long> submitTemplateIds = new LinkedHashSet<Long>(16);
            Collection<ApproveBillRptTemp> rptTemps = this.createRptTempParams(submitRptList, processTypeEnum, approveBillSourceId, processTaskIdMap, rptApproveDescFromCache, submitTemplateIds);
            BailOrgRelation bailOrgRelation = (BailOrgRelation)bailOrgRelationMap.get(submitEntityId);
            if (bailOrgRelation != null) {
                bailOrgId = bailOrgRelation.getDefaultBailId();
            }
            String orgDesc = (String)orgDescMap.get(submitEntityId);
            ApproveBillSubMitInfo approveBillSubMitInfo = this.createApproveBillParams(modelId, bizModelId, periodId, dataTypeId, versionId, (Long)submitEntityId, entityViewId, orgDesc, bailOrgId, submitTemplateIds, rptTemps, processTypeEnum, creatorOrgId, departmentId, position);
            if (appid == null) {
                appid = ApproveBillCommon.getAppId((ApproveBillSubMitInfo)approveBillSubMitInfo);
            }
            if (formId == null) {
                formId = ApproveBillCommon.getFormId((ApproveBillSubMitInfo)approveBillSubMitInfo);
            }
            if (forbidCommitParent && StringUtils.isNotEmpty((CharSequence)(string = CommitCommandUtil.checkChildrenApproveBill(approveBillSubMitInfo)))) {
                this.getView().showMessage("", string, MessageTypes.Default);
                return;
            }
            HashSet<String> hashSet = new HashSet<String>(16);
            toSaveApproveBillDynamicObjects.addAll(this.createToSaveApproveBillDynamicObjects(approveBillSubMitInfo, approveBillInfos, approveBillAutoCreate, hashSet));
            entityBillNoMap.put(submitEntityId, hashSet);
            entitySubMitInfoMap.put(submitEntityId, approveBillSubMitInfo);
            addBillNos.addAll(hashSet);
        }
        TXHandle tx = TX.requiresNew((String)"submitBillAndUpdateRpt");
        submitEntityId = null;
        try {
            Object[] approveBillIds = approveBillAutoCreate.saveApproveBill(toSaveApproveBillDynamicObjects, addBillNos);
            Set toSubmitBills = null;
            if (approveBillIds != null && approveBillIds.length > 0) {
                toSubmitBills = Arrays.stream(approveBillIds).map(p -> ((DynamicObject)p).getLong("id")).collect(Collectors.toSet());
                for (Object approveBillId : approveBillIds) {
                    billNoIdMap.put(((DynamicObject)approveBillId).getString("billno"), ((DynamicObject)approveBillId).getLong("id"));
                }
            }
            if (CollectionUtils.isEmpty(toSubmitBills)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u521b\u5efa\u5931\u8d25\u3002", (String)"BgDimRangeSelect_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("batchOrgCommit", "true");
                if (rptApproveDescFromCache != null) {
                    operateOption.setVariableValue("descInfo", SerializationUtils.toJsonString(rptApproveDescFromCache));
                }
                operationResult = ApproveBillSubmitHelper.getInstance().submitApproveBillWithShowMessage(this.getView(), appid, formId, modelId, toSubmitBills, operateOption);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                tx.markRollback();
                if (e instanceof KDException) {
                    throw e;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            submitEntityId = e;
            throw e;
        }
        finally {
            if (tx != null) {
                if (submitEntityId != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)submitEntityId).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        if (operationResult != null) {
            RptSubmitResult rptSubmitResult = new RptSubmitResult();
            String submitType = (String)this.getView().getFormShowParameter().getCustomParam("submitType");
            rptSubmitResult.setSubmitType(submitType);
            Set pkIds = operationResult.getSuccessPkIds().stream().map(ConvertUtils::toLong).collect(Collectors.toSet());
            ApproveUtils.getInstance().saveSubmitInfos(pkIds);
            ApproveUtils.getInstance().saveApproveBillAuditType(pkIds);
            Set approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(pkIds);
            ApproveUtils.getInstance().updateRejectBillStatus(pkIds, (Collection)approveReportProcessIds);
            operationResult.setSuccessPkIds(new ArrayList(16));
            rptSubmitResult.setOpResult(SerializationUtils.toJsonString((Object)operationResult));
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : entitySubMitInfoMap.entrySet()) {
                Long entityId = (Long)entry.getKey();
                ApproveBillSubMitInfo subMitInfo = (ApproveBillSubMitInfo)entry.getValue();
                Set strings = (Set)entityBillNoMap.get(entityId);
                ArrayList<Object> billIds = new ArrayList<Object>(16);
                for (String string : strings) {
                    billIds.add(billNoIdMap.get(string));
                }
                String passiveCommit = CommitCommandUtil.checkChildPassiveCommit(subMitInfo, billIds);
                if (!StringUtils.isNotEmpty((CharSequence)passiveCommit)) continue;
                stringBuilder.append(passiveCommit).append("\n");
            }
            if (StringUtils.isNotEmpty((CharSequence)stringBuilder)) {
                rptSubmitResult.setPassiveCommitMsg(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            if (operationResult.isSuccess()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)rptSubmitResult));
                this.getView().close();
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private ApproveBillSubMitInfo createApproveBillParams(Long modelId, Long bizModelId, Long periodId, Long dataTypeId, Long versionId, Long submitEntityId, Long entityViewId, String orgDesc, Long bailOrgId, Set<Long> submitTemplateIds, Collection<ApproveBillRptTemp> rptTemps, ProcessTypeEnum processTypeEnum, Long creatorOrgId, Long departmentId, String position) {
        ApproveBillSubMitInfo approveBillSubMitInfo = new ApproveBillSubMitInfo();
        approveBillSubMitInfo.setRptProcessType(processTypeEnum.getIndex());
        approveBillSubMitInfo.setApproveNote(orgDesc);
        approveBillSubMitInfo.setBailOrgIds(Collections.singleton(bailOrgId));
        approveBillSubMitInfo.setView(false);
        approveBillSubMitInfo.setBtnKey("");
        approveBillSubMitInfo.setCreateOrgId(creatorOrgId);
        approveBillSubMitInfo.setDepartment(departmentId);
        approveBillSubMitInfo.setPosition(position);
        ApproveBillSubMitDim submitDims = new ApproveBillSubMitDim();
        submitDims.setOrgId(submitEntityId);
        submitDims.setViewId(entityViewId);
        submitDims.setModelId(modelId);
        submitDims.setBizModelId(bizModelId);
        submitDims.setCommitType("2");
        submitDims.setVersionId(versionId);
        submitDims.setDataTypeId(dataTypeId);
        submitDims.setYearPeriodId(periodId);
        submitDims.setTempIds(submitTemplateIds);
        approveBillSubMitInfo.setSubmitDims(submitDims);
        approveBillSubMitInfo.setRptTemps(rptTemps);
        return approveBillSubMitInfo;
    }

    private Collection<ApproveBillRptTemp> createRptTempParams(Set<ReportProcess> submitRptList, ProcessTypeEnum processTypeEnum, Long approveBillSourceId, Map<Long, Long> processTaskIdMap, Map<Long, String> rptApproveDescFromCache, Set<Long> submitTemplateIds) {
        ArrayList<ApproveBillRptTemp> result = new ArrayList<ApproveBillRptTemp>(16);
        for (ReportProcess reportProcess : submitRptList) {
            ApproveBillRptTemp approveBillRptTemp = new ApproveBillRptTemp();
            approveBillRptTemp.setRptId(reportProcess.getId());
            approveBillRptTemp.setTempId(reportProcess.getTemplateId());
            approveBillRptTemp.setRptType(processTypeEnum.getNumber());
            approveBillRptTemp.setOrgId(reportProcess.getEntityId());
            approveBillRptTemp.setStatus(reportProcess.getStatus());
            approveBillRptTemp.setTaskListId(approveBillSourceId);
            if (processTaskIdMap != null) {
                approveBillRptTemp.setSubTaskId(processTaskIdMap.get(reportProcess.getId()) == null ? Long.valueOf(0L) : processTaskIdMap.get(reportProcess.getId()));
            }
            if (rptApproveDescFromCache != null) {
                approveBillRptTemp.setApproveDesc(rptApproveDescFromCache.get(reportProcess.getId()) == null ? "" : rptApproveDescFromCache.get(reportProcess.getId()));
            }
            result.add(approveBillRptTemp);
            submitTemplateIds.add(reportProcess.getTemplateId());
        }
        return result;
    }

    private List<DynamicObject> createToSaveApproveBillDynamicObjects(ApproveBillSubMitInfo approveBillSubMitInfo, Map<Long, ApproveBillCreateInfo> approveBillInfos, ApproveBillAutoCreate approveBillAutoCreate, Set<String> addBillNos) {
        return approveBillAutoCreate.getNeedSaveApproveBillList(approveBillSubMitInfo, approveBillInfos, addBillNos);
    }

    private Map<Long, ApproveBillCreateInfo> getApproveBillInfo(Long modelId, Long periodId, Long dataTypeId, Long versionId, Set<Long> submitEntityIds) {
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "=", (Object)periodId);
        qFilter.and("dim_version", "=", (Object)versionId);
        qFilter.and("dim_datatype", "=", (Object)dataTypeId);
        qFilter.and("eborgid", "in", submitEntityIds);
        qFilter.and("centralbilltype", "!=", (Object)CentralBillType.Child.getNumber());
        String fields = "id,billno,billstatus,dim_period,dim_version,dim_datatype,entryentity.tempid as tempid,eborgid,approvetype,approvetypeversion";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])qFilter.toArray());
        HashMap<Long, ApproveBillCreateInfo> tempBillMap = new HashMap<Long, ApproveBillCreateInfo>(16);
        for (DynamicObject approveBill : approveBills) {
            long billId = approveBill.getLong("id");
            ApproveBillCreateInfo approveBillCreateInfo = (ApproveBillCreateInfo)tempBillMap.get(billId);
            if (approveBillCreateInfo == null) {
                approveBillCreateInfo = new ApproveBillCreateInfo();
                approveBillCreateInfo.setId(Long.valueOf(billId));
                approveBillCreateInfo.setBillNo(approveBill.getString("billno"));
                approveBillCreateInfo.setBillStatus(approveBill.getString("billstatus"));
                approveBillCreateInfo.setTemplates(new HashSet(16));
                approveBillCreateInfo.setApproveType(Long.valueOf(approveBill.getLong("approvetype")));
                approveBillCreateInfo.setApproveTypeVersion(Long.valueOf(approveBill.getLong("approvetypeversion")));
                tempBillMap.put(billId, approveBillCreateInfo);
            }
            Set templateIds = approveBillCreateInfo.getTemplates();
            templateIds.add(approveBill.getLong("tempid"));
        }
        return tempBillMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("approvedesc".equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object newValue = e.getChangeSet()[0].getNewValue();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(REPORTENTRYENTITY, rowIndex);
            if (entryRowEntity != null) {
                long reportprocessid = entryRowEntity.getLong("reportprocessid");
                this.cacheRptApproveDesc(reportprocessid, newValue == null ? "" : newValue.toString());
            }
        }
    }

    private void cacheRptApproveDesc(Long rptId, String desc) {
        Map<Long, String> rptApproveDescMap = this.getRptApproveDescFromCache();
        rptApproveDescMap.put(rptId, desc);
        this.getPageCache().put("rptApproveDescStr", SerializationUtils.serializeToBase64(rptApproveDescMap));
    }

    private Map<Long, String> getRptApproveDescFromCache() {
        Map<Long, String> rptApproveDescMap = new HashMap<Long, String>(16);
        String rptApproveDescStr = this.getPageCache().get("rptApproveDescStr");
        if (StringUtils.isNotEmpty((CharSequence)rptApproveDescStr)) {
            rptApproveDescMap = (Map)SerializationUtils.deSerializeFromBase64((String)rptApproveDescStr);
        }
        return rptApproveDescMap;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addrow": {
                this.addRowF7();
                break;
            }
        }
    }

    private Set<Long> getUserPermEntityIds() {
        TaskTreePanelDraw taskTreePanelDraw;
        List<Map<String, Object>> rst;
        HashSet<Long> result = new HashSet<Long>(16);
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return result;
        }
        if (params.getReportSubmitEnterEnum() == ProcessTypeEnum.REPORT) {
            return new ReportPreparationListHelper().getEntityTreeIdSet(params.getModelId(), params.getSchemeId(), params.getBizModelId(), params.getEntityViewId());
        }
        if (params.getReportSubmitEnterEnum() == ProcessTypeEnum.TASK && CollectionUtils.isNotEmpty(rst = (taskTreePanelDraw = new TaskTreePanelDraw(this.getModelId(), params.getRole(), null, this.getView())).getTaskProcessMapList(null, null, params.getPeriodId(), params.getDataTypeId(), params.getVersionId()))) {
            for (Map<String, Object> row : rst) {
                Long _orgId = (Long)row.get("orgid");
                result.add(_orgId);
            }
        }
        return result;
    }

    private void addRowF7() {
        QFilter qFilter;
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return;
        }
        Set<Long> entityTreeIdSet = this.getUserPermEntityIds();
        if (CollectionUtils.isEmpty(entityTreeIdSet)) {
            return;
        }
        RangeF7Param param = new RangeF7Param();
        param.setCanSelectBudgetPeriodRoot(false);
        param.setEnableView(false);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject view = BusinessDataServiceHelper.loadSingleFromCache((Object)params.getEntityViewId(), (String)"eb_dimensionview", (String)"id,number,name,source,usage,version,viewgroup.id");
        if (view != null) {
            qFilter = new QFilter("view", "=", (Object)params.getEntityViewId());
            qFilter.and("memberid", "in", entityTreeIdSet);
        } else {
            qFilter = new QFilter("id", "in", entityTreeIdSet);
        }
        qFilters.add(qFilter);
        param.setqFilters(qFilters);
        param.setOpenProperty(false);
        FormShowParameter formShowParameter = new FormShowParameter();
        param.setShowParameter(formShowParameter);
        param.setPattern(F7PatternEnum.NORMAL);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, addRowActionId));
        ArrayList<String> useRange = new ArrayList<String>();
        useRange.add(RangeEnum.ONLY.getIndex() + "");
        param.setUserRange(useRange);
        param.setShowDisableVisible(false);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORGENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(16);
            for (DynamicObject dynamicObject : entryEntity) {
                if (dynamicObject == null || StringUtils.isEmpty((CharSequence)dynamicObject.getString("submitorgnumber"))) continue;
                members.add(new MemberCondition(dynamicObject.getString("submitorgnumber"), dynamicObject.getString("submitorgname"), null, RangeEnum.ONLY.getIndex() + ""));
            }
            param.setCon_list(members);
        }
        CustomF7utils.openCustomF7Range((Long)params.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), (Long)params.getEntityViewId(), (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    @Override
    public Long getModelId() {
        ReportSubmitRangeViewParam params = this.getParams();
        if (params == null) {
            return 0L;
        }
        return params.getModelId();
    }

    private void fillUserInfo() {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("applier", (Object)UserUtils.getUserId());
        BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (boolean)true);
        DynamicObject object = (DynamicObject)dataModel.getValue("applier");
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbAdjustBillEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("appliertag");
        label.setText(object.getString("name"));
        label = (Label)this.getControl("userphone");
        label.setText(object.getString("phone"));
        Image pic = (Image)this.getControl("userpic");
        Long userId = object.getLong("id");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
        pic.setUrl((String)userPics.get(userId));
        DynamicObject dynamicObjectCompany = (DynamicObject)dataModel.getValue("company");
        if (dynamicObjectCompany != null && (label = (Label)this.getControl("companytag")) != null) {
            label.setText(dynamicObjectCompany.getString("name"));
        } else if (dynamicObjectCompany == null && (label = (Label)this.getControl("companytag")) != null) {
            label.setText("");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (addRowActionId.equals(actionId)) {
            DynamicObjectCollection backMemb = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (backMemb == null || CollectionUtils.isEmpty((Collection)backMemb)) {
                return;
            }
            if (backMemb.size() > 5000) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u591a\u4ec5\u652f\u6301\u9009\u62e9%1\u6761\u8bb0\u5f55\u3002", (String)"BgFloatSettingPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{"5000"}));
                return;
            }
            if (backMemb.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u63d0\u4ea4\u8d85\u8fc7100\u4e2a\u7ec4\u7ec7\u7684\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u63d0\u4ea4\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORGENTRYENTITY);
            HashSet<String> existOrgNumbers = new HashSet<String>(16);
            for (DynamicObject dynamicObject : entryEntity) {
                existOrgNumbers.add(dynamicObject.getString("submitorgnumber"));
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(ORGENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            this.getModel().beginInit();
            int[] createNewEntryRow = this.getModel().batchCreateNewEntryRow(ORGENTRYENTITY, backMemb.size());
            int index = 0;
            HashMap<Long, Integer> selectedOrgIdMap = new HashMap<Long, Integer>(16);
            for (DynamicObject member : backMemb) {
                if (existOrgNumbers.contains(member.getString("number"))) {
                    this.getModel().deleteEntryRow(ORGENTRYENTITY, createNewEntryRow[index]);
                    continue;
                }
                selectedOrgIdMap.put(member.getLong("id"), createNewEntryRow[index]);
                this.getModel().setValue("submitorgid", (Object)member.getLong("id"), createNewEntryRow[index]);
                this.getModel().setValue("submitorgnumber", (Object)member.getString("number"), createNewEntryRow[index]);
                this.getModel().setValue("submitorgname", (Object)member.getString("name"), createNewEntryRow[index]);
                ++index;
            }
            Map<Long, Set<Long>> entityTemplateIdMap = this.initReportProcessMap(selectedOrgIdMap.keySet());
            for (Map.Entry entry : selectedOrgIdMap.entrySet()) {
                int count = 0;
                Set<Long> templateIds = entityTemplateIdMap.get(entry.getKey());
                if (CollectionUtils.isNotEmpty(templateIds)) {
                    count = templateIds.size();
                }
                this.getModel().setValue(REPORTCOUNT, (Object)count, ((Integer)entry.getValue()).intValue());
            }
            this.getModel().endInit();
            this.getView().updateView(ORGENTRYENTITY);
            if (selectRows != null && selectRows.length > 0) {
                entryGrid.selectRows(selectRows, selectRows[0]);
            }
        } else if ("switchdept".equals(actionId)) {
            String data = (String)closedCallBackEvent.getReturnData();
            if (data != null) {
                IDataModel dataModel = this.getModel();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (Map)dataMap);
            }
        } else if ("examineCheckResult".equals(actionId)) {
            String returnData2 = (String)closedCallBackEvent.getReturnData();
            if (!"success".equals(returnData2)) {
                return;
            }
            this.submitReport(false, false);
        } else if ("rptPreparedCheckResult".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            Map returnDataMap = (Map)returnData;
            ApproveBillUtil.saveUserSelNotPrompt(returnDataMap, this.getModelId(), this.getUserId());
            String result = (String)returnDataMap.get("result");
            if ("true".equals(result)) {
                this.submitReport(true, false);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.fillRightEntry();
    }

    private Set<Long> getSelectOrgIds() {
        int[] selectRows;
        HashSet<Long> selectOrgIds = new HashSet<Long>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ORGENTRYENTITY);
        for (int selectRow : selectRows = entryGrid.getSelectRows()) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ORGENTRYENTITY, selectRow);
            long submitorgid = entryRowEntity.getLong("submitorgid");
            selectOrgIds.add(submitorgid);
        }
        return selectOrgIds;
    }

    private Map<Object, DynamicObject> queryTemplateMap(Set<Long> selectTemplateIds) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (CollectionUtils.isNotEmpty(selectTemplateIds)) {
            qFilter = new QFilter("id", "in", selectTemplateIds);
        }
        return BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity", (String)"id, name, number, templatetype,", (QFilter[])new QFilter[]{qFilter});
    }

    private Map<Object, DynamicObject> queryEntityMap(Set<Long> selectOrgIds) {
        QFilter qFilter = new QFilter("model", "in", (Object)this.getModelId());
        if (CollectionUtils.isNotEmpty(selectOrgIds)) {
            qFilter = new QFilter("id", "in", selectOrgIds);
        }
        return BusinessDataServiceHelper.loadFromCache((String)"epm_entitymembertree", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
    }

    private void fillRightEntry() {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(REPORTENTRYENTITY);
        this.getModel().endInit();
        this.getView().updateView(REPORTENTRYENTITY);
        ReportSubmitTypeEnum submitType = this.getSubmitType();
        if (submitType == null) {
            return;
        }
        Set<Long> selectOrgIds = this.getSelectOrgIds();
        if (CollectionUtils.isEmpty(selectOrgIds)) {
            return;
        }
        Map<Object, DynamicObject> templateMap = this.queryTemplateMap(null);
        Map<Object, DynamicObject> orgMap = this.queryEntityMap(selectOrgIds);
        Map<Long, String> rptApproveDescFromCache = this.getRptApproveDescFromCache();
        int rptCount = 0;
        Map<Long, Set<ReportProcess>> entityReportProcessMap = CommitCommandUtil.initReportProcessListMap(selectOrgIds, null, this.getParams(), this.getView());
        for (Map.Entry<Long, Set<ReportProcess>> entry : entityReportProcessMap.entrySet()) {
            rptCount += entry.getValue().size();
        }
        if (rptCount == 0) {
            return;
        }
        this.getModel().beginInit();
        int[] createNewEntryRow = this.getModel().batchCreateNewEntryRow(REPORTENTRYENTITY, rptCount);
        int index = 0;
        for (Long selectOrgId : selectOrgIds) {
            Set<ReportProcess> reportProcesses = entityReportProcessMap.get(selectOrgId);
            if (CollectionUtils.isEmpty(reportProcesses)) continue;
            for (ReportProcess reportProcess : reportProcesses) {
                String approveDesc = rptApproveDescFromCache.get(reportProcess.getId());
                DynamicObject templateDynamicObject = templateMap.get(reportProcess.getTemplateId());
                DynamicObject orgDynamicObject = orgMap.get(reportProcess.getEntityId());
                this.renderReportEntryRow(createNewEntryRow[index], reportProcess.getId(), reportProcess.getStatus(), approveDesc, templateDynamicObject, orgDynamicObject);
                ++index;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(REPORTENTRYENTITY);
    }

    private void renderReportEntryRow(Integer rowIndex, Long reportProcessId, String reportStatus, String approveDesc, DynamicObject templateDynamicObject, DynamicObject orgDynamicObject) {
        if (templateDynamicObject != null) {
            this.getModel().setValue("templatetype", (Object)templateDynamicObject.getString("templatetype"), rowIndex.intValue());
            this.getModel().setValue("reportname", (Object)templateDynamicObject.getString("name"), rowIndex.intValue());
            this.getModel().setValue("reportnumber", (Object)templateDynamicObject.getString("number"), rowIndex.intValue());
            this.getModel().setValue("templateid", (Object)templateDynamicObject.getLong("id"), rowIndex.intValue());
        }
        if (orgDynamicObject != null) {
            this.getModel().setValue("reportorgname", (Object)orgDynamicObject.getString("name"), rowIndex.intValue());
        }
        this.getModel().setValue("reportprocessid", (Object)reportProcessId, rowIndex.intValue());
        this.getModel().setValue("reportstatus", (Object)reportStatus, rowIndex.intValue());
        this.getModel().setValue("approvedesc", (Object)approveDesc, rowIndex.intValue());
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (REPORTCOUNT.equals(fieldName)) {
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            splitContainer.setCollapse("splitpanelap1", false);
        }
    }

    public ReportSubmitTypeEnum getSubmitType() {
        ReportSubmitRangeViewParam params = this.getParams();
        if (params != null) {
            return params.getReportSubmitTypeEnum();
        }
        return null;
    }

    private void selectDept() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_userdeptlist");
        Object user = this.getModel().getValue("applier");
        Object dept = this.getModel().getValue("department");
        String position = (String)this.getModel().getValue("position");
        if (user instanceof DynamicObject) {
            formShowParameter.setCustomParam("user", (Object)((DynamicObject)user).getString("id"));
            if (dept instanceof DynamicObject) {
                formShowParameter.setCustomParam("dept.id", (Object)((DynamicObject)dept).getString("id"));
                if (position != null) {
                    formShowParameter.setCustomParam("position", (Object)position);
                }
            }
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "switchdept"));
        this.getView().showForm(formShowParameter);
    }
}

