/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class CustomConfirmPlugin
extends AbstractFormPlugin {
    private static final String BTN_MORE = "btnmore";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_SKIP = "btn_skip";
    private static final String BTN_CONTINUE = "btn_continue";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_MORE, BTN_CLOSE, BTN_OK, BTN_SKIP, BTN_CONTINUE});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label label = (Label)this.getControl("ftitle");
        label.setText((String)parameter.getCustomParam("title"));
        Object errObj = parameter.getCustomParam("errorMsg");
        Object moda = parameter.getCustomParam("moda");
        if (moda != null) {
            if (moda.equals("select")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SKIP, BTN_CONTINUE});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SKIP, BTN_CONTINUE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_OK});
        }
        if (errObj != null) {
            StringBuilder val = new StringBuilder();
            if (errObj instanceof List) {
                List list = (List)errObj;
                Iterator var7 = list.iterator();
                int index = 1;
                while (var7.hasNext()) {
                    String text = (String)var7.next();
                    val.append(index).append(".").append(text).append(System.lineSeparator());
                    ++index;
                }
            } else {
                String errStr = (String)errObj;
                val.append(this.extractMesage(errStr));
            }
            this.getModel().setValue("content", (Object)val.toString());
            if (Boolean.TRUE != parameter.getCustomParam("hasMore")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_MORE});
            }
            Label subtitle = (Label)this.getControl("fsubtitle");
            String message = (String)parameter.getCustomParam("message");
            if (StringUtils.isBlank((CharSequence)message)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"fsubtitle"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"fsubtitle"});
                subtitle.setText(message);
            }
        }
    }

    private String extractMesage(String errStr) {
        int index = errStr.indexOf(62);
        if (index == 0) {
            return errStr;
        }
        String[] lines = StringUtils.substring((String)errStr, (int)(errStr.indexOf(62) + 1)).split("<br/>");
        StringBuilder val = new StringBuilder();
        val.append(lines[0]);
        for (int i = 1; i < lines.length - 1; ++i) {
            val.append(System.lineSeparator());
            val.append(lines[i]);
        }
        return val.toString();
    }

    public void click(EventObject evt) {
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (BTN_MORE.equals(key)) {
            FormShowParameter param = this.getView().getFormShowParameter();
            IFormView view = this.getView();
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("eb_showoperationresult");
            parameter.setCustomParam("pkNumbers", param.getCustomParam("pkNumbers"));
            parameter.setCustomParam("operateName", param.getCustomParam("operateName"));
            parameter.setCustomParam("errorTitle", param.getCustomParam("errorTitle"));
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            IPageCache pageCache = parentView.getPageCache();
            this.getPageCache().put("operationresult", pageCache.get("operationresult"));
            view.showForm(parameter);
        } else if (BTN_OK.equals(key)) {
            this.getView().returnDataToParent((Object)"ok");
            this.getView().close();
        } else if (BTN_SKIP.equals(key)) {
            this.getView().returnDataToParent((Object)"skip");
            this.getView().close();
        } else if (BTN_CONTINUE.equals(key)) {
            this.getView().returnDataToParent((Object)"continue");
            this.getView().close();
        }
    }
}

